/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/src/diagnostics/symbols", ["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    /**
     * An enumeration of basic types.
     *
     * @publicApi
     */
    var BuiltinType;
    (function (BuiltinType) {
        /**
         * The type is a type that can hold any other type.
         */
        BuiltinType[BuiltinType["Any"] = 0] = "Any";
        /**
         * The type of a string literal.
         */
        BuiltinType[BuiltinType["String"] = 1] = "String";
        /**
         * The type of a numeric literal.
         */
        BuiltinType[BuiltinType["Number"] = 2] = "Number";
        /**
         * The type of the `true` and `false` literals.
         */
        BuiltinType[BuiltinType["Boolean"] = 3] = "Boolean";
        /**
         * The type of the `undefined` literal.
         */
        BuiltinType[BuiltinType["Undefined"] = 4] = "Undefined";
        /**
         * the type of the `null` literal.
         */
        BuiltinType[BuiltinType["Null"] = 5] = "Null";
        /**
         * the type is an unbound type parameter.
         */
        BuiltinType[BuiltinType["Unbound"] = 6] = "Unbound";
        /**
         * Not a built-in type.
         */
        BuiltinType[BuiltinType["Other"] = 7] = "Other";
    })(BuiltinType = exports.BuiltinType || (exports.BuiltinType = {}));
});
//# sourceMappingURL=data:application/json;base64,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