## API Report File for "json-schema-typed"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

// @public
export interface JSONSchema {
    $comment?: string;
    // Warning: (tsdoc-escape-greater-than) The ">" character should be escaped using a backslash to avoid confusion with an HTML tag
    // Warning: (tsdoc-escape-greater-than) The ">" character should be escaped using a backslash to avoid confusion with an HTML tag
    // Warning: (tsdoc-malformed-html-name) Invalid HTML element: Expecting an HTML name
    // Warning: (tsdoc-malformed-html-name) Invalid HTML element: Expecting an HTML name
    $id?: string;
    $ref?: string;
    $schema?: string;
    additionalItems?: JSONSchema | boolean;
    additionalProperties?: JSONSchema | boolean;
    allOf?: (JSONSchema | boolean)[];
    anyOf?: (JSONSchema | boolean)[];
    const?: any;
    contains?: JSONSchema | boolean;
    contentEncoding?: JSONSchemaContentEncodingName | JSONSchemaContentEncoding;
    contentMediaType?: string;
    default?: any;
    definitions?: {
        [key: string]: JSONSchema | boolean;
    };
    dependencies?: {
        [key: string]: JSONSchema | boolean | string[];
    } | string[];
    description?: string;
    else?: JSONSchema | boolean;
    enum?: any[];
    examples?: any[];
    exclusiveMaximum?: number;
    exclusiveMinimum?: number;
    format?: JSONSchemaFormat | 'date' | 'date-time' | 'email' | 'full-date' | 'full-time' | 'hostname' | 'idn-email' | 'idn-hostname' | 'ipv4' | 'ipv6' | 'iri' | 'iri-reference' | 'json-pointer' | 'json-pointer-uri-fragment' | 'regex' | 'relative-json-pointer' | 'time' | 'uri' | 'uri-reference' | 'uri-template' | 'uuid';
    if?: JSONSchema | boolean;
    items?: JSONSchema | boolean | (JSONSchema | boolean)[];
    maximum?: number;
    maxItems?: number;
    maxLength?: number;
    maxProperties?: number;
    minimum?: number;
    minItems?: number;
    minLength?: number;
    minProperties?: number;
    multipleOf?: number;
    not?: JSONSchema | boolean;
    oneOf?: JSONSchema | boolean[];
    pattern?: string;
    patternProperties?: {
        [key: string]: JSONSchema | boolean;
    };
    properties?: {
        [key: string]: JSONSchema | boolean;
    };
    propertyNames?: JSONSchema | boolean;
    // Warning: (tsdoc-undefined-tag) The TSDoc tag "@default" is not defined in this configuration
    readOnly?: boolean;
    // Warning: (tsdoc-undefined-tag) The TSDoc tag "@default" is not defined in this configuration
    required?: string[];
    then?: JSONSchema | boolean;
    title?: string;
    type?: JSONSchemaType | JSONSchemaTypeName | (JSONSchemaType | JSONSchemaTypeName)[];
    // Warning: (tsdoc-undefined-tag) The TSDoc tag "@default" is not defined in this configuration
    uniqueItems?: boolean;
    // Warning: (tsdoc-undefined-tag) The TSDoc tag "@default" is not defined in this configuration
    writeOnly?: boolean;
}

// @public
export enum JSONSchemaContentEncoding {
    '7bit' = "7bit",
    '8bit' = "8bit",
    Base64 = "base64",
    Binary = "binary",
    IETFToken = "ietf-token",
    QuotedPrintable = "quoted-printable",
    XToken = "x-token"
}

// @public
export type JSONSchemaContentEncodingName = '7bit' | '8bit' | 'binary' | 'quoted-printable' | 'base64' | 'ietf-token' | 'x-token';

// @public
export enum JSONSchemaFormat {
    Date = "date",
    DateTime = "date-time",
    Email = "email",
    Hostname = "hostname",
    IDNEmail = "idn-email",
    IDNHostname = "idn-hostname",
    IPv4 = "ipv4",
    IPv6 = "ipv6",
    IRI = "iri",
    IRIReference = "iri-reference",
    JSONPointer = "json-pointer",
    JSONPointerURIFragment = "json-pointer-uri-fragment",
    RegEx = "regex",
    RelativeJSONPointer = "relative-json-pointer",
    Time = "time",
    URI = "uri",
    URIReference = "uri-reference",
    URITemplate = "uri-template",
    UUID = "uuid"
}

// @public
export const JSONSchemaKeys: (keyof JSONSchema)[];

// @public
export enum JSONSchemaType {
    Array = "array",
    Boolean = "boolean",
    Integer = "integer",
    Null = "null",
    Number = "number",
    Object = "object",
    String = "string"
}

// @public
export type JSONSchemaTypeName = 'array' | 'boolean' | 'integer' | 'null' | 'number' | 'object' | 'string';

// @public
export type JSONSchemaTypeValue = JSONSchemaTypeName | JSONSchemaType | (JSONSchemaType | JSONSchemaTypeName)[];


// (No @packageDocumentation comment for this package)

```
