"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAppCacheDir = getAppCacheDir;

var path = _interopRequireWildcard(require("path"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function getAppCacheDir() {
  const homedir = require("os").homedir(); // https://github.com/electron/electron/issues/1404#issuecomment-194391247


  let result;

  if (process.platform === "win32") {
    result = process.env.LOCALAPPDATA || path.join(homedir, "AppData", "Local");
  } else if (process.platform === "darwin") {
    result = path.join(homedir, "Library", "Application Support", "Caches");
  } else {
    result = process.env.XDG_CACHE_HOME || path.join(homedir, ".cache");
  }

  return result;
} 
// __ts-babel@6.0.4
//# sourceMappingURL=AppAdapter.js.map