/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject.dagger;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.VisitorState;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.Arrays;
import java.util.EnumSet;
import javax.lang.model.element.Modifier;

final class Util {
    static final Matcher<Tree> ANNOTATED_WITH_PRODUCES_OR_PROVIDES = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.hasAnnotation((String)"dagger.Provides"), Matchers.hasAnnotation((String)"dagger.producers.Produces")});
    static final Matcher<Tree> ANNOTATED_WITH_MULTIBINDING_ANNOTATION = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.hasAnnotation((String)"dagger.multibindings.IntoSet"), Matchers.hasAnnotation((String)"dagger.multibindings.ElementsIntoSet"), Matchers.hasAnnotation((String)"dagger.multibindings.IntoMap")});
    static final Matcher<Tree> IS_DAGGER_2_MODULE = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.allOf((Matcher[])new Matcher[]{Matchers.isType((String)"dagger.Module"), Matchers.not(Util.hasAnyParameter("injects", "staticInjections", "overrides", "addsTo", "complete", "library"))}), Matchers.isType((String)"dagger.producers.ProducerModule")}));
    private static final Matcher<ClassTree> CLASS_EXTENDS_NOTHING = new Matcher<ClassTree>(){

        public boolean matches(ClassTree t, VisitorState state) {
            return t.getExtendsClause() == null;
        }
    };
    static final Matcher<ClassTree> CAN_HAVE_ABSTRACT_BINDING_METHODS = Matchers.allOf((Matcher[])new Matcher[]{IS_DAGGER_2_MODULE, Matchers.anyOf((Matcher[])new Matcher[]{Matchers.kindIs((Tree.Kind)Tree.Kind.INTERFACE), CLASS_EXTENDS_NOTHING}), Matchers.not((Matcher)Matchers.hasMethod((Matcher)Matchers.allOf((Matcher[])new Matcher[]{ANNOTATED_WITH_PRODUCES_OR_PROVIDES, Matchers.not((Matcher)Matchers.hasModifier((Modifier)Modifier.STATIC))})))});
    private static final MultiMatcher<ClassTree, MethodTree> HAS_GENERATED_CONSTRUCTOR = Matchers.constructor((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)new Matcher<MethodTree>(){

        public boolean matches(MethodTree t, VisitorState state) {
            return ASTHelpers.isGeneratedConstructor((MethodTree)t);
        }
    });

    private Util() {
    }

    private static Matcher<AnnotationTree> hasAnyParameter(String ... parameters) {
        return Matchers.anyOf((Iterable)Iterables.transform(Arrays.asList(parameters), (Function)new Function<String, Matcher<AnnotationTree>>(){

            public Matcher<AnnotationTree> apply(String parameter) {
                return Matchers.hasArgumentWithValue((String)parameter, (Matcher)Matchers.anything());
            }
        }));
    }

    static Optional<AnnotationTree> findAnnotation(String annotationName, ClassTree classTree) {
        for (AnnotationTree annotationTree : classTree.getModifiers().getAnnotations()) {
            Symbol.ClassSymbol annotationClass = (Symbol.ClassSymbol)ASTHelpers.getSymbol((Tree)annotationTree.getAnnotationType());
            if (!annotationClass.fullname.contentEquals(annotationName)) continue;
            return Optional.of((Object)annotationTree);
        }
        return Optional.absent();
    }

    static SuggestedFix.Builder makeConcreteClassAbstract(ClassTree classTree, VisitorState state) {
        boolean wasAbstract;
        EnumSet<Modifier> flags = EnumSet.noneOf(Modifier.class);
        flags.addAll(classTree.getModifiers().getFlags());
        boolean wasFinal = flags.remove((Object)Modifier.FINAL);
        boolean bl = wasAbstract = !flags.add(Modifier.ABSTRACT);
        if (classTree.getKind().equals((Object)Tree.Kind.INTERFACE) || !wasFinal && wasAbstract) {
            return SuggestedFix.builder();
        }
        ImmutableList.Builder modifiers = ImmutableList.builder();
        for (AnnotationTree annotationTree : classTree.getModifiers().getAnnotations()) {
            modifiers.add((Object)state.getSourceForNode((Tree)annotationTree));
        }
        modifiers.addAll(flags);
        SuggestedFix.Builder makeAbstract = SuggestedFix.builder();
        if (((JCTree.JCModifiers)classTree.getModifiers()).pos == -1) {
            makeAbstract.prefixWith((Tree)classTree, Joiner.on((char)' ').join((Iterable)modifiers.build()));
        } else {
            makeAbstract.replace((Tree)classTree.getModifiers(), Joiner.on((char)' ').join((Iterable)modifiers.build()));
        }
        if (wasFinal && HAS_GENERATED_CONSTRUCTOR.matches((Tree)classTree, state)) {
            makeAbstract.merge(Util.addPrivateConstructor(classTree));
        }
        return makeAbstract;
    }

    private static SuggestedFix.Builder addPrivateConstructor(ClassTree classTree) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String indent = "  ";
        for (Tree tree : classTree.getMembers()) {
            if (tree.getKind().equals((Object)Tree.Kind.METHOD) && !ASTHelpers.isGeneratedConstructor((MethodTree)((MethodTree)tree))) {
                fix.prefixWith(tree, indent + "private " + classTree.getSimpleName() + "() {} // no instances\n" + indent);
                break;
            }
            if (tree.getKind().equals((Object)Tree.Kind.METHOD)) continue;
            indent = "";
        }
        return fix;
    }
}

