(function() {
  var Grim, asyncifyJasmineFn, buildReporter, buildTerminalReporter, disableFocusMethods, fs, ipcRenderer, path, requireSpecs, setSpecDirectory, setSpecField, setSpecType, temp, waitsForPromise,
    slice = [].slice;

  Grim = require('grim');

  fs = require('fs-plus');

  temp = require('temp');

  path = require('path');

  ipcRenderer = require('electron').ipcRenderer;

  temp.track();

  module.exports = function(arg) {
    var ApplicationDelegate, JasmineJUnitReporter, TimeReporter, applicationDelegate, atomHome, buildAtomEnvironment, documentTitle, fileBase, headless, i, j, jasmineContent, jasmineEnv, key, len, len1, loadablePack, logFile, outputDir, packName, promise, ref, resolveWithExitCode, testPackages, testPath, testPaths, userHome, userPack, value;
    logFile = arg.logFile, headless = arg.headless, testPaths = arg.testPaths, buildAtomEnvironment = arg.buildAtomEnvironment;
    ref = require('../vendor/jasmine');
    for (key in ref) {
      value = ref[key];
      window[key] = value;
    }
    require('jasmine-tagged');
    global.it = asyncifyJasmineFn(global.it, 1);
    global.fit = asyncifyJasmineFn(global.fit, 1);
    global.ffit = asyncifyJasmineFn(global.ffit, 1);
    global.fffit = asyncifyJasmineFn(global.fffit, 1);
    global.beforeEach = asyncifyJasmineFn(global.beforeEach, 0);
    global.afterEach = asyncifyJasmineFn(global.afterEach, 0);
    documentTitle = null;
    Object.defineProperty(document, 'title', {
      get: function() {
        return documentTitle;
      },
      set: function(title) {
        return documentTitle = title;
      }
    });
    userHome = process.env.ATOM_HOME || path.join(fs.getHomeDirectory(), '.atom');
    atomHome = temp.mkdirSync({
      prefix: 'atom-test-home-'
    });
    if (process.env.APM_TEST_PACKAGES) {
      testPackages = process.env.APM_TEST_PACKAGES.split(/\s+/);
      fs.makeTreeSync(path.join(atomHome, 'packages'));
      for (i = 0, len = testPackages.length; i < len; i++) {
        packName = testPackages[i];
        userPack = path.join(userHome, 'packages', packName);
        loadablePack = path.join(atomHome, 'packages', packName);
        try {
          fs.symlinkSync(userPack, loadablePack, 'dir');
        } catch (error1) {
          fs.copySync(userPack, loadablePack);
        }
      }
    }
    ApplicationDelegate = require('../src/application-delegate');
    applicationDelegate = new ApplicationDelegate();
    applicationDelegate.setRepresentedFilename = function() {};
    applicationDelegate.setWindowDocumentEdited = function() {};
    window.atom = buildAtomEnvironment({
      applicationDelegate: applicationDelegate,
      window: window,
      document: document,
      configDirPath: atomHome,
      enablePersistence: false
    });
    require('./spec-helper');
    if (process.env.JANKY_SHA1 || process.env.CI) {
      disableFocusMethods();
    }
    for (j = 0, len1 = testPaths.length; j < len1; j++) {
      testPath = testPaths[j];
      requireSpecs(testPath);
    }
    setSpecType('user');
    resolveWithExitCode = null;
    promise = new Promise(function(resolve, reject) {
      return resolveWithExitCode = resolve;
    });
    jasmineEnv = jasmine.getEnv();
    jasmineEnv.addReporter(buildReporter({
      logFile: logFile,
      headless: headless,
      resolveWithExitCode: resolveWithExitCode
    }));
    TimeReporter = require('./time-reporter');
    jasmineEnv.addReporter(new TimeReporter());
    if (process.env.TEST_JUNIT_XML_PATH) {
      JasmineJUnitReporter = require('./jasmine-junit-reporter').JasmineJUnitReporter;
      process.stdout.write("Outputting JUnit XML to <" + process.env.TEST_JUNIT_XML_PATH + ">\n");
      outputDir = path.dirname(process.env.TEST_JUNIT_XML_PATH);
      fileBase = path.basename(process.env.TEST_JUNIT_XML_PATH, '.xml');
      jasmineEnv.addReporter(new JasmineJUnitReporter(outputDir, true, false, fileBase, true));
    }
    jasmineEnv.setIncludedTags([process.platform]);
    jasmineContent = document.createElement('div');
    jasmineContent.setAttribute('id', 'jasmine-content');
    document.body.appendChild(jasmineContent);
    jasmineEnv.execute();
    return promise;
  };

  asyncifyJasmineFn = function(fn, callbackPosition) {
    return function() {
      var args, callback;
      args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
      if (typeof args[callbackPosition] === 'function') {
        callback = args[callbackPosition];
        args[callbackPosition] = function() {
          var args, result;
          args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
          result = callback.apply(this, args);
          if (result instanceof Promise) {
            return waitsForPromise(function() {
              return result;
            });
          }
        };
      }
      return fn.apply(this, args);
    };
  };

  waitsForPromise = function(fn) {
    var promise;
    promise = fn();
    return global.waitsFor('spec promise to resolve', function(done) {
      return promise.then(done, function(error) {
        jasmine.getEnv().currentSpec.fail(error);
        return done();
      });
    });
  };

  disableFocusMethods = function() {
    return ['fdescribe', 'ffdescribe', 'fffdescribe', 'fit', 'ffit', 'fffit'].forEach(function(methodName) {
      var focusMethod;
      focusMethod = window[methodName];
      return window[methodName] = function(description) {
        var error;
        error = new Error('Focused spec is running on CI');
        return focusMethod(description, function() {
          throw error;
        });
      };
    });
  };

  requireSpecs = function(testPath, specType) {
    var i, len, ref, results, testFilePath;
    if (fs.isDirectorySync(testPath)) {
      ref = fs.listTreeSync(testPath);
      results = [];
      for (i = 0, len = ref.length; i < len; i++) {
        testFilePath = ref[i];
        if (!(/-spec\.(coffee|js)$/.test(testFilePath))) {
          continue;
        }
        require(testFilePath);
        results.push(setSpecDirectory(testPath));
      }
      return results;
    } else {
      require(testPath);
      return setSpecDirectory(path.dirname(testPath));
    }
  };

  setSpecField = function(name, value) {
    var i, index, ref, results, specs;
    specs = jasmine.getEnv().currentRunner().specs();
    if (specs.length === 0) {
      return;
    }
    results = [];
    for (index = i = ref = specs.length - 1; ref <= 0 ? i <= 0 : i >= 0; index = ref <= 0 ? ++i : --i) {
      if (specs[index][name] != null) {
        break;
      }
      results.push(specs[index][name] = value);
    }
    return results;
  };

  setSpecType = function(specType) {
    return setSpecField('specType', specType);
  };

  setSpecDirectory = function(specDirectory) {
    return setSpecField('specDirectory', specDirectory);
  };

  buildReporter = function(arg) {
    var AtomReporter, headless, logFile, reporter, resolveWithExitCode;
    logFile = arg.logFile, headless = arg.headless, resolveWithExitCode = arg.resolveWithExitCode;
    if (headless) {
      return buildTerminalReporter(logFile, resolveWithExitCode);
    } else {
      AtomReporter = require('./atom-reporter');
      return reporter = new AtomReporter();
    }
  };

  buildTerminalReporter = function(logFile, resolveWithExitCode) {
    var JasmineListReporter, TerminalReporter, log, logStream, options;
    if (logFile != null) {
      logStream = fs.openSync(logFile, 'w');
    }
    log = function(str) {
      if (logStream != null) {
        return fs.writeSync(logStream, str);
      } else {
        return ipcRenderer.send('write-to-stderr', str);
      }
    };
    options = {
      print: function(str) {
        return log(str);
      },
      onComplete: function(runner) {
        if (logStream != null) {
          fs.closeSync(logStream);
        }
        if (Grim.getDeprecationsLength() > 0) {
          Grim.logDeprecations();
          resolveWithExitCode(1);
          return;
        }
        if (runner.results().failedCount > 0) {
          return resolveWithExitCode(1);
        } else {
          return resolveWithExitCode(0);
        }
      }
    };
    if (process.env.ATOM_JASMINE_REPORTER === 'list') {
      JasmineListReporter = require('./jasmine-list-reporter').JasmineListReporter;
      return new JasmineListReporter(options);
    } else {
      TerminalReporter = require('jasmine-tagged').TerminalReporter;
      return new TerminalReporter(options);
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2J1aWxkL2F0b20vc3JjL2F0b20tMS40MC4xL291dC9hcHAvc3BlYy9qYXNtaW5lLXRlc3QtcnVubmVyLmNvZmZlZSJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtBQUFBLE1BQUEsMkxBQUE7SUFBQTs7RUFBQSxJQUFBLEdBQU8sT0FBQSxDQUFRLE1BQVI7O0VBQ1AsRUFBQSxHQUFLLE9BQUEsQ0FBUSxTQUFSOztFQUNMLElBQUEsR0FBTyxPQUFBLENBQVEsTUFBUjs7RUFDUCxJQUFBLEdBQU8sT0FBQSxDQUFRLE1BQVI7O0VBQ04sY0FBZSxPQUFBLENBQVEsVUFBUjs7RUFFaEIsSUFBSSxDQUFDLEtBQUwsQ0FBQTs7RUFFQSxNQUFNLENBQUMsT0FBUCxHQUFpQixTQUFDLEdBQUQ7QUFDZixRQUFBO0lBRGlCLHVCQUFTLHlCQUFVLDJCQUFXO0FBQy9DO0FBQUEsU0FBQSxVQUFBOztNQUFBLE1BQU8sQ0FBQSxHQUFBLENBQVAsR0FBYztBQUFkO0lBQ0EsT0FBQSxDQUFRLGdCQUFSO0lBS0EsTUFBTSxDQUFDLEVBQVAsR0FBWSxpQkFBQSxDQUFrQixNQUFNLENBQUMsRUFBekIsRUFBNkIsQ0FBN0I7SUFDWixNQUFNLENBQUMsR0FBUCxHQUFhLGlCQUFBLENBQWtCLE1BQU0sQ0FBQyxHQUF6QixFQUE4QixDQUE5QjtJQUNiLE1BQU0sQ0FBQyxJQUFQLEdBQWMsaUJBQUEsQ0FBa0IsTUFBTSxDQUFDLElBQXpCLEVBQStCLENBQS9CO0lBQ2QsTUFBTSxDQUFDLEtBQVAsR0FBZSxpQkFBQSxDQUFrQixNQUFNLENBQUMsS0FBekIsRUFBZ0MsQ0FBaEM7SUFDZixNQUFNLENBQUMsVUFBUCxHQUFvQixpQkFBQSxDQUFrQixNQUFNLENBQUMsVUFBekIsRUFBcUMsQ0FBckM7SUFDcEIsTUFBTSxDQUFDLFNBQVAsR0FBbUIsaUJBQUEsQ0FBa0IsTUFBTSxDQUFDLFNBQXpCLEVBQW9DLENBQXBDO0lBR25CLGFBQUEsR0FBZ0I7SUFDaEIsTUFBTSxDQUFDLGNBQVAsQ0FBc0IsUUFBdEIsRUFBZ0MsT0FBaEMsRUFDRTtNQUFBLEdBQUEsRUFBSyxTQUFBO2VBQUc7TUFBSCxDQUFMO01BQ0EsR0FBQSxFQUFLLFNBQUMsS0FBRDtlQUFXLGFBQUEsR0FBZ0I7TUFBM0IsQ0FETDtLQURGO0lBSUEsUUFBQSxHQUFXLE9BQU8sQ0FBQyxHQUFHLENBQUMsU0FBWixJQUF5QixJQUFJLENBQUMsSUFBTCxDQUFVLEVBQUUsQ0FBQyxnQkFBSCxDQUFBLENBQVYsRUFBaUMsT0FBakM7SUFDcEMsUUFBQSxHQUFXLElBQUksQ0FBQyxTQUFMLENBQWU7TUFBQSxNQUFBLEVBQVEsaUJBQVI7S0FBZjtJQUNYLElBQUcsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBZjtNQUNFLFlBQUEsR0FBZSxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQTlCLENBQW9DLEtBQXBDO01BQ2YsRUFBRSxDQUFDLFlBQUgsQ0FBZ0IsSUFBSSxDQUFDLElBQUwsQ0FBVSxRQUFWLEVBQW9CLFVBQXBCLENBQWhCO0FBQ0EsV0FBQSw4Q0FBQTs7UUFDRSxRQUFBLEdBQVcsSUFBSSxDQUFDLElBQUwsQ0FBVSxRQUFWLEVBQW9CLFVBQXBCLEVBQWdDLFFBQWhDO1FBQ1gsWUFBQSxHQUFlLElBQUksQ0FBQyxJQUFMLENBQVUsUUFBVixFQUFvQixVQUFwQixFQUFnQyxRQUFoQztBQUVmO1VBQ0UsRUFBRSxDQUFDLFdBQUgsQ0FBZSxRQUFmLEVBQXlCLFlBQXpCLEVBQXVDLEtBQXZDLEVBREY7U0FBQSxjQUFBO1VBR0UsRUFBRSxDQUFDLFFBQUgsQ0FBWSxRQUFaLEVBQXNCLFlBQXRCLEVBSEY7O0FBSkYsT0FIRjs7SUFZQSxtQkFBQSxHQUFzQixPQUFBLENBQVEsNkJBQVI7SUFDdEIsbUJBQUEsR0FBc0IsSUFBSSxtQkFBSixDQUFBO0lBQ3RCLG1CQUFtQixDQUFDLHNCQUFwQixHQUE2QyxTQUFBLEdBQUE7SUFDN0MsbUJBQW1CLENBQUMsdUJBQXBCLEdBQThDLFNBQUEsR0FBQTtJQUM5QyxNQUFNLENBQUMsSUFBUCxHQUFjLG9CQUFBLENBQXFCO01BQ2pDLHFCQUFBLG1CQURpQztNQUNaLFFBQUEsTUFEWTtNQUNKLFVBQUEsUUFESTtNQUVqQyxhQUFBLEVBQWUsUUFGa0I7TUFHakMsaUJBQUEsRUFBbUIsS0FIYztLQUFyQjtJQU1kLE9BQUEsQ0FBUSxlQUFSO0lBQ0EsSUFBeUIsT0FBTyxDQUFDLEdBQUcsQ0FBQyxVQUFaLElBQTBCLE9BQU8sQ0FBQyxHQUFHLENBQUMsRUFBL0Q7TUFBQSxtQkFBQSxDQUFBLEVBQUE7O0FBQ0EsU0FBQSw2Q0FBQTs7TUFBQSxZQUFBLENBQWEsUUFBYjtBQUFBO0lBRUEsV0FBQSxDQUFZLE1BQVo7SUFFQSxtQkFBQSxHQUFzQjtJQUN0QixPQUFBLEdBQVUsSUFBSSxPQUFKLENBQVksU0FBQyxPQUFELEVBQVUsTUFBVjthQUFxQixtQkFBQSxHQUFzQjtJQUEzQyxDQUFaO0lBQ1YsVUFBQSxHQUFhLE9BQU8sQ0FBQyxNQUFSLENBQUE7SUFDYixVQUFVLENBQUMsV0FBWCxDQUF1QixhQUFBLENBQWM7TUFBQyxTQUFBLE9BQUQ7TUFBVSxVQUFBLFFBQVY7TUFBb0IscUJBQUEsbUJBQXBCO0tBQWQsQ0FBdkI7SUFDQSxZQUFBLEdBQWUsT0FBQSxDQUFRLGlCQUFSO0lBQ2YsVUFBVSxDQUFDLFdBQVgsQ0FBdUIsSUFBSSxZQUFKLENBQUEsQ0FBdkI7SUFFQSxJQUFHLE9BQU8sQ0FBQyxHQUFHLENBQUMsbUJBQWY7TUFDRyx1QkFBd0IsT0FBQSxDQUFRLDBCQUFSO01BQ3pCLE9BQU8sQ0FBQyxNQUFNLENBQUMsS0FBZixDQUFxQiwyQkFBQSxHQUE0QixPQUFPLENBQUMsR0FBRyxDQUFDLG1CQUF4QyxHQUE0RCxLQUFqRjtNQUNBLFNBQUEsR0FBWSxJQUFJLENBQUMsT0FBTCxDQUFhLE9BQU8sQ0FBQyxHQUFHLENBQUMsbUJBQXpCO01BQ1osUUFBQSxHQUFXLElBQUksQ0FBQyxRQUFMLENBQWMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxtQkFBMUIsRUFBK0MsTUFBL0M7TUFFWCxVQUFVLENBQUMsV0FBWCxDQUF1QixJQUFJLG9CQUFKLENBQXlCLFNBQXpCLEVBQW9DLElBQXBDLEVBQTBDLEtBQTFDLEVBQWlELFFBQWpELEVBQTJELElBQTNELENBQXZCLEVBTkY7O0lBUUEsVUFBVSxDQUFDLGVBQVgsQ0FBMkIsQ0FBQyxPQUFPLENBQUMsUUFBVCxDQUEzQjtJQUVBLGNBQUEsR0FBaUIsUUFBUSxDQUFDLGFBQVQsQ0FBdUIsS0FBdkI7SUFDakIsY0FBYyxDQUFDLFlBQWYsQ0FBNEIsSUFBNUIsRUFBa0MsaUJBQWxDO0lBRUEsUUFBUSxDQUFDLElBQUksQ0FBQyxXQUFkLENBQTBCLGNBQTFCO0lBRUEsVUFBVSxDQUFDLE9BQVgsQ0FBQTtXQUNBO0VBekVlOztFQTJFakIsaUJBQUEsR0FBb0IsU0FBQyxFQUFELEVBQUssZ0JBQUw7V0FDbEIsU0FBQTtBQUNFLFVBQUE7TUFERDtNQUNDLElBQUcsT0FBTyxJQUFLLENBQUEsZ0JBQUEsQ0FBWixLQUFpQyxVQUFwQztRQUNFLFFBQUEsR0FBVyxJQUFLLENBQUEsZ0JBQUE7UUFFaEIsSUFBSyxDQUFBLGdCQUFBLENBQUwsR0FBeUIsU0FBQTtBQUN2QixjQUFBO1VBRHdCO1VBQ3hCLE1BQUEsR0FBUyxRQUFRLENBQUMsS0FBVCxDQUFlLElBQWYsRUFBcUIsSUFBckI7VUFDVCxJQUFHLE1BQUEsWUFBa0IsT0FBckI7bUJBQ0UsZUFBQSxDQUFnQixTQUFBO3FCQUFHO1lBQUgsQ0FBaEIsRUFERjs7UUFGdUIsRUFIM0I7O2FBUUEsRUFBRSxDQUFDLEtBQUgsQ0FBUyxJQUFULEVBQWUsSUFBZjtJQVRGO0VBRGtCOztFQVlwQixlQUFBLEdBQWtCLFNBQUMsRUFBRDtBQUNoQixRQUFBO0lBQUEsT0FBQSxHQUFVLEVBQUEsQ0FBQTtXQUVWLE1BQU0sQ0FBQyxRQUFQLENBQWdCLHlCQUFoQixFQUEyQyxTQUFDLElBQUQ7YUFDekMsT0FBTyxDQUFDLElBQVIsQ0FBYSxJQUFiLEVBQW1CLFNBQUMsS0FBRDtRQUNqQixPQUFPLENBQUMsTUFBUixDQUFBLENBQWdCLENBQUMsV0FBVyxDQUFDLElBQTdCLENBQWtDLEtBQWxDO2VBQ0EsSUFBQSxDQUFBO01BRmlCLENBQW5CO0lBRHlDLENBQTNDO0VBSGdCOztFQVVsQixtQkFBQSxHQUFzQixTQUFBO1dBQ3BCLENBQUMsV0FBRCxFQUFjLFlBQWQsRUFBNEIsYUFBNUIsRUFBMkMsS0FBM0MsRUFBa0QsTUFBbEQsRUFBMEQsT0FBMUQsQ0FBa0UsQ0FBQyxPQUFuRSxDQUEyRSxTQUFDLFVBQUQ7QUFDekUsVUFBQTtNQUFBLFdBQUEsR0FBYyxNQUFPLENBQUEsVUFBQTthQUNyQixNQUFPLENBQUEsVUFBQSxDQUFQLEdBQXFCLFNBQUMsV0FBRDtBQUNuQixZQUFBO1FBQUEsS0FBQSxHQUFRLElBQUksS0FBSixDQUFVLCtCQUFWO2VBQ1IsV0FBQSxDQUFZLFdBQVosRUFBeUIsU0FBQTtBQUFHLGdCQUFNO1FBQVQsQ0FBekI7TUFGbUI7SUFGb0QsQ0FBM0U7RUFEb0I7O0VBT3RCLFlBQUEsR0FBZSxTQUFDLFFBQUQsRUFBVyxRQUFYO0FBQ2IsUUFBQTtJQUFBLElBQUcsRUFBRSxDQUFDLGVBQUgsQ0FBbUIsUUFBbkIsQ0FBSDtBQUNFO0FBQUE7V0FBQSxxQ0FBQTs7Y0FBbUQscUJBQXFCLENBQUMsSUFBdEIsQ0FBMkIsWUFBM0I7OztRQUNqRCxPQUFBLENBQVEsWUFBUjtxQkFFQSxnQkFBQSxDQUFpQixRQUFqQjtBQUhGO3FCQURGO0tBQUEsTUFBQTtNQU1FLE9BQUEsQ0FBUSxRQUFSO2FBQ0EsZ0JBQUEsQ0FBaUIsSUFBSSxDQUFDLE9BQUwsQ0FBYSxRQUFiLENBQWpCLEVBUEY7O0VBRGE7O0VBVWYsWUFBQSxHQUFlLFNBQUMsSUFBRCxFQUFPLEtBQVA7QUFDYixRQUFBO0lBQUEsS0FBQSxHQUFRLE9BQU8sQ0FBQyxNQUFSLENBQUEsQ0FBZ0IsQ0FBQyxhQUFqQixDQUFBLENBQWdDLENBQUMsS0FBakMsQ0FBQTtJQUNSLElBQVUsS0FBSyxDQUFDLE1BQU4sS0FBZ0IsQ0FBMUI7QUFBQSxhQUFBOztBQUNBO1NBQWEsNEZBQWI7TUFDRSxJQUFTLDBCQUFUO0FBQUEsY0FBQTs7bUJBQ0EsS0FBTSxDQUFBLEtBQUEsQ0FBTyxDQUFBLElBQUEsQ0FBYixHQUFxQjtBQUZ2Qjs7RUFIYTs7RUFPZixXQUFBLEdBQWMsU0FBQyxRQUFEO1dBQ1osWUFBQSxDQUFhLFVBQWIsRUFBeUIsUUFBekI7RUFEWTs7RUFHZCxnQkFBQSxHQUFtQixTQUFDLGFBQUQ7V0FDakIsWUFBQSxDQUFhLGVBQWIsRUFBOEIsYUFBOUI7RUFEaUI7O0VBR25CLGFBQUEsR0FBZ0IsU0FBQyxHQUFEO0FBQ2QsUUFBQTtJQURnQix1QkFBUyx5QkFBVTtJQUNuQyxJQUFHLFFBQUg7YUFDRSxxQkFBQSxDQUFzQixPQUF0QixFQUErQixtQkFBL0IsRUFERjtLQUFBLE1BQUE7TUFHRSxZQUFBLEdBQWUsT0FBQSxDQUFRLGlCQUFSO2FBQ2YsUUFBQSxHQUFXLElBQUksWUFBSixDQUFBLEVBSmI7O0VBRGM7O0VBT2hCLHFCQUFBLEdBQXdCLFNBQUMsT0FBRCxFQUFVLG1CQUFWO0FBQ3RCLFFBQUE7SUFBQSxJQUF5QyxlQUF6QztNQUFBLFNBQUEsR0FBWSxFQUFFLENBQUMsUUFBSCxDQUFZLE9BQVosRUFBcUIsR0FBckIsRUFBWjs7SUFDQSxHQUFBLEdBQU0sU0FBQyxHQUFEO01BQ0osSUFBRyxpQkFBSDtlQUNFLEVBQUUsQ0FBQyxTQUFILENBQWEsU0FBYixFQUF3QixHQUF4QixFQURGO09BQUEsTUFBQTtlQUdFLFdBQVcsQ0FBQyxJQUFaLENBQWlCLGlCQUFqQixFQUFvQyxHQUFwQyxFQUhGOztJQURJO0lBTU4sT0FBQSxHQUNFO01BQUEsS0FBQSxFQUFPLFNBQUMsR0FBRDtlQUNMLEdBQUEsQ0FBSSxHQUFKO01BREssQ0FBUDtNQUVBLFVBQUEsRUFBWSxTQUFDLE1BQUQ7UUFDVixJQUEyQixpQkFBM0I7VUFBQSxFQUFFLENBQUMsU0FBSCxDQUFhLFNBQWIsRUFBQTs7UUFDQSxJQUFHLElBQUksQ0FBQyxxQkFBTCxDQUFBLENBQUEsR0FBK0IsQ0FBbEM7VUFDRSxJQUFJLENBQUMsZUFBTCxDQUFBO1VBQ0EsbUJBQUEsQ0FBb0IsQ0FBcEI7QUFDQSxpQkFIRjs7UUFLQSxJQUFHLE1BQU0sQ0FBQyxPQUFQLENBQUEsQ0FBZ0IsQ0FBQyxXQUFqQixHQUErQixDQUFsQztpQkFDRSxtQkFBQSxDQUFvQixDQUFwQixFQURGO1NBQUEsTUFBQTtpQkFHRSxtQkFBQSxDQUFvQixDQUFwQixFQUhGOztNQVBVLENBRlo7O0lBY0YsSUFBRyxPQUFPLENBQUMsR0FBRyxDQUFDLHFCQUFaLEtBQXFDLE1BQXhDO01BQ0csc0JBQXVCLE9BQUEsQ0FBUSx5QkFBUjthQUN4QixJQUFJLG1CQUFKLENBQXdCLE9BQXhCLEVBRkY7S0FBQSxNQUFBO01BSUcsbUJBQW9CLE9BQUEsQ0FBUSxnQkFBUjthQUNyQixJQUFJLGdCQUFKLENBQXFCLE9BQXJCLEVBTEY7O0VBdkJzQjtBQTlJeEIiLCJzb3VyY2VzQ29udGVudCI6WyJHcmltID0gcmVxdWlyZSAnZ3JpbSdcbmZzID0gcmVxdWlyZSAnZnMtcGx1cydcbnRlbXAgPSByZXF1aXJlICd0ZW1wJ1xucGF0aCA9IHJlcXVpcmUgJ3BhdGgnXG57aXBjUmVuZGVyZXJ9ID0gcmVxdWlyZSAnZWxlY3Ryb24nXG5cbnRlbXAudHJhY2soKVxuXG5tb2R1bGUuZXhwb3J0cyA9ICh7bG9nRmlsZSwgaGVhZGxlc3MsIHRlc3RQYXRocywgYnVpbGRBdG9tRW52aXJvbm1lbnR9KSAtPlxuICB3aW5kb3dba2V5XSA9IHZhbHVlIGZvciBrZXksIHZhbHVlIG9mIHJlcXVpcmUgJy4uL3ZlbmRvci9qYXNtaW5lJ1xuICByZXF1aXJlICdqYXNtaW5lLXRhZ2dlZCdcblxuICAjIFJld3JpdGUgZ2xvYmFsIGphc21pbmUgZnVuY3Rpb25zIHRvIGhhdmUgc3VwcG9ydCBmb3IgYXN5bmMgdGVzdHMuXG4gICMgVGhpcyB3YXkgcGFja2FnZXMgY2FuIGNyZWF0ZSBhc3luYyBzcGVjcyB3aXRob3V0IGhhdmluZyB0byBpbXBvcnQgdGhlc2UgZnJvbSB0aGVcbiAgIyBhc3luYy1zcGVjLWhlbHBlcnMgZmlsZS5cbiAgZ2xvYmFsLml0ID0gYXN5bmNpZnlKYXNtaW5lRm4gZ2xvYmFsLml0LCAxXG4gIGdsb2JhbC5maXQgPSBhc3luY2lmeUphc21pbmVGbiBnbG9iYWwuZml0LCAxXG4gIGdsb2JhbC5mZml0ID0gYXN5bmNpZnlKYXNtaW5lRm4gZ2xvYmFsLmZmaXQsIDFcbiAgZ2xvYmFsLmZmZml0ID0gYXN5bmNpZnlKYXNtaW5lRm4gZ2xvYmFsLmZmZml0LCAxXG4gIGdsb2JhbC5iZWZvcmVFYWNoID0gYXN5bmNpZnlKYXNtaW5lRm4gZ2xvYmFsLmJlZm9yZUVhY2gsIDBcbiAgZ2xvYmFsLmFmdGVyRWFjaCA9IGFzeW5jaWZ5SmFzbWluZUZuIGdsb2JhbC5hZnRlckVhY2gsIDBcblxuICAjIEFsbG93IGRvY3VtZW50LnRpdGxlIHRvIGJlIGFzc2lnbmVkIGluIHNwZWNzIHdpdGhvdXQgc2NyZXdpbmcgdXAgc3BlYyB3aW5kb3cgdGl0bGVcbiAgZG9jdW1lbnRUaXRsZSA9IG51bGxcbiAgT2JqZWN0LmRlZmluZVByb3BlcnR5IGRvY3VtZW50LCAndGl0bGUnLFxuICAgIGdldDogLT4gZG9jdW1lbnRUaXRsZVxuICAgIHNldDogKHRpdGxlKSAtPiBkb2N1bWVudFRpdGxlID0gdGl0bGVcblxuICB1c2VySG9tZSA9IHByb2Nlc3MuZW52LkFUT01fSE9NRSBvciBwYXRoLmpvaW4oZnMuZ2V0SG9tZURpcmVjdG9yeSgpLCAnLmF0b20nKVxuICBhdG9tSG9tZSA9IHRlbXAubWtkaXJTeW5jIHByZWZpeDogJ2F0b20tdGVzdC1ob21lLSdcbiAgaWYgcHJvY2Vzcy5lbnYuQVBNX1RFU1RfUEFDS0FHRVNcbiAgICB0ZXN0UGFja2FnZXMgPSBwcm9jZXNzLmVudi5BUE1fVEVTVF9QQUNLQUdFUy5zcGxpdCAvXFxzKy9cbiAgICBmcy5tYWtlVHJlZVN5bmMgcGF0aC5qb2luKGF0b21Ib21lLCAncGFja2FnZXMnKVxuICAgIGZvciBwYWNrTmFtZSBpbiB0ZXN0UGFja2FnZXNcbiAgICAgIHVzZXJQYWNrID0gcGF0aC5qb2luKHVzZXJIb21lLCAncGFja2FnZXMnLCBwYWNrTmFtZSlcbiAgICAgIGxvYWRhYmxlUGFjayA9IHBhdGguam9pbihhdG9tSG9tZSwgJ3BhY2thZ2VzJywgcGFja05hbWUpXG5cbiAgICAgIHRyeVxuICAgICAgICBmcy5zeW1saW5rU3luYyB1c2VyUGFjaywgbG9hZGFibGVQYWNrLCAnZGlyJ1xuICAgICAgY2F0Y2hcbiAgICAgICAgZnMuY29weVN5bmMgdXNlclBhY2ssIGxvYWRhYmxlUGFja1xuXG4gIEFwcGxpY2F0aW9uRGVsZWdhdGUgPSByZXF1aXJlICcuLi9zcmMvYXBwbGljYXRpb24tZGVsZWdhdGUnXG4gIGFwcGxpY2F0aW9uRGVsZWdhdGUgPSBuZXcgQXBwbGljYXRpb25EZWxlZ2F0ZSgpXG4gIGFwcGxpY2F0aW9uRGVsZWdhdGUuc2V0UmVwcmVzZW50ZWRGaWxlbmFtZSA9IC0+XG4gIGFwcGxpY2F0aW9uRGVsZWdhdGUuc2V0V2luZG93RG9jdW1lbnRFZGl0ZWQgPSAtPlxuICB3aW5kb3cuYXRvbSA9IGJ1aWxkQXRvbUVudmlyb25tZW50KHtcbiAgICBhcHBsaWNhdGlvbkRlbGVnYXRlLCB3aW5kb3csIGRvY3VtZW50LFxuICAgIGNvbmZpZ0RpclBhdGg6IGF0b21Ib21lXG4gICAgZW5hYmxlUGVyc2lzdGVuY2U6IGZhbHNlXG4gIH0pXG5cbiAgcmVxdWlyZSAnLi9zcGVjLWhlbHBlcidcbiAgZGlzYWJsZUZvY3VzTWV0aG9kcygpIGlmIHByb2Nlc3MuZW52LkpBTktZX1NIQTEgb3IgcHJvY2Vzcy5lbnYuQ0lcbiAgcmVxdWlyZVNwZWNzKHRlc3RQYXRoKSBmb3IgdGVzdFBhdGggaW4gdGVzdFBhdGhzXG5cbiAgc2V0U3BlY1R5cGUoJ3VzZXInKVxuXG4gIHJlc29sdmVXaXRoRXhpdENvZGUgPSBudWxsXG4gIHByb21pc2UgPSBuZXcgUHJvbWlzZSAocmVzb2x2ZSwgcmVqZWN0KSAtPiByZXNvbHZlV2l0aEV4aXRDb2RlID0gcmVzb2x2ZVxuICBqYXNtaW5lRW52ID0gamFzbWluZS5nZXRFbnYoKVxuICBqYXNtaW5lRW52LmFkZFJlcG9ydGVyKGJ1aWxkUmVwb3J0ZXIoe2xvZ0ZpbGUsIGhlYWRsZXNzLCByZXNvbHZlV2l0aEV4aXRDb2RlfSkpXG4gIFRpbWVSZXBvcnRlciA9IHJlcXVpcmUgJy4vdGltZS1yZXBvcnRlcidcbiAgamFzbWluZUVudi5hZGRSZXBvcnRlcihuZXcgVGltZVJlcG9ydGVyKCkpXG5cbiAgaWYgcHJvY2Vzcy5lbnYuVEVTVF9KVU5JVF9YTUxfUEFUSFxuICAgIHtKYXNtaW5lSlVuaXRSZXBvcnRlcn0gPSByZXF1aXJlICcuL2phc21pbmUtanVuaXQtcmVwb3J0ZXInXG4gICAgcHJvY2Vzcy5zdGRvdXQud3JpdGUgXCJPdXRwdXR0aW5nIEpVbml0IFhNTCB0byA8I3twcm9jZXNzLmVudi5URVNUX0pVTklUX1hNTF9QQVRIfT5cXG5cIlxuICAgIG91dHB1dERpciA9IHBhdGguZGlybmFtZShwcm9jZXNzLmVudi5URVNUX0pVTklUX1hNTF9QQVRIKVxuICAgIGZpbGVCYXNlID0gcGF0aC5iYXNlbmFtZShwcm9jZXNzLmVudi5URVNUX0pVTklUX1hNTF9QQVRILCAnLnhtbCcpXG5cbiAgICBqYXNtaW5lRW52LmFkZFJlcG9ydGVyIG5ldyBKYXNtaW5lSlVuaXRSZXBvcnRlcihvdXRwdXREaXIsIHRydWUsIGZhbHNlLCBmaWxlQmFzZSwgdHJ1ZSlcblxuICBqYXNtaW5lRW52LnNldEluY2x1ZGVkVGFncyhbcHJvY2Vzcy5wbGF0Zm9ybV0pXG5cbiAgamFzbWluZUNvbnRlbnQgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKVxuICBqYXNtaW5lQ29udGVudC5zZXRBdHRyaWJ1dGUoJ2lkJywgJ2phc21pbmUtY29udGVudCcpXG5cbiAgZG9jdW1lbnQuYm9keS5hcHBlbmRDaGlsZChqYXNtaW5lQ29udGVudClcblxuICBqYXNtaW5lRW52LmV4ZWN1dGUoKVxuICBwcm9taXNlXG5cbmFzeW5jaWZ5SmFzbWluZUZuID0gKGZuLCBjYWxsYmFja1Bvc2l0aW9uKSAtPlxuICAoYXJncy4uLikgLT5cbiAgICBpZiB0eXBlb2YgYXJnc1tjYWxsYmFja1Bvc2l0aW9uXSBpcyAnZnVuY3Rpb24nXG4gICAgICBjYWxsYmFjayA9IGFyZ3NbY2FsbGJhY2tQb3NpdGlvbl1cblxuICAgICAgYXJnc1tjYWxsYmFja1Bvc2l0aW9uXSA9IChhcmdzLi4uKSAtPlxuICAgICAgICByZXN1bHQgPSBjYWxsYmFjay5hcHBseSB0aGlzLCBhcmdzXG4gICAgICAgIGlmIHJlc3VsdCBpbnN0YW5jZW9mIFByb21pc2VcbiAgICAgICAgICB3YWl0c0ZvclByb21pc2UoLT4gcmVzdWx0KVxuXG4gICAgZm4uYXBwbHkgdGhpcywgYXJnc1xuXG53YWl0c0ZvclByb21pc2UgPSAoZm4pIC0+XG4gIHByb21pc2UgPSBmbigpXG5cbiAgZ2xvYmFsLndhaXRzRm9yKCdzcGVjIHByb21pc2UgdG8gcmVzb2x2ZScsIChkb25lKSAtPlxuICAgIHByb21pc2UudGhlbihkb25lLCAoZXJyb3IpIC0+XG4gICAgICBqYXNtaW5lLmdldEVudigpLmN1cnJlbnRTcGVjLmZhaWwgZXJyb3JcbiAgICAgIGRvbmUoKVxuICAgIClcbiAgKVxuXG5kaXNhYmxlRm9jdXNNZXRob2RzID0gLT5cbiAgWydmZGVzY3JpYmUnLCAnZmZkZXNjcmliZScsICdmZmZkZXNjcmliZScsICdmaXQnLCAnZmZpdCcsICdmZmZpdCddLmZvckVhY2ggKG1ldGhvZE5hbWUpIC0+XG4gICAgZm9jdXNNZXRob2QgPSB3aW5kb3dbbWV0aG9kTmFtZV1cbiAgICB3aW5kb3dbbWV0aG9kTmFtZV0gPSAoZGVzY3JpcHRpb24pIC0+XG4gICAgICBlcnJvciA9IG5ldyBFcnJvcignRm9jdXNlZCBzcGVjIGlzIHJ1bm5pbmcgb24gQ0knKVxuICAgICAgZm9jdXNNZXRob2QgZGVzY3JpcHRpb24sIC0+IHRocm93IGVycm9yXG5cbnJlcXVpcmVTcGVjcyA9ICh0ZXN0UGF0aCwgc3BlY1R5cGUpIC0+XG4gIGlmIGZzLmlzRGlyZWN0b3J5U3luYyh0ZXN0UGF0aClcbiAgICBmb3IgdGVzdEZpbGVQYXRoIGluIGZzLmxpc3RUcmVlU3luYyh0ZXN0UGF0aCkgd2hlbiAvLXNwZWNcXC4oY29mZmVlfGpzKSQvLnRlc3QgdGVzdEZpbGVQYXRoXG4gICAgICByZXF1aXJlKHRlc3RGaWxlUGF0aClcbiAgICAgICMgU2V0IHNwZWMgZGlyZWN0b3J5IG9uIHNwZWMgZm9yIHNldHRpbmcgdXAgdGhlIHByb2plY3QgaW4gc3BlYy1oZWxwZXJcbiAgICAgIHNldFNwZWNEaXJlY3RvcnkodGVzdFBhdGgpXG4gIGVsc2VcbiAgICByZXF1aXJlKHRlc3RQYXRoKVxuICAgIHNldFNwZWNEaXJlY3RvcnkocGF0aC5kaXJuYW1lKHRlc3RQYXRoKSlcblxuc2V0U3BlY0ZpZWxkID0gKG5hbWUsIHZhbHVlKSAtPlxuICBzcGVjcyA9IGphc21pbmUuZ2V0RW52KCkuY3VycmVudFJ1bm5lcigpLnNwZWNzKClcbiAgcmV0dXJuIGlmIHNwZWNzLmxlbmd0aCBpcyAwXG4gIGZvciBpbmRleCBpbiBbc3BlY3MubGVuZ3RoLTEuLjBdXG4gICAgYnJlYWsgaWYgc3BlY3NbaW5kZXhdW25hbWVdP1xuICAgIHNwZWNzW2luZGV4XVtuYW1lXSA9IHZhbHVlXG5cbnNldFNwZWNUeXBlID0gKHNwZWNUeXBlKSAtPlxuICBzZXRTcGVjRmllbGQoJ3NwZWNUeXBlJywgc3BlY1R5cGUpXG5cbnNldFNwZWNEaXJlY3RvcnkgPSAoc3BlY0RpcmVjdG9yeSkgLT5cbiAgc2V0U3BlY0ZpZWxkKCdzcGVjRGlyZWN0b3J5Jywgc3BlY0RpcmVjdG9yeSlcblxuYnVpbGRSZXBvcnRlciA9ICh7bG9nRmlsZSwgaGVhZGxlc3MsIHJlc29sdmVXaXRoRXhpdENvZGV9KSAtPlxuICBpZiBoZWFkbGVzc1xuICAgIGJ1aWxkVGVybWluYWxSZXBvcnRlcihsb2dGaWxlLCByZXNvbHZlV2l0aEV4aXRDb2RlKVxuICBlbHNlXG4gICAgQXRvbVJlcG9ydGVyID0gcmVxdWlyZSAnLi9hdG9tLXJlcG9ydGVyJ1xuICAgIHJlcG9ydGVyID0gbmV3IEF0b21SZXBvcnRlcigpXG5cbmJ1aWxkVGVybWluYWxSZXBvcnRlciA9IChsb2dGaWxlLCByZXNvbHZlV2l0aEV4aXRDb2RlKSAtPlxuICBsb2dTdHJlYW0gPSBmcy5vcGVuU3luYyhsb2dGaWxlLCAndycpIGlmIGxvZ0ZpbGU/XG4gIGxvZyA9IChzdHIpIC0+XG4gICAgaWYgbG9nU3RyZWFtP1xuICAgICAgZnMud3JpdGVTeW5jKGxvZ1N0cmVhbSwgc3RyKVxuICAgIGVsc2VcbiAgICAgIGlwY1JlbmRlcmVyLnNlbmQgJ3dyaXRlLXRvLXN0ZGVycicsIHN0clxuXG4gIG9wdGlvbnMgPVxuICAgIHByaW50OiAoc3RyKSAtPlxuICAgICAgbG9nKHN0cilcbiAgICBvbkNvbXBsZXRlOiAocnVubmVyKSAtPlxuICAgICAgZnMuY2xvc2VTeW5jKGxvZ1N0cmVhbSkgaWYgbG9nU3RyZWFtP1xuICAgICAgaWYgR3JpbS5nZXREZXByZWNhdGlvbnNMZW5ndGgoKSA+IDBcbiAgICAgICAgR3JpbS5sb2dEZXByZWNhdGlvbnMoKVxuICAgICAgICByZXNvbHZlV2l0aEV4aXRDb2RlKDEpXG4gICAgICAgIHJldHVyblxuXG4gICAgICBpZiBydW5uZXIucmVzdWx0cygpLmZhaWxlZENvdW50ID4gMFxuICAgICAgICByZXNvbHZlV2l0aEV4aXRDb2RlKDEpXG4gICAgICBlbHNlXG4gICAgICAgIHJlc29sdmVXaXRoRXhpdENvZGUoMClcblxuICBpZiBwcm9jZXNzLmVudi5BVE9NX0pBU01JTkVfUkVQT1JURVIgaXMgJ2xpc3QnXG4gICAge0phc21pbmVMaXN0UmVwb3J0ZXJ9ID0gcmVxdWlyZSAnLi9qYXNtaW5lLWxpc3QtcmVwb3J0ZXInXG4gICAgbmV3IEphc21pbmVMaXN0UmVwb3J0ZXIob3B0aW9ucylcbiAgZWxzZVxuICAgIHtUZXJtaW5hbFJlcG9ydGVyfSA9IHJlcXVpcmUgJ2phc21pbmUtdGFnZ2VkJ1xuICAgIG5ldyBUZXJtaW5hbFJlcG9ydGVyKG9wdGlvbnMpXG4iXX0=
