"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ItemTypePropType = exports.UserStorePropType = exports.MergeConflictItemPropType = exports.MultiFilePatchPropType = exports.FilePatchItemPropType = exports.IssueishPropType = exports.OperationStateObserverPropType = exports.EnableableOperationPropType = exports.RangePropType = exports.PointPropType = exports.RefHolderPropType = exports.RelayConnectionPropType = exports.AuthorPropType = exports.CommitPropType = exports.BranchSetPropType = exports.RemoteSetPropType = exports.SearchPropType = exports.BranchPropType = exports.EndpointPropType = exports.RemotePropType = exports.GithubLoginModelPropType = exports.WorkdirContextPoolPropType = exports.DOMNodePropType = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

const DOMNodePropType = (props, propName, componentName) => {
  if (props[propName] instanceof HTMLElement) {
    return null;
  } else {
    return new Error(`Invalid prop '${propName}' supplied to '${componentName}'. Value is not DOM element.`);
  }
};

exports.DOMNodePropType = DOMNodePropType;

const WorkdirContextPoolPropType = _propTypes["default"].shape({
  getContext: _propTypes["default"].func.isRequired
});

exports.WorkdirContextPoolPropType = WorkdirContextPoolPropType;

const GithubLoginModelPropType = _propTypes["default"].shape({
  getToken: _propTypes["default"].func.isRequired,
  setToken: _propTypes["default"].func.isRequired,
  removeToken: _propTypes["default"].func.isRequired,
  getScopes: _propTypes["default"].func.isRequired,
  onDidUpdate: _propTypes["default"].func.isRequired
});

exports.GithubLoginModelPropType = GithubLoginModelPropType;

const RemotePropType = _propTypes["default"].shape({
  getName: _propTypes["default"].func.isRequired,
  getUrl: _propTypes["default"].func.isRequired,
  isGithubRepo: _propTypes["default"].func.isRequired,
  getOwner: _propTypes["default"].func.isRequired,
  getRepo: _propTypes["default"].func.isRequired,
  getEndpoint: _propTypes["default"].func.isRequired
});

exports.RemotePropType = RemotePropType;

const EndpointPropType = _propTypes["default"].shape({
  getGraphQLRoot: _propTypes["default"].func.isRequired,
  getRestRoot: _propTypes["default"].func.isRequired,
  getRestURI: _propTypes["default"].func.isRequired
});

exports.EndpointPropType = EndpointPropType;

const BranchPropType = _propTypes["default"].shape({
  getName: _propTypes["default"].func.isRequired,
  isDetached: _propTypes["default"].func.isRequired,
  isPresent: _propTypes["default"].func.isRequired
});

exports.BranchPropType = BranchPropType;

const SearchPropType = _propTypes["default"].shape({
  getName: _propTypes["default"].func.isRequired,
  createQuery: _propTypes["default"].func.isRequired
});

exports.SearchPropType = SearchPropType;

const RemoteSetPropType = _propTypes["default"].shape({
  withName: _propTypes["default"].func.isRequired,
  isEmpty: _propTypes["default"].func.isRequired,
  size: _propTypes["default"].func.isRequired,
  [Symbol.iterator]: _propTypes["default"].func.isRequired
});

exports.RemoteSetPropType = RemoteSetPropType;

const BranchSetPropType = _propTypes["default"].shape({
  getNames: _propTypes["default"].func.isRequired,
  getPullTargets: _propTypes["default"].func.isRequired,
  getPushSources: _propTypes["default"].func.isRequired
});

exports.BranchSetPropType = BranchSetPropType;

const CommitPropType = _propTypes["default"].shape({
  getSha: _propTypes["default"].func.isRequired,
  getMessageSubject: _propTypes["default"].func.isRequired,
  isUnbornRef: _propTypes["default"].func.isRequired,
  isPresent: _propTypes["default"].func.isRequired
});

exports.CommitPropType = CommitPropType;

const AuthorPropType = _propTypes["default"].shape({
  getEmail: _propTypes["default"].func.isRequired,
  getFullName: _propTypes["default"].func.isRequired
});

exports.AuthorPropType = AuthorPropType;

const RelayConnectionPropType = nodePropType => _propTypes["default"].shape({
  edges: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    cursor: _propTypes["default"].string,
    node: nodePropType
  })),
  pageInfo: _propTypes["default"].shape({
    endCursor: _propTypes["default"].string,
    hasNextPage: _propTypes["default"].bool,
    hasPreviousPage: _propTypes["default"].bool,
    startCursor: _propTypes["default"].string
  }),
  totalCount: _propTypes["default"].number
});

exports.RelayConnectionPropType = RelayConnectionPropType;

const RefHolderPropType = _propTypes["default"].shape({
  isEmpty: _propTypes["default"].func.isRequired,
  get: _propTypes["default"].func.isRequired,
  setter: _propTypes["default"].func.isRequired,
  observe: _propTypes["default"].func.isRequired
});

exports.RefHolderPropType = RefHolderPropType;

const PointPropType = _propTypes["default"].shape({
  row: _propTypes["default"].number.isRequired,
  column: _propTypes["default"].number.isRequired,
  isEqual: _propTypes["default"].func.isRequired
});

exports.PointPropType = PointPropType;

const RangePropType = _propTypes["default"].shape({
  start: PointPropType.isRequired,
  end: PointPropType.isRequired,
  isEqual: _propTypes["default"].func.isRequired
});

exports.RangePropType = RangePropType;

const EnableableOperationPropType = _propTypes["default"].shape({
  isEnabled: _propTypes["default"].func.isRequired,
  run: _propTypes["default"].func.isRequired,
  getMessage: _propTypes["default"].func.isRequired,
  why: _propTypes["default"].func.isRequired
});

exports.EnableableOperationPropType = EnableableOperationPropType;

const OperationStateObserverPropType = _propTypes["default"].shape({
  onDidComplete: _propTypes["default"].func.isRequired,
  dispose: _propTypes["default"].func.isRequired
});

exports.OperationStateObserverPropType = OperationStateObserverPropType;

const IssueishPropType = _propTypes["default"].shape({
  getNumber: _propTypes["default"].func.isRequired,
  getTitle: _propTypes["default"].func.isRequired,
  getGitHubURL: _propTypes["default"].func.isRequired,
  getAuthorLogin: _propTypes["default"].func.isRequired,
  getAuthorAvatarURL: _propTypes["default"].func.isRequired,
  getCreatedAt: _propTypes["default"].func.isRequired,
  getHeadRefName: _propTypes["default"].func.isRequired,
  getHeadRepositoryID: _propTypes["default"].func.isRequired,
  getStatusCounts: _propTypes["default"].func.isRequired
});

exports.IssueishPropType = IssueishPropType;

const FilePatchItemPropType = _propTypes["default"].shape({
  filePath: _propTypes["default"].string.isRequired,
  status: _propTypes["default"].string.isRequired
});

exports.FilePatchItemPropType = FilePatchItemPropType;

const MultiFilePatchPropType = _propTypes["default"].shape({
  getFilePatches: _propTypes["default"].func.isRequired
});

exports.MultiFilePatchPropType = MultiFilePatchPropType;
const statusNames = ['added', 'deleted', 'modified', 'typechange', 'equivalent'];

const MergeConflictItemPropType = _propTypes["default"].shape({
  filePath: _propTypes["default"].string.isRequired,
  status: _propTypes["default"].shape({
    file: _propTypes["default"].oneOf(statusNames).isRequired,
    ours: _propTypes["default"].oneOf(statusNames).isRequired,
    theirs: _propTypes["default"].oneOf(statusNames).isRequired
  }).isRequired
});

exports.MergeConflictItemPropType = MergeConflictItemPropType;

const UserStorePropType = _propTypes["default"].shape({
  getUsers: _propTypes["default"].func.isRequired,
  onDidUpdate: _propTypes["default"].func.isRequired
}); // Require item classes lazily to prevent circular imports


exports.UserStorePropType = UserStorePropType;
let lazyItemConstructors = null;

function createItemTypePropType(required) {
  return function (props, propName, componentName) {
    if (lazyItemConstructors === null) {
      lazyItemConstructors = new Set();

      for (const itemPath of ['./items/changed-file-item', './items/commit-preview-item', './items/commit-detail-item', './items/issueish-detail-item']) {
        lazyItemConstructors.add(require(itemPath)["default"]);
      }
    }

    if (props[propName] === undefined || props[propName] === null) {
      /* istanbul ignore else */
      if (required) {
        return new Error(`Missing required prop ${propName} on component ${componentName}.`);
      } else {
        return undefined;
      }
    }
    /* istanbul ignore if */


    if (!lazyItemConstructors.has(props[propName])) {
      const choices = Array.from(lazyItemConstructors, each => each.name).join(', ');
      return new Error(`Invalid prop "${propName}" supplied to ${componentName}. Must be one of ${choices}.`);
    }

    return undefined;
  };
}

const ItemTypePropType = createItemTypePropType(false);
exports.ItemTypePropType = ItemTypePropType;
ItemTypePropType.isRequired = createItemTypePropType(true);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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