"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nullFile = exports["default"] = void 0;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class File {
  constructor({
    path,
    mode,
    symlink
  }) {
    this.path = path;
    this.mode = mode;
    this.symlink = symlink;
  }

  getPath() {
    return this.path;
  }

  getMode() {
    return this.mode;
  }

  getSymlink() {
    return this.symlink;
  }

  isSymlink() {
    return this.getMode() === this.constructor.modes.SYMLINK;
  }

  isRegularFile() {
    return this.getMode() === this.constructor.modes.NORMAL || this.getMode() === this.constructor.modes.EXECUTABLE;
  }

  isExecutable() {
    return this.getMode() === this.constructor.modes.EXECUTABLE;
  }

  isPresent() {
    return true;
  }

  clone(opts = {}) {
    return new File({
      path: opts.path !== undefined ? opts.path : this.path,
      mode: opts.mode !== undefined ? opts.mode : this.mode,
      symlink: opts.symlink !== undefined ? opts.symlink : this.symlink
    });
  }

}

exports["default"] = File;

_defineProperty(File, "modes", {
  // Non-executable, non-symlink
  NORMAL: '100644',
  // +x bit set
  EXECUTABLE: '100755',
  // Soft link to another filesystem location
  SYMLINK: '120000',
  // Submodule mount point
  GITLINK: '160000'
});

const nullFile = {
  getPath() {
    /* istanbul ignore next */
    return null;
  },

  getMode() {
    /* istanbul ignore next */
    return null;
  },

  getSymlink() {
    /* istanbul ignore next */
    return null;
  },

  isSymlink() {
    return false;
  },

  isRegularFile() {
    return false;
  },

  isExecutable() {
    return false;
  },

  isPresent() {
    return false;
  },

  clone(opts = {}) {
    if (opts.path === undefined && opts.mode === undefined && opts.symlink === undefined) {
      return this;
    } else {
      return new File({
        path: opts.path !== undefined ? opts.path : this.getPath(),
        mode: opts.mode !== undefined ? opts.mode : this.getMode(),
        symlink: opts.symlink !== undefined ? opts.symlink : this.getSymlink()
      });
    }
  }

};
exports.nullFile = nullFile;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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