"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _electron = require("electron");

var _helpers = require("../helpers");

var _reporterProxy = require("../reporter-proxy");

var _propTypes2 = require("../prop-types");

var _issueishSearchesController = _interopRequireDefault(require("./issueish-searches-controller"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class RemoteController extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'onCreatePr');
  }

  render() {
    return _react["default"].createElement(_issueishSearchesController["default"], {
      endpoint: this.props.endpoint,
      token: this.props.token,
      remoteOperationObserver: this.props.remoteOperationObserver,
      workingDirectory: this.props.workingDirectory,
      repository: this.props.repository,
      workspace: this.props.workspace,
      remote: this.props.remote,
      remotes: this.props.remotes,
      branches: this.props.branches,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      onCreatePr: this.onCreatePr
    });
  }

  async onCreatePr() {
    const currentBranch = this.props.branches.getHeadBranch();
    const upstream = currentBranch.getUpstream();

    if (!upstream.isPresent() || this.props.aheadCount > 0) {
      await this.props.onPushBranch();
    }

    let createPrUrl = 'https://github.com/';
    createPrUrl += this.props.remote.getOwner() + '/' + this.props.remote.getRepo();
    createPrUrl += '/compare/' + encodeURIComponent(currentBranch.getName());
    createPrUrl += '?expand=1';
    return new Promise((resolve, reject) => {
      _electron.shell.openExternal(createPrUrl, {}, err => {
        if (err) {
          reject(err);
        } else {
          (0, _reporterProxy.incrementCounter)('create-pull-request');
          resolve();
        }
      });
    });
  }

}

exports["default"] = RemoteController;

_defineProperty(RemoteController, "propTypes", {
  // Relay payload
  repository: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired,
    defaultBranchRef: _propTypes["default"].shape({
      prefix: _propTypes["default"].string.isRequired,
      name: _propTypes["default"].string.isRequired
    })
  }),
  // Connection
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes["default"].string.isRequired,
  // Repository derived attributes
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  workingDirectory: _propTypes["default"].string,
  workspace: _propTypes["default"].object.isRequired,
  remote: _propTypes2.RemotePropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  aheadCount: _propTypes["default"].number,
  pushInProgress: _propTypes["default"].bool.isRequired,
  // Actions
  onPushBranch: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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