"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _issueishListController = _interopRequireWildcard(require("../controllers/issueish-list-controller"));

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _graphql;

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class IssueishSearchContainer extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'renderQueryResult');
    this.sub = new _eventKit.Disposable();
  }

  render() {
    const environment = _relayNetworkLayerManager["default"].getEnvironmentForHost(this.props.endpoint, this.props.token);

    if (this.props.search.isNull()) {
      return _react["default"].createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false
      }, this.controllerProps()));
    }

    const query = _graphql || (_graphql = function () {
      const node = require("./__generated__/issueishSearchContainerQuery.graphql");

      if (node.hash && node.hash !== "9b0a99c35f017d4c3013e5908990a61c") {
        console.error("The definition of 'issueishSearchContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
      }

      return require("./__generated__/issueishSearchContainerQuery.graphql");
    });

    const variables = {
      query: this.props.search.createQuery(),
      first: this.props.limit,
      checkSuiteCount: _helpers.CHECK_SUITE_PAGE_SIZE,
      checkSuiteCursor: null,
      checkRunCount: _helpers.CHECK_RUN_PAGE_SIZE,
      checkRunCursor: null
    };
    return _react["default"].createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      variables: variables,
      query: query,
      render: this.renderQueryResult
    });
  }

  renderQueryResult({
    error,
    props,
    retry
  }) {
    if (retry) {
      this.sub.dispose();
      this.sub = this.props.remoteOperationObserver.onDidComplete(retry);
    }

    if (error) {
      return _react["default"].createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false,
        error: error
      }, this.controllerProps()));
    }

    if (props === null) {
      return _react["default"].createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: true
      }, this.controllerProps()));
    }

    return _react["default"].createElement(_issueishListController["default"], _extends({
      total: props.search.issueCount,
      results: props.search.nodes,
      isLoading: false
    }, this.controllerProps()));
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

  controllerProps() {
    return {
      title: this.props.search.getName(),
      onOpenIssueish: this.props.onOpenIssueish,
      onOpenReviews: this.props.onOpenReviews,
      onOpenMore: () => this.props.onOpenSearch(this.props.search)
    };
  }

}

exports["default"] = IssueishSearchContainer;

_defineProperty(IssueishSearchContainer, "propTypes", {
  // Connection information
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes["default"].string.isRequired,
  // Search model
  limit: _propTypes["default"].number,
  search: _propTypes2.SearchPropType.isRequired,
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  // Action methods
  onOpenIssueish: _propTypes["default"].func.isRequired,
  onOpenSearch: _propTypes["default"].func.isRequired,
  onOpenReviews: _propTypes["default"].func.isRequired
});

_defineProperty(IssueishSearchContainer, "defaultProps", {
  limit: 20
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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