/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.document;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XDevice;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XChild;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.container.XNamed;
import com.sun.star.drawing.XControlShape;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPageSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.drawing.XShapeGrouper;
import com.sun.star.drawing.XShapes;
import com.sun.star.form.XFormsSupplier;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.view.XControlAccess;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.document.Control;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FormHandler {
    private static final String CHECKBOX = "CheckBox";
    private static final String DATEFIELD = "DateField";
    private static final String FORMATTEDFIELD = "FormattedField";
    private static final String TEXTFIELD = "TextField";
    private static final String TIMEFIELD = "TimeField";
    private XFormsSupplier xFormsSupplier;
    public XMultiServiceFactory xMSFDoc;
    public XMultiServiceFactory xMSF;
    public XDrawPage xDrawPage;
    public String[] sModelServices = new String[8];
    public static ControlData[] oControlData;
    public static final int SOLABEL = 0;
    public static final int SOTEXTBOX = 1;
    public static final int SOCHECKBOX = 2;
    public static final int SODATECONTROL = 3;
    public static final int SOTIMECONTROL = 4;
    public static final int SONUMERICCONTROL = 5;
    public static final int SOGRIDCONTROL = 6;
    public static final int SOIMAGECONTROL = 7;
    public static final int SODATETIMECONTROL = 8;
    public static String SOSIZETEXT;
    private int iXPixelFactor = -1;
    private int iYPixelFactor = -1;
    private int iXNirwanaPos = 50000;
    private int iYNirwanaPos = 50000;
    private int nLabelHeight = -1;
    private int nDBRefHeight = -1;
    private int BasicLabelDiffHeight = -1;
    private XNameAccess xNamedForms;
    XControlAccess xControlAccess;
    XShapeGrouper xShapeGrouper;

    public FormHandler(XMultiServiceFactory _xMSF, XTextDocument xTextDocument) {
        this.xMSF = _xMSF;
        XDrawPageSupplier xDrawPageSupplier = (XDrawPageSupplier)UnoRuntime.queryInterface(XDrawPageSupplier.class, (Object)xTextDocument);
        this.xDrawPage = xDrawPageSupplier.getDrawPage();
        this.xFormsSupplier = (XFormsSupplier)UnoRuntime.queryInterface(XFormsSupplier.class, (Object)this.xDrawPage);
        this.xShapeGrouper = (XShapeGrouper)UnoRuntime.queryInterface(XShapeGrouper.class, (Object)this.xDrawPage);
        this.xControlAccess = (XControlAccess)UnoRuntime.queryInterface(XControlAccess.class, (Object)xTextDocument.getCurrentController());
        this.xMSFDoc = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xTextDocument);
        this.sModelServices[0] = "com.sun.star.form.component.FixedText";
        this.sModelServices[1] = "com.sun.star.form.component.TextField";
        this.sModelServices[2] = "com.sun.star.form.component.CheckBox";
        this.sModelServices[3] = "com.sun.star.form.component.DateField";
        this.sModelServices[4] = "com.sun.star.form.component.TimeField";
        this.sModelServices[5] = "com.sun.star.form.component.FormattedField";
        this.sModelServices[6] = "com.sun.star.form.component.GridControl";
        this.sModelServices[7] = "com.sun.star.form.component.DatabaseImageControl";
        oControlData = new ControlData[23];
        FormHandler.oControlData[0] = this.createControlData(-7, 2, CHECKBOX);
        FormHandler.oControlData[1] = this.createControlData(16, 2, CHECKBOX);
        FormHandler.oControlData[2] = this.createControlData(-6, 5, FORMATTEDFIELD);
        FormHandler.oControlData[3] = this.createControlData(5, 5, FORMATTEDFIELD);
        FormHandler.oControlData[4] = this.createControlData(4, 5, FORMATTEDFIELD);
        FormHandler.oControlData[5] = this.createControlData(-5, 5, FORMATTEDFIELD);
        FormHandler.oControlData[6] = this.createControlData(6, 5, FORMATTEDFIELD);
        FormHandler.oControlData[7] = this.createControlData(7, 5, FORMATTEDFIELD);
        FormHandler.oControlData[8] = this.createControlData(8, 5, FORMATTEDFIELD);
        FormHandler.oControlData[9] = this.createControlData(2, 5, FORMATTEDFIELD);
        FormHandler.oControlData[10] = this.createControlData(3, 5, FORMATTEDFIELD);
        FormHandler.oControlData[11] = this.createControlData(1, 1, TEXTFIELD);
        FormHandler.oControlData[12] = this.createControlData(12, 1, TEXTFIELD);
        FormHandler.oControlData[13] = this.createControlData(-1, 1, TEXTFIELD);
        FormHandler.oControlData[14] = this.createControlData(91, 3, DATEFIELD);
        FormHandler.oControlData[15] = this.createControlData(92, 4, TIMEFIELD);
        FormHandler.oControlData[16] = this.createControlData(93, 3, TEXTFIELD);
        FormHandler.oControlData[17] = this.createControlData(-2, 7, TEXTFIELD);
        FormHandler.oControlData[18] = this.createControlData(-3, 7, TEXTFIELD);
        FormHandler.oControlData[19] = this.createControlData(-4, 7, TEXTFIELD);
        FormHandler.oControlData[20] = this.createControlData(2004, 7, TEXTFIELD);
        FormHandler.oControlData[21] = this.createControlData(2005, 7, TEXTFIELD);
        FormHandler.oControlData[22] = this.createControlData(1111, 7, TEXTFIELD);
    }

    public int getControlType(int _fieldtype) {
        for (int i = 0; i < oControlData.length; ++i) {
            if (FormHandler.oControlData[i].DataType != _fieldtype) continue;
            return oControlData[i].ControlType;
        }
        return -1;
    }

    private void initializeBasicControlValues() {
        Control oLabelControl = new Control(this, 0, new Point(), new Size());
        XDevice xDevice = (XDevice)UnoRuntime.queryInterface(XDevice.class, (Object)oLabelControl.xWindowPeer);
        this.iXPixelFactor = (int)(100000.0 / xDevice.getInfo().PixelPerMeterX);
        this.iYPixelFactor = (int)(100000.0 / xDevice.getInfo().PixelPerMeterY);
        this.nLabelHeight = oLabelControl.getPreferredHeight("The quick brown fox...") + 1;
        Control oTextControl = new Control(this, 1, new Point(), new Size());
        this.nDBRefHeight = oTextControl.getPreferredHeight("The quick brown fox...") + 1;
        this.BasicLabelDiffHeight = (this.nDBRefHeight - this.nLabelHeight) / 2;
        this.xDrawPage.remove(oLabelControl.xShape);
        this.xDrawPage.remove(oTextControl.xShape);
    }

    private ControlData createControlData(int _datatype, int _controltype, String _gridcolumnname) {
        ControlData curControlData = new ControlData();
        curControlData.DataType = _datatype;
        curControlData.ControlType = _controltype;
        curControlData.GridColumnName = _gridcolumnname;
        return curControlData;
    }

    public XNameContainer getDocumentForms() {
        return this.xFormsSupplier.getForms();
    }

    public String getValueofHiddenControl(XNameAccess xNamedForm, String ControlName) {
        String value = "";
        try {
            if (xNamedForm.hasByName(ControlName)) {
                value = AnyConverter.toString((Object)Helper.getUnoPropertyValue(xNamedForm.getByName(ControlName), "HiddenValue"));
            }
        }
        catch (Exception ex) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        return value;
    }

    public void insertHiddenControl(XNameAccess xNameAccess, XNameContainer xNamedForm, String ControlName, String ControlValue) {
        try {
            XInterface xHiddenControl;
            if (xNameAccess.hasByName(ControlName)) {
                xHiddenControl = (XInterface)AnyConverter.toObject((Type)new Type(XInterface.class), (Object)xNameAccess.getByName(ControlName));
            } else {
                xHiddenControl = (XInterface)this.xMSFDoc.createInstance("com.sun.star.form.component.HiddenControl");
                xNamedForm.insertByName(ControlName, (Object)xHiddenControl);
            }
            Helper.setUnoPropertyValue(xHiddenControl, "HiddenValue", ControlValue);
        }
        catch (Exception ex) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private boolean hasFormByName(String _FormName) {
        XNameContainer xNamedFormContainer = this.getDocumentForms();
        this.xNamedForms = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xNamedFormContainer);
        return this.xNamedForms.hasByName(_FormName);
    }

    public void removeControlsofForm(String _FormName) {
        try {
            for (int i = this.xDrawPage.getCount() - 1; i >= 0; --i) {
                if (!this.belongsToForm(this.xDrawPage.getByIndex(i), _FormName)) continue;
                XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)this.xDrawPage.getByIndex(i));
                this.xDrawPage.remove(xShape);
            }
        }
        catch (Exception e) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void removeElement(XNameContainer _parentContainer, String _formName) {
        try {
            _parentContainer.removeByName(_formName);
        }
        catch (WrappedTargetException e) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, e);
        }
        catch (NoSuchElementException e) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    private boolean belongsToForm(Object _oDrawPageElement, String _FormName) {
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)_oDrawPageElement);
        while (xServiceInfo.supportsService("com.sun.star.drawing.GroupShape")) {
            XShapes xShapes = (XShapes)UnoRuntime.queryInterface(XShapes.class, (Object)_oDrawPageElement);
            try {
                _oDrawPageElement = xShapes.getByIndex(0);
                xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)_oDrawPageElement);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (xServiceInfo.supportsService("com.sun.star.drawing.ControlShape")) {
            XControlShape xControlShape = (XControlShape)UnoRuntime.queryInterface(XControlShape.class, (Object)_oDrawPageElement);
            XControlModel xControlModel = xControlShape.getControl();
            xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)xControlShape.getControl());
            if (xServiceInfo.supportsService("com.sun.star.form.FormComponent")) {
                XChild xChild = (XChild)UnoRuntime.queryInterface(XChild.class, (Object)xControlModel);
                XNamed xNamed = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)xChild.getParent());
                String sName = xNamed.getName();
                return _FormName.equals(sName);
            }
        }
        return false;
    }

    public XNameContainer insertFormbyName(String _FormName, XNameContainer _xNamedFormContainer) {
        try {
            if (!this.hasFormByName(_FormName)) {
                Object oDBForm = this.xMSFDoc.createInstance("com.sun.star.form.component.Form");
                _xNamedFormContainer.insertByName(_FormName, oDBForm);
                XNameContainer xNamedForm = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)oDBForm);
                return xNamedForm;
            }
            return this.getFormByName(_FormName);
        }
        catch (Exception e) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
    }

    public XNameContainer insertFormbyName(String _FormName) {
        return this.insertFormbyName(_FormName, this.getDocumentForms());
    }

    private XNameContainer getFormByName(String _sname) {
        XNameContainer xNamedForm = null;
        try {
            if (this.xNamedForms.hasByName(_sname)) {
                Object oDBForm = AnyConverter.toObject((Type)new Type(XInterface.class), (Object)Helper.getUnoObjectbyName(this.xNamedForms, _sname));
                xNamedForm = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)oDBForm);
            }
        }
        catch (IllegalArgumentException e) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, e);
        }
        return xNamedForm;
    }

    public int getXPixelFactor() {
        if (this.iXPixelFactor == -1) {
            this.initializeBasicControlValues();
        }
        return this.iXPixelFactor;
    }

    public int getYPixelFactor() {
        if (this.iYPixelFactor == -1) {
            this.initializeBasicControlValues();
        }
        return this.iYPixelFactor;
    }

    public void moveShapesToNirwana(Control[] ControlList) {
        if (ControlList != null) {
            for (int i = 0; i < ControlList.length; ++i) {
                if (ControlList[i] == null) continue;
                ControlList[i].setPosition(new Point(this.iXNirwanaPos, this.iYNirwanaPos));
            }
        }
    }

    public void removeShape(XShape _xShape) {
        this.xDrawPage.remove(_xShape);
        XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)_xShape);
        xComponent.dispose();
    }

    public XShape groupShapesTogether(XMultiServiceFactory _xMSF, XShape _xLabelShape, XShape _xControlShape) {
        try {
            Object oGroupShape = _xMSF.createInstance("com.sun.star.drawing.ShapeCollection");
            XShapes xShapes = (XShapes)UnoRuntime.queryInterface(XShapes.class, (Object)oGroupShape);
            xShapes.add(_xLabelShape);
            xShapes.add(_xControlShape);
            return this.xShapeGrouper.group(xShapes);
        }
        catch (Exception e) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
    }

    public int getBasicLabelDiffHeight() {
        if (this.BasicLabelDiffHeight == -1) {
            this.initializeBasicControlValues();
        }
        return this.BasicLabelDiffHeight;
    }

    public int getControlReferenceHeight() {
        if (this.nDBRefHeight == -1) {
            this.initializeBasicControlValues();
        }
        return this.nDBRefHeight;
    }

    public int getLabelHeight() {
        if (this.nLabelHeight == -1) {
            this.initializeBasicControlValues();
        }
        return this.nLabelHeight;
    }

    public void setDrawObjectsCaptureMode(boolean _bCaptureObjects) {
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xMSFDoc.createInstance("com.sun.star.text.DocumentSettings"));
            xPropertySet.setPropertyValue("DoNotCaptureDrawObjsOnPage", (Object)(!_bCaptureObjects ? 1 : 0));
        }
        catch (Exception e) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    static {
        SOSIZETEXT = "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog.";
    }

    public static class ControlData {
        int DataType;
        private int ControlType;
        String GridColumnName;
    }
}

