"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var wireJson = require('../../wire.json');
var squirrelUpdateInterval = {
    DELAY: 5 * 60 * 1000,
    INTERVAL: 24 * 60 * 60 * 1000,
};
exports.config = __assign({}, wireJson, { backendOrigins: ['https://staging-nginz-https.zinfra.io', 'https://prod-nginz-https.wire.com'], logFileName: 'console.log', maximumAccounts: parseInt(wireJson.maximumAccounts, 10), squirrelUpdateInterval: squirrelUpdateInterval, userAgent: 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36' });
//# sourceMappingURL=config.js.map