/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0015\u0010\u0005\u001a\u00020\u0006\"\n\b\u0000\u0010\u0007\u0018\u0001*\u00020\bH\u0086\b\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u001a\u0014\u0010\u0005\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0002\u001a-\u0010\f\u001a\u00020\r*\u00020\u00062\u0010\b\u0002\u0010\u000e\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012H\u0086\b\u001a-\u0010\u0013\u001a\u00020\r*\u00020\u00062\u0010\b\u0002\u0010\u000e\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012H\u0086\b\u001a(\u0010\u0014\u001a\u0004\u0018\u0001H\u0007\"\u0004\b\u0000\u0010\u0007*\u00020\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0012H\u0086\b\u00a2\u0006\u0002\u0010\u0016\" \u0010\u0000\u001a\u0006\u0012\u0002\b\u00030\u0001*\u0006\u0012\u0002\b\u00030\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0017"}, d2={"declaringClass", "Ljava/lang/Class;", "Lkotlin/reflect/KProperty;", "getDeclaringClass", "(Lkotlin/reflect/KProperty;)Ljava/lang/Class;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "T", "", "category", "", "field", "debug", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "lazyMessage", "Lkotlin/Function0;", "debugOrInfoIfTestMode", "runAndLogException", "runnable", "(Lcom/intellij/openapi/diagnostic/Logger;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.platform.util.ex"})
public final class LoggerKt {
    @NotNull
    public static final /* synthetic */ <T> Logger logger() {
        int $i$f$logger = 0;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Logger logger = Logger.getInstance(Object.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        return logger;
    }

    @NotNull
    public static final Logger logger(@NotNull String category) {
        Intrinsics.checkParameterIsNotNull((Object)category, (String)"category");
        Logger logger = Logger.getInstance((String)category);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(category)");
        return logger;
    }

    @NotNull
    public static final Logger logger(@NotNull KProperty<? extends Logger> field) {
        Intrinsics.checkParameterIsNotNull(field, (String)"field");
        Logger logger = Logger.getInstance(LoggerKt.getDeclaringClass(field));
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(field.declaringClass)");
        return logger;
    }

    private static final Class<?> getDeclaringClass(@NotNull KProperty<?> $this$declaringClass) {
        Member member;
        Field field = ReflectJvmMapping.getJavaField($this$declaringClass);
        if (field != null) {
            member = field;
        } else {
            Method method = ReflectJvmMapping.getJavaGetter($this$declaringClass);
            if (!(method instanceof Member)) {
                method = null;
            }
            member = method;
        }
        Class<Object> clazz = member != null ? member.getDeclaringClass() : null;
        if (clazz == null) {
            Intrinsics.throwNpe();
        }
        return clazz;
    }

    public static final void debug(@NotNull Logger $this$debug, @Nullable Exception e, @NotNull Function0<String> lazyMessage) {
        int $i$f$debug = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$debug, (String)"$this$debug");
        Intrinsics.checkParameterIsNotNull(lazyMessage, (String)"lazyMessage");
        if ($this$debug.isDebugEnabled()) {
            $this$debug.debug((String)lazyMessage.invoke(), (Throwable)e);
        }
    }

    public static /* synthetic */ void debug$default(Logger $this$debug, Exception e, Function0 lazyMessage, int n, Object object) {
        if ((n & 1) != 0) {
            e = null;
        }
        boolean $i$f$debug = false;
        Intrinsics.checkParameterIsNotNull((Object)$this$debug, (String)"$this$debug");
        Intrinsics.checkParameterIsNotNull((Object)lazyMessage, (String)"lazyMessage");
        if ($this$debug.isDebugEnabled()) {
            $this$debug.debug((String)lazyMessage.invoke(), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void debugOrInfoIfTestMode(@NotNull Logger $this$debugOrInfoIfTestMode, @Nullable Exception e, @NotNull Function0<String> lazyMessage) {
        int $i$f$debugOrInfoIfTestMode = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$debugOrInfoIfTestMode, (String)"$this$debugOrInfoIfTestMode");
        Intrinsics.checkParameterIsNotNull(lazyMessage, (String)"lazyMessage");
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            if (application.isUnitTestMode()) {
                $this$debugOrInfoIfTestMode.info((String)lazyMessage.invoke());
                return;
            }
        }
        Logger $this$debug$iv = $this$debugOrInfoIfTestMode;
        boolean $i$f$debug = false;
        if (!$this$debug$iv.isDebugEnabled()) return;
        $this$debug$iv.debug((String)lazyMessage.invoke(), (Throwable)e);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static /* synthetic */ void debugOrInfoIfTestMode$default(Logger $this$debugOrInfoIfTestMode, Exception e, Function0 lazyMessage, int n, Object object) {
        if ((n & 1) != 0) {
            e = null;
        }
        boolean $i$f$debugOrInfoIfTestMode = false;
        Intrinsics.checkParameterIsNotNull((Object)$this$debugOrInfoIfTestMode, (String)"$this$debugOrInfoIfTestMode");
        Intrinsics.checkParameterIsNotNull((Object)lazyMessage, (String)"lazyMessage");
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            if (application.isUnitTestMode()) {
                $this$debugOrInfoIfTestMode.info((String)lazyMessage.invoke());
                return;
            }
        }
        Logger $this$debug$iv = $this$debugOrInfoIfTestMode;
        boolean $i$f$debug = false;
        if (!$this$debug$iv.isDebugEnabled()) return;
        $this$debug$iv.debug((String)lazyMessage.invoke(), (Throwable)e);
    }

    @Nullable
    public static final <T> T runAndLogException(@NotNull Logger $this$runAndLogException, @NotNull Function0<? extends T> runnable) {
        int $i$f$runAndLogException = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$runAndLogException, (String)"$this$runAndLogException");
        Intrinsics.checkParameterIsNotNull(runnable, (String)"runnable");
        try {
            return (T)runnable.invoke();
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (CancellationException e) {
            throw (Throwable)e;
        }
        catch (Throwable e) {
            $this$runAndLogException.error(e);
            return null;
        }
    }
}

