/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.newImpl;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.newImpl.ActionButton;
import com.intellij.ui.tabs.newImpl.JBTabsImpl;
import com.intellij.ui.tabs.newImpl.TabLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.SwingUtilities;

public class ActionPanel
extends NonOpaquePanel {
    private final List<ActionButton> myButtons = new ArrayList<ActionButton>();
    private final JBTabsImpl myTabs;
    private boolean myAutoHide;
    private boolean myActionsIsVisible = false;

    public ActionPanel(JBTabsImpl tabs, TabInfo tabInfo, Consumer<MouseEvent> pass, Consumer<Boolean> hover) {
        this.myTabs = tabs;
        ActionGroup group = tabInfo.getTabLabelActions() != null ? tabInfo.getTabLabelActions() : new DefaultActionGroup();
        AnAction[] children = group.getChildren(null);
        NonOpaquePanel wrapper = new NonOpaquePanel(new BorderLayout());
        wrapper.add(Box.createHorizontalStrut(2), "West");
        NonOpaquePanel inner = new NonOpaquePanel();
        inner.setLayout(new BoxLayout(inner, 0));
        wrapper.add((Component)inner, "Center");
        for (AnAction each : children) {
            ActionButton eachButton = new ActionButton(this.myTabs, tabInfo, each, tabInfo.getTabActionPlace(), pass, hover, tabs.getTabActionsMouseDeadzone()){

                @Override
                protected void repaintComponent(Component c) {
                    TabLabel tabLabel = (TabLabel)SwingUtilities.getAncestorOfClass(TabLabel.class, c);
                    if (tabLabel != null) {
                        Point point = SwingUtilities.convertPoint(c, new Point(0, 0), tabLabel);
                        Dimension d = c.getSize();
                        tabLabel.repaint(point.x, point.y, d.width, d.height);
                    } else {
                        super.repaintComponent(c);
                    }
                }
            };
            this.myButtons.add(eachButton);
            InplaceButton component = eachButton.getComponent();
            inner.add(component);
        }
        this.add(wrapper);
    }

    public boolean update() {
        boolean changed = false;
        boolean anyVisible = false;
        for (ActionButton each : this.myButtons) {
            changed |= each.update();
            each.setMouseDeadZone(this.myTabs.getTabActionsMouseDeadzone());
            anyVisible |= each.getComponent().isVisible();
        }
        this.myActionsIsVisible = anyVisible;
        return changed;
    }

    public boolean isAutoHide() {
        return this.myAutoHide;
    }

    public void setAutoHide(boolean autoHide) {
        this.myAutoHide = autoHide;
        for (ActionButton each : this.myButtons) {
            each.setAutoHide(this.myAutoHide);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.myActionsIsVisible ? super.getPreferredSize() : new Dimension(0, 0);
    }

    public void toggleShowActions(boolean show) {
        for (ActionButton each : this.myButtons) {
            each.toggleShowActions(show);
        }
    }
}

