/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Setter;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.awt.GridLayout;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BeanConfigurable<T>
implements UnnamedConfigurable {
    private final T myInstance;
    private final List<BeanField> myFields;

    protected BeanConfigurable(@NotNull T beanInstance) {
        if (beanInstance == null) {
            BeanConfigurable.$$$reportNull$$$0(0);
        }
        this.myFields = new ArrayList<BeanField>();
        this.myInstance = beanInstance;
    }

    protected BeanConfigurable() {
        this.myFields = new ArrayList<BeanField>();
        this.myInstance = null;
    }

    @Nullable
    protected T getInstance() {
        return this.myInstance;
    }

    @Deprecated
    protected void checkBox(@NonNls String fieldName, String title) {
        this.myFields.add(new CheckboxField(fieldName, title));
    }

    protected void checkBox(@NotNull String title, @NotNull Getter<Boolean> getter, @NotNull Setter<Boolean> setter) {
        if (title == null) {
            BeanConfigurable.$$$reportNull$$$0(1);
        }
        if (getter == null) {
            BeanConfigurable.$$$reportNull$$$0(2);
        }
        if (setter == null) {
            BeanConfigurable.$$$reportNull$$$0(3);
        }
        CheckboxField field = new CheckboxField(new BeanMethodAccessor(getter, setter), title);
        this.myFields.add(field);
    }

    protected void checkBox(@NotNull String title, @NotNull KMutableProperty0<Boolean> prop) {
        if (title == null) {
            BeanConfigurable.$$$reportNull$$$0(4);
        }
        if (prop == null) {
            BeanConfigurable.$$$reportNull$$$0(5);
        }
        this.myFields.add(new CheckboxField(new BeanKPropertyAccessor(prop), title));
    }

    protected <V> void component(final @NotNull JComponent component, @NotNull Getter<? extends V> beanGetter, @NotNull Setter<? super V> beanSetter, final @NotNull Getter<? extends V> componentGetter, final @NotNull Setter<? super V> componentSetter) {
        if (component == null) {
            BeanConfigurable.$$$reportNull$$$0(6);
        }
        if (beanGetter == null) {
            BeanConfigurable.$$$reportNull$$$0(7);
        }
        if (beanSetter == null) {
            BeanConfigurable.$$$reportNull$$$0(8);
        }
        if (componentGetter == null) {
            BeanConfigurable.$$$reportNull$$$0(9);
        }
        if (componentSetter == null) {
            BeanConfigurable.$$$reportNull$$$0(10);
        }
        BeanField<JComponent> field = new BeanField<JComponent>(new BeanMethodAccessor(beanGetter, beanSetter)){

            @Override
            @NotNull
            JComponent createComponent() {
                JComponent jComponent = component;
                if (jComponent == null) {
                    1.$$$reportNull$$$0(0);
                }
                return jComponent;
            }

            @Override
            Object getComponentValue() {
                return componentGetter.get();
            }

            @Override
            void setComponentValue(Object value) {
                componentSetter.set(value);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/BeanConfigurable$1", "createComponent"));
            }
        };
        this.myFields.add(field);
    }

    @Override
    public JComponent createComponent() {
        JPanel panel2 = new JPanel(new GridLayout(this.myFields.size(), 1));
        for (BeanField field : this.myFields) {
            panel2.add((Component)field.getComponent());
        }
        return panel2;
    }

    @Override
    public boolean isModified() {
        for (BeanField field : this.myFields) {
            if (!field.isModified(this.myInstance)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void apply() throws ConfigurationException {
        for (BeanField field : this.myFields) {
            field.apply(this.myInstance);
        }
    }

    @Override
    public void reset() {
        for (BeanField field : this.myFields) {
            field.reset(this.myInstance);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanInstance";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanGetter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanSetter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentGetter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentSetter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/options/BeanConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkBox";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "component";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CheckboxField
    extends BeanField<JCheckBox> {
        private final String myTitle;

        private CheckboxField(String fieldName, String title) {
            super(new BeanFieldAccessor(fieldName, Boolean.TYPE));
            this.myTitle = title;
        }

        private CheckboxField(BeanPropertyAccessor accessor, String title) {
            super(accessor);
            this.myTitle = title;
        }

        @Override
        @NotNull
        JCheckBox createComponent() {
            JCheckBox jCheckBox = new JCheckBox(this.myTitle);
            if (jCheckBox == null) {
                CheckboxField.$$$reportNull$$$0(0);
            }
            return jCheckBox;
        }

        @Override
        Object getComponentValue() {
            return ((JCheckBox)this.getComponent()).isSelected();
        }

        @Override
        void setComponentValue(Object value) {
            ((JCheckBox)this.getComponent()).setSelected((Boolean)value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/BeanConfigurable$CheckboxField", "createComponent"));
        }
    }

    private static abstract class BeanField<T extends JComponent> {
        BeanPropertyAccessor myAccessor;
        T myComponent;

        private BeanField(BeanPropertyAccessor accessor) {
            this.myAccessor = accessor;
        }

        T getComponent() {
            if (this.myComponent == null) {
                this.myComponent = this.createComponent();
            }
            return this.myComponent;
        }

        @NotNull
        abstract T createComponent();

        boolean isModified(Object instance) {
            Object beanValue;
            Object componentValue = this.getComponentValue();
            return !Comparing.equal((Object)componentValue, (Object)(beanValue = this.myAccessor.getBeanValue(instance)));
        }

        void apply(Object instance) {
            this.myAccessor.setBeanValue(instance, this.getComponentValue());
        }

        void reset(Object instance) {
            this.setComponentValue(this.myAccessor.getBeanValue(instance));
        }

        abstract Object getComponentValue();

        abstract void setComponentValue(Object var1);
    }

    private static class BeanKPropertyAccessor<T>
    extends BeanPropertyAccessor {
        private final KMutableProperty0<T> myProperty;

        private BeanKPropertyAccessor(KMutableProperty0<T> property) {
            this.myProperty = property;
        }

        @Override
        Object getBeanValue(Object instance) {
            return this.myProperty.get();
        }

        @Override
        void setBeanValue(Object instance, @NotNull Object value) {
            if (value == null) {
                BeanKPropertyAccessor.$$$reportNull$$$0(0);
            }
            this.myProperty.set(value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/options/BeanConfigurable$BeanKPropertyAccessor", "setBeanValue"));
        }
    }

    private static class BeanMethodAccessor<T>
    extends BeanPropertyAccessor {
        private final Getter<? extends T> myGetter;
        private final Setter<? super T> mySetter;

        private BeanMethodAccessor(Getter<? extends T> getter, Setter<? super T> setter) {
            this.myGetter = getter;
            this.mySetter = setter;
        }

        @Override
        Object getBeanValue(Object instance) {
            return this.myGetter.get();
        }

        @Override
        void setBeanValue(Object instance, @NotNull Object value) {
            if (value == null) {
                BeanMethodAccessor.$$$reportNull$$$0(0);
            }
            this.mySetter.set(value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/options/BeanConfigurable$BeanMethodAccessor", "setBeanValue"));
        }
    }

    private static class BeanFieldAccessor
    extends BeanPropertyAccessor {
        private final String myFieldName;
        private final Class myValueClass;

        private BeanFieldAccessor(String fieldName, Class valueClass) {
            this.myFieldName = fieldName;
            this.myValueClass = valueClass;
        }

        @NonNls
        protected String getterName() {
            if (this.myValueClass.equals(Boolean.TYPE)) {
                return "is" + StringUtil.capitalize((String)this.myFieldName);
            }
            return "get" + StringUtil.capitalize((String)this.myFieldName);
        }

        @Override
        Object getBeanValue(@NotNull Object instance) {
            if (instance == null) {
                BeanFieldAccessor.$$$reportNull$$$0(0);
            }
            try {
                Field field = instance.getClass().getField(this.myFieldName);
                return field.get(instance);
            }
            catch (NoSuchFieldException e) {
                try {
                    Method method = instance.getClass().getMethod(this.getterName(), new Class[0]);
                    return method.invoke(instance, new Object[0]);
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        void setBeanValue(@NotNull Object instance, @NotNull Object value) {
            if (instance == null) {
                BeanFieldAccessor.$$$reportNull$$$0(1);
            }
            if (value == null) {
                BeanFieldAccessor.$$$reportNull$$$0(2);
            }
            try {
                Field field = instance.getClass().getField(this.myFieldName);
                field.set(instance, value);
            }
            catch (NoSuchFieldException e) {
                try {
                    Method method = instance.getClass().getMethod("set" + StringUtil.capitalize((String)this.myFieldName), this.myValueClass);
                    method.invoke(instance, value);
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instance";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/options/BeanConfigurable$BeanFieldAccessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getBeanValue";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setBeanValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class BeanPropertyAccessor {
        private BeanPropertyAccessor() {
        }

        abstract Object getBeanValue(Object var1);

        abstract void setBeanValue(Object var1, @NotNull Object var2);
    }
}

