/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentProvider;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExecutionEnvironmentBuilder {
    private RunProfile myRunProfile;
    @NotNull
    private ExecutionTarget myTarget;
    @NotNull
    private final Project myProject;
    @Nullable
    private RunnerSettings myRunnerSettings;
    @Nullable
    private ConfigurationPerRunnerSettings myConfigurationSettings;
    @Nullable
    private RunContentDescriptor myContentToReuse;
    @Nullable
    private RunnerAndConfigurationSettings myRunnerAndConfigurationSettings;
    private ProgramRunner<?> myRunner;
    private boolean myAssignNewId;
    @Nullable
    private Long myExecutionId;
    @NotNull
    private Executor myExecutor;
    @Nullable
    private DataContext myDataContext;
    private final UserDataHolderBase myUserData;

    public ExecutionEnvironmentBuilder(@NotNull Project project, @NotNull Executor executor) {
        if (project == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(0);
        }
        if (executor == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(1);
        }
        this.myTarget = DefaultExecutionTarget.INSTANCE;
        this.myExecutionId = null;
        this.myUserData = new UserDataHolderBase();
        this.myProject = project;
        this.myExecutor = executor;
    }

    @NotNull
    public static ExecutionEnvironmentBuilder create(@NotNull Project project, @NotNull Executor executor, @NotNull RunProfile runProfile) throws ExecutionException {
        ExecutionEnvironmentBuilder builder;
        if (project == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(2);
        }
        if (executor == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(3);
        }
        if (runProfile == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(4);
        }
        if ((builder = ExecutionEnvironmentBuilder.createOrNull(project, executor, runProfile)) == null) {
            throw new ExecutionException("Cannot find runner for " + runProfile.getName());
        }
        ExecutionEnvironmentBuilder executionEnvironmentBuilder = builder;
        if (executionEnvironmentBuilder == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(5);
        }
        return executionEnvironmentBuilder;
    }

    @Nullable
    public static ExecutionEnvironmentBuilder createOrNull(@NotNull Project project, @NotNull Executor executor, @NotNull RunProfile runProfile) {
        ProgramRunner<RunnerSettings> runner;
        if (project == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(6);
        }
        if (executor == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(7);
        }
        if (runProfile == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(8);
        }
        if ((runner = ProgramRunner.getRunner(executor.getId(), runProfile)) == null) {
            return null;
        }
        return new ExecutionEnvironmentBuilder(project, executor).runner(runner).runProfile(runProfile);
    }

    @Nullable
    public static ExecutionEnvironmentBuilder createOrNull(@NotNull Executor executor, @NotNull RunnerAndConfigurationSettings settings) {
        ExecutionEnvironmentBuilder builder;
        if (executor == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(10);
        }
        return (builder = ExecutionEnvironmentBuilder.createOrNull(executor, settings.getConfiguration())) == null ? null : builder.runnerAndSettings(builder.myRunner, settings);
    }

    @Nullable
    public static ExecutionEnvironmentBuilder createOrNull(@NotNull Executor executor, @NotNull RunConfiguration configuration) {
        ExecutionEnvironmentBuilder builder;
        if (executor == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(11);
        }
        if (configuration == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(12);
        }
        if ((builder = ExecutionEnvironmentBuilder.createOrNull(configuration.getProject(), executor, configuration)) != null) {
            builder.runProfile(configuration);
        }
        return builder;
    }

    @NotNull
    public static ExecutionEnvironmentBuilder create(@NotNull Executor executor, @NotNull RunnerAndConfigurationSettings settings) throws ExecutionException {
        if (executor == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(13);
        }
        if (settings == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(14);
        }
        RunConfiguration configuration = settings.getConfiguration();
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.create(configuration.getProject(), executor, configuration);
        ExecutionEnvironmentBuilder executionEnvironmentBuilder = builder.runnerAndSettings(builder.myRunner, settings);
        if (executionEnvironmentBuilder == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(15);
        }
        return executionEnvironmentBuilder;
    }

    @NotNull
    public static ExecutionEnvironmentBuilder create(@NotNull Executor executor, @NotNull RunConfiguration configuration) {
        if (executor == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(16);
        }
        if (configuration == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(17);
        }
        ExecutionEnvironmentBuilder executionEnvironmentBuilder = new ExecutionEnvironmentBuilder(configuration.getProject(), executor).runProfile(configuration);
        if (executionEnvironmentBuilder == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(18);
        }
        return executionEnvironmentBuilder;
    }

    @NotNull
    Executor getExecutor() {
        Executor executor = this.myExecutor;
        if (executor == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(19);
        }
        return executor;
    }

    public ExecutionEnvironmentBuilder(@NotNull ExecutionEnvironment copySource) {
        if (copySource == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(20);
        }
        this.myTarget = DefaultExecutionTarget.INSTANCE;
        this.myExecutionId = null;
        this.myUserData = new UserDataHolderBase();
        this.myTarget = copySource.getExecutionTarget();
        this.myProject = copySource.getProject();
        this.myRunnerAndConfigurationSettings = copySource.getRunnerAndConfigurationSettings();
        this.myRunProfile = copySource.getRunProfile();
        this.myRunnerSettings = copySource.getRunnerSettings();
        this.myConfigurationSettings = copySource.getConfigurationSettings();
        this.myRunner = copySource.getRunner();
        this.myContentToReuse = copySource.getContentToReuse();
        this.myExecutor = copySource.getExecutor();
        copySource.copyUserDataTo(this.myUserData);
    }

    public ExecutionEnvironmentBuilder target(@Nullable ExecutionTarget target) {
        if (target != null) {
            this.myTarget = target;
        }
        return this;
    }

    public ExecutionEnvironmentBuilder activeTarget() {
        this.myTarget = ExecutionTargetManager.getActiveTarget(this.myProject);
        return this;
    }

    @NotNull
    public ExecutionEnvironmentBuilder runnerAndSettings(@NotNull ProgramRunner runner, @NotNull RunnerAndConfigurationSettings settings) {
        if (runner == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(21);
        }
        if (settings == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(22);
        }
        this.myRunnerAndConfigurationSettings = settings;
        this.myRunProfile = settings.getConfiguration();
        this.myRunnerSettings = settings.getRunnerSettings(runner);
        this.myConfigurationSettings = settings.getConfigurationSettings(runner);
        this.myRunner = runner;
        ExecutionEnvironmentBuilder executionEnvironmentBuilder = this;
        if (executionEnvironmentBuilder == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(23);
        }
        return executionEnvironmentBuilder;
    }

    public ExecutionEnvironmentBuilder runnerSettings(@Nullable RunnerSettings runnerSettings) {
        this.myRunnerSettings = runnerSettings;
        return this;
    }

    public ExecutionEnvironmentBuilder contentToReuse(@Nullable RunContentDescriptor contentToReuse) {
        this.myContentToReuse = contentToReuse;
        return this;
    }

    public ExecutionEnvironmentBuilder runProfile(@NotNull RunProfile runProfile) {
        if (runProfile == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(24);
        }
        this.myRunProfile = runProfile;
        return this;
    }

    @NotNull
    public ExecutionEnvironmentBuilder runner(@NotNull ProgramRunner<?> runner) {
        if (runner == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(25);
        }
        this.myRunner = runner;
        ExecutionEnvironmentBuilder executionEnvironmentBuilder = this;
        if (executionEnvironmentBuilder == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(26);
        }
        return executionEnvironmentBuilder;
    }

    public ExecutionEnvironmentBuilder dataContext(@Nullable DataContext dataContext) {
        this.myDataContext = dataContext;
        return this;
    }

    public ExecutionEnvironmentBuilder executor(@NotNull Executor executor) {
        if (executor == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(27);
        }
        this.myExecutor = executor;
        return this;
    }

    public ExecutionEnvironmentBuilder executionId(long executionId) {
        this.myExecutionId = executionId;
        this.myAssignNewId = false;
        return this;
    }

    @NotNull
    public ExecutionEnvironment build() {
        ExecutionEnvironment environment = null;
        ExecutionEnvironmentProvider environmentProvider = ServiceManager.getService(this.myProject, ExecutionEnvironmentProvider.class);
        if (environmentProvider != null) {
            environment = environmentProvider.createExecutionEnvironment(this.myProject, this.myRunProfile, this.myExecutor, this.myTarget, this.myRunnerSettings, this.myConfigurationSettings, this.myRunnerAndConfigurationSettings);
        }
        if (environment == null && this.myRunner == null) {
            this.myRunner = ProgramRunner.getRunner(this.myExecutor.getId(), this.myRunProfile);
        }
        if (environment == null && this.myRunner == null) {
            throw new IllegalStateException("Runner must be specified");
        }
        if (environment == null) {
            environment = new ExecutionEnvironment(this.myRunProfile, this.myExecutor, this.myTarget, this.myProject, this.myRunnerSettings, this.myConfigurationSettings, this.myContentToReuse, this.myRunnerAndConfigurationSettings, this.myRunner);
        }
        if (this.myAssignNewId) {
            environment.assignNewExecutionId();
        }
        if (this.myExecutionId != null) {
            environment.setExecutionId(this.myExecutionId);
        }
        if (this.myDataContext != null) {
            environment.setDataContext(this.myDataContext);
        }
        this.myUserData.copyUserDataTo((UserDataHolderBase)environment);
        ExecutionEnvironment executionEnvironment = environment;
        if (executionEnvironment == null) {
            ExecutionEnvironmentBuilder.$$$reportNull$$$0(28);
        }
        return executionEnvironment;
    }

    public void buildAndExecute() throws ExecutionException {
        ExecutionEnvironment environment = this.build();
        this.myRunner.execute(environment);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: 
            case 8: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runProfile";
                break;
            }
            case 5: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/runners/ExecutionEnvironmentBuilder";
                break;
            }
            case 10: 
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copySource";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/runners/ExecutionEnvironmentBuilder";
                break;
            }
            case 5: 
            case 15: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutor";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "runnerAndSettings";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "runner";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 28: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createOrNull";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "runnerAndSettings";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "runProfile";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "runner";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "executor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

