/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider.commit;

import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.commit.AbstractCommitWorkflowKt;
import com.intellij.vcs.commit.AmendCommitAware;
import com.intellij.vcs.commit.AmendCommitHandler;
import com.intellij.vcs.commit.AmendCommitModeListener;
import com.intellij.vcs.commit.ToggleAmendCommitOption;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgChange;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.HgActionUtil;
import org.zmlx.hg4idea.command.HgAddCommand;
import org.zmlx.hg4idea.command.HgCommitCommand;
import org.zmlx.hg4idea.command.HgCommitTypeCommand;
import org.zmlx.hg4idea.command.HgRemoveCommand;
import org.zmlx.hg4idea.command.HgStatusCommand;
import org.zmlx.hg4idea.command.HgWorkingCopyRevisionsCommand;
import org.zmlx.hg4idea.command.mq.HgQNewCommand;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.provider.HgCurrentBinaryContentRevision;
import org.zmlx.hg4idea.provider.commit.HgCommitAndPushExecutorKt;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCheckinEnvironment
implements CheckinEnvironment,
AmendCommitAware {
    @NotNull
    private final HgVcs myVcs;
    @NotNull
    private final Project myProject;
    private boolean myShouldCommitSubrepos;
    private boolean myMqNewPatch;
    private boolean myCloseBranch;
    @Nullable
    private Collection<HgRepository> myRepos;

    public HgCheckinEnvironment(@NotNull HgVcs vcs) {
        if (vcs == null) {
            HgCheckinEnvironment.$$$reportNull$$$0(0);
        }
        this.myVcs = vcs;
        this.myProject = vcs.getProject();
    }

    @Nullable
    public RefreshableOnComponent createCommitOptions(@NotNull CheckinProjectPanel commitPanel, @NotNull CommitContext commitContext) {
        if (commitPanel == null) {
            HgCheckinEnvironment.$$$reportNull$$$0(1);
        }
        if (commitContext == null) {
            HgCheckinEnvironment.$$$reportNull$$$0(2);
        }
        this.reset();
        List<HgRepository> repos = HgActionUtil.collectRepositoriesFromFiles(HgUtil.getRepositoryManager(this.myProject), commitPanel.getRoots());
        boolean hasSubrepos = ContainerUtil.exists(repos, HgRepository::hasSubrepos);
        boolean showAmendOption = ToggleAmendCommitOption.isAmendCommitOptionSupported((CheckinProjectPanel)commitPanel, (AmendCommitAware)this);
        if (!hasSubrepos && !showAmendOption) {
            return null;
        }
        return new HgCommitAdditionalComponent(commitPanel, hasSubrepos, showAmendOption);
    }

    private void reset() {
        this.myShouldCommitSubrepos = false;
        this.myCloseBranch = false;
        this.myMqNewPatch = false;
        this.myRepos = null;
    }

    public String getHelpId() {
        return null;
    }

    public String getCheckinOperationName() {
        return HgVcsMessages.message("hg4idea.commit", new Object[0]);
    }

    public boolean isAmendCommitSupported() {
        return this.myVcs.getVersion().isAmendSupported();
    }

    @Nullable
    public String getLastCommitMessage(@NotNull VirtualFile root) {
        if (root == null) {
            HgCheckinEnvironment.$$$reportNull$$$0(3);
        }
        HgCommandExecutor commandExecutor = new HgCommandExecutor(this.myProject);
        ArrayList<String> args = new ArrayList<String>();
        args.add("-r");
        args.add(".");
        args.add("--template");
        args.add("{desc}");
        HgCommandResult result = commandExecutor.executeInCurrentThread(root, "log", args);
        return result == null ? "" : result.getRawOutput();
    }

    @NotNull
    public List<VcsException> commit(@NotNull List<Change> changes, @NotNull String commitMessage, @NotNull CommitContext commitContext, @NotNull Set<String> feedback) {
        if (changes == null) {
            HgCheckinEnvironment.$$$reportNull$$$0(4);
        }
        if (commitMessage == null) {
            HgCheckinEnvironment.$$$reportNull$$$0(5);
        }
        if (commitContext == null) {
            HgCheckinEnvironment.$$$reportNull$$$0(6);
        }
        if (feedback == null) {
            HgCheckinEnvironment.$$$reportNull$$$0(7);
        }
        LinkedList<VcsException> exceptions = new LinkedList<VcsException>();
        Map<HgRepository, Set<HgFile>> repositoriesMap = this.getFilesByRepository(changes);
        this.addRepositoriesWithoutChanges(repositoriesMap);
        boolean isAmend = AbstractCommitWorkflowKt.isAmendCommitMode((CommitContext)commitContext);
        for (Map.Entry<HgRepository, Set<HgFile>> entry : repositoriesMap.entrySet()) {
            HgCommitTypeCommand command;
            HgRepository repo = entry.getKey();
            Set<HgFile> selectedFiles = entry.getValue();
            HgCommitTypeCommand hgCommitTypeCommand = this.myMqNewPatch ? new HgQNewCommand(this.myProject, repo, commitMessage, isAmend) : (command = new HgCommitCommand(this.myProject, repo, commitMessage, isAmend, this.myCloseBranch, this.myShouldCommitSubrepos && !selectedFiles.isEmpty()));
            if (this.isMergeCommit(repo.getRoot())) {
                boolean partial;
                Set<HgFile> changedFilesNotInCommit = this.getChangedFilesNotInCommit(repo.getRoot(), selectedFiles);
                boolean bl = partial = !changedFilesNotInCommit.isEmpty();
                if (partial) {
                    StringBuilder filesNotIncludedString = new StringBuilder();
                    for (HgFile hgFile : changedFilesNotInCommit) {
                        filesNotIncludedString.append("<li>");
                        filesNotIncludedString.append(hgFile.getRelativePath());
                        filesNotIncludedString.append("</li>");
                    }
                    if (!this.mayCommitEverything(filesNotIncludedString.toString())) {
                        LinkedList<VcsException> linkedList = exceptions;
                        if (linkedList == null) {
                            HgCheckinEnvironment.$$$reportNull$$$0(8);
                        }
                        return linkedList;
                    }
                    VcsDirtyScopeManager dirtyManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
                    for (HgFile hgFile : changedFilesNotInCommit) {
                        dirtyManager.fileDirty(hgFile.toFilePath());
                    }
                }
            } else {
                command.setFiles(selectedFiles);
            }
            try {
                command.executeInCurrentThread();
            }
            catch (HgCommandException e) {
                exceptions.add(new VcsException((Throwable)e));
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        if (HgCommitAndPushExecutorKt.isPushAfterCommit(commitContext) && exceptions.isEmpty()) {
            ArrayList<HgRepository> preselectedRepositories = new ArrayList<HgRepository>(repositoriesMap.keySet());
            GuiUtils.invokeLaterIfNeeded(() -> new VcsPushDialog(this.myProject, preselectedRepositories, (Repository)HgUtil.getCurrentRepository(this.myProject)).show(), (ModalityState)ModalityState.defaultModalityState());
        }
        LinkedList<VcsException> linkedList = exceptions;
        if (linkedList == null) {
            HgCheckinEnvironment.$$$reportNull$$$0(9);
        }
        return linkedList;
    }

    private boolean isMergeCommit(VirtualFile repo) {
        return new HgWorkingCopyRevisionsCommand(this.myProject).parents(repo).size() > 1;
    }

    private Set<HgFile> getChangedFilesNotInCommit(VirtualFile repo, Set<HgFile> selectedFiles) {
        List<HgRevisionNumber> parents = new HgWorkingCopyRevisionsCommand(this.myProject).parents(repo);
        HgStatusCommand statusCommand = new HgStatusCommand.Builder(true).unknown(false).ignored(false).baseRevision(parents.get(0)).build(this.myProject);
        Set<HgChange> allChangedFilesInRepo = statusCommand.executeInCurrentThread(repo);
        HashSet<HgFile> filesNotIncluded = new HashSet<HgFile>();
        for (HgChange change : allChangedFilesInRepo) {
            HgFile beforeFile = change.beforeFile();
            HgFile afterFile = change.afterFile();
            if (!selectedFiles.contains(beforeFile)) {
                filesNotIncluded.add(beforeFile);
                continue;
            }
            if (selectedFiles.contains(afterFile)) continue;
            filesNotIncluded.add(afterFile);
        }
        return filesNotIncluded;
    }

    private boolean mayCommitEverything(String filesNotIncludedString) {
        int[] choice = new int[1];
        Runnable runnable = () -> {
            choice[0] = Messages.showOkCancelDialog((Project)this.myProject, (String)HgVcsMessages.message("hg4idea.commit.partial.merge.message", filesNotIncludedString), (String)HgVcsMessages.message("hg4idea.commit.partial.merge.title", new Object[0]), null);
        };
        ApplicationManager.getApplication().invokeAndWait(runnable);
        return choice[0] == 0;
    }

    public List<VcsException> scheduleMissingFileForDeletion(@NotNull List<FilePath> files) {
        if (files == null) {
            HgCheckinEnvironment.$$$reportNull$$$0(10);
        }
        final ArrayList<HgFile> filesWithRoots = new ArrayList<HgFile>();
        for (FilePath filePath : files) {
            VirtualFile vcsRoot = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)filePath);
            if (vcsRoot == null) continue;
            filesWithRoots.add(new HgFile(vcsRoot, filePath));
        }
        new Task.Backgroundable(this.myProject, "Removing Files..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                new HgRemoveCommand(this.myProject).executeInCurrentThread(filesWithRoots);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment$1", "run"));
            }
        }.queue();
        return null;
    }

    public List<VcsException> scheduleUnversionedFilesForAddition(@NotNull List<VirtualFile> files) {
        if (files == null) {
            HgCheckinEnvironment.$$$reportNull$$$0(11);
        }
        new HgAddCommand(this.myProject).addWithProgress(files);
        return null;
    }

    public boolean isRefreshAfterCommitNeeded() {
        return false;
    }

    @NotNull
    private Map<HgRepository, Set<HgFile>> getFilesByRepository(List<Change> changes) {
        HashMap<HgRepository, Set<HgFile>> result = new HashMap<HgRepository, Set<HgFile>>();
        for (Change change : changes) {
            ContentRevision afterRevision = change.getAfterRevision();
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (afterRevision != null) {
                this.addFile(result, afterRevision);
            }
            if (beforeRevision == null) continue;
            this.addFile(result, beforeRevision);
        }
        HashMap<HgRepository, Set<HgFile>> hashMap = result;
        if (hashMap == null) {
            HgCheckinEnvironment.$$$reportNull$$$0(12);
        }
        return hashMap;
    }

    private void addFile(Map<HgRepository, Set<HgFile>> result, ContentRevision contentRevision) {
        FilePath filePath = contentRevision.getFile();
        HgRepository repo = HgUtil.getRepositoryForFile(this.myProject, contentRevision instanceof HgCurrentBinaryContentRevision ? ((HgCurrentBinaryContentRevision)contentRevision).getRepositoryRoot() : ChangesUtil.findValidParentAccurately((FilePath)filePath));
        if (repo == null) {
            return;
        }
        Set<HgFile> hgFiles = result.get(repo);
        if (hgFiles == null) {
            hgFiles = new HashSet<HgFile>();
            result.put(repo, hgFiles);
        }
        hgFiles.add(new HgFile(repo.getRoot(), filePath));
    }

    public void setMqNew() {
        this.myMqNewPatch = true;
    }

    public void setCloseBranch(boolean closeBranch) {
        this.myCloseBranch = closeBranch;
    }

    public void setRepos(@NotNull Collection<HgRepository> repos) {
        if (repos == null) {
            HgCheckinEnvironment.$$$reportNull$$$0(13);
        }
        this.myRepos = repos;
    }

    private void addRepositoriesWithoutChanges(@NotNull Map<HgRepository, Set<HgFile>> repositoryMap) {
        if (repositoryMap == null) {
            HgCheckinEnvironment.$$$reportNull$$$0(14);
        }
        if (this.myRepos == null) {
            return;
        }
        for (HgRepository repository : this.myRepos) {
            if (repositoryMap.keySet().contains(repository)) continue;
            repositoryMap.put(repository, Collections.emptySet());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitPanel";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitMessage";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feedback";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repos";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "commit";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesByRepository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCommitOptions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommitMessage";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "scheduleMissingFileForDeletion";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "scheduleUnversionedFilesForAddition";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setRepos";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addRepositoriesWithoutChanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class HgCommitAdditionalComponent
    implements RefreshableOnComponent,
    AmendCommitModeListener,
    Disposable {
        @NotNull
        private final JPanel myPanel;
        @NotNull
        private final JCheckBox myCommitSubrepos;
        @NotNull
        private final CheckinProjectPanel myCommitPanel;
        @Nullable
        private final ToggleAmendCommitOption myAmendOption;

        HgCommitAdditionalComponent(CheckinProjectPanel panel, boolean hasSubrepos, boolean showAmendOption) {
            if (panel == null) {
                HgCommitAdditionalComponent.$$$reportNull$$$0(0);
            }
            this.myCommitPanel = panel;
            this.myAmendOption = showAmendOption ? new ToggleAmendCommitOption(this.myCommitPanel, (Disposable)this) : null;
            this.myCommitSubrepos = new JCheckBox("Commit subrepositories", false);
            this.myCommitSubrepos.setVisible(hasSubrepos);
            this.myCommitSubrepos.setToolTipText(XmlStringUtil.wrapInHtml((CharSequence)"Commit all subrepos for selected repositories.<br> <code>hg ci <i><b>files</b></i> -S <i><b>subrepos</b></i></code>"));
            this.myCommitSubrepos.setMnemonic('s');
            this.myCommitSubrepos.addActionListener(e -> this.updateAmendState(!this.myCommitSubrepos.isSelected()));
            GridBag gb = new GridBag().setDefaultInsets((Insets)JBUI.insets((int)2)).setDefaultAnchor(17).setDefaultWeightX(1.0).setDefaultFill(2);
            this.myPanel = new JPanel(new GridBagLayout());
            if (this.myAmendOption != null) {
                this.myPanel.add((Component)this.myAmendOption, gb.nextLine().next());
            }
            this.myPanel.add((Component)this.myCommitSubrepos, gb.nextLine().next());
            this.getAmendHandler().addAmendCommitModeListener((AmendCommitModeListener)this, (Disposable)this);
        }

        @NotNull
        private AmendCommitHandler getAmendHandler() {
            AmendCommitHandler amendCommitHandler = this.myCommitPanel.getCommitWorkflowHandler().getAmendCommitHandler();
            if (amendCommitHandler == null) {
                HgCommitAdditionalComponent.$$$reportNull$$$0(1);
            }
            return amendCommitHandler;
        }

        public void dispose() {
        }

        public void amendCommitModeToggled() {
            this.updateCommitSubreposState();
        }

        public void refresh() {
            HgCheckinEnvironment.this.myShouldCommitSubrepos = false;
        }

        public void saveState() {
            HgCheckinEnvironment.this.myShouldCommitSubrepos = this.myCommitSubrepos.isSelected();
        }

        public void restoreState() {
            this.updateCommitSubreposState();
            this.refresh();
        }

        public JComponent getComponent() {
            return this.myPanel;
        }

        public boolean isAmend() {
            return this.getAmendHandler().isAmendCommitMode();
        }

        private void updateCommitSubreposState() {
            boolean isAmendMode = this.isAmend();
            this.myCommitSubrepos.setEnabled(!isAmendMode);
            if (isAmendMode) {
                this.myCommitSubrepos.setSelected(false);
            }
        }

        private void updateAmendState(boolean enable) {
            this.getAmendHandler().setAmendCommitModeTogglingEnabled(enable);
            if (this.myAmendOption != null) {
                this.myAmendOption.setEnabled(enable);
            }
            if (!enable) {
                this.getAmendHandler().setAmendCommitMode(false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment$HgCommitAdditionalComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment$HgCommitAdditionalComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAmendHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

