/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.ui.WindowMouseListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.ApiStatus;

public class WindowMoveListener
extends WindowMouseListener {
    public WindowMoveListener(Component content2) {
        super(content2);
    }

    @Override
    int getCursorType(Component view, Point location) {
        return 0;
    }

    @Override
    void updateBounds(Rectangle bounds2, Component view, int dx, int dy) {
        bounds2.x += dx;
        bounds2.y += dy;
    }

    @Override
    public void mouseMoved(MouseEvent event) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        Frame frame;
        int state;
        Component view;
        if (event.isConsumed()) {
            return;
        }
        if (16 == (0x10 & event.getModifiers()) && 1 < event.getClickCount() && (view = this.getView(this.getContent(event))) instanceof Frame && !WindowMoveListener.isStateSet(1, state = (frame = (Frame)view).getExtendedState()) && frame.isResizable()) {
            event.consume();
            frame.setExtendedState(WindowMoveListener.isStateSet(6, state) ? state & 0xFFFFFFF9 : state | 6);
        }
        super.mouseClicked(event);
    }

    @ApiStatus.Experimental
    public static class ToolkitListener
    extends WindowMoveListener {
        private final WindowMouseListener.ToolkitListenerHelper myHelper = new WindowMouseListener.ToolkitListenerHelper(this);

        public ToolkitListener(Component content2) {
            super(content2);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (!ourIsResizing && this.hitTest(event)) {
                super.mousePressed(event);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (!ourIsResizing && this.hitTest(event)) {
                super.mouseReleased(event);
            }
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            if (!ourIsResizing) {
                super.mouseDragged(event);
            }
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (this.hitTest(event)) {
                super.mouseMoved(event);
            }
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (this.hitTest(event)) {
                PotemkinProgress.invokeLaterNotBlocking(event.getSource(), () -> super.mouseClicked(event));
            }
        }

        private boolean hitTest(MouseEvent e) {
            Rectangle bounds2 = ToolkitListener.getScreenBounds(this.myContent);
            return bounds2.contains(e.getLocationOnScreen());
        }

        @Override
        protected void setCursor(Component content2, Cursor cursor) {
            this.myHelper.setCursor(content2, cursor, () -> super.setCursor(content2, cursor));
        }

        @Override
        protected void setBounds(Component comp, Rectangle bounds2) {
            this.myHelper.setBounds(comp, bounds2, () -> super.setBounds(comp, bounds2));
        }

        public void addTo(Component comp) {
            this.myHelper.addTo(comp);
        }

        public void removeFrom(Component comp) {
            this.myHelper.removeFrom(comp);
        }

        private static Rectangle getScreenBounds(Component comp) {
            Rectangle bounds2 = comp.getBounds();
            for (Container ancestor = comp.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
                Point loc = ancestor.getLocation();
                bounds2.setLocation(bounds2.x + loc.x, bounds2.y + loc.y);
            }
            return bounds2;
        }
    }
}

