/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.NullableConsumer;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkConfigurationUtil {
    private static final Logger LOG = Logger.getInstance(SdkConfigurationUtil.class);

    private SdkConfigurationUtil() {
    }

    public static void createSdk(@Nullable Project project, @NotNull Sdk[] existingSdks, @NotNull NullableConsumer<? super Sdk> onSdkCreatedCallBack, boolean createIfExists, SdkType ... sdkTypes) {
        if (existingSdks == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(0);
        }
        if (onSdkCreatedCallBack == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(1);
        }
        if (sdkTypes == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(2);
        }
        SdkConfigurationUtil.createSdk(project, existingSdks, onSdkCreatedCallBack, createIfExists, true, sdkTypes);
    }

    public static void createSdk(@Nullable Project project, final @NotNull Sdk[] existingSdks, final @NotNull NullableConsumer<? super Sdk> onSdkCreatedCallBack, final boolean createIfExists, boolean followSymLinks, final SdkType ... sdkTypes) {
        if (existingSdks == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(3);
        }
        if (onSdkCreatedCallBack == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(4);
        }
        if (sdkTypes == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(5);
        }
        if (sdkTypes.length == 0) {
            onSdkCreatedCallBack.consume(null);
            return;
        }
        FileChooserDescriptor descriptor2 = SdkConfigurationUtil.createCompositeDescriptor(sdkTypes);
        if (!followSymLinks) {
            descriptor2.setForcedToUseIdeaFileChooser(true);
        }
        VirtualFile suggestedDir = SdkConfigurationUtil.getSuggestedSdkRoot(sdkTypes[0]);
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)project, (VirtualFile)suggestedDir, (Consumer)new FileChooser.FileChooserConsumer(){

            public void consume(List<VirtualFile> selectedFiles) {
                for (SdkType sdkType : sdkTypes) {
                    String path = selectedFiles.get(0).getPath();
                    if (!sdkType.isValidSdkHome(path)) continue;
                    Sdk newSdk = null;
                    if (!createIfExists) {
                        for (Sdk sdk : existingSdks) {
                            if (!path.equals(sdk.getHomePath())) continue;
                            newSdk = sdk;
                            break;
                        }
                    }
                    if (newSdk == null) {
                        newSdk = SdkConfigurationUtil.setupSdk(existingSdks, selectedFiles.get(0), sdkType, false, null, null);
                    }
                    onSdkCreatedCallBack.consume(newSdk);
                    return;
                }
                onSdkCreatedCallBack.consume(null);
            }

            public void cancelled() {
                onSdkCreatedCallBack.consume(null);
            }
        });
    }

    public static void createSdk(@Nullable Project project, @NotNull Sdk[] existingSdks, @NotNull NullableConsumer<? super Sdk> onSdkCreatedCallBack, SdkType ... sdkTypes) {
        if (existingSdks == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(6);
        }
        if (onSdkCreatedCallBack == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(7);
        }
        if (sdkTypes == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(8);
        }
        SdkConfigurationUtil.createSdk(project, existingSdks, onSdkCreatedCallBack, true, sdkTypes);
    }

    @NotNull
    private static FileChooserDescriptor createCompositeDescriptor(final SdkType ... sdkTypes) {
        if (sdkTypes == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(9);
        }
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(sdkTypes[0].getHomeChooserDescriptor()){

            public void validateSelectedFiles(@NotNull VirtualFile[] files2) throws Exception {
                if (files2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (files2.length > 0) {
                    for (SdkType type : sdkTypes) {
                        if (!type.isValidSdkHome(files2[0].getPath())) continue;
                        return;
                    }
                }
                String key = files2.length > 0 && files2[0].isDirectory() ? "sdk.configure.home.invalid.error" : "sdk.configure.home.file.invalid.error";
                throw new Exception(ProjectBundle.message((String)key, (Object[])new Object[]{sdkTypes[0].getPresentableName()}));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil$2", "validateSelectedFiles"));
            }
        };
        if (fileChooserDescriptor == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(10);
        }
        return fileChooserDescriptor;
    }

    public static void addSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().addJdk(sdk));
    }

    public static void removeSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().removeJdk(sdk));
    }

    @Nullable
    public static Sdk setupSdk(@NotNull Sdk[] allSdks, @NotNull VirtualFile homeDir, @NotNull SdkType sdkType, boolean silent, @Nullable SdkAdditionalData additionalData, @Nullable String customSdkSuggestedName) {
        if (allSdks == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(13);
        }
        if (homeDir == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(14);
        }
        if (sdkType == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(15);
        }
        ProjectJdkImpl sdk = null;
        try {
            sdk = SdkConfigurationUtil.createSdk(allSdks, homeDir, sdkType, additionalData, customSdkSuggestedName);
            sdkType.setupSdkPaths((Sdk)sdk);
        }
        catch (Throwable e) {
            LOG.warn("Error creating or configuring sdk: homeDir=[" + homeDir + "]; sdkType=[" + sdkType + "]; additionalData=[" + additionalData + "]; customSdkSuggestedName=[" + customSdkSuggestedName + "]; sdk=[" + (Object)((Object)sdk) + "]", e);
            if (!silent) {
                Messages.showErrorDialog((String)("Error configuring SDK: " + e.getMessage() + ".\nPlease make sure that " + FileUtil.toSystemDependentName((String)homeDir.getPath()) + " is a valid home path for this SDK type."), (String)"Error Configuring SDK");
            }
            return null;
        }
        return sdk;
    }

    @NotNull
    public static ProjectJdkImpl createSdk(@NotNull Sdk[] allSdks, @NotNull VirtualFile homeDir, @NotNull SdkType sdkType, @Nullable SdkAdditionalData additionalData, @Nullable String customSdkSuggestedName) {
        if (allSdks == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(16);
        }
        if (homeDir == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(17);
        }
        if (sdkType == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(18);
        }
        List<Sdk> sdksList = Arrays.asList(allSdks);
        String sdkPath = sdkType.sdkPath(homeDir);
        String sdkName = customSdkSuggestedName == null ? SdkConfigurationUtil.createUniqueSdkName(sdkType, sdkPath, sdksList) : SdkConfigurationUtil.createUniqueSdkName(customSdkSuggestedName, sdksList);
        ProjectJdkImpl sdk = new ProjectJdkImpl(sdkName, (SdkTypeId)sdkType);
        if (additionalData != null) {
            sdk.setSdkAdditionalData(additionalData);
        }
        sdk.setHomePath(sdkPath);
        ProjectJdkImpl projectJdkImpl = sdk;
        if (projectJdkImpl == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(19);
        }
        return projectJdkImpl;
    }

    public static void setDirectoryProjectSdk(@NotNull Project project, @Nullable Sdk sdk) {
        if (project == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(20);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            ProjectRootManager.getInstance((Project)project).setProjectSdk(sdk);
            Module[] modules = ModuleManager.getInstance((Project)project).getModules();
            if (modules.length > 0) {
                ModuleRootModificationUtil.setSdkInherited((Module)modules[0]);
            }
        });
    }

    public static void configureDirectoryProjectSdk(@NotNull Project project, @Nullable Comparator<? super Sdk> preferredSdkComparator, SdkType ... sdkTypes) {
        Sdk existingSdk;
        if (project == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(21);
        }
        if (sdkTypes == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(22);
        }
        if ((existingSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk()) != null && ArrayUtil.contains((Object)existingSdk.getSdkType(), (Object[])sdkTypes)) {
            return;
        }
        Sdk sdk = SdkConfigurationUtil.findOrCreateSdk(preferredSdkComparator, sdkTypes);
        if (sdk != null) {
            SdkConfigurationUtil.setDirectoryProjectSdk(project, sdk);
        }
    }

    @Nullable
    public static Sdk findOrCreateSdk(@Nullable Comparator<? super Sdk> comparator2, SdkType ... sdkTypes) {
        Project defaultProject;
        Sdk sdk;
        if (sdkTypes == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(23);
        }
        if ((sdk = ProjectRootManager.getInstance((Project)(defaultProject = ProjectManager.getInstance().getDefaultProject())).getProjectSdk()) != null) {
            for (SdkType type : sdkTypes) {
                if (sdk.getSdkType() != type) continue;
                return sdk;
            }
        }
        for (SdkType type : sdkTypes) {
            List sdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)type);
            if (sdks.isEmpty()) continue;
            if (comparator2 != null) {
                Collections.sort(sdks, comparator2);
            }
            return (Sdk)sdks.get(0);
        }
        for (SdkType sdkType : sdkTypes) {
            Sdk an_sdk;
            String suggestedHomePath = sdkType.suggestHomePath();
            if (suggestedHomePath == null || !sdkType.isValidSdkHome(suggestedHomePath) || (an_sdk = SdkConfigurationUtil.createAndAddSDK(suggestedHomePath, sdkType)) == null) continue;
            return an_sdk;
        }
        return null;
    }

    @Nullable
    public static Sdk createAndAddSDK(@NotNull String path, @NotNull SdkType sdkType) {
        VirtualFile sdkHome;
        if (path == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(24);
        }
        if (sdkType == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(25);
        }
        if ((sdkHome = (VirtualFile)WriteAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(path))) != null) {
            Sdk newSdk = SdkConfigurationUtil.setupSdk(ProjectJdkTable.getInstance().getAllJdks(), sdkHome, sdkType, true, null, null);
            if (newSdk != null) {
                SdkConfigurationUtil.addSdk(newSdk);
            }
            return newSdk;
        }
        return null;
    }

    @NotNull
    public static String createUniqueSdkName(@NotNull SdkType type, String home, Collection<? extends Sdk> sdks) {
        if (type == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(26);
        }
        String string = SdkConfigurationUtil.createUniqueSdkName(type.suggestSdkName(null, home), sdks);
        if (string == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public static String createUniqueSdkName(@NotNull String suggestedName, @NotNull Collection<? extends Sdk> sdks) {
        if (suggestedName == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(28);
        }
        if (sdks == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(29);
        }
        Set nameList = sdks.stream().map(jdk -> jdk.getName()).collect(Collectors.toSet());
        String string = UniqueNameGenerator.generateUniqueName((String)suggestedName, (String)"", (String)"", (String)" (", (String)")", o -> !nameList.contains(o));
        if (string == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(30);
        }
        return string;
    }

    public static void selectSdkHome(@NotNull SdkType sdkType, @NotNull Consumer<? super String> consumer) {
        if (sdkType == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(31);
        }
        if (consumer == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(32);
        }
        FileChooserDescriptor descriptor2 = sdkType.getHomeChooserDescriptor();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Sdk sdk = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)sdkType);
            if (sdk == null) {
                throw new RuntimeException("No SDK of type " + sdkType + " found");
            }
            consumer.consume((Object)sdk.getHomePath());
            return;
        }
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, null, (VirtualFile)SdkConfigurationUtil.getSuggestedSdkRoot(sdkType), chosen -> {
            String path = ((VirtualFile)chosen.get(0)).getPath();
            if (sdkType.isValidSdkHome(path)) {
                consumer.consume((Object)path);
                return;
            }
            String adjustedPath = sdkType.adjustSelectedSdkHome(path);
            if (sdkType.isValidSdkHome(adjustedPath)) {
                consumer.consume((Object)adjustedPath);
            }
        });
    }

    @Nullable
    public static VirtualFile getSuggestedSdkRoot(@NotNull SdkType sdkType) {
        String homePath;
        if (sdkType == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(33);
        }
        return (homePath = sdkType.suggestHomePath()) == null ? null : LocalFileSystem.getInstance().findFileByPath(homePath);
    }

    @NotNull
    public static List<String> filterExistingPaths(@NotNull SdkType sdkType, Collection<String> sdkHomes, Sdk[] sdks) {
        if (sdkType == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(34);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (String sdkHome : sdkHomes) {
            if (SdkConfigurationUtil.findByPath(sdkType, sdks, sdkHome) != null) continue;
            result2.add(sdkHome);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(35);
        }
        return arrayList;
    }

    @Nullable
    private static Sdk findByPath(@NotNull SdkType sdkType, @NotNull Sdk[] sdks, @NotNull String sdkHome) {
        if (sdkType == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(36);
        }
        if (sdks == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(37);
        }
        if (sdkHome == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(38);
        }
        for (Sdk sdk : sdks) {
            String path = sdk.getHomePath();
            if (sdk.getSdkType() != sdkType || path == null || !FileUtil.pathsEqual((String)FileUtil.toSystemIndependentName((String)path), (String)FileUtil.toSystemIndependentName((String)sdkHome))) continue;
            return sdk;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 19: 
            case 27: 
            case 30: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 19: 
            case 27: 
            case 30: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingSdks";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSdkCreatedCallBack";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkTypes";
                break;
            }
            case 10: 
            case 19: 
            case 27: 
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allSdks";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homeDir";
                break;
            }
            case 15: 
            case 18: 
            case 25: 
            case 31: 
            case 33: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkType";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedName";
                break;
            }
            case 29: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompositeDescriptor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createSdk";
                break;
            }
            case 27: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createUniqueSdkName";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "filterExistingPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSdk";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCompositeDescriptor";
                break;
            }
            case 10: 
            case 19: 
            case 27: 
            case 30: 
            case 35: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addSdk";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeSdk";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setupSdk";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setDirectoryProjectSdk";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "configureDirectoryProjectSdk";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateSdk";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createAndAddSDK";
                break;
            }
            case 26: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createUniqueSdkName";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "selectSdkHome";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestedSdkRoot";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "filterExistingPaths";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findByPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 19: 
            case 27: 
            case 30: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

