/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.autoimport.ProjectStatus;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013J(\u0010\u0014\u001a\u00020\u0007*\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00072\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00070\u0016H\u0002J(\u0010\u0017\u001a\u00020\u0007*\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00072\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00070\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectState;", "kotlin.jvm.PlatformType", "isUpToDate", "", "markDirty", "stamp", "", "markModified", "markReverted", "markSynchronized", "update", "event", "Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectEvent;", "ifFuture", "action", "Lkotlin/Function1;", "withFuture", "ProjectEvent", "ProjectState", "intellij.platform.externalSystem.impl"})
public final class ProjectStatus {
    private final Logger LOG;
    private AtomicReference<ProjectState> state;

    public final boolean isUpToDate() {
        boolean bl;
        ProjectState projectState = this.state.get();
        if (projectState instanceof ProjectState.Modified || projectState instanceof ProjectState.Dirty) {
            bl = false;
        } else if (projectState instanceof ProjectState.Synchronized || projectState instanceof ProjectState.Reverted) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @NotNull
    public final ProjectState markDirty(long stamp) {
        return this.update(new ProjectEvent.Invalidate(stamp));
    }

    @NotNull
    public final ProjectState markModified(long stamp) {
        return this.update(new ProjectEvent.Modify(stamp));
    }

    @NotNull
    public final ProjectState markReverted(long stamp) {
        return this.update(new ProjectEvent.Revert(stamp));
    }

    @NotNull
    public final ProjectState markSynchronized(long stamp) {
        return this.update(new ProjectEvent.Synchronize(stamp));
    }

    @NotNull
    public final ProjectState update(@NotNull ProjectEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Event " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName() + " is happened at " + event.getStamp());
        }
        ProjectState projectState = this.state.updateAndGet(new UnaryOperator<ProjectState>(this, event){
            final /* synthetic */ ProjectStatus this$0;
            final /* synthetic */ ProjectEvent $event;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final ProjectState apply(ProjectState currentState) {
                ProjectState projectState;
                ProjectState projectState2 = currentState;
                if (projectState2 instanceof ProjectState.Synchronized) {
                    ProjectEvent projectEvent = this.$event;
                    if (projectEvent instanceof ProjectEvent.Synchronize) {
                        projectState = ProjectStatus.access$withFuture(this.this$0, this.$event, currentState, update.1.INSTANCE);
                        return projectState;
                    } else if (projectEvent instanceof ProjectEvent.Invalidate) {
                        projectState = ProjectStatus.access$ifFuture(this.this$0, this.$event, currentState, update.2.INSTANCE);
                        return projectState;
                    } else if (projectEvent instanceof ProjectEvent.Modify) {
                        projectState = ProjectStatus.access$ifFuture(this.this$0, this.$event, currentState, update.3.INSTANCE);
                        return projectState;
                    } else {
                        if (!(projectEvent instanceof ProjectEvent.Revert)) throw new NoWhenBranchMatchedException();
                        projectState = ProjectStatus.access$ifFuture(this.this$0, this.$event, currentState, update.4.INSTANCE);
                    }
                    return projectState;
                } else if (projectState2 instanceof ProjectState.Dirty) {
                    ProjectEvent projectEvent = this.$event;
                    if (projectEvent instanceof ProjectEvent.Synchronize) {
                        projectState = ProjectStatus.access$ifFuture(this.this$0, this.$event, currentState, update.5.INSTANCE);
                        return projectState;
                    } else if (projectEvent instanceof ProjectEvent.Invalidate) {
                        projectState = ProjectStatus.access$withFuture(this.this$0, this.$event, currentState, update.6.INSTANCE);
                        return projectState;
                    } else if (projectEvent instanceof ProjectEvent.Modify) {
                        projectState = ProjectStatus.access$withFuture(this.this$0, this.$event, currentState, update.7.INSTANCE);
                        return projectState;
                    } else {
                        if (!(projectEvent instanceof ProjectEvent.Revert)) throw new NoWhenBranchMatchedException();
                        projectState = ProjectStatus.access$withFuture(this.this$0, this.$event, currentState, update.8.INSTANCE);
                    }
                    return projectState;
                } else if (projectState2 instanceof ProjectState.Modified) {
                    ProjectEvent projectEvent = this.$event;
                    if (projectEvent instanceof ProjectEvent.Synchronize) {
                        projectState = ProjectStatus.access$ifFuture(this.this$0, this.$event, currentState, update.9.INSTANCE);
                        return projectState;
                    } else if (projectEvent instanceof ProjectEvent.Invalidate) {
                        projectState = ProjectStatus.access$withFuture(this.this$0, this.$event, currentState, update.10.INSTANCE);
                        return projectState;
                    } else if (projectEvent instanceof ProjectEvent.Modify) {
                        projectState = ProjectStatus.access$withFuture(this.this$0, this.$event, currentState, update.11.INSTANCE);
                        return projectState;
                    } else {
                        if (!(projectEvent instanceof ProjectEvent.Revert)) throw new NoWhenBranchMatchedException();
                        projectState = ProjectStatus.access$ifFuture(this.this$0, this.$event, currentState, update.12.INSTANCE);
                    }
                    return projectState;
                } else {
                    if (!(projectState2 instanceof ProjectState.Reverted)) throw new NoWhenBranchMatchedException();
                    ProjectEvent projectEvent = this.$event;
                    if (projectEvent instanceof ProjectEvent.Synchronize) {
                        projectState = ProjectStatus.access$ifFuture(this.this$0, this.$event, currentState, update.13.INSTANCE);
                        return projectState;
                    } else if (projectEvent instanceof ProjectEvent.Invalidate) {
                        projectState = ProjectStatus.access$withFuture(this.this$0, this.$event, currentState, update.14.INSTANCE);
                        return projectState;
                    } else if (projectEvent instanceof ProjectEvent.Modify) {
                        projectState = ProjectStatus.access$ifFuture(this.this$0, this.$event, currentState, update.15.INSTANCE);
                        return projectState;
                    } else {
                        if (!(projectEvent instanceof ProjectEvent.Revert)) throw new NoWhenBranchMatchedException();
                        projectState = ProjectStatus.access$withFuture(this.this$0, this.$event, currentState, update.16.INSTANCE);
                    }
                }
                return projectState;
            }
            {
                this.this$0 = projectStatus;
                this.$event = projectEvent;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)projectState, (String)"state.updateAndGet { cur\u2026)\n        }\n      }\n    }");
        return projectState;
    }

    private final ProjectState withFuture(@NotNull ProjectEvent $this$withFuture, ProjectState state, Function1<? super Long, ? extends ProjectState> action2) {
        return (ProjectState)action2.invoke((Object)Long.max($this$withFuture.getStamp(), state.getStamp()));
    }

    private final ProjectState ifFuture(@NotNull ProjectEvent $this$ifFuture, ProjectState state, Function1<? super Long, ? extends ProjectState> action2) {
        return $this$ifFuture.getStamp() > state.getStamp() ? (ProjectState)action2.invoke((Object)$this$ifFuture.getStamp()) : state;
    }

    public ProjectStatus() {
        Logger logger = Logger.getInstance(ProjectStatus.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(ProjectStatus::class.java)");
        this.LOG = logger;
        this.state = new AtomicReference<ProjectState>(new ProjectState.Synchronized(-1L));
    }

    public static final /* synthetic */ ProjectState access$withFuture(ProjectStatus $this, ProjectEvent $this$access_u24withFuture, ProjectState state, Function1 action2) {
        return $this.withFuture($this$access_u24withFuture, state, (Function1<? super Long, ? extends ProjectState>)action2);
    }

    public static final /* synthetic */ ProjectState access$ifFuture(ProjectStatus $this, ProjectEvent $this$access_u24ifFuture, ProjectState state, Function1 action2) {
        return $this.ifFuture($this$access_u24ifFuture, state, (Function1<? super Long, ? extends ProjectState>)action2);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0007\b\t\nB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0004\u000b\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectEvent;", "", "stamp", "", "(J)V", "getStamp", "()J", "Invalidate", "Modify", "Revert", "Synchronize", "Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectEvent$Synchronize;", "Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectEvent$Invalidate;", "Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectEvent$Modify;", "Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectEvent$Revert;", "intellij.platform.externalSystem.impl"})
    public static abstract class ProjectEvent {
        private final long stamp;

        public final long getStamp() {
            return this.stamp;
        }

        private ProjectEvent(long stamp) {
            this.stamp = stamp;
        }

        public /* synthetic */ ProjectEvent(long stamp, DefaultConstructorMarker $constructor_marker) {
            this(stamp);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectEvent$Synchronize;", "Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectEvent;", "stamp", "", "(J)V", "intellij.platform.externalSystem.impl"})
        public static final class Synchronize
        extends ProjectEvent {
            public Synchronize(long stamp) {
                super(stamp, null);
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectEvent$Invalidate;", "Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectEvent;", "stamp", "", "(J)V", "intellij.platform.externalSystem.impl"})
        public static final class Invalidate
        extends ProjectEvent {
            public Invalidate(long stamp) {
                super(stamp, null);
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectEvent$Modify;", "Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectEvent;", "stamp", "", "(J)V", "intellij.platform.externalSystem.impl"})
        public static final class Modify
        extends ProjectEvent {
            public Modify(long stamp) {
                super(stamp, null);
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectEvent$Revert;", "Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectEvent;", "stamp", "", "(J)V", "intellij.platform.externalSystem.impl"})
        public static final class Revert
        extends ProjectEvent {
            public Revert(long stamp) {
                super(stamp, null);
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0007\b\t\nB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0004\u000b\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectState;", "", "stamp", "", "(J)V", "getStamp", "()J", "Dirty", "Modified", "Reverted", "Synchronized", "Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectState$Synchronized;", "Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectState$Dirty;", "Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectState$Modified;", "Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectState$Reverted;", "intellij.platform.externalSystem.impl"})
    public static abstract class ProjectState {
        private final long stamp;

        public final long getStamp() {
            return this.stamp;
        }

        private ProjectState(long stamp) {
            this.stamp = stamp;
        }

        public /* synthetic */ ProjectState(long stamp, DefaultConstructorMarker $constructor_marker) {
            this(stamp);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectState$Synchronized;", "Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectState;", "stamp", "", "(J)V", "intellij.platform.externalSystem.impl"})
        public static final class Synchronized
        extends ProjectState {
            public Synchronized(long stamp) {
                super(stamp, null);
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectState$Dirty;", "Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectState;", "stamp", "", "(J)V", "intellij.platform.externalSystem.impl"})
        public static final class Dirty
        extends ProjectState {
            public Dirty(long stamp) {
                super(stamp, null);
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectState$Modified;", "Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectState;", "stamp", "", "(J)V", "intellij.platform.externalSystem.impl"})
        public static final class Modified
        extends ProjectState {
            public Modified(long stamp) {
                super(stamp, null);
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectState$Reverted;", "Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectStatus$ProjectState;", "stamp", "", "(J)V", "intellij.platform.externalSystem.impl"})
        public static final class Reverted
        extends ProjectState {
            public Reverted(long stamp) {
                super(stamp, null);
            }
        }
    }
}

