/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.navigation;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.ide.actions.searcheverywhere.SymbolSearchEverywhereContributor;
import com.intellij.navigation.JBProtocolNavigateCommand;
import com.intellij.navigation.JBProtocolNavigateCommand$perform$;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.JBProtocolCommand;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.StatusBarProgress;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.PsiNavigateUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0016\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/navigation/JBProtocolNavigateCommand;", "Lcom/intellij/openapi/application/JBProtocolCommand;", "()V", "perform", "", "target", "", "parameters", "", "Companion", "intellij.platform.lang.impl"})
public class JBProtocolNavigateCommand
extends JBProtocolCommand {
    private static final Logger LOG;
    @NotNull
    public static final String NAVIGATE_COMMAND = "navigate";
    @NotNull
    public static final String PROJECT_NAME_KEY = "project";
    @NotNull
    public static final String REFERENCE_TARGET = "reference";
    @NotNull
    public static final String PATH_KEY = "path";
    @NotNull
    public static final String FQN_KEY = "fqn";
    @NotNull
    public static final String SELECTION = "selection";
    @NotNull
    public static final String FILE_PROTOCOL = "file://";
    private static final String PATH_GROUP = "path";
    private static final String LINE_GROUP = "line";
    private static final String COLUMN_GROUP = "column";
    private static final Pattern PATH_WITH_LOCATION;
    public static final Companion Companion;

    @Override
    public void perform(@NotNull String target2, @NotNull Map<String, String> parameters) {
        AnAction[] recentProjectsActions;
        Intrinsics.checkParameterIsNotNull((Object)target2, (String)"target");
        Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
        String projectName = parameters.get(PROJECT_NAME_KEY);
        CharSequence charSequence = projectName;
        boolean bl = false;
        int n = 0;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        if (Intrinsics.areEqual((Object)target2, (Object)REFERENCE_TARGET) ^ true) {
            LOG.warn("JB navigate action supports only reference target, got " + target2);
            return;
        }
        AnAction[] anActionArray = RecentProjectsManager.getInstance().getRecentProjectsActions(false);
        Intrinsics.checkExpressionValueIsNotNull((Object)anActionArray, (String)"RecentProjectsManager.ge\u2026entProjectsActions(false)");
        for (AnAction recentProjectAction : recentProjectsActions = anActionArray) {
            boolean bl2;
            Project project;
            boolean bl3;
            Object object;
            block5: {
                if (!(recentProjectAction instanceof ReopenProjectAction) || !Intrinsics.areEqual((Object)((ReopenProjectAction)recentProjectAction).getProjectName(), (Object)projectName)) continue;
                ProjectManager projectManager = ProjectManager.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
                Project[] projectArray = projectManager.getOpenProjects();
                Intrinsics.checkExpressionValueIsNotNull((Object)projectArray, (String)"ProjectManager.getInstance().openProjects");
                object = projectArray;
                bl3 = false;
                Project[] projectArray2 = object;
                boolean bl4 = false;
                Project[] projectArray3 = projectArray2;
                int n2 = projectArray3.length;
                for (int i = 0; i < n2; ++i) {
                    Project project2;
                    Project project3 = project2 = projectArray3[i];
                    boolean bl5 = false;
                    Project project4 = project3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)PROJECT_NAME_KEY);
                    if (!Intrinsics.areEqual((Object)project4.getName(), (Object)projectName)) continue;
                    project = project2;
                    break block5;
                }
                project = null;
            }
            if (project != null) {
                object = project;
                bl3 = false;
                bl2 = false;
                Object it = object;
                boolean bl6 = false;
                JBProtocolNavigateCommand.Companion.findAndNavigateToReference((Project)it, parameters);
                continue;
            }
            object = this;
            bl3 = false;
            bl2 = false;
            JBProtocolNavigateCommand $this$run = (JBProtocolNavigateCommand)object;
            boolean bl7 = false;
            ApplicationManager.getApplication().invokeLater(new Runnable(recentProjectAction, parameters){
                final /* synthetic */ AnAction $recentProjectAction$inlined;
                final /* synthetic */ Map $parameters$inlined;
                {
                    this.$recentProjectAction$inlined = anAction;
                    this.$parameters$inlined = map2;
                }

                public final void run() {
                    block0: {
                        Project project = RecentProjectsManagerBase.getInstanceEx().doOpenProject(((ReopenProjectAction)this.$recentProjectAction$inlined).getProjectPath(), null, false);
                        if (project == null) break block0;
                        Project project2 = project;
                        boolean bl = false;
                        boolean bl2 = false;
                        Project it = project2;
                        boolean bl3 = false;
                        StartupManager.getInstance((Project)it).registerPostStartupActivity(new Runnable(it, this){
                            final /* synthetic */ Project $it;
                            final /* synthetic */ perform$$inlined$run$lambda$1 this$0;
                            {
                                this.$it = project;
                                this.this$0 = var2_2;
                            }

                            public final void run() {
                                Project project = this.$it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"it");
                                com.intellij.navigation.JBProtocolNavigateCommand$Companion.access$findAndNavigateToReference(JBProtocolNavigateCommand.Companion, project, this.this$0.$parameters$inlined);
                            }
                        });
                    }
                }
            }, ModalityState.NON_MODAL);
        }
    }

    public JBProtocolNavigateCommand() {
        super(NAVIGATE_COMMAND);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(JBProtocolNavigateCommand.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(JBPro\u2026igateCommand::class.java)");
        LOG = logger;
        Pattern pattern = Pattern.compile("(?<path>[^:]*)(?<line>:[\\d]+)?(?<column>:[\\d]+)?");
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\"(?<$PAT\u2026$COLUMN_GROUP>:[\\\\d]+)?\")");
        PATH_WITH_LOCATION = pattern;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0017H\u0002J,\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00172\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J,\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00172\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J.\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0!0 2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0017H\u0002J$\u0010\"\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0!H\u0002J$\u0010$\u001a\u00020\u00132\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/navigation/JBProtocolNavigateCommand$Companion;", "", "()V", "COLUMN_GROUP", "", "FILE_PROTOCOL", "FQN_KEY", "LINE_GROUP", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "NAVIGATE_COMMAND", "PATH_GROUP", "PATH_KEY", "PATH_WITH_LOCATION", "Ljava/util/regex/Pattern;", "PROJECT_NAME_KEY", "REFERENCE_TARGET", "SELECTION", "findAndNavigateToReference", "", "project", "Lcom/intellij/openapi/project/Project;", "parameters", "", "navigateByFqn", "reference", "navigateByPath", "pathText", "parsePosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "range", "parseSelections", "", "Lkotlin/Pair;", "setSelection", "selection", "setSelections", "intellij.platform.lang.impl"})
    public static final class Companion {
        private final void findAndNavigateToReference(Project project, Map<String, String> parameters) {
            Map.Entry element$iv2;
            Map.Entry it;
            Map.Entry element$iv$iv;
            Map $this$filterTo$iv$iv;
            Map $this$filter$iv = parameters;
            boolean $i$f$filter = false;
            Map map2 = $this$filter$iv;
            Map destination$iv$iv22 = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            void var8_14 = $this$filterTo$iv$iv;
            boolean bl = false;
            Iterator iterator = var8_14.entrySet().iterator();
            while (iterator.hasNext()) {
                it = element$iv$iv = iterator.next();
                boolean bl2 = false;
                if (!StringsKt.startsWith$default((String)((String)it.getKey()), (String)JBProtocolNavigateCommand.FQN_KEY, (boolean)false, (int)2, null)) continue;
                destination$iv$iv22.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map $this$forEach$iv = destination$iv$iv22;
            boolean $i$f$forEach = false;
            $this$filterTo$iv$iv = $this$forEach$iv;
            boolean destination$iv$iv22 = false;
            for (Map.Entry element$iv2 : $this$filterTo$iv$iv.entrySet()) {
                Map.Entry it2 = element$iv2;
                boolean bl3 = false;
                Companion.navigateByFqn(project, parameters, (String)it2.getValue());
            }
            $this$filter$iv = parameters;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            $i$f$filterTo = false;
            element$iv2 = $this$filterTo$iv$iv;
            boolean it2 = false;
            Iterator bl3 = element$iv2.entrySet().iterator();
            while (bl3.hasNext()) {
                it = element$iv$iv = bl3.next();
                boolean bl4 = false;
                if (!StringsKt.startsWith$default((String)((String)it.getKey()), (String)"path", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$forEach$iv = destination$iv$iv;
            $i$f$forEach = false;
            map2 = $this$forEach$iv;
            boolean bl5 = false;
            Iterator iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry it3 = element$iv2 = iterator2.next();
                boolean bl6 = false;
                Companion.navigateByPath(project, parameters, (String)it3.getValue());
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void navigateByPath(Project project, Map<String, String> parameters, String pathText) {
            int n;
            int n2;
            int n3;
            boolean bl;
            CaretModel caretModel;
            Editor editor;
            void $this$filterIsInstanceTo$iv$iv;
            Matcher matcher = PATH_WITH_LOCATION.matcher(pathText);
            if (!matcher.matches()) {
                return;
            }
            String path = matcher.group("path");
            String line2 = matcher.group(JBProtocolNavigateCommand.LINE_GROUP);
            String column = matcher.group(JBProtocolNavigateCommand.COLUMN_GROUP);
            if (path == null) {
                return;
            }
            if (!FileUtil.isAbsolute((String)(path = FileUtil.expandUserHome((String)path)))) {
                path = new File(project.getBasePath(), path).getAbsolutePath();
            }
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(JBProtocolNavigateCommand.FILE_PROTOCOL + path);
            if (virtualFile == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"VirtualFileManager.getIn\u2026ROTOCOL + path) ?: return");
            VirtualFile virtualFile2 = virtualFile;
            FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project).openFile(virtualFile2, true);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorArray, (String)"FileEditorManager.getIns\u2026enFile(virtualFile, true)");
            FileEditor[] $this$filterIsInstance$iv = fileEditorArray;
            boolean $i$f$filterIsInstance = false;
            FileEditor[] fileEditorArray2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof TextEditor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Object object = CollectionsKt.first((List)((List)destination$iv$iv));
            boolean bl2 = false;
            boolean bl3 = false;
            TextEditor textEditor = (TextEditor)object;
            boolean bl4 = false;
            Editor editor2 = textEditor.getEditor();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"textEditor.editor");
            Editor editor3 = editor2;
            CaretModel caretModel2 = editor3.getCaretModel();
            Editor editor4 = editor3;
            String string = line2;
            if (string != null) {
                String string2 = string;
                editor = editor4;
                caretModel = caretModel2;
                bl = false;
                n3 = Integer.parseInt(string2);
                caretModel2 = caretModel;
                editor4 = editor;
                n2 = n3;
            } else {
                n2 = 0;
            }
            String string3 = column;
            if (string3 != null) {
                String string4 = string3;
                n3 = n2;
                editor = editor4;
                caretModel = caretModel2;
                bl = false;
                int n4 = Integer.parseInt(string4);
                caretModel2 = caretModel;
                editor4 = editor;
                n2 = n3;
                n = n4;
            } else {
                n = 0;
            }
            int n5 = n;
            int n6 = n2;
            caretModel2.moveToOffset(editor4.logicalPositionToOffset(new LogicalPosition(n6, n5)));
            Companion.setSelections(parameters, project);
        }

        private final void navigateByFqn(Project project, Map<String, String> parameters, String reference2) {
            String string;
            block3: {
                block2: {
                    string = parameters.get("__fragment");
                    if (string == null) break block2;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    string = reference2 + '#' + it;
                    if (string != null) break block3;
                }
                string = reference2;
            }
            String fqn = string;
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, fqn, parameters, project, IdeBundle.message((String)"navigate.command.search.reference.progress.title", (Object[])new Object[]{fqn}), true){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $fqn;
                final /* synthetic */ Map $parameters;

                /*
                 * WARNING - void declaration
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    void $this$filterIsInstanceTo$iv$iv;
                    Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                    SymbolSearchEverywhereContributor symbolSearchEverywhereContributor = new SymbolSearchEverywhereContributor(this.$project, null);
                    ProgressManager progressManager = ProgressManager.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
                    ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
                    if (progressIndicator == null) {
                        progressIndicator = new StatusBarProgress();
                    }
                    List list2 = symbolSearchEverywhereContributor.search(this.$fqn, progressIndicator);
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"SymbolSearchEverywhereCo\u2026r ?: StatusBarProgress())");
                    Iterable $this$filterIsInstance$iv = list2;
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof PsiElement)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$forEach$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl = false;
                        ApplicationManager.getApplication().invokeLater(new Runnable(it, this){
                            final /* synthetic */ PsiElement $it;
                            final /* synthetic */ navigateByFqn.1 this$0;
                            {
                                this.$it = psiElement;
                                this.this$0 = var2_2;
                            }

                            public final void run() {
                                PsiNavigateUtil.navigate((PsiElement)this.$it);
                                com.intellij.navigation.JBProtocolNavigateCommand$Companion.access$setSelections(JBProtocolNavigateCommand.Companion, this.this$0.$parameters, this.this$0.$project);
                            }
                        });
                    }
                }

                public boolean shouldStartInBackground() {
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                    return !application.isUnitTestMode();
                }

                public boolean isConditionalModal() {
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                    return !application.isUnitTestMode();
                }
                {
                    this.$project = $captured_local_variable$0;
                    this.$fqn = $captured_local_variable$1;
                    this.$parameters = $captured_local_variable$2;
                    super($super_call_param$3, $super_call_param$4, $super_call_param$5);
                }
            });
        }

        private final void setSelections(Map<String, String> parameters, Project project) {
            Iterable $this$forEach$iv = this.parseSelections(parameters);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair selection = (Pair)element$iv;
                boolean bl = false;
                Companion.setSelection(project, (Pair<? extends LogicalPosition, ? extends LogicalPosition>)selection);
            }
        }

        private final void setSelection(Project project, Pair<? extends LogicalPosition, ? extends LogicalPosition> selection) {
            block0: {
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
                Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager, (String)"FileEditorManager.getInstance(project)");
                Editor editor = fileEditorManager.getSelectedTextEditor();
                Editor editor2 = editor;
                if (editor2 == null || (editor2 = editor2.getSelectionModel()) == null) break block0;
                editor2.setSelection(editor.logicalPositionToOffset((LogicalPosition)selection.getFirst()), editor.logicalPositionToOffset((LogicalPosition)selection.getSecond()));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<Pair<LogicalPosition, LogicalPosition>> parseSelections(Map<String, String> parameters) {
            void $this$mapNotNullTo$iv$iv;
            Map<String, String> $this$filterKeys$iv = parameters;
            boolean $i$f$filterKeys = false;
            Object result$iv = new LinkedHashMap();
            Map<String, String> map2 = $this$filterKeys$iv;
            boolean bl = false;
            for (Map.Entry<String, String> entry$iv : map2.entrySet()) {
                String it = entry$iv.getKey();
                boolean bl2 = false;
                if (!StringsKt.startsWith$default((String)it, (String)JBProtocolNavigateCommand.SELECTION, (boolean)false, (int)2, null)) continue;
                ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
            }
            Iterable $this$mapNotNull$iv = ((Map)result$iv).values();
            boolean $i$f$mapNotNull = false;
            result$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Pair pair;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl3 = false;
                String it = (String)element$iv$iv;
                boolean bl4 = false;
                List split = StringsKt.split$default((CharSequence)it, (char[])new char[]{'-'}, (boolean)false, (int)0, (int)6, null);
                if (split.size() != 2) {
                    pair = null;
                } else {
                    LogicalPosition position1 = Companion.parsePosition((String)split.get(0));
                    LogicalPosition position2 = Companion.parsePosition((String)split.get(1));
                    pair = position1 != null && position2 != null ? new Pair((Object)position1, (Object)position1) : null;
                }
                if (pair == null) continue;
                Pair pair2 = pair;
                boolean bl5 = false;
                boolean bl6 = false;
                Pair it$iv$iv = pair2;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final LogicalPosition parsePosition(String range2) {
            List position = StringsKt.split$default((CharSequence)range2, (char[])new char[]{':'}, (boolean)false, (int)0, (int)6, null);
            if (position.size() != 2) {
                return null;
            }
            try {
                return new LogicalPosition(Integer.parseInt((String)position.get(0)), Integer.parseInt((String)position.get(1)));
            }
            catch (Exception e) {
                return null;
            }
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$setSelections(Companion $this, Map parameters, Project project) {
            $this.setSelections(parameters, project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

