/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.template.TemplateLookupSelectionHandler;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class TemplateExpressionLookupElement
extends LookupElementDecorator<LookupElement> {
    private final TemplateState myState;

    TemplateExpressionLookupElement(TemplateState state, LookupElement element, int index) {
        super(PrioritizedLookupElement.withPriority((LookupElement)element, (double)(0x7FFFFFF5 - index)));
        this.myState = state;
    }

    private static InsertionContext createInsertionContext(LookupElement item, PsiFile psiFile, List<? extends LookupElement> elements2, Editor editor, char completionChar) {
        OffsetMap offsetMap = new OffsetMap(editor.getDocument());
        InsertionContext context = new InsertionContext(offsetMap, completionChar, elements2.toArray(LookupElement.EMPTY_ARRAY), psiFile, editor, InsertionContext.shouldAddCompletionChar((char)completionChar));
        context.setTailOffset(editor.getCaretModel().getOffset());
        offsetMap.addOffset(CompletionInitializationContext.START_OFFSET, context.getTailOffset() - item.getLookupString().length());
        offsetMap.addOffset(CompletionInitializationContext.SELECTION_END_OFFSET, context.getTailOffset());
        offsetMap.addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, context.getTailOffset());
        return context;
    }

    void handleTemplateInsert(List<? extends LookupElement> elements2, char completionChar) {
        InsertionContext context = TemplateExpressionLookupElement.createInsertionContext((LookupElement)this, this.myState.getPsiFile(), elements2, this.myState.getEditor(), completionChar);
        WriteAction.run(() -> {
            this.doHandleInsert(context);
            if (context.shouldAddCompletionChar()) {
                CodeCompletionHandlerBase.addCompletionChar(context, (LookupElement)this);
            }
        });
        Disposer.dispose((Disposable)context.getOffsetMap());
        if (TemplateExpressionLookupElement.handleCompletionChar(context) && !this.myState.isFinished()) {
            this.myState.calcResults(true);
            this.myState.considerNextTabOnLookupItemSelected(this.getDelegate());
        }
    }

    public void handleInsert(@NotNull InsertionContext context) {
        if (context == null) {
            TemplateExpressionLookupElement.$$$reportNull$$$0(0);
        }
        this.doHandleInsert(context);
        TemplateExpressionLookupElement.handleCompletionChar(context);
    }

    private void doHandleInsert(InsertionContext context) {
        LookupElement item = this.getDelegate();
        PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
        TextRange range2 = this.myState.getCurrentVariableRange();
        TemplateLookupSelectionHandler handler2 = (TemplateLookupSelectionHandler)item.getUserData(TemplateLookupSelectionHandler.KEY_IN_LOOKUP_ITEM);
        if (handler2 != null && range2 != null) {
            handler2.itemSelected(item, context.getFile(), context.getDocument(), range2.getStartOffset(), range2.getEndOffset());
        } else {
            super.handleInsert(context);
        }
    }

    private static boolean handleCompletionChar(InsertionContext context) {
        if (context.getCompletionChar() == '.') {
            AutoPopupController.getInstance(context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/impl/TemplateExpressionLookupElement", "handleInsert"));
    }
}

