/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPathMapper
implements PathMapper {
    @Nullable
    public static String convertToLocal(@NotNull String remotePath, @NotNull Iterable<? extends PathMappingSettings.PathMapping> mappings) {
        if (remotePath == null) {
            AbstractPathMapper.$$$reportNull$$$0(0);
        }
        if (mappings == null) {
            AbstractPathMapper.$$$reportNull$$$0(1);
        }
        PathMappingSettings.BestMappingSelector selector = new PathMappingSettings.BestMappingSelector();
        for (PathMappingSettings.PathMapping pathMapping : mappings) {
            if (!pathMapping.canReplaceRemote(remotePath)) continue;
            selector.consider(pathMapping, pathMapping.getRemoteLen());
        }
        if (selector.get() != null) {
            return selector.get().mapToLocal(remotePath);
        }
        return null;
    }

    @Nullable
    public static String convertToRemote(@NotNull String localPath, @NotNull Collection<? extends PathMappingSettings.PathMapping> pathMappings) {
        if (localPath == null) {
            AbstractPathMapper.$$$reportNull$$$0(2);
        }
        if (pathMappings == null) {
            AbstractPathMapper.$$$reportNull$$$0(3);
        }
        PathMappingSettings.BestMappingSelector selector = new PathMappingSettings.BestMappingSelector();
        for (PathMappingSettings.PathMapping pathMapping : pathMappings) {
            if (pathMapping == null || !pathMapping.canReplaceLocal(localPath)) continue;
            selector.consider(pathMapping, pathMapping.getLocalLen());
        }
        if (selector.get() != null) {
            return selector.get().mapToRemote(localPath);
        }
        return null;
    }

    @Override
    @NotNull
    public final List<String> convertToRemote(@NotNull Collection<String> paths) {
        if (paths == null) {
            AbstractPathMapper.$$$reportNull$$$0(4);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String p : paths) {
            result.add(this.convertToRemote(p));
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            AbstractPathMapper.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Override
    public final boolean canReplaceRemote(@NotNull String remotePath) {
        if (remotePath == null) {
            AbstractPathMapper.$$$reportNull$$$0(6);
        }
        for (PathMappingSettings.PathMapping mapping : this.getAvailablePathMappings()) {
            if (!mapping.canReplaceRemote(remotePath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean canReplaceLocal(@NotNull String localPath) {
        if (localPath == null) {
            AbstractPathMapper.$$$reportNull$$$0(7);
        }
        for (PathMappingSettings.PathMapping mapping : this.getAvailablePathMappings()) {
            if (!mapping.canReplaceLocal(localPath)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected abstract Collection<PathMappingSettings.PathMapping> getAvailablePathMappings();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/AbstractPathMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/AbstractPathMapper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToRemote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertToLocal";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertToRemote";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canReplaceRemote";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canReplaceLocal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

