/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.WeakHashMap;
import javax.xml.transform.TransformerException;
import org.apache.batik.dom.AbstractAttr;
import org.apache.batik.dom.AbstractAttrNS;
import org.apache.batik.dom.AbstractDOMImplementation;
import org.apache.batik.dom.AbstractElement;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.AbstractParentNode;
import org.apache.batik.dom.AbstractText;
import org.apache.batik.dom.ExtendedNode;
import org.apache.batik.dom.GenericDocumentType;
import org.apache.batik.dom.events.DocumentEventSupport;
import org.apache.batik.dom.events.EventSupport;
import org.apache.batik.dom.traversal.TraversalSupport;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.xbl.GenericXBLManager;
import org.apache.batik.dom.xbl.XBLManager;
import org.apache.batik.i18n.Localizable;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.util.CleanerThread;
import org.apache.batik.util.SoftDoublyIndexedTable;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DOMLocator;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.MutationNameEvent;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;
import org.w3c.dom.xpath.XPathEvaluator;
import org.w3c.dom.xpath.XPathException;
import org.w3c.dom.xpath.XPathExpression;
import org.w3c.dom.xpath.XPathNSResolver;
import org.w3c.dom.xpath.XPathResult;

public abstract class AbstractDocument
extends AbstractParentNode
implements Document,
DocumentEvent,
DocumentTraversal,
Localizable,
XPathEvaluator {
    protected static final String RESOURCES = "org.apache.batik.dom.resources.Messages";
    protected transient LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.dom.resources.Messages", this.getClass().getClassLoader());
    protected transient DOMImplementation implementation;
    protected transient TraversalSupport traversalSupport;
    protected transient DocumentEventSupport documentEventSupport;
    protected transient boolean eventsEnabled;
    protected transient WeakHashMap elementsByTagNames;
    protected transient WeakHashMap elementsByTagNamesNS;
    protected String inputEncoding;
    protected String xmlEncoding;
    protected String xmlVersion = "1.0";
    protected boolean xmlStandalone;
    protected String documentURI;
    protected boolean strictErrorChecking = true;
    protected DocumentConfiguration domConfig;
    protected transient XBLManager xblManager = new GenericXBLManager();
    protected transient Map elementsById;

    protected AbstractDocument() {
    }

    public AbstractDocument(DocumentType documentType, DOMImplementation dOMImplementation) {
        this.implementation = dOMImplementation;
        if (documentType != null) {
            GenericDocumentType genericDocumentType;
            if (documentType instanceof GenericDocumentType && (genericDocumentType = (GenericDocumentType)documentType).getOwnerDocument() == null) {
                genericDocumentType.setOwnerDocument(this);
            }
            this.appendChild(documentType);
        }
    }

    public void setDocumentInputEncoding(String string) {
        this.inputEncoding = string;
    }

    public void setDocumentXmlEncoding(String string) {
        this.xmlEncoding = string;
    }

    public void setLocale(Locale locale) {
        this.localizableSupport.setLocale(locale);
    }

    public Locale getLocale() {
        return this.localizableSupport.getLocale();
    }

    public String formatMessage(String string, Object[] objectArray) throws MissingResourceException {
        return this.localizableSupport.formatMessage(string, objectArray);
    }

    public boolean getEventsEnabled() {
        return this.eventsEnabled;
    }

    public void setEventsEnabled(boolean bl) {
        this.eventsEnabled = bl;
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    public short getNodeType() {
        return 9;
    }

    @Override
    public DocumentType getDoctype() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 10) continue;
            return (DocumentType)node;
        }
        return null;
    }

    public void setDoctype(DocumentType documentType) {
        if (documentType != null) {
            this.appendChild(documentType);
            ((ExtendedNode)((Object)documentType)).setReadonly(true);
        }
    }

    @Override
    public DOMImplementation getImplementation() {
        return this.implementation;
    }

    @Override
    public Element getDocumentElement() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    @Override
    public Node importNode(Node node, boolean bl) throws DOMException {
        return this.importNode(node, bl, false);
    }

    public Node importNode(Node node, boolean bl, boolean bl2) {
        Node node2;
        Node node3;
        switch (node.getNodeType()) {
            case 1: {
                node3 = this.createElementNS(node.getNamespaceURI(), node.getNodeName());
                node2 = node3;
                if (!node.hasAttributes()) break;
                Object object = node.getAttributes();
                int n = object.getLength();
                for (int i = 0; i < n; ++i) {
                    Attr attr = (Attr)object.item(i);
                    if (!attr.getSpecified()) continue;
                    AbstractAttr abstractAttr = (AbstractAttr)this.importNode(attr, true);
                    if (bl2 && abstractAttr.isId()) {
                        abstractAttr.setIsId(false);
                    }
                    node3.setAttributeNodeNS(abstractAttr);
                }
                break;
            }
            case 2: {
                node2 = this.createAttributeNS(node.getNamespaceURI(), node.getNodeName());
                break;
            }
            case 3: {
                node2 = this.createTextNode(node.getNodeValue());
                bl = false;
                break;
            }
            case 4: {
                node2 = this.createCDATASection(node.getNodeValue());
                bl = false;
                break;
            }
            case 5: {
                node2 = this.createEntityReference(node.getNodeName());
                break;
            }
            case 7: {
                node2 = this.createProcessingInstruction(node.getNodeName(), node.getNodeValue());
                bl = false;
                break;
            }
            case 8: {
                node2 = this.createComment(node.getNodeValue());
                bl = false;
                break;
            }
            case 11: {
                node2 = this.createDocumentFragment();
                break;
            }
            case 10: {
                Object object = (DocumentType)node;
                GenericDocumentType genericDocumentType = new GenericDocumentType(object.getName(), object.getPublicId(), object.getSystemId());
                genericDocumentType.ownerDocument = this;
                node2 = genericDocumentType;
                break;
            }
            default: {
                throw this.createDOMException((short)9, "import.node", new Object[0]);
            }
        }
        if (node instanceof AbstractNode) {
            this.fireUserDataHandlers((short)2, node, node2);
        }
        if (bl) {
            for (node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                node2.appendChild(this.importNode(node3, true));
            }
        }
        return node2;
    }

    @Override
    public Node cloneNode(boolean bl) {
        Document document = (Document)this.newNode();
        this.copyInto(document);
        this.fireUserDataHandlers((short)1, this, document);
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                document.appendChild(document.importNode(node, bl));
            }
        }
        return document;
    }

    public abstract boolean isId(Attr var1);

    @Override
    public Element getElementById(String string) {
        return this.getChildElementById(this.getDocumentElement(), string);
    }

    public Element getChildElementById(Node node, String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (this.elementsById == null) {
            return null;
        }
        Node node2 = this.getRoot(node);
        Object object = this.elementsById.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof IdSoftRef) {
            if ((object = ((IdSoftRef)((Object)object)).get()) == null) {
                this.elementsById.remove(string);
                return null;
            }
            Element element = (Element)object;
            if (this.getRoot(element) == node2) {
                return element;
            }
            return null;
        }
        List list = (List)object;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IdSoftRef idSoftRef = (IdSoftRef)((Object)iterator.next());
            object = idSoftRef.get();
            if (object == null) {
                iterator.remove();
                continue;
            }
            Element element = (Element)object;
            if (this.getRoot(element) != node2) continue;
            return element;
        }
        return null;
    }

    protected Node getRoot(Node node) {
        Node node2 = node;
        while (node != null) {
            node2 = node;
            node = node.getParentNode();
        }
        return node2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIdEntry(Element element, String string) {
        if (string == null) {
            return;
        }
        if (this.elementsById == null) {
            return;
        }
        Map map = this.elementsById;
        synchronized (map) {
            Object object = this.elementsById.get(string);
            if (object == null) {
                return;
            }
            if (object instanceof IdSoftRef) {
                this.elementsById.remove(string);
                return;
            }
            List list = (List)object;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IdSoftRef idSoftRef = (IdSoftRef)((Object)iterator.next());
                object = idSoftRef.get();
                if (object == null) {
                    iterator.remove();
                    continue;
                }
                if (element != object) continue;
                iterator.remove();
                break;
            }
            if (list.size() == 0) {
                this.elementsById.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdEntry(Element element, String string) {
        if (string == null) {
            return;
        }
        if (this.elementsById == null) {
            HashMap<String, IdSoftRef> hashMap = new HashMap<String, IdSoftRef>();
            hashMap.put(string, new IdSoftRef(element, string));
            this.elementsById = hashMap;
            return;
        }
        Map map = this.elementsById;
        synchronized (map) {
            Object v = this.elementsById.get(string);
            if (v == null) {
                this.elementsById.put(string, new IdSoftRef(element, string));
                return;
            }
            if (v instanceof IdSoftRef) {
                IdSoftRef idSoftRef = (IdSoftRef)((Object)v);
                Object object = idSoftRef.get();
                if (object == null) {
                    this.elementsById.put(string, new IdSoftRef(element, string));
                    return;
                }
                ArrayList<IdSoftRef> arrayList = new ArrayList<IdSoftRef>(4);
                idSoftRef.setList(arrayList);
                arrayList.add(idSoftRef);
                arrayList.add(new IdSoftRef(element, string, arrayList));
                this.elementsById.put(string, arrayList);
                return;
            }
            List list = (List)v;
            list.add(new IdSoftRef(element, string, list));
        }
    }

    public void updateIdEntry(Element element, String string, String string2) {
        if (string == string2 || string != null && string.equals(string2)) {
            return;
        }
        this.removeIdEntry(element, string);
        this.addIdEntry(element, string2);
    }

    public AbstractParentNode.ElementsByTagName getElementsByTagName(Node node, String string) {
        if (this.elementsByTagNames == null) {
            return null;
        }
        SoftDoublyIndexedTable softDoublyIndexedTable = (SoftDoublyIndexedTable)this.elementsByTagNames.get(node);
        if (softDoublyIndexedTable == null) {
            return null;
        }
        return (AbstractParentNode.ElementsByTagName)softDoublyIndexedTable.get(null, (Object)string);
    }

    public void putElementsByTagName(Node node, String string, AbstractParentNode.ElementsByTagName elementsByTagName) {
        SoftDoublyIndexedTable softDoublyIndexedTable;
        if (this.elementsByTagNames == null) {
            this.elementsByTagNames = new WeakHashMap(11);
        }
        if ((softDoublyIndexedTable = (SoftDoublyIndexedTable)this.elementsByTagNames.get(node)) == null) {
            softDoublyIndexedTable = new SoftDoublyIndexedTable();
            this.elementsByTagNames.put(node, softDoublyIndexedTable);
        }
        softDoublyIndexedTable.put(null, (Object)string, (Object)elementsByTagName);
    }

    public AbstractParentNode.ElementsByTagNameNS getElementsByTagNameNS(Node node, String string, String string2) {
        if (this.elementsByTagNamesNS == null) {
            return null;
        }
        SoftDoublyIndexedTable softDoublyIndexedTable = (SoftDoublyIndexedTable)this.elementsByTagNamesNS.get(node);
        if (softDoublyIndexedTable == null) {
            return null;
        }
        return (AbstractParentNode.ElementsByTagNameNS)softDoublyIndexedTable.get((Object)string, (Object)string2);
    }

    public void putElementsByTagNameNS(Node node, String string, String string2, AbstractParentNode.ElementsByTagNameNS elementsByTagNameNS) {
        SoftDoublyIndexedTable softDoublyIndexedTable;
        if (this.elementsByTagNamesNS == null) {
            this.elementsByTagNamesNS = new WeakHashMap(11);
        }
        if ((softDoublyIndexedTable = (SoftDoublyIndexedTable)this.elementsByTagNamesNS.get(node)) == null) {
            softDoublyIndexedTable = new SoftDoublyIndexedTable();
            this.elementsByTagNamesNS.put(node, softDoublyIndexedTable);
        }
        softDoublyIndexedTable.put((Object)string, (Object)string2, (Object)elementsByTagNameNS);
    }

    @Override
    public Event createEvent(String string) throws DOMException {
        if (this.documentEventSupport == null) {
            this.documentEventSupport = ((AbstractDOMImplementation)this.implementation).createDocumentEventSupport();
        }
        return this.documentEventSupport.createEvent(string);
    }

    public boolean canDispatch(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string == null || string.equals("http://www.w3.org/2001/xml-events")) {
            return string2.equals("Event") || string2.equals("MutationEvent") || string2.equals("MutationNameEvent") || string2.equals("UIEvent") || string2.equals("MouseEvent") || string2.equals("KeyEvent") || string2.equals("KeyboardEvent") || string2.equals("TextEvent") || string2.equals("CustomEvent");
        }
        return false;
    }

    @Override
    public NodeIterator createNodeIterator(Node node, int n, NodeFilter nodeFilter, boolean bl) throws DOMException {
        if (this.traversalSupport == null) {
            this.traversalSupport = new TraversalSupport();
        }
        return this.traversalSupport.createNodeIterator(this, node, n, nodeFilter, bl);
    }

    @Override
    public TreeWalker createTreeWalker(Node node, int n, NodeFilter nodeFilter, boolean bl) throws DOMException {
        return TraversalSupport.createTreeWalker(this, node, n, nodeFilter, bl);
    }

    public void detachNodeIterator(NodeIterator nodeIterator) {
        this.traversalSupport.detachNodeIterator(nodeIterator);
    }

    @Override
    public void nodeToBeRemoved(Node node) {
        if (this.traversalSupport != null) {
            this.traversalSupport.nodeToBeRemoved(node);
        }
    }

    @Override
    protected AbstractDocument getCurrentDocument() {
        return this;
    }

    protected Node export(Node node, Document document) {
        throw this.createDOMException((short)9, "import.document", new Object[0]);
    }

    protected Node deepExport(Node node, Document document) {
        throw this.createDOMException((short)9, "import.document", new Object[0]);
    }

    @Override
    protected Node copyInto(Node node) {
        super.copyInto(node);
        AbstractDocument abstractDocument = (AbstractDocument)node;
        abstractDocument.implementation = this.implementation;
        abstractDocument.localizableSupport = new LocalizableSupport(RESOURCES, this.getClass().getClassLoader());
        abstractDocument.inputEncoding = this.inputEncoding;
        abstractDocument.xmlEncoding = this.xmlEncoding;
        abstractDocument.xmlVersion = this.xmlVersion;
        abstractDocument.xmlStandalone = this.xmlStandalone;
        abstractDocument.documentURI = this.documentURI;
        abstractDocument.strictErrorChecking = this.strictErrorChecking;
        return node;
    }

    @Override
    protected Node deepCopyInto(Node node) {
        super.deepCopyInto(node);
        AbstractDocument abstractDocument = (AbstractDocument)node;
        abstractDocument.implementation = this.implementation;
        abstractDocument.localizableSupport = new LocalizableSupport(RESOURCES, this.getClass().getClassLoader());
        return node;
    }

    @Override
    protected void checkChildType(Node node, boolean bl) {
        short s = node.getNodeType();
        switch (s) {
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            default: {
                throw this.createDOMException((short)3, "child.type", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), new Integer(s), node.getNodeName()});
            }
        }
        if (!bl && s == 1 && this.getDocumentElement() != null || s == 10 && this.getDoctype() != null) {
            throw this.createDOMException((short)9, "document.child.already.exists", new Object[]{new Integer(s), node.getNodeName()});
        }
    }

    @Override
    public String getInputEncoding() {
        return this.inputEncoding;
    }

    @Override
    public String getXmlEncoding() {
        return this.xmlEncoding;
    }

    @Override
    public boolean getXmlStandalone() {
        return this.xmlStandalone;
    }

    @Override
    public void setXmlStandalone(boolean bl) throws DOMException {
        this.xmlStandalone = bl;
    }

    @Override
    public String getXmlVersion() {
        return this.xmlVersion;
    }

    @Override
    public void setXmlVersion(String string) throws DOMException {
        if (string == null || !string.equals("1.0") && !string.equals("1.1")) {
            throw this.createDOMException((short)9, "xml.version", new Object[]{string});
        }
        this.xmlVersion = string;
    }

    @Override
    public boolean getStrictErrorChecking() {
        return this.strictErrorChecking;
    }

    @Override
    public void setStrictErrorChecking(boolean bl) {
        this.strictErrorChecking = bl;
    }

    @Override
    public String getDocumentURI() {
        return this.documentURI;
    }

    @Override
    public void setDocumentURI(String string) {
        this.documentURI = string;
    }

    @Override
    public DOMConfiguration getDomConfig() {
        if (this.domConfig == null) {
            this.domConfig = new DocumentConfiguration();
        }
        return this.domConfig;
    }

    @Override
    public Node adoptNode(Node node) throws DOMException {
        if (!(node instanceof AbstractNode)) {
            return null;
        }
        switch (node.getNodeType()) {
            case 9: {
                throw this.createDOMException((short)9, "adopt.document", new Object[0]);
            }
            case 10: {
                throw this.createDOMException((short)9, "adopt.document.type", new Object[0]);
            }
            case 6: 
            case 12: {
                return null;
            }
        }
        AbstractNode abstractNode = (AbstractNode)node;
        if (abstractNode.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(abstractNode.getNodeType()), abstractNode.getNodeName()});
        }
        Node node2 = node.getParentNode();
        if (node2 != null) {
            node2.removeChild(node);
        }
        this.adoptNode1((AbstractNode)node);
        return node;
    }

    protected void adoptNode1(AbstractNode abstractNode) {
        Node node;
        abstractNode.ownerDocument = this;
        switch (abstractNode.getNodeType()) {
            case 2: {
                node = (AbstractAttr)abstractNode;
                ((AbstractAttr)node).ownerElement = null;
                ((AbstractAttr)node).unspecified = false;
                break;
            }
            case 1: {
                NamedNodeMap namedNodeMap = abstractNode.getAttributes();
                int n = namedNodeMap.getLength();
                for (int i = 0; i < n; ++i) {
                    node = (AbstractAttr)namedNodeMap.item(i);
                    if (!((AbstractAttr)node).getSpecified()) continue;
                    this.adoptNode1((AbstractNode)node);
                }
                break;
            }
            case 5: {
                while (abstractNode.getFirstChild() != null) {
                    abstractNode.removeChild(abstractNode.getFirstChild());
                }
                break;
            }
        }
        this.fireUserDataHandlers((short)5, abstractNode, null);
        for (node = abstractNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 6: 
                case 10: 
                case 12: {
                    return;
                }
            }
            this.adoptNode1((AbstractNode)node);
        }
    }

    @Override
    public Node renameNode(Node node, String string, String string2) {
        AbstractNode abstractNode = (AbstractNode)node;
        if (abstractNode == this.getDocumentElement()) {
            throw this.createDOMException((short)9, "rename.document.element", new Object[0]);
        }
        short s = node.getNodeType();
        if (s != 1 && s != 2) {
            throw this.createDOMException((short)9, "rename.node", new Object[]{new Integer(s), node.getNodeName()});
        }
        if (this.xmlVersion.equals("1.1") && !DOMUtilities.isValidName11(string2) || !DOMUtilities.isValidName(string2)) {
            throw this.createDOMException((short)9, "wf.invalid.name", new Object[]{string2});
        }
        if (node.getOwnerDocument() != this) {
            throw this.createDOMException((short)9, "node.from.wrong.document", new Object[]{new Integer(s), node.getNodeName()});
        }
        int n = string2.indexOf(58);
        if (n == 0 || n == string2.length() - 1) {
            throw this.createDOMException((short)14, "qname", new Object[]{new Integer(s), node.getNodeName(), string2});
        }
        String string3 = DOMUtilities.getPrefix(string2);
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string3 != null && string == null) {
            throw this.createDOMException((short)14, "prefix", new Object[]{new Integer(s), node.getNodeName(), string3});
        }
        if (this.strictErrorChecking && ("xml".equals(string3) && !"http://www.w3.org/XML/1998/namespace".equals(string) || "xmlns".equals(string3) && !"http://www.w3.org/2000/xmlns/".equals(string))) {
            throw this.createDOMException((short)14, "namespace", new Object[]{new Integer(s), node.getNodeName(), string});
        }
        String string4 = node.getNamespaceURI();
        String string5 = node.getNodeName();
        if (s == 1) {
            Object object;
            EventSupport eventSupport;
            Node node2 = node.getParentNode();
            AbstractElement abstractElement = (AbstractElement)this.createElementNS(string, string2);
            EventSupport eventSupport2 = abstractNode.getEventSupport();
            if (eventSupport2 != null) {
                eventSupport = abstractElement.getEventSupport();
                if (eventSupport == null) {
                    object = (AbstractDOMImplementation)this.implementation;
                    eventSupport = ((AbstractDOMImplementation)object).createEventSupport(abstractElement);
                    this.setEventsEnabled(true);
                    abstractElement.eventSupport = eventSupport;
                }
                eventSupport2.moveEventListeners(abstractElement.getEventSupport());
            }
            abstractElement.userData = abstractElement.userData == null ? null : (HashMap)abstractNode.userData.clone();
            abstractElement.userDataHandlers = abstractElement.userDataHandlers == null ? null : (HashMap)abstractNode.userDataHandlers.clone();
            eventSupport = null;
            if (node2 != null) {
                node.getNextSibling();
                node2.removeChild(node);
            }
            while (node.getFirstChild() != null) {
                abstractElement.appendChild(node.getFirstChild());
            }
            object = node.getAttributes();
            for (int i = 0; i < object.getLength(); ++i) {
                Attr attr = (Attr)object.item(i);
                abstractElement.setAttributeNodeNS(attr);
            }
            if (node2 != null) {
                if (eventSupport == null) {
                    node2.appendChild(abstractElement);
                } else {
                    node2.insertBefore((Node)((Object)eventSupport), abstractElement);
                }
            }
            this.fireUserDataHandlers((short)4, node, abstractElement);
            if (this.getEventsEnabled()) {
                MutationNameEvent mutationNameEvent = (MutationNameEvent)this.createEvent("MutationNameEvent");
                mutationNameEvent.initMutationNameEventNS("http://www.w3.org/2001/xml-events", "DOMElementNameChanged", true, false, null, string4, string5);
                this.dispatchEvent((Event)mutationNameEvent);
            }
            return abstractElement;
        }
        if (node instanceof AbstractAttrNS) {
            AbstractAttrNS abstractAttrNS = (AbstractAttrNS)node;
            Element element = abstractAttrNS.getOwnerElement();
            if (element != null) {
                element.removeAttributeNode(abstractAttrNS);
            }
            abstractAttrNS.namespaceURI = string;
            abstractAttrNS.nodeName = string2;
            if (element != null) {
                element.setAttributeNodeNS(abstractAttrNS);
            }
            this.fireUserDataHandlers((short)4, abstractAttrNS, null);
            if (this.getEventsEnabled()) {
                MutationNameEvent mutationNameEvent = (MutationNameEvent)this.createEvent("MutationNameEvent");
                mutationNameEvent.initMutationNameEventNS("http://www.w3.org/2001/xml-events", "DOMAttrNameChanged", true, false, (Node)abstractAttrNS, string4, string5);
                this.dispatchEvent((Event)mutationNameEvent);
            }
            return abstractAttrNS;
        }
        AbstractAttr abstractAttr = (AbstractAttr)node;
        Element element = abstractAttr.getOwnerElement();
        if (element != null) {
            element.removeAttributeNode(abstractAttr);
        }
        AbstractAttr abstractAttr2 = (AbstractAttr)this.createAttributeNS(string, string2);
        abstractAttr2.setNodeValue(abstractAttr.getNodeValue());
        abstractAttr2.userData = abstractAttr.userData == null ? null : (HashMap)abstractAttr.userData.clone();
        HashMap hashMap = abstractAttr2.userDataHandlers = abstractAttr.userDataHandlers == null ? null : (HashMap)abstractAttr.userDataHandlers.clone();
        if (element != null) {
            element.setAttributeNodeNS(abstractAttr2);
        }
        this.fireUserDataHandlers((short)4, abstractAttr, abstractAttr2);
        if (this.getEventsEnabled()) {
            MutationNameEvent mutationNameEvent = (MutationNameEvent)this.createEvent("MutationNameEvent");
            mutationNameEvent.initMutationNameEventNS("http://www.w3.org/2001/xml-events", "DOMAttrNameChanged", true, false, (Node)abstractAttr2, string4, string5);
            this.dispatchEvent((Event)mutationNameEvent);
        }
        return abstractAttr2;
    }

    @Override
    public void normalizeDocument() {
        if (this.domConfig == null) {
            this.domConfig = new DocumentConfiguration();
        }
        boolean bl = this.domConfig.getBooleanParameter("cdata-sections");
        boolean bl2 = this.domConfig.getBooleanParameter("comments");
        boolean bl3 = this.domConfig.getBooleanParameter("element-content-whitespace");
        boolean bl4 = this.domConfig.getBooleanParameter("namespace-declarations");
        boolean bl5 = this.domConfig.getBooleanParameter("namespaces");
        boolean bl6 = this.domConfig.getBooleanParameter("split-cdata-sections");
        DOMErrorHandler dOMErrorHandler = (DOMErrorHandler)this.domConfig.getParameter("error-handler");
        this.normalizeDocument(this.getDocumentElement(), bl, bl2, bl3, bl4, bl5, bl6, dOMErrorHandler);
    }

    protected boolean normalizeDocument(Element element, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, DOMErrorHandler dOMErrorHandler) {
        String string;
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        AbstractElement abstractElement = (AbstractElement)element;
        Object object4 = element.getFirstChild();
        while (object4 != null) {
            short s = object4.getNodeType();
            if (s == 3 || !bl && s == 4) {
                Object object5;
                object3 = object4;
                serializable = new StringBuffer();
                ((StringBuffer)serializable).append(object3.getNodeValue());
                object4 = object4.getNextSibling();
                while (object4 != null && (object4.getNodeType() == 3 || !bl && object4.getNodeType() == 4)) {
                    ((StringBuffer)serializable).append(object4.getNodeValue());
                    object5 = object4.getNextSibling();
                    element.removeChild((Node)object4);
                    object4 = object5;
                }
                object5 = ((StringBuffer)serializable).toString();
                if (((String)object5).length() == 0) {
                    object2 = object4.getNextSibling();
                    element.removeChild((Node)object4);
                    object4 = object2;
                    continue;
                }
                if (!((String)object5).equals(object3.getNodeValue())) {
                    if (!bl && s == 3) {
                        object4 = this.createTextNode((String)object5);
                        element.replaceChild((Node)object4, (Node)object3);
                    } else {
                        object4 = object3;
                        object3.setNodeValue((String)object5);
                    }
                } else {
                    object4 = object3;
                }
                if (!bl3 && (s = object4.getNodeType()) == 3 && ((AbstractText)(object2 = (AbstractText)object4)).isElementContentWhitespace()) {
                    object = object4.getNextSibling();
                    element.removeChild((Node)object4);
                    object4 = object;
                    continue;
                }
                if (s == 4 && bl6 && !this.splitCdata(element, (Node)object4, dOMErrorHandler)) {
                    return false;
                }
            } else if (s == 4 && bl6) {
                if (!this.splitCdata(element, (Node)object4, dOMErrorHandler)) {
                    return false;
                }
            } else if (s == 8 && !bl2) {
                object3 = object4.getPreviousSibling();
                if (object3 == null) {
                    object3 = object4.getNextSibling();
                }
                element.removeChild((Node)object4);
                object4 = object3;
                continue;
            }
            object4 = object4.getNextSibling();
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        object3 = new LinkedList();
        serializable = new HashMap();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            object2 = (Attr)namedNodeMap.item(i);
            object = object2.getPrefix();
            if ((object2 == null || !"xmlns".equals(object)) && !object2.getNodeName().equals("xmlns")) continue;
            if (!bl4) {
                ((LinkedList)object3).add(object2);
                continue;
            }
            string = object2.getNodeValue();
            if (object2.getNodeValue().equals("http://www.w3.org/2000/xmlns/") || !string.equals("http://www.w3.org/2000/xmlns/")) continue;
            ((HashMap)serializable).put(object, string);
        }
        if (!bl4) {
            Iterator iterator = ((AbstractSequentialList)object3).iterator();
            while (iterator.hasNext()) {
                element.removeAttributeNode((Attr)iterator.next());
            }
        } else if (bl5) {
            String string2 = element.getNamespaceURI();
            if (string2 != null) {
                object2 = element.getPrefix();
                if (!this.compareStrings(abstractElement.lookupNamespaceURI((String)object2), string2)) {
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", object2 == null ? "xmlns" : "xmlns:" + (String)object2, string2);
                }
            } else if (element.getLocalName() != null && abstractElement.lookupNamespaceURI(null) == null) {
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
            }
            namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                object = (Attr)namedNodeMap.item(i);
                string = object.getNamespaceURI();
                if (string != null) {
                    String string3;
                    String string4 = object.getPrefix();
                    if (string4 != null && (string4.equals("xml") || string4.equals("xmlns")) || string.equals("http://www.w3.org/2000/xmlns/")) continue;
                    String string5 = string3 = string4 == null ? null : abstractElement.lookupNamespaceURI(string4);
                    if (string4 != null && string3 != null && string3.equals(string)) continue;
                    String string6 = abstractElement.lookupPrefix(string);
                    if (string6 != null) {
                        object.setPrefix(string6);
                        continue;
                    }
                    if (string4 != null && abstractElement.lookupNamespaceURI(string4) == null) {
                        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string4, string);
                        continue;
                    }
                    int n = 1;
                    while (abstractElement.lookupPrefix(string6 = "NS" + n) != null) {
                    }
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string6, string);
                    object.setPrefix(string6);
                    continue;
                }
                if (object.getLocalName() != null) continue;
            }
        }
        namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (!this.checkName(attr.getNodeName()) && dOMErrorHandler != null && !dOMErrorHandler.handleError(this.createDOMError("wf-invalid-character-in-node-name", (short)2, "wf.invalid.name", new Object[]{attr.getNodeName()}, attr, null))) {
                return false;
            }
            if (this.checkChars(attr.getNodeValue()) || dOMErrorHandler == null || dOMErrorHandler.handleError(this.createDOMError("wf-invalid-character", (short)2, "wf.invalid.character", new Object[]{new Integer(2), attr.getNodeName(), attr.getNodeValue()}, attr, null))) continue;
            return false;
        }
        block14: for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            short s = node.getNodeType();
            switch (s) {
                case 3: {
                    object = node.getNodeValue();
                    if (this.checkChars((String)object) || dOMErrorHandler == null || dOMErrorHandler.handleError(this.createDOMError("wf-invalid-character", (short)2, "wf.invalid.character", new Object[]{new Integer(node.getNodeType()), node.getNodeName(), object}, node, null))) continue block14;
                    return false;
                }
                case 8: {
                    object = node.getNodeValue();
                    if (this.checkChars((String)object) && ((String)object).indexOf("--") == -1 && ((String)object).charAt(((String)object).length() - 1) != '-' || dOMErrorHandler == null || dOMErrorHandler.handleError(this.createDOMError("wf-invalid-character", (short)2, "wf.invalid.character", new Object[]{new Integer(node.getNodeType()), node.getNodeName(), object}, node, null))) continue block14;
                    return false;
                }
                case 4: {
                    object = node.getNodeValue();
                    if (this.checkChars((String)object) && ((String)object).indexOf("]]>") == -1 || dOMErrorHandler == null || dOMErrorHandler.handleError(this.createDOMError("wf-invalid-character", (short)2, "wf.invalid.character", new Object[]{new Integer(node.getNodeType()), node.getNodeName(), object}, node, null))) continue block14;
                    return false;
                }
                case 7: {
                    if (node.getNodeName().equalsIgnoreCase("xml") && dOMErrorHandler != null && !dOMErrorHandler.handleError(this.createDOMError("wf-invalid-character-in-node-name", (short)2, "wf.invalid.name", new Object[]{node.getNodeName()}, node, null))) {
                        return false;
                    }
                    object = node.getNodeValue();
                    if (this.checkChars((String)object) && ((String)object).indexOf("?>") == -1 || dOMErrorHandler == null || dOMErrorHandler.handleError(this.createDOMError("wf-invalid-character", (short)2, "wf.invalid.character", new Object[]{new Integer(node.getNodeType()), node.getNodeName(), object}, node, null))) continue block14;
                    return false;
                }
                case 1: {
                    if (!this.checkName(node.getNodeName()) && dOMErrorHandler != null && !dOMErrorHandler.handleError(this.createDOMError("wf-invalid-character-in-node-name", (short)2, "wf.invalid.name", new Object[]{node.getNodeName()}, node, null))) {
                        return false;
                    }
                    if (this.normalizeDocument((Element)node, bl, bl2, bl3, bl4, bl5, bl6, dOMErrorHandler)) continue block14;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean splitCdata(Element element, Node node, DOMErrorHandler dOMErrorHandler) {
        String string = node.getNodeValue();
        int n = string.indexOf("]]>");
        if (n != -1) {
            String string2 = string.substring(0, n + 2);
            String string3 = string.substring(n + 2);
            node.setNodeValue(string2);
            Node node2 = node.getNextSibling();
            if (node2 == null) {
                element.appendChild(this.createCDATASection(string3));
            } else {
                element.insertBefore(this.createCDATASection(string3), node2);
            }
            if (dOMErrorHandler != null && !dOMErrorHandler.handleError(this.createDOMError("cdata-sections-splitted", (short)1, "cdata.section.split", new Object[0], node, null))) {
                return false;
            }
        }
        return true;
    }

    protected boolean checkChars(String string) {
        int n = string.length();
        if (this.xmlVersion.equals("1.1")) {
            for (int i = 0; i < n; ++i) {
                if (DOMUtilities.isXML11Character((int)string.charAt(i))) continue;
                return false;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (DOMUtilities.isXMLCharacter((int)string.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean checkName(String string) {
        if (this.xmlVersion.equals("1.1")) {
            return DOMUtilities.isValidName11(string);
        }
        return DOMUtilities.isValidName(string);
    }

    protected DOMError createDOMError(String string, short s, String string2, Object[] objectArray, Node node, Exception exception) {
        try {
            return new DocumentError(string, s, this.getCurrentDocument().formatMessage(string2, objectArray), node, exception);
        }
        catch (Exception exception2) {
            return new DocumentError(string, s, string2, node, exception);
        }
    }

    @Override
    public void setTextContent(String string) throws DOMException {
    }

    public void setXBLManager(XBLManager xBLManager) {
        boolean bl = this.xblManager.isProcessing();
        this.xblManager.stopProcessing();
        if (xBLManager == null) {
            xBLManager = new GenericXBLManager();
        }
        this.xblManager = xBLManager;
        if (bl) {
            this.xblManager.startProcessing();
        }
    }

    public XBLManager getXBLManager() {
        return this.xblManager;
    }

    @Override
    public XPathExpression createExpression(String string, XPathNSResolver xPathNSResolver) throws DOMException, XPathException {
        return new XPathExpr(string, xPathNSResolver);
    }

    @Override
    public XPathNSResolver createNSResolver(Node node) {
        return new XPathNodeNSResolver(node);
    }

    @Override
    public Object evaluate(String string, Node node, XPathNSResolver xPathNSResolver, short s, Object object) throws XPathException, DOMException {
        XPathExpression xPathExpression = this.createExpression(string, xPathNSResolver);
        return xPathExpression.evaluate(node, s, object);
    }

    public XPathException createXPathException(short s, String string, Object[] objectArray) {
        try {
            return new XPathException(s, this.formatMessage(string, objectArray));
        }
        catch (Exception exception) {
            return new XPathException(s, string);
        }
    }

    @Override
    public Node getXblParentNode() {
        return this.xblManager.getXblParentNode(this);
    }

    @Override
    public NodeList getXblChildNodes() {
        return this.xblManager.getXblChildNodes(this);
    }

    @Override
    public NodeList getXblScopedChildNodes() {
        return this.xblManager.getXblScopedChildNodes(this);
    }

    @Override
    public Node getXblFirstChild() {
        return this.xblManager.getXblFirstChild(this);
    }

    @Override
    public Node getXblLastChild() {
        return this.xblManager.getXblLastChild(this);
    }

    @Override
    public Node getXblPreviousSibling() {
        return this.xblManager.getXblPreviousSibling(this);
    }

    @Override
    public Node getXblNextSibling() {
        return this.xblManager.getXblNextSibling(this);
    }

    @Override
    public Element getXblFirstElementChild() {
        return this.xblManager.getXblFirstElementChild(this);
    }

    @Override
    public Element getXblLastElementChild() {
        return this.xblManager.getXblLastElementChild(this);
    }

    @Override
    public Element getXblPreviousElementSibling() {
        return this.xblManager.getXblPreviousElementSibling(this);
    }

    @Override
    public Element getXblNextElementSibling() {
        return this.xblManager.getXblNextElementSibling(this);
    }

    @Override
    public Element getXblBoundElement() {
        return this.xblManager.getXblBoundElement(this);
    }

    @Override
    public Element getXblShadowTree() {
        return this.xblManager.getXblShadowTree(this);
    }

    @Override
    public NodeList getXblDefinitions() {
        return this.xblManager.getXblDefinitions(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.implementation.getClass().getName());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.localizableSupport = new LocalizableSupport(RESOURCES, this.getClass().getClassLoader());
        Class<?> clazz = Class.forName((String)objectInputStream.readObject());
        try {
            Method method = clazz.getMethod("getDOMImplementation", null);
            this.implementation = (DOMImplementation)method.invoke(null, (Object[])null);
        }
        catch (Exception exception) {
            try {
                this.implementation = (DOMImplementation)clazz.newInstance();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    protected class XPathNodeNSResolver
    implements XPathNSResolver {
        protected Node contextNode;

        public XPathNodeNSResolver(Node node) {
            this.contextNode = node;
        }

        @Override
        public String lookupNamespaceURI(String string) {
            return ((AbstractNode)this.contextNode).lookupNamespaceURI(string);
        }
    }

    protected class XPathExpr
    implements XPathExpression {
        protected XPath xpath;
        protected XPathNSResolver resolver;
        protected NSPrefixResolver prefixResolver;
        protected XPathContext context;

        public XPathExpr(String string, XPathNSResolver xPathNSResolver) throws DOMException, XPathException {
            this.resolver = xPathNSResolver;
            this.prefixResolver = new NSPrefixResolver();
            try {
                this.xpath = new XPath(string, null, (PrefixResolver)this.prefixResolver, 0);
                this.context = new XPathContext();
            }
            catch (TransformerException transformerException) {
                throw AbstractDocument.this.createXPathException((short)51, "xpath.invalid.expression", new Object[]{string, transformerException.getMessage()});
            }
        }

        @Override
        public Object evaluate(Node node, short s, Object object) throws XPathException, DOMException {
            if (node.getNodeType() != 9 && node.getOwnerDocument() != AbstractDocument.this || node.getNodeType() == 9 && node != AbstractDocument.this) {
                throw AbstractDocument.this.createDOMException((short)4, "node.from.wrong.document", new Object[]{new Integer(node.getNodeType()), node.getNodeName()});
            }
            if (s < 0 || s > 9) {
                throw AbstractDocument.this.createDOMException((short)9, "xpath.invalid.result.type", new Object[]{new Integer(s)});
            }
            switch (node.getNodeType()) {
                case 5: 
                case 6: 
                case 10: 
                case 11: 
                case 12: {
                    throw AbstractDocument.this.createDOMException((short)9, "xpath.invalid.context.node", new Object[]{new Integer(node.getNodeType()), node.getNodeName()});
                }
            }
            this.context.reset();
            XObject xObject = null;
            try {
                xObject = this.xpath.execute(this.context, node, (PrefixResolver)this.prefixResolver);
            }
            catch (TransformerException transformerException) {
                throw AbstractDocument.this.createXPathException((short)51, "xpath.error", new Object[]{this.xpath.getPatternString(), transformerException.getMessage()});
            }
            try {
                switch (s) {
                    case 8: 
                    case 9: {
                        return this.convertSingleNode(xObject, s);
                    }
                    case 3: {
                        return this.convertBoolean(xObject);
                    }
                    case 1: {
                        return this.convertNumber(xObject);
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return this.convertNodeIterator(xObject, s);
                    }
                    case 2: {
                        return this.convertString(xObject);
                    }
                    case 0: {
                        switch (xObject.getType()) {
                            case 1: {
                                return this.convertBoolean(xObject);
                            }
                            case 2: {
                                return this.convertNumber(xObject);
                            }
                            case 3: {
                                return this.convertString(xObject);
                            }
                            case 4: {
                                return this.convertNodeIterator(xObject, (short)4);
                            }
                        }
                    }
                }
            }
            catch (TransformerException transformerException) {
                throw AbstractDocument.this.createXPathException((short)52, "xpath.cannot.convert.result", new Object[]{new Integer(s), transformerException.getMessage()});
            }
            return null;
        }

        protected Result convertSingleNode(XObject xObject, short s) throws TransformerException {
            return new Result(xObject.nodelist().item(0), s);
        }

        protected Result convertBoolean(XObject xObject) throws TransformerException {
            return new Result(xObject.bool());
        }

        protected Result convertNumber(XObject xObject) throws TransformerException {
            return new Result(xObject.num());
        }

        protected Result convertString(XObject xObject) {
            return new Result(xObject.str());
        }

        protected Result convertNodeIterator(XObject xObject, short s) throws TransformerException {
            return new Result(xObject.nodelist(), s);
        }

        protected class NSPrefixResolver
        implements PrefixResolver {
            protected NSPrefixResolver() {
            }

            public String getBaseIdentifier() {
                return null;
            }

            public String getNamespaceForPrefix(String string) {
                if (XPathExpr.this.resolver == null) {
                    return null;
                }
                return XPathExpr.this.resolver.lookupNamespaceURI(string);
            }

            public String getNamespaceForPrefix(String string, Node node) {
                if (XPathExpr.this.resolver == null) {
                    return null;
                }
                return XPathExpr.this.resolver.lookupNamespaceURI(string);
            }

            public boolean handlesNullPrefixes() {
                return false;
            }
        }

        public class Result
        implements XPathResult {
            protected short resultType;
            protected double numberValue;
            protected String stringValue;
            protected boolean booleanValue;
            protected Node singleNodeValue;
            protected NodeList iterator;
            protected int iteratorPosition;

            public Result(Node node, short s) {
                this.resultType = s;
                this.singleNodeValue = node;
            }

            public Result(boolean bl) throws TransformerException {
                this.resultType = (short)3;
                this.booleanValue = bl;
            }

            public Result(double d) throws TransformerException {
                this.resultType = 1;
                this.numberValue = d;
            }

            public Result(String string) {
                this.resultType = (short)2;
                this.stringValue = string;
            }

            public Result(NodeList nodeList, short s) {
                this.resultType = s;
                this.iterator = nodeList;
            }

            @Override
            public short getResultType() {
                return this.resultType;
            }

            @Override
            public boolean getBooleanValue() {
                if (this.resultType != 3) {
                    throw AbstractDocument.this.createXPathException((short)52, "xpath.invalid.result.type", new Object[]{new Integer(this.resultType)});
                }
                return this.booleanValue;
            }

            @Override
            public double getNumberValue() {
                if (this.resultType != 1) {
                    throw AbstractDocument.this.createXPathException((short)52, "xpath.invalid.result.type", new Object[]{new Integer(this.resultType)});
                }
                return this.numberValue;
            }

            @Override
            public String getStringValue() {
                if (this.resultType != 2) {
                    throw AbstractDocument.this.createXPathException((short)52, "xpath.invalid.result.type", new Object[]{new Integer(this.resultType)});
                }
                return this.stringValue;
            }

            @Override
            public Node getSingleNodeValue() {
                if (this.resultType != 8 && this.resultType != 9) {
                    throw AbstractDocument.this.createXPathException((short)52, "xpath.invalid.result.type", new Object[]{new Integer(this.resultType)});
                }
                return this.singleNodeValue;
            }

            @Override
            public boolean getInvalidIteratorState() {
                return false;
            }

            @Override
            public int getSnapshotLength() {
                if (this.resultType != 6 && this.resultType != 7) {
                    throw AbstractDocument.this.createXPathException((short)52, "xpath.invalid.result.type", new Object[]{new Integer(this.resultType)});
                }
                return this.iterator.getLength();
            }

            @Override
            public Node iterateNext() {
                if (this.resultType != 4 && this.resultType != 5) {
                    throw AbstractDocument.this.createXPathException((short)52, "xpath.invalid.result.type", new Object[]{new Integer(this.resultType)});
                }
                return this.iterator.item(this.iteratorPosition++);
            }

            @Override
            public Node snapshotItem(int n) {
                if (this.resultType != 6 && this.resultType != 7) {
                    throw AbstractDocument.this.createXPathException((short)52, "xpath.invalid.result.type", new Object[]{new Integer(this.resultType)});
                }
                return this.iterator.item(n);
            }
        }
    }

    protected class DocumentConfiguration
    implements DOMConfiguration {
        protected String[] booleanParamNames = new String[]{"canonical-form", "cdata-sections", "check-character-normalization", "comments", "datatype-normalization", "element-content-whitespace", "entities", "infoset", "namespaces", "namespace-declarations", "normalize-characters", "split-cdata-sections", "validate", "validate-if-schema", "well-formed"};
        protected boolean[] booleanParamValues = new boolean[]{false, true, false, true, false, false, true, false, true, true, false, true, false, false, true};
        protected boolean[] booleanParamReadOnly = new boolean[]{true, false, true, false, true, false, false, false, false, false, true, false, true, true, false};
        protected Map booleanParamIndexes = new HashMap();
        protected Object errorHandler;
        protected ParameterNameList paramNameList;

        protected DocumentConfiguration() {
            for (int i = 0; i < this.booleanParamNames.length; ++i) {
                this.booleanParamIndexes.put(this.booleanParamNames[i], new Integer(i));
            }
        }

        @Override
        public void setParameter(String string, Object object) {
            if ("error-handler".equals(string)) {
                if (object != null && !(object instanceof DOMErrorHandler)) {
                    throw AbstractDocument.this.createDOMException((short)17, "domconfig.param.type", new Object[]{string});
                }
                this.errorHandler = object;
                return;
            }
            Integer n = (Integer)this.booleanParamIndexes.get(string);
            if (n == null) {
                throw AbstractDocument.this.createDOMException((short)8, "domconfig.param.not.found", new Object[]{string});
            }
            if (object == null) {
                throw AbstractDocument.this.createDOMException((short)9, "domconfig.param.value", new Object[]{string});
            }
            if (!(object instanceof Boolean)) {
                throw AbstractDocument.this.createDOMException((short)17, "domconfig.param.type", new Object[]{string});
            }
            int n2 = n;
            boolean bl = (Boolean)object;
            if (this.booleanParamReadOnly[n2] && this.booleanParamValues[n2] != bl) {
                throw AbstractDocument.this.createDOMException((short)9, "domconfig.param.value", new Object[]{string});
            }
            this.booleanParamValues[n2] = bl;
            if (string.equals("infoset")) {
                this.setParameter("validate-if-schema", Boolean.FALSE);
                this.setParameter("entities", Boolean.FALSE);
                this.setParameter("datatype-normalization", Boolean.FALSE);
                this.setParameter("cdata-sections", Boolean.FALSE);
                this.setParameter("well-formed", Boolean.TRUE);
                this.setParameter("element-content-whitespace", Boolean.TRUE);
                this.setParameter("comments", Boolean.TRUE);
                this.setParameter("namespaces", Boolean.TRUE);
            }
        }

        @Override
        public Object getParameter(String string) {
            if ("error-handler".equals(string)) {
                return this.errorHandler;
            }
            Integer n = (Integer)this.booleanParamIndexes.get(string);
            if (n == null) {
                throw AbstractDocument.this.createDOMException((short)8, "domconfig.param.not.found", new Object[]{string});
            }
            return this.booleanParamValues[n] ? Boolean.TRUE : Boolean.FALSE;
        }

        public boolean getBooleanParameter(String string) {
            Boolean bl = (Boolean)this.getParameter(string);
            return bl;
        }

        @Override
        public boolean canSetParameter(String string, Object object) {
            if (string.equals("error-handler")) {
                return object == null || object instanceof DOMErrorHandler;
            }
            Integer n = (Integer)this.booleanParamIndexes.get(string);
            if (n == null || object == null || !(object instanceof Boolean)) {
                return false;
            }
            int n2 = n;
            boolean bl = (Boolean)object;
            return !this.booleanParamReadOnly[n2] || this.booleanParamValues[n2] == bl;
        }

        @Override
        public DOMStringList getParameterNames() {
            if (this.paramNameList == null) {
                this.paramNameList = new ParameterNameList();
            }
            return this.paramNameList;
        }

        protected class ParameterNameList
        implements DOMStringList {
            protected ParameterNameList() {
            }

            @Override
            public String item(int n) {
                if (n < 0) {
                    return null;
                }
                if (n < DocumentConfiguration.this.booleanParamNames.length) {
                    return DocumentConfiguration.this.booleanParamNames[n];
                }
                if (n == DocumentConfiguration.this.booleanParamNames.length) {
                    return "error-handler";
                }
                return null;
            }

            @Override
            public int getLength() {
                return DocumentConfiguration.this.booleanParamNames.length + 1;
            }

            @Override
            public boolean contains(String string) {
                if ("error-handler".equals(string)) {
                    return true;
                }
                for (int i = 0; i < DocumentConfiguration.this.booleanParamNames.length; ++i) {
                    if (!DocumentConfiguration.this.booleanParamNames[i].equals(string)) continue;
                    return true;
                }
                return false;
            }
        }
    }

    protected class DocumentError
    implements DOMError {
        protected String type;
        protected short severity;
        protected String message;
        protected Node relatedNode;
        protected Object relatedException;
        protected DOMLocator domLocator;

        public DocumentError(String string, short s, String string2, Node node, Exception exception) {
            this.type = string;
            this.severity = s;
            this.message = string2;
            this.relatedNode = node;
            this.relatedException = exception;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public short getSeverity() {
            return this.severity;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public Object getRelatedData() {
            return this.relatedNode;
        }

        @Override
        public Object getRelatedException() {
            return this.relatedException;
        }

        @Override
        public DOMLocator getLocation() {
            if (this.domLocator == null) {
                this.domLocator = new ErrorLocation(this.relatedNode);
            }
            return this.domLocator;
        }

        protected class ErrorLocation
        implements DOMLocator {
            protected Node node;

            public ErrorLocation(Node node) {
                this.node = node;
            }

            @Override
            public int getLineNumber() {
                return -1;
            }

            @Override
            public int getColumnNumber() {
                return -1;
            }

            @Override
            public int getByteOffset() {
                return -1;
            }

            @Override
            public int getUtf16Offset() {
                return -1;
            }

            @Override
            public Node getRelatedNode() {
                return this.node;
            }

            @Override
            public String getUri() {
                AbstractDocument abstractDocument = (AbstractDocument)this.node.getOwnerDocument();
                return abstractDocument.getDocumentURI();
            }
        }
    }

    protected class IdSoftRef
    extends CleanerThread.SoftReferenceCleared {
        String id;
        List list;

        IdSoftRef(Object object, String string) {
            super(object);
            this.id = string;
        }

        IdSoftRef(Object object, String string, List list) {
            super(object);
            this.id = string;
            this.list = list;
        }

        public void setList(List list) {
            this.list = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleared() {
            if (AbstractDocument.this.elementsById == null) {
                return;
            }
            Map map = AbstractDocument.this.elementsById;
            synchronized (map) {
                if (this.list != null) {
                    this.list.remove((Object)this);
                } else {
                    Object v = AbstractDocument.this.elementsById.remove(this.id);
                    if (v != this) {
                        AbstractDocument.this.elementsById.put(this.id, v);
                    }
                }
            }
        }
    }
}

