"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mockIndexPattern = exports.mockFields = void 0;

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var mockFields = [{
  name: 'machine.os',
  esTypes: ['text'],
  type: 'string',
  aggregatable: false,
  searchable: false,
  filterable: true
}, {
  name: 'machine.os.raw',
  type: 'string',
  esTypes: ['keyword'],
  aggregatable: true,
  searchable: true,
  filterable: true
}, {
  name: 'not.filterable',
  type: 'string',
  esTypes: ['text'],
  aggregatable: true,
  searchable: false,
  filterable: false
}, {
  name: 'bytes',
  type: 'number',
  esTypes: ['long'],
  aggregatable: true,
  searchable: true,
  filterable: true
}, {
  name: '@timestamp',
  type: 'date',
  esTypes: ['date'],
  aggregatable: true,
  searchable: true,
  filterable: true
}, {
  name: 'clientip',
  type: 'ip',
  esTypes: ['ip'],
  aggregatable: true,
  searchable: true,
  filterable: true
}, {
  name: 'bool.field',
  type: 'boolean',
  esTypes: ['boolean'],
  aggregatable: true,
  searchable: true,
  filterable: true
}];
exports.mockFields = mockFields;
var mockIndexPattern = {
  id: 'logstash-*',
  fields: mockFields,
  title: 'logstash-*',
  timeFieldName: '@timestamp'
};
exports.mockIndexPattern = mockIndexPattern;