"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var classnames_1 = __importDefault(require("classnames"));
var mobx_react_1 = require("mobx-react");
var react_1 = __importDefault(require("react"));
var react_konva_1 = require("react-konva");
var specs_1 = require("../../lib/series/specs");
var area_geometries_1 = require("./area_geometries");
var axis_1 = require("./axis");
var bar_geometries_1 = require("./bar_geometries");
var bar_values_1 = require("./bar_values");
var grid_1 = require("./grid");
var line_annotation_1 = require("./line_annotation");
var line_geometries_1 = require("./line_geometries");
var rect_annotation_1 = require("./rect_annotation");
function limitPoint(value, min, max) {
    if (value > max) {
        return max;
    }
    else if (value < min) {
        return min;
    }
    else {
        return value;
    }
}
function getPoint(event, extent) {
    var point = {
        x: limitPoint(event.layerX, extent.minX, extent.maxX),
        y: limitPoint(event.layerY, extent.minY, extent.maxY),
    };
    return point;
}
var Chart = /** @class */ (function (_super) {
    __extends(Chart, _super);
    function Chart() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.firstRender = true;
        _this.state = {
            brushing: false,
            brushStart: {
                x: 0,
                y: 0,
            },
            brushEnd: {
                x: 0,
                y: 0,
            },
            bbox: {
                left: 0,
                top: 0,
            },
        };
        _this.renderBarSeries = function () {
            var _a = _this.props.chartStore, geometries = _a.geometries, canDataBeAnimated = _a.canDataBeAnimated, chartTheme = _a.chartTheme;
            if (!geometries) {
                return [];
            }
            var highlightedLegendItem = _this.getHighlightedLegendItem();
            var element = (react_1.default.createElement(bar_geometries_1.BarGeometries, { key: 'bar-geometries', animated: canDataBeAnimated, bars: geometries.bars, style: chartTheme.barSeriesStyle, sharedStyle: chartTheme.sharedStyle, highlightedLegendItem: highlightedLegendItem }));
            return [
                {
                    element: element,
                    zIndex: 0,
                },
            ];
        };
        _this.renderLineSeries = function () {
            var _a = _this.props.chartStore, geometries = _a.geometries, canDataBeAnimated = _a.canDataBeAnimated, chartTheme = _a.chartTheme;
            if (!geometries) {
                return [];
            }
            var highlightedLegendItem = _this.getHighlightedLegendItem();
            var element = (react_1.default.createElement(line_geometries_1.LineGeometries, { key: 'line-geometries', animated: canDataBeAnimated, lines: geometries.lines, style: chartTheme.lineSeriesStyle, sharedStyle: chartTheme.sharedStyle, highlightedLegendItem: highlightedLegendItem }));
            return [
                {
                    element: element,
                    zIndex: 0,
                },
            ];
        };
        _this.renderAreaSeries = function () {
            var _a = _this.props.chartStore, geometries = _a.geometries, canDataBeAnimated = _a.canDataBeAnimated, chartTheme = _a.chartTheme;
            if (!geometries) {
                return [];
            }
            var highlightedLegendItem = _this.getHighlightedLegendItem();
            var element = (react_1.default.createElement(area_geometries_1.AreaGeometries, { key: 'area-geometries', animated: canDataBeAnimated, areas: geometries.areas, style: chartTheme.areaSeriesStyle, sharedStyle: chartTheme.sharedStyle, highlightedLegendItem: highlightedLegendItem }));
            return [
                {
                    element: element,
                    zIndex: 0,
                },
            ];
        };
        _this.renderAxes = function () {
            var _a = _this.props.chartStore, axesVisibleTicks = _a.axesVisibleTicks, axesSpecs = _a.axesSpecs, axesTicksDimensions = _a.axesTicksDimensions, axesPositions = _a.axesPositions, chartTheme = _a.chartTheme, debug = _a.debug, chartDimensions = _a.chartDimensions;
            var axesComponents = [];
            axesVisibleTicks.forEach(function (axisTicks, axisId) {
                var axisSpec = axesSpecs.get(axisId);
                var axisTicksDimensions = axesTicksDimensions.get(axisId);
                var axisPosition = axesPositions.get(axisId);
                var ticks = axesVisibleTicks.get(axisId);
                if (!ticks || !axisSpec || !axisTicksDimensions || !axisPosition) {
                    return;
                }
                axesComponents.push(react_1.default.createElement(axis_1.Axis, { key: "axis-" + axisId, axisSpec: axisSpec, axisTicksDimensions: axisTicksDimensions, axisPosition: axisPosition, ticks: ticks, chartTheme: chartTheme, debug: debug, chartDimensions: chartDimensions }));
            });
            return axesComponents;
        };
        _this.renderGrids = function () {
            var _a = _this.props.chartStore, axesGridLinesPositions = _a.axesGridLinesPositions, axesSpecs = _a.axesSpecs, chartDimensions = _a.chartDimensions, debug = _a.debug;
            var gridComponents = [];
            axesGridLinesPositions.forEach(function (axisGridLinesPositions, axisId) {
                var axisSpec = axesSpecs.get(axisId);
                if (axisSpec && axisGridLinesPositions.length > 0) {
                    gridComponents.push(react_1.default.createElement(grid_1.Grid, { key: "axis-grid-" + axisId, chartDimensions: chartDimensions, debug: debug, gridLineStyle: axisSpec.gridLineStyle, linesPositions: axisGridLinesPositions }));
                }
            });
            return gridComponents;
        };
        _this.renderAnnotations = function () {
            var _a = _this.props.chartStore, annotationDimensions = _a.annotationDimensions, annotationSpecs = _a.annotationSpecs, chartDimensions = _a.chartDimensions, debug = _a.debug;
            var annotationElements = [];
            annotationDimensions.forEach(function (annotation, id) {
                var spec = annotationSpecs.get(id);
                if (!spec) {
                    return;
                }
                var zIndex = spec.zIndex || 0;
                var element;
                if (specs_1.isLineAnnotation(spec)) {
                    var lineStyle = spec.style;
                    element = (react_1.default.createElement(line_annotation_1.LineAnnotation, { key: "annotation-" + id, chartDimensions: chartDimensions, debug: debug, lines: annotation, lineStyle: lineStyle }));
                }
                else if (specs_1.isRectAnnotation(spec)) {
                    var rectStyle = spec.style;
                    element = (react_1.default.createElement(rect_annotation_1.RectAnnotation, { key: "annotation-" + id, chartDimensions: chartDimensions, debug: debug, rects: annotation, rectStyle: rectStyle }));
                }
                if (element) {
                    annotationElements.push({
                        element: element,
                        zIndex: zIndex,
                    });
                }
            });
            return annotationElements;
        };
        _this.renderBarValues = function () {
            var _a = _this.props.chartStore, debug = _a.debug, chartDimensions = _a.chartDimensions, geometries = _a.geometries, chartTheme = _a.chartTheme, chartRotation = _a.chartRotation;
            if (!geometries) {
                return;
            }
            var props = {
                debug: debug,
                chartDimensions: chartDimensions,
                chartRotation: chartRotation,
                bars: geometries.bars,
                // displayValue is guaranteed on style as part of the merged theme
                displayValueStyle: chartTheme.barSeriesStyle.displayValue,
            };
            return react_1.default.createElement(bar_values_1.BarValues, __assign({}, props));
        };
        _this.renderBrushTool = function () {
            var _a = _this.state, brushing = _a.brushing, brushStart = _a.brushStart, brushEnd = _a.brushEnd;
            var _b = _this.props.chartStore, chartDimensions = _b.chartDimensions, chartRotation = _b.chartRotation, chartTransform = _b.chartTransform;
            if (!brushing) {
                return null;
            }
            var x = 0;
            var y = 0;
            var width = 0;
            var height = 0;
            // x = {chartDimensions.left + chartTransform.x};
            // y = {chartDimensions.top + chartTransform.y};
            if (chartRotation === 0 || chartRotation === 180) {
                x = brushStart.x;
                y = chartDimensions.top + chartTransform.y;
                width = brushEnd.x - brushStart.x;
                height = chartDimensions.height;
            }
            else {
                x = chartDimensions.left + chartTransform.x;
                y = brushStart.y;
                width = chartDimensions.width;
                height = brushEnd.y - brushStart.y;
            }
            return react_1.default.createElement(react_konva_1.Rect, { x: x, y: y, width: width, height: height, fill: "gray", opacity: 0.6 });
        };
        _this.onStartBrusing = function (event) {
            window.addEventListener('mouseup', _this.onEndBrushing);
            _this.props.chartStore.onBrushStart();
            var brushExtent = _this.props.chartStore.brushExtent;
            var point = getPoint(event.evt, brushExtent);
            _this.setState(function () { return ({
                brushing: true,
                brushStart: point,
                brushEnd: point,
            }); });
        };
        _this.onEndBrushing = function () {
            window.removeEventListener('mouseup', _this.onEndBrushing);
            var _a = _this.state, brushStart = _a.brushStart, brushEnd = _a.brushEnd;
            _this.props.chartStore.onBrushEnd(brushStart, brushEnd);
            _this.setState(function () { return ({
                brushing: false,
                brushStart: { x: 0, y: 0 },
                brushEnd: { x: 0, y: 0 },
            }); });
        };
        _this.onBrushing = function (event) {
            if (!_this.state.brushing) {
                return;
            }
            var brushExtent = _this.props.chartStore.brushExtent;
            var point = getPoint(event.evt, brushExtent);
            _this.setState(function () { return ({
                brushEnd: point,
            }); });
        };
        _this.renderDebugChartBorders = function () {
            var chartDimensions = _this.props.chartStore.chartDimensions;
            return (react_1.default.createElement(react_konva_1.Rect, { x: chartDimensions.left, y: chartDimensions.top, width: chartDimensions.width, height: chartDimensions.height, stroke: "red", strokeWidth: 4, listening: false, dash: [4, 4] }));
        };
        _this.getHighlightedLegendItem = function () {
            return _this.props.chartStore.highlightedLegendItem.get();
        };
        return _this;
    }
    Chart.prototype.sortAndRenderElements = function () {
        var bars = this.renderBarSeries();
        var areas = this.renderAreaSeries();
        var lines = this.renderLineSeries();
        var annotations = this.renderAnnotations();
        return __spread(bars, areas, lines, annotations).sort(function (elemIdxA, elemIdxB) { return elemIdxA.zIndex - elemIdxB.zIndex; })
            .map(function (elemIdx) { return elemIdx.element; });
    };
    Chart.prototype.render = function () {
        var _this = this;
        var _a = this.props.chartStore, initialized = _a.initialized, debug = _a.debug;
        if (!initialized.get()) {
            return null;
        }
        var _b = this.props.chartStore, parentDimensions = _b.parentDimensions, chartDimensions = _b.chartDimensions, chartRotation = _b.chartRotation, chartTransform = _b.chartTransform, setCursorPosition = _b.setCursorPosition;
        // disable clippings when debugging
        var clippings = debug
            ? {}
            : {
                clipX: 0,
                clipY: 0,
                clipWidth: [90, -90].includes(chartRotation) ? chartDimensions.height : chartDimensions.width,
                clipHeight: [90, -90].includes(chartRotation) ? chartDimensions.width : chartDimensions.height,
            };
        var brushProps = {};
        var isBrushEnabled = this.props.chartStore.isBrushEnabled();
        if (isBrushEnabled) {
            brushProps = {
                onMouseDown: this.onStartBrusing,
                onMouseMove: this.onBrushing,
            };
        }
        var layerClippings = {
            clipX: chartDimensions.left,
            clipY: chartDimensions.top,
            clipWidth: chartDimensions.width,
            clipHeight: chartDimensions.height,
        };
        var className = classnames_1.default({
            'echChart--isBrushEnabled': this.props.chartStore.isCrosshairCursorVisible.get(),
        });
        return (react_1.default.createElement("div", { style: {
                position: 'absolute',
                top: 0,
                bottom: 0,
                right: 0,
                left: 0,
                boxSizing: 'border-box',
            }, onMouseMove: function (_a) {
                var _b = _a.nativeEvent, offsetX = _b.offsetX, offsetY = _b.offsetY;
                setCursorPosition(offsetX, offsetY);
            }, onMouseLeave: function () {
                setCursorPosition(-1, -1);
            }, onClick: function () {
                _this.props.chartStore.handleChartClick();
            }, className: className },
            react_1.default.createElement(react_konva_1.Stage, __assign({ width: parentDimensions.width, height: parentDimensions.height, style: {
                    width: '100%',
                    height: '100%',
                } }, brushProps),
                react_1.default.createElement(react_konva_1.Layer, __assign({ hitGraphEnabled: false, listening: false }, layerClippings), this.renderGrids()),
                react_1.default.createElement(react_konva_1.Layer, __assign({ x: chartDimensions.left + chartTransform.x, y: chartDimensions.top + chartTransform.y, rotation: chartRotation }, clippings, { hitGraphEnabled: false, listening: false }), this.sortAndRenderElements()),
                react_1.default.createElement(react_konva_1.Layer, { hitGraphEnabled: false, listening: false }, debug && this.renderDebugChartBorders()),
                isBrushEnabled && (react_1.default.createElement(react_konva_1.Layer, { hitGraphEnabled: false, listening: false }, this.renderBrushTool())),
                react_1.default.createElement(react_konva_1.Layer, { hitGraphEnabled: false, listening: false }, this.renderAxes()),
                react_1.default.createElement(react_konva_1.Layer, __assign({ hitGraphEnabled: false, listening: false }, layerClippings), this.renderBarValues()))));
    };
    Chart.displayName = 'ReactiveChart';
    return Chart;
}(react_1.default.Component));
exports.ReactiveChart = mobx_react_1.inject('chartStore')(mobx_react_1.observer(Chart));
//# sourceMappingURL=reactive_chart.js.map