/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestEngine;

@API(status=API.Status.STABLE, since="1.0")
public class EngineFilter
implements Filter<TestEngine> {
    private final List<String> engineIds;
    private final Type type;

    public static EngineFilter includeEngines(String ... engineIds) {
        return EngineFilter.includeEngines(Arrays.asList(engineIds));
    }

    public static EngineFilter includeEngines(List<String> engineIds) {
        return new EngineFilter(engineIds, Type.INCLUDE);
    }

    public static EngineFilter excludeEngines(String ... engineIds) {
        return EngineFilter.excludeEngines(Arrays.asList(engineIds));
    }

    public static EngineFilter excludeEngines(List<String> engineIds) {
        return new EngineFilter(engineIds, Type.EXCLUDE);
    }

    private EngineFilter(List<String> engineIds, Type type) {
        this.engineIds = EngineFilter.validateAndTrim(engineIds);
        this.type = type;
    }

    public FilterResult apply(TestEngine testEngine) {
        Preconditions.notNull((Object)testEngine, (String)"TestEngine must not be null");
        String engineId = testEngine.getId();
        Preconditions.notBlank((String)engineId, (String)"TestEngine ID must not be null or blank");
        if (this.type == Type.INCLUDE) {
            return FilterResult.includedIf((boolean)this.engineIds.stream().anyMatch(engineId::equals), () -> String.format("Engine ID [%s] is in included list [%s]", engineId, this.engineIds), () -> String.format("Engine ID [%s] is not in included list [%s]", engineId, this.engineIds));
        }
        return FilterResult.includedIf((boolean)this.engineIds.stream().noneMatch(engineId::equals), () -> String.format("Engine ID [%s] is not in excluded list [%s]", engineId, this.engineIds), () -> String.format("Engine ID [%s] is in excluded list [%s]", engineId, this.engineIds));
    }

    public String toString() {
        return String.format("%s that %s engines with IDs %s", this.getClass().getSimpleName(), this.type.verb, this.engineIds);
    }

    private static List<String> validateAndTrim(List<String> engineIds) {
        Preconditions.notEmpty(engineIds, (String)"engine ID list must not be null or empty");
        return engineIds.stream().distinct().peek(id -> Preconditions.notBlank((String)id, (String)"engine ID must not be null or blank")).map(String::trim).collect(Collectors.toList());
    }

    private static enum Type {
        INCLUDE("includes"),
        EXCLUDE("excludes");

        private final String verb;

        private Type(String verb) {
            this.verb = verb;
        }
    }
}

