/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.truetype.TTFFontLoader;
import org.apache.fop.fonts.type1.Type1FontLoader;

public abstract class FontLoader {
    protected static Log log = LogFactory.getLog(class$org$apache$fop$fonts$FontLoader == null ? (class$org$apache$fop$fonts$FontLoader = FontLoader.class$("org.apache.fop.fonts.FontLoader")) : class$org$apache$fop$fonts$FontLoader);
    protected String fontFileURI = null;
    protected InputStream in = null;
    protected FontResolver resolver = null;
    protected CustomFont returnFont = null;
    protected boolean loaded = false;
    static /* synthetic */ Class class$org$apache$fop$fonts$FontLoader;

    public FontLoader(String fontFileURI, InputStream in, FontResolver resolver) {
        this.fontFileURI = fontFileURI;
        this.in = in;
        this.resolver = resolver;
    }

    private static boolean isType1(String fontURI) {
        return fontURI.toLowerCase().endsWith(".pfb");
    }

    public static CustomFont loadFont(File fontFile, FontResolver resolver) throws IOException {
        return FontLoader.loadFont(fontFile.getAbsolutePath(), resolver);
    }

    public static CustomFont loadFont(String fontFileURI, FontResolver resolver) throws IOException {
        fontFileURI = fontFileURI.trim();
        String name = fontFileURI.toLowerCase();
        boolean type1 = FontLoader.isType1(fontFileURI);
        String effURI = type1 ? name.substring(0, fontFileURI.length() - 4) + ".pfm" : fontFileURI;
        if (log.isDebugEnabled()) {
            log.debug("opening " + effURI);
        }
        InputStream in = FontLoader.openFontFile(resolver, effURI);
        return FontLoader.loadFontFromInputStream(fontFileURI, resolver, type1, in);
    }

    protected static CustomFont loadFontFromInputStream(String fontFileURI, FontResolver resolver, boolean isType1, InputStream in) throws IOException {
        CustomFont customFont;
        try {
            FontLoader loader = isType1 ? new Type1FontLoader(fontFileURI, in, resolver) : new TTFFontLoader(fontFileURI, in, resolver);
            customFont = loader.getFont();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
        return customFont;
    }

    private static InputStream openFontFile(FontResolver resolver, String uri) throws IOException, MalformedURLException {
        InputStream in = null;
        if (resolver != null) {
            Source source = resolver.resolve(uri);
            if (source == null) {
                String err = "Cannot load font: failed to create Source for font file " + uri;
                throw new IOException(err);
            }
            if (source instanceof StreamSource) {
                in = ((StreamSource)source).getInputStream();
            }
            if (in == null && source.getSystemId() != null) {
                in = new URL(source.getSystemId()).openStream();
            }
            if (in == null) {
                String err = "Cannot load font: failed to create InputStream from Source for font file " + uri;
                throw new IOException(err);
            }
        } else {
            in = new URL(uri).openStream();
        }
        return in;
    }

    protected abstract void read() throws IOException;

    public CustomFont getFont() throws IOException {
        if (!this.loaded) {
            this.read();
        }
        return this.returnFont;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

