/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.HDRPercentilesAggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.PercentilesMethod;
import org.elasticsearch.search.aggregations.metrics.TDigestPercentilesAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceParserHelper;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.internal.SearchContext;

public class PercentilesAggregationBuilder
extends ValuesSourceAggregationBuilder.LeafOnly<ValuesSource.Numeric, PercentilesAggregationBuilder> {
    public static final String NAME = "percentiles";
    private static final double[] DEFAULT_PERCENTS = new double[]{1.0, 5.0, 25.0, 50.0, 75.0, 95.0, 99.0};
    public static final ParseField PERCENTS_FIELD = new ParseField("percents", new String[0]);
    public static final ParseField KEYED_FIELD = new ParseField("keyed", new String[0]);
    public static final ParseField METHOD_FIELD = new ParseField("method", new String[0]);
    public static final ParseField COMPRESSION_FIELD = new ParseField("compression", new String[0]);
    public static final ParseField NUMBER_SIGNIFICANT_DIGITS_FIELD = new ParseField("number_of_significant_value_digits", new String[0]);
    private static final ObjectParser<TDigestOptions, Void> TDIGEST_OPTIONS_PARSER = new ObjectParser(PercentilesMethod.TDIGEST.getParseField().getPreferredName(), () -> new TDigestOptions());
    private static final ObjectParser<HDROptions, Void> HDR_OPTIONS_PARSER;
    private static final ObjectParser<InternalBuilder, Void> PARSER;
    private double[] percents = DEFAULT_PERCENTS;
    private PercentilesMethod method = PercentilesMethod.TDIGEST;
    private int numberOfSignificantValueDigits = 3;
    private double compression = 100.0;
    private boolean keyed = true;

    public static AggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        InternalBuilder internal = (InternalBuilder)PARSER.parse(parser, (Object)new InternalBuilder(aggregationName), null);
        PercentilesAggregationBuilder returnedAgg = new PercentilesAggregationBuilder(internal.name);
        PercentilesAggregationBuilder.setIfNotNull(returnedAgg::valueType, internal.valueType());
        PercentilesAggregationBuilder.setIfNotNull(returnedAgg::format, internal.format());
        PercentilesAggregationBuilder.setIfNotNull(returnedAgg::missing, internal.missing());
        PercentilesAggregationBuilder.setIfNotNull(returnedAgg::field, internal.field());
        PercentilesAggregationBuilder.setIfNotNull(returnedAgg::script, internal.script());
        PercentilesAggregationBuilder.setIfNotNull(returnedAgg::method, internal.method());
        PercentilesAggregationBuilder.setIfNotNull(returnedAgg::percentiles, internal.percentiles());
        returnedAgg.keyed(internal.keyed());
        returnedAgg.compression(internal.compression());
        returnedAgg.numberOfSignificantValueDigits(internal.numberOfSignificantValueDigits());
        return returnedAgg;
    }

    private static <T> void setIfNotNull(Consumer<T> consumer, T value) {
        if (value != null) {
            consumer.accept(value);
        }
    }

    public PercentilesAggregationBuilder(String name) {
        super(name, ValuesSourceType.NUMERIC, ValueType.NUMERIC);
    }

    protected PercentilesAggregationBuilder(PercentilesAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
        this.percents = clone.percents;
        this.method = clone.method;
        this.numberOfSignificantValueDigits = clone.numberOfSignificantValueDigits;
        this.compression = clone.compression;
        this.keyed = clone.keyed;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new PercentilesAggregationBuilder(this, factoriesBuilder, metaData);
    }

    public PercentilesAggregationBuilder(StreamInput in) throws IOException {
        super(in, ValuesSourceType.NUMERIC, ValueType.NUMERIC);
        this.percents = in.readDoubleArray();
        this.keyed = in.readBoolean();
        this.numberOfSignificantValueDigits = in.readVInt();
        this.compression = in.readDouble();
        this.method = PercentilesMethod.readFromStream(in);
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeDoubleArray(this.percents);
        out.writeBoolean(this.keyed);
        out.writeVInt(this.numberOfSignificantValueDigits);
        out.writeDouble(this.compression);
        this.method.writeTo(out);
    }

    public PercentilesAggregationBuilder percentiles(double ... percents) {
        if (percents == null) {
            throw new IllegalArgumentException("[percents] must not be null: [" + this.name + "]");
        }
        if (percents.length == 0) {
            throw new IllegalArgumentException("[percents] must not be empty: [" + this.name + "]");
        }
        double[] sortedPercents = Arrays.copyOf(percents, percents.length);
        Arrays.sort(sortedPercents);
        this.percents = sortedPercents;
        return this;
    }

    public double[] percentiles() {
        return this.percents;
    }

    public PercentilesAggregationBuilder keyed(boolean keyed) {
        this.keyed = keyed;
        return this;
    }

    public boolean keyed() {
        return this.keyed;
    }

    public PercentilesAggregationBuilder numberOfSignificantValueDigits(int numberOfSignificantValueDigits) {
        if (numberOfSignificantValueDigits < 0 || numberOfSignificantValueDigits > 5) {
            throw new IllegalArgumentException("[numberOfSignificantValueDigits] must be between 0 and 5: [" + this.name + "]");
        }
        this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
        return this;
    }

    public int numberOfSignificantValueDigits() {
        return this.numberOfSignificantValueDigits;
    }

    public PercentilesAggregationBuilder compression(double compression) {
        if (compression < 0.0) {
            throw new IllegalArgumentException("[compression] must be greater than or equal to 0. Found [" + compression + "] in [" + this.name + "]");
        }
        this.compression = compression;
        return this;
    }

    public double compression() {
        return this.compression;
    }

    public PercentilesAggregationBuilder method(PercentilesMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("[method] must not be null: [" + this.name + "]");
        }
        this.method = method;
        return this;
    }

    public PercentilesMethod method() {
        return this.method;
    }

    @Override
    protected ValuesSourceAggregatorFactory<ValuesSource.Numeric, ?> innerBuild(SearchContext context, ValuesSourceConfig<ValuesSource.Numeric> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        switch (this.method) {
            case TDIGEST: {
                return new TDigestPercentilesAggregatorFactory(this.name, config, this.percents, this.compression, this.keyed, context, parent, subFactoriesBuilder, this.metaData);
            }
            case HDR: {
                return new HDRPercentilesAggregatorFactory(this.name, config, this.percents, this.numberOfSignificantValueDigits, this.keyed, context, parent, subFactoriesBuilder, this.metaData);
            }
        }
        throw new IllegalStateException("Illegal method [" + this.method + "]");
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.array(PERCENTS_FIELD.getPreferredName(), this.percents);
        builder.field(KEYED_FIELD.getPreferredName(), this.keyed);
        builder.startObject(this.method.toString());
        if (this.method == PercentilesMethod.TDIGEST) {
            builder.field(COMPRESSION_FIELD.getPreferredName(), this.compression);
        } else {
            builder.field(NUMBER_SIGNIFICANT_DIGITS_FIELD.getPreferredName(), this.numberOfSignificantValueDigits);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        PercentilesAggregationBuilder other = (PercentilesAggregationBuilder)obj;
        if (!Objects.equals(this.method, other.method)) {
            return false;
        }
        boolean equalSettings = false;
        switch (this.method) {
            case HDR: {
                equalSettings = Objects.equals(this.numberOfSignificantValueDigits, other.numberOfSignificantValueDigits);
                break;
            }
            case TDIGEST: {
                equalSettings = Objects.equals(this.compression, other.compression);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal method [" + this.method.toString() + "]");
            }
        }
        return equalSettings && Objects.deepEquals(this.percents, other.percents) && Objects.equals(this.keyed, other.keyed) && Objects.equals(this.method, other.method);
    }

    @Override
    public int hashCode() {
        switch (this.method) {
            case HDR: {
                return Objects.hash(super.hashCode(), Arrays.hashCode(this.percents), this.keyed, this.numberOfSignificantValueDigits, this.method);
            }
            case TDIGEST: {
                return Objects.hash(super.hashCode(), Arrays.hashCode(this.percents), this.keyed, this.compression, this.method);
            }
        }
        throw new IllegalStateException("Illegal method [" + this.method.toString() + "]");
    }

    @Override
    public String getType() {
        return NAME;
    }

    static {
        TDIGEST_OPTIONS_PARSER.declareDouble((opts, compression) -> {
            opts.compression = compression;
        }, COMPRESSION_FIELD);
        HDR_OPTIONS_PARSER = new ObjectParser(PercentilesMethod.HDR.getParseField().getPreferredName(), () -> new HDROptions());
        HDR_OPTIONS_PARSER.declareInt((opts, numberOfSigDigits) -> {
            opts.numberOfSigDigits = numberOfSigDigits;
        }, NUMBER_SIGNIFICANT_DIGITS_FIELD);
        PARSER = new ObjectParser(NAME);
        ValuesSourceParserHelper.declareNumericFields(PARSER, true, true, false);
        PARSER.declareDoubleArray((b, v) -> b.percentiles(v.stream().mapToDouble(Double::doubleValue).toArray()), PERCENTS_FIELD);
        PARSER.declareBoolean(PercentilesAggregationBuilder::keyed, KEYED_FIELD);
        PARSER.declareField((b, v) -> {
            b.method(PercentilesMethod.TDIGEST);
            if (v.compression != null) {
                b.compression(v.compression);
            }
        }, (arg_0, arg_1) -> TDIGEST_OPTIONS_PARSER.parse(arg_0, arg_1), PercentilesMethod.TDIGEST.getParseField(), ObjectParser.ValueType.OBJECT);
        PARSER.declareField((b, v) -> {
            b.method(PercentilesMethod.HDR);
            if (v.numberOfSigDigits != null) {
                b.numberOfSignificantValueDigits(v.numberOfSigDigits);
            }
        }, (arg_0, arg_1) -> HDR_OPTIONS_PARSER.parse(arg_0, arg_1), PercentilesMethod.HDR.getParseField(), ObjectParser.ValueType.OBJECT);
    }

    private static class InternalBuilder
    extends PercentilesAggregationBuilder {
        private boolean setOnce = false;

        private InternalBuilder(String name) {
            super(name);
        }

        @Override
        public InternalBuilder method(PercentilesMethod method) {
            if (!this.setOnce) {
                super.method(method);
                this.setOnce = true;
                return this;
            }
            throw new IllegalStateException("Only one percentiles method should be declared.");
        }
    }

    private static class HDROptions {
        Integer numberOfSigDigits;

        private HDROptions() {
        }
    }

    private static class TDigestOptions {
        Double compression;

        private TDigestOptions() {
        }
    }
}

