/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.persistent;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.StreamableResponseActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.persistent.PersistentTaskResponse;
import org.elasticsearch.persistent.PersistentTasksClusterService;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class CompletionPersistentTaskAction
extends StreamableResponseActionType<PersistentTaskResponse> {
    public static final CompletionPersistentTaskAction INSTANCE = new CompletionPersistentTaskAction();
    public static final String NAME = "cluster:admin/persistent/completion";

    private CompletionPersistentTaskAction() {
        super(NAME);
    }

    @Override
    public PersistentTaskResponse newResponse() {
        return new PersistentTaskResponse();
    }

    public static class TransportAction
    extends TransportMasterNodeAction<Request, PersistentTaskResponse> {
        private final PersistentTasksClusterService persistentTasksClusterService;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, PersistentTasksClusterService persistentTasksClusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(CompletionPersistentTaskAction.NAME, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, Request::new);
            this.persistentTasksClusterService = persistentTasksClusterService;
        }

        @Override
        protected String executor() {
            return "generic";
        }

        @Override
        protected PersistentTaskResponse newResponse() {
            return new PersistentTaskResponse();
        }

        @Override
        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }

        @Override
        protected final void masterOperation(Request request, ClusterState state, ActionListener<PersistentTaskResponse> listener) {
            this.persistentTasksClusterService.completePersistentTask(request.taskId, request.allocationId, request.exception, ActionListener.delegateFailure(listener, (delegatedListener, task) -> delegatedListener.onResponse(new PersistentTaskResponse((PersistentTasksCustomMetaData.PersistentTask<?>)task))));
        }
    }

    public static class RequestBuilder
    extends MasterNodeOperationRequestBuilder<Request, PersistentTaskResponse, RequestBuilder> {
        protected RequestBuilder(ElasticsearchClient client, CompletionPersistentTaskAction action) {
            super(client, action, new Request());
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private String taskId;
        private Exception exception;
        private long allocationId = -1L;

        public Request() {
        }

        public Request(String taskId, long allocationId, Exception exception) {
            this.taskId = taskId;
            this.exception = exception;
            this.allocationId = allocationId;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.taskId = in.readString();
            this.allocationId = in.readLong();
            this.exception = in.readException();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.taskId);
            out.writeLong(this.allocationId);
            out.writeException(this.exception);
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.taskId == null) {
                validationException = ValidateActions.addValidationError("task id is missing", validationException);
            }
            if (this.allocationId < 0L) {
                validationException = ValidateActions.addValidationError("allocation id is negative or missing", validationException);
            }
            return validationException;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.taskId, request.taskId) && this.allocationId == request.allocationId && Objects.equals(this.exception, request.exception);
        }

        public int hashCode() {
            return Objects.hash(this.taskId, this.allocationId, this.exception);
        }
    }
}

