/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.xml;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.lsp4e.server.ProcessStreamConnectionProvider;
import org.eclipse.wildwebdeveloper.xml.Activator;

public class XMLLanguageServer
extends ProcessStreamConnectionProvider {
    public XMLLanguageServer() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.computeJavaPath());
        commands.add("-classpath");
        try {
            URL url = FileLocator.toFileURL((URL)((Object)((Object)this)).getClass().getResource("/language-servers/server/org.eclipse.lsp4xml-0.8.0-uber.jar"));
            commands.add(new File(url.getPath()).getAbsolutePath());
            commands.add("org.eclipse.lsp4xml.XMLServerLauncher");
            this.setCommands(commands);
            this.setWorkingDirectory(System.getProperty("user.dir"));
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
        }
    }

    private String computeJavaPath() {
        String javaPath = "java";
        boolean existsInPath = Stream.of(System.getenv("PATH").split(Pattern.quote(File.pathSeparator))).map(string -> Paths.get(string, new String[0])).anyMatch(path -> Files.exists(path.resolve("java"), new LinkOption[0]));
        if (!existsInPath) {
            File f = new File(System.getProperty("java.home"), "bin/java" + (Platform.getOS().equals("win32") ? ".exe" : ""));
            javaPath = f.getAbsolutePath();
        }
        return javaPath;
    }

    public String toString() {
        return "XML Language Server: " + super.toString();
    }
}

