/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.docker.launcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.docker.launcher.DockerLaunchUIPlugin;
import org.eclipse.cdt.internal.docker.launcher.ContainerPortDialog;
import org.eclipse.cdt.internal.docker.launcher.ContainerTabModel;
import org.eclipse.cdt.internal.docker.launcher.ExposedPortModel;
import org.eclipse.cdt.internal.docker.launcher.ILaunchConstants;
import org.eclipse.cdt.internal.docker.launcher.Messages;
import org.eclipse.cdt.internal.docker.launcher.SWTImagesFactory;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionManagerListener;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageListener;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ContainerTab
extends AbstractLaunchConfigurationTab
implements IDockerConnectionManagerListener,
IDockerImageListener {
    private org.eclipse.swt.widgets.List directoriesList;
    private String imageName;
    private String connectionName;
    private String connectionUri = "";
    private Boolean keepValue;
    private Boolean stdinValue;
    private Boolean privilegedValue;
    private IDockerConnection connection;
    private IDockerConnection[] connections;
    private IDockerImageListener containerTab;
    private Button newButton;
    private Button removeButton;
    private CheckboxTableViewer tableViewer;
    private Button keepButton;
    private Button stdinButton;
    private Button privilegedButton;
    private Combo imageCombo;
    private Combo connectionSelector;
    private ContainerTabModel model;
    private static final int INDENT = 1;
    private final DataBindingContext dbc = new DataBindingContext();
    private ModifyListener connectionModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            int index = ContainerTab.this.connectionSelector.getSelectionIndex();
            if (ContainerTab.this.connection != null) {
                ContainerTab.this.connection.removeImageListener(ContainerTab.this.containerTab);
            }
            ContainerTab.this.connection = ContainerTab.this.connections[index];
            ContainerTab.this.connectionUri = ContainerTab.this.connection.getUri();
            if (!ContainerTab.this.connectionName.equals(ContainerTab.this.connection.getName())) {
                ContainerTab.this.setErrorMessage(null);
                ContainerTab.this.initializeImageCombo();
            }
            ContainerTab.this.connectionName = ContainerTab.this.connection.getName();
        }
    };

    public ContainerTab() {
        this.containerTab = this;
        this.model = new ContainerTabModel();
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite mainComposite = this.createComposite(parent, 3, 1, 768);
        mainComposite.setFont(font);
        this.setControl((Control)mainComposite);
        Label connectionSelectorLabel = new Label(mainComposite, 0);
        connectionSelectorLabel.setText(Messages.ContainerTab_Connection_Selector_Label);
        this.connectionSelector = new Combo(mainComposite, 2056);
        this.initializeConnectionSelector();
        this.connectionSelector.addModifyListener(this.connectionModifyListener);
        this.connectionSelector.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = false;
            }
        });
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.connectionSelector.setLayoutData((Object)gd);
        Label imageSelectorLabel = new Label(mainComposite, 0);
        imageSelectorLabel.setText(Messages.ContainerTab_Image_Selector_Label);
        this.imageCombo = new Combo(mainComposite, 4);
        this.imageCombo.setLayoutData((Object)gd);
        this.initializeImageCombo();
        this.imageCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!ContainerTab.this.imageName.equals(ContainerTab.this.imageCombo.getText())) {
                    ContainerTab.this.updateLaunchConfigurationDialog();
                }
                ContainerTab.this.imageName = ContainerTab.this.imageCombo.getText();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createDirectoryList(mainComposite);
        this.createButtons(mainComposite);
        this.createPortSettingsSection(mainComposite);
        this.createOptions(mainComposite);
    }

    private void createDirectoryList(Composite parent) {
        Composite comp = this.createComposite(parent, 1, 2, 1808);
        Group group = new Group(comp, 0);
        Font font = parent.getFont();
        group.setFont(font);
        group.setText(Messages.ContainerTab_Group_Name);
        GridData gd2 = new GridData(1808);
        group.setLayoutData((Object)gd2);
        group.setLayout((Layout)new GridLayout());
        this.directoriesList = new org.eclipse.swt.widgets.List((Composite)group, 516);
        GridData gd3 = new GridData(1808);
        this.directoriesList.setLayoutData((Object)gd3);
        this.directoriesList.setFont(font);
        this.directoriesList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContainerTab.this.removeButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createButtons(Composite parent) {
        Font font = parent.getFont();
        Composite composite = this.createComposite(parent, 1, 1, 130);
        composite.setFont(font);
        this.newButton = this.createPushButton(composite, Messages.ContainerTab_New_Button, null);
        this.newButton.setLayoutData((Object)new GridData(1808));
        GridData gdb = new GridData(4);
        gdb.grabExcessHorizontalSpace = false;
        gdb.horizontalAlignment = 4;
        gdb.minimumWidth = 120;
        this.newButton.setLayoutData((Object)gdb);
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ContainerTab.this.handleNewButtonSelected(ContainerTab.this.directoriesList);
            }
        });
        this.removeButton = this.createPushButton(composite, Messages.ContainerTab_Remove_Button, null);
        this.removeButton.setLayoutData((Object)new GridData(1808));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ContainerTab.this.handleRemoveButtonSelected(ContainerTab.this.directoriesList);
            }
        });
        this.removeButton.setEnabled(false);
    }

    private void createPortSettingsSection(Composite parent) {
        CheckboxTableViewer exposedPortsTableViewer;
        Font font = parent.getFont();
        Composite comp = this.createComposite(parent, 1, 2, 1808);
        Group group = new Group(comp, 0);
        group.setFont(font);
        group.setText(Messages.ContainerTab_Ports_Group_Name);
        GridData gd2 = new GridData(1808);
        group.setLayoutData((Object)gd2);
        group.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).applyTo((Control)group);
        group.setLayout((Layout)new GridLayout());
        Label portSettingsLabel = new Label((Composite)group, 0);
        portSettingsLabel.setText(Messages.ContainerTab_Specify_Ports_Label);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)portSettingsLabel);
        this.tableViewer = exposedPortsTableViewer = this.createPortSettingsTable((Composite)group);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).indent(1, 0).hint(200, 70).applyTo((Control)exposedPortsTableViewer.getTable());
        Composite buttonsContainers = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)buttonsContainers);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(-1, 0).applyTo(buttonsContainers);
        Button addButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)addButton);
        addButton.setText(Messages.ContainerTab_Add_Button);
        addButton.addSelectionListener(this.onAddPort(exposedPortsTableViewer));
        Button editButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)editButton);
        editButton.setText(Messages.ContainerTab_Edit_Button);
        editButton.setEnabled(false);
        editButton.addSelectionListener(this.onEditPort(exposedPortsTableViewer));
        Button removeButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)removeButton);
        removeButton.setText(Messages.ContainerTab_Remove_Button);
        removeButton.addSelectionListener(this.onRemovePorts((TableViewer)exposedPortsTableViewer));
        ViewerSupport.bind((StructuredViewer)exposedPortsTableViewer, this.model.getExposedPorts(), (IValueProperty[])BeanProperties.values(ExposedPortModel.class, (String[])new String[]{"containerPort", "portType", "hostAddress", "hostPort"}));
        this.dbc.bindSet((IObservableSet)ViewersObservables.observeCheckedElements((CheckboxTableViewer)exposedPortsTableViewer, ExposedPortModel.class), BeanProperties.set((String)"selectedPorts").observe((Object)this.model));
        this.checkAllElements(exposedPortsTableViewer);
        exposedPortsTableViewer.addSelectionChangedListener(this.onSelectionChanged(editButton, removeButton));
        exposedPortsTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExposedPortModel e = (ExposedPortModel)event.getElement();
                e.setSelected(event.getChecked());
                ContainerTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void checkAllElements(CheckboxTableViewer exposedPortsTableViewer) {
        exposedPortsTableViewer.setAllChecked(true);
        this.model.setSelectedPorts(new HashSet<ExposedPortModel>((Collection<ExposedPortModel>)this.model.getExposedPorts()));
    }

    private SelectionListener onAddPort(CheckboxTableViewer exposedPortsTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            ContainerPortDialog dialog = new ContainerPortDialog(this.getShell());
            dialog.create();
            if (dialog.open() == 0) {
                ExposedPortModel port = dialog.getPort();
                port.setSelected(true);
                this.model.addAvailablePort(port);
                this.model.getSelectedPorts().add(port);
                exposedPortsTableViewer.setChecked((Object)port, true);
                this.updateLaunchConfigurationDialog();
            }
        });
    }

    private SelectionListener onEditPort(CheckboxTableViewer exposedPortsTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            IStructuredSelection selection = exposedPortsTableViewer.getStructuredSelection();
            ExposedPortModel selectedContainerPort = (ExposedPortModel)selection.getFirstElement();
            ContainerPortDialog dialog = new ContainerPortDialog(this.getShell(), selectedContainerPort);
            dialog.create();
            if (dialog.open() == 0) {
                ExposedPortModel configuredPort = dialog.getPort();
                selectedContainerPort.setContainerPort(configuredPort.getContainerPort());
                selectedContainerPort.setHostAddress(configuredPort.getHostAddress());
                selectedContainerPort.setHostPort(configuredPort.getHostPort());
                exposedPortsTableViewer.refresh();
                this.updateLaunchConfigurationDialog();
            }
        });
    }

    private SelectionListener onRemovePorts(TableViewer portsTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            IStructuredSelection selection = portsTableViewer.getStructuredSelection();
            for (ExposedPortModel port : selection) {
                this.model.removeAvailablePort(port);
                this.model.getSelectedPorts().remove(port);
                this.updateLaunchConfigurationDialog();
            }
        });
    }

    private ISelectionChangedListener onSelectionChanged(Button ... targetButtons) {
        return e -> {
            if (e.getSelection().isEmpty()) {
                ContainerTab.setControlsEnabled((Control[])targetButtons, false);
            } else {
                ContainerTab.setControlsEnabled((Control[])targetButtons, true);
            }
        };
    }

    private static void setControlsEnabled(Control[] controls, boolean enabled) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(enabled);
            ++n2;
        }
    }

    private CheckboxTableViewer createPortSettingsTable(Composite container) {
        Table table = new Table(container, 68384);
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createTableViewerColum((TableViewer)tableViewer, Messages.ContainerTab_Port_Column, 100);
        this.createTableViewerColum((TableViewer)tableViewer, Messages.ContainerTab_Type_Column, 50);
        this.createTableViewerColum((TableViewer)tableViewer, Messages.ContainerTab_HostAddress_Column, 100);
        this.createTableViewerColum((TableViewer)tableViewer, Messages.ContainerTab_HostPort_Column, 100);
        tableViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        return tableViewer;
    }

    private TableViewerColumn createTableViewerColum(TableViewer tableViewer, String title, int width) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        if (title != null) {
            column.setText(title);
        }
        column.setWidth(width);
        return viewerColumn;
    }

    private void createOptions(Composite parent) {
        Font font = parent.getFont();
        Composite comp = this.createComposite(parent, 1, 3, 1808);
        Group group = new Group(comp, 0);
        group.setFont(font);
        group.setText(Messages.ContainerTab_Option_Group_Name);
        GridData gd2 = new GridData(1808);
        group.setLayoutData((Object)gd2);
        group.setLayout((Layout)new GridLayout());
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.docker.launcher");
        this.keepButton = this.createCheckButton((Composite)group, Messages.ContainerTab_Keep_Label);
        this.keepButton.setLayoutData((Object)new GridData(768));
        Boolean keepPref = prefs.getBoolean("keepContainerAfterLaunch", false);
        this.keepButton.setSelection(keepPref.booleanValue());
        this.keepValue = keepPref;
        this.keepButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!ContainerTab.this.keepValue.equals(ContainerTab.this.keepButton.getSelection())) {
                    ContainerTab.this.updateLaunchConfigurationDialog();
                }
                ContainerTab.this.keepValue = ContainerTab.this.keepButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.stdinButton = this.createCheckButton((Composite)group, Messages.ContainerTab_Stdin_Support_Label);
        this.stdinButton.setLayoutData((Object)new GridData(768));
        this.stdinValue = false;
        this.stdinButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!ContainerTab.this.stdinValue.equals(ContainerTab.this.stdinButton.getSelection())) {
                    ContainerTab.this.updateLaunchConfigurationDialog();
                }
                ContainerTab.this.stdinValue = ContainerTab.this.stdinButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.privilegedButton = this.createCheckButton((Composite)group, Messages.ContainerTab_Privileged_Mode_Label);
        this.privilegedButton.setLayoutData((Object)new GridData(768));
        this.privilegedValue = false;
        this.privilegedButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!ContainerTab.this.privilegedValue.equals(ContainerTab.this.privilegedButton.getSelection())) {
                    ContainerTab.this.updateLaunchConfigurationDialog();
                }
                ContainerTab.this.privilegedValue = ContainerTab.this.privilegedButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private Composite createComposite(Composite parent, int columns, int hspan, int fill) {
        Composite g = new Composite(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    protected void handleNewButtonSelected(org.eclipse.swt.widgets.List list) {
        String directory = this.getDirectory();
        if (directory != null) {
            list.add(directory);
            this.updateLaunchConfigurationDialog();
        }
    }

    private String getDirectory() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        return dialog.open();
    }

    protected void handleRemoveButtonSelected(org.eclipse.swt.widgets.List list) {
        int index = list.getSelectionIndex();
        list.remove(index);
        this.updateLaunchConfigurationDialog();
        this.removeButton.setEnabled(false);
    }

    private void initializeConnectionSelector() {
        int defaultIndex = -1;
        this.connections = DockerConnectionManager.getInstance().getConnections();
        if (this.connections.length == 0) {
            this.setErrorMessage(Messages.ContainerTab_Error_No_Connections);
            return;
        }
        String[] connectionNames = new String[this.connections.length];
        int i = 0;
        while (i < this.connections.length) {
            connectionNames[i] = this.connections[i].getName();
            if (this.connections[i].getUri().equals(this.connectionUri)) {
                defaultIndex = i;
            }
            ++i;
        }
        if (defaultIndex < 0) {
            defaultIndex = 0;
        }
        this.connectionSelector.setItems(connectionNames);
        if (this.connections.length > 0) {
            this.connectionSelector.setText(connectionNames[defaultIndex]);
            this.connection = this.connections[defaultIndex];
            this.connectionName = this.connection.getName();
            this.connectionUri = this.connection.getUri();
        }
    }

    private void initializeImageCombo() {
        if (this.connection != null) {
            List images = this.connection.getImages();
            if (images == null || images.size() == 0) {
                this.setErrorMessage(Messages.ContainerTab_Error_No_Images);
                return;
            }
            this.connection.removeImageListener(this.containerTab);
            ArrayList<String> imageNames = new ArrayList<String>();
            for (IDockerImage image : images) {
                List tags = image.repoTags();
                if (tags == null) continue;
                for (String tag : tags) {
                    if (tag.equals("<none>:<none>")) continue;
                    imageNames.add(tag);
                }
            }
            this.imageCombo.setItems(imageNames.toArray(new String[0]));
            if (this.imageName != null) {
                this.imageCombo.setText(this.imageName);
            }
            this.connection.addImageListener(this.containerTab);
        }
    }

    public void addControlAccessibleListener(Control control, String controlName) {
        String[] strs = controlName.split("&");
        StringBuilder stripped = new StringBuilder();
        int i = 0;
        while (i < strs.length) {
            stripped.append(strs[i]);
            ++i;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(stripped.toString()));
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(ILaunchConstants.ATTR_ADDITIONAL_DIRS, null);
        configuration.setAttribute(ILaunchConstants.ATTR_EXPOSED_PORTS, null);
        configuration.setAttribute(ILaunchConstants.ATTR_CONNECTION_URI, "");
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.docker.launcher");
        String image = prefs.get("defaultImageForLaunch", "");
        configuration.setAttribute(ILaunchConstants.ATTR_IMAGE, image);
        Boolean keepContainer = prefs.getBoolean("keepContainerAfterLaunch", false);
        configuration.setAttribute(ILaunchConstants.ATTR_KEEP_AFTER_LAUNCH, (Object)keepContainer);
        configuration.setAttribute(ILaunchConstants.ATTR_STDIN_SUPPORT, false);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            List additionalDirs = configuration.getAttribute(ILaunchConstants.ATTR_ADDITIONAL_DIRS, null);
            if (additionalDirs != null) {
                this.directoriesList.setItems(additionalDirs.toArray(new String[0]));
            }
            List exposedPortInfos = configuration.getAttribute(ILaunchConstants.ATTR_EXPOSED_PORTS, Collections.emptyList());
            this.model.removeExposedPorts();
            for (String port : exposedPortInfos) {
                ExposedPortModel m = ExposedPortModel.createPortModel(port);
                this.model.addAvailablePort(m);
                if (!m.getSelected()) continue;
                this.model.getSelectedPorts().add(m);
                this.tableViewer.setChecked((Object)m, true);
            }
            this.connectionUri = configuration.getAttribute(ILaunchConstants.ATTR_CONNECTION_URI, "");
            int defaultIndex = 0;
            this.connections = DockerConnectionManager.getInstance().getConnections();
            if (this.connections.length > 0) {
                if (!this.connectionUri.isEmpty()) {
                    String[] connectionNames = new String[this.connections.length];
                    int i = 0;
                    while (i < this.connections.length) {
                        connectionNames[i] = this.connections[i].getName();
                        if (this.connections[i].getUri().equals(this.connectionUri)) {
                            defaultIndex = i;
                        }
                        ++i;
                    }
                    this.connectionSelector.select(defaultIndex);
                } else {
                    this.connectionUri = this.connections[0].getUri();
                }
            }
            this.imageName = configuration.getAttribute(ILaunchConstants.ATTR_IMAGE, "");
            this.imageCombo.setText(this.imageName);
            this.keepValue = configuration.getAttribute(ILaunchConstants.ATTR_KEEP_AFTER_LAUNCH, false);
            this.keepButton.setSelection(this.keepValue.booleanValue());
            this.stdinValue = configuration.getAttribute(ILaunchConstants.ATTR_STDIN_SUPPORT, false);
            this.stdinButton.setSelection(this.stdinValue.booleanValue());
            this.privilegedValue = configuration.getAttribute(ILaunchConstants.ATTR_PRIVILEGED_MODE, false);
            this.privilegedButton.setSelection(this.privilegedValue.booleanValue());
        }
        catch (CoreException e) {
            this.setErrorMessage(Messages.bind((String)Messages.ContainerTab_Error_Reading_Configuration, (Object)e.getStatus().getMessage()));
            DockerLaunchUIPlugin.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String[] dirs = this.directoriesList.getItems();
        configuration.setAttribute(ILaunchConstants.ATTR_ADDITIONAL_DIRS, Arrays.asList(dirs));
        String image = this.imageCombo.getText();
        configuration.setAttribute(ILaunchConstants.ATTR_IMAGE, image);
        configuration.setAttribute(ILaunchConstants.ATTR_CONNECTION_URI, this.connectionUri);
        configuration.setAttribute(ILaunchConstants.ATTR_KEEP_AFTER_LAUNCH, this.keepButton.getSelection());
        configuration.setAttribute(ILaunchConstants.ATTR_STDIN_SUPPORT, this.stdinButton.getSelection());
        configuration.setAttribute(ILaunchConstants.ATTR_PRIVILEGED_MODE, this.privilegedButton.getSelection());
        configuration.setAttribute(ILaunchConstants.ATTR_EXPOSED_PORTS, ExposedPortModel.toArrayString(this.model.getExposedPorts()));
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        String image;
        block7: {
            int index;
            block6: {
                block5: {
                    try {
                        image = launchConfig.getAttribute(ILaunchConstants.ATTR_IMAGE, null);
                        if (image != null) break block5;
                        return false;
                    }
                    catch (CoreException e) {
                        return false;
                    }
                }
                index = image.lastIndexOf(58);
                if (index > 0) break block6;
                return false;
            }
            if (!this.connection.hasImage(image.substring(0, index), image.substring(index + 1))) break block7;
            this.setWarningMessage(null);
            return true;
        }
        this.setWarningMessage(Messages.bind((String)Messages.ContainerTab_Warning_Image_Not_Found, (Object)image, (Object)this.connections[0].getName()));
        return false;
    }

    public String getName() {
        return Messages.ContainerTab_Name;
    }

    public Image getImage() {
        return SWTImagesFactory.get("org.eclipse.cdt.docker.launcher.repository-middle.gif");
    }

    public void changeEvent(IDockerConnection changedConnection, int type) {
        String currUri = null;
        int currIndex = 0;
        this.setErrorMessage(null);
        this.connections = DockerConnectionManager.getInstance().getConnections();
        if (this.connection != null) {
            currUri = this.connection.getUri();
            currIndex = this.connectionSelector.getSelectionIndex();
        }
        String[] connectionNames = new String[this.connections.length];
        int index = 0;
        int i = 0;
        while (i < this.connections.length) {
            connectionNames[i] = this.connections[i].getName();
            if (this.connections[i].getUri().equals(currUri)) {
                index = i;
            }
            ++i;
        }
        if (type == 2) {
            index = currIndex;
        }
        this.connectionSelector.removeModifyListener(this.connectionModifyListener);
        this.connectionSelector.setItems(connectionNames);
        if (connectionNames.length > 0) {
            this.connectionSelector.setText(connectionNames[index]);
            this.connection = this.connections[index];
            this.connectionUri = this.connection.getUri();
            List images = this.connection.getImages();
            if (images == null || images.size() == 0) {
                this.setErrorMessage(Messages.ContainerTab_Error_No_Images);
            }
        } else {
            this.setErrorMessage(Messages.ContainerTab_Error_No_Connections);
            this.connection = null;
            this.connectionUri = "";
            this.connectionSelector.setText("");
        }
        this.connectionSelector.addModifyListener(this.connectionModifyListener);
    }

    public void listChanged(IDockerConnection c, List<IDockerImage> list) {
        this.setErrorMessage(null);
        IDockerImage[] finalList = list.toArray(new IDockerImage[0]);
        if (finalList.length == 0) {
            this.setErrorMessage(Messages.ContainerTab_Error_No_Images);
        }
        if (c.getName().equals(this.connection.getName())) {
            Display.getDefault().syncExec(() -> {
                this.connection.removeImageListener(this.containerTab);
                ArrayList<String> imageNames = new ArrayList<String>();
                IDockerImage[] iDockerImageArray2 = finalList;
                int n = finalList.length;
                int n2 = 0;
                while (n2 < n) {
                    IDockerImage image = iDockerImageArray2[n2];
                    List tags = image.repoTags();
                    if (tags != null) {
                        for (String tag : tags) {
                            imageNames.add(tag);
                        }
                    }
                    ++n2;
                }
                if (!this.imageCombo.isDisposed()) {
                    this.imageCombo.setItems(imageNames.toArray(new String[0]));
                }
                this.connection.addImageListener(this.containerTab);
            });
        }
    }

    public void dispose() {
        if (this.connection != null) {
            this.connection.removeImageListener(this.containerTab);
        }
        super.dispose();
    }

    private class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String name) {
            this.controlName = name;
        }

        public void getName(AccessibleEvent e) {
            e.result = this.controlName;
        }
    }
}

