/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.ui.views;

import java.util.Locale;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.mysql.ui.MySQLUIActivator;
import org.jkiss.dbeaver.ext.mysql.ui.internal.MySQLUIMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ClientHomesSelector;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class MySQLConnectionPage
extends ConnectionPageAbstract
implements ICompositeDialogPage {
    private static final boolean MANAGE_SERVER_TIME_ZONE = false;
    private Text hostText;
    private Text portText;
    private Text dbText;
    private Text usernameText;
    private Text passwordText;
    private ClientHomesSelector homesSelector;
    private boolean activated = false;
    private Combo serverTimezoneCombo;

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite composite) {
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.site.updateButtons();
            }
        };
        int fontHeight = UIUtils.getFontHeight((Control)composite);
        Composite addrGroup = UIUtils.createPlaceholder((Composite)composite, (int)2);
        GridLayout gl = new GridLayout(2, false);
        addrGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        addrGroup.setLayoutData((Object)gd);
        Label hostLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)MySQLUIMessages.dialog_connection_host);
        hostLabel.setLayoutData((Object)new GridData(128));
        this.hostText = new Text(addrGroup, 2048);
        this.hostText.setLayoutData((Object)new GridData(768));
        this.hostText.addModifyListener(textListener);
        Label portLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)MySQLUIMessages.dialog_connection_port);
        portLabel.setLayoutData((Object)new GridData(128));
        this.portText = new Text(addrGroup, 2048);
        gd = new GridData(32);
        gd.widthHint = fontHeight * 10;
        this.portText.setLayoutData((Object)gd);
        this.portText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.portText.addModifyListener(textListener);
        Label dbLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)MySQLUIMessages.dialog_connection_database);
        dbLabel.setLayoutData((Object)new GridData(128));
        this.dbText = new Text(addrGroup, 2048);
        this.dbText.setLayoutData((Object)new GridData(768));
        this.dbText.addModifyListener(textListener);
        Label usernameLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)MySQLUIMessages.dialog_connection_user_name);
        usernameLabel.setLayoutData((Object)new GridData(128));
        this.usernameText = new Text(addrGroup, 2048);
        gd = new GridData(32);
        gd.widthHint = fontHeight * 20;
        this.usernameText.setLayoutData((Object)gd);
        this.usernameText.addModifyListener(textListener);
        Label passwordLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)MySQLUIMessages.dialog_connection_password);
        passwordLabel.setLayoutData((Object)new GridData(128));
        Composite passPH = UIUtils.createPlaceholder((Composite)addrGroup, (int)2, (int)5);
        passPH.setLayoutData((Object)new GridData(768));
        this.passwordText = new Text(passPH, 0x400800);
        gd = new GridData(32);
        gd.widthHint = fontHeight * 20;
        this.passwordText.setLayoutData((Object)gd);
        this.passwordText.addModifyListener(textListener);
        this.createSavePasswordButton(passPH);
        UIUtils.createHorizontalLine((Composite)addrGroup, (int)2, (int)10);
        this.homesSelector = new ClientHomesSelector(addrGroup, 0, MySQLUIMessages.dialog_connection_local_client);
        gd = new GridData(800);
        gd.horizontalSpan = 2;
        this.homesSelector.getPanel().setLayoutData((Object)gd);
        this.createDriverPanel(addrGroup);
        this.setControl((Control)addrGroup);
    }

    public boolean isComplete() {
        return this.hostText != null && this.portText != null && !CommonUtils.isEmpty((String)this.hostText.getText()) && !CommonUtils.isEmpty((String)this.portText.getText());
    }

    public void loadSettings() {
        super.loadSettings();
        DBPDriver driver = this.getSite().getDriver();
        if (driver != null && driver.getId().equalsIgnoreCase("mariaDB")) {
            this.setImageDescriptor(MySQLUIActivator.getImageDescriptor("icons/mariadb_logo.png"));
        } else {
            this.setImageDescriptor(MySQLUIActivator.getImageDescriptor("icons/mysql_logo.png"));
        }
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.hostText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                this.hostText.setText(connectionInfo.getHostName());
            } else {
                this.hostText.setText("localhost");
            }
        }
        if (this.portText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(connectionInfo.getHostPort());
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
        }
        if (this.dbText != null) {
            this.dbText.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
        }
        if (this.usernameText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getUserName())) {
                this.usernameText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserName()));
            } else if (this.site.isNew()) {
                this.usernameText.setText("root");
            }
        }
        if (this.passwordText != null) {
            this.passwordText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserPassword()));
        }
        if (this.serverTimezoneCombo != null) {
            String tzProp = connectionInfo.getProviderProperty("@dbeaver-serverTimezone@");
            if (CommonUtils.isEmpty((String)tzProp)) {
                this.serverTimezoneCombo.select(0);
            } else {
                this.serverTimezoneCombo.setText(tzProp);
            }
        }
        this.homesSelector.populateHomes(this.site.getDriver(), connectionInfo.getClientHomeId(), this.site.isNew());
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
        }
        if (this.portText != null) {
            connectionInfo.setHostPort(this.portText.getText().trim());
        }
        if (this.dbText != null) {
            connectionInfo.setDatabaseName(this.dbText.getText().trim());
        }
        if (this.usernameText != null) {
            connectionInfo.setUserName(this.usernameText.getText().trim());
        }
        if (this.passwordText != null) {
            connectionInfo.setUserPassword(this.passwordText.getText());
        }
        if (this.serverTimezoneCombo != null) {
            if (this.serverTimezoneCombo.getSelectionIndex() == 0 || CommonUtils.isEmpty((String)this.serverTimezoneCombo.getText())) {
                connectionInfo.removeProviderProperty("@dbeaver-serverTimezone@");
            } else {
                connectionInfo.setProviderProperty("@dbeaver-serverTimezone@", this.serverTimezoneCombo.getText());
            }
        }
        if (this.homesSelector != null) {
            connectionInfo.setClientHomeId(this.homesSelector.getSelectedHome());
        }
        super.saveSettings(dataSource);
    }

    public IDialogPage[] getSubPages(boolean extrasOnly) {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

