/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model.lock;

import java.sql.Date;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.model.admin.locks.DBAServerLock;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;

public class OracleLock
implements DBAServerLock {
    private int wait_sid;
    private int serial;
    private int wait_pid;
    private String wait_user;
    private String oname;
    private String owner;
    private long row_lock;
    private int hold_sid;
    private int hold_pid;
    private String hold_user;
    private Date ltime;
    private String status;
    private String event;
    private DBAServerLock hold = null;
    private List<DBAServerLock> waiters = new ArrayList<DBAServerLock>(0);

    public OracleLock(ResultSet dbResult) {
        this.wait_sid = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"waiting_session");
        this.serial = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"serial");
        this.hold_sid = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"holding_session");
        this.wait_pid = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"wait_pid");
        this.hold_pid = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"hold_pid");
        this.oname = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"oname");
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"owner");
        this.row_lock = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"row_lock");
        this.wait_user = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"waiting_user");
        this.hold_user = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"holding_user");
        this.ltime = JDBCUtils.safeGetDate((ResultSet)dbResult, (String)"logon_time");
        this.status = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"blocking_session_status");
        this.event = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"event");
    }

    public String getTitle() {
        return String.valueOf(this.wait_sid);
    }

    public DBAServerLock getHoldBy() {
        return this.hold;
    }

    public DBAServerLock getHold() {
        return this.hold;
    }

    public Integer getId() {
        return this.wait_sid;
    }

    public List<DBAServerLock> waitThis() {
        return this.waiters;
    }

    public Integer getHoldID() {
        return this.hold_sid;
    }

    public void setHoldBy(DBAServerLock lock) {
        this.hold = lock;
    }

    public String toString() {
        return String.format("Wait %s - %d (%s) Hold - %d (%s)", this.oname, this.wait_sid, this.wait_user, this.hold_sid, this.hold_user);
    }

    @Property(viewable=true, order=1)
    public int getWait_sid() {
        return this.wait_sid;
    }

    @Property(viewable=true, order=2)
    public int getWait_pid() {
        return this.wait_pid;
    }

    @Property(viewable=true, order=3)
    public String getWait_user() {
        return this.wait_user;
    }

    @Property(viewable=true, order=4)
    public String getOname() {
        return this.oname;
    }

    @Property(viewable=true, order=5)
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=true, order=6)
    public long getRow_lock() {
        return this.row_lock;
    }

    @Property(viewable=true, order=7)
    public int getHold_sid() {
        return this.hold_sid;
    }

    @Property(viewable=true, order=8)
    public int getHold_pid() {
        return this.hold_pid;
    }

    @Property(viewable=true, order=9)
    public String getHold_user() {
        return this.hold_user;
    }

    @Property(viewable=true, order=10)
    public Date getLtime() {
        return this.ltime;
    }

    @Property(viewable=true, order=11)
    public String getStatus() {
        return this.status;
    }

    @Property(viewable=true, order=12)
    public String getEvent() {
        return this.event;
    }

    public int getSerial() {
        return this.serial;
    }
}

