/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.data;

import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetListener;
import org.jkiss.dbeaver.ui.controls.resultset.QueryResultsDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetSaveSettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.editors.AbstractDatabaseObjectEditor;
import org.jkiss.dbeaver.ui.editors.data.DatabaseDataEditor;
import org.jkiss.dbeaver.ui.editors.entity.IEntityDataEditor;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public abstract class AbstractDataEditor<OBJECT_TYPE extends DBSObject>
extends AbstractDatabaseObjectEditor<OBJECT_TYPE>
implements IResultSetContainer,
IResultSetListener,
IEntityDataEditor {
    private static final Log log = Log.getLog(AbstractDataEditor.class);
    private ResultSetViewer resultSetView;
    private boolean loaded = false;
    private Composite parent;

    public void createPartControl(Composite parent) {
        this.parent = parent;
    }

    public void activatePart() {
        this.createResultSetView();
        if (!this.loaded && !this.isSuspendDataQuery() && this.isReadyToRun()) {
            this.resultSetView.setStatus(this.getDataQueryMessage());
            DBDDataFilter dataFilter = this.getEditorDataFilter();
            if (dataFilter == null) {
                this.resultSetView.refresh();
            } else {
                this.resultSetView.refreshWithFilter(dataFilter);
            }
            this.loaded = true;
        }
    }

    protected abstract DBDDataFilter getEditorDataFilter();

    protected abstract boolean isSuspendDataQuery();

    protected abstract String getDataQueryMessage();

    private void createResultSetView() {
        if (this.resultSetView == null) {
            this.resultSetView = new ResultSetViewer(this.parent, this.getSite(), this);
            this.resultSetView.addListener(this);
            this.parent.layout();
            this.resultSetView.getControl().setFocus();
            this.getSite().setSelectionProvider((ISelectionProvider)this.resultSetView);
        }
    }

    public void deactivatePart() {
    }

    public void dispose() {
        if (this.resultSetView != null) {
            this.resultSetView.removeListener(this);
            this.resultSetView = null;
        }
        super.dispose();
    }

    @Override
    @Nullable
    public ResultSetViewer getResultSetController() {
        return this.resultSetView;
    }

    @Override
    public boolean isReadyToRun() {
        return true;
    }

    @Override
    public void openNewContainer(DBRProgressMonitor monitor, @NotNull DBSDataContainer dataContainer, @NotNull DBDDataFilter newFilter) {
        DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext == null) {
            log.error((Object)"Can't open new container - not execution context found");
            return;
        }
        DBNDatabaseNode targetNode = executionContext.getDataSource().getContainer().getPlatform().getNavigatorModel().getNodeByObject(monitor, (DBSObject)dataContainer, false);
        if (targetNode == null) {
            UIUtils.showMessageBox(null, (String)"Open link", (String)("Can't navigate to '" + DBUtils.getObjectFullName((DBPNamedObject)dataContainer, (DBPEvaluationContext)DBPEvaluationContext.UI) + "' - navigator node not found"), (int)1);
            return;
        }
        AbstractDataEditor.openNewDataEditor(targetNode, newFilter);
    }

    @Override
    public IResultSetDecorator createResultSetDecorator() {
        return new QueryResultsDecorator();
    }

    public static void openNewDataEditor(DBNDatabaseNode targetNode, DBDDataFilter newFilter) {
        UIUtils.asyncExec(() -> {
            ResultSetViewer rsv;
            Object selectedPage;
            IEditorPart entityEditor = NavigatorHandlerObjectOpen.openEntityEditor((DBNNode)targetNode, (String)DatabaseDataEditor.class.getName(), null, Collections.singletonMap("dataFilter", newFilter), (IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow(), (boolean)true);
            if (newFilter != null && entityEditor instanceof MultiPageEditorPart && (selectedPage = ((MultiPageEditorPart)entityEditor).getSelectedPage()) instanceof IResultSetContainer && (rsv = (ResultSetViewer)((IResultSetContainer)selectedPage).getResultSetController()) != null && !rsv.isRefreshInProgress() && !newFilter.equals((Object)rsv.getModel().getDataFilter())) {
                rsv.refreshWithFilter(newFilter);
            }
        });
    }

    public void setFocus() {
        this.createResultSetView();
        if (this.resultSetView != null && !this.resultSetView.getActivePresentation().getControl().isDisposed()) {
            this.resultSetView.getActivePresentation().getControl().setFocus();
        }
        this.refreshActions();
    }

    private void refreshActions() {
        IActionBars actionBars = this.getEditorSite().getActionBars();
        actionBars.updateActionBars();
    }

    public boolean isDirty() {
        return this.resultSetView != null && !this.resultSetView.getControl().isDisposed() && this.resultSetView.isDirty();
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.resultSetView != null && this.resultSetView.isDirty() && !this.resultSetView.applyChanges(RuntimeUtils.makeMonitor((IProgressMonitor)monitor), new ResultSetSaveSettings())) {
            monitor.setCanceled(true);
        }
    }

    @Override
    public void handleResultSetLoad() {
        this.refreshActions();
    }

    @Override
    public void handleResultSetChange() {
        this.firePropertyChange(257);
    }

    @Override
    public void handleResultSetSelectionChange(SelectionChangedEvent event) {
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (this.resultSetView != null) {
            if (adapter == IResultSetController.class || adapter == ResultSetViewer.class) {
                return adapter.cast(this.resultSetView);
            }
            T res = this.resultSetView.getAdapter(adapter);
            if (res != null) {
                return res;
            }
        }
        return null;
    }

    public void refreshPart(Object source, boolean force) {
        if (force && this.resultSetView != null && this.resultSetView.hasData() && !this.resultSetView.isRefreshInProgress()) {
            this.resultSetView.refresh();
        }
    }

    public boolean isActiveTask() {
        return this.resultSetView.isRefreshInProgress();
    }
}

