crystal_doc_search_index_callback({"repository_name":"","body":"# Crystal\n\n[![Travis CI Build Status](https://travis-ci.org/crystal-lang/crystal.svg)](https://travis-ci.org/crystal-lang/crystal)\n[![CircleCI Build Status](https://circleci.com/gh/crystal-lang/crystal/tree/master.svg?style=shield)](https://circleci.com/gh/crystal-lang/crystal)\n[![Join the chat at https://gitter.im/crystal-lang/crystal](https://badges.gitter.im/crystal-lang/crystal.svg)](https://gitter.im/crystal-lang/crystal)\n[![Bountysource](https://api.bountysource.com/badge/team?team_id=89730&style=raised)](https://salt.bountysource.com/teams/crystal-lang)\n[![Code Triagers Badge](https://www.codetriage.com/crystal-lang/crystal/badges/users.svg)](https://www.codetriage.com/crystal-lang/crystal)\n\n---\n\n[![born-and-raised](https://cloud.githubusercontent.com/assets/209371/13291809/022e2360-daf8-11e5-8be7-d02c1c8b38fb.png)](https://manas.tech/)\n\nCrystal is a programming language with the following goals:\n\n* Have a syntax similar to Ruby (but compatibility with it is not a goal)\n* Statically type-checked but without having to specify the type of variables or method arguments.\n* Be able to call C code by writing bindings to it in Crystal.\n* Have compile-time evaluation and generation of code, to avoid boilerplate code.\n* Compile to efficient native code.\n\nWhy?\n----\n\nWe love Ruby's efficiency for writing code.\n\nWe love C's efficiency for running code.\n\nWe want the best of both worlds.\n\nWe want the compiler to understand what we mean without having to specify types everywhere.\n\nWe want full OOP.\n\nOh, and we don't want to write C code to make the code run faster.\n\nProject Status\n--------------\n\nCrystal is still under heavy development. There can be breaking changes but we're trying to keep them as minimum as possible.\n\nThe development is possible thanks to the community's effort, [84codes](https://www.84codes.com/)' support, and every [BountySource supporter](https://crystal-lang.org/sponsors).\n\nInstalling\n----------\n\n[Follow these instructions](https://crystal-lang.org/docs/installation/index.html)\n\nTry it online\n-------------\n\n[play.crystal-lang.org](https://play.crystal-lang.org/)\n\nDocumentation\n-------------\n\n* [Official docs](http://crystal-lang.org/docs)\n* [Standard library API](https://crystal-lang.org/api)\n* [Roadmap](https://github.com/crystal-lang/crystal/wiki/Roadmap)\n\nCommunity\n---------\n\nQuestions or suggestions? Ask on the [Crystal Forum](https://forum.crystal-lang.org), on our [Gitter channel](https://gitter.im/crystal-lang/crystal) or IRC channel [#crystal-lang](http://webchat.freenode.net/?channels=#crystal-lang) at chat.freenode.net, or on Stack Overflow under the [crystal-lang](http://stackoverflow.com/questions/tagged/crystal-lang) tag. There is also an archived [Google Group](https://groups.google.com/forum/?fromgroups#!forum/crystal-lang).\n\nContributing\n------------\n\nRead the general [Contributing guide](https://github.com/crystal-lang/crystal/blob/master/CONTRIBUTING.md), and then:\n\n1. Fork it (<https://github.com/crystal-lang/crystal/fork>)\n2. Create your feature branch (`git checkout -b my-new-feature`)\n3. Commit your changes (`git commit -am 'Add some feature'`)\n4. Push to the branch (`git push origin my-new-feature`)\n5. Create a new Pull Request\n","program":{"html_id":"/toplevel","path":"toplevel.html","kind":"module","full_name":"Top Level Namespace","name":"Top Level Namespace","abstract":false,"superclass":null,"ancestors":[{"html_id":"/Spec/Methods","kind":"module","full_name":"Spec::Methods","name":"Methods"},{"html_id":"/Spec/Expectations","kind":"module","full_name":"Spec::Expectations","name":"Expectations"}],"locations":[],"repository_name":"","program":true,"enum":false,"alias":false,"aliased":"","const":false,"constants":[{"id":"ARGF","name":"ARGF","value":"IO::ARGF.new(ARGV, STDIN)","doc":"An `IO` for reading files from `ARGV`.\n\nUsage example:\n\n`program.cr`:\n```\nputs ARGF.gets_to_end\n```\n\nA file to read from: (`file`)\n```text\n123\n```\n\n```text\n$ crystal build program.cr\n$ ./program file\n123\n$ ./program file file\n123123\n$ # If ARGV is empty, ARGF reads from STDIN instead:\n$ echo \"hello\" | ./program\nhello\n$ ./program unknown\nUnhandled exception: Error opening file 'unknown' with mode 'r': No such file or directory (Errno)\n...\n```\n\nAfter a file from `ARGV` has been read, it's removed from `ARGV`.\n\nYou can manipulate `ARGV` yourself to control what `ARGF` operates on.\nIf you remove a file from `ARGV`, it is ignored by `ARGF`; if you add files to `ARGV`, `ARGF` will read from it.\n\n```\nARGV.replace [\"file1\"]\nARGF.gets_to_end # => Content of file1\nARGV             # => []\nARGV << \"file2\"\nARGF.gets_to_end # => Content of file2\n```","summary":"<p>An <code><a href=\"IO.html\">IO</a></code> for reading files from <code><a href=\"toplevel.html#ARGV\">ARGV</a></code>.</p>"},{"id":"ARGV","name":"ARGV","value":"Array.new(ARGC_UNSAFE - 1) do |i|\n  String.new(ARGV_UNSAFE[1 + i])\nend","doc":"An array of arguments passed to the program.","summary":"<p>An array of arguments passed to the program.</p>"},{"id":"PROGRAM_NAME","name":"PROGRAM_NAME","value":"String.new(ARGV_UNSAFE.value)","doc":"The name, the program was called with.","summary":"<p>The name, the program was called with.</p>"},{"id":"STDERR","name":"STDERR","value":"IO::FileDescriptor.from_stdio(2)","doc":"The standard error file descriptor.\n\nTypically used to output error messages and diagnostics.\n\nWhen this is a TTY device, `sync` will be true for it\nat the start of the program.","summary":"<p>The standard error file descriptor.</p>"},{"id":"STDIN","name":"STDIN","value":"IO::FileDescriptor.from_stdio(0)","doc":"The standard input file descriptor. Contains data piped to the program.","summary":"<p>The standard input file descriptor.</p>"},{"id":"STDOUT","name":"STDOUT","value":"IO::FileDescriptor.from_stdio(1)","doc":"The standard output file descriptor.\n\nTypically used to output data and information.\n\nWhen this is a TTY device, `sync` will be true for it\nat the start of the program.","summary":"<p>The standard output file descriptor.</p>"}],"included_modules":[{"html_id":"/Spec/Expectations","kind":"module","full_name":"Spec::Expectations","name":"Expectations"},{"html_id":"/Spec/Methods","kind":"module","full_name":"Spec::Methods","name":"Methods"}],"extended_modules":[{"html_id":"/Spec/Expectations","kind":"module","full_name":"Spec::Expectations","name":"Expectations"},{"html_id":"/Spec/Methods","kind":"module","full_name":"Spec::Methods","name":"Methods"}],"subclasses":[],"including_types":[],"namespace":null,"doc":null,"summary":null,"class_methods":[{"id":"__crystal_once(state:Pointer(Void),flag:Pointer(Bool),initializer:Pointer(Void))-class-method","html_id":"__crystal_once(state:Pointer(Void),flag:Pointer(Bool),initializer:Pointer(Void))-class-method","name":"__crystal_once","doc":null,"summary":null,"abstract":false,"args":[{"name":"state","doc":null,"default_value":"","external_name":"state","restriction":""},{"name":"flag","doc":null,"default_value":"","external_name":"flag","restriction":""},{"name":"initializer","doc":null,"default_value":"","external_name":"initializer","restriction":""}],"args_string":"(state : Pointer(Void), flag : Pointer(Bool), initializer : Pointer(Void))","source_link":null,"def":{"name":"__crystal_once","args":[{"name":"state","doc":null,"default_value":"","external_name":"state","restriction":""},{"name":"flag","doc":null,"default_value":"","external_name":"flag","restriction":""},{"name":"initializer","doc":null,"default_value":"","external_name":"initializer","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(state.as(Crystal::OnceState)).once(flag, initializer)"}},{"id":"__crystal_once_init-class-method","html_id":"__crystal_once_init-class-method","name":"__crystal_once_init","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"__crystal_once_init","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Crystal::OnceState.new.as(::Pointer(Void))"}},{"id":"__mulodi4(a:Int64,b:Int64,overflow:Pointer(Int32))-class-method","html_id":"__mulodi4(a:Int64,b:Int64,overflow:Pointer(Int32))-class-method","name":"__mulodi4","doc":null,"summary":null,"abstract":false,"args":[{"name":"a","doc":null,"default_value":"","external_name":"a","restriction":""},{"name":"b","doc":null,"default_value":"","external_name":"b","restriction":""},{"name":"overflow","doc":null,"default_value":"","external_name":"overflow","restriction":""}],"args_string":"(a : Int64, b : Int64, overflow : Pointer(Int32))","source_link":null,"def":{"name":"__mulodi4","args":[{"name":"a","doc":null,"default_value":"","external_name":"a","restriction":""},{"name":"b","doc":null,"default_value":"","external_name":"b","restriction":""},{"name":"overflow","doc":null,"default_value":"","external_name":"overflow","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"n = 64\nmin = Int64::MIN\nmax = Int64::MAX\noverflow.value = 0\nresult = a &* b\nif a == min\n  if (b != 0) && (b != 1)\n    overflow.value = 1\n  end\n  return result\nend\nif b == min\n  if (a != 0) && (a != 1)\n    overflow.value = 1\n  end\n  return result\nend\nsa = a >> (n &- 1)\nabs_a = (a ^ sa) &- sa\nsb = b >> (n &- 1)\nabs_b = (b ^ sb) &- sb\nif abs_a < 2 || abs_b < 2\n  return result\nend\nif sa == sb\n  if abs_a > (max // abs_b)\n    overflow.value = 1\n  end\nelse\n  if abs_a > (min // (0_i64 &- abs_b))\n    overflow.value = 1\n  end\nend\nreturn result\n"}},{"id":"`(command):String-class-method","html_id":"`(command):String-class-method","name":"`","doc":"Returns the standard output of executing *command* in a subshell.\nStandard input, and error are inherited.\nThe special `$?` variable is set to a `Process::Status` associated with this execution.\n\nExample:\n\n```\n`echo hi` # => \"hi\\n\"\n```","summary":"<p>Returns the standard output of executing <em>command</em> in a subshell.</p>","abstract":false,"args":[{"name":"command","doc":null,"default_value":"","external_name":"command","restriction":""}],"args_string":"(command) : String","source_link":null,"def":{"name":"`","args":[{"name":"command","doc":null,"default_value":"","external_name":"command","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"process = Process.new(command, shell: true, input: Process::Redirect::Inherit, output: Process::Redirect::Pipe, error: Process::Redirect::Inherit)\noutput = process.output.gets_to_end\nstatus = process.wait\n$? = status\noutput\n"}},{"id":"abort(message,status=1):NoReturn-class-method","html_id":"abort(message,status=1):NoReturn-class-method","name":"abort","doc":"Terminates execution immediately, printing *message* to `STDERR` and\nthen calling `exit(status)`.","summary":"<p>Terminates execution immediately, printing <em>message</em> to <code><a href=\"toplevel.html#STDERR\">STDERR</a></code> and then calling <code><a href=\"toplevel.html#exit(status=0):NoReturn-class-method\">exit(status)</a></code>.</p>","abstract":false,"args":[{"name":"message","doc":null,"default_value":"","external_name":"message","restriction":""},{"name":"status","doc":null,"default_value":"1","external_name":"status","restriction":""}],"args_string":"(message, status = <span class=\"n\">1</span>) : NoReturn","source_link":null,"def":{"name":"abort","args":[{"name":"message","doc":null,"default_value":"","external_name":"message","restriction":""},{"name":"status","doc":null,"default_value":"1","external_name":"status","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NoReturn","visibility":"Public","body":"if message\n  STDERR.puts(message)\nend\nexit(status)\n"}},{"id":"at_exit(&handler:Int32,Exception?->):Nil-class-method","html_id":"at_exit(&amp;handler:Int32,Exception?-&gt;):Nil-class-method","name":"at_exit","doc":"Registers the given `Proc` for execution when the program exits.\nIf multiple handlers are registered, they are executed in reverse order of registration.\n\n```\ndef do_at_exit(str1)\n  at_exit { print str1 }\nend\n\nat_exit { puts \"cruel world\" }\ndo_at_exit(\"goodbye \")\nexit\n```\n\nProduces:\n\n```text\ngoodbye cruel world\n```\n\nThe exit status code that will be returned by this program is passed to\nthe block as its first argument. In case of any unhandled exception, it is\npassed as the second argument to the block, if the program terminates\nnormally or `exit(status)` is called explicitly, then the second argument\nwill be nil.","summary":"<p>Registers the given <code><a href=\"Proc.html\">Proc</a></code> for execution when the program exits.</p>","abstract":false,"args":[],"args_string":"(&handler : Int32, Exception? -> ) : Nil","source_link":null,"def":{"name":"at_exit","args":[],"double_splat":null,"splat_index":null,"yields":2,"block_arg":{"name":"handler","doc":null,"default_value":"","external_name":"handler","restriction":"(Int32, Exception | ::Nil -> )"},"return_type":"Nil","visibility":"Public","body":"AtExitHandlers.add(handler)"}},{"id":"caller-class-method","html_id":"caller-class-method","name":"caller","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"caller","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"CallStack.new.printable_backtrace"}},{"id":"delay(delay,&block:->UNDERSCORE)-class-method","html_id":"delay(delay,&amp;block:-&gt;UNDERSCORE)-class-method","name":"delay","doc":"Spawns a `Fiber` to compute *&block* in the background after *delay* has elapsed.\nAccess to get is synchronized between fibers. *&block* is only called once.\nMay be canceled before *&block* is called by calling `cancel`.\n```\nd = delay(1) { Process.kill(Signal::KILL, Process.pid) }\n# ... long operations ...\nd.cancel\n```","summary":"<p>Spawns a <code><a href=\"Fiber.html\">Fiber</a></code> to compute <em>&block</em> in the background after <em>delay</em> has elapsed.</p>","abstract":false,"args":[{"name":"delay","doc":null,"default_value":"","external_name":"delay","restriction":""}],"args_string":"(delay, &block :  -> UNDERSCORE)","source_link":null,"def":{"name":"delay","args":[{"name":"delay","doc":null,"default_value":"","external_name":"delay","restriction":""}],"double_splat":null,"splat_index":null,"yields":0,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":"(-> _)"},"return_type":"","visibility":"Public","body":"Concurrent::Future.new(delay: delay, &block)"}},{"id":"exit(status=0):NoReturn-class-method","html_id":"exit(status=0):NoReturn-class-method","name":"exit","doc":"Terminates execution immediately, returning the given status code\nto the invoking environment.\n\nRegistered `at_exit` procs are executed.","summary":"<p>Terminates execution immediately, returning the given status code to the invoking environment.</p>","abstract":false,"args":[{"name":"status","doc":null,"default_value":"0","external_name":"status","restriction":""}],"args_string":"(status = <span class=\"n\">0</span>) : NoReturn","source_link":null,"def":{"name":"exit","args":[{"name":"status","doc":null,"default_value":"0","external_name":"status","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NoReturn","visibility":"Public","body":"status = AtExitHandlers.run(status)\nSTDOUT.flush\nSTDERR.flush\nProcess.exit(status)\n"}},{"id":"fork-class-method","html_id":"fork-class-method","name":"fork","doc":"See also: `Process.fork`","summary":"<p>See also: <code>Process.fork</code></p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"fork","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Process.fork"}},{"id":"fork(&block)-class-method","html_id":"fork(&amp;block)-class-method","name":"fork","doc":"See also: `Process.fork`","summary":"<p>See also: <code>Process.fork</code></p>","abstract":false,"args":[],"args_string":"(&block)","source_link":null,"def":{"name":"fork","args":[],"double_splat":null,"splat_index":null,"yields":0,"block_arg":null,"return_type":"","visibility":"Public","body":"Process.fork do\n  yield\nend"}},{"id":"future(&exp:->UNDERSCORE)-class-method","html_id":"future(&amp;exp:-&gt;UNDERSCORE)-class-method","name":"future","doc":"Spawns a `Fiber` to compute *&block* in the background.\nAccess to get is synchronized between fibers.  *&block* is only called once.\n```\nf = future { `echo hello` }\n# ... other actions ...\nf.get # => \"hello\\n\"\n```","summary":"<p>Spawns a <code><a href=\"Fiber.html\">Fiber</a></code> to compute <em>&block</em> in the background.</p>","abstract":false,"args":[],"args_string":"(&exp :  -> UNDERSCORE)","source_link":null,"def":{"name":"future","args":[],"double_splat":null,"splat_index":null,"yields":0,"block_arg":{"name":"exp","doc":null,"default_value":"","external_name":"exp","restriction":"(-> _)"},"return_type":"","visibility":"Public","body":"Concurrent::Future.new(&exp)"}},{"id":"gets(*args,**options)-class-method","html_id":"gets(*args,**options)-class-method","name":"gets","doc":"Reads a line from `STDIN`.\n\nSee also: `IO#gets`.","summary":"<p>Reads a line from <code><a href=\"toplevel.html#STDIN\">STDIN</a></code>.</p>","abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","source_link":null,"def":{"name":"gets","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"STDIN.gets(*args, **options)"}},{"id":"lazy(&block:->UNDERSCORE)-class-method","html_id":"lazy(&amp;block:-&gt;UNDERSCORE)-class-method","name":"lazy","doc":"Conditionally spawns a `Fiber` to run *&block* in the background.\nAccess to get is synchronized between fibers. *&block* is only called once.\n*&block* doesn't run by default, only when `get` is called.\n```\nl = lazy { expensive_computation }\nspawn { maybe_use_computation(l) }\nspawn { maybe_use_computation(l) }\n```","summary":"<p>Conditionally spawns a <code><a href=\"Fiber.html\">Fiber</a></code> to run <em>&block</em> in the background.</p>","abstract":false,"args":[],"args_string":"(&block :  -> UNDERSCORE)","source_link":null,"def":{"name":"lazy","args":[],"double_splat":null,"splat_index":null,"yields":0,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":"(-> _)"},"return_type":"","visibility":"Public","body":"Concurrent::Future.new(run_immediately: false, &block)"}},{"id":"loop(&block)-class-method","html_id":"loop(&amp;block)-class-method","name":"loop","doc":"Repeatedly executes the block.\n\n```\nloop do\n  line = gets\n  break unless line\n  # ...\nend\n```","summary":"<p>Repeatedly executes the block.</p>","abstract":false,"args":[],"args_string":"(&block)","source_link":null,"def":{"name":"loop","args":[],"double_splat":null,"splat_index":null,"yields":0,"block_arg":null,"return_type":"","visibility":"Public","body":"while true\n  yield\nend"}},{"id":"main(argc:Int32,argv:Pointer(Pointer(UInt8)))-class-method","html_id":"main(argc:Int32,argv:Pointer(Pointer(UInt8)))-class-method","name":"main","doc":"Main function that acts as C's main function.\nInvokes `Crystal.main`.\n\nCan be redefined. See `Crystal.main` for examples.","summary":"<p>Main function that acts as C's main function.</p>","abstract":false,"args":[{"name":"argc","doc":null,"default_value":"","external_name":"argc","restriction":""},{"name":"argv","doc":null,"default_value":"","external_name":"argv","restriction":""}],"args_string":"(argc : Int32, argv : Pointer(Pointer(UInt8)))","source_link":null,"def":{"name":"main","args":[{"name":"argc","doc":null,"default_value":"","external_name":"argc","restriction":""},{"name":"argv","doc":null,"default_value":"","external_name":"argv","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Crystal.main(argc, argv)"}},{"id":"p(object)-class-method","html_id":"p(object)-class-method","name":"p","doc":"Inspects *object* to `STDOUT` followed\nby a newline. Returns *object*.\n\nSee also: `Object#inspect(io)`.","summary":"<p>Inspects <em>object</em> to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code> followed by a newline.</p>","abstract":false,"args":[{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":""}],"args_string":"(object)","source_link":null,"def":{"name":"p","args":[{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"object.inspect(STDOUT)\nputs\nobject\n"}},{"id":"p(**objects)-class-method","html_id":"p(**objects)-class-method","name":"p","doc":"Inspects *objects* to `STDOUT`, followed\nby a newline. Returns *objects*.\n\n```\np foo: 23, bar: 42 # => {foo: 23, bar: 42}\n```\n\nSee `Object#inspect(io)`","summary":"<p>Inspects <em>objects</em> to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code>, followed by a newline.</p>","abstract":false,"args":[],"args_string":"(**objects)","source_link":null,"def":{"name":"p","args":[],"double_splat":{"name":"objects","doc":null,"default_value":"","external_name":"objects","restriction":""},"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if objects.empty?\nelse\n  p(objects)\nend"}},{"id":"p(*objects)-class-method","html_id":"p(*objects)-class-method","name":"p","doc":"Inspects each object in *objects* to `STDOUT`, followed\nby a newline. Returns *objects*.\n\nSee also: `Object#inspect(io)`.","summary":"<p>Inspects each object in <em>objects</em> to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code>, followed by a newline.</p>","abstract":false,"args":[{"name":"objects","doc":null,"default_value":"","external_name":"objects","restriction":""}],"args_string":"(*objects)","source_link":null,"def":{"name":"p","args":[{"name":"objects","doc":null,"default_value":"","external_name":"objects","restriction":""}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"objects.each do |obj|\n  p(obj)\nend\nobjects\n"}},{"id":"pp(object)-class-method","html_id":"pp(object)-class-method","name":"pp","doc":"Pretty prints *object* to `STDOUT` followed\nby a newline. Returns *object*.\n\nSee also: `Object#pretty_print(pp)`.","summary":"<p>Pretty prints <em>object</em> to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code> followed by a newline.</p>","abstract":false,"args":[{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":""}],"args_string":"(object)","source_link":null,"def":{"name":"pp","args":[{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"PrettyPrint.format(object, STDOUT, 79)\nputs\nobject\n"}},{"id":"pp(**objects)-class-method","html_id":"pp(**objects)-class-method","name":"pp","doc":"Pretty prints *objects* to `STDOUT`, followed\nby a newline. Returns *objects*.\n\n```\np foo: 23, bar: 42 # => {foo: 23, bar: 42}\n```\n\nSee `Object#pretty_print(pp)`","summary":"<p>Pretty prints <em>objects</em> to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code>, followed by a newline.</p>","abstract":false,"args":[],"args_string":"(**objects)","source_link":null,"def":{"name":"pp","args":[],"double_splat":{"name":"objects","doc":null,"default_value":"","external_name":"objects","restriction":""},"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if objects.empty?\nelse\n  pp(objects)\nend"}},{"id":"pp(*objects)-class-method","html_id":"pp(*objects)-class-method","name":"pp","doc":"Pretty prints each object in *objects* to `STDOUT`, followed\nby a newline. Returns *objects*.\n\nSee also: `Object#pretty_print(pp)`.","summary":"<p>Pretty prints each object in <em>objects</em> to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code>, followed by a newline.</p>","abstract":false,"args":[{"name":"objects","doc":null,"default_value":"","external_name":"objects","restriction":""}],"args_string":"(*objects)","source_link":null,"def":{"name":"pp","args":[{"name":"objects","doc":null,"default_value":"","external_name":"objects","restriction":""}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"objects.each do |obj|\n  pp(obj)\nend\nobjects\n"}},{"id":"print(*objects:UNDERSCORE):Nil-class-method","html_id":"print(*objects:UNDERSCORE):Nil-class-method","name":"print","doc":"Prints objects to `STDOUT` and then invokes `STDOUT.flush`.\n\nSee also: `IO#print`.","summary":"<p>Prints objects to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code> and then invokes <code>STDOUT.flush</code>.</p>","abstract":false,"args":[{"name":"objects","doc":null,"default_value":"","external_name":"objects","restriction":"_"}],"args_string":"(*objects : UNDERSCORE) : Nil","source_link":null,"def":{"name":"print","args":[{"name":"objects","doc":null,"default_value":"","external_name":"objects","restriction":"_"}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"STDOUT.print(*objects)"}},{"id":"printf(format_string,*args):Nil-class-method","html_id":"printf(format_string,*args):Nil-class-method","name":"printf","doc":"Prints a formatted string to `STDOUT`.\n\nFor details on the format string, see `sprintf`.","summary":"<p>Prints a formatted string to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code>.</p>","abstract":false,"args":[{"name":"format_string","doc":null,"default_value":"","external_name":"format_string","restriction":""},{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(format_string, *args) : Nil","source_link":null,"def":{"name":"printf","args":[{"name":"format_string","doc":null,"default_value":"","external_name":"format_string","restriction":""},{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":null,"splat_index":1,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"printf(format_string, args)"}},{"id":"printf(format_string,args:Array|Tuple):Nil-class-method","html_id":"printf(format_string,args:Array|Tuple):Nil-class-method","name":"printf","doc":"Prints a formatted string to `STDOUT`.\n\nFor details on the format string, see `sprintf`.","summary":"<p>Prints a formatted string to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code>.</p>","abstract":false,"args":[{"name":"format_string","doc":null,"default_value":"","external_name":"format_string","restriction":""},{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":"Array | Tuple"}],"args_string":"(format_string, args : Array | Tuple) : Nil","source_link":null,"def":{"name":"printf","args":[{"name":"format_string","doc":null,"default_value":"","external_name":"format_string","restriction":""},{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":"Array | Tuple"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"STDOUT.printf(format_string, args)"}},{"id":"puts(*objects):Nil-class-method","html_id":"puts(*objects):Nil-class-method","name":"puts","doc":"Prints objects to `STDOUT`, each followed by a newline.\n\nSee also: `IO#puts`.","summary":"<p>Prints objects to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code>, each followed by a newline.</p>","abstract":false,"args":[{"name":"objects","doc":null,"default_value":"","external_name":"objects","restriction":""}],"args_string":"(*objects) : Nil","source_link":null,"def":{"name":"puts","args":[{"name":"objects","doc":null,"default_value":"","external_name":"objects","restriction":""}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"STDOUT.puts(*objects)"}},{"id":"raise(exception:Exception):NoReturn-class-method","html_id":"raise(exception:Exception):NoReturn-class-method","name":"raise","doc":"Raises the *exception*.\n\nThis will set the exception's callstack if it hasn't been already.\nRe-raising a previously catched exception won't replace the callstack.","summary":"<p>Raises the <em>exception</em>.</p>","abstract":false,"args":[{"name":"exception","doc":null,"default_value":"","external_name":"exception","restriction":"Exception"}],"args_string":"(exception : Exception) : NoReturn","source_link":null,"def":{"name":"raise","args":[{"name":"exception","doc":null,"default_value":"","external_name":"exception","restriction":"Exception"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NoReturn","visibility":"Public","body":"exception.callstack || (exception.callstack = CallStack.new)\nunwind_ex = Pointer(LibUnwind::Exception).malloc\nunwind_ex.value.exception_class = LibC::SizeT.zero\nunwind_ex.value.exception_cleanup = LibC::SizeT.zero\nunwind_ex.value.exception_object = exception.object_id\nunwind_ex.value.exception_type_id = exception.crystal_type_id\n__crystal_raise(unwind_ex)\n"}},{"id":"raise(message:String):NoReturn-class-method","html_id":"raise(message:String):NoReturn-class-method","name":"raise","doc":"Raises an Exception with the *message*.","summary":"<p>Raises an Exception with the <em>message</em>.</p>","abstract":false,"args":[{"name":"message","doc":null,"default_value":"","external_name":"message","restriction":"String"}],"args_string":"(message : String) : NoReturn","source_link":null,"def":{"name":"raise","args":[{"name":"message","doc":null,"default_value":"","external_name":"message","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NoReturn","visibility":"Public","body":"raise(Exception.new(message))"}},{"id":"rand(x)-class-method","html_id":"rand(x)-class-method","name":"rand","doc":"See `Random#rand(x)`.","summary":"<p>See <code>Random#rand(x)</code>.</p>","abstract":false,"args":[{"name":"x","doc":null,"default_value":"","external_name":"x","restriction":""}],"args_string":"(x)","source_link":null,"def":{"name":"rand","args":[{"name":"x","doc":null,"default_value":"","external_name":"x","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Random.rand(x)"}},{"id":"rand-class-method","html_id":"rand-class-method","name":"rand","doc":"See `Random#rand`.","summary":"<p>See <code>Random#rand</code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"rand","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Random.rand"}},{"id":"read_line(*args,**options)-class-method","html_id":"read_line(*args,**options)-class-method","name":"read_line","doc":"Reads a line from `STDIN`.\n\nSee also: `IO#read_line`.","summary":"<p>Reads a line from <code><a href=\"toplevel.html#STDIN\">STDIN</a></code>.</p>","abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","source_link":null,"def":{"name":"read_line","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"STDIN.read_line(*args, **options)"}},{"id":"sleep-class-method","html_id":"sleep-class-method","name":"sleep","doc":"Blocks the current fiber forever.\n\nMeanwhile, other ready-to-execute fibers might start their execution.","summary":"<p>Blocks the current fiber forever.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"sleep","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Crystal::Scheduler.reschedule"}},{"id":"sleep(time:Time::Span)-class-method","html_id":"sleep(time:Time::Span)-class-method","name":"sleep","doc":"Blocks the current Fiber for the specified time span.\n\nWhile this fiber is waiting this time, other ready-to-execute\nfibers might start their execution.","summary":"<p>Blocks the current Fiber for the specified time span.</p>","abstract":false,"args":[{"name":"time","doc":null,"default_value":"","external_name":"time","restriction":"Time::Span"}],"args_string":"(time : Time::Span)","source_link":null,"def":{"name":"sleep","args":[{"name":"time","doc":null,"default_value":"","external_name":"time","restriction":"Time::Span"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Crystal::Scheduler.sleep(time)"}},{"id":"sleep(seconds:Number)-class-method","html_id":"sleep(seconds:Number)-class-method","name":"sleep","doc":"Blocks the current fiber for the specified number of seconds.\n\nWhile this fiber is waiting this time, other ready-to-execute\nfibers might start their execution.","summary":"<p>Blocks the current fiber for the specified number of seconds.</p>","abstract":false,"args":[{"name":"seconds","doc":null,"default_value":"","external_name":"seconds","restriction":"Number"}],"args_string":"(seconds : Number)","source_link":null,"def":{"name":"sleep","args":[{"name":"seconds","doc":null,"default_value":"","external_name":"seconds","restriction":"Number"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if seconds < 0\n  raise(ArgumentError.new(\"Sleep seconds must be positive\"))\nend\nCrystal::Scheduler.sleep(seconds.seconds)\n"}},{"id":"spawn(*,name:String?=nil,same_thread=false,&block)-class-method","html_id":"spawn(*,name:String?=nil,same_thread=false,&amp;block)-class-method","name":"spawn","doc":"Spawns a new fiber.\n\nThe newly created fiber doesn't run as soon as spawned.\n\nExample:\n```\n# Write \"1\" every 1 second and \"2\" every 2 seconds for 6 seconds.\n\nch = Channel(Nil).new\n\nspawn do\n  6.times do\n    sleep 1\n    puts 1\n  end\n  ch.send(nil)\nend\n\nspawn do\n  3.times do\n    sleep 2\n    puts 2\n  end\n  ch.send(nil)\nend\n\n2.times { ch.receive }\n```","summary":"<p>Spawns a new fiber.</p>","abstract":false,"args":[{"name":"","doc":null,"default_value":"","external_name":"","restriction":""},{"name":"name","doc":null,"default_value":"nil","external_name":"name","restriction":"String | ::Nil"},{"name":"same_thread","doc":null,"default_value":"false","external_name":"same_thread","restriction":""}],"args_string":"(*, name : String? = <span class=\"n\">nil</span>, same_thread = <span class=\"n\">false</span>, &block)","source_link":null,"def":{"name":"spawn","args":[{"name":"","doc":null,"default_value":"","external_name":"","restriction":""},{"name":"name","doc":null,"default_value":"nil","external_name":"name","restriction":"String | ::Nil"},{"name":"same_thread","doc":null,"default_value":"false","external_name":"same_thread","restriction":""}],"double_splat":null,"splat_index":0,"yields":0,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":""},"return_type":"","visibility":"Public","body":"fiber = Fiber.new(name, &block)\nif same_thread\n  (fiber.@current_thread).set(Thread.current)\nend\nCrystal::Scheduler.enqueue(fiber)\nfiber\n"}},{"id":"sprintf(format_string,args:Array|Tuple):String-class-method","html_id":"sprintf(format_string,args:Array|Tuple):String-class-method","name":"sprintf","doc":"Returns a formatted string.\nThe string is produced according to the *format_string* with format specifiers\nbeing replaced by values from *args* formatted according to the specifier.\n\nWithin the format string, any characters other than format specifiers\n(specifiers beginning with `%`) are copied to the result.\n\nThe syntax for a format specifier is:\n\n```text\n%[flags][width][.precision]type\n```\n\nA format specifier consists of a percent sign, followed by optional flags,\nwidth, and precision indicators, then terminated with a field type\ncharacter.\n\nThe field type controls how the corresponding\n`sprintf` argument is to be interpreted, while the flags\nmodify that interpretation.\n\nThe field type characters are:\n\n```text\nField | Integer Format\n------+------------------------------------------------------------------\n  b   | Formats argument as a binary number.\n  d   | Formats argument as a decimal number.\n  i   | Same as d.\n  o   | Formats argument as an octal number.\n  x   | Formats argument as a hexadecimal number using lowercase letters.\n  X   | Same as x, but uses uppercase letters.\n\nField | Float Format\n------+---------------------------------------------------------------\n  e   | Formats floating point argument into exponential notation\n      | with one digit before the decimal point as [-]d.dddddde[+-]dd.\n      | The precision specifies the number of digits after the decimal\n      | point (defaulting to six).\n  E   | Equivalent to e, but uses an uppercase E to indicate\n      | the exponent.\n  f   | Formats floating point argument as [-]ddd.dddddd,\n      | where the precision specifies the number of digits after\n      | the decimal point.\n  g   | Formats a floating point number using exponential form\n      | if the exponent is less than -4 or greater than or\n      | equal to the precision, or in dd.dddd form otherwise.\n      | The precision specifies the number of significant digits.\n  G   | Equivalent to g, but use an uppercase E in exponent form.\n  a   | Formats floating point argument as [-]0xh.hhhhp[+-]dd,\n      | which is consisted from optional sign, \"0x\", fraction part\n      | as hexadecimal, \"p\", and exponential part as decimal.\n  A   | Equivalent to a, but use uppercase X and P.\n\nField | Other Format\n------+------------------------------------------------------------\n  c   | Argument is a single character itself.\n  s   | Argument is a string to be substituted. If the format\n      | sequence contains a precision, at most that many characters\n      | will be copied.\n  %   | A percent sign itself will be displayed. No argument taken.\n```\nThe flags modifies the behavior of the formats.\nThe flag characters are:\n```text\nFlag     | Applies to    | Meaning\n---------+---------------+--------------------------------------------\nspace    | bdiouxX       | Add a leading space character to\n         | aAeEfgG       | non-negative numbers.\n         | (numeric fmt) | For o, x, X, b, use\n         |               | a minus sign with absolute value for\n         |               | negative values.\n---------+---------------+--------------------------------------------\n+        | bdiouxX       | Add a leading plus sign to non-negative\n         | aAeEfgG       | numbers.\n         | (numeric fmt) | For o, x, X, b, use\n         |               | a minus sign with absolute value for\n         |               | negative values.\n---------+---------------+--------------------------------------------\n-        | all           | Left-justify the result of this conversion.\n---------+---------------+--------------------------------------------\n0 (zero) | bdiouxX       | Pad with zeros, not spaces.\n         | aAeEfgG       | For o, x, X, b, radix-1\n         | (numeric fmt) | is used for negative numbers formatted as\n         |               | complements.\n```\n\nExamples of flags:\n\nDecimal number conversion\n```\nsprintf \"%d\", 123  # => \"123\"\nsprintf \"%+d\", 123 # => \"+123\"\nsprintf \"% d\", 123 # => \" 123\"\n```\n\nOctal number conversion\n```\nsprintf \"%o\", 123   # => \"173\"\nsprintf \"%+o\", 123  # => \"+173\"\nsprintf \"%o\", -123  # => \"-173\"\nsprintf \"%+o\", -123 # => \"-173\"\n```\n\nHexadecimal number conversion\n```\nsprintf \"%x\", 123   # => \"7b\"\nsprintf \"%+x\", 123  # => \"+7b\"\nsprintf \"%x\", -123  # => \"-7b\"\nsprintf \"%+x\", -123 # => \"-7b\"\nsprintf \"%#x\", 0    # => \"0\"\nsprintf \"% x\", 123  # => \" 7b\"\nsprintf \"% x\", -123 # => \"-7b\"\nsprintf \"%X\", 123   # => \"7B\"\nsprintf \"%#X\", -123 # => \"-7B\"\n```\n\nBinary number conversion\n```\nsprintf \"%b\", 123    # => \"1111011\"\nsprintf \"%+b\", 123   # => \"+1111011\"\nsprintf \"%+b\", -123  # => \"-1111011\"\nsprintf \"%b\", -123   # => \"-1111011\"\nsprintf \"%#b\", 0     # => \"0\"\nsprintf \"% b\", 123   # => \" 1111011\"\nsprintf \"%+ b\", 123  # => \"+ 1111011\"\nsprintf \"% b\", -123  # => \"-1111011\"\nsprintf \"%+ b\", -123 # => \"-1111011\"\n```\n\nFloating point conversion\n```\nsprintf \"%a\", 123 # => \"0x1.ecp+6\"\nsprintf \"%A\", 123 # => \"0X1.ECP+6\"\n```\n\nExponential form conversion\n```\nsprintf \"%g\", 123.4          # => \"123.4\"\nsprintf \"%g\", 123.4567       # => \"123.457\"\nsprintf \"%20.8g\", 1234.56789 # => \"           1234.5679\"\nsprintf \"%20.8g\", 123456789  # => \"       1.2345679e+08\"\nsprintf \"%20.8G\", 123456789  # => \"       1.2345679E+08\"\nsprintf \"%20.8g\", -123456789 # => \"      -1.2345679e+08\"\nsprintf \"%20.8G\", -123456789 # => \"      -1.2345679E+08\"\n```\n\nThe field width is an optional integer, followed optionally by a\nperiod and a precision. The width specifies the minimum number of\ncharacters that will be written to the result for this field.\n\nExamples of width:\n```\nsprintf \"%20d\", 123   # => \"                 123\"\nsprintf \"%+20d\", 123  # => \"                +123\"\nsprintf \"%020d\", 123  # => \"00000000000000000123\"\nsprintf \"%+020d\", 123 # => \"+0000000000000000123\"\nsprintf \"% 020d\", 123 # => \" 0000000000000000123\"\nsprintf \"%-20d\", 123  # => \"123                 \"\nsprintf \"%-+20d\", 123 # => \"+123                \"\nsprintf \"%- 20d\", 123 # => \" 123                \"\nsprintf \"%020x\", -123 # => \"00000000000000000-7b\"\nsprintf \"%020X\", -123 # => \"00000000000000000-7B\"\n```\n\nFor numeric fields, the precision controls the number of decimal places\ndisplayed.\n\nFor string fields, the precision determines the maximum\nnumber of characters to be copied from the string.\n\nExamples of precisions:\n\nPrecision for `d`, `o`, `x` and `b` is\nminimum number of digits\n```\nsprintf \"%20.8d\", 123   # => \"                 123\"\nsprintf \"%020.8d\", 123  # => \"00000000000000000123\"\nsprintf \"%20.8o\", 123   # => \"                 173\"\nsprintf \"%020.8o\", 123  # => \"00000000000000000173\"\nsprintf \"%20.8x\", 123   # => \"                  7b\"\nsprintf \"%020.8x\", 123  # => \"0000000000000000007b\"\nsprintf \"%20.8b\", 123   # => \"             1111011\"\nsprintf \"%20.8d\", -123  # => \"                -123\"\nsprintf \"%020.8d\", -123 # => \"0000000000000000-123\"\nsprintf \"%20.8o\", -123  # => \"                -173\"\nsprintf \"%20.8x\", -123  # => \"                 -7b\"\nsprintf \"%20.8b\", -11   # => \"               -1011\"\n```\n\nPrecision for `e` is number of digits after the decimal point.\n```\nsprintf \"%20.8e\", 1234.56789 # => \"      1.23456789e+03\"\n```\n\nPrecision for `f` is number of digits after the decimal point.\n```\nsprintf \"%20.8f\", 1234.56789 # => \"       1234.56789000\"\n```\n\nPrecision for `g` is number of significant digits.\n```\nsprintf \"%20.8g\", 1234.56789 # => \"           1234.5679\"\nsprintf \"%20.8g\", 123456789  # => \"       1.2345679e+08\"\nsprintf \"%-20.8g\", 123456789 # => \"1.2345679e+08       \"\n```\n\nPrecision for `s` is maximum number of characters.\n```\nsprintf \"%20.8s\", \"string test\" # => \"            string t\"\n```\n\nAdditional examples:\n```\nsprintf \"%d %04x\", 123, 123             # => \"123 007b\"\nsprintf \"%08b '%4s'\", 123, 123          # => \"01111011 ' 123'\"\nsprintf \"%+g:% g:%-g\", 1.23, 1.23, 1.23 # => \"+1.23: 1.23:1.23\"\n```","summary":"<p>Returns a formatted string.</p>","abstract":false,"args":[{"name":"format_string","doc":null,"default_value":"","external_name":"format_string","restriction":""},{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":"Array | Tuple"}],"args_string":"(format_string, args : Array | Tuple) : String","source_link":null,"def":{"name":"sprintf","args":[{"name":"format_string","doc":null,"default_value":"","external_name":"format_string","restriction":""},{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":"Array | Tuple"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"String.build(format_string.bytesize) do |str|\n  (String::Formatter(typeof(args)).new(format_string, args, str)).format\nend"}},{"id":"sprintf(format_string,*args):String-class-method","html_id":"sprintf(format_string,*args):String-class-method","name":"sprintf","doc":"Returns a formatted string.\nThe string is produced according to the *format_string* with format specifiers\nbeing replaced by values from *args* formatted according to the specifier.\n\nWithin the format string, any characters other than format specifiers\n(specifiers beginning with `%`) are copied to the result.\n\nThe syntax for a format specifier is:\n\n```text\n%[flags][width][.precision]type\n```\n\nA format specifier consists of a percent sign, followed by optional flags,\nwidth, and precision indicators, then terminated with a field type\ncharacter.\n\nThe field type controls how the corresponding\n`sprintf` argument is to be interpreted, while the flags\nmodify that interpretation.\n\nThe field type characters are:\n\n```text\nField | Integer Format\n------+------------------------------------------------------------------\n  b   | Formats argument as a binary number.\n  d   | Formats argument as a decimal number.\n  i   | Same as d.\n  o   | Formats argument as an octal number.\n  x   | Formats argument as a hexadecimal number using lowercase letters.\n  X   | Same as x, but uses uppercase letters.\n\nField | Float Format\n------+---------------------------------------------------------------\n  e   | Formats floating point argument into exponential notation\n      | with one digit before the decimal point as [-]d.dddddde[+-]dd.\n      | The precision specifies the number of digits after the decimal\n      | point (defaulting to six).\n  E   | Equivalent to e, but uses an uppercase E to indicate\n      | the exponent.\n  f   | Formats floating point argument as [-]ddd.dddddd,\n      | where the precision specifies the number of digits after\n      | the decimal point.\n  g   | Formats a floating point number using exponential form\n      | if the exponent is less than -4 or greater than or\n      | equal to the precision, or in dd.dddd form otherwise.\n      | The precision specifies the number of significant digits.\n  G   | Equivalent to g, but use an uppercase E in exponent form.\n  a   | Formats floating point argument as [-]0xh.hhhhp[+-]dd,\n      | which is consisted from optional sign, \"0x\", fraction part\n      | as hexadecimal, \"p\", and exponential part as decimal.\n  A   | Equivalent to a, but use uppercase X and P.\n\nField | Other Format\n------+------------------------------------------------------------\n  c   | Argument is a single character itself.\n  s   | Argument is a string to be substituted. If the format\n      | sequence contains a precision, at most that many characters\n      | will be copied.\n  %   | A percent sign itself will be displayed. No argument taken.\n```\nThe flags modifies the behavior of the formats.\nThe flag characters are:\n```text\nFlag     | Applies to    | Meaning\n---------+---------------+--------------------------------------------\nspace    | bdiouxX       | Add a leading space character to\n         | aAeEfgG       | non-negative numbers.\n         | (numeric fmt) | For o, x, X, b, use\n         |               | a minus sign with absolute value for\n         |               | negative values.\n---------+---------------+--------------------------------------------\n+        | bdiouxX       | Add a leading plus sign to non-negative\n         | aAeEfgG       | numbers.\n         | (numeric fmt) | For o, x, X, b, use\n         |               | a minus sign with absolute value for\n         |               | negative values.\n---------+---------------+--------------------------------------------\n-        | all           | Left-justify the result of this conversion.\n---------+---------------+--------------------------------------------\n0 (zero) | bdiouxX       | Pad with zeros, not spaces.\n         | aAeEfgG       | For o, x, X, b, radix-1\n         | (numeric fmt) | is used for negative numbers formatted as\n         |               | complements.\n```\n\nExamples of flags:\n\nDecimal number conversion\n```\nsprintf \"%d\", 123  # => \"123\"\nsprintf \"%+d\", 123 # => \"+123\"\nsprintf \"% d\", 123 # => \" 123\"\n```\n\nOctal number conversion\n```\nsprintf \"%o\", 123   # => \"173\"\nsprintf \"%+o\", 123  # => \"+173\"\nsprintf \"%o\", -123  # => \"-173\"\nsprintf \"%+o\", -123 # => \"-173\"\n```\n\nHexadecimal number conversion\n```\nsprintf \"%x\", 123   # => \"7b\"\nsprintf \"%+x\", 123  # => \"+7b\"\nsprintf \"%x\", -123  # => \"-7b\"\nsprintf \"%+x\", -123 # => \"-7b\"\nsprintf \"%#x\", 0    # => \"0\"\nsprintf \"% x\", 123  # => \" 7b\"\nsprintf \"% x\", -123 # => \"-7b\"\nsprintf \"%X\", 123   # => \"7B\"\nsprintf \"%#X\", -123 # => \"-7B\"\n```\n\nBinary number conversion\n```\nsprintf \"%b\", 123    # => \"1111011\"\nsprintf \"%+b\", 123   # => \"+1111011\"\nsprintf \"%+b\", -123  # => \"-1111011\"\nsprintf \"%b\", -123   # => \"-1111011\"\nsprintf \"%#b\", 0     # => \"0\"\nsprintf \"% b\", 123   # => \" 1111011\"\nsprintf \"%+ b\", 123  # => \"+ 1111011\"\nsprintf \"% b\", -123  # => \"-1111011\"\nsprintf \"%+ b\", -123 # => \"-1111011\"\n```\n\nFloating point conversion\n```\nsprintf \"%a\", 123 # => \"0x1.ecp+6\"\nsprintf \"%A\", 123 # => \"0X1.ECP+6\"\n```\n\nExponential form conversion\n```\nsprintf \"%g\", 123.4          # => \"123.4\"\nsprintf \"%g\", 123.4567       # => \"123.457\"\nsprintf \"%20.8g\", 1234.56789 # => \"           1234.5679\"\nsprintf \"%20.8g\", 123456789  # => \"       1.2345679e+08\"\nsprintf \"%20.8G\", 123456789  # => \"       1.2345679E+08\"\nsprintf \"%20.8g\", -123456789 # => \"      -1.2345679e+08\"\nsprintf \"%20.8G\", -123456789 # => \"      -1.2345679E+08\"\n```\n\nThe field width is an optional integer, followed optionally by a\nperiod and a precision. The width specifies the minimum number of\ncharacters that will be written to the result for this field.\n\nExamples of width:\n```\nsprintf \"%20d\", 123   # => \"                 123\"\nsprintf \"%+20d\", 123  # => \"                +123\"\nsprintf \"%020d\", 123  # => \"00000000000000000123\"\nsprintf \"%+020d\", 123 # => \"+0000000000000000123\"\nsprintf \"% 020d\", 123 # => \" 0000000000000000123\"\nsprintf \"%-20d\", 123  # => \"123                 \"\nsprintf \"%-+20d\", 123 # => \"+123                \"\nsprintf \"%- 20d\", 123 # => \" 123                \"\nsprintf \"%020x\", -123 # => \"00000000000000000-7b\"\nsprintf \"%020X\", -123 # => \"00000000000000000-7B\"\n```\n\nFor numeric fields, the precision controls the number of decimal places\ndisplayed.\n\nFor string fields, the precision determines the maximum\nnumber of characters to be copied from the string.\n\nExamples of precisions:\n\nPrecision for `d`, `o`, `x` and `b` is\nminimum number of digits\n```\nsprintf \"%20.8d\", 123   # => \"                 123\"\nsprintf \"%020.8d\", 123  # => \"00000000000000000123\"\nsprintf \"%20.8o\", 123   # => \"                 173\"\nsprintf \"%020.8o\", 123  # => \"00000000000000000173\"\nsprintf \"%20.8x\", 123   # => \"                  7b\"\nsprintf \"%020.8x\", 123  # => \"0000000000000000007b\"\nsprintf \"%20.8b\", 123   # => \"             1111011\"\nsprintf \"%20.8d\", -123  # => \"                -123\"\nsprintf \"%020.8d\", -123 # => \"0000000000000000-123\"\nsprintf \"%20.8o\", -123  # => \"                -173\"\nsprintf \"%20.8x\", -123  # => \"                 -7b\"\nsprintf \"%20.8b\", -11   # => \"               -1011\"\n```\n\nPrecision for `e` is number of digits after the decimal point.\n```\nsprintf \"%20.8e\", 1234.56789 # => \"      1.23456789e+03\"\n```\n\nPrecision for `f` is number of digits after the decimal point.\n```\nsprintf \"%20.8f\", 1234.56789 # => \"       1234.56789000\"\n```\n\nPrecision for `g` is number of significant digits.\n```\nsprintf \"%20.8g\", 1234.56789 # => \"           1234.5679\"\nsprintf \"%20.8g\", 123456789  # => \"       1.2345679e+08\"\nsprintf \"%-20.8g\", 123456789 # => \"1.2345679e+08       \"\n```\n\nPrecision for `s` is maximum number of characters.\n```\nsprintf \"%20.8s\", \"string test\" # => \"            string t\"\n```\n\nAdditional examples:\n```\nsprintf \"%d %04x\", 123, 123             # => \"123 007b\"\nsprintf \"%08b '%4s'\", 123, 123          # => \"01111011 ' 123'\"\nsprintf \"%+g:% g:%-g\", 1.23, 1.23, 1.23 # => \"+1.23: 1.23:1.23\"\n```","summary":"<p>Returns a formatted string.</p>","abstract":false,"args":[{"name":"format_string","doc":null,"default_value":"","external_name":"format_string","restriction":""},{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(format_string, *args) : String","source_link":null,"def":{"name":"sprintf","args":[{"name":"format_string","doc":null,"default_value":"","external_name":"format_string","restriction":""},{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":null,"splat_index":1,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"sprintf(format_string, args)"}},{"id":"system(command:String,args=nil):Bool-class-method","html_id":"system(command:String,args=nil):Bool-class-method","name":"system","doc":"Executes the given command in a subshell.\nStandard input, output and error are inherited.\nReturns `true` if the command gives zero exit code, `false` otherwise.\nThe special `$?` variable is set to a `Process::Status` associated with this execution.\n\nIf *command* contains no spaces and *args* is given, it will become\nits argument list.\n\nIf *command* contains spaces and *args* is given, *command* must include\n`\"${@}\"` (including the quotes) to receive the argument list.\n\nNo shell interpretation is done in *args*.\n\nExample:\n\n```\nsystem(\"echo *\")\n```\n\nProduces:\n\n```text\nLICENSE shard.yml Readme.md spec src\n```","summary":"<p>Executes the given command in a subshell.</p>","abstract":false,"args":[{"name":"command","doc":null,"default_value":"","external_name":"command","restriction":"String"},{"name":"args","doc":null,"default_value":"nil","external_name":"args","restriction":""}],"args_string":"(command : String, args = <span class=\"n\">nil</span>) : Bool","source_link":null,"def":{"name":"system","args":[{"name":"command","doc":null,"default_value":"","external_name":"command","restriction":"String"},{"name":"args","doc":null,"default_value":"nil","external_name":"args","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"status = Process.run(command, args, shell: true, input: Process::Redirect::Inherit, output: Process::Redirect::Inherit, error: Process::Redirect::Inherit)\n$? = status\nstatus.success?\n"}},{"id":"with_color(color:Symbol)-class-method","html_id":"with_color(color:Symbol)-class-method","name":"with_color","doc":null,"summary":null,"abstract":false,"args":[{"name":"color","doc":null,"default_value":"","external_name":"color","restriction":"Symbol"}],"args_string":"(color : Symbol)","source_link":null,"def":{"name":"with_color","args":[{"name":"color","doc":null,"default_value":"","external_name":"color","restriction":"Symbol"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"\"\".colorize(color)"}},{"id":"with_color-class-method","html_id":"with_color-class-method","name":"with_color","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"with_color","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"\"\".colorize"}}],"constructors":[],"instance_methods":[],"macros":[{"id":"assert_responds_to(var,method)-macro","html_id":"assert_responds_to(var,method)-macro","name":"assert_responds_to","doc":null,"summary":null,"abstract":false,"args":[{"name":"var","doc":null,"default_value":"","external_name":"var","restriction":""},{"name":"method","doc":null,"default_value":"","external_name":"method","restriction":""}],"args_string":"(var, method)","source_link":null,"def":{"name":"assert_responds_to","args":[{"name":"var","doc":null,"default_value":"","external_name":"var","restriction":""},{"name":"method","doc":null,"default_value":"","external_name":"method","restriction":""}],"double_splat":null,"splat_index":null,"block_arg":null,"visibility":"Public","body":"  if \n{{ var }}\n.responds_to?(:\n{{ method }}\n)\n    \n{{ var }}\n\n  \nelse\n    raise \"Expected \n{{ var }}\n to respond to :\n{{ method }}\n, not #{ \n{{ var }}\n }\"\n  \nend\n\n"}},{"id":"debugger-macro","html_id":"debugger-macro","name":"debugger","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"debugger","args":[],"double_splat":null,"splat_index":null,"block_arg":null,"visibility":"Public","body":"  Intrinsics.debugtrap\n"}},{"id":"p!(*exps)-macro","html_id":"p!(*exps)-macro","name":"p!","doc":"Prints a series of expressions together with their inspected values.\nUseful for print style debugging.\n\n```\na = 1\np! a # => \"a # => 1\"\n\np! [1, 2, 3].map(&.to_s) # => \"[1, 2, 3].map(&.to_s) # => [\"1\", \"2\", \"3\"]\"\n```\n\nSee also: `p`, `Object#inspect`.","summary":"<p>Prints a series of expressions together with their inspected values.</p>","abstract":false,"args":[{"name":"exps","doc":null,"default_value":"","external_name":"exps","restriction":""}],"args_string":"(*exps)","source_link":null,"def":{"name":"p!","args":[{"name":"exps","doc":null,"default_value":"","external_name":"exps","restriction":""}],"double_splat":null,"splat_index":0,"block_arg":null,"visibility":"Public","body":"  \n{% if exps.size == 0 %}\n    # Nothing\n  {% else %}{% if exps.size == 1 %}\n    {% exp = exps.first %}\n    %prefix = \"#{{{ exp.stringify }}} # => \"\n    ::print %prefix\n    ::p({{ exp }})\n  {% else %}\n    %names = { {{ *exps.map(&.stringify) }} }\n    %max_size = %names.max_of &.size\n    {\n      {% for exp, i in exps %}\n        begin\n          %prefix = \"#{%names[{{ i }}].ljust(%max_size)} # => \"\n          ::print %prefix\n          ::p({{ exp }})\n        end,\n      {% end %}\n    }\n  {% end %}{% end %}\n\n\n"}},{"id":"parallel(*jobs)-macro","html_id":"parallel(*jobs)-macro","name":"parallel","doc":"Runs the commands passed as arguments concurrently (in Fibers) and waits\nfor them to finish.\n\n```\ndef say(word)\n  puts word\nend\n\n# Will print out the three words concurrently\nparallel(\n  say(\"concurrency\"),\n  say(\"is\"),\n  say(\"easy\")\n)\n```\n\nCan also be used to conveniently collect the return values of the\nconcurrent operations.\n\n```\ndef concurrent_job(word)\n  word\nend\n\na, b, c =\n  parallel(\n    concurrent_job(\"concurrency\"),\n    concurrent_job(\"is\"),\n    concurrent_job(\"easy\")\n  )\n\na # => \"concurrency\"\nb # => \"is\"\nc # => \"easy\"\n```\n\nDue to the concurrent nature of this macro, it is highly recommended\nto handle any exceptions within the concurrent calls. Unhandled\nexceptions raised within the concurrent operations will be re-raised\ninside the parent fiber as `ConcurrentExecutionException`, with the\n`cause` attribute set to the original exception.","summary":"<p>Runs the commands passed as arguments concurrently (in Fibers) and waits for them to finish.</p>","abstract":false,"args":[{"name":"jobs","doc":null,"default_value":"","external_name":"jobs","restriction":""}],"args_string":"(*jobs)","source_link":null,"def":{"name":"parallel","args":[{"name":"jobs","doc":null,"default_value":"","external_name":"jobs","restriction":""}],"double_splat":null,"splat_index":0,"block_arg":null,"visibility":"Public","body":"  \n%channel\n = Channel(Exception | Nil).new\n\n  \n{% for job, i in jobs %}\n    %ret{i} = uninitialized typeof({{ job }})\n    spawn do\n      begin\n        %ret{i} = {{ job }}\n      rescue e : Exception\n        %channel.send e\n      else\n        %channel.send nil\n      end\n    end\n  {% end %}\n\n\n  \n{{ jobs.size }}\n.times do\n    \n%value\n = \n%channel\n.receive\n    if \n%value\n.is_a?(Exception)\n      raise ConcurrentExecutionException.new(\n        \"An unhandled error occurred inside a `parallel` call\",\n        cause: \n%value\n\n      )\n    \nend\n  \nend\n\n  \n{\n    \n{% for job, i in jobs %}\n      %ret{i},\n    {% end %}\n\n  }\n\n"}},{"id":"pp!(*exps)-macro","html_id":"pp!(*exps)-macro","name":"pp!","doc":"Prints a series of expressions together with their pretty printed values.\nUseful for print style debugging.\n\n```\na = 1\npp! a # => \"a # => 1\"\n\npp! [1, 2, 3].map(&.to_s) # => \"[1, 2, 3].map(&.to_s) # => [\"1\", \"2\", \"3\"]\"\n```\n\nSee also: `pp`, `Object#pretty_inspect`.","summary":"<p>Prints a series of expressions together with their pretty printed values.</p>","abstract":false,"args":[{"name":"exps","doc":null,"default_value":"","external_name":"exps","restriction":""}],"args_string":"(*exps)","source_link":null,"def":{"name":"pp!","args":[{"name":"exps","doc":null,"default_value":"","external_name":"exps","restriction":""}],"double_splat":null,"splat_index":0,"block_arg":null,"visibility":"Public","body":"  \n{% if exps.size == 0 %}\n    # Nothing\n  {% else %}{% if exps.size == 1 %}\n    {% exp = exps.first %}\n    %prefix = \"#{{{ exp.stringify }}} # => \"\n    ::print %prefix\n    ::pp({{ exp }})\n  {% else %}\n    %names = { {{ *exps.map(&.stringify) }} }\n    %max_size = %names.max_of &.size\n    {\n      {% for exp, i in exps %}\n        begin\n          %prefix = \"#{%names[{{ i }}].ljust(%max_size)} # => \"\n          ::print %prefix\n          ::pp({{ exp }})\n        end,\n      {% end %}\n    }\n  {% end %}{% end %}\n\n\n"}},{"id":"record(name,*properties)-macro","html_id":"record(name,*properties)-macro","name":"record","doc":"Defines a **`Struct`** with the given name and properties.\n\nThe generated struct has a constructor with the given properties\nin the same order as declared. The struct only provides getters,\nnot setters, making it immutable by default.\n\nThe properties can be type declarations or assignments.\n\nYou can pass a block to this macro, that will be inserted inside\nthe struct definition.\n\n```\nrecord Point, x : Int32, y : Int32\n\nPoint.new 1, 2 # => #<Point(@x=1, @y=2)>\n```\n\nAn example with the block version:\n\n```\nrecord Person, first_name : String, last_name : String do\n  def full_name\n    \"#{first_name} #{last_name}\"\n  end\nend\n\nperson = Person.new \"John\", \"Doe\"\nperson.full_name # => \"John Doe\"\n```\n\nAn example with type declarations and default values:\n\n```\nrecord Point, x : Int32 = 0, y : Int32 = 0\n\nPoint.new      # => #<Point(@x=0, @y=0)>\nPoint.new y: 2 # => #<Point(@x=0, @y=2)>\n```\n\nAn example with assignments (in this case the compiler must be able to\ninfer the types from the default values):\n\n```\nrecord Point, x = 0, y = 0\n\nPoint.new      # => #<Point(@x=0, @y=0)>\nPoint.new y: 2 # => #<Point(@x=0, @y=2)>\n```\n\nThis macro also provides a `copy_with` method which returns\na copy of the record with the provided properties altered.\n\n```\nrecord Point, x = 0, y = 0\n\np = Point.new y: 2 # => #<Point(@x=0, @y=2)>\np.copy_with x: 3   # => #<Point(@x=3, @y=2)>\np                  # => #<Point(@x=0, @y=2)>\n```","summary":"<p>Defines a <strong><code><a href=\"Struct.html\">Struct</a></code></strong> with the given name and properties.</p>","abstract":false,"args":[{"name":"name","doc":null,"default_value":"","external_name":"name","restriction":""},{"name":"properties","doc":null,"default_value":"","external_name":"properties","restriction":""}],"args_string":"(name, *properties)","source_link":null,"def":{"name":"record","args":[{"name":"name","doc":null,"default_value":"","external_name":"name","restriction":""},{"name":"properties","doc":null,"default_value":"","external_name":"properties","restriction":""}],"double_splat":null,"splat_index":1,"block_arg":null,"visibility":"Public","body":"  struct \n{{ name.id }}\n\n    \n{% for property in properties %}\n      {% if property.is_a?(Assign) %}\n        getter {{ property.target.id }}\n      {% else %}{% if property.is_a?(TypeDeclaration) %}\n        getter {{ property.var }} : {{ property.type }}\n      {% else %}\n        getter :{{ property.id }}\n      {% end %}{% end %}\n    {% end %}\n\n\n    def initialize(\n{{ *properties.map do |field|\n  \"@#{field.id}\".id\nend }}\n)\n    \nend\n\n    \n{{ yield }}\n\n\n    def copy_with(\n{{ *properties.map do |property|\n  if property.is_a?(Assign)\n    \"#{property.target.id} _#{property.target.id} = @#{property.target.id}\".id\n  else\n    if property.is_a?(TypeDeclaration)\n      \"#{property.var.id} _#{property.var.id} = @#{property.var.id}\".id\n    else\n      \"#{property.id} _#{property.id} = @#{property.id}\".id\n    end\n  end\nend }}\n)\n      self.class.new(\n{{ *properties.map do |property|\n  if property.is_a?(Assign)\n    \"_#{property.target.id}\".id\n  else\n    if property.is_a?(TypeDeclaration)\n      \"_#{property.var.id}\".id\n    else\n      \"_#{property.id}\".id\n    end\n  end\nend }}\n)\n    \nend\n\n    def clone\n      self.class.new(\n{{ *properties.map do |property|\n  if property.is_a?(Assign)\n    \"@#{property.target.id}.clone\".id\n  else\n    if property.is_a?(TypeDeclaration)\n      \"@#{property.var.id}.clone\".id\n    else\n      \"@#{property.id}.clone\".id\n    end\n  end\nend }}\n)\n    \nend\n  \nend\n\n"}},{"id":"spawn(call,*,name=nil,same_thread=false,&block)-macro","html_id":"spawn(call,*,name=nil,same_thread=false,&amp;block)-macro","name":"spawn","doc":"Spawns a fiber by first creating a `Proc`, passing the *call*'s\nexpressions to it, and letting the `Proc` finally invoke the *call*.\n\nCompare this:\n\n```\ni = 0\nwhile i < 5\n  spawn { print(i) }\n  i += 1\nend\nFiber.yield\n# Output: 55555\n```\n\nTo this:\n\n```\ni = 0\nwhile i < 5\n  spawn print(i)\n  i += 1\nend\nFiber.yield\n# Output: 01234\n```\n\nThis is because in the first case all spawned fibers refer to\nthe same local variable, while in the second example copies of\n*i* are passed to a `Proc` that eventually invokes the call.","summary":"<p>Spawns a fiber by first creating a <code><a href=\"Proc.html\">Proc</a></code>, passing the <em>call</em>'s expressions to it, and letting the <code><a href=\"Proc.html\">Proc</a></code> finally invoke the <em>call</em>.</p>","abstract":false,"args":[{"name":"call","doc":null,"default_value":"","external_name":"call","restriction":""},{"name":"","doc":null,"default_value":"","external_name":"","restriction":""},{"name":"name","doc":null,"default_value":"nil","external_name":"name","restriction":""},{"name":"same_thread","doc":null,"default_value":"false","external_name":"same_thread","restriction":""}],"args_string":"(call, *, name = <span class=\"n\">nil</span>, same_thread = <span class=\"n\">false</span>, &block)","source_link":null,"def":{"name":"spawn","args":[{"name":"call","doc":null,"default_value":"","external_name":"call","restriction":""},{"name":"","doc":null,"default_value":"","external_name":"","restriction":""},{"name":"name","doc":null,"default_value":"nil","external_name":"name","restriction":""},{"name":"same_thread","doc":null,"default_value":"false","external_name":"same_thread","restriction":""}],"double_splat":null,"splat_index":1,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":""},"visibility":"Public","body":"  \n{% if block %}\n    {% raise(\"`spawn(call)` can't be invoked with a block, did you mean `spawn(name: ...) { ... }`?\") %}\n  {% end %}\n\n\n  \n{% if call.is_a?(Call) %}\n    ->(\n      {% for arg, i in call.args %}\n        __arg{{ i }} : typeof({{ arg }}),\n      {% end %}\n      {% if call.named_args %}\n        {% for narg, i in call.named_args %}\n          __narg{{ i }} : typeof({{ narg.value }}),\n        {% end %}\n      {% end %}\n      ) {\n      spawn(name: {{ name }}, same_thread: {{ same_thread }}) do\n        {% if call.receiver %}{{ call.receiver }}.{% end %}{{ call.name }}(\n          {% for arg, i in call.args %}\n            __arg{{ i }},\n          {% end %}\n          {% if call.named_args %}\n            {% for narg, i in call.named_args %}\n              {{ narg.name }}: __narg{{ i }},\n            {% end %}\n          {% end %}\n        )\n      end\n    {% if call.named_args %}\n      }.call({{ *call.args }}, {{ *call.named_args.map(&.value) }})\n    {% else %}\n      }.call({{ *call.args }})\n    {% end %}\n  {% else %}\n    spawn do\n      {{ call }}\n    end\n  {% end %}\n\n\n"}}],"types":[{"html_id":"/Adler32","path":"Adler32.html","kind":"module","full_name":"Adler32","name":"Adler32","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":null,"summary":null,"class_methods":[{"id":"checksum(data):UInt32-class-method","html_id":"checksum(data):UInt32-class-method","name":"checksum","doc":null,"summary":null,"abstract":false,"args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""}],"args_string":"(data) : UInt32","source_link":null,"def":{"name":"checksum","args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"UInt32","visibility":"Public","body":"update(data, initial)"}},{"id":"combine(adler1:UInt32,adler2:UInt32,len):UInt32-class-method","html_id":"combine(adler1:UInt32,adler2:UInt32,len):UInt32-class-method","name":"combine","doc":null,"summary":null,"abstract":false,"args":[{"name":"adler1","doc":null,"default_value":"","external_name":"adler1","restriction":"UInt32"},{"name":"adler2","doc":null,"default_value":"","external_name":"adler2","restriction":"UInt32"},{"name":"len","doc":null,"default_value":"","external_name":"len","restriction":""}],"args_string":"(adler1 : UInt32, adler2 : UInt32, len) : UInt32","source_link":null,"def":{"name":"combine","args":[{"name":"adler1","doc":null,"default_value":"","external_name":"adler1","restriction":"UInt32"},{"name":"adler2","doc":null,"default_value":"","external_name":"adler2","restriction":"UInt32"},{"name":"len","doc":null,"default_value":"","external_name":"len","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"UInt32","visibility":"Public","body":"(LibZ.adler32_combine(adler1, adler2, len)).to_u32"}},{"id":"initial:UInt32-class-method","html_id":"initial:UInt32-class-method","name":"initial","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : UInt32","source_link":null,"def":{"name":"initial","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"UInt32","visibility":"Public","body":"(LibZ.adler32(0, nil, 0)).to_u32"}},{"id":"update(data,adler32:UInt32):UInt32-class-method","html_id":"update(data,adler32:UInt32):UInt32-class-method","name":"update","doc":null,"summary":null,"abstract":false,"args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""},{"name":"adler32","doc":null,"default_value":"","external_name":"adler32","restriction":"UInt32"}],"args_string":"(data, adler32 : UInt32) : UInt32","source_link":null,"def":{"name":"update","args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""},{"name":"adler32","doc":null,"default_value":"","external_name":"adler32","restriction":"UInt32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"UInt32","visibility":"Public","body":"slice = data.to_slice\n(LibZ.adler32(adler32, slice, slice.size)).to_u32\n"}}],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"/ArgumentError","path":"ArgumentError.html","kind":"class","full_name":"ArgumentError","name":"ArgumentError","abstract":false,"superclass":{"html_id":"/Exception","kind":"class","full_name":"Exception","name":"Exception"},"ancestors":[{"html_id":"/Exception","kind":"class","full_name":"Exception","name":"Exception"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"Raised when the arguments are wrong and there isn't a more specific `Exception` class.\n\n```\n[1, 2, 3].first(-4) # raises ArgumentError (attempt to take negative size)\n```","summary":"<p>Raised when the arguments are wrong and there isn't a more specific <code><a href=\"Exception.html\">Exception</a></code> class.</p>","class_methods":[],"constructors":[{"id":"new(message=&quot;Argumenterror&quot;)-class-method","html_id":"new(message=&amp;quot;Argumenterror&amp;quot;)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"message","doc":null,"default_value":"\"Argument error\"","external_name":"message","restriction":""}],"args_string":"(message = <span class=\"s\">&quot;Argument error&quot;</span>)","source_link":null,"def":{"name":"new","args":[{"name":"message","doc":null,"default_value":"\"Argument error\"","external_name":"message","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(message)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[],"macros":[],"types":[]},{"html_id":"/Array","path":"Array.html","kind":"class","full_name":"Array(T)","name":"Array","abstract":false,"superclass":{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Indexable","kind":"module","full_name":"Indexable","name":"Indexable"},{"html_id":"/Enumerable","kind":"module","full_name":"Enumerable","name":"Enumerable"},{"html_id":"/Iterable","kind":"module","full_name":"Iterable","name":"Iterable"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Indexable","kind":"module","full_name":"Indexable","name":"Indexable"}],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"An `Array` is an ordered, integer-indexed collection of objects of type T.\n\nArray indexing starts at 0. A negative index is assumed to be\nrelative to the end of the array: -1 indicates the last element,\n-2 is the next to last element, and so on.\n\nAn `Array` can be created using the usual `new` method (several are provided), or with an array literal:\n\n```\nArray(Int32).new  # => []\n[1, 2, 3]         # Array(Int32)\n[1, \"hello\", 'x'] # Array(Int32 | String | Char)\n```\n\nAn `Array` can have mixed types, meaning T will be a union of types, but these are determined\nwhen the array is created, either by specifying T or by using an array literal. In the latter\ncase, T will be set to the union of the array literal elements' types.\n\nWhen creating an empty array you must always specify T:\n\n```\n[] of Int32 # same as Array(Int32)\n[]          # syntax error\n```\n\nAn `Array` is implemented using an internal buffer of some capacity\nand is reallocated when elements are pushed to it when more capacity\nis needed. This is normally known as a [dynamic array](http://en.wikipedia.org/wiki/Dynamic_array).\n\nYou can use a special array literal syntax with other types too, as long as they define an argless\n`new` method and a `<<` method. `Set` is one such type:\n\n```\nset = Set{1, 2, 3} # => Set{1, 2, 3}\nset.class          # => Set(Int32)\n```\n\nThe above is the same as this:\n\n```\nset = Set(typeof(1, 2, 3)).new\nset << 1\nset << 2\nset << 3\n```","summary":"<p>An <code><a href=\"Array.html\">Array</a></code> is an ordered, integer-indexed collection of objects of type T.</p>","class_methods":[{"id":"each_product(arrays:Array(Array),reuse=false,&block)-class-method","html_id":"each_product(arrays:Array(Array),reuse=false,&amp;block)-class-method","name":"each_product","doc":null,"summary":null,"abstract":false,"args":[{"name":"arrays","doc":null,"default_value":"","external_name":"arrays","restriction":"Array(Array)"},{"name":"reuse","doc":null,"default_value":"false","external_name":"reuse","restriction":""}],"args_string":"(arrays : Array(Array), reuse = <span class=\"n\">false</span>, &block)","source_link":null,"def":{"name":"each_product","args":[{"name":"arrays","doc":null,"default_value":"","external_name":"arrays","restriction":"Array(Array)"},{"name":"reuse","doc":null,"default_value":"false","external_name":"reuse","restriction":""}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"lens = arrays.map(&.size)\nif lens.any?(&.==(0))\n  return\nend\npool = arrays.map(&.first)\nn = arrays.size\nindices = Array.new(n, 0)\nif reuse\n  if reuse.is_a?(Array)\n  else\n    reuse = (typeof(pool)).new(n)\n  end\nelse\n  reuse = nil\nend\nyield pool_slice(pool, n, reuse)\nwhile true\n  i = n - 1\n  __temp_9 = i\n  indices[__temp_9] = indices[__temp_9] + 1\n  while indices[i] >= lens[i]\n    indices[i] = 0\n    pool[i] = arrays[i][indices[i]]\n    i = i - 1\n    if i < 0\n      return\n    end\n    __temp_11 = i\n    indices[__temp_11] = indices[__temp_11] + 1\n  end\n  pool[i] = arrays[i][indices[i]]\n  yield pool_slice(pool, n, reuse)\nend\n"}},{"id":"each_product(*arrays:Array,reuse=false,&block)-class-method","html_id":"each_product(*arrays:Array,reuse=false,&amp;block)-class-method","name":"each_product","doc":null,"summary":null,"abstract":false,"args":[{"name":"arrays","doc":null,"default_value":"","external_name":"arrays","restriction":"Array"},{"name":"reuse","doc":null,"default_value":"false","external_name":"reuse","restriction":""}],"args_string":"(*arrays : Array, reuse = <span class=\"n\">false</span>, &block)","source_link":null,"def":{"name":"each_product","args":[{"name":"arrays","doc":null,"default_value":"","external_name":"arrays","restriction":"Array"},{"name":"reuse","doc":null,"default_value":"false","external_name":"reuse","restriction":""}],"double_splat":null,"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"each_product(arrays.to_a, reuse: reuse) do |result|\n  yield result\nend"}},{"id":"from_json(string_or_io,&block):Nil-class-method","html_id":"from_json(string_or_io,&amp;block):Nil-class-method","name":"from_json","doc":"Parses a `String` or `IO` denoting a JSON array, yielding\neach of its elements to the given block. This is useful\nfor decoding an array and processing its elements without\ncreating an Array in memory, which might be expensive.\n\n```\nrequire \"json\"\n\nArray(Int32).from_json(\"[1, 2, 3]\") do |element|\n  puts element\nend\n```\n\nOutput:\n\n```text\n1\n2\n3\n```\n\nTo parse and get an `Array`, use the block-less overload.","summary":"<p>Parses a <code><a href=\"String.html\">String</a></code> or <code><a href=\"IO.html\">IO</a></code> denoting a JSON array, yielding each of its elements to the given block.</p>","abstract":false,"args":[{"name":"string_or_io","doc":null,"default_value":"","external_name":"string_or_io","restriction":""}],"args_string":"(string_or_io, &block) : Nil","source_link":null,"def":{"name":"from_json","args":[{"name":"string_or_io","doc":null,"default_value":"","external_name":"string_or_io","restriction":""}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"parser = JSON::PullParser.new(string_or_io)\nnew(parser) do |element|\n  yield element\nend\nnil\n"}},{"id":"from_yaml(string_or_io:String|IO,&block)-class-method","html_id":"from_yaml(string_or_io:String|IO,&amp;block)-class-method","name":"from_yaml","doc":null,"summary":null,"abstract":false,"args":[{"name":"string_or_io","doc":null,"default_value":"","external_name":"string_or_io","restriction":"String | IO"}],"args_string":"(string_or_io : String | IO, &block)","source_link":null,"def":{"name":"from_yaml","args":[{"name":"string_or_io","doc":null,"default_value":"","external_name":"string_or_io","restriction":"String | IO"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"new(YAML::ParseContext.new, parse_yaml(string_or_io)) do |element|\n  yield element\nend"}},{"id":"product(arrays)-class-method","html_id":"product(arrays)-class-method","name":"product","doc":null,"summary":null,"abstract":false,"args":[{"name":"arrays","doc":null,"default_value":"","external_name":"arrays","restriction":""}],"args_string":"(arrays)","source_link":null,"def":{"name":"product","args":[{"name":"arrays","doc":null,"default_value":"","external_name":"arrays","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"result = [] of Array(typeof(arrays.first.first))\neach_product(arrays) do |product|\n  result << product\nend\nresult\n"}},{"id":"product(*arrays:Array)-class-method","html_id":"product(*arrays:Array)-class-method","name":"product","doc":null,"summary":null,"abstract":false,"args":[{"name":"arrays","doc":null,"default_value":"","external_name":"arrays","restriction":"Array"}],"args_string":"(*arrays : Array)","source_link":null,"def":{"name":"product","args":[{"name":"arrays","doc":null,"default_value":"","external_name":"arrays","restriction":"Array"}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"product(arrays.to_a)"}}],"constructors":[{"id":"build(capacity:Int,&block):self-class-method","html_id":"build(capacity:Int,&amp;block):self-class-method","name":"build","doc":"Creates a new `Array`, allocating an internal buffer with the given *capacity*,\nand yielding that buffer. The given block must return the desired size of the array.\n\nThis method is **unsafe**, but is usually used to initialize the buffer\nby passing it to a C function.\n\n```\nArray.build(3) do |buffer|\n  LibSome.fill_buffer_and_return_number_of_elements_filled(buffer)\nend\n```","summary":"<p>Creates a new <code><a href=\"Array.html\">Array</a></code>, allocating an internal buffer with the given <em>capacity</em>, and yielding that buffer.</p>","abstract":false,"args":[{"name":"capacity","doc":null,"default_value":"","external_name":"capacity","restriction":"Int"}],"args_string":"(capacity : Int, &block) : <span class=\"k\">self</span>","source_link":null,"def":{"name":"build","args":[{"name":"capacity","doc":null,"default_value":"","external_name":"capacity","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"self","visibility":"Public","body":"ary = Array(T).new(capacity)\nary.size = (yield ary.to_unsafe).to_i\nary\n"}},{"id":"new(size:Int,value:T)-class-method","html_id":"new(size:Int,value:T)-class-method","name":"new","doc":"Creates a new `Array` of the given *size* filled with the same *value* in each position.\n\n```\nArray.new(3, 'a') # => ['a', 'a', 'a']\n\nary = Array.new(3, [1])\nary # => [[1], [1], [1]]\nary[0][0] = 2\nary # => [[2], [2], [2]]\n```","summary":"<p>Creates a new <code><a href=\"Array.html\">Array</a></code> of the given <em>size</em> filled with the same <em>value</em> in each position.</p>","abstract":false,"args":[{"name":"size","doc":null,"default_value":"","external_name":"size","restriction":"Int"},{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(size : Int, value : T)","source_link":null,"def":{"name":"new","args":[{"name":"size","doc":null,"default_value":"","external_name":"size","restriction":"Int"},{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = Array(T).allocate\n_.initialize(size, value)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(ctx:YAML::ParseContext,node:YAML::Nodes::Node)-class-method","html_id":"new(ctx:YAML::ParseContext,node:YAML::Nodes::Node)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"ctx","doc":null,"default_value":"","external_name":"ctx","restriction":"YAML::ParseContext"},{"name":"node","doc":null,"default_value":"","external_name":"node","restriction":"YAML::Nodes::Node"}],"args_string":"(ctx : YAML::ParseContext, node : YAML::Nodes::Node)","source_link":null,"def":{"name":"new","args":[{"name":"ctx","doc":null,"default_value":"","external_name":"ctx","restriction":"YAML::ParseContext"},{"name":"node","doc":null,"default_value":"","external_name":"node","restriction":"YAML::Nodes::Node"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ctx.read_alias(node, self) do |obj|\n  return obj\nend\nary = new\nctx.record_anchor(node, ary)\nnew(ctx, node) do |element|\n  ary << element\nend\nary\n"}},{"id":"new(initial_capacity:Int)-class-method","html_id":"new(initial_capacity:Int)-class-method","name":"new","doc":"Creates a new empty `Array` backed by a buffer that is initially\n`initial_capacity` big.\n\nThe *initial_capacity* is useful to avoid unnecessary reallocations\nof the internal buffer in case of growth. If you have an estimate\nof the maximum number of elements an array will hold, the array should\nbe initialized with that capacity for improved performance.\n\n```\nary = Array(Int32).new(5)\nary.size # => 0\n```","summary":"<p>Creates a new empty <code><a href=\"Array.html\">Array</a></code> backed by a buffer that is initially <code>initial_capacity</code> big.</p>","abstract":false,"args":[{"name":"initial_capacity","doc":null,"default_value":"","external_name":"initial_capacity","restriction":"Int"}],"args_string":"(initial_capacity : Int)","source_link":null,"def":{"name":"new","args":[{"name":"initial_capacity","doc":null,"default_value":"","external_name":"initial_capacity","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = Array(T).allocate\n_.initialize(initial_capacity)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(pull:JSON::PullParser)-class-method","html_id":"new(pull:JSON::PullParser)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"pull","doc":null,"default_value":"","external_name":"pull","restriction":"JSON::PullParser"}],"args_string":"(pull : JSON::PullParser)","source_link":null,"def":{"name":"new","args":[{"name":"pull","doc":null,"default_value":"","external_name":"pull","restriction":"JSON::PullParser"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ary = new\nnew(pull) do |element|\n  ary << element\nend\nary\n"}},{"id":"new-class-method","html_id":"new-class-method","name":"new","doc":"Creates a new empty Array.","summary":"<p>Creates a new empty Array.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"new","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = Array(T).allocate\n_.initialize\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(ctx:YAML::ParseContext,node:YAML::Nodes::Node,&block)-class-method","html_id":"new(ctx:YAML::ParseContext,node:YAML::Nodes::Node,&amp;block)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"ctx","doc":null,"default_value":"","external_name":"ctx","restriction":"YAML::ParseContext"},{"name":"node","doc":null,"default_value":"","external_name":"node","restriction":"YAML::Nodes::Node"}],"args_string":"(ctx : YAML::ParseContext, node : YAML::Nodes::Node, &block)","source_link":null,"def":{"name":"new","args":[{"name":"ctx","doc":null,"default_value":"","external_name":"ctx","restriction":"YAML::ParseContext"},{"name":"node","doc":null,"default_value":"","external_name":"node","restriction":"YAML::Nodes::Node"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"if node.is_a?(YAML::Nodes::Sequence)\nelse\n  node.raise(\"Expected sequence, not #{node.class}\")\nend\nnode.each do |value|\n  yield T.new(ctx, value)\nend\n"}},{"id":"new(size:Int,&block:Int32->T)-class-method","html_id":"new(size:Int,&amp;block:Int32-&gt;T)-class-method","name":"new","doc":"Creates a new `Array` of the given *size* and invokes the given block once\nfor each index of `self`, assigning the block's value in that index.\n\n```\nArray.new(3) { |i| (i + 1) ** 2 } # => [1, 4, 9]\n\nary = Array.new(3) { [1] }\nary # => [[1], [1], [1]]\nary[0][0] = 2\nary # => [[2], [1], [1]]\n```","summary":"<p>Creates a new <code><a href=\"Array.html\">Array</a></code> of the given <em>size</em> and invokes the given block once for each index of <code>self</code>, assigning the block's value in that index.</p>","abstract":false,"args":[{"name":"size","doc":null,"default_value":"","external_name":"size","restriction":"Int"}],"args_string":"(size : Int, &block : Int32 -> T)","source_link":null,"def":{"name":"new","args":[{"name":"size","doc":null,"default_value":"","external_name":"size","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":"(Int32 -> T)"},"return_type":"","visibility":"Public","body":"Array(T).build(size) do |buffer|\n  size.to_i.times do |i|\n    buffer[i] = yield i\n  end\n  size\nend"}},{"id":"new(pull:JSON::PullParser,&block)-class-method","html_id":"new(pull:JSON::PullParser,&amp;block)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"pull","doc":null,"default_value":"","external_name":"pull","restriction":"JSON::PullParser"}],"args_string":"(pull : JSON::PullParser, &block)","source_link":null,"def":{"name":"new","args":[{"name":"pull","doc":null,"default_value":"","external_name":"pull","restriction":"JSON::PullParser"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"pull.read_array do\n  yield T.new(pull)\nend"}}],"instance_methods":[{"id":"&(other:Array(U))forallU-instance-method","html_id":"&amp;(other:Array(U))forallU-instance-method","name":"&","doc":"Set intersection: returns a new `Array` containing elements common to `self`\nand *other*, excluding any duplicates. The order is preserved from `self`.\n\n```\n[1, 1, 3, 5] & [1, 2, 3]               # => [ 1, 3 ]\n['a', 'b', 'b', 'z'] & ['a', 'b', 'c'] # => [ 'a', 'b' ]\n```\n\nSee also: `#uniq`.","summary":"<p>Set intersection: returns a new <code><a href=\"Array.html\">Array</a></code> containing elements common to <code>self</code> and <em>other</em>, excluding any duplicates.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array(U)"}],"args_string":"(other : Array(U)) forall U","source_link":null,"def":{"name":"&","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array(U)"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if self.empty? || other.empty?\n  return Array(T).new\nend\nif (self.size + other.size) <= (SMALL_ARRAY_SIZE * 2)\n  ary = Array(T).new\n  each do |elem|\n    if (!(ary.includes?(elem))) && (other.includes?(elem))\n      ary << elem\n    end\n  end\n  return ary\nend\nhash = other.to_lookup_hash\nhash_size = hash.size\nArray(T).build(Math.min(size, other.size)) do |buffer|\n  i = 0\n  each do |obj|\n    hash.delete(obj)\n    new_hash_size = hash.size\n    if hash_size != new_hash_size\n      hash_size = new_hash_size\n      buffer[i] = obj\n      i = i + 1\n    end\n  end\n  i\nend\n"}},{"id":"*(times:Int)-instance-method","html_id":"*(times:Int)-instance-method","name":"*","doc":"Repetition: Returns a new `Array` built by concatenating *times* copies of `self`.\n\n```\n[\"a\", \"b\", \"c\"] * 2 # => [ \"a\", \"b\", \"c\", \"a\", \"b\", \"c\" ]\n```","summary":"<p>Repetition: Returns a new <code><a href=\"Array.html\">Array</a></code> built by concatenating <em>times</em> copies of <code>self</code>.</p>","abstract":false,"args":[{"name":"times","doc":null,"default_value":"","external_name":"times","restriction":"Int"}],"args_string":"(times : Int)","source_link":null,"def":{"name":"*","args":[{"name":"times","doc":null,"default_value":"","external_name":"times","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if (times == 0) || empty?\n  return Array(T).new\nend\nif times == 1\n  return dup\nend\nif size == 1\n  return Array(T).new(times, first)\nend\nnew_size = size * times\nArray(T).build(new_size) do |buffer|\n  buffer.copy_from(to_unsafe, size)\n  n = size\n  while n <= (new_size // 2)\n    (buffer + n).copy_from(buffer, n)\n    n = n * 2\n  end\n  (buffer + n).copy_from(buffer, new_size - n)\n  new_size\nend\n"}},{"id":"+(other:Array(U))forallU-instance-method","html_id":"+(other:Array(U))forallU-instance-method","name":"+","doc":"Concatenation. Returns a new `Array` built by concatenating `self` and *other*.\nThe type of the new array is the union of the types of both the original arrays.\n\n```\n[1, 2] + [\"a\"]  # => [1,2,\"a\"] of (Int32 | String)\n[1, 2] + [2, 3] # => [1,2,2,3]\n```","summary":"<p>Concatenation.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array(U)"}],"args_string":"(other : Array(U)) forall U","source_link":null,"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array(U)"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"new_size = size + other.size\nArray(T | U).build(new_size) do |buffer|\n  buffer.copy_from(@buffer, size)\n  (buffer + size).copy_from(other.to_unsafe, other.size)\n  new_size\nend\n"}},{"id":"-(other:Array(U))forallU-instance-method","html_id":"-(other:Array(U))forallU-instance-method","name":"-","doc":"Difference. Returns a new `Array` that is a copy of `self`, removing any items\nthat appear in *other*. The order of `self` is preserved.\n\n```\n[1, 2, 3] - [2, 1] # => [3]\n```","summary":"<p>Difference.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array(U)"}],"args_string":"(other : Array(U)) forall U","source_link":null,"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array(U)"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if size <= SMALL_ARRAY_SIZE || other.size <= SMALL_ARRAY_SIZE\n  ary = Array(T).new\n  each do |elem|\n    if other.includes?(elem)\n    else\n      ary << elem\n    end\n  end\n  return ary\nend\nary = Array(T).new(Math.max(size - other.size, 0))\nhash = other.to_lookup_hash\neach do |obj|\n  if hash.has_key?(obj)\n  else\n    ary << obj\n  end\nend\nary\n"}},{"id":"<<(value:T)-instance-method","html_id":"&lt;&lt;(value:T)-instance-method","name":"<<","doc":"Append. Alias for `push`.\n\n```\na = [1, 2]\na << 3 # => [1,2,3]\n```","summary":"<p>Append.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","source_link":null,"def":{"name":"<<","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"push(value)"}},{"id":"(other:Array)-instance-method","html_id":"(other:Array)-instance-method","name":"<=>","doc":"Combined comparison operator.\n\nReturns `-1`, `0` or `1` depending on whether `self` is less than *other*, equals *other*\nor is greater than *other*.\n\nIt compares the elements of both arrays in the same position using the\n`<=>` operator. As soon as one of such comparisons returns a non-zero\nvalue, that result is the return value of the comparison.\n\nIf all elements are equal, the comparison is based on the size of the arrays.\n\n```\n[8] <=> [1, 2, 3] # => 1\n[2] <=> [4, 2, 3] # => -1\n[1, 2] <=> [1, 2] # => 0\n```","summary":"<p>Combined comparison operator.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array"}],"args_string":"(other : Array)","source_link":null,"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"min_size = Math.min(size, other.size)\n0.upto(min_size - 1) do |i|\n  n = @buffer[i] <=> other.to_unsafe[i]\n  if n != 0\n    return n\n  end\nend\nsize <=> other.size\n"}},{"id":"==(other:Array)-instance-method","html_id":"==(other:Array)-instance-method","name":"==","doc":"Equality. Returns `true` if each element in `self` is equal to each\ncorresponding element in *other*.\n\n```\nary = [1, 2, 3]\nary == [1, 2, 3] # => true\nary == [2, 3]    # => false\n```","summary":"<p>Equality.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array"}],"args_string":"(other : Array)","source_link":null,"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"equals?(other) do |x, y|\n  x == y\nend"}},{"id":"==(other:JSON::Any)-instance-method","html_id":"==(other:JSON::Any)-instance-method","name":"==","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"JSON::Any"}],"args_string":"(other : JSON::Any)","source_link":null,"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"JSON::Any"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == other.raw"}},{"id":"==(other:YAML::Any)-instance-method","html_id":"==(other:YAML::Any)-instance-method","name":"==","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"YAML::Any"}],"args_string":"(other : YAML::Any)","source_link":null,"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"YAML::Any"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == other.raw"}},{"id":"[](start:Int,count:Int)-instance-method","html_id":"[](start:Int,count:Int)-instance-method","name":"[]","doc":"Returns count or less (if there aren't enough) elements starting at the\ngiven start index.\n\nNegative indices count backward from the end of the array (-1 is the last\nelement). Additionally, an empty array is returned when the starting index\nfor an element range is at the end of the array.\n\nRaises `IndexError` if the *start* index is out of range.\n\nRaises `ArgumentError` if *count* is negative.\n\n```\na = [\"a\", \"b\", \"c\", \"d\", \"e\"]\na[-3, 3] # => [\"c\", \"d\", \"e\"]\na[1, 2]  # => [\"b\", \"c\"]\na[5, 1]  # => []\na[6, 1]  # raises IndexError\n```","summary":"<p>Returns count or less (if there aren't enough) elements starting at the given start index.</p>","abstract":false,"args":[{"name":"start","doc":null,"default_value":"","external_name":"start","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"args_string":"(start : Int, count : Int)","source_link":null,"def":{"name":"[]","args":[{"name":"start","doc":null,"default_value":"","external_name":"start","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self[start, count]? || (raise(IndexError.new))"}},{"id":"[](range:Range)-instance-method","html_id":"[](range:Range)-instance-method","name":"[]","doc":"Returns all elements that are within the given range.\n\nNegative indices count backward from the end of the array (-1 is the last\nelement). Additionally, an empty array is returned when the starting index\nfor an element range is at the end of the array.\n\nRaises `IndexError` if the range's start is out of range.\n\n```\na = [\"a\", \"b\", \"c\", \"d\", \"e\"]\na[1..3]    # => [\"b\", \"c\", \"d\"]\na[4..7]    # => [\"e\"]\na[6..10]   # raise IndexError\na[5..10]   # => []\na[-2...-1] # => [\"d\"]\na[2..]     # => [\"c\", \"d\", \"e\"]\n```","summary":"<p>Returns all elements that are within the given range.</p>","abstract":false,"args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"}],"args_string":"(range : Range)","source_link":null,"def":{"name":"[]","args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self[*Indexable.range_to_index_and_count(range, size)]"}},{"id":"[]=(range:Range,value:T)-instance-method","html_id":"[]=(range:Range,value:T)-instance-method","name":"[]=","doc":"Replaces a subrange with a single value.\n\n```\na = [1, 2, 3, 4, 5]\na[1..3] = 6\na # => [1, 6, 5]\n\na = [1, 2, 3, 4, 5]\na[1...1] = 6\na # => [1, 6, 2, 3, 4, 5]\n\na = [1, 2, 3, 4, 5]\na[2...] = 6\na # => [1, 2, 6]\n```","summary":"<p>Replaces a subrange with a single value.</p>","abstract":false,"args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"},{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(range : Range, value : T)","source_link":null,"def":{"name":"[]=","args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"},{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self[*Indexable.range_to_index_and_count(range, size)] = value"}},{"id":"[]=(range:Range,values:Array(T))-instance-method","html_id":"[]=(range:Range,values:Array(T))-instance-method","name":"[]=","doc":"Replaces a subrange with the elements of the given array.\n\n```\na = [1, 2, 3, 4, 5]\na[1..3] = [6, 7, 8]\na # => [1, 6, 7, 8, 5]\n\na = [1, 2, 3, 4, 5]\na[1..3] = [6, 7]\na # => [1, 6, 7, 5]\n\na = [1, 2, 3, 4, 5]\na[1..3] = [6, 7, 8, 9, 10]\na # => [1, 6, 7, 8, 9, 10, 5]\n\na = [1, 2, 3, 4, 5]\na[2..] = [6, 7, 8, 9, 10]\na # => [1, 2, 6, 7, 8, 9, 10]\n```","summary":"<p>Replaces a subrange with the elements of the given array.</p>","abstract":false,"args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"},{"name":"values","doc":null,"default_value":"","external_name":"values","restriction":"Array(T)"}],"args_string":"(range : Range, values : Array(T))","source_link":null,"def":{"name":"[]=","args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"},{"name":"values","doc":null,"default_value":"","external_name":"values","restriction":"Array(T)"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self[*Indexable.range_to_index_and_count(range, size)] = values"}},{"id":"[]=(index:Int,value:T)-instance-method","html_id":"[]=(index:Int,value:T)-instance-method","name":"[]=","doc":"Sets the given value at the given index.\n\nNegative indices can be used to start counting from the end of the array.\nRaises `IndexError` if trying to set an element outside the array's range.\n\n```\nary = [1, 2, 3]\nary[0] = 5\np ary # => [5,2,3]\n\nary[3] = 5 # raises IndexError\n```","summary":"<p>Sets the given value at the given index.</p>","abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"},{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(index : Int, value : T)","source_link":null,"def":{"name":"[]=","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"},{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"index = check_index_out_of_bounds(index)\n@buffer[index] = value\n"}},{"id":"[]=(index:Int,count:Int,value:T)-instance-method","html_id":"[]=(index:Int,count:Int,value:T)-instance-method","name":"[]=","doc":"Replaces a subrange with a single value. All elements in the range\n`index...index+count` are removed and replaced by a single element\n*value*.\n\nIf *count* is zero, *value* is inserted at *index*.\n\nNegative values of *index* count from the end of the array.\n\n```\na = [1, 2, 3, 4, 5]\na[1, 3] = 6\na # => [1, 6, 5]\n\na = [1, 2, 3, 4, 5]\na[1, 0] = 6\na # => [1, 6, 2, 3, 4, 5]\n```","summary":"<p>Replaces a subrange with a single value.</p>","abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"},{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(index : Int, count : Int, value : T)","source_link":null,"def":{"name":"[]=","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"},{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if count < 0\n  raise(ArgumentError.new(\"Negative count: #{count}\"))\nend\nindex = check_index_out_of_bounds(index)\ncount = (index + count) <= size ? count : size - index\ncase count\nwhen 0\n  insert(index, value)\nwhen 1\n  @buffer[index] = value\nelse\n  diff = count - 1\n  ((@buffer + index) + 1).move_from((@buffer + index) + count, (size - index) - count)\n  ((@buffer + @size) - diff).clear(diff)\n  @buffer[index] = value\n  @size = @size - diff\nend\nvalue\n"}},{"id":"[]=(index:Int,count:Int,values:Array(T))-instance-method","html_id":"[]=(index:Int,count:Int,values:Array(T))-instance-method","name":"[]=","doc":"Replaces a subrange with the elements of the given array.\n\n```\na = [1, 2, 3, 4, 5]\na[1, 3] = [6, 7, 8]\na # => [1, 6, 7, 8, 5]\n\na = [1, 2, 3, 4, 5]\na[1, 3] = [6, 7]\na # => [1, 6, 7, 5]\n\na = [1, 2, 3, 4, 5]\na[1, 3] = [6, 7, 8, 9, 10]\na # => [1, 6, 7, 8, 9, 10, 5]\n```","summary":"<p>Replaces a subrange with the elements of the given array.</p>","abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"},{"name":"values","doc":null,"default_value":"","external_name":"values","restriction":"Array(T)"}],"args_string":"(index : Int, count : Int, values : Array(T))","source_link":null,"def":{"name":"[]=","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"},{"name":"values","doc":null,"default_value":"","external_name":"values","restriction":"Array(T)"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if count < 0\n  raise(ArgumentError.new(\"Negative count: #{count}\"))\nend\nindex = check_index_out_of_bounds(index)\ncount = (index + count) <= size ? count : size - index\ndiff = values.size - count\nif diff == 0\n  (@buffer + index).copy_from(values.to_unsafe, values.size)\nelse\n  if diff < 0\n    diff = -diff\n    (@buffer + index).copy_from(values.to_unsafe, values.size)\n    ((@buffer + index) + values.size).move_from((@buffer + index) + count, (size - index) - count)\n    ((@buffer + @size) - diff).clear(diff)\n    @size = @size - diff\n  else\n    resize_to_capacity(Math.pw2ceil(@size + diff))\n    ((@buffer + index) + values.size).move_from((@buffer + index) + count, (size - index) - count)\n    (@buffer + index).copy_from(values.to_unsafe, values.size)\n    @size = @size + diff\n  end\nend\nvalues\n"}},{"id":"[]?(start:Int,count:Int)-instance-method","html_id":"[]?(start:Int,count:Int)-instance-method","name":"[]?","doc":"Like `#[Int, Int]` but returns `nil` if the *start* index is out of range.","summary":"<p>Like <code>#[Int, <a href=\"Int.html\">Int</a>]</code> but returns <code>nil</code> if the <em>start</em> index is out of range.</p>","abstract":false,"args":[{"name":"start","doc":null,"default_value":"","external_name":"start","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"args_string":"(start : Int, count : Int)","source_link":null,"def":{"name":"[]?","args":[{"name":"start","doc":null,"default_value":"","external_name":"start","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if count < 0\n  raise(ArgumentError.new(\"Negative count: #{count}\"))\nend\nif start == size\n  return Array(T).new\nend\nif start < 0\n  start = start + size\nend\nif 0 <= start && start <= size\n  if count == 0\n    return Array(T).new\n  end\n  count = Math.min(count, size - start)\n  Array(T).build(count) do |buffer|\n    buffer.copy_from(@buffer + start, count)\n    count\n  end\nend\n"}},{"id":"[]?(range:Range(Int,Int))-instance-method","html_id":"[]?(range:Range(Int,Int))-instance-method","name":"[]?","doc":"Like `#[Range(Int, Int)]`, but returns `nil` if the range's start is out of range.\n\n```\na = [\"a\", \"b\", \"c\", \"d\", \"e\"]\na[6..10]? # => nil\n```","summary":"<p>Like <code>#[Range(Int, Int)]</code>, but returns <code>nil</code> if the range's start is out of range.</p>","abstract":false,"args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range(Int, Int)"}],"args_string":"(range : Range(Int, Int))","source_link":null,"def":{"name":"[]?","args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range(Int, Int)"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self[*Indexable.range_to_index_and_count(range, size)]?"}},{"id":"clear-instance-method","html_id":"clear-instance-method","name":"clear","doc":"Removes all elements from self.\n\n```\na = [\"a\", \"b\", \"c\", \"d\", \"e\"]\na.clear # => []\n```","summary":"<p>Removes all elements from self.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"clear","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@buffer.clear(@size)\n@size = 0\nself\n"}},{"id":"clone-instance-method","html_id":"clone-instance-method","name":"clone","doc":"Returns a new `Array` that has `self`'s elements cloned.\nThat is, it returns a deep copy of `self`.\n\nUse `#dup` if you want a shallow copy.\n\n```\nary = [[1, 2], [3, 4]]\nary2 = ary.clone\nary[0][0] = 5\nary  # => [[5, 2], [3, 4]]\nary2 # => [[1, 2], [3, 4]]\n\nary2 << [7, 8]\nary  # => [[5, 2], [3, 4]]\nary2 # => [[1, 2], [3, 4], [7, 8]]\n```","summary":"<p>Returns a new <code><a href=\"Array.html\">Array</a></code> that has <code>self</code>'s elements cloned.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Array(T).new(size) do |i|\n  @buffer[i].clone.as(T)\nend"}},{"id":"combinations(size:Int=self.size)-instance-method","html_id":"combinations(size:Int=self.size)-instance-method","name":"combinations","doc":null,"summary":null,"abstract":false,"args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"}],"args_string":"(size : Int = <span class=\"k\">self</span>.size)","source_link":null,"def":{"name":"combinations","args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ary = [] of Array(T)\neach_combination(size) do |a|\n  ary << a\nend\nary\n"}},{"id":"compact-instance-method","html_id":"compact-instance-method","name":"compact","doc":"Returns a copy of `self` with all `nil` elements removed.\n\n```\n[\"a\", nil, \"b\", nil, \"c\", nil].compact # => [\"a\", \"b\", \"c\"]\n```","summary":"<p>Returns a copy of <code>self</code> with all <code>nil</code> elements removed.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"compact","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"compact_map(&.itself)"}},{"id":"compact!-instance-method","html_id":"compact!-instance-method","name":"compact!","doc":"Removes all `nil` elements from `self` and returns `self`.\n\n```\nary = [\"a\", nil, \"b\", nil, \"c\"]\nary.compact!\nary # => [\"a\", \"b\", \"c\"]\n```","summary":"<p>Removes all <code>nil</code> elements from <code>self</code> and returns <code>self</code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"compact!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"reject! do |__arg1|\n  __arg1.nil?\nend"}},{"id":"concat(other:Array)-instance-method","html_id":"concat(other:Array)-instance-method","name":"concat","doc":"Appends the elements of *other* to `self`, and returns `self`.\n\n```\nary = [\"a\", \"b\"]\nary.concat([\"c\", \"d\"])\nary # => [\"a\", \"b\", \"c\", \"d\"]\n```","summary":"<p>Appends the elements of <em>other</em> to <code>self</code>, and returns <code>self</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array"}],"args_string":"(other : Array)","source_link":null,"def":{"name":"concat","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"other_size = other.size\nnew_size = size + other_size\nif new_size > @capacity\n  resize_to_capacity(Math.pw2ceil(new_size))\nend\n(@buffer + @size).copy_from(other.to_unsafe, other_size)\n@size = new_size\nself\n"}},{"id":"concat(other:Enumerable)-instance-method","html_id":"concat(other:Enumerable)-instance-method","name":"concat","doc":"Appends the elements of *other* to `self`, and returns `self`.\n\n```\nary = [\"a\", \"b\"]\nary.concat([\"c\", \"d\"])\nary # => [\"a\", \"b\", \"c\", \"d\"]\n```","summary":"<p>Appends the elements of <em>other</em> to <code>self</code>, and returns <code>self</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Enumerable"}],"args_string":"(other : Enumerable)","source_link":null,"def":{"name":"concat","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Enumerable"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"left_before_resize = @capacity - @size\nlen = @size\nbuf = @buffer + len\nother.each do |elem|\n  if left_before_resize == 0\n    double_capacity\n    left_before_resize = @capacity - len\n    buf = @buffer + len\n  end\n  buf.value = elem\n  buf = buf + 1\n  len = len + 1\n  left_before_resize = left_before_resize - 1\nend\n@size = len\nself\n"}},{"id":"delete(obj)-instance-method","html_id":"delete(obj)-instance-method","name":"delete","doc":"Removes all items from `self` that are equal to *obj*.\n\nReturns the last found element that was equal to *obj*,\nif any, or `nil` if not found.\n\n```\na = [\"a\", \"b\", \"b\", \"b\", \"c\"]\na.delete(\"b\") # => \"b\"\na             # => [\"a\", \"c\"]\n\na.delete(\"x\") # => nil\na             # => [\"a\", \"c\"]\n```","summary":"<p>Removes all items from <code>self</code> that are equal to <em>obj</em>.</p>","abstract":false,"args":[{"name":"obj","doc":null,"default_value":"","external_name":"obj","restriction":""}],"args_string":"(obj)","source_link":null,"def":{"name":"delete","args":[{"name":"obj","doc":null,"default_value":"","external_name":"obj","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"internal_delete do |e|\n  e == obj\nend[1]"}},{"id":"delete_at(index:Int,count:Int)-instance-method","html_id":"delete_at(index:Int,count:Int)-instance-method","name":"delete_at","doc":"Removes *count* elements from `self` starting at *index*.\nIf the size of `self` is less than *count*, removes values to the end of the array without error.\nReturns an array of the removed elements with the original order of `self` preserved.\nRaises `IndexError` if *index* is out of range.\n\n```\na = [\"ant\", \"bat\", \"cat\", \"dog\"]\na.delete_at(1, 2)  # => [\"bat\", \"cat\"]\na                  # => [\"ant\", \"dog\"]\na.delete_at(99, 1) # raises IndexError\n```","summary":"<p>Removes <em>count</em> elements from <code>self</code> starting at <em>index</em>.</p>","abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"args_string":"(index : Int, count : Int)","source_link":null,"def":{"name":"delete_at","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"val = self[index, count]\ncount = (index + count) <= size ? count : size - index\n(@buffer + index).move_from((@buffer + index) + count, (size - index) - count)\n@size = @size - count\n(@buffer + @size).clear(count)\nval\n"}},{"id":"delete_at(index:Int)-instance-method","html_id":"delete_at(index:Int)-instance-method","name":"delete_at","doc":"Removes the element at *index*, returning that element.\nRaises `IndexError` if *index* is out of range.\n\n```\na = [\"ant\", \"bat\", \"cat\", \"dog\"]\na.delete_at(2)  # => \"cat\"\na               # => [\"ant\", \"bat\", \"dog\"]\na.delete_at(99) # raises IndexError\n```","summary":"<p>Removes the element at <em>index</em>, returning that element.</p>","abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"}],"args_string":"(index : Int)","source_link":null,"def":{"name":"delete_at","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"index = check_index_out_of_bounds(index)\nelem = @buffer[index]\n(@buffer + index).move_from((@buffer + index) + 1, (size - index) - 1)\n@size = @size - 1\n(@buffer + @size).clear\nelem\n"}},{"id":"delete_at(range:Range)-instance-method","html_id":"delete_at(range:Range)-instance-method","name":"delete_at","doc":"Removes all elements within the given *range*.\nReturns an array of the removed elements with the original order of `self` preserved.\nRaises `IndexError` if the index is out of range.\n\n```\na = [\"ant\", \"bat\", \"cat\", \"dog\"]\na.delete_at(1..2)    # => [\"bat\", \"cat\"]\na                    # => [\"ant\", \"dog\"]\na.delete_at(99..100) # raises IndexError\n```","summary":"<p>Removes all elements within the given <em>range</em>.</p>","abstract":false,"args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"}],"args_string":"(range : Range)","source_link":null,"def":{"name":"delete_at","args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"index, count = Indexable.range_to_index_and_count(range, self.size)\ndelete_at(index, count)\n"}},{"id":"dup-instance-method","html_id":"dup-instance-method","name":"dup","doc":"Returns a new `Array` that has exactly `self`'s elements.\nThat is, it returns a shallow copy of `self`.\n\nUse `#clone` if you want a deep copy.\n\n```\nary = [[1, 2], [3, 4]]\nary2 = ary.dup\nary[0][0] = 5\nary  # => [[5, 2], [3, 4]]\nary2 # => [[5, 2], [3, 4]]\n\nary2 << [7, 8]\nary  # => [[5, 2], [3, 4]]\nary2 # => [[5, 2], [3, 4], [7, 8]]\n```","summary":"<p>Returns a new <code><a href=\"Array.html\">Array</a></code> that has exactly <code>self</code>'s elements.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"dup","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Array(T).build(@capacity) do |buffer|\n  buffer.copy_from(@buffer, size)\n  size\nend"}},{"id":"each_combination(size:Int=self.size,reuse=false,&block):Nil-instance-method","html_id":"each_combination(size:Int=self.size,reuse=false,&amp;block):Nil-instance-method","name":"each_combination","doc":null,"summary":null,"abstract":false,"args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"},{"name":"reuse","doc":null,"default_value":"false","external_name":"reuse","restriction":""}],"args_string":"(size : Int = <span class=\"k\">self</span>.size, reuse = <span class=\"n\">false</span>, &block) : Nil","source_link":null,"def":{"name":"each_combination","args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"},{"name":"reuse","doc":null,"default_value":"false","external_name":"reuse","restriction":""}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"n = self.size\nif size > n\n  return\nend\nif size < 0\n  raise(ArgumentError.new(\"Size must be positive\"))\nend\nreuse = check_reuse(reuse, size)\ncopy = self.dup\npool = self.dup\nindices = (0...size).to_a\nyield pool_slice(pool, size, reuse)\nwhile true\n  stop = true\n  i = size - 1\n  while i >= 0\n    if indices[i] != ((i + n) - size)\n      stop = false\n      break\n    end\n    i = i - 1\n  end\n  if stop\n    return\n  end\n  __temp_7 = i\n  indices[__temp_7] = indices[__temp_7] + 1\n  pool[i] = copy[indices[i]]\n  (i + 1).upto(size - 1) do |j|\n    indices[j] = indices[j - 1] + 1\n    pool[j] = copy[indices[j]]\n  end\n  yield pool_slice(pool, size, reuse)\nend\n"}},{"id":"each_combination(size:Int=self.size,reuse=false)-instance-method","html_id":"each_combination(size:Int=self.size,reuse=false)-instance-method","name":"each_combination","doc":null,"summary":null,"abstract":false,"args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"},{"name":"reuse","doc":null,"default_value":"false","external_name":"reuse","restriction":""}],"args_string":"(size : Int = <span class=\"k\">self</span>.size, reuse = <span class=\"n\">false</span>)","source_link":null,"def":{"name":"each_combination","args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"},{"name":"reuse","doc":null,"default_value":"false","external_name":"reuse","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if size < 0\n  raise(ArgumentError.new(\"Size must be positive\"))\nend\nCombinationIterator.new(self, size.to_i, reuse)\n"}},{"id":"each_permutation(size:Int=self.size,reuse=false)-instance-method","html_id":"each_permutation(size:Int=self.size,reuse=false)-instance-method","name":"each_permutation","doc":"Returns an `Iterator` over each possible permutation of *size* of `self`.\n\n```\niter = [1, 2, 3].each_permutation\niter.next # => [1, 2, 3]\niter.next # => [1, 3, 2]\niter.next # => [2, 1, 3]\niter.next # => [2, 3, 1]\niter.next # => [3, 1, 2]\niter.next # => [3, 2, 1]\niter.next # => #<Iterator::Stop>\n```\n\nBy default, a new array is created and returned for each permutation.\nIf *reuse* is given, the array can be reused: if *reuse* is\nan `Array`, this array will be reused; if *reuse* if truthy,\nthe method will create a new array and reuse it. This can be\nused to prevent many memory allocations when each slice of\ninterest is to be used in a read-only fashion.","summary":"<p>Returns an <code><a href=\"Iterator.html\">Iterator</a></code> over each possible permutation of <em>size</em> of <code>self</code>.</p>","abstract":false,"args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"},{"name":"reuse","doc":null,"default_value":"false","external_name":"reuse","restriction":""}],"args_string":"(size : Int = <span class=\"k\">self</span>.size, reuse = <span class=\"n\">false</span>)","source_link":null,"def":{"name":"each_permutation","args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"},{"name":"reuse","doc":null,"default_value":"false","external_name":"reuse","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if size < 0\n  raise(ArgumentError.new(\"Size must be positive\"))\nend\nPermutationIterator.new(self, size.to_i, reuse)\n"}},{"id":"each_permutation(size:Int=self.size,reuse=false,&block):Nil-instance-method","html_id":"each_permutation(size:Int=self.size,reuse=false,&amp;block):Nil-instance-method","name":"each_permutation","doc":"Yields each possible permutation of *size* of `self`.\n\n```\na = [1, 2, 3]\nsums = [] of Int32\na.each_permutation(2) { |p| sums << p.sum } # => nil\nsums                                        # => [3, 4, 3, 5, 4, 5]\n```\n\nBy default, a new array is created and yielded for each permutation.\nIf *reuse* is given, the array can be reused: if *reuse* is\nan `Array`, this array will be reused; if *reuse* if truthy,\nthe method will create a new array and reuse it. This can be\nused to prevent many memory allocations when each slice of\ninterest is to be used in a read-only fashion.","summary":"<p>Yields each possible permutation of <em>size</em> of <code>self</code>.</p>","abstract":false,"args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"},{"name":"reuse","doc":null,"default_value":"false","external_name":"reuse","restriction":""}],"args_string":"(size : Int = <span class=\"k\">self</span>.size, reuse = <span class=\"n\">false</span>, &block) : Nil","source_link":null,"def":{"name":"each_permutation","args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"},{"name":"reuse","doc":null,"default_value":"false","external_name":"reuse","restriction":""}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"n = self.size\nif size > n\n  return\nend\nif size < 0\n  raise(ArgumentError.new(\"Size must be positive\"))\nend\nreuse = check_reuse(reuse, size)\npool = self.dup\ncycles = (((n - size) + 1)..n).to_a.reverse!\nyield pool_slice(pool, size, reuse)\nwhile true\n  stop = true\n  i = size - 1\n  while i >= 0\n    ci = ((    __temp_5 = i\n    cycles[__temp_5] = cycles[__temp_5] - 1))\n    if ci == 0\n      e = pool[i]\n      (i + 1).upto(n - 1) do |j|\n        pool[j - 1] = pool[j]\n      end\n      pool[n - 1] = e\n      cycles[i] = n - i\n    else\n      pool.swap(i, -ci)\n      yield pool_slice(pool, size, reuse)\n      stop = false\n      break\n    end\n    i = i - 1\n  end\n  if stop\n    return\n  end\nend\n"}},{"id":"each_repeated_combination(size:Int=self.size,reuse=false,&block):Nil-instance-method","html_id":"each_repeated_combination(size:Int=self.size,reuse=false,&amp;block):Nil-instance-method","name":"each_repeated_combination","doc":null,"summary":null,"abstract":false,"args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"},{"name":"reuse","doc":null,"default_value":"false","external_name":"reuse","restriction":""}],"args_string":"(size : Int = <span class=\"k\">self</span>.size, reuse = <span class=\"n\">false</span>, &block) : Nil","source_link":null,"def":{"name":"each_repeated_combination","args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"},{"name":"reuse","doc":null,"default_value":"false","external_name":"reuse","restriction":""}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"n = self.size\nif size > n && (n == 0)\n  return\nend\nif size < 0\n  raise(ArgumentError.new(\"Size must be positive\"))\nend\nreuse = check_reuse(reuse, size)\ncopy = self.dup\nindices = Array.new(size, 0)\npool = indices.map do |i|\n  copy[i]\nend\nyield pool_slice(pool, size, reuse)\nwhile true\n  stop = true\n  i = size - 1\n  while i >= 0\n    if indices[i] != (n - 1)\n      stop = false\n      break\n    end\n    i = i - 1\n  end\n  if stop\n    return\n  end\n  ii = indices[i] + 1\n  tmp = copy[ii]\n  indices.fill(i, size - i) do\n    ii\n  end\n  pool.fill(i, size - i) do\n    tmp\n  end\n  yield pool_slice(pool, size, reuse)\nend\n"}},{"id":"each_repeated_combination(size:Int=self.size,reuse=false)-instance-method","html_id":"each_repeated_combination(size:Int=self.size,reuse=false)-instance-method","name":"each_repeated_combination","doc":null,"summary":null,"abstract":false,"args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"},{"name":"reuse","doc":null,"default_value":"false","external_name":"reuse","restriction":""}],"args_string":"(size : Int = <span class=\"k\">self</span>.size, reuse = <span class=\"n\">false</span>)","source_link":null,"def":{"name":"each_repeated_combination","args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"},{"name":"reuse","doc":null,"default_value":"false","external_name":"reuse","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if size < 0\n  raise(ArgumentError.new(\"Size must be positive\"))\nend\nRepeatedCombinationIterator.new(self, size.to_i, reuse)\n"}},{"id":"each_repeated_permutation(size:Int=self.size,reuse=false,&block):Nil-instance-method","html_id":"each_repeated_permutation(size:Int=self.size,reuse=false,&amp;block):Nil-instance-method","name":"each_repeated_permutation","doc":null,"summary":null,"abstract":false,"args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"},{"name":"reuse","doc":null,"default_value":"false","external_name":"reuse","restriction":""}],"args_string":"(size : Int = <span class=\"k\">self</span>.size, reuse = <span class=\"n\">false</span>, &block) : Nil","source_link":null,"def":{"name":"each_repeated_permutation","args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"},{"name":"reuse","doc":null,"default_value":"false","external_name":"reuse","restriction":""}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"n = self.size\nif (size != 0) && (n == 0)\n  return\nend\nif size < 0\n  raise(ArgumentError.new(\"Size must be positive\"))\nend\nif size == 0\n  yield [] of T\nelse\n  Array.each_product(Array.new(size, self), reuse: reuse) do |r|\n    yield r\n  end\nend\n"}},{"id":"fill(from:Int,&block)-instance-method","html_id":"fill(from:Int,&amp;block)-instance-method","name":"fill","doc":"Yields each index of `self`, starting at *from*, to the given block and then assigns\nthe block's value in that position. Returns `self`.\n\nNegative values of *from* count from the end of the array.\n\nRaises `IndexError` if *from* is outside the array range.\n\n```\na = [1, 2, 3, 4]\na.fill(2) { |i| i * i } # => [1, 2, 4, 9]\n```","summary":"<p>Yields each index of <code>self</code>, starting at <em>from</em>, to the given block and then assigns the block's value in that position.</p>","abstract":false,"args":[{"name":"from","doc":null,"default_value":"","external_name":"from","restriction":"Int"}],"args_string":"(from : Int, &block)","source_link":null,"def":{"name":"fill","args":[{"name":"from","doc":null,"default_value":"","external_name":"from","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"if from < 0\n  from = from + size\nend\nif 0 <= from && from < size\nelse\n  raise(IndexError.new)\nend\nfrom.upto(size - 1) do |i|\n  @buffer[i] = yield i\nend\nself\n"}},{"id":"fill(range:Range,&block)-instance-method","html_id":"fill(range:Range,&amp;block)-instance-method","name":"fill","doc":"Yields each index of `self`, in the given *range*, to the given block and then assigns\nthe block's value in that position. Returns `self`.\n\n```\na = [1, 2, 3, 4, 5, 6]\na.fill(2..3) { |i| i * i } # => [1, 2, 4, 9, 5, 6]\n```","summary":"<p>Yields each index of <code>self</code>, in the given <em>range</em>, to the given block and then assigns the block's value in that position.</p>","abstract":false,"args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"}],"args_string":"(range : Range, &block)","source_link":null,"def":{"name":"fill","args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"fill(*Indexable.range_to_index_and_count(range, size)) do |i|\n  yield i\nend"}},{"id":"fill(&block)-instance-method","html_id":"fill(&amp;block)-instance-method","name":"fill","doc":"Yields each index of `self` to the given block and then assigns\nthe block's value in that position. Returns `self`.\n\n```\na = [1, 2, 3, 4]\na.fill { |i| i * i } # => [0, 1, 4, 9]\n```","summary":"<p>Yields each index of <code>self</code> to the given block and then assigns the block's value in that position.</p>","abstract":false,"args":[],"args_string":"(&block)","source_link":null,"def":{"name":"fill","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"each_index do |i|\n  @buffer[i] = yield i\nend\nself\n"}},{"id":"fill(value:T,from:Int,count:Int)-instance-method","html_id":"fill(value:T,from:Int,count:Int)-instance-method","name":"fill","doc":"Replaces every element in `self`, starting at *from* and only *count* times,\nwith the given *value*. Returns `self`.\n\nNegative values of *from* count from the end of the array.\n\n```\na = [1, 2, 3, 4, 5]\na.fill(9, 2, 2) # => [1, 2, 9, 9, 5]\n```","summary":"<p>Replaces every element in <code>self</code>, starting at <em>from</em> and only <em>count</em> times, with the given <em>value</em>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"},{"name":"from","doc":null,"default_value":"","external_name":"from","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"args_string":"(value : T, from : Int, count : Int)","source_link":null,"def":{"name":"fill","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"},{"name":"from","doc":null,"default_value":"","external_name":"from","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"fill(from, count) do\n  value\nend"}},{"id":"fill(value:T,from:Int)-instance-method","html_id":"fill(value:T,from:Int)-instance-method","name":"fill","doc":"Replaces every element in `self`, starting at *from*, with the given *value*. Returns `self`.\n\nNegative values of *from* count from the end of the array.\n\n```\na = [1, 2, 3, 4, 5]\na.fill(9, 2) # => [1, 2, 9, 9, 9]\n```","summary":"<p>Replaces every element in <code>self</code>, starting at <em>from</em>, with the given <em>value</em>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"},{"name":"from","doc":null,"default_value":"","external_name":"from","restriction":"Int"}],"args_string":"(value : T, from : Int)","source_link":null,"def":{"name":"fill","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"},{"name":"from","doc":null,"default_value":"","external_name":"from","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"fill(from) do\n  value\nend"}},{"id":"fill(value:T,range:Range)-instance-method","html_id":"fill(value:T,range:Range)-instance-method","name":"fill","doc":"Replaces every element in *range* with *value*. Returns `self`.\n\nNegative values of *from* count from the end of the array.\n\n```\na = [1, 2, 3, 4, 5]\na.fill(9, 2..3) # => [1, 2, 9, 9, 5]\n```","summary":"<p>Replaces every element in <em>range</em> with <em>value</em>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"},{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"}],"args_string":"(value : T, range : Range)","source_link":null,"def":{"name":"fill","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"},{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"fill(range) do\n  value\nend"}},{"id":"fill(value:T)-instance-method","html_id":"fill(value:T)-instance-method","name":"fill","doc":"Replaces every element in `self` with the given *value*. Returns `self`.\n\n```\na = [1, 2, 3]\na.fill(9) # => [9, 9, 9]\n```","summary":"<p>Replaces every element in <code>self</code> with the given <em>value</em>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","source_link":null,"def":{"name":"fill","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"fill do\n  value\nend"}},{"id":"fill(from:Int,count:Int,&block)-instance-method","html_id":"fill(from:Int,count:Int,&amp;block)-instance-method","name":"fill","doc":"Yields each index of `self`, starting at *from* and just *count* times,\nto the given block and then assigns the block's value in that position. Returns `self`.\n\nNegative values of *from* count from the end of the array.\n\nRaises `IndexError` if *from* is outside the array range.\n\nHas no effect if *count* is zero or negative.\n\n```\na = [1, 2, 3, 4, 5, 6]\na.fill(2, 2) { |i| i * i } # => [1, 2, 4, 9, 5, 6]\n```","summary":"<p>Yields each index of <code>self</code>, starting at <em>from</em> and just <em>count</em> times, to the given block and then assigns the block's value in that position.</p>","abstract":false,"args":[{"name":"from","doc":null,"default_value":"","external_name":"from","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"args_string":"(from : Int, count : Int, &block)","source_link":null,"def":{"name":"fill","args":[{"name":"from","doc":null,"default_value":"","external_name":"from","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"if count <= 0\n  return self\nend\nif from < 0\n  from = from + size\nend\nif (0 <= from && from < size) && (from + count) <= size\nelse\n  raise(IndexError.new)\nend\nfrom.upto((from + count) - 1) do |i|\n  @buffer[i] = yield i\nend\nself\n"}},{"id":"first(n:Int)-instance-method","html_id":"first(n:Int)-instance-method","name":"first","doc":"Returns the first *n* elements of the array.\n\n```\n[1, 2, 3].first(2) # => [1, 2]\n[1, 2, 3].first(4) # => [1, 2, 3]\n```","summary":"<p>Returns the first <em>n</em> elements of the array.</p>","abstract":false,"args":[{"name":"n","doc":null,"default_value":"","external_name":"n","restriction":"Int"}],"args_string":"(n : Int)","source_link":null,"def":{"name":"first","args":[{"name":"n","doc":null,"default_value":"","external_name":"n","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self[0, n]"}},{"id":"flatten-instance-method","html_id":"flatten-instance-method","name":"flatten","doc":"Returns a new `Array` that is a one-dimensional flattening of `self` (recursively).\n\nThat is, for every element that is an array or an iterator, extract its elements into the new array.\n\n```\ns = [1, 2, 3]          # => [1, 2, 3]\nt = [4, 5, 6, [7, 8]]  # => [4, 5, 6, [7, 8]]\nu = [9, [10, 11].each] # => [9, #<Indexable::ItemIterator>]\na = [s, t, u, 12, 13]  # => [[1, 2, 3], [4, 5, 6, [7, 8]], 9, #<Indexable::ItemIterator>, 12, 13]\na.flatten              # => [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13]\n```","summary":"<p>Returns a new <code><a href=\"Array.html\">Array</a></code> that is a one-dimensional flattening of <code>self</code> (recursively).</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"flatten","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"FlattenHelper(typeof(FlattenHelper.element_type(self))).flatten(self)"}},{"id":"insert(index:Int,object:T)-instance-method","html_id":"insert(index:Int,object:T)-instance-method","name":"insert","doc":"Insert *object* before the element at *index* and shifting successive elements, if any.\nReturns `self`.\n\nNegative values of *index* count from the end of the array.\n\n```\na = [\"a\", \"b\", \"c\"]\na.insert(0, \"x\")  # => [\"x\", \"a\", \"b\", \"c\"]\na.insert(2, \"y\")  # => [\"x\", \"a\", \"y\", \"b\", \"c\"]\na.insert(-1, \"z\") # => [\"x\", \"a\", \"y\", \"b\", \"c\", \"z\"]\n```","summary":"<p>Insert <em>object</em> before the element at <em>index</em> and shifting successive elements, if any.</p>","abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"},{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":"T"}],"args_string":"(index : Int, object : T)","source_link":null,"def":{"name":"insert","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"},{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"check_needs_resize\nif index < 0\n  index = index + (size + 1)\nend\nif 0 <= index && index <= size\nelse\n  raise(IndexError.new)\nend\n((@buffer + index) + 1).move_from(@buffer + index, size - index)\n@buffer[index] = object\n@size = @size + 1\nself\n"}},{"id":"last(n:Int)-instance-method","html_id":"last(n:Int)-instance-method","name":"last","doc":"Returns the last *n* elements of the array.\n\n```\n[1, 2, 3].last(2) # => [2, 3]\n[1, 2, 3].last(4) # => [1, 2, 3]\n```","summary":"<p>Returns the last <em>n</em> elements of the array.</p>","abstract":false,"args":[{"name":"n","doc":null,"default_value":"","external_name":"n","restriction":"Int"}],"args_string":"(n : Int)","source_link":null,"def":{"name":"last","args":[{"name":"n","doc":null,"default_value":"","external_name":"n","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if n < @size\n  self[@size - n, n]\nelse\n  dup\nend"}},{"id":"map(&block:T->U)forallU-instance-method","html_id":"map(&amp;block:T-&gt;U)forallU-instance-method","name":"map","doc":"Optimized version of `Enumerable#map`.","summary":"<p>Optimized version of <code><a href=\"Enumerable.html#map(&block:T-%3EU)forallU-instance-method\">Enumerable#map</a></code>.</p>","abstract":false,"args":[],"args_string":"(&block : T -> U) forall U","source_link":null,"def":{"name":"map","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":"(T -> U)"},"return_type":"","visibility":"Public","body":"Array(U).new(size) do |i|\n  yield @buffer[i]\nend"}},{"id":"map!(&block)-instance-method","html_id":"map!(&amp;block)-instance-method","name":"map!","doc":"Invokes the given block for each element of `self`, replacing the element\nwith the value returned by the block. Returns `self`.\n\n```\na = [1, 2, 3]\na.map! { |x| x * x }\na # => [1, 4, 9]\n```","summary":"<p>Invokes the given block for each element of <code>self</code>, replacing the element with the value returned by the block.</p>","abstract":false,"args":[],"args_string":"(&block)","source_link":null,"def":{"name":"map!","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"@buffer.map!(size) do |e|\n  yield e\nend\nself\n"}},{"id":"map_with_index(&block:T,Int32->U)forallU-instance-method","html_id":"map_with_index(&amp;block:T,Int32-&gt;U)forallU-instance-method","name":"map_with_index","doc":"Optimized version of `Enumerable#map_with_index`.","summary":"<p>Optimized version of <code><a href=\"Enumerable.html#map_with_index(&block:T,Int32-%3EU)forallU-instance-method\">Enumerable#map_with_index</a></code>.</p>","abstract":false,"args":[],"args_string":"(&block : T, Int32 -> U) forall U","source_link":null,"def":{"name":"map_with_index","args":[],"double_splat":null,"splat_index":null,"yields":2,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":"(T, Int32 -> U)"},"return_type":"","visibility":"Public","body":"Array(U).new(size) do |i|\n  yield @buffer[i], i\nend"}},{"id":"map_with_index!(&block:T,Int32->T)-instance-method","html_id":"map_with_index!(&amp;block:T,Int32-&gt;T)-instance-method","name":"map_with_index!","doc":"Like `map_with_index`, but mutates `self` instead of allocating a new object.","summary":"<p>Like <code><a href=\"Array.html#map_with_index(&block:T,Int32-%3EU)forallU-instance-method\">#map_with_index</a></code>, but mutates <code>self</code> instead of allocating a new object.</p>","abstract":false,"args":[],"args_string":"(&block : T, Int32 -> T)","source_link":null,"def":{"name":"map_with_index!","args":[],"double_splat":null,"splat_index":null,"yields":2,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":"(T, Int32 -> T)"},"return_type":"","visibility":"Public","body":"to_unsafe.map_with_index!(size) do |e, i|\n  yield e, i\nend\nself\n"}},{"id":"permutations(size:Int=self.size)-instance-method","html_id":"permutations(size:Int=self.size)-instance-method","name":"permutations","doc":"Returns an `Array` with all possible permutations of *size*.\n\n```\na = [1, 2, 3]\na.permutations    # => [[1,2,3],[1,3,2],[2,1,3],[2,3,1],[3,1,2],[3,2,1]]\na.permutations(1) # => [[1],[2],[3]]\na.permutations(2) # => [[1,2],[1,3],[2,1],[2,3],[3,1],[3,2]]\na.permutations(3) # => [[1,2,3],[1,3,2],[2,1,3],[2,3,1],[3,1,2],[3,2,1]]\na.permutations(0) # => [[]]\na.permutations(4) # => []\n```","summary":"<p>Returns an <code><a href=\"Array.html\">Array</a></code> with all possible permutations of <em>size</em>.</p>","abstract":false,"args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"}],"args_string":"(size : Int = <span class=\"k\">self</span>.size)","source_link":null,"def":{"name":"permutations","args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ary = [] of Array(T)\neach_permutation(size) do |a|\n  ary << a\nend\nary\n"}},{"id":"pop-instance-method","html_id":"pop-instance-method","name":"pop","doc":"Removes the last value from `self`, at index *size - 1*.\nThis method returns the removed value.\nRaises `IndexError` if array is of 0 size.\n\n```\na = [\"a\", \"b\", \"c\"]\na.pop # => \"c\"\na     # => [\"a\", \"b\"]\n```","summary":"<p>Removes the last value from <code>self</code>, at index <em>size - 1</em>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"pop","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"pop do\n  raise(IndexError.new)\nend"}},{"id":"pop(&block)-instance-method","html_id":"pop(&amp;block)-instance-method","name":"pop","doc":"Removes the last value from `self`.\nIf the array is empty, the given block is called.\n\n```\na = [1]\na.pop { \"Testing\" } # => 1\na.pop { \"Testing\" } # => \"Testing\"\n```","summary":"<p>Removes the last value from <code>self</code>.</p>","abstract":false,"args":[],"args_string":"(&block)","source_link":null,"def":{"name":"pop","args":[],"double_splat":null,"splat_index":null,"yields":0,"block_arg":null,"return_type":"","visibility":"Public","body":"if @size == 0\n  yield\nelse\n  @size = @size - 1\n  value = @buffer[@size]\n  (@buffer + @size).clear\n  value\nend"}},{"id":"pop(n:Int)-instance-method","html_id":"pop(n:Int)-instance-method","name":"pop","doc":"Removes the last *n* values from `self`, at index *size - 1*.\nThis method returns an array of the removed values, with the original order preserved.\n\nIf *n* is greater than the size of `self`, all values will be removed from `self`\nwithout raising an error.\n\n```\na = [\"a\", \"b\", \"c\"]\na.pop(2) # => [\"b\", \"c\"]\na        # => [\"a\"]\n\na = [\"a\", \"b\", \"c\"]\na.pop(4) # => [\"a\", \"b\", \"c\"]\na        # => []\n```","summary":"<p>Removes the last <em>n</em> values from <code>self</code>, at index <em>size - 1</em>.</p>","abstract":false,"args":[{"name":"n","doc":null,"default_value":"","external_name":"n","restriction":"Int"}],"args_string":"(n : Int)","source_link":null,"def":{"name":"pop","args":[{"name":"n","doc":null,"default_value":"","external_name":"n","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if n < 0\n  raise(ArgumentError.new(\"Can't pop negative count\"))\nend\nn = Math.min(n, @size)\nary = Array(T).new(n) do |i|\n  @buffer[(@size - n) + i]\nend\n@size = @size - n\n(@buffer + @size).clear(n)\nary\n"}},{"id":"pop?-instance-method","html_id":"pop?-instance-method","name":"pop?","doc":"Like `pop`, but returns `nil` if `self` is empty.","summary":"<p>Like <code><a href=\"Array.html#pop-instance-method\">#pop</a></code>, but returns <code>nil</code> if <code>self</code> is empty.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"pop?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"pop do\n  nil\nend"}},{"id":"pretty_print(pp):Nil-instance-method","html_id":"pretty_print(pp):Nil-instance-method","name":"pretty_print","doc":null,"summary":null,"abstract":false,"args":[{"name":"pp","doc":null,"default_value":"","external_name":"pp","restriction":""}],"args_string":"(pp) : Nil","source_link":null,"def":{"name":"pretty_print","args":[{"name":"pp","doc":null,"default_value":"","external_name":"pp","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"executed = exec_recursive(:pretty_print) do\n  pp.list(\"[\", self, \"]\")\nend\nif executed\nelse\n  pp.text(\"[...]\")\nend\n"}},{"id":"product(ary:Array(U))forallU-instance-method","html_id":"product(ary:Array(U))forallU-instance-method","name":"product","doc":null,"summary":null,"abstract":false,"args":[{"name":"ary","doc":null,"default_value":"","external_name":"ary","restriction":"Array(U)"}],"args_string":"(ary : Array(U)) forall U","source_link":null,"def":{"name":"product","args":[{"name":"ary","doc":null,"default_value":"","external_name":"ary","restriction":"Array(U)"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"result = Array(::Tuple(T, U)).new(size * ary.size)\nproduct(ary) do |x, y|\n  result << {x, y}\nend\nresult\n"}},{"id":"product(enumerable:Enumerable,&block)-instance-method","html_id":"product(enumerable:Enumerable,&amp;block)-instance-method","name":"product","doc":null,"summary":null,"abstract":false,"args":[{"name":"enumerable","doc":null,"default_value":"","external_name":"enumerable","restriction":"Enumerable"}],"args_string":"(enumerable : Enumerable, &block)","source_link":null,"def":{"name":"product","args":[{"name":"enumerable","doc":null,"default_value":"","external_name":"enumerable","restriction":"Enumerable"}],"double_splat":null,"splat_index":null,"yields":2,"block_arg":null,"return_type":"","visibility":"Public","body":"self.each do |a|\n  enumerable.each do |b|\n    yield a, b\n  end\nend"}},{"id":"push(value:T)-instance-method","html_id":"push(value:T)-instance-method","name":"push","doc":"Append. Pushes one value to the end of `self`, given that the type of the value is *T*\n(which might be a single type or a union of types).\nThis method returns `self`, so several calls can be chained.\nSee `pop` for the opposite effect.\n\n```\na = [\"a\", \"b\"]\na.push(\"c\") # => [\"a\", \"b\", \"c\"]\na.push(1)   # Errors, because the array only accepts String.\n\na = [\"a\", \"b\"] of (Int32 | String)\na.push(\"c\") # => [\"a\", \"b\", \"c\"]\na.push(1)   # => [\"a\", \"b\", \"c\", 1]\n```","summary":"<p>Append.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","source_link":null,"def":{"name":"push","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"check_needs_resize\n@buffer[@size] = value\n@size = @size + 1\nself\n"}},{"id":"push(*values:T)-instance-method","html_id":"push(*values:T)-instance-method","name":"push","doc":"Append multiple values. The same as `push`, but takes an arbitrary number\nof values to push into `self`. Returns `self`.\n\n```\na = [\"a\"]\na.push(\"b\", \"c\") # => [\"a\", \"b\", \"c\"]\n```","summary":"<p>Append multiple values.</p>","abstract":false,"args":[{"name":"values","doc":null,"default_value":"","external_name":"values","restriction":"T"}],"args_string":"(*values : T)","source_link":null,"def":{"name":"push","args":[{"name":"values","doc":null,"default_value":"","external_name":"values","restriction":"T"}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"new_size = @size + values.size\nif new_size > @capacity\n  resize_to_capacity(Math.pw2ceil(new_size))\nend\nvalues.each_with_index do |value, i|\n  @buffer[@size + i] = value\nend\n@size = new_size\nself\n"}},{"id":"reject!(&block)-instance-method","html_id":"reject!(&amp;block)-instance-method","name":"reject!","doc":"Modifies `self`, deleting the elements in the collection for which the\npassed block returns `true`. Returns `self`.\n\n```\nary = [1, 6, 2, 4, 8]\nary.reject! { |x| x > 3 }\nary # => [1, 2]\n```\n\nSee also: `Array#reject`.","summary":"<p>Modifies <code>self</code>, deleting the elements in the collection for which the passed block returns <code>true</code>.</p>","abstract":false,"args":[],"args_string":"(&block)","source_link":null,"def":{"name":"reject!","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"internal_delete do |e|\n  yield e\nend\nself\n"}},{"id":"reject!(pattern)-instance-method","html_id":"reject!(pattern)-instance-method","name":"reject!","doc":"Modifies `self`, deleting the elements in the collection for which\n`pattern === element`.\n\n```\nary = [1, 6, 2, 4, 8]\nary.reject!(3..7)\nary # => [1, 2, 8]\n```\n\nSee also: `Array#select!`.","summary":"<p>Modifies <code>self</code>, deleting the elements in the collection for which <code>pattern === element</code>.</p>","abstract":false,"args":[{"name":"pattern","doc":null,"default_value":"","external_name":"pattern","restriction":""}],"args_string":"(pattern)","source_link":null,"def":{"name":"reject!","args":[{"name":"pattern","doc":null,"default_value":"","external_name":"pattern","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"reject! do |elem|\n  pattern === elem\nend\nself\n"}},{"id":"repeated_combinations(size:Int=self.size)-instance-method","html_id":"repeated_combinations(size:Int=self.size)-instance-method","name":"repeated_combinations","doc":null,"summary":null,"abstract":false,"args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"}],"args_string":"(size : Int = <span class=\"k\">self</span>.size)","source_link":null,"def":{"name":"repeated_combinations","args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ary = [] of Array(T)\neach_repeated_combination(size) do |a|\n  ary << a\nend\nary\n"}},{"id":"repeated_permutations(size:Int=self.size)-instance-method","html_id":"repeated_permutations(size:Int=self.size)-instance-method","name":"repeated_permutations","doc":null,"summary":null,"abstract":false,"args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"}],"args_string":"(size : Int = <span class=\"k\">self</span>.size)","source_link":null,"def":{"name":"repeated_permutations","args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ary = [] of Array(T)\neach_repeated_permutation(size) do |a|\n  ary << a\nend\nary\n"}},{"id":"replace(other:Array)-instance-method","html_id":"replace(other:Array)-instance-method","name":"replace","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array"}],"args_string":"(other : Array)","source_link":null,"def":{"name":"replace","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@size = other.size\nif @size > @capacity\n  resize_to_capacity(Math.pw2ceil(@size))\nend\n@buffer.copy_from(other.to_unsafe, other.size)\nself\n"}},{"id":"reverse-instance-method","html_id":"reverse-instance-method","name":"reverse","doc":"Returns an array with all the elements in the collection reversed.\n\n```\na = [1, 2, 3]\na.reverse # => [3, 2, 1]\n```","summary":"<p>Returns an array with all the elements in the collection reversed.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"reverse","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Array(T).new(size) do |i|\n  @buffer[(size - i) - 1]\nend"}},{"id":"reverse!-instance-method","html_id":"reverse!-instance-method","name":"reverse!","doc":"Reverses in-place all the elements of `self`.","summary":"<p>Reverses in-place all the elements of <code>self</code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"reverse!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(Slice.new(@buffer, size)).reverse!\nself\n"}},{"id":"rotate(n=1)-instance-method","html_id":"rotate(n=1)-instance-method","name":"rotate","doc":null,"summary":null,"abstract":false,"args":[{"name":"n","doc":null,"default_value":"1","external_name":"n","restriction":""}],"args_string":"(n = <span class=\"n\">1</span>)","source_link":null,"def":{"name":"rotate","args":[{"name":"n","doc":null,"default_value":"1","external_name":"n","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if size == 0\n  return self\nend\nn = n % size\nif n == 0\n  return self\nend\nres = Array(T).new(size)\nres.to_unsafe.copy_from(@buffer + n, size - n)\n((res.to_unsafe + size) - n).copy_from(@buffer, n)\nres.size = size\nres\n"}},{"id":"rotate!(n=1)-instance-method","html_id":"rotate!(n=1)-instance-method","name":"rotate!","doc":null,"summary":null,"abstract":false,"args":[{"name":"n","doc":null,"default_value":"1","external_name":"n","restriction":""}],"args_string":"(n = <span class=\"n\">1</span>)","source_link":null,"def":{"name":"rotate!","args":[{"name":"n","doc":null,"default_value":"1","external_name":"n","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if size == 0\n  return self\nend\nn = n % size\nif n == 0\n  return self\nend\nif n <= (size // 2)\n  tmp = self[0..n]\n  @buffer.move_from(@buffer + n, size - n)\n  ((@buffer + size) - n).copy_from(tmp.to_unsafe, n)\nelse\n  tmp = self[n..-1]\n  ((@buffer + size) - n).move_from(@buffer, n)\n  @buffer.copy_from(tmp.to_unsafe, size - n)\nend\nself\n"}},{"id":"sample(n:Int,random=Random::DEFAULT)-instance-method","html_id":"sample(n:Int,random=Random::DEFAULT)-instance-method","name":"sample","doc":"Returns *n* number of random elements from `self`, using the given *random* number generator.\nRaises IndexError if `self` is empty.\n\n```\na = [1, 2, 3]\na.sample(2)                # => [2, 1]\na.sample(2, Random.new(1)) # => [1, 3]\n```","summary":"<p>Returns <em>n</em> number of random elements from <code>self</code>, using the given <em>random</em> number generator.</p>","abstract":false,"args":[{"name":"n","doc":null,"default_value":"","external_name":"n","restriction":"Int"},{"name":"random","doc":null,"default_value":"Random::DEFAULT","external_name":"random","restriction":""}],"args_string":"(n : Int, random = <span class=\"t\">Random</span><span class=\"t\">::</span><span class=\"t\">DEFAULT</span>)","source_link":null,"def":{"name":"sample","args":[{"name":"n","doc":null,"default_value":"","external_name":"n","restriction":"Int"},{"name":"random","doc":null,"default_value":"Random::DEFAULT","external_name":"random","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if n < 0\n  raise(ArgumentError.new(\"Can't get negative count sample\"))\nend\ncase n\nwhen 0\n  return [] of T\nwhen 1\n  return [sample(random)] of T\nelse\n  if n >= size\n    return dup.shuffle!(random)\n  end\n  ary = Array(T).new(n) do |i|\n    @buffer[i]\n  end\n  buffer = ary.to_unsafe\n  n.upto(size - 1) do |i|\n    j = random.rand(i + 1)\n    if j <= n\n      buffer[j] = @buffer[i]\n    end\n  end\n  ary.shuffle!(random)\n  ary\nend\n"}},{"id":"select!(pattern)-instance-method","html_id":"select!(pattern)-instance-method","name":"select!","doc":"Modifies `self`, keeping only the elements in the collection for which\n`pattern === element`.\n\n```\nary = [1, 6, 2, 4, 8]\nary.select!(3..7)\nary # => [6, 4]\n```\n\nSee also: `Array#reject!`.","summary":"<p>Modifies <code>self</code>, keeping only the elements in the collection for which <code>pattern === element</code>.</p>","abstract":false,"args":[{"name":"pattern","doc":null,"default_value":"","external_name":"pattern","restriction":""}],"args_string":"(pattern)","source_link":null,"def":{"name":"select!","args":[{"name":"pattern","doc":null,"default_value":"","external_name":"pattern","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self.select! do |elem|\n  pattern === elem\nend"}},{"id":"select!(&block)-instance-method","html_id":"select!(&amp;block)-instance-method","name":"select!","doc":"Modifies `self`, keeping only the elements in the collection for which the\npassed block returns `true`. Returns `self`.\n\n```\nary = [1, 6, 2, 4, 8]\nary.select! { |x| x > 3 }\nary # => [6, 4, 8]\n```\n\nSee also: `Array#select`.","summary":"<p>Modifies <code>self</code>, keeping only the elements in the collection for which the passed block returns <code>true</code>.</p>","abstract":false,"args":[],"args_string":"(&block)","source_link":null,"def":{"name":"select!","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"reject! do |elem|\n  !(yield elem)\nend"}},{"id":"shift-instance-method","html_id":"shift-instance-method","name":"shift","doc":"Removes the first value of `self`, at index 0. This method returns the removed value.\nIf the array is empty, it raises `IndexError`.\n\n```\na = [\"a\", \"b\", \"c\"]\na.shift # => \"a\"\na       # => [\"b\", \"c\"]\n```","summary":"<p>Removes the first value of <code>self</code>, at index 0.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"shift","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"shift do\n  raise(IndexError.new)\nend"}},{"id":"shift(n:Int)-instance-method","html_id":"shift(n:Int)-instance-method","name":"shift","doc":"Removes the first *n* values of `self`, starting at index 0.\nThis method returns an array of the removed values.\n\nIf *n* is greater than the size of `self`, all values will be removed from `self`\nwithout raising an error.\n\n```\na = [\"a\", \"b\", \"c\"]\na.shift # => \"a\"\na       # => [\"b\", \"c\"]\n\na = [\"a\", \"b\", \"c\"]\na.shift(4) # => [\"a\", \"b\", \"c\"]\na          # => []\n```","summary":"<p>Removes the first <em>n</em> values of <code>self</code>, starting at index 0.</p>","abstract":false,"args":[{"name":"n","doc":null,"default_value":"","external_name":"n","restriction":"Int"}],"args_string":"(n : Int)","source_link":null,"def":{"name":"shift","args":[{"name":"n","doc":null,"default_value":"","external_name":"n","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if n < 0\n  raise(ArgumentError.new(\"Can't shift negative count\"))\nend\nn = Math.min(n, @size)\nary = Array(T).new(n) do |i|\n  @buffer[i]\nend\n@buffer.move_from(@buffer + n, @size - n)\n@size = @size - n\n(@buffer + @size).clear(n)\nary\n"}},{"id":"shift(&block)-instance-method","html_id":"shift(&amp;block)-instance-method","name":"shift","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"(&block)","source_link":null,"def":{"name":"shift","args":[],"double_splat":null,"splat_index":null,"yields":0,"block_arg":null,"return_type":"","visibility":"Public","body":"if @size == 0\n  yield\nelse\n  value = @buffer[0]\n  @size = @size - 1\n  @buffer.move_from(@buffer + 1, @size)\n  (@buffer + @size).clear\n  value\nend"}},{"id":"shift?-instance-method","html_id":"shift?-instance-method","name":"shift?","doc":"Removes the first value of `self`, at index 0. This method returns the removed value.\nIf the array is empty, it returns `nil` without raising any error.\n\n```\na = [\"a\", \"b\"]\na.shift? # => \"a\"\na        # => [\"b\"]\na.shift? # => \"b\"\na        # => []\na.shift? # => nil\na        # => []\n```","summary":"<p>Removes the first value of <code>self</code>, at index 0.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"shift?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"shift do\n  nil\nend"}},{"id":"shuffle(random=Random::DEFAULT)-instance-method","html_id":"shuffle(random=Random::DEFAULT)-instance-method","name":"shuffle","doc":"Returns an array with all the elements in the collection randomized\nusing the given *random* number generator.","summary":"<p>Returns an array with all the elements in the collection randomized using the given <em>random</em> number generator.</p>","abstract":false,"args":[{"name":"random","doc":null,"default_value":"Random::DEFAULT","external_name":"random","restriction":""}],"args_string":"(random = <span class=\"t\">Random</span><span class=\"t\">::</span><span class=\"t\">DEFAULT</span>)","source_link":null,"def":{"name":"shuffle","args":[{"name":"random","doc":null,"default_value":"Random::DEFAULT","external_name":"random","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"dup.shuffle!(random)"}},{"id":"shuffle!(random=Random::DEFAULT)-instance-method","html_id":"shuffle!(random=Random::DEFAULT)-instance-method","name":"shuffle!","doc":"Modifies `self` by randomizing the order of elements in the collection\nusing the given *random* number generator. Returns `self`.","summary":"<p>Modifies <code>self</code> by randomizing the order of elements in the collection using the given <em>random</em> number generator.</p>","abstract":false,"args":[{"name":"random","doc":null,"default_value":"Random::DEFAULT","external_name":"random","restriction":""}],"args_string":"(random = <span class=\"t\">Random</span><span class=\"t\">::</span><span class=\"t\">DEFAULT</span>)","source_link":null,"def":{"name":"shuffle!","args":[{"name":"random","doc":null,"default_value":"Random::DEFAULT","external_name":"random","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@buffer.shuffle!(size, random)\nself\n"}},{"id":"size:Int32-instance-method","html_id":"size:Int32-instance-method","name":"size","doc":"Returns the number of elements in the array.\n\n```\n[:foo, :bar].size # => 2\n```","summary":"<p>Returns the number of elements in the array.</p>","abstract":false,"args":[],"args_string":" : Int32","source_link":null,"def":{"name":"size","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":"@size"}},{"id":"skip(count:Int):Array(T)-instance-method","html_id":"skip(count:Int):Array(T)-instance-method","name":"skip","doc":"Returns an `Array` with the first *count* elements removed\nfrom the original array.\n\nIf *count* is bigger than the number of elements in the array, returns an empty array.\n\n```\n[1, 2, 3, 4, 5, 6].skip(3) # => [4, 5, 6]\n```","summary":"<p>Returns an <code><a href=\"Array.html\">Array</a></code> with the first <em>count</em> elements removed from the original array.</p>","abstract":false,"args":[{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"args_string":"(count : Int) : Array(T)","source_link":null,"def":{"name":"skip","args":[{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Array(T)","visibility":"Public","body":"if count < 0\n  raise(ArgumentError.new(\"Attempt to skip negative size\"))\nend\nnew_size = Math.max(size - count, 0)\nArray(T).build(new_size) do |buffer|\n  buffer.copy_from(to_unsafe + count, new_size)\n  new_size\nend\n"}},{"id":"sort:Array(T)-instance-method","html_id":"sort:Array(T)-instance-method","name":"sort","doc":"Returns a new array with all elements sorted based on the return value of\ntheir comparison method `#<=>`\n\n```\na = [3, 1, 2]\na.sort # => [1, 2, 3]\na      # => [3, 1, 2]\n```","summary":"<p>Returns a new array with all elements sorted based on the return value of their comparison method <code><a href=\"Array.html#(other:Array)-instance-method\">#<=></a></code></p>","abstract":false,"args":[],"args_string":" : Array(T)","source_link":null,"def":{"name":"sort","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Array(T)","visibility":"Public","body":"dup.sort!"}},{"id":"sort(&block:T,T->U):Array(T)forallU-instance-method","html_id":"sort(&amp;block:T,T-&gt;U):Array(T)forallU-instance-method","name":"sort","doc":"Returns a new array with all elements sorted based on the comparator in the\ngiven block.\n\nThe block must implement a comparison between two elements *a* and *b*,\nwhere `a < b` returns `-1`, `a == b` returns `0`, and `a > b` returns `1`.\nThe comparison operator `<=>` can be used for this.\n\n```\na = [3, 1, 2]\nb = a.sort { |a, b| b <=> a }\n\nb # => [3, 2, 1]\na # => [3, 1, 2]\n```","summary":"<p>Returns a new array with all elements sorted based on the comparator in the given block.</p>","abstract":false,"args":[],"args_string":"(&block : T, T -> U) : Array(T) forall U","source_link":null,"def":{"name":"sort","args":[],"double_splat":null,"splat_index":null,"yields":2,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":"(T, T -> U)"},"return_type":"Array(T)","visibility":"Public","body":"{% if U <= ::Union(Int32, ::Nil) %}{% else %}\n      {% raise(\"expected block to return Int32 or Nil, not #{U}\") %}\n    {% end %}\ndup.sort!(&block)\n"}},{"id":"sort!:Array(T)-instance-method","html_id":"sort!:Array(T)-instance-method","name":"sort!","doc":"Modifies `self` by sorting all elements based on the return value of their\ncomparison method `#<=>`\n\n```\na = [3, 1, 2]\na.sort!\na # => [1, 2, 3]\n```","summary":"<p>Modifies <code>self</code> by sorting all elements based on the return value of their comparison method <code><a href=\"Array.html#(other:Array)-instance-method\">#<=></a></code></p>","abstract":false,"args":[],"args_string":" : Array(T)","source_link":null,"def":{"name":"sort!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Array(T)","visibility":"Public","body":"(Slice.new(to_unsafe, size)).sort!\nself\n"}},{"id":"sort!(&block:T,T->U):Array(T)forallU-instance-method","html_id":"sort!(&amp;block:T,T-&gt;U):Array(T)forallU-instance-method","name":"sort!","doc":"Modifies `self` by sorting all elements based on the comparator in the given\nblock.\n\nThe given block must implement a comparison between two elements\n*a* and *b*, where `a < b` returns `-1`, `a == b` returns `0`,\nand `a > b` returns `1`.\nThe comparison operator `<=>` can be used for this.\n\n```\na = [3, 1, 2]\na.sort! { |a, b| b <=> a }\na # => [3, 2, 1]\n```","summary":"<p>Modifies <code>self</code> by sorting all elements based on the comparator in the given block.</p>","abstract":false,"args":[],"args_string":"(&block : T, T -> U) : Array(T) forall U","source_link":null,"def":{"name":"sort!","args":[],"double_splat":null,"splat_index":null,"yields":2,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":"(T, T -> U)"},"return_type":"Array(T)","visibility":"Public","body":"{% if U <= ::Union(Int32, ::Nil) %}{% else %}\n      {% raise(\"expected block to return Int32 or Nil, not #{U}\") %}\n    {% end %}\n(Slice.new(to_unsafe, size)).sort!(&block)\nself\n"}},{"id":"sort_by(&block:T->UNDERSCORE):Array(T)-instance-method","html_id":"sort_by(&amp;block:T-&gt;UNDERSCORE):Array(T)-instance-method","name":"sort_by","doc":"Returns a new array with all elements sorted. The given block is called for\neach element, then the comparison method #<=> is called on the object\nreturned from the block to determine sort order.\n\n```\na = %w(apple pear fig)\nb = a.sort_by { |word| word.size }\nb # => [\"fig\", \"pear\", \"apple\"]\na # => [\"apple\", \"pear\", \"fig\"]\n```","summary":"<p>Returns a new array with all elements sorted.</p>","abstract":false,"args":[],"args_string":"(&block : T -> UNDERSCORE) : Array(T)","source_link":null,"def":{"name":"sort_by","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":"(T -> _)"},"return_type":"Array(T)","visibility":"Public","body":"dup.sort_by! do |e|\n  yield e\nend"}},{"id":"sort_by!(&block:T->UNDERSCORE):Array(T)-instance-method","html_id":"sort_by!(&amp;block:T-&gt;UNDERSCORE):Array(T)-instance-method","name":"sort_by!","doc":"Modifies `self` by sorting all elements. The given block is called for\neach element, then the comparison method #<=> is called on the object\nreturned from the block to determine sort order.\n\n```\na = %w(apple pear fig)\na.sort_by! { |word| word.size }\na # => [\"fig\", \"pear\", \"apple\"]\n```","summary":"<p>Modifies <code>self</code> by sorting all elements.</p>","abstract":false,"args":[],"args_string":"(&block : T -> UNDERSCORE) : Array(T)","source_link":null,"def":{"name":"sort_by!","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":"(T -> _)"},"return_type":"Array(T)","visibility":"Public","body":"sorted = map do |e|\n  {e, yield e}\nend.sort! do |x, y|\n  x[1] <=> y[1]\nend\n@size.times do |i|\n  @buffer[i] = sorted.to_unsafe[i][0]\nend\nself\n"}},{"id":"swap(index0,index1):Array(T)-instance-method","html_id":"swap(index0,index1):Array(T)-instance-method","name":"swap","doc":"Swaps the elements at *index0* and *index1* and returns `self`.\nRaises an `IndexError` if either index is out of bounds.\n\n```\na = [\"first\", \"second\", \"third\"]\na.swap(1, 2)  # => [\"first\", \"third\", \"second\"]\na             # => [\"first\", \"third\", \"second\"]\na.swap(0, -1) # => [\"second\", \"third\", \"first\"]\na             # => [\"second\", \"third\", \"first\"]\na.swap(2, 3)  # => raises \"Index out of bounds (IndexError)\"\n```","summary":"<p>Swaps the elements at <em>index0</em> and <em>index1</em> and returns <code>self</code>.</p>","abstract":false,"args":[{"name":"index0","doc":null,"default_value":"","external_name":"index0","restriction":""},{"name":"index1","doc":null,"default_value":"","external_name":"index1","restriction":""}],"args_string":"(index0, index1) : Array(T)","source_link":null,"def":{"name":"swap","args":[{"name":"index0","doc":null,"default_value":"","external_name":"index0","restriction":""},{"name":"index1","doc":null,"default_value":"","external_name":"index1","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Array(T)","visibility":"Public","body":"if index0 < 0\n  index0 = index0 + size\nend\nif index1 < 0\n  index1 = index1 + size\nend\nif (0 <= index0 && index0 < size) && (0 <= index1 && index1 < size)\nelse\n  raise(IndexError.new)\nend\n@buffer[index0], @buffer[index1] = @buffer[index1], @buffer[index0]\nself\n"}},{"id":"to_a-instance-method","html_id":"to_a-instance-method","name":"to_a","doc":"Returns an `Array` with all the elements in the collection.\n\n```\n{1, 2, 3}.to_a # => [1, 2, 3]\n```","summary":"<p>Returns an <code><a href=\"Array.html\">Array</a></code> with all the elements in the collection.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_a","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"to_json(json:JSON::Builder)-instance-method","html_id":"to_json(json:JSON::Builder)-instance-method","name":"to_json","doc":null,"summary":null,"abstract":false,"args":[{"name":"json","doc":null,"default_value":"","external_name":"json","restriction":"JSON::Builder"}],"args_string":"(json : JSON::Builder)","source_link":null,"def":{"name":"to_json","args":[{"name":"json","doc":null,"default_value":"","external_name":"json","restriction":"JSON::Builder"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"json.array do\n  each(&.to_json(json))\nend"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Appends a short String representation of this object\nwhich includes its class name and its object address.\n\n```\nclass Person\n  def initialize(@name : String, @age : Int32)\n  end\nend\n\nPerson.new(\"John\", 32).to_s # => #<Person:0x10a199f20>\n```","summary":"<p>Appends a short String representation of this object which includes its class name and its object address.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"executed = exec_recursive(:to_s) do\n  io << '['\n  join(\", \", io, &.inspect(io))\n  io << ']'\nend\nif executed\nelse\n  io << \"[...]\"\nend\n"}},{"id":"to_unsafe:Pointer(T)-instance-method","html_id":"to_unsafe:Pointer(T)-instance-method","name":"to_unsafe","doc":"Returns a pointer to the internal buffer where `self`'s elements are stored.\n\nThis method is **unsafe** because it returns a pointer, and the pointed might eventually\nnot be that of `self` if the array grows and its internal buffer is reallocated.\n\n```\nary = [1, 2, 3]\nary.to_unsafe[0] # => 1\n```","summary":"<p>Returns a pointer to the internal buffer where <code>self</code>'s elements are stored.</p>","abstract":false,"args":[],"args_string":" : Pointer(T)","source_link":null,"def":{"name":"to_unsafe","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Pointer(T)","visibility":"Public","body":"@buffer"}},{"id":"to_yaml(yaml:YAML::Nodes::Builder)-instance-method","html_id":"to_yaml(yaml:YAML::Nodes::Builder)-instance-method","name":"to_yaml","doc":null,"summary":null,"abstract":false,"args":[{"name":"yaml","doc":null,"default_value":"","external_name":"yaml","restriction":"YAML::Nodes::Builder"}],"args_string":"(yaml : YAML::Nodes::Builder)","source_link":null,"def":{"name":"to_yaml","args":[{"name":"yaml","doc":null,"default_value":"","external_name":"yaml","restriction":"YAML::Nodes::Builder"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"yaml.sequence(reference: self) do\n  each(&.to_yaml(yaml))\nend"}},{"id":"transpose-instance-method","html_id":"transpose-instance-method","name":"transpose","doc":"Assumes that `self` is an array of arrays and transposes the rows and columns.\n\n```\na = [[:a, :b], [:c, :d], [:e, :f]]\na.transpose # => [[:a, :c, :e], [:b, :d, :f]]\na           # => [[:a, :b], [:c, :d], [:e, :f]]\n```","summary":"<p>Assumes that <code>self</code> is an array of arrays and transposes the rows and columns.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"transpose","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if empty?\n  return Array(Array(typeof(first.first))).new\nend\nlen = self[0].size\n(1...@size).each do |i|\n  l = self[i].size\n  if len != l\n    raise(IndexError.new)\n  end\nend\nArray(Array(typeof(first.first))).new(len) do |i|\n  Array(typeof(first.first)).new(@size) do |j|\n    self[j][i]\n  end\nend\n"}},{"id":"uniq-instance-method","html_id":"uniq-instance-method","name":"uniq","doc":"Returns a new `Array` by removing duplicate values in `self`.\n\n```\na = [\"a\", \"a\", \"b\", \"b\", \"c\"]\na.uniq # => [\"a\", \"b\", \"c\"]\na      # => [ \"a\", \"a\", \"b\", \"b\", \"c\" ]\n```","summary":"<p>Returns a new <code><a href=\"Array.html\">Array</a></code> by removing duplicate values in <code>self</code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"uniq","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if size <= 1\n  return dup\nend\nif size <= SMALL_ARRAY_SIZE\n  ary = Array(T).new\n  each do |elem|\n    if ary.includes?(elem)\n    else\n      ary << elem\n    end\n  end\n  return ary\nend\nto_lookup_hash.values\n"}},{"id":"uniq(&block:T->UNDERSCORE)-instance-method","html_id":"uniq(&amp;block:T-&gt;UNDERSCORE)-instance-method","name":"uniq","doc":"Returns a new `Array` by removing duplicate values in `self`, using the block's\nvalue for comparison.\n\n```\na = [{\"student\", \"sam\"}, {\"student\", \"george\"}, {\"teacher\", \"matz\"}]\na.uniq { |s| s[0] } # => [{\"student\", \"sam\"}, {\"teacher\", \"matz\"}]\na                   # => [{\"student\", \"sam\"}, {\"student\", \"george\"}, {\"teacher\", \"matz\"}]\n```","summary":"<p>Returns a new <code><a href=\"Array.html\">Array</a></code> by removing duplicate values in <code>self</code>, using the block's value for comparison.</p>","abstract":false,"args":[],"args_string":"(&block : T -> UNDERSCORE)","source_link":null,"def":{"name":"uniq","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":"(T -> _)"},"return_type":"","visibility":"Public","body":"if size <= 1\n  dup\nelse\n  hash = to_lookup_hash do |elem|\n    yield elem\n  end\n  hash.values\nend"}},{"id":"uniq!-instance-method","html_id":"uniq!-instance-method","name":"uniq!","doc":"Removes duplicate elements from `self`. Returns `self`.\n\n```\na = [\"a\", \"a\", \"b\", \"b\", \"c\"]\na.uniq! # => [\"a\", \"b\", \"c\"]\na       # => [\"a\", \"b\", \"c\"]\n```","summary":"<p>Removes duplicate elements from <code>self</code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"uniq!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if size <= 1\n  return self\nend\nif size <= SMALL_ARRAY_SIZE\n  internal_delete do |elem, index|\n    (0...index).any? do |subindex|\n      elem == to_unsafe[subindex]\n    end\n  end\n  return self\nend\nuniq!(&.itself)\n"}},{"id":"uniq!(&block)-instance-method","html_id":"uniq!(&amp;block)-instance-method","name":"uniq!","doc":"Removes duplicate elements from `self`, using the block's value for comparison. Returns `self`.\n\n```\na = [{\"student\", \"sam\"}, {\"student\", \"george\"}, {\"teacher\", \"matz\"}]\na.uniq! { |s| s[0] } # => [{\"student\", \"sam\"}, {\"teacher\", \"matz\"}]\na                    # => [{\"student\", \"sam\"}, {\"teacher\", \"matz\"}]\n```","summary":"<p>Removes duplicate elements from <code>self</code>, using the block's value for comparison.</p>","abstract":false,"args":[],"args_string":"(&block)","source_link":null,"def":{"name":"uniq!","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"if size <= 1\n  return self\nend\nhash = to_lookup_hash do |elem|\n  yield elem\nend\nif size == hash.size\n  return self\nend\nold_size = @size\n@size = hash.size\nremoved = old_size - @size\nif removed == 0\n  return self\nend\nptr = @buffer\nhash.each do |k, v|\n  ptr.value = v\n  ptr = ptr + 1\nend\n(@buffer + @size).clear(removed)\nself\n"}},{"id":"unsafe_fetch(index:Int)-instance-method","html_id":"unsafe_fetch(index:Int)-instance-method","name":"unsafe_fetch","doc":"Returns the element at the given *index*, without doing any bounds check.\n\n`Indexable` makes sure to invoke this method with *index* in `0...size`,\nso converting negative indices to positive ones is not needed here.\n\nClients never invoke this method directly. Instead, they access\nelements with `#[](index)` and `#[]?(index)`.\n\nThis method should only be directly invoked if you are absolutely\nsure the index is in bounds, to avoid a bounds check for a small boost\nof performance.","summary":"<p>Returns the element at the given <em>index</em>, without doing any bounds check.</p>","abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"}],"args_string":"(index : Int)","source_link":null,"def":{"name":"unsafe_fetch","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@buffer[index]"}},{"id":"unshift(obj:T)-instance-method","html_id":"unshift(obj:T)-instance-method","name":"unshift","doc":"Prepend. Adds *obj* to the beginning of `self`, given that the type of the value is *T*\n(which might be a single type or a union of types).\nThis method returns `self`, so several calls can be chained.\nSee `shift` for the opposite effect.\n\n```\na = [\"a\", \"b\"]\na.unshift(\"c\") # => [\"c\", \"a\", \"b\"]\na.unshift(1)   # Errors, because the array only accepts String.\n\na = [\"a\", \"b\"] of (Int32 | String)\na.unshift(\"c\") # => [\"c\", \"a\", \"b\"]\na.unshift(1)   # => [1, \"c\", \"a\", \"b\"]\n```","summary":"<p>Prepend.</p>","abstract":false,"args":[{"name":"obj","doc":null,"default_value":"","external_name":"obj","restriction":"T"}],"args_string":"(obj : T)","source_link":null,"def":{"name":"unshift","args":[{"name":"obj","doc":null,"default_value":"","external_name":"obj","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"insert(0, obj)"}},{"id":"unshift(*values:T)-instance-method","html_id":"unshift(*values:T)-instance-method","name":"unshift","doc":"Prepend multiple values. The same as `unshift`, but takes an arbitrary number\nof values to add to the array. Returns `self`.","summary":"<p>Prepend multiple values.</p>","abstract":false,"args":[{"name":"values","doc":null,"default_value":"","external_name":"values","restriction":"T"}],"args_string":"(*values : T)","source_link":null,"def":{"name":"unshift","args":[{"name":"values","doc":null,"default_value":"","external_name":"values","restriction":"T"}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"new_size = @size + values.size\nif new_size > @capacity\n  resize_to_capacity(Math.pw2ceil(new_size))\nend\nmove_value = values.size\n@buffer.move_to(@buffer + move_value, @size)\nvalues.each_with_index do |value, i|\n  @buffer[i] = value\nend\n@size = new_size\nself\n"}},{"id":"update(index:Int,&block)-instance-method","html_id":"update(index:Int,&amp;block)-instance-method","name":"update","doc":null,"summary":null,"abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"}],"args_string":"(index : Int, &block)","source_link":null,"def":{"name":"update","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"index = check_index_out_of_bounds(index)\n@buffer[index] = yield @buffer[index]\n"}},{"id":"|(other:Array(U))forallU-instance-method","html_id":"|(other:Array(U))forallU-instance-method","name":"|","doc":"Set union: returns a new `Array` by joining `self` with *other*, excluding\nany duplicates, and preserving the order from `self`.\n\n```\n[\"a\", \"b\", \"c\"] | [\"c\", \"d\", \"a\"] # => [ \"a\", \"b\", \"c\", \"d\" ]\n```\n\nSee also: `#uniq`.","summary":"<p>Set union: returns a new <code><a href=\"Array.html\">Array</a></code> by joining <code>self</code> with <em>other</em>, excluding any duplicates, and preserving the order from <code>self</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array(U)"}],"args_string":"(other : Array(U)) forall U","source_link":null,"def":{"name":"|","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array(U)"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if (size + other.size) <= SMALL_ARRAY_SIZE\n  ary = Array(T | U).new\n  each do |elem|\n    if ary.includes?(elem)\n    else\n      ary << elem\n    end\n  end\n  other.each do |elem|\n    if ary.includes?(elem)\n    else\n      ary << elem\n    end\n  end\n  return ary\nend\nArray(T | U).build(size + other.size) do |buffer|\n  hash = Hash(T, Bool).new\n  i = 0\n  each do |obj|\n    if hash.has_key?(obj)\n    else\n      buffer[i] = obj\n      hash[obj] = true\n      i = i + 1\n    end\n  end\n  other.each do |obj|\n    if hash.has_key?(obj)\n    else\n      buffer[i] = obj\n      hash[obj] = true\n      i = i + 1\n    end\n  end\n  i\nend\n"}}],"macros":[],"types":[]},{"html_id":"/Atomic","path":"Atomic.html","kind":"struct","full_name":"Atomic(T)","name":"Atomic","abstract":false,"superclass":{"html_id":"/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"A value that may be updated atomically.\n\nOnly primitive integer types, reference types or nilable reference types\ncan be used with an Atomic type.","summary":"<p>A value that may be updated atomically.</p>","class_methods":[],"constructors":[{"id":"new(value:T)-class-method","html_id":"new(value:T)-class-method","name":"new","doc":"Creates an Atomic with the given initial value.","summary":"<p>Creates an Atomic with the given initial value.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","source_link":null,"def":{"name":"new","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = Atomic(T).allocate\n_.initialize(value)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"add(value:T)-instance-method","html_id":"add(value:T)-instance-method","name":"add","doc":"Performs `atomic_value += value`. Returns the old value.\n\n```\natomic = Atomic.new(1)\natomic.add(2) # => 1\natomic.get    # => 3\n```","summary":"<p>Performs <code>atomic_value += value</code>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","source_link":null,"def":{"name":"add","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Ops.atomicrmw(:add, pointerof(@value), value, :sequentially_consistent, false)"}},{"id":"and(value:T)-instance-method","html_id":"and(value:T)-instance-method","name":"and","doc":"Performs `atomic_value &= value`. Returns the old value.\n\n```\natomic = Atomic.new(5)\natomic.and(3) # => 5\natomic.get    # => 1\n```","summary":"<p>Performs <code>atomic_value &= value</code>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","source_link":null,"def":{"name":"and","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Ops.atomicrmw(:and, pointerof(@value), value, :sequentially_consistent, false)"}},{"id":"compare_and_set(cmp:T,new:T):Tuple(T,Bool)-instance-method","html_id":"compare_and_set(cmp:T,new:T):Tuple(T,Bool)-instance-method","name":"compare_and_set","doc":"Compares this atomic's value with *cmp*:\n\n* if they are equal, sets the value to *new*, and returns `{old_value, true}`\n* if they are not equal the value remains the same, and returns `{old_value, false}`\n\n```\natomic = Atomic.new(1)\n\natomic.compare_and_set(2, 3) # => {1, false}\natomic.get                   # => 1\n\natomic.compare_and_set(1, 3) # => {1, true}\natomic.get                   # => 3\n```","summary":"<p>Compares this atomic's value with <em>cmp</em>:</p>","abstract":false,"args":[{"name":"cmp","doc":null,"default_value":"","external_name":"cmp","restriction":"T"},{"name":"new","doc":null,"default_value":"","external_name":"new","restriction":"T"}],"args_string":"(cmp : T, new : T) : Tuple(T, Bool)","source_link":null,"def":{"name":"compare_and_set","args":[{"name":"cmp","doc":null,"default_value":"","external_name":"cmp","restriction":"T"},{"name":"new","doc":null,"default_value":"","external_name":"new","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"::Tuple(T, Bool)","visibility":"Public","body":"{% if T.union? && T.union_types.all? do |t|\n  (t == Nil) || t < Reference\nend %}\n      # If so, use addresses because LLVM < 3.9 doesn't support cmpxchg with pointers\n      address, success = Ops.cmpxchg(pointerof(@value).as(LibC::SizeT*), LibC::SizeT.new(cmp.as(T).object_id), LibC::SizeT.new(new.as(T).object_id), :sequentially_consistent, :sequentially_consistent)\n      {address == 0 ? nil : Pointer(T).new(address).as(T), success}\n      # Check if it's a reference type\n    {% else %}{% if T < Reference %}\n      # Use addresses again (but this can't return nil)\n      address, success = Ops.cmpxchg(pointerof(@value).as(LibC::SizeT*), LibC::SizeT.new(cmp.as(T).object_id), LibC::SizeT.new(new.as(T).object_id), :sequentially_consistent, :sequentially_consistent)\n      {Pointer(T).new(address).as(T), success}\n    {% else %}\n      # Otherwise, this is an integer type\n      Ops.cmpxchg(pointerof(@value), cmp, new, :sequentially_consistent, :sequentially_consistent)\n    {% end %}{% end %}"}},{"id":"get-instance-method","html_id":"get-instance-method","name":"get","doc":"Atomically returns this atomic's value.","summary":"<p>Atomically returns this atomic's value.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"get","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Ops.load(pointerof(@value), :sequentially_consistent, true)"}},{"id":"lazy_get-instance-method","html_id":"lazy_get-instance-method","name":"lazy_get","doc":"**Non-atomically** returns this atomic's value.","summary":"<p><strong>Non-atomically</strong> returns this atomic's value.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"lazy_get","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@value"}},{"id":"lazy_set(value:T)-instance-method","html_id":"lazy_set(value:T)-instance-method","name":"lazy_set","doc":"**Non-atomically** sets this atomic's value to *value*. Returns the **new** value.\n\n```\natomic = Atomic.new(5)\natomic.lazy_set(10) # => 10\natomic.get          # => 10\n```","summary":"<p><strong>Non-atomically</strong> sets this atomic's value to <em>value</em>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","source_link":null,"def":{"name":"lazy_set","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@value = value"}},{"id":"max(value:T)-instance-method","html_id":"max(value:T)-instance-method","name":"max","doc":"Performs `atomic_value = max(atomic_value, value)`. Returns the old value.\n\n```\natomic = Atomic.new(5)\n\natomic.max(3) # => 5\natomic.get    # => 5\n\natomic.max(10) # => 5\natomic.get     # => 10\n```","summary":"<p>Performs <code>atomic_value = max(atomic_value, value)</code>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","source_link":null,"def":{"name":"max","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% if T < Int::Signed %}\n      Ops.atomicrmw(:max, pointerof(@value), value, :sequentially_consistent, false)\n    {% else %}\n      Ops.atomicrmw(:umax, pointerof(@value), value, :sequentially_consistent, false)\n    {% end %}"}},{"id":"min(value:T)-instance-method","html_id":"min(value:T)-instance-method","name":"min","doc":"Performs `atomic_value = min(atomic_value, value)`. Returns the old value.\n\n```\natomic = Atomic.new(5)\n\natomic.min(10) # => 5\natomic.get     # => 5\n\natomic.min(3) # => 5\natomic.get    # => 3\n```","summary":"<p>Performs <code>atomic_value = min(atomic_value, value)</code>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","source_link":null,"def":{"name":"min","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% if T < Int::Signed %}\n      Ops.atomicrmw(:min, pointerof(@value), value, :sequentially_consistent, false)\n    {% else %}\n      Ops.atomicrmw(:umin, pointerof(@value), value, :sequentially_consistent, false)\n    {% end %}"}},{"id":"nand(value:T)-instance-method","html_id":"nand(value:T)-instance-method","name":"nand","doc":"Performs `atomic_value = ~(atomic_value & value)`. Returns the old value.\n\n```\natomic = Atomic.new(5)\natomic.nand(3) # => 5\natomic.get     # => -2\n```","summary":"<p>Performs <code>atomic_value = ~(atomic_value & value)</code>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","source_link":null,"def":{"name":"nand","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Ops.atomicrmw(:nand, pointerof(@value), value, :sequentially_consistent, false)"}},{"id":"or(value:T)-instance-method","html_id":"or(value:T)-instance-method","name":"or","doc":"Performs `atomic_value |= value`. Returns the old value.\n\n```\natomic = Atomic.new(5)\natomic.or(2) # => 5\natomic.get   # => 7\n```","summary":"<p>Performs <code>atomic_value |= value</code>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","source_link":null,"def":{"name":"or","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Ops.atomicrmw(:or, pointerof(@value), value, :sequentially_consistent, false)"}},{"id":"set(value:T)-instance-method","html_id":"set(value:T)-instance-method","name":"set","doc":"Atomically sets this atomic's value to *value*. Returns the **new** value.\n\n```\natomic = Atomic.new(5)\natomic.set(10) # => 10\natomic.get     # => 10\n```","summary":"<p>Atomically sets this atomic's value to <em>value</em>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","source_link":null,"def":{"name":"set","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Ops.store(pointerof(@value), value.as(T), :sequentially_consistent, true)\nvalue\n"}},{"id":"sub(value:T)-instance-method","html_id":"sub(value:T)-instance-method","name":"sub","doc":"Performs `atomic_value -= value`. Returns the old value.\n\n```\natomic = Atomic.new(9)\natomic.sub(2) # => 9\natomic.get    # => 7\n```","summary":"<p>Performs <code>atomic_value -= value</code>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","source_link":null,"def":{"name":"sub","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Ops.atomicrmw(:sub, pointerof(@value), value, :sequentially_consistent, false)"}},{"id":"swap(value:T)-instance-method","html_id":"swap(value:T)-instance-method","name":"swap","doc":"Atomically sets this atomic's value to *value*. Returns the **old** value.\n\n```\natomic = Atomic.new(5)\natomic.swap(10) # => 5\natomic.get      # => 10\n```","summary":"<p>Atomically sets this atomic's value to <em>value</em>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","source_link":null,"def":{"name":"swap","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% if (T.union? && T.union_types.all? do |t|\n  (t == Nil) || t < Reference\nend) || T < Reference %}\n      address = Ops.atomicrmw(:xchg, pointerof(@value).as(LibC::SizeT*), LibC::SizeT.new(value.as(T).object_id), :sequentially_consistent, false)\n      Pointer(T).new(address).as(T)\n    {% else %}\n      Ops.atomicrmw(:xchg, pointerof(@value), value, :sequentially_consistent, false)\n    {% end %}"}},{"id":"xor(value:T)-instance-method","html_id":"xor(value:T)-instance-method","name":"xor","doc":"Performs `atomic_value ^= value`. Returns the old value.\n\n```\natomic = Atomic.new(5)\natomic.xor(3) # => 5\natomic.get    # => 6\n```","summary":"<p>Performs <code>atomic_value ^= value</code>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","source_link":null,"def":{"name":"xor","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Ops.atomicrmw(:xor, pointerof(@value), value, :sequentially_consistent, false)"}}],"macros":[],"types":[{"html_id":"/Atomic/Flag","path":"Atomic/Flag.html","kind":"struct","full_name":"Atomic::Flag","name":"Flag","abstract":false,"superclass":{"html_id":"/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Atomic","kind":"struct","full_name":"Atomic(T)","name":"Atomic"},"doc":"An atomic flag, that can be set or not.\n\nConcurrency safe. If many fibers try to set the atomic in parallel, only one\nwill succeed.\n\nExample:\n```\nflag = Atomic::Flag.new\nflag.test_and_set # => true\nflag.test_and_set # => false\nflag.clear\nflag.test_and_set # => true\n```","summary":"<p>An atomic flag, that can be set or not.</p>","class_methods":[],"constructors":[{"id":"new-class-method","html_id":"new-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"new","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"clear:Nil-instance-method","html_id":"clear:Nil-instance-method","name":"clear","doc":"Atomically clears the flag.","summary":"<p>Atomically clears the flag.</p>","abstract":false,"args":[],"args_string":" : Nil","source_link":null,"def":{"name":"clear","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"Atomic::Ops.store(pointerof(@value), 0_u8, :sequentially_consistent, true)"}},{"id":"test_and_set:Bool-instance-method","html_id":"test_and_set:Bool-instance-method","name":"test_and_set","doc":"Atomically tries to set the flag. Only succeeds and returns `true` if the\nflag wasn't previously set; returns `false` otherwise.","summary":"<p>Atomically tries to set the flag.</p>","abstract":false,"args":[],"args_string":" : Bool","source_link":null,"def":{"name":"test_and_set","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"(Atomic::Ops.atomicrmw(:xchg, pointerof(@value), 1_u8, :sequentially_consistent, false)) == 0_u8"}}],"macros":[],"types":[]}]},{"html_id":"/Base64","path":"Base64.html","kind":"module","full_name":"Base64","name":"Base64","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[{"html_id":"/Base64","kind":"module","full_name":"Base64","name":"Base64"}],"subclasses":[],"including_types":[],"namespace":null,"doc":"The `Base64` module provides for the encoding (`encode`, `strict_encode`,\n`urlsafe_encode`) and decoding (`decode`)\nof binary data using a base64 representation.\n\n### Example\n\nA simple encoding and decoding.\n\n```\nrequire \"base64\"\n\nenc = Base64.encode(\"Send reinforcements\") # => \"U2VuZCByZWluZm9yY2VtZW50cw==\\n\"\nplain = Base64.decode_string(enc)          # => \"Send reinforcements\"\n```\n\nThe purpose of using base64 to encode data is that it translates any binary\ndata into purely printable characters.","summary":"<p>The <code><a href=\"Base64.html\">Base64</a></code> module provides for the encoding (<code><a href=\"Base64.html#encode(data,io:IO)-instance-method\">#encode</a></code>, <code><a href=\"Base64.html#strict_encode(data,io:IO)-instance-method\">#strict_encode</a></code>, <code><a href=\"Base64.html#urlsafe_encode(data,io:IO)-instance-method\">#urlsafe_encode</a></code>) and decoding (<code><a href=\"Base64.html#decode(data,io:IO)-instance-method\">#decode</a></code>) of binary data using a base64 representation.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"decode(data,io:IO)-instance-method","html_id":"decode(data,io:IO)-instance-method","name":"decode","doc":"Writes the base64-decoded version of *data* to *io*.\nThis will decode either the normal or urlsafe alphabets.","summary":"<p>Writes the base64-decoded version of <em>data</em> to <em>io</em>.</p>","abstract":false,"args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""},{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(data, io : IO)","source_link":null,"def":{"name":"decode","args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""},{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"count = 0\nfrom_base64(data.to_slice) do |byte|\n  io.write_byte(byte)\n  count = count + 1\nend\nio.flush\ncount\n"}},{"id":"decode(data):Bytes-instance-method","html_id":"decode(data):Bytes-instance-method","name":"decode","doc":"Returns the base64-decoded version of *data* as a `Bytes`.\nThis will decode either the normal or urlsafe alphabets.","summary":"<p>Returns the base64-decoded version of <em>data</em> as a <code><a href=\"Bytes.html\">Bytes</a></code>.</p>","abstract":false,"args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""}],"args_string":"(data) : Bytes","source_link":null,"def":{"name":"decode","args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bytes","visibility":"Public","body":"slice = data.to_slice\nbuf = Pointer(UInt8).malloc(decode_size(slice.size))\nappender = buf.appender\nfrom_base64(slice) do |byte|\n  appender << byte\nend\nSlice.new(buf, appender.size.to_i32)\n"}},{"id":"decode_string(data):String-instance-method","html_id":"decode_string(data):String-instance-method","name":"decode_string","doc":"Returns the base64-decoded version of *data* as a string.\nThis will decode either the normal or urlsafe alphabets.","summary":"<p>Returns the base64-decoded version of <em>data</em> as a string.</p>","abstract":false,"args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""}],"args_string":"(data) : String","source_link":null,"def":{"name":"decode_string","args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"slice = data.to_slice\nString.new(decode_size(slice.size)) do |buf|\n  appender = buf.appender\n  from_base64(slice) do |byte|\n    appender << byte\n  end\n  {appender.size, 0}\nend\n"}},{"id":"encode(data,io:IO)-instance-method","html_id":"encode(data,io:IO)-instance-method","name":"encode","doc":"Writes the base64-encoded version of *data* to *io*.\nThis method complies with [RFC 2045](https://tools.ietf.org/html/rfc2045).\nLine feeds are added to every 60 encoded characters.\n\n```\nBase64.encode(\"Now is the time for all good coders\\nto learn Crystal\", STDOUT)\n```","summary":"<p>Writes the base64-encoded version of <em>data</em> to <em>io</em>.</p>","abstract":false,"args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""},{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(data, io : IO)","source_link":null,"def":{"name":"encode","args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""},{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"count = 0\nencode_with_new_lines(data.to_slice) do |byte|\n  io.write_byte(byte)\n  count = count + 1\nend\nio.flush\ncount\n"}},{"id":"encode(data):String-instance-method","html_id":"encode(data):String-instance-method","name":"encode","doc":"Returns the base64-encoded version of *data*.\nThis method complies with [RFC 2045](https://tools.ietf.org/html/rfc2045).\nLine feeds are added to every 60 encoded characters.\n\n```\nputs Base64.encode(\"Now is the time for all good coders\\nto learn Crystal\")\n```\n\nGenerates:\n\n```text\nTm93IGlzIHRoZSB0aW1lIGZvciBhbGwgZ29vZCBjb2RlcnMKdG8gbGVhcm4g\nQ3J5c3RhbA==\n```","summary":"<p>Returns the base64-encoded version of <em>data</em>.</p>","abstract":false,"args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""}],"args_string":"(data) : String","source_link":null,"def":{"name":"encode","args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"slice = data.to_slice\nString.new(encode_size(slice.size, new_lines: true)) do |buf|\n  appender = buf.appender\n  encode_with_new_lines(slice) do |byte|\n    appender << byte\n  end\n  size = appender.size\n  {size, size}\nend\n"}},{"id":"strict_encode(data,io:IO)-instance-method","html_id":"strict_encode(data,io:IO)-instance-method","name":"strict_encode","doc":"Writes the base64-encoded version of *data* with no newlines to *io*.\nThis method complies with [RFC 4648](https://tools.ietf.org/html/rfc4648).\n\n```\nBase64.strict_encode(\"Now is the time for all good coders\\nto learn Crystal\", STDOUT)\n```","summary":"<p>Writes the base64-encoded version of <em>data</em> with no newlines to <em>io</em>.</p>","abstract":false,"args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""},{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(data, io : IO)","source_link":null,"def":{"name":"strict_encode","args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""},{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"strict_encode_to_io_internal(data, io, CHARS_STD, pad: true)"}},{"id":"strict_encode(data):String-instance-method","html_id":"strict_encode(data):String-instance-method","name":"strict_encode","doc":"Returns the base64-encoded version of *data* with no newlines.\nThis method complies with [RFC 4648](https://tools.ietf.org/html/rfc4648).\n\n```\nputs Base64.strict_encode(\"Now is the time for all good coders\\nto learn Crystal\")\n```\n\nGenerates:\n\n```text\nTm93IGlzIHRoZSB0aW1lIGZvciBhbGwgZ29vZCBjb2RlcnMKdG8gbGVhcm4gQ3J5c3RhbA==\n```","summary":"<p>Returns the base64-encoded version of <em>data</em> with no newlines.</p>","abstract":false,"args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""}],"args_string":"(data) : String","source_link":null,"def":{"name":"strict_encode","args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"strict_encode(data, CHARS_STD, pad: true)"}},{"id":"urlsafe_encode(data,io:IO)-instance-method","html_id":"urlsafe_encode(data,io:IO)-instance-method","name":"urlsafe_encode","doc":"Writes the base64-encoded version of *data* using a urlsafe alphabet to *io*.\nThis method complies with \"Base 64 Encoding with URL and Filename Safe\nAlphabet\" in [RFC 4648](https://tools.ietf.org/html/rfc4648).\n\nThe alphabet uses `'-'` instead of `'+'` and `'_'` instead of `'/'`.","summary":"<p>Writes the base64-encoded version of <em>data</em> using a urlsafe alphabet to <em>io</em>.</p>","abstract":false,"args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""},{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(data, io : IO)","source_link":null,"def":{"name":"urlsafe_encode","args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""},{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"strict_encode_to_io_internal(data, io, CHARS_SAFE, pad: true)"}},{"id":"urlsafe_encode(data,padding=true):String-instance-method","html_id":"urlsafe_encode(data,padding=true):String-instance-method","name":"urlsafe_encode","doc":"Returns the base64-encoded version of *data* using a urlsafe alphabet.\nThis method complies with \"Base 64 Encoding with URL and Filename Safe\nAlphabet\" in [RFC 4648](https://tools.ietf.org/html/rfc4648).\n\nThe alphabet uses `'-'` instead of `'+'` and `'_'` instead of `'/'`.\n\nThe *padding* parameter defaults to `true`. When `false`, enough `=` characters\nare not added to make the output divisible by 4.","summary":"<p>Returns the base64-encoded version of <em>data</em> using a urlsafe alphabet.</p>","abstract":false,"args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""},{"name":"padding","doc":null,"default_value":"true","external_name":"padding","restriction":""}],"args_string":"(data, padding = <span class=\"n\">true</span>) : String","source_link":null,"def":{"name":"urlsafe_encode","args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""},{"name":"padding","doc":null,"default_value":"true","external_name":"padding","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"slice = data.to_slice\nString.new(encode_size(slice.size)) do |buf|\n  appender = buf.appender\n  to_base64(slice, CHARS_SAFE, pad: padding) do |byte|\n    appender << byte\n  end\n  size = appender.size\n  {size, size}\nend\n"}}],"macros":[],"types":[{"html_id":"/Base64/Error","path":"Base64/Error.html","kind":"class","full_name":"Base64::Error","name":"Error","abstract":false,"superclass":{"html_id":"/Exception","kind":"class","full_name":"Exception","name":"Exception"},"ancestors":[{"html_id":"/Exception","kind":"class","full_name":"Exception","name":"Exception"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Base64","kind":"module","full_name":"Base64","name":"Base64"},"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]}]},{"html_id":"/Benchmark","path":"Benchmark.html","kind":"module","full_name":"Benchmark","name":"Benchmark","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[{"html_id":"/Benchmark","kind":"module","full_name":"Benchmark","name":"Benchmark"}],"subclasses":[],"including_types":[],"namespace":null,"doc":"The Benchmark module provides methods for benchmarking Crystal code, giving\ndetailed reports on the time and memory taken for each task.\n\n### Measure the number of iterations per second of each task\n\n```\nrequire \"benchmark\"\n\nBenchmark.ips do |x|\n  x.report(\"short sleep\") { sleep 0.01 }\n  x.report(\"shorter sleep\") { sleep 0.001 }\nend\n```\n\nThis generates the following output showing the mean iterations per second,\nthe mean times per iteration, the standard deviation relative to the mean, and a comparison:\n\n```text\n  short sleep   88.7  ( 11.27ms) (± 3.33%)  8.90× slower\nshorter sleep  789.7  (  1.27ms) (± 3.02%)       fastest\n```\n\n`Benchmark::IPS` defaults to 2 seconds of warmup time and 5 seconds of\ncalculation time. This can be configured:\n\n```\nrequire \"benchmark\"\n\nBenchmark.ips(warmup: 4, calculation: 10) do |x|\n  x.report(\"sleep\") { sleep 0.01 }\nend\n```\n\nMake sure to always benchmark code by compiling with the `--release` flag.\n\n### Measure the time to construct the string given by the expression: `\"a\"*1_000_000_000`\n\n```\nrequire \"benchmark\"\n\nputs Benchmark.measure { \"a\"*1_000_000_000 }\n```\n\nThis generates the following output:\n\n```text\n 0.190000   0.220000   0.410000 (  0.420185)\n```\n\nThis report shows the user CPU time, system CPU time, the sum of\nthe user and system CPU times, and the elapsed real time. The unit\nof time is seconds.\n\n### Do some experiments sequentially using the `#bm` method:\n\n```\nrequire \"benchmark\"\n\nn = 5000000\nBenchmark.bm do |x|\n  x.report(\"times:\") do\n    n.times do\n      a = \"1\"\n    end\n  end\n  x.report(\"upto:\") do\n    1.upto(n) do\n      a = \"1\"\n    end\n  end\nend\n```\n\nThe result:\n\n```text\n           user     system      total        real\ntimes:   0.010000   0.000000   0.010000 (  0.008976)\nupto:    0.010000   0.000000   0.010000 (  0.010466)\n```\n\nMake sure to always benchmark code by compiling with the `--release` flag.","summary":"<p>The Benchmark module provides methods for benchmarking Crystal code, giving detailed reports on the time and memory taken for each task.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"bm(&block)-instance-method","html_id":"bm(&amp;block)-instance-method","name":"bm","doc":"Main interface of the `Benchmark` module. Yields a `Job` to which\none can report the benchmarks. See the module's description.","summary":"<p>Main interface of the <code><a href=\"Benchmark.html\">Benchmark</a></code> module.</p>","abstract":false,"args":[],"args_string":"(&block)","source_link":null,"def":{"name":"bm","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"{% if !(flag?(:release)) %}\n      puts \"Warning: benchmarking without the `--release` flag won't yield useful results\"\n    {% end %}\nreport = BM::Job.new\nyield report\nreport.execute\nreport\n"}},{"id":"ips(calculation=5,warmup=2,interactive=STDOUT.tty?,&block)-instance-method","html_id":"ips(calculation=5,warmup=2,interactive=STDOUT.tty?,&amp;block)-instance-method","name":"ips","doc":"Instruction per second interface of the `Benchmark` module. Yields a `Job`\nto which one can report the benchmarks. See the module's description.\n\nThe optional parameters *calculation* and *warmup* set the duration of\nthose stages in seconds. For more detail on these stages see\n`Benchmark::IPS`. When the *interactive* parameter is `true`, results are\ndisplayed and updated as they are calculated, otherwise all at once.","summary":"<p>Instruction per second interface of the <code><a href=\"Benchmark.html\">Benchmark</a></code> module.</p>","abstract":false,"args":[{"name":"calculation","doc":null,"default_value":"5","external_name":"calculation","restriction":""},{"name":"warmup","doc":null,"default_value":"2","external_name":"warmup","restriction":""},{"name":"interactive","doc":null,"default_value":"STDOUT.tty?","external_name":"interactive","restriction":""}],"args_string":"(calculation = <span class=\"n\">5</span>, warmup = <span class=\"n\">2</span>, interactive = <span class=\"t\">STDOUT</span>.tty?, &block)","source_link":null,"def":{"name":"ips","args":[{"name":"calculation","doc":null,"default_value":"5","external_name":"calculation","restriction":""},{"name":"warmup","doc":null,"default_value":"2","external_name":"warmup","restriction":""},{"name":"interactive","doc":null,"default_value":"STDOUT.tty?","external_name":"interactive","restriction":""}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"{% if !(flag?(:release)) %}\n      puts \"Warning: benchmarking without the `--release` flag won't yield useful results\"\n    {% end %}\njob = IPS::Job.new(calculation, warmup, interactive)\nyield job\njob.execute\njob.report\njob\n"}},{"id":"measure(label=&quot;&quot;,&block):BM::Tms-instance-method","html_id":"measure(label=&amp;quot;&amp;quot;,&amp;block):BM::Tms-instance-method","name":"measure","doc":"Returns the time used to execute the given block.","summary":"<p>Returns the time used to execute the given block.</p>","abstract":false,"args":[{"name":"label","doc":null,"default_value":"\"\"","external_name":"label","restriction":""}],"args_string":"(label = <span class=\"s\">&quot;&quot;</span>, &block) : BM::Tms","source_link":null,"def":{"name":"measure","args":[{"name":"label","doc":null,"default_value":"\"\"","external_name":"label","restriction":""}],"double_splat":null,"splat_index":null,"yields":0,"block_arg":null,"return_type":"BM::Tms","visibility":"Public","body":"t0, r0 = Process.times, Time.monotonic\nyield\nt1, r1 = Process.times, Time.monotonic\nBM::Tms.new(t1.utime - t0.utime, t1.stime - t0.stime, t1.cutime - t0.cutime, t1.cstime - t0.cstime, (r1 - r0).total_seconds, label)\n"}},{"id":"memory(&block)-instance-method","html_id":"memory(&amp;block)-instance-method","name":"memory","doc":"Returns the memory in bytes that the given block consumes.\n\n```\nBenchmark.memory { Array(Int32).new } # => 32\n```","summary":"<p>Returns the memory in bytes that the given block consumes.</p>","abstract":false,"args":[],"args_string":"(&block)","source_link":null,"def":{"name":"memory","args":[],"double_splat":null,"splat_index":null,"yields":0,"block_arg":null,"return_type":"","visibility":"Public","body":"bytes_before_measure = GC.stats.total_bytes\nyield\n(GC.stats.total_bytes - bytes_before_measure).to_i64\n"}},{"id":"realtime(&block):Time::Span-instance-method","html_id":"realtime(&amp;block):Time::Span-instance-method","name":"realtime","doc":"Returns the elapsed real time used to execute the given block.\n\n```\nBenchmark.realtime { \"a\" * 100_000 } # => 00:00:00.0005840\n```","summary":"<p>Returns the elapsed real time used to execute the given block.</p>","abstract":false,"args":[],"args_string":"(&block) : Time::Span","source_link":null,"def":{"name":"realtime","args":[],"double_splat":null,"splat_index":null,"yields":0,"block_arg":null,"return_type":"Time::Span","visibility":"Public","body":"Time.measure do\n  yield\nend"}}],"macros":[],"types":[{"html_id":"/Benchmark/BM","path":"Benchmark/BM.html","kind":"module","full_name":"Benchmark::BM","name":"BM","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Benchmark","kind":"module","full_name":"Benchmark","name":"Benchmark"},"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[{"html_id":"/Benchmark/BM/Job","path":"Benchmark/BM/Job.html","kind":"class","full_name":"Benchmark::BM::Job","name":"Job","abstract":false,"superclass":{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Benchmark/BM","kind":"module","full_name":"Benchmark::BM","name":"BM"},"doc":"Yielded by `Benchmark#bm`, use `#report` to report benchmarks.","summary":"<p>Yielded by <code><a href=\"../../Benchmark.html#bm(&block)-instance-method\">Benchmark#bm</a></code>, use <code><a href=\"../../Benchmark/BM/Job.html#report(label=&quot;&quot;,&block)-instance-method\">#report</a></code> to report benchmarks.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"report(label=&quot;&quot;,&block)-instance-method","html_id":"report(label=&amp;quot;&amp;quot;,&amp;block)-instance-method","name":"report","doc":"Reports a single benchmark unit.","summary":"<p>Reports a single benchmark unit.</p>","abstract":false,"args":[{"name":"label","doc":null,"default_value":"\" \"","external_name":"label","restriction":""}],"args_string":"(label = <span class=\"s\">&quot; &quot;</span>, &block)","source_link":null,"def":{"name":"report","args":[{"name":"label","doc":null,"default_value":"\" \"","external_name":"label","restriction":""}],"double_splat":null,"splat_index":null,"yields":0,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":""},"return_type":"","visibility":"Public","body":"if label.size > @label_width\n  @label_width = label.size\nend\n@reports << {label, block}\n"}}],"macros":[],"types":[]},{"html_id":"/Benchmark/BM/Tms","path":"Benchmark/BM/Tms.html","kind":"class","full_name":"Benchmark::BM::Tms","name":"Tms","abstract":false,"superclass":{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Benchmark/BM","kind":"module","full_name":"Benchmark::BM","name":"BM"},"doc":"A data object, representing the times associated with a benchmark measurement.","summary":"<p>A data object, representing the times associated with a benchmark measurement.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"cstime:Float64-instance-method","html_id":"cstime:Float64-instance-method","name":"cstime","doc":"System CPU time of children","summary":"<p>System CPU time of children</p>","abstract":false,"args":[],"args_string":" : Float64","source_link":null,"def":{"name":"cstime","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Float64","visibility":"Public","body":"@cstime"}},{"id":"cutime:Float64-instance-method","html_id":"cutime:Float64-instance-method","name":"cutime","doc":"User CPU time of children","summary":"<p>User CPU time of children</p>","abstract":false,"args":[],"args_string":" : Float64","source_link":null,"def":{"name":"cutime","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Float64","visibility":"Public","body":"@cutime"}},{"id":"label:String-instance-method","html_id":"label:String-instance-method","name":"label","doc":"The label associated with this measure","summary":"<p>The label associated with this measure</p>","abstract":false,"args":[],"args_string":" : String","source_link":null,"def":{"name":"label","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"@label"}},{"id":"real:Float64-instance-method","html_id":"real:Float64-instance-method","name":"real","doc":"Elapsed real time","summary":"<p>Elapsed real time</p>","abstract":false,"args":[],"args_string":" : Float64","source_link":null,"def":{"name":"real","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Float64","visibility":"Public","body":"@real"}},{"id":"stime:Float64-instance-method","html_id":"stime:Float64-instance-method","name":"stime","doc":"System CPU time","summary":"<p>System CPU time</p>","abstract":false,"args":[],"args_string":" : Float64","source_link":null,"def":{"name":"stime","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Float64","visibility":"Public","body":"@stime"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Prints *utime*, *stime*, *total* and *real* to the given IO.","summary":"<p>Prints <em>utime</em>, <em>stime</em>, <em>total</em> and <em>real</em> to the given IO.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io.printf(\"  %.6f   %.6f   %.6f (  %.6f)\", utime, stime, total, real)"}},{"id":"total-instance-method","html_id":"total-instance-method","name":"total","doc":"Total time, that is utime + stime + cutime + cstime","summary":"<p>Total time, that is utime + stime + cutime + cstime</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"total","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"((utime + stime) + cutime) + cstime"}},{"id":"utime:Float64-instance-method","html_id":"utime:Float64-instance-method","name":"utime","doc":"User CPU time","summary":"<p>User CPU time</p>","abstract":false,"args":[],"args_string":" : Float64","source_link":null,"def":{"name":"utime","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Float64","visibility":"Public","body":"@utime"}}],"macros":[],"types":[]}]},{"html_id":"/Benchmark/IPS","path":"Benchmark/IPS.html","kind":"module","full_name":"Benchmark::IPS","name":"IPS","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Benchmark","kind":"module","full_name":"Benchmark","name":"Benchmark"},"doc":"Benchmark IPS calculates the number of iterations per second for a given\nblock of code. The strategy is to use two stages: a warmup stage and a\ncalculation stage.\n\nThe warmup phase defaults to 2 seconds. During this stage we figure out how\nmany cycles are needed to run the block for roughly 100ms, and record it.\n\nThe calculation defaults to 5 seconds. During this stage we run the block\nin sets of the size calculated in the warmup stage. The measurements for\nthose sets are then used to calculate the mean and standard deviation,\nwhich are then reported. Additionally we compare the means to that of the\nfastest.","summary":"<p>Benchmark IPS calculates the number of iterations per second for a given block of code.</p>","class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[{"html_id":"/Benchmark/IPS/Entry","path":"Benchmark/IPS/Entry.html","kind":"class","full_name":"Benchmark::IPS::Entry","name":"Entry","abstract":false,"superclass":{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Benchmark/IPS","kind":"module","full_name":"Benchmark::IPS","name":"IPS"},"doc":null,"summary":null,"class_methods":[],"constructors":[{"id":"new(label:String,action:->)-class-method","html_id":"new(label:String,action:-&gt;)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"label","doc":null,"default_value":"","external_name":"label","restriction":"String"},{"name":"action","doc":null,"default_value":"","external_name":"action","restriction":"(-> )"}],"args_string":"(label : String, action :  -> )","source_link":null,"def":{"name":"new","args":[{"name":"label","doc":null,"default_value":"","external_name":"label","restriction":"String"},{"name":"action","doc":null,"default_value":"","external_name":"action","restriction":"(-> )"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(label, action)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"action:->-instance-method","html_id":"action:-&gt;-instance-method","name":"action","doc":"Code to be benchmarked","summary":"<p>Code to be benchmarked</p>","abstract":false,"args":[],"args_string":" :  -> ","source_link":null,"def":{"name":"action","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"(-> )","visibility":"Public","body":"@action"}},{"id":"action=(action:->)-instance-method","html_id":"action=(action:-&gt;)-instance-method","name":"action=","doc":"Code to be benchmarked","summary":"<p>Code to be benchmarked</p>","abstract":false,"args":[{"name":"action","doc":null,"default_value":"","external_name":"action","restriction":"(-> )"}],"args_string":"(action :  -> )","source_link":null,"def":{"name":"action=","args":[{"name":"action","doc":null,"default_value":"","external_name":"action","restriction":"(-> )"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@action = action"}},{"id":"bytes_per_op-instance-method","html_id":"bytes_per_op-instance-method","name":"bytes_per_op","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"bytes_per_op","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@bytes_per_op.not_nil!"}},{"id":"bytes_per_op=(bytes_per_op:Int32)-instance-method","html_id":"bytes_per_op=(bytes_per_op:Int32)-instance-method","name":"bytes_per_op=","doc":"Number of bytes allocated per operation","summary":"<p>Number of bytes allocated per operation</p>","abstract":false,"args":[{"name":"bytes_per_op","doc":null,"default_value":"","external_name":"bytes_per_op","restriction":"Int32"}],"args_string":"(bytes_per_op : Int32)","source_link":null,"def":{"name":"bytes_per_op=","args":[{"name":"bytes_per_op","doc":null,"default_value":"","external_name":"bytes_per_op","restriction":"Int32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@bytes_per_op = bytes_per_op"}},{"id":"bytes_per_op?:Int32?-instance-method","html_id":"bytes_per_op?:Int32?-instance-method","name":"bytes_per_op?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Int32?","source_link":null,"def":{"name":"bytes_per_op?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@bytes_per_op"}},{"id":"calculate_stats(samples)-instance-method","html_id":"calculate_stats(samples)-instance-method","name":"calculate_stats","doc":null,"summary":null,"abstract":false,"args":[{"name":"samples","doc":null,"default_value":"","external_name":"samples","restriction":""}],"args_string":"(samples)","source_link":null,"def":{"name":"calculate_stats","args":[{"name":"samples","doc":null,"default_value":"","external_name":"samples","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@ran = true\n@size = samples.size\n@mean = samples.sum.to_f / size.to_f\n@variance = (samples.reduce(0) do |acc, i|\n  acc + ((i - mean) ** 2)\nend).to_f / size.to_f\n@stddev = Math.sqrt(variance)\n@relative_stddev = 100.0 * (stddev / mean)\n"}},{"id":"call-instance-method","html_id":"call-instance-method","name":"call","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"call","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"action.call"}},{"id":"call_for_100ms-instance-method","html_id":"call_for_100ms-instance-method","name":"call_for_100ms","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"call_for_100ms","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"cycles.times do\n  action.call\nend"}},{"id":"cycles-instance-method","html_id":"cycles-instance-method","name":"cycles","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"cycles","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@cycles.not_nil!"}},{"id":"cycles=(cycles:Int32)-instance-method","html_id":"cycles=(cycles:Int32)-instance-method","name":"cycles=","doc":"Number of cycles needed to run for approx 100ms\nCalculated during the warmup stage","summary":"<p>Number of cycles needed to run for approx 100ms Calculated during the warmup stage</p>","abstract":false,"args":[{"name":"cycles","doc":null,"default_value":"","external_name":"cycles","restriction":"Int32"}],"args_string":"(cycles : Int32)","source_link":null,"def":{"name":"cycles=","args":[{"name":"cycles","doc":null,"default_value":"","external_name":"cycles","restriction":"Int32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@cycles = cycles"}},{"id":"cycles?:Int32?-instance-method","html_id":"cycles?:Int32?-instance-method","name":"cycles?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Int32?","source_link":null,"def":{"name":"cycles?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@cycles"}},{"id":"human_compare-instance-method","html_id":"human_compare-instance-method","name":"human_compare","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"human_compare","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if slower == 1.0\n  \"fastest\"\nelse\n  sprintf(\"%5.2f× slower\", slower)\nend"}},{"id":"human_iteration_time-instance-method","html_id":"human_iteration_time-instance-method","name":"human_iteration_time","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"human_iteration_time","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"iteration_time = 1.0 / mean\niteration_time.humanize(precision: 2, significant: false) do |magnitude, _|\n  magnitude = (Number.prefix_index(magnitude)).clamp(-9..0)\n  {magnitude, magnitude == 0 ? \"s \" : \"#{Number.si_prefix(magnitude)}s\"}\nend.rjust(8)\n"}},{"id":"human_mean-instance-method","html_id":"human_mean-instance-method","name":"human_mean","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"human_mean","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"mean.humanize(precision: 2, significant: false, prefixes: Number::SI_PREFIXES_PADDED).rjust(7)"}},{"id":"label:String-instance-method","html_id":"label:String-instance-method","name":"label","doc":"Label of the benchmark","summary":"<p>Label of the benchmark</p>","abstract":false,"args":[],"args_string":" : String","source_link":null,"def":{"name":"label","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"@label"}},{"id":"label=(label:String)-instance-method","html_id":"label=(label:String)-instance-method","name":"label=","doc":"Label of the benchmark","summary":"<p>Label of the benchmark</p>","abstract":false,"args":[{"name":"label","doc":null,"default_value":"","external_name":"label","restriction":"String"}],"args_string":"(label : String)","source_link":null,"def":{"name":"label=","args":[{"name":"label","doc":null,"default_value":"","external_name":"label","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@label = label"}},{"id":"mean-instance-method","html_id":"mean-instance-method","name":"mean","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"mean","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@mean.not_nil!"}},{"id":"mean=(mean:Float64)-instance-method","html_id":"mean=(mean:Float64)-instance-method","name":"mean=","doc":"Statistical mean from calculation stage","summary":"<p>Statistical mean from calculation stage</p>","abstract":false,"args":[{"name":"mean","doc":null,"default_value":"","external_name":"mean","restriction":"Float64"}],"args_string":"(mean : Float64)","source_link":null,"def":{"name":"mean=","args":[{"name":"mean","doc":null,"default_value":"","external_name":"mean","restriction":"Float64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@mean = mean"}},{"id":"mean?:Float64?-instance-method","html_id":"mean?:Float64?-instance-method","name":"mean?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Float64?","source_link":null,"def":{"name":"mean?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@mean"}},{"id":"ran?:Bool-instance-method","html_id":"ran?:Bool-instance-method","name":"ran?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Bool","source_link":null,"def":{"name":"ran?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@ran"}},{"id":"relative_stddev-instance-method","html_id":"relative_stddev-instance-method","name":"relative_stddev","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"relative_stddev","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@relative_stddev.not_nil!"}},{"id":"relative_stddev=(relative_stddev:Float64)-instance-method","html_id":"relative_stddev=(relative_stddev:Float64)-instance-method","name":"relative_stddev=","doc":"Relative standard deviation as a percentage","summary":"<p>Relative standard deviation as a percentage</p>","abstract":false,"args":[{"name":"relative_stddev","doc":null,"default_value":"","external_name":"relative_stddev","restriction":"Float64"}],"args_string":"(relative_stddev : Float64)","source_link":null,"def":{"name":"relative_stddev=","args":[{"name":"relative_stddev","doc":null,"default_value":"","external_name":"relative_stddev","restriction":"Float64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@relative_stddev = relative_stddev"}},{"id":"relative_stddev?:Float64?-instance-method","html_id":"relative_stddev?:Float64?-instance-method","name":"relative_stddev?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Float64?","source_link":null,"def":{"name":"relative_stddev?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@relative_stddev"}},{"id":"set_cycles(duration,iterations)-instance-method","html_id":"set_cycles(duration,iterations)-instance-method","name":"set_cycles","doc":null,"summary":null,"abstract":false,"args":[{"name":"duration","doc":null,"default_value":"","external_name":"duration","restriction":""},{"name":"iterations","doc":null,"default_value":"","external_name":"iterations","restriction":""}],"args_string":"(duration, iterations)","source_link":null,"def":{"name":"set_cycles","args":[{"name":"duration","doc":null,"default_value":"","external_name":"duration","restriction":""},{"name":"iterations","doc":null,"default_value":"","external_name":"iterations","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@cycles = ((iterations / duration.total_milliseconds) * 100).to_i\nif cycles <= 0\n  @cycles = 1\nend\n"}},{"id":"size-instance-method","html_id":"size-instance-method","name":"size","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"size","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@size.not_nil!"}},{"id":"size=(size:Int32)-instance-method","html_id":"size=(size:Int32)-instance-method","name":"size=","doc":"Number of 100ms runs during the calculation stage","summary":"<p>Number of 100ms runs during the calculation stage</p>","abstract":false,"args":[{"name":"size","doc":null,"default_value":"","external_name":"size","restriction":"Int32"}],"args_string":"(size : Int32)","source_link":null,"def":{"name":"size=","args":[{"name":"size","doc":null,"default_value":"","external_name":"size","restriction":"Int32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@size = size"}},{"id":"size?:Int32?-instance-method","html_id":"size?:Int32?-instance-method","name":"size?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Int32?","source_link":null,"def":{"name":"size?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@size"}},{"id":"slower-instance-method","html_id":"slower-instance-method","name":"slower","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"slower","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@slower.not_nil!"}},{"id":"slower=(slower:Float64)-instance-method","html_id":"slower=(slower:Float64)-instance-method","name":"slower=","doc":"Multiple slower than the fastest entry","summary":"<p>Multiple slower than the fastest entry</p>","abstract":false,"args":[{"name":"slower","doc":null,"default_value":"","external_name":"slower","restriction":"Float64"}],"args_string":"(slower : Float64)","source_link":null,"def":{"name":"slower=","args":[{"name":"slower","doc":null,"default_value":"","external_name":"slower","restriction":"Float64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@slower = slower"}},{"id":"slower?:Float64?-instance-method","html_id":"slower?:Float64?-instance-method","name":"slower?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Float64?","source_link":null,"def":{"name":"slower?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@slower"}},{"id":"stddev-instance-method","html_id":"stddev-instance-method","name":"stddev","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"stddev","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@stddev.not_nil!"}},{"id":"stddev=(stddev:Float64)-instance-method","html_id":"stddev=(stddev:Float64)-instance-method","name":"stddev=","doc":"Statistical standard deviation from calculation stage","summary":"<p>Statistical standard deviation from calculation stage</p>","abstract":false,"args":[{"name":"stddev","doc":null,"default_value":"","external_name":"stddev","restriction":"Float64"}],"args_string":"(stddev : Float64)","source_link":null,"def":{"name":"stddev=","args":[{"name":"stddev","doc":null,"default_value":"","external_name":"stddev","restriction":"Float64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@stddev = stddev"}},{"id":"stddev?:Float64?-instance-method","html_id":"stddev?:Float64?-instance-method","name":"stddev?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Float64?","source_link":null,"def":{"name":"stddev?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@stddev"}},{"id":"variance-instance-method","html_id":"variance-instance-method","name":"variance","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"variance","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@variance.not_nil!"}},{"id":"variance=(variance:Float64)-instance-method","html_id":"variance=(variance:Float64)-instance-method","name":"variance=","doc":"Statistical variance from calculation stage","summary":"<p>Statistical variance from calculation stage</p>","abstract":false,"args":[{"name":"variance","doc":null,"default_value":"","external_name":"variance","restriction":"Float64"}],"args_string":"(variance : Float64)","source_link":null,"def":{"name":"variance=","args":[{"name":"variance","doc":null,"default_value":"","external_name":"variance","restriction":"Float64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@variance = variance"}},{"id":"variance?:Float64?-instance-method","html_id":"variance?:Float64?-instance-method","name":"variance?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Float64?","source_link":null,"def":{"name":"variance?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@variance"}}],"macros":[],"types":[]},{"html_id":"/Benchmark/IPS/Job","path":"Benchmark/IPS/Job.html","kind":"class","full_name":"Benchmark::IPS::Job","name":"Job","abstract":false,"superclass":{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Benchmark/IPS","kind":"module","full_name":"Benchmark::IPS","name":"IPS"},"doc":null,"summary":null,"class_methods":[],"constructors":[{"id":"new(calculation=5,warmup=2,interactive=STDOUT.tty?)-class-method","html_id":"new(calculation=5,warmup=2,interactive=STDOUT.tty?)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"calculation","doc":null,"default_value":"5","external_name":"calculation","restriction":""},{"name":"warmup","doc":null,"default_value":"2","external_name":"warmup","restriction":""},{"name":"interactive","doc":null,"default_value":"STDOUT.tty?","external_name":"interactive","restriction":""}],"args_string":"(calculation = <span class=\"n\">5</span>, warmup = <span class=\"n\">2</span>, interactive = <span class=\"t\">STDOUT</span>.tty?)","source_link":null,"def":{"name":"new","args":[{"name":"calculation","doc":null,"default_value":"5","external_name":"calculation","restriction":""},{"name":"warmup","doc":null,"default_value":"2","external_name":"warmup","restriction":""},{"name":"interactive","doc":null,"default_value":"STDOUT.tty?","external_name":"interactive","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(calculation, warmup, interactive)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"execute-instance-method","html_id":"execute-instance-method","name":"execute","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"execute","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"run_warmup\nrun_calculation\nrun_comparison\n"}},{"id":"items:Array(Entry)-instance-method","html_id":"items:Array(Entry)-instance-method","name":"items","doc":"List of all entries in the benchmark.\nAfter #execute, these are populated with the resulting statistics.","summary":"<p>List of all entries in the benchmark.</p>","abstract":false,"args":[],"args_string":" : Array(Entry)","source_link":null,"def":{"name":"items","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Array(Entry)","visibility":"Public","body":"@items"}},{"id":"items=(items:Array(Entry))-instance-method","html_id":"items=(items:Array(Entry))-instance-method","name":"items=","doc":"List of all entries in the benchmark.\nAfter #execute, these are populated with the resulting statistics.","summary":"<p>List of all entries in the benchmark.</p>","abstract":false,"args":[{"name":"items","doc":null,"default_value":"","external_name":"items","restriction":"Array(Entry)"}],"args_string":"(items : Array(Entry))","source_link":null,"def":{"name":"items=","args":[{"name":"items","doc":null,"default_value":"","external_name":"items","restriction":"Array(Entry)"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@items = items"}},{"id":"report(label=&quot;&quot;,&action)-instance-method","html_id":"report(label=&amp;quot;&amp;quot;,&amp;action)-instance-method","name":"report","doc":"Adds code to be benchmarked","summary":"<p>Adds code to be benchmarked</p>","abstract":false,"args":[{"name":"label","doc":null,"default_value":"\"\"","external_name":"label","restriction":""}],"args_string":"(label = <span class=\"s\">&quot;&quot;</span>, &action)","source_link":null,"def":{"name":"report","args":[{"name":"label","doc":null,"default_value":"\"\"","external_name":"label","restriction":""}],"double_splat":null,"splat_index":null,"yields":0,"block_arg":{"name":"action","doc":null,"default_value":"","external_name":"action","restriction":""},"return_type":"","visibility":"Public","body":"item = Entry.new(label, action)\n@items << item\nitem\n"}},{"id":"report-instance-method","html_id":"report-instance-method","name":"report","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"report","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"max_label = ran_items.max_of do |__arg0|\n  __arg0.label.size\nend\nmax_compare = ran_items.max_of do |__arg1|\n  __arg1.human_compare.size\nend\nmax_bytes_per_op = ran_items.max_of do |__arg2|\n  __arg2.bytes_per_op.humanize(base: 1024).size\nend\nran_items.each do |item|\n  printf(\"%s %s (%s) (±%5.2f%%)  %sB/op  %s\\n\", item.label.rjust(max_label), item.human_mean, item.human_iteration_time, item.relative_stddev, item.bytes_per_op.humanize(base: 1024).rjust(max_bytes_per_op), item.human_compare.rjust(max_compare))\nend\n"}}],"macros":[],"types":[]}]}]},{"html_id":"/BigDecimal","path":"BigDecimal.html","kind":"struct","full_name":"BigDecimal","name":"BigDecimal","abstract":false,"superclass":{"html_id":"/Number","kind":"struct","full_name":"Number","name":"Number"},"ancestors":[{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Number","kind":"struct","full_name":"Number","name":"Number"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[{"id":"DEFAULT_MAX_DIV_ITERATIONS","name":"DEFAULT_MAX_DIV_ITERATIONS","value":"100_u64","doc":null,"summary":null},{"id":"TEN","name":"TEN","value":"BigInt.new(10)","doc":null,"summary":null},{"id":"ZERO","name":"ZERO","value":"BigInt.new(0)","doc":null,"summary":null}],"included_modules":[{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"}],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":null,"summary":null,"class_methods":[],"constructors":[{"id":"new(value:BigInt,scale:UInt64)-class-method","html_id":"new(value:BigInt,scale:UInt64)-class-method","name":"new","doc":"Creates a new `BigDecimal` from `BigInt` *value* and `UInt64` *scale*,\nwhich matches the internal representation.","summary":"<p>Creates a new <code><a href=\"BigDecimal.html\">BigDecimal</a></code> from <code><a href=\"BigInt.html\">BigInt</a></code> <em>value</em> and <code><a href=\"UInt64.html\">UInt64</a></code> <em>scale</em>, which matches the internal representation.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"BigInt"},{"name":"scale","doc":null,"default_value":"","external_name":"scale","restriction":"UInt64"}],"args_string":"(value : BigInt, scale : UInt64)","source_link":null,"def":{"name":"new","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"BigInt"},{"name":"scale","doc":null,"default_value":"","external_name":"scale","restriction":"UInt64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(value, scale)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:Float)-class-method","html_id":"new(num:Float)-class-method","name":"new","doc":"Creates a new `BigDecimal` from `Float`.\n\nNOTE: Floats are fundamentally less precise than BigDecimals,\nwhich makes initialization from them risky.","summary":"<p>Creates a new <code><a href=\"BigDecimal.html\">BigDecimal</a></code> from <code><a href=\"Float.html\">Float</a></code>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Float"}],"args_string":"(num : Float)","source_link":null,"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Float"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"new(num.to_s)"}},{"id":"new(num:BigRational)-class-method","html_id":"new(num:BigRational)-class-method","name":"new","doc":"Creates a new `BigDecimal` from `BigRational`.\n\nNOTE: BigRational are fundamentally more precise than BigDecimals,\nwhich makes initialization from them risky.","summary":"<p>Creates a new <code><a href=\"BigDecimal.html\">BigDecimal</a></code> from <code><a href=\"BigRational.html\">BigRational</a></code>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigRational"}],"args_string":"(num : BigRational)","source_link":null,"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"num.numerator.to_big_d / num.denominator.to_big_d"}},{"id":"new(num:BigDecimal)-class-method","html_id":"new(num:BigDecimal)-class-method","name":"new","doc":"Returns *num*. Useful for generic code that does `T.new(...)` with `T`\nbeing a `Number`.","summary":"<p>Returns <em>num</em>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigDecimal"}],"args_string":"(num : BigDecimal)","source_link":null,"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"num"}},{"id":"new(num:Int=0,scale:Int=0)-class-method","html_id":"new(num:Int=0,scale:Int=0)-class-method","name":"new","doc":"Creates a new `BigDecimal` from `Int`.","summary":"<p>Creates a new <code><a href=\"BigDecimal.html\">BigDecimal</a></code> from <code><a href=\"Int.html\">Int</a></code>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"0","external_name":"num","restriction":"Int"},{"name":"scale","doc":null,"default_value":"0","external_name":"scale","restriction":"Int"}],"args_string":"(num : Int = <span class=\"n\">0</span>, scale : Int = <span class=\"n\">0</span>)","source_link":null,"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"0","external_name":"num","restriction":"Int"},{"name":"scale","doc":null,"default_value":"0","external_name":"scale","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num, scale)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(str:String)-class-method","html_id":"new(str:String)-class-method","name":"new","doc":"Creates a new `BigDecimal` from a `String`.\n\nAllows only valid number strings with an optional negative sign.","summary":"<p>Creates a new <code><a href=\"BigDecimal.html\">BigDecimal</a></code> from a <code><a href=\"String.html\">String</a></code>.</p>","abstract":false,"args":[{"name":"str","doc":null,"default_value":"","external_name":"str","restriction":"String"}],"args_string":"(str : String)","source_link":null,"def":{"name":"new","args":[{"name":"str","doc":null,"default_value":"","external_name":"str","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(str)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"*(other:BigDecimal):BigDecimal-instance-method","html_id":"*(other:BigDecimal):BigDecimal-instance-method","name":"*","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : BigDecimal","source_link":null,"def":{"name":"*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"BigDecimal.new(@value * other.value, @scale + other.scale)"}},{"id":"*(other:Int)-instance-method","html_id":"*(other:Int)-instance-method","name":"*","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int)","source_link":null,"def":{"name":"*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self * (BigDecimal.new(other))"}},{"id":"**(other:Int):BigDecimal-instance-method","html_id":"**(other:Int):BigDecimal-instance-method","name":"**","doc":"Raises the decimal to the *other*th power\n\n```\nrequire \"big\"\n\nBigDecimal.new(1234, 2) ** 2 # => 152.2756\n```","summary":"<p>Raises the decimal to the <em>other</em>th power</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigDecimal","source_link":null,"def":{"name":"**","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"if other < 0\n  raise(ArgumentError.new(\"Negative exponent isn't supported\"))\nend\nBigDecimal.new(@value ** other, @scale * other)\n"}},{"id":"+(other:BigDecimal):BigDecimal-instance-method","html_id":"+(other:BigDecimal):BigDecimal-instance-method","name":"+","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : BigDecimal","source_link":null,"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"if @scale > other.scale\n  scaled = other.scale_to(self)\n  BigDecimal.new(@value + scaled.value, @scale)\nelse\n  if @scale < other.scale\n    scaled = scale_to(other)\n    BigDecimal.new(scaled.value + other.value, other.scale)\n  else\n    BigDecimal.new(@value + other.value, @scale)\n  end\nend"}},{"id":"+(other:Int)-instance-method","html_id":"+(other:Int)-instance-method","name":"+","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int)","source_link":null,"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self + (BigDecimal.new(other))"}},{"id":"-(other:BigDecimal):BigDecimal-instance-method","html_id":"-(other:BigDecimal):BigDecimal-instance-method","name":"-","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : BigDecimal","source_link":null,"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"if @scale > other.scale\n  scaled = other.scale_to(self)\n  BigDecimal.new(@value - scaled.value, @scale)\nelse\n  if @scale < other.scale\n    scaled = scale_to(other)\n    BigDecimal.new(scaled.value - other.value, other.scale)\n  else\n    BigDecimal.new(@value - other.value, @scale)\n  end\nend"}},{"id":"-(other:Int)-instance-method","html_id":"-(other:Int)-instance-method","name":"-","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int)","source_link":null,"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self - (BigDecimal.new(other))"}},{"id":"-:BigDecimal-instance-method","html_id":"-:BigDecimal-instance-method","name":"-","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : BigDecimal","source_link":null,"def":{"name":"-","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"BigDecimal.new(-@value, @scale)"}},{"id":"/(other:UInt16):BigDecimal-instance-method","html_id":"/(other:UInt16):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt16"}],"args_string":"(other : UInt16) : BigDecimal","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt16"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:Float32):BigDecimal-instance-method","html_id":"/(other:Float32):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float32"}],"args_string":"(other : Float32) : BigDecimal","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:UInt128):BigDecimal-instance-method","html_id":"/(other:UInt128):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt128"}],"args_string":"(other : UInt128) : BigDecimal","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt128"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:Int128):BigDecimal-instance-method","html_id":"/(other:Int128):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int128"}],"args_string":"(other : Int128) : BigDecimal","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int128"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:UInt64):BigDecimal-instance-method","html_id":"/(other:UInt64):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt64"}],"args_string":"(other : UInt64) : BigDecimal","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:Int64):BigDecimal-instance-method","html_id":"/(other:Int64):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int64"}],"args_string":"(other : Int64) : BigDecimal","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:UInt32):BigDecimal-instance-method","html_id":"/(other:UInt32):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt32"}],"args_string":"(other : UInt32) : BigDecimal","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:Int32):BigDecimal-instance-method","html_id":"/(other:Int32):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int32"}],"args_string":"(other : Int32) : BigDecimal","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:Int16):BigDecimal-instance-method","html_id":"/(other:Int16):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int16"}],"args_string":"(other : Int16) : BigDecimal","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int16"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:UInt8):BigDecimal-instance-method","html_id":"/(other:UInt8):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt8"}],"args_string":"(other : UInt8) : BigDecimal","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt8"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:Int8):BigDecimal-instance-method","html_id":"/(other:Int8):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int8"}],"args_string":"(other : Int8) : BigDecimal","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int8"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:BigRational):BigRational-instance-method","html_id":"/(other:BigRational):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational) : BigRational","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:BigFloat):BigDecimal-instance-method","html_id":"/(other:BigFloat):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigFloat"}],"args_string":"(other : BigFloat) : BigDecimal","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigFloat"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:BigInt):BigDecimal-instance-method","html_id":"/(other:BigInt):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigDecimal","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:BigDecimal):BigDecimal-instance-method","html_id":"/(other:BigDecimal):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : BigDecimal","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"div(other)"}},{"id":"/(other:Float64):BigDecimal-instance-method","html_id":"/(other:Float64):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float64"}],"args_string":"(other : Float64) : BigDecimal","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"(other:BigDecimal):Int32-instance-method","html_id":"(other:BigDecimal):Int32-instance-method","name":"<=>","doc":"The comparison operator. Returns `0` if the two objects are equal,\na negative number if this object is considered less than *other*,\na positive number if this object is considered greter than *other*,\nor `nil` if the two objects are not comparable.\n\nSubclasses define this method to provide class-specific ordering.\n\nThe comparison operator is usually used to sort values:\n\n```\n# Sort in a descending way:\n[3, 1, 2].sort { |x, y| y <=> x } # => [3, 2, 1]\n\n# Sort in an ascending way:\n[3, 1, 2].sort { |x, y| x <=> y } # => [1, 2, 3]\n```","summary":"<p>The comparison operator.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : Int32","source_link":null,"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":"if @scale > other.scale\n  @value <=> (other.scale_to(self)).value\nelse\n  if @scale < other.scale\n    (scale_to(other)).value <=> other.value\n  else\n    @value <=> other.value\n  end\nend"}},{"id":"(other:Int|Float|BigRational)-instance-method","html_id":"(other:Int|Float|BigRational)-instance-method","name":"<=>","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int | Float | BigRational"}],"args_string":"(other : Int | Float | BigRational)","source_link":null,"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int | Float | BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self <=> (BigDecimal.new(other))"}},{"id":"==(other:BigDecimal):Bool-instance-method","html_id":"==(other:BigDecimal):Bool-instance-method","name":"==","doc":"Compares this object to *other* based on the receiver’s `<=>` method,\nreturning `true` if it returns `0`.\n\nAlso returns `true` if this and *other* are the same object.","summary":"<p>Compares this object to <em>other</em> based on the receiver’s <code><a href=\"BigDecimal.html#(other:BigDecimal):Int32-instance-method\">#<=></a></code> method, returning <code>true</code> if it returns <code>0</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : Bool","source_link":null,"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"case @scale\nwhen  > other.scale\n  scaled = other.value * (power_ten_to(@scale - other.scale))\n  @value == scaled\nwhen  < other.scale\n  scaled = @value * (power_ten_to(other.scale - @scale))\n  scaled == other.value\nelse\n  @value == other.value\nend"}},{"id":"ceil:BigDecimal-instance-method","html_id":"ceil:BigDecimal-instance-method","name":"ceil","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : BigDecimal","source_link":null,"def":{"name":"ceil","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"mask = power_ten_to(@scale)\ndiff = (mask - (@value % mask)) % mask\nself + (BigDecimal.new(diff, @scale))\n"}},{"id":"clone-instance-method","html_id":"clone-instance-method","name":"clone","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"div(other:BigDecimal,max_div_iterations=DEFAULT_MAX_DIV_ITERATIONS):BigDecimal-instance-method","html_id":"div(other:BigDecimal,max_div_iterations=DEFAULT_MAX_DIV_ITERATIONS):BigDecimal-instance-method","name":"div","doc":"Divides `self` with another `BigDecimal`, with a optionally configurable *max_div_iterations*, which\ndefines a maximum number of iterations in case the division is not exact.\n\n```\nBigDecimal.new(1).div(BigDecimal.new(2))    # => BigDecimal(@value=5, @scale=2)\nBigDecimal.new(1).div(BigDecimal.new(3), 5) # => BigDecimal(@value=33333, @scale=5)\n```","summary":"<p>Divides <code>self</code> with another <code><a href=\"BigDecimal.html\">BigDecimal</a></code>, with a optionally configurable <em>max_div_iterations</em>, which defines a maximum number of iterations in case the division is not exact.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"},{"name":"max_div_iterations","doc":null,"default_value":"DEFAULT_MAX_DIV_ITERATIONS","external_name":"max_div_iterations","restriction":""}],"args_string":"(other : BigDecimal, max_div_iterations = <span class=\"t\">DEFAULT_MAX_DIV_ITERATIONS</span>) : BigDecimal","source_link":null,"def":{"name":"div","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"},{"name":"max_div_iterations","doc":null,"default_value":"DEFAULT_MAX_DIV_ITERATIONS","external_name":"max_div_iterations","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"check_division_by_zero(other)\nother.factor_powers_of_ten\nscale = @scale - other.scale\nnumerator, denominator = @value, other.@value\nquotient, remainder = numerator.divmod(denominator)\nif remainder == ZERO\n  return BigDecimal.new(normalize_quotient(other, quotient), scale)\nend\nremainder = remainder * TEN\ni = 0\nwhile (remainder != ZERO) && i < max_div_iterations\n  inner_quotient, inner_remainder = remainder.divmod(denominator)\n  quotient = (quotient * TEN) + inner_quotient\n  remainder = inner_remainder * TEN\n  i = i + 1\nend\nBigDecimal.new(normalize_quotient(other, quotient), scale + i)\n"}},{"id":"floor:BigDecimal-instance-method","html_id":"floor:BigDecimal-instance-method","name":"floor","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : BigDecimal","source_link":null,"def":{"name":"floor","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"in_scale(0)"}},{"id":"hash(hasher)-instance-method","html_id":"hash(hasher)-instance-method","name":"hash","doc":"Appends this object's value to *hasher*, and returns the modified *hasher*.\n\nUsually the macro `def_hash` can be used to generate this method.\nOtherwise, invoke `hash(hasher)` on each object's instance variables to\naccumulate the result:\n\n```\ndef hash(hasher)\n  hasher = @some_ivar.hash(hasher)\n  hasher = @some_other_ivar.hash(hasher)\n  hasher\nend\n```","summary":"<p>Appends this object's value to <em>hasher</em>, and returns the modified <em>hasher</em>.</p>","abstract":false,"args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"args_string":"(hasher)","source_link":null,"def":{"name":"hash","args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"hasher.string(to_s)"}},{"id":"normalize_quotient(other:BigDecimal,quotient:BigInt):BigInt-instance-method","html_id":"normalize_quotient(other:BigDecimal,quotient:BigInt):BigInt-instance-method","name":"normalize_quotient","doc":"Returns the *quotient* as absolutely negative if `self` and *other* have\ndifferent signs, otherwise returns the *quotient*.","summary":"<p>Returns the <em>quotient</em> as absolutely negative if <code>self</code> and <em>other</em> have different signs, otherwise returns the <em>quotient</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"},{"name":"quotient","doc":null,"default_value":"","external_name":"quotient","restriction":"BigInt"}],"args_string":"(other : BigDecimal, quotient : BigInt) : BigInt","source_link":null,"def":{"name":"normalize_quotient","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"},{"name":"quotient","doc":null,"default_value":"","external_name":"quotient","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"if (@value < 0 && other.value > 0) || (other.value < 0 && @value > 0)\n  -quotient.abs\nelse\n  quotient\nend"}},{"id":"scale:UInt64-instance-method","html_id":"scale:UInt64-instance-method","name":"scale","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : UInt64","source_link":null,"def":{"name":"scale","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"UInt64","visibility":"Public","body":"@scale"}},{"id":"scale_to(new_scale:BigDecimal):BigDecimal-instance-method","html_id":"scale_to(new_scale:BigDecimal):BigDecimal-instance-method","name":"scale_to","doc":"Scales a `BigDecimal` to another `BigDecimal`, so they can be\ncomputed easier.","summary":"<p>Scales a <code><a href=\"BigDecimal.html\">BigDecimal</a></code> to another <code><a href=\"BigDecimal.html\">BigDecimal</a></code>, so they can be computed easier.</p>","abstract":false,"args":[{"name":"new_scale","doc":null,"default_value":"","external_name":"new_scale","restriction":"BigDecimal"}],"args_string":"(new_scale : BigDecimal) : BigDecimal","source_link":null,"def":{"name":"scale_to","args":[{"name":"new_scale","doc":null,"default_value":"","external_name":"new_scale","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"in_scale(new_scale.scale)"}},{"id":"to_big_d-instance-method","html_id":"to_big_d-instance-method","name":"to_big_d","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_big_d","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"to_big_f-instance-method","html_id":"to_big_f-instance-method","name":"to_big_f","doc":"Converts to `BigFloat`.","summary":"<p>Converts to <code><a href=\"BigFloat.html\">BigFloat</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_big_f","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigFloat.new(to_s)"}},{"id":"to_big_i-instance-method","html_id":"to_big_i-instance-method","name":"to_big_i","doc":"Converts to `BigInt`. Truncates anything on the right side of the decimal point.","summary":"<p>Converts to <code><a href=\"BigInt.html\">BigInt</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_big_i","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if self >= 0\n  self.floor.value\nelse\n  self.ceil.value\nend"}},{"id":"to_big_r-instance-method","html_id":"to_big_r-instance-method","name":"to_big_r","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_big_r","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigRational.new(self.value, BigDecimal::TEN ** self.scale)"}},{"id":"to_f-instance-method","html_id":"to_f-instance-method","name":"to_f","doc":"Converts to `Float64`.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"Float64.html\">Float64</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64"}},{"id":"to_f!-instance-method","html_id":"to_f!-instance-method","name":"to_f!","doc":"Converts to `Float64`.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"Float64.html\">Float64</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64!"}},{"id":"to_f32-instance-method","html_id":"to_f32-instance-method","name":"to_f32","doc":"Converts to `Float32`.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"Float32.html\">Float32</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_f32"}},{"id":"to_f32!-instance-method","html_id":"to_f32!-instance-method","name":"to_f32!","doc":"Converts to `Float32`.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"Float32.html\">Float32</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f32!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_f32!"}},{"id":"to_f64-instance-method","html_id":"to_f64-instance-method","name":"to_f64","doc":"Converts to `Float64`.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"Float64.html\">Float64</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_s.to_f64"}},{"id":"to_f64!-instance-method","html_id":"to_f64!-instance-method","name":"to_f64!","doc":"Converts to `Float64`.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"Float64.html\">Float64</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f64!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64"}},{"id":"to_i-instance-method","html_id":"to_i-instance-method","name":"to_i","doc":"Converts to `Int32`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"Int32.html\">Int32</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i32"}},{"id":"to_i!-instance-method","html_id":"to_i!-instance-method","name":"to_i!","doc":"Converts to `Int32`. Truncates anything on the right side of the decimal point.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"Int32.html\">Int32</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i32!"}},{"id":"to_i16-instance-method","html_id":"to_i16-instance-method","name":"to_i16","doc":"Converts to `Int16`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"Int16.html\">Int16</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i16","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_i.to_i16"}},{"id":"to_i16!-instance-method","html_id":"to_i16!-instance-method","name":"to_i16!","doc":"Converts to `Int16`. Truncates anything on the right side of the decimal point.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"Int16.html\">Int16</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i16!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_i.to_i16!"}},{"id":"to_i32-instance-method","html_id":"to_i32-instance-method","name":"to_i32","doc":"Converts to `Int32`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"Int32.html\">Int32</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_i.to_i32"}},{"id":"to_i32!-instance-method","html_id":"to_i32!-instance-method","name":"to_i32!","doc":"Converts to `Int32`. Truncates anything on the right side of the decimal point.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"Int32.html\">Int32</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i32!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_i.to_i32!"}},{"id":"to_i64-instance-method","html_id":"to_i64-instance-method","name":"to_i64","doc":"Converts to `Int64`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"Int64.html\">Int64</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_i.to_i64"}},{"id":"to_i64!-instance-method","html_id":"to_i64!-instance-method","name":"to_i64!","doc":"Converts to `Int64`. Truncates anything on the right side of the decimal point.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"Int64.html\">Int64</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i64!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_i.to_i64!"}},{"id":"to_i8-instance-method","html_id":"to_i8-instance-method","name":"to_i8","doc":"Converts to `Int8`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"Int8.html\">Int8</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i8","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_i.to_i8"}},{"id":"to_i8!-instance-method","html_id":"to_i8!-instance-method","name":"to_i8!","doc":"Converts to `Int8`. Truncates anything on the right side of the decimal point.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"Int8.html\">Int8</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i8!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_i.to_i8!"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Appends a `String` representation of this object\nto the given `IO` object.\n\nAn object must never append itself to the io argument,\nas this will in turn call `to_s(io)` on it.","summary":"<p>Appends a <code><a href=\"String.html\">String</a></code> representation of this object to the given <code><a href=\"IO.html\">IO</a></code> object.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"factor_powers_of_ten\ns = @value.to_s\nif @scale == 0\n  io << s\n  return\nend\nif @scale >= s.size && @value >= 0\n  io << \"0.\"\n  (@scale - s.size).times do\n    io << '0'\n  end\n  io << s\nelse\n  if @scale >= s.size && @value < 0\n    io << \"-0.0\"\n    (@scale - s.size).times do\n      io << '0'\n    end\n    io << s[1..-1]\n  else\n    offset = s.size - @scale\n    ((io << s[0...offset]) << '.') << s[offset..-1]\n  end\nend\n"}},{"id":"to_u-instance-method","html_id":"to_u-instance-method","name":"to_u","doc":"Converts to `UInt32`. Truncates anything on the right side of the decimal point,\nconverting negative to positive.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"UInt32.html\">UInt32</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u32"}},{"id":"to_u!-instance-method","html_id":"to_u!-instance-method","name":"to_u!","doc":"Converts to `UInt32`. Truncates anything on the right side of the decimal point,\nconverting negative to positive.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"UInt32.html\">UInt32</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u32!"}},{"id":"to_u16-instance-method","html_id":"to_u16-instance-method","name":"to_u16","doc":"Converts to `UInt16`. Truncates anything on the right side of the decimal point,\nconverting negative to positive.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"UInt16.html\">UInt16</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u16","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_u.to_u16"}},{"id":"to_u16!-instance-method","html_id":"to_u16!-instance-method","name":"to_u16!","doc":"Converts to `UInt16`. Truncates anything on the right side of the decimal point,\nconverting negative to positive.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"UInt16.html\">UInt16</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u16!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_u.to_u16!"}},{"id":"to_u32-instance-method","html_id":"to_u32-instance-method","name":"to_u32","doc":"Converts to `UInt32`. Truncates anything on the right side of the decimal point,\nconverting negative to positive.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"UInt32.html\">UInt32</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_u.to_u32"}},{"id":"to_u32!-instance-method","html_id":"to_u32!-instance-method","name":"to_u32!","doc":"Converts to `UInt32`. Truncates anything on the right side of the decimal point,\nconverting negative to positive.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"UInt32.html\">UInt32</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u32!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_u.to_u32!"}},{"id":"to_u64-instance-method","html_id":"to_u64-instance-method","name":"to_u64","doc":"Converts to `UInt64`. Truncates anything on the right side of the decimal point,\nconverting negative to positive.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"UInt64.html\">UInt64</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_u.to_u64"}},{"id":"to_u64!-instance-method","html_id":"to_u64!-instance-method","name":"to_u64!","doc":"Converts to `UInt64`. Truncates anything on the right side of the decimal point,\nconverting negative to positive.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"UInt64.html\">UInt64</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u64!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_u.to_u64!"}},{"id":"to_u8-instance-method","html_id":"to_u8-instance-method","name":"to_u8","doc":"Converts to `UInt8`. Truncates anything on the right side of the decimal point,\nconverting negative to positive.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"UInt8.html\">UInt8</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u8","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_u.to_u8"}},{"id":"to_u8!-instance-method","html_id":"to_u8!-instance-method","name":"to_u8!","doc":"Converts to `UInt8`. Truncates anything on the right side of the decimal point,\nconverting negative to positive.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"UInt8.html\">UInt8</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u8!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_u.to_u8!"}},{"id":"trunc:BigDecimal-instance-method","html_id":"trunc:BigDecimal-instance-method","name":"trunc","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : BigDecimal","source_link":null,"def":{"name":"trunc","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"self < 0 ? ceil : floor"}},{"id":"value:BigInt-instance-method","html_id":"value:BigInt-instance-method","name":"value","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : BigInt","source_link":null,"def":{"name":"value","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"@value"}}],"macros":[],"types":[]},{"html_id":"/BigFloat","path":"BigFloat.html","kind":"struct","full_name":"BigFloat","name":"BigFloat","abstract":false,"superclass":{"html_id":"/Float","kind":"struct","full_name":"Float","name":"Float"},"ancestors":[{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Float","kind":"struct","full_name":"Float","name":"Float"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Number","kind":"struct","full_name":"Number","name":"Number"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"}],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"A `BigFloat` can represent arbitrarily large floats.\n\nIt is implemented under the hood with [GMP](https://gmplib.org/).","summary":"<p>A <code><a href=\"BigFloat.html\">BigFloat</a></code> can represent arbitrarily large floats.</p>","class_methods":[{"id":"default_precision-class-method","html_id":"default_precision-class-method","name":"default_precision","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"default_precision","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpf_get_default_prec"}},{"id":"default_precision=(prec:Int)-class-method","html_id":"default_precision=(prec:Int)-class-method","name":"default_precision=","doc":null,"summary":null,"abstract":false,"args":[{"name":"prec","doc":null,"default_value":"","external_name":"prec","restriction":"Int"}],"args_string":"(prec : Int)","source_link":null,"def":{"name":"default_precision=","args":[{"name":"prec","doc":null,"default_value":"","external_name":"prec","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpf_set_default_prec(prec.to_u64)"}}],"constructors":[{"id":"new(num:Float,precision:Int)-class-method","html_id":"new(num:Float,precision:Int)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Float"},{"name":"precision","doc":null,"default_value":"","external_name":"precision","restriction":"Int"}],"args_string":"(num : Float, precision : Int)","source_link":null,"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Float"},{"name":"precision","doc":null,"default_value":"","external_name":"precision","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num, precision)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(str:String)-class-method","html_id":"new(str:String)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"str","doc":null,"default_value":"","external_name":"str","restriction":"String"}],"args_string":"(str : String)","source_link":null,"def":{"name":"new","args":[{"name":"str","doc":null,"default_value":"","external_name":"str","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(str)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:BigInt)-class-method","html_id":"new(num:BigInt)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigInt"}],"args_string":"(num : BigInt)","source_link":null,"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:BigRational)-class-method","html_id":"new(num:BigRational)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigRational"}],"args_string":"(num : BigRational)","source_link":null,"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:BigFloat)-class-method","html_id":"new(num:BigFloat)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigFloat"}],"args_string":"(num : BigFloat)","source_link":null,"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigFloat"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:Int8|Int16|Int32)-class-method","html_id":"new(num:Int8|Int16|Int32)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Int8 | Int16 | Int32"}],"args_string":"(num : Int8 | Int16 | Int32)","source_link":null,"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Int8 | Int16 | Int32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:UInt8|UInt16|UInt32)-class-method","html_id":"new(num:UInt8|UInt16|UInt32)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"UInt8 | UInt16 | UInt32"}],"args_string":"(num : UInt8 | UInt16 | UInt32)","source_link":null,"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"UInt8 | UInt16 | UInt32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:Int64)-class-method","html_id":"new(num:Int64)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Int64"}],"args_string":"(num : Int64)","source_link":null,"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Int64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:UInt64)-class-method","html_id":"new(num:UInt64)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"UInt64"}],"args_string":"(num : UInt64)","source_link":null,"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"UInt64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:Number)-class-method","html_id":"new(num:Number)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Number"}],"args_string":"(num : Number)","source_link":null,"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Number"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(mpf:LibGMP::MPF)-class-method","html_id":"new(mpf:LibGMP::MPF)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"mpf","doc":null,"default_value":"","external_name":"mpf","restriction":"LibGMP::MPF"}],"args_string":"(mpf : LibGMP::MPF)","source_link":null,"def":{"name":"new","args":[{"name":"mpf","doc":null,"default_value":"","external_name":"mpf","restriction":"LibGMP::MPF"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(mpf)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new-class-method","html_id":"new-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"new","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(&block)-class-method","html_id":"new(&amp;block)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"(&block)","source_link":null,"def":{"name":"new","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpf_init(out mpf)\nyield pointerof(mpf)\nnew(mpf)\n"}}],"instance_methods":[{"id":"*(other:Number)-instance-method","html_id":"*(other:Number)-instance-method","name":"*","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"args_string":"(other : Number)","source_link":null,"def":{"name":"*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigFloat.new do |mpf|\n  LibGMP.mpf_mul(mpf, self, other.to_big_f)\nend"}},{"id":"**(other:Int)-instance-method","html_id":"**(other:Int)-instance-method","name":"**","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int)","source_link":null,"def":{"name":"**","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigFloat.new do |mpf|\n  LibGMP.mpf_pow_ui(mpf, self, other.to_u64)\nend"}},{"id":"+(other:Number)-instance-method","html_id":"+(other:Number)-instance-method","name":"+","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"args_string":"(other : Number)","source_link":null,"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigFloat.new do |mpf|\n  LibGMP.mpf_add(mpf, self, other.to_big_f)\nend"}},{"id":"-(other:Number)-instance-method","html_id":"-(other:Number)-instance-method","name":"-","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"args_string":"(other : Number)","source_link":null,"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigFloat.new do |mpf|\n  LibGMP.mpf_sub(mpf, self, other.to_big_f)\nend"}},{"id":"--instance-method","html_id":"--instance-method","name":"-","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"-","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigFloat.new do |mpf|\n  LibGMP.mpf_neg(mpf, self)\nend"}},{"id":"/(other:UInt8|UInt16|UInt32|UInt64)-instance-method","html_id":"/(other:UInt8|UInt16|UInt32|UInt64)-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt8 | UInt16 | UInt32 | UInt64"}],"args_string":"(other : UInt8 | UInt16 | UInt32 | UInt64)","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt8 | UInt16 | UInt32 | UInt64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if other == 0\n  raise(DivisionByZeroError.new)\nend\nif other.is_a?(UInt8 | UInt16 | UInt32) || ((LibGMP::ULong == UInt64) && other.is_a?(UInt64))\n  BigFloat.new do |mpf|\n    LibGMP.mpf_div_ui(mpf, self, other)\n  end\nelse\n  BigFloat.new do |mpf|\n    LibGMP.mpf_div(mpf, self, other.to_big_f)\n  end\nend\n"}},{"id":"/(other:Float64):BigFloat-instance-method","html_id":"/(other:Float64):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float64"}],"args_string":"(other : Float64) : BigFloat","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Float32):BigFloat-instance-method","html_id":"/(other:Float32):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float32"}],"args_string":"(other : Float32) : BigFloat","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:UInt128):BigFloat-instance-method","html_id":"/(other:UInt128):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt128"}],"args_string":"(other : UInt128) : BigFloat","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt128"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Int128):BigFloat-instance-method","html_id":"/(other:Int128):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int128"}],"args_string":"(other : Int128) : BigFloat","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int128"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Int64):BigFloat-instance-method","html_id":"/(other:Int64):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int64"}],"args_string":"(other : Int64) : BigFloat","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Int32):BigFloat-instance-method","html_id":"/(other:Int32):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int32"}],"args_string":"(other : Int32) : BigFloat","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Int16):BigFloat-instance-method","html_id":"/(other:Int16):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int16"}],"args_string":"(other : Int16) : BigFloat","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int16"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Int8):BigFloat-instance-method","html_id":"/(other:Int8):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int8"}],"args_string":"(other : Int8) : BigFloat","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int8"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:BigRational):BigRational-instance-method","html_id":"/(other:BigRational):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational) : BigRational","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:BigDecimal):BigDecimal-instance-method","html_id":"/(other:BigDecimal):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : BigDecimal","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:BigInt):BigFloat-instance-method","html_id":"/(other:BigInt):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigFloat","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:BigFloat)-instance-method","html_id":"/(other:BigFloat)-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigFloat"}],"args_string":"(other : BigFloat)","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigFloat"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if other == 0\n  raise(DivisionByZeroError.new)\nend\nBigFloat.new do |mpf|\n  LibGMP.mpf_div(mpf, self, other)\nend\n"}},{"id":"(other:Number)-instance-method","html_id":"(other:Number)-instance-method","name":"<=>","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"args_string":"(other : Number)","source_link":null,"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if other.is_a?(Int8 | Int16 | Int32) || ((LibGMP::Long == Int64) && other.is_a?(Int64))\n  LibGMP.mpf_cmp_si(self, other)\nelse\n  if other.is_a?(UInt8 | UInt16 | UInt32) || ((LibGMP::ULong == UInt64) && other.is_a?(UInt64))\n    LibGMP.mpf_cmp_ui(self, other)\n  else\n    LibGMP.mpf_cmp(self, other.to_big_f)\n  end\nend"}},{"id":"(other:Float32|Float64)-instance-method","html_id":"(other:Float32|Float64)-instance-method","name":"<=>","doc":"The comparison operator. Returns `0` if the two objects are equal,\na negative number if this object is considered less than *other*,\na positive number if this object is considered greter than *other*,\nor `nil` if the two objects are not comparable.\n\nSubclasses define this method to provide class-specific ordering.\n\nThe comparison operator is usually used to sort values:\n\n```\n# Sort in a descending way:\n[3, 1, 2].sort { |x, y| y <=> x } # => [3, 2, 1]\n\n# Sort in an ascending way:\n[3, 1, 2].sort { |x, y| x <=> y } # => [1, 2, 3]\n```","summary":"<p>The comparison operator.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float32 | Float64"}],"args_string":"(other : Float32 | Float64)","source_link":null,"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float32 | Float64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpf_cmp_d(self, other.to_f64)"}},{"id":"(other:BigInt)-instance-method","html_id":"(other:BigInt)-instance-method","name":"<=>","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt)","source_link":null,"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpf_cmp_z(self, other)"}},{"id":"(other:BigFloat)-instance-method","html_id":"(other:BigFloat)-instance-method","name":"<=>","doc":"The comparison operator. Returns `0` if the two objects are equal,\na negative number if this object is considered less than *other*,\na positive number if this object is considered greter than *other*,\nor `nil` if the two objects are not comparable.\n\nSubclasses define this method to provide class-specific ordering.\n\nThe comparison operator is usually used to sort values:\n\n```\n# Sort in a descending way:\n[3, 1, 2].sort { |x, y| y <=> x } # => [3, 2, 1]\n\n# Sort in an ascending way:\n[3, 1, 2].sort { |x, y| x <=> y } # => [1, 2, 3]\n```","summary":"<p>The comparison operator.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigFloat"}],"args_string":"(other : BigFloat)","source_link":null,"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigFloat"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpf_cmp(self, other)"}},{"id":"abs-instance-method","html_id":"abs-instance-method","name":"abs","doc":"Returns the absolute value of this number.\n\n```\n123.abs  # => 123\n-123.abs # => 123\n```","summary":"<p>Returns the absolute value of this number.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"abs","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigFloat.new do |mpf|\n  LibGMP.mpf_abs(mpf, self)\nend"}},{"id":"ceil-instance-method","html_id":"ceil-instance-method","name":"ceil","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"ceil","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigFloat.new do |mpf|\n  LibGMP.mpf_ceil(mpf, self)\nend"}},{"id":"clone-instance-method","html_id":"clone-instance-method","name":"clone","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"floor-instance-method","html_id":"floor-instance-method","name":"floor","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"floor","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigFloat.new do |mpf|\n  LibGMP.mpf_floor(mpf, self)\nend"}},{"id":"hash(hasher)-instance-method","html_id":"hash(hasher)-instance-method","name":"hash","doc":"TODO: improve this","summary":"<p><span class=\"flag orange\">TODO</span>  improve this</p>","abstract":false,"args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"args_string":"(hasher)","source_link":null,"def":{"name":"hash","args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"hasher = to_f64.hash(hasher)\nhasher\n"}},{"id":"to_big_f-instance-method","html_id":"to_big_f-instance-method","name":"to_big_f","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_big_f","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"to_big_i-instance-method","html_id":"to_big_i-instance-method","name":"to_big_i","doc":"Returns a `BigInt` representing this float (rounded using `floor`).\n```\nrequire \"big\"\n\n1212341515125412412412421.0.to_big_i\n```","summary":"<p>Returns a <code><a href=\"BigInt.html\">BigInt</a></code> representing this float (rounded using <code><a href=\"BigFloat.html#floor-instance-method\">#floor</a></code>).</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_big_i","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.set_f(mpz, mpf)\nend"}},{"id":"to_f-instance-method","html_id":"to_f-instance-method","name":"to_f","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64"}},{"id":"to_f!-instance-method","html_id":"to_f!-instance-method","name":"to_f!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64!"}},{"id":"to_f32-instance-method","html_id":"to_f32-instance-method","name":"to_f32","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_f32"}},{"id":"to_f32!-instance-method","html_id":"to_f32!-instance-method","name":"to_f32!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f32!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_f32!"}},{"id":"to_f64-instance-method","html_id":"to_f64-instance-method","name":"to_f64","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpf_get_d(self)"}},{"id":"to_f64!-instance-method","html_id":"to_f64!-instance-method","name":"to_f64!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f64!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64"}},{"id":"to_i-instance-method","html_id":"to_i-instance-method","name":"to_i","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i32"}},{"id":"to_i!-instance-method","html_id":"to_i!-instance-method","name":"to_i!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i32!"}},{"id":"to_i16-instance-method","html_id":"to_i16-instance-method","name":"to_i16","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i16","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i64.to_i16"}},{"id":"to_i16!-instance-method","html_id":"to_i16!-instance-method","name":"to_i16!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i16!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.mpf_get_si(self)).to_i16!"}},{"id":"to_i32-instance-method","html_id":"to_i32-instance-method","name":"to_i32","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i64.to_i32"}},{"id":"to_i32!-instance-method","html_id":"to_i32!-instance-method","name":"to_i32!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i32!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.mpf_get_si(self)).to_i32!"}},{"id":"to_i64-instance-method","html_id":"to_i64-instance-method","name":"to_i64","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpf_get_si(self)"}},{"id":"to_i64!-instance-method","html_id":"to_i64!-instance-method","name":"to_i64!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i64!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpf_get_si(self)"}},{"id":"to_i8-instance-method","html_id":"to_i8-instance-method","name":"to_i8","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i8","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i64.to_i8"}},{"id":"to_i8!-instance-method","html_id":"to_i8!-instance-method","name":"to_i8!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i8!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.mpf_get_si(self)).to_i8!"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Appends a `String` representation of this object\nto the given `IO` object.\n\nAn object must never append itself to the io argument,\nas this will in turn call `to_s(io)` on it.","summary":"<p>Appends a <code><a href=\"String.html\">String</a></code> representation of this object to the given <code><a href=\"IO.html\">IO</a></code> object.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"cstr = LibGMP.mpf_get_str(nil, out expptr, 10, 0, self)\nlength = LibC.strlen(cstr)\ndecimal_set = false\nif self < 0\n  io << '-'\nend\nif expptr == 0\n  io << 0\nelse\n  if expptr < 0\n    (io << 0) << '.'\n    decimal_set = true\n    expptr.abs.times do\n      io << 0\n    end\n  end\nend\nif self < 0\n  expptr = expptr + 1\nend\nlength.times do |i|\n  if cstr[i] == 45\n    next\n  end\n  if i == expptr\n    io << '.'\n    decimal_set = true\n  end\n  io << cstr[i].unsafe_chr\nend\nif expptr > 0\n  (expptr - length).times do\n    io << 0\n  end\nend\nif !decimal_set\n  io << \".0\"\nend\n"}},{"id":"to_u-instance-method","html_id":"to_u-instance-method","name":"to_u","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u32"}},{"id":"to_u!-instance-method","html_id":"to_u!-instance-method","name":"to_u!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u32!"}},{"id":"to_u16-instance-method","html_id":"to_u16-instance-method","name":"to_u16","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u16","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u64.to_u16"}},{"id":"to_u16!-instance-method","html_id":"to_u16!-instance-method","name":"to_u16!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u16!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.mpf_get_ui(self)).to_u16!"}},{"id":"to_u32-instance-method","html_id":"to_u32-instance-method","name":"to_u32","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u64.to_u32"}},{"id":"to_u32!-instance-method","html_id":"to_u32!-instance-method","name":"to_u32!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u32!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.mpf_get_ui(self)).to_u32!"}},{"id":"to_u64-instance-method","html_id":"to_u64-instance-method","name":"to_u64","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpf_get_ui(self)"}},{"id":"to_u64!-instance-method","html_id":"to_u64!-instance-method","name":"to_u64!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u64!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpf_get_ui(self)"}},{"id":"to_u8-instance-method","html_id":"to_u8-instance-method","name":"to_u8","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u8","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u64.to_u8"}},{"id":"to_u8!-instance-method","html_id":"to_u8!-instance-method","name":"to_u8!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u8!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.mpf_get_ui(self)).to_u8!"}},{"id":"to_unsafe-instance-method","html_id":"to_unsafe-instance-method","name":"to_unsafe","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_unsafe","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"mpf"}},{"id":"trunc-instance-method","html_id":"trunc-instance-method","name":"trunc","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"trunc","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigFloat.new do |mpf|\n  LibGMP.mpf_trunc(mpf, self)\nend"}}],"macros":[],"types":[]},{"html_id":"/BigInt","path":"BigInt.html","kind":"struct","full_name":"BigInt","name":"BigInt","abstract":false,"superclass":{"html_id":"/Int","kind":"struct","full_name":"Int","name":"Int"},"ancestors":[{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Int","kind":"struct","full_name":"Int","name":"Int"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Number","kind":"struct","full_name":"Number","name":"Number"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"}],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"A `BigInt` can represent arbitrarily large integers.\n\nIt is implemented under the hood with [GMP](https://gmplib.org/).","summary":"<p>A <code><a href=\"BigInt.html\">BigInt</a></code> can represent arbitrarily large integers.</p>","class_methods":[],"constructors":[{"id":"new(str:String,base=10)-class-method","html_id":"new(str:String,base=10)-class-method","name":"new","doc":"Creates a `BigInt` with the value denoted by *str* in the given *base*.\n\nRaises `ArgumentError` if the string doesn't denote a valid integer.\n\n```\nrequire \"big\"\n\nBigInt.new(\"123456789123456789123456789123456789\") # => 123456789123456789123456789123456789\nBigInt.new(\"123_456_789_123_456_789_123_456_789\")  # => 123456789123456789123456789\nBigInt.new(\"1234567890ABCDEF\", base: 16)           # => 1311768467294899695\n```","summary":"<p>Creates a <code><a href=\"BigInt.html\">BigInt</a></code> with the value denoted by <em>str</em> in the given <em>base</em>.</p>","abstract":false,"args":[{"name":"str","doc":null,"default_value":"","external_name":"str","restriction":"String"},{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":""}],"args_string":"(str : String, base = <span class=\"n\">10</span>)","source_link":null,"def":{"name":"new","args":[{"name":"str","doc":null,"default_value":"","external_name":"str","restriction":"String"},{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(str, base)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:Int::Signed)-class-method","html_id":"new(num:Int::Signed)-class-method","name":"new","doc":"Creates a `BigInt` from the given *num*.","summary":"<p>Creates a <code><a href=\"BigInt.html\">BigInt</a></code> from the given <em>num</em>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Int::Signed"}],"args_string":"(num : Int::Signed)","source_link":null,"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Int::Signed"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:Int::Unsigned)-class-method","html_id":"new(num:Int::Unsigned)-class-method","name":"new","doc":"Creates a `BigInt` from the given *num*.","summary":"<p>Creates a <code><a href=\"BigInt.html\">BigInt</a></code> from the given <em>num</em>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Int::Unsigned"}],"args_string":"(num : Int::Unsigned)","source_link":null,"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Int::Unsigned"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:Float::Primitive)-class-method","html_id":"new(num:Float::Primitive)-class-method","name":"new","doc":"Creates a `BigInt` from the given *num*.","summary":"<p>Creates a <code><a href=\"BigInt.html\">BigInt</a></code> from the given <em>num</em>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Float::Primitive"}],"args_string":"(num : Float::Primitive)","source_link":null,"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Float::Primitive"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:BigFloat)-class-method","html_id":"new(num:BigFloat)-class-method","name":"new","doc":"Creates a `BigInt` from the given *num*.","summary":"<p>Creates a <code><a href=\"BigInt.html\">BigInt</a></code> from the given <em>num</em>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigFloat"}],"args_string":"(num : BigFloat)","source_link":null,"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigFloat"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"num.to_big_i"}},{"id":"new(num:BigDecimal)-class-method","html_id":"new(num:BigDecimal)-class-method","name":"new","doc":"Creates a `BigInt` from the given *num*.","summary":"<p>Creates a <code><a href=\"BigInt.html\">BigInt</a></code> from the given <em>num</em>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigDecimal"}],"args_string":"(num : BigDecimal)","source_link":null,"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"num.to_big_i"}},{"id":"new(num:BigRational)-class-method","html_id":"new(num:BigRational)-class-method","name":"new","doc":"Creates a `BigInt` from the given *num*.","summary":"<p>Creates a <code><a href=\"BigInt.html\">BigInt</a></code> from the given <em>num</em>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigRational"}],"args_string":"(num : BigRational)","source_link":null,"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"num.to_big_i"}},{"id":"new(num:BigInt)-class-method","html_id":"new(num:BigInt)-class-method","name":"new","doc":"Returns *num*. Useful for generic code that does `T.new(...)` with `T`\nbeing a `Number`.","summary":"<p>Returns <em>num</em>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigInt"}],"args_string":"(num : BigInt)","source_link":null,"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"num"}},{"id":"new-class-method","html_id":"new-class-method","name":"new","doc":"Creates a `BigInt` with the value zero.\n\n```\nrequire \"big\"\n\nBigInt.new # => 0\n```","summary":"<p>Creates a <code><a href=\"BigInt.html\">BigInt</a></code> with the value zero.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"new","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"%(other:Int):BigInt-instance-method","html_id":"%(other:Int):BigInt-instance-method","name":"%","doc":"Returns `self` modulo *other*.\n\nThis uses floored division.\n\nSee `Int#/` for more details.","summary":"<p>Returns <code>self</code> modulo <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","source_link":null,"def":{"name":"%","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"check_division_by_zero(other)\nif other < 0\n  -((-self).unsafe_floored_mod(-other))\nelse\n  unsafe_floored_mod(other)\nend\n"}},{"id":"&(other:Int):BigInt-instance-method","html_id":"&amp;(other:Int):BigInt-instance-method","name":"&","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","source_link":null,"def":{"name":"&","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.and(mpz, self, other.to_big_i)\nend"}},{"id":"&*(other):BigInt-instance-method","html_id":"&amp;*(other):BigInt-instance-method","name":"&*","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"args_string":"(other) : BigInt","source_link":null,"def":{"name":"&*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"self * other"}},{"id":"&+(other):BigInt-instance-method","html_id":"&amp;+(other):BigInt-instance-method","name":"&+","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"args_string":"(other) : BigInt","source_link":null,"def":{"name":"&+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"self + other"}},{"id":"&-(other):BigInt-instance-method","html_id":"&amp;-(other):BigInt-instance-method","name":"&-","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"args_string":"(other) : BigInt","source_link":null,"def":{"name":"&-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"self - other"}},{"id":"*(other:Int):BigInt-instance-method","html_id":"*(other:Int):BigInt-instance-method","name":"*","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","source_link":null,"def":{"name":"*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"self * other.to_big_i"}},{"id":"*(other:LibGMP::IntPrimitiveUnsigned):BigInt-instance-method","html_id":"*(other:LibGMP::IntPrimitiveUnsigned):BigInt-instance-method","name":"*","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"LibGMP::IntPrimitiveUnsigned"}],"args_string":"(other : LibGMP::IntPrimitiveUnsigned) : BigInt","source_link":null,"def":{"name":"*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"LibGMP::IntPrimitiveUnsigned"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.mul_ui(mpz, self, other)\nend"}},{"id":"*(other:LibGMP::IntPrimitiveSigned):BigInt-instance-method","html_id":"*(other:LibGMP::IntPrimitiveSigned):BigInt-instance-method","name":"*","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"LibGMP::IntPrimitiveSigned"}],"args_string":"(other : LibGMP::IntPrimitiveSigned) : BigInt","source_link":null,"def":{"name":"*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"LibGMP::IntPrimitiveSigned"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.mul_si(mpz, self, other)\nend"}},{"id":"*(other:BigInt):BigInt-instance-method","html_id":"*(other:BigInt):BigInt-instance-method","name":"*","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","source_link":null,"def":{"name":"*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.mul(mpz, self, other)\nend"}},{"id":"**(other:Int):BigInt-instance-method","html_id":"**(other:Int):BigInt-instance-method","name":"**","doc":"Returns the value of raising `self` to the power of *exponent*.\n\nRaises `ArgumentError` if *exponent* is negative: if this is needed,\neither use a float base or a float exponent.\n\nRaises `OverflowError` in case of overflow.\n\n```\n2 ** 3  # => 8\n2 ** 0  # => 1\n2 ** -1 # ArgumentError\n```","summary":"<p>Returns the value of raising <code>self</code> to the power of <em>exponent</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","source_link":null,"def":{"name":"**","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"if other < 0\n  raise(ArgumentError.new(\"Negative exponent isn't supported\"))\nend\nBigInt.new do |mpz|\n  LibGMP.pow_ui(mpz, self, other)\nend\n"}},{"id":"+(other:Int):BigInt-instance-method","html_id":"+(other:Int):BigInt-instance-method","name":"+","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","source_link":null,"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"if other < 0\n  self - other.abs\nelse\n  if other <= LibGMP::ULong::MAX\n    BigInt.new do |mpz|\n      LibGMP.add_ui(mpz, self, other)\n    end\n  else\n    self + other.to_big_i\n  end\nend"}},{"id":"+(other:BigInt):BigInt-instance-method","html_id":"+(other:BigInt):BigInt-instance-method","name":"+","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","source_link":null,"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.add(mpz, self, other)\nend"}},{"id":"-:BigInt-instance-method","html_id":"-:BigInt-instance-method","name":"-","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : BigInt","source_link":null,"def":{"name":"-","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.neg(mpz, self)\nend"}},{"id":"-(other:Int):BigInt-instance-method","html_id":"-(other:Int):BigInt-instance-method","name":"-","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","source_link":null,"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"if other < 0\n  self + other.abs\nelse\n  if other <= LibGMP::ULong::MAX\n    BigInt.new do |mpz|\n      LibGMP.sub_ui(mpz, self, other)\n    end\n  else\n    self - other.to_big_i\n  end\nend"}},{"id":"-(other:BigInt):BigInt-instance-method","html_id":"-(other:BigInt):BigInt-instance-method","name":"-","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","source_link":null,"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.sub(mpz, self, other)\nend"}},{"id":"/(other:Float64):BigFloat-instance-method","html_id":"/(other:Float64):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float64"}],"args_string":"(other : Float64) : BigFloat","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Float32):BigFloat-instance-method","html_id":"/(other:Float32):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float32"}],"args_string":"(other : Float32) : BigFloat","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:UInt128):BigFloat-instance-method","html_id":"/(other:UInt128):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt128"}],"args_string":"(other : UInt128) : BigFloat","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt128"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Int128):BigFloat-instance-method","html_id":"/(other:Int128):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int128"}],"args_string":"(other : Int128) : BigFloat","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int128"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:UInt64):BigFloat-instance-method","html_id":"/(other:UInt64):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt64"}],"args_string":"(other : UInt64) : BigFloat","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Int64):BigFloat-instance-method","html_id":"/(other:Int64):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int64"}],"args_string":"(other : Int64) : BigFloat","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:UInt32):BigFloat-instance-method","html_id":"/(other:UInt32):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt32"}],"args_string":"(other : UInt32) : BigFloat","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Int32):BigFloat-instance-method","html_id":"/(other:Int32):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int32"}],"args_string":"(other : Int32) : BigFloat","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:UInt16):BigFloat-instance-method","html_id":"/(other:UInt16):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt16"}],"args_string":"(other : UInt16) : BigFloat","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt16"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Int16):BigFloat-instance-method","html_id":"/(other:Int16):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int16"}],"args_string":"(other : Int16) : BigFloat","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int16"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Int8):BigFloat-instance-method","html_id":"/(other:Int8):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int8"}],"args_string":"(other : Int8) : BigFloat","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int8"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:BigRational):BigRational-instance-method","html_id":"/(other:BigRational):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational) : BigRational","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:BigDecimal):BigDecimal-instance-method","html_id":"/(other:BigDecimal):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : BigDecimal","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:BigInt):BigFloat-instance-method","html_id":"/(other:BigInt):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigFloat","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:UInt8):BigFloat-instance-method","html_id":"/(other:UInt8):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt8"}],"args_string":"(other : UInt8) : BigFloat","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt8"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"//(other:Int):BigInt-instance-method","html_id":"//(other:Int):BigInt-instance-method","name":"//","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","source_link":null,"def":{"name":"//","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"check_division_by_zero(other)\nif other < 0\n  (-self).unsafe_floored_div(-other)\nelse\n  unsafe_floored_div(other)\nend\n"}},{"id":"//(other:Int::Unsigned):BigInt-instance-method","html_id":"//(other:Int::Unsigned):BigInt-instance-method","name":"//","doc":"Divides `self` by *other* using floored division.\n\nIn floored division, given two integers x and y:\n* q = x / y is rounded toward negative infinity\n* r = x % y has the sign of the second argument\n* x == q*y + r\n\nFor example:\n\n```text\n x     y     x / y     x % y\n 5     3       1         2\n-5     3      -2         1\n 5    -3      -2        -1\n-5    -3       1        -2\n```\n\nRaises if *other* is zero, or if *other* is -1 and\n`self` is signed and is the minimum value for that\ninteger type.","summary":"<p>Divides <code>self</code> by <em>other</em> using floored division.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int::Unsigned"}],"args_string":"(other : Int::Unsigned) : BigInt","source_link":null,"def":{"name":"//","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int::Unsigned"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"check_division_by_zero(other)\nunsafe_floored_div(other)\n"}},{"id":"<<(other:Int):BigInt-instance-method","html_id":"&lt;&lt;(other:Int):BigInt-instance-method","name":"<<","doc":"Returns the result of shifting this number's bits *count* positions to the left.\n\n* If *count* is greater than the number of bits of this integer, returns 0\n* If *count* is negative, a right shift is performed\n\n```\n8000 << 1  # => 16000\n8000 << 2  # => 32000\n8000 << 32 # => 0\n8000 << -1 # => 4000\n```","summary":"<p>Returns the result of shifting this number's bits <em>count</em> positions to the left.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","source_link":null,"def":{"name":"<<","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.mul_2exp(mpz, self, other)\nend"}},{"id":"(other:BigInt)-instance-method","html_id":"(other:BigInt)-instance-method","name":"<=>","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt)","source_link":null,"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.cmp(mpz, other)"}},{"id":"(other:Float)-instance-method","html_id":"(other:Float)-instance-method","name":"<=>","doc":"The comparison operator. Returns `0` if the two objects are equal,\na negative number if this object is considered less than *other*,\na positive number if this object is considered greter than *other*,\nor `nil` if the two objects are not comparable.\n\nSubclasses define this method to provide class-specific ordering.\n\nThe comparison operator is usually used to sort values:\n\n```\n# Sort in a descending way:\n[3, 1, 2].sort { |x, y| y <=> x } # => [3, 2, 1]\n\n# Sort in an ascending way:\n[3, 1, 2].sort { |x, y| x <=> y } # => [1, 2, 3]\n```","summary":"<p>The comparison operator.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float"}],"args_string":"(other : Float)","source_link":null,"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.cmp_d(mpz, other)"}},{"id":"(other:Int::Unsigned)-instance-method","html_id":"(other:Int::Unsigned)-instance-method","name":"<=>","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int::Unsigned"}],"args_string":"(other : Int::Unsigned)","source_link":null,"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int::Unsigned"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if other <= LibC::ULong::MAX\n  LibGMP.cmp_ui(mpz, other)\nelse\n  self <=> (BigInt.new(other))\nend"}},{"id":"(other:Int::Signed)-instance-method","html_id":"(other:Int::Signed)-instance-method","name":"<=>","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int::Signed"}],"args_string":"(other : Int::Signed)","source_link":null,"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int::Signed"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if LibC::Long::MIN <= other && other <= LibC::Long::MAX\n  LibGMP.cmp_si(mpz, other)\nelse\n  self <=> (BigInt.new(other))\nend"}},{"id":">>(other:Int):BigInt-instance-method","html_id":"&gt;&gt;(other:Int):BigInt-instance-method","name":">>","doc":"Returns the result of shifting this number's bits *count* positions to the right.\nAlso known as arithmetic right shift.\n\n* If *count* is greater than the number of bits of this integer, returns 0\n* If *count* is negative, a left shift is performed\n\n```\n8000 >> 1  # => 4000\n8000 >> 2  # => 2000\n8000 >> 32 # => 0\n8000 >> -1 # => 16000\n\n-8000 >> 1 # => -4000\n```","summary":"<p>Returns the result of shifting this number's bits <em>count</em> positions to the right.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","source_link":null,"def":{"name":">>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.fdiv_q_2exp(mpz, self, other)\nend"}},{"id":"^(other:Int):BigInt-instance-method","html_id":"^(other:Int):BigInt-instance-method","name":"^","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","source_link":null,"def":{"name":"^","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.xor(mpz, self, other.to_big_i)\nend"}},{"id":"abs:BigInt-instance-method","html_id":"abs:BigInt-instance-method","name":"abs","doc":"Returns the absolute value of this number.\n\n```\n123.abs  # => 123\n-123.abs # => 123\n```","summary":"<p>Returns the absolute value of this number.</p>","abstract":false,"args":[],"args_string":" : BigInt","source_link":null,"def":{"name":"abs","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.abs(mpz, self)\nend"}},{"id":"clone-instance-method","html_id":"clone-instance-method","name":"clone","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"digits:Array(Int32)-instance-method","html_id":"digits:Array(Int32)-instance-method","name":"digits","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Array(Int32)","source_link":null,"def":{"name":"digits","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Array(Int32)","visibility":"Public","body":"ary = [] of Int32\nself.to_s.each_char do |c|\n  ary << (c - '0')\nend\nary\n"}},{"id":"divmod(number:Int::Signed)-instance-method","html_id":"divmod(number:Int::Signed)-instance-method","name":"divmod","doc":null,"summary":null,"abstract":false,"args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"Int::Signed"}],"args_string":"(number : Int::Signed)","source_link":null,"def":{"name":"divmod","args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"Int::Signed"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"check_division_by_zero(number)\nif number > 0 && number <= LibC::Long::MAX\n  unsafe_floored_divmod(LibGMP::ULong.new(number))\nelse\n  divmod(number.to_big_i)\nend\n"}},{"id":"divmod(number:Int::Unsigned)-instance-method","html_id":"divmod(number:Int::Unsigned)-instance-method","name":"divmod","doc":null,"summary":null,"abstract":false,"args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"Int::Unsigned"}],"args_string":"(number : Int::Unsigned)","source_link":null,"def":{"name":"divmod","args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"Int::Unsigned"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"check_division_by_zero(number)\nif number <= LibC::ULong::MAX\n  unsafe_floored_divmod(LibGMP::ULong.new(number))\nelse\n  divmod(number.to_big_i)\nend\n"}},{"id":"divmod(number:BigInt)-instance-method","html_id":"divmod(number:BigInt)-instance-method","name":"divmod","doc":null,"summary":null,"abstract":false,"args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"BigInt"}],"args_string":"(number : BigInt)","source_link":null,"def":{"name":"divmod","args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"check_division_by_zero(number)\nunsafe_floored_divmod(number)\n"}},{"id":"gcd(other:Int):Int-instance-method","html_id":"gcd(other:Int):Int-instance-method","name":"gcd","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : Int","source_link":null,"def":{"name":"gcd","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int","visibility":"Public","body":"result = LibGMP.gcd_ui(nil, self, other.abs.to_u64)\nresult == 0 ? self : result\n"}},{"id":"gcd(other:BigInt):BigInt-instance-method","html_id":"gcd(other:BigInt):BigInt-instance-method","name":"gcd","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","source_link":null,"def":{"name":"gcd","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.gcd(mpz, self, other)\nend"}},{"id":"hash(hasher)-instance-method","html_id":"hash(hasher)-instance-method","name":"hash","doc":"TODO: improve this","summary":"<p><span class=\"flag orange\">TODO</span>  improve this</p>","abstract":false,"args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"args_string":"(hasher)","source_link":null,"def":{"name":"hash","args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"hasher = to_u64.hash(hasher)\nhasher\n"}},{"id":"lcm(other:Int):BigInt-instance-method","html_id":"lcm(other:Int):BigInt-instance-method","name":"lcm","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","source_link":null,"def":{"name":"lcm","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.lcm_ui(mpz, self, other.abs.to_u64)\nend"}},{"id":"lcm(other:BigInt):BigInt-instance-method","html_id":"lcm(other:BigInt):BigInt-instance-method","name":"lcm","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","source_link":null,"def":{"name":"lcm","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.lcm(mpz, self, other)\nend"}},{"id":"popcount-instance-method","html_id":"popcount-instance-method","name":"popcount","doc":"Counts `1`-bits in the binary representation of this integer.\n\n```\n5.popcount   # => 2\n-15.popcount # => 29\n```","summary":"<p>Counts <code>1</code>-bits in the binary representation of this integer.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"popcount","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.popcount(self)"}},{"id":"remainder(other:Int):BigInt-instance-method","html_id":"remainder(other:Int):BigInt-instance-method","name":"remainder","doc":"Returns `self` remainder *other*.\n\nThis uses truncated division.\n\nSee `Int#div` for more details.","summary":"<p>Returns <code>self</code> remainder <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","source_link":null,"def":{"name":"remainder","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"check_division_by_zero(other)\nunsafe_truncated_mod(other)\n"}},{"id":"tdiv(other:Int):BigInt-instance-method","html_id":"tdiv(other:Int):BigInt-instance-method","name":"tdiv","doc":"Divides `self` by *other* using truncated division.\n\nIn truncated division, given two integers x and y:\n* `q = x.tdiv(y)` is rounded toward zero\n* `r = x.remainder(y)` has the sign of the first argument\n* `x == q*y + r`\n\nFor example:\n\n```text\n x     y     x / y     x % y\n 5     3       1         2\n-5     3      -1        -2\n 5    -3      -1         2\n-5    -3       1        -2\n```\n\nRaises if *other* is `0`, or if *other* is `-1` and\n`self` is signed and is the minimum value for that\ninteger type.","summary":"<p>Divides <code>self</code> by <em>other</em> using truncated division.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","source_link":null,"def":{"name":"tdiv","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"check_division_by_zero(other)\nunsafe_truncated_div(other)\n"}},{"id":"to_big_d-instance-method","html_id":"to_big_d-instance-method","name":"to_big_d","doc":"Converts `self` to `BigDecimal`.\n```\nrequire \"big\"\n12123415151254124124.to_big_d\n```","summary":"<p>Converts <code>self</code> to <code><a href=\"BigDecimal.html\">BigDecimal</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_big_d","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigDecimal.new(self)"}},{"id":"to_big_f-instance-method","html_id":"to_big_f-instance-method","name":"to_big_f","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_big_f","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigFloat.new do |mpf|\n  LibGMP.mpf_set_z(mpf, mpz)\nend"}},{"id":"to_big_i-instance-method","html_id":"to_big_i-instance-method","name":"to_big_i","doc":"Returns a `BigInt` representing this integer.\n```\nrequire \"big\"\n\n123.to_big_i\n```","summary":"<p>Returns a <code><a href=\"BigInt.html\">BigInt</a></code> representing this integer.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_big_i","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"to_big_r-instance-method","html_id":"to_big_r-instance-method","name":"to_big_r","doc":"Returns a `BigRational` representing this integer.\n```\nrequire \"big\"\n\n123.to_big_r\n```","summary":"<p>Returns a <code><a href=\"BigRational.html\">BigRational</a></code> representing this integer.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_big_r","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigRational.new(self)"}},{"id":"to_f-instance-method","html_id":"to_f-instance-method","name":"to_f","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64"}},{"id":"to_f!-instance-method","html_id":"to_f!-instance-method","name":"to_f!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64!"}},{"id":"to_f32-instance-method","html_id":"to_f32-instance-method","name":"to_f32","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_f32"}},{"id":"to_f32!-instance-method","html_id":"to_f32!-instance-method","name":"to_f32!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f32!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.get_d(self)).to_f32!"}},{"id":"to_f64-instance-method","html_id":"to_f64-instance-method","name":"to_f64","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.get_d(self)"}},{"id":"to_f64!-instance-method","html_id":"to_f64!-instance-method","name":"to_f64!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f64!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.get_d(self)"}},{"id":"to_i-instance-method","html_id":"to_i-instance-method","name":"to_i","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i32"}},{"id":"to_i!-instance-method","html_id":"to_i!-instance-method","name":"to_i!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i32!"}},{"id":"to_i16-instance-method","html_id":"to_i16-instance-method","name":"to_i16","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i16","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i32.to_i16"}},{"id":"to_i16!-instance-method","html_id":"to_i16!-instance-method","name":"to_i16!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i16!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.get_si(self)).to_i16!"}},{"id":"to_i32-instance-method","html_id":"to_i32-instance-method","name":"to_i32","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.get_si(self)).to_i32"}},{"id":"to_i32!-instance-method","html_id":"to_i32!-instance-method","name":"to_i32!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i32!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.get_si(self)).to_i32!"}},{"id":"to_i64-instance-method","html_id":"to_i64-instance-method","name":"to_i64","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if (LibGMP::Long == Int64) || (Int32::MIN <= self && self <= Int32::MAX)\n  (LibGMP.get_si(self)).to_i64\nelse\n  to_s.to_i64\nend"}},{"id":"to_i64!-instance-method","html_id":"to_i64!-instance-method","name":"to_i64!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i64!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if (LibGMP::Long == Int64) || (Int32::MIN <= self && self <= Int32::MAX)\n  (LibGMP.get_si(self)).to_i64!\nelse\n  to_s.to_i64\nend"}},{"id":"to_i8-instance-method","html_id":"to_i8-instance-method","name":"to_i8","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i8","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i32.to_i8"}},{"id":"to_i8!-instance-method","html_id":"to_i8!-instance-method","name":"to_i8!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i8!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.get_si(self)).to_i8!"}},{"id":"to_s:String-instance-method","html_id":"to_s:String-instance-method","name":"to_s","doc":"Returns a string representation of self.\n\n```\nrequire \"big\"\n\nBigInt.new(\"123456789101101987654321\").to_s # => 123456789101101987654321\n```","summary":"<p>Returns a string representation of self.</p>","abstract":false,"args":[],"args_string":" : String","source_link":null,"def":{"name":"to_s","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"String.new(to_cstr)"}},{"id":"to_s(base:Int):String-instance-method","html_id":"to_s(base:Int):String-instance-method","name":"to_s","doc":"Returns a string containing the representation of big radix base (2 through 36).\n\n```\nrequire \"big\"\n\nBigInt.new(\"123456789101101987654321\").to_s(8)  # => \"32111154373025463465765261\"\nBigInt.new(\"123456789101101987654321\").to_s(16) # => \"1a249b1f61599cd7eab1\"\nBigInt.new(\"123456789101101987654321\").to_s(36) # => \"k3qmt029k48nmpd\"\n```","summary":"<p>Returns a string containing the representation of big radix base (2 through 36).</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"","external_name":"base","restriction":"Int"}],"args_string":"(base : Int) : String","source_link":null,"def":{"name":"to_s","args":[{"name":"base","doc":null,"default_value":"","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"if 2 <= base && base <= 36\nelse\n  raise(\"Invalid base #{base}\")\nend\ncstr = LibGMP.get_str(nil, base, self)\nString.new(cstr)\n"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Returns a string representation of self.\n\n```\nrequire \"big\"\n\nBigInt.new(\"123456789101101987654321\").to_s # => 123456789101101987654321\n```","summary":"<p>Returns a string representation of self.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"str = to_cstr\nio.write_utf8(Slice.new(str, LibC.strlen(str)))\n"}},{"id":"to_u-instance-method","html_id":"to_u-instance-method","name":"to_u","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u32"}},{"id":"to_u!-instance-method","html_id":"to_u!-instance-method","name":"to_u!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u32!"}},{"id":"to_u16-instance-method","html_id":"to_u16-instance-method","name":"to_u16","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u16","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u32.to_u16"}},{"id":"to_u16!-instance-method","html_id":"to_u16!-instance-method","name":"to_u16!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u16!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.get_ui(self)).to_u16!"}},{"id":"to_u32-instance-method","html_id":"to_u32-instance-method","name":"to_u32","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.get_ui(self)).to_u32"}},{"id":"to_u32!-instance-method","html_id":"to_u32!-instance-method","name":"to_u32!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u32!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.get_ui(self)).to_u32!"}},{"id":"to_u64-instance-method","html_id":"to_u64-instance-method","name":"to_u64","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if (LibGMP::ULong == UInt64) || (UInt32::MIN <= self && self <= UInt32::MAX)\n  (LibGMP.get_ui(self)).to_u64\nelse\n  to_s.to_u64\nend"}},{"id":"to_u64!-instance-method","html_id":"to_u64!-instance-method","name":"to_u64!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u64!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if (LibGMP::Long == Int64) || (Int32::MIN <= self && self <= Int32::MAX)\n  (LibGMP.get_ui(self)).to_u64!\nelse\n  to_s.to_u64\nend"}},{"id":"to_u8-instance-method","html_id":"to_u8-instance-method","name":"to_u8","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u8","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u32.to_u8"}},{"id":"to_u8!-instance-method","html_id":"to_u8!-instance-method","name":"to_u8!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u8!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.get_ui(self)).to_u8!"}},{"id":"to_unsafe-instance-method","html_id":"to_unsafe-instance-method","name":"to_unsafe","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_unsafe","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"mpz"}},{"id":"trailing_zeros_count-instance-method","html_id":"trailing_zeros_count-instance-method","name":"trailing_zeros_count","doc":"Returns the number of trailing `0`-bits.","summary":"<p>Returns the number of trailing <code>0</code>-bits.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"trailing_zeros_count","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.scan1(self, 0)"}},{"id":"unsafe_floored_div(other:BigInt):BigInt-instance-method","html_id":"unsafe_floored_div(other:BigInt):BigInt-instance-method","name":"unsafe_floored_div","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","source_link":null,"def":{"name":"unsafe_floored_div","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.fdiv_q(mpz, self, other)\nend"}},{"id":"unsafe_floored_div(other:Int):BigInt-instance-method","html_id":"unsafe_floored_div(other:Int):BigInt-instance-method","name":"unsafe_floored_div","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","source_link":null,"def":{"name":"unsafe_floored_div","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"if (LibGMP::ULong == UInt32) && (other < Int32::MIN || other > UInt32::MAX)\n  unsafe_floored_div(other.to_big_i)\nelse\n  if other < 0\n    -BigInt.new do |mpz|\n      LibGMP.fdiv_q_ui(mpz, self, other.abs)\n    end\n  else\n    BigInt.new do |mpz|\n      LibGMP.fdiv_q_ui(mpz, self, other)\n    end\n  end\nend"}},{"id":"unsafe_floored_divmod(number:LibGMP::ULong)-instance-method","html_id":"unsafe_floored_divmod(number:LibGMP::ULong)-instance-method","name":"unsafe_floored_divmod","doc":null,"summary":null,"abstract":false,"args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"LibGMP::ULong"}],"args_string":"(number : LibGMP::ULong)","source_link":null,"def":{"name":"unsafe_floored_divmod","args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"LibGMP::ULong"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"the_q = BigInt.new\nthe_r = BigInt.new do |r|\n  LibGMP.fdiv_qr_ui(the_q, r, self, number)\nend\n{the_q, the_r}\n"}},{"id":"unsafe_floored_divmod(number:BigInt)-instance-method","html_id":"unsafe_floored_divmod(number:BigInt)-instance-method","name":"unsafe_floored_divmod","doc":null,"summary":null,"abstract":false,"args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"BigInt"}],"args_string":"(number : BigInt)","source_link":null,"def":{"name":"unsafe_floored_divmod","args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"the_q = BigInt.new\nthe_r = BigInt.new do |r|\n  LibGMP.fdiv_qr(the_q, r, self, number)\nend\n{the_q, the_r}\n"}},{"id":"unsafe_floored_mod(other:BigInt):BigInt-instance-method","html_id":"unsafe_floored_mod(other:BigInt):BigInt-instance-method","name":"unsafe_floored_mod","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","source_link":null,"def":{"name":"unsafe_floored_mod","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.fdiv_r(mpz, self, other)\nend"}},{"id":"unsafe_floored_mod(other:Int):BigInt-instance-method","html_id":"unsafe_floored_mod(other:Int):BigInt-instance-method","name":"unsafe_floored_mod","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","source_link":null,"def":{"name":"unsafe_floored_mod","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"if (other < LibGMP::Long::MIN || other > LibGMP::ULong::MAX)\n  unsafe_floored_mod(other.to_big_i)\nelse\n  if other < 0\n    -BigInt.new do |mpz|\n      LibGMP.fdiv_r_ui(mpz, self, other.abs)\n    end\n  else\n    BigInt.new do |mpz|\n      LibGMP.fdiv_r_ui(mpz, self, other)\n    end\n  end\nend"}},{"id":"unsafe_truncated_div(other:BigInt):BigInt-instance-method","html_id":"unsafe_truncated_div(other:BigInt):BigInt-instance-method","name":"unsafe_truncated_div","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","source_link":null,"def":{"name":"unsafe_truncated_div","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.tdiv_q(mpz, self, other)\nend"}},{"id":"unsafe_truncated_div(other:Int):BigInt-instance-method","html_id":"unsafe_truncated_div(other:Int):BigInt-instance-method","name":"unsafe_truncated_div","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","source_link":null,"def":{"name":"unsafe_truncated_div","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"if (LibGMP::ULong == UInt32) && (other < Int32::MIN || other > UInt32::MAX)\n  unsafe_truncated_div(other.to_big_i)\nelse\n  if other < 0\n    -BigInt.new do |mpz|\n      LibGMP.tdiv_q_ui(mpz, self, other.abs)\n    end\n  else\n    BigInt.new do |mpz|\n      LibGMP.tdiv_q_ui(mpz, self, other)\n    end\n  end\nend"}},{"id":"unsafe_truncated_divmod(number:BigInt)-instance-method","html_id":"unsafe_truncated_divmod(number:BigInt)-instance-method","name":"unsafe_truncated_divmod","doc":null,"summary":null,"abstract":false,"args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"BigInt"}],"args_string":"(number : BigInt)","source_link":null,"def":{"name":"unsafe_truncated_divmod","args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"the_q = BigInt.new\nthe_r = BigInt.new do |r|\n  LibGMP.tdiv_qr(the_q, r, self, number)\nend\n{the_q, the_r}\n"}},{"id":"unsafe_truncated_divmod(number:LibGMP::ULong)-instance-method","html_id":"unsafe_truncated_divmod(number:LibGMP::ULong)-instance-method","name":"unsafe_truncated_divmod","doc":null,"summary":null,"abstract":false,"args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"LibGMP::ULong"}],"args_string":"(number : LibGMP::ULong)","source_link":null,"def":{"name":"unsafe_truncated_divmod","args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"LibGMP::ULong"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"the_q = BigInt.new\nthe_r = BigInt.new do |r|\n  LibGMP.tdiv_qr_ui(the_q, r, self, number)\nend\n{the_q, the_r}\n"}},{"id":"unsafe_truncated_mod(other:BigInt):BigInt-instance-method","html_id":"unsafe_truncated_mod(other:BigInt):BigInt-instance-method","name":"unsafe_truncated_mod","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","source_link":null,"def":{"name":"unsafe_truncated_mod","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.tdiv_r(mpz, self, other)\nend"}},{"id":"unsafe_truncated_mod(other:Int):BigInt-instance-method","html_id":"unsafe_truncated_mod(other:Int):BigInt-instance-method","name":"unsafe_truncated_mod","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","source_link":null,"def":{"name":"unsafe_truncated_mod","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.tdiv_r_ui(mpz, self, other.abs.to_big_i)\nend"}},{"id":"unsafe_truncated_mod(other:LibGMP::IntPrimitive):BigInt-instance-method","html_id":"unsafe_truncated_mod(other:LibGMP::IntPrimitive):BigInt-instance-method","name":"unsafe_truncated_mod","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"LibGMP::IntPrimitive"}],"args_string":"(other : LibGMP::IntPrimitive) : BigInt","source_link":null,"def":{"name":"unsafe_truncated_mod","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"LibGMP::IntPrimitive"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.tdiv_r_ui(mpz, self, other.abs)\nend"}},{"id":"|(other:Int):BigInt-instance-method","html_id":"|(other:Int):BigInt-instance-method","name":"|","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","source_link":null,"def":{"name":"|","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.ior(mpz, self, other.to_big_i)\nend"}},{"id":"~:BigInt-instance-method","html_id":"~:BigInt-instance-method","name":"~","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : BigInt","source_link":null,"def":{"name":"~","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.com(mpz, self)\nend"}}],"macros":[],"types":[]},{"html_id":"/BigRational","path":"BigRational.html","kind":"struct","full_name":"BigRational","name":"BigRational","abstract":false,"superclass":{"html_id":"/Number","kind":"struct","full_name":"Number","name":"Number"},"ancestors":[{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Number","kind":"struct","full_name":"Number","name":"Number"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"}],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"Rational numbers are represented as the quotient of arbitrarily large\nnumerators and denominators. Rationals are canonicalized such that the\ndenominator and the numerator have no common factors, and that the\ndenominator is positive. Zero has the unique representation 0/1.\n\n```\nrequire \"big\"\n\nr = BigRational.new(7.to_big_i, 3.to_big_i)\nr.to_s # => \"7/3\"\n\nr = BigRational.new(3, -9)\nr.to_s # => \"-1/3\"\n```\n\nIt is implemented under the hood with [GMP](https://gmplib.org/).","summary":"<p>Rational numbers are represented as the quotient of arbitrarily large numerators and denominators.</p>","class_methods":[],"constructors":[{"id":"new(numerator:Int,denominator:Int)-class-method","html_id":"new(numerator:Int,denominator:Int)-class-method","name":"new","doc":"Creates a new `BigRational`.\n\nIf *denominator* is 0, this will raise an exception.","summary":"<p>Creates a new <code><a href=\"BigRational.html\">BigRational</a></code>.</p>","abstract":false,"args":[{"name":"numerator","doc":null,"default_value":"","external_name":"numerator","restriction":"Int"},{"name":"denominator","doc":null,"default_value":"","external_name":"denominator","restriction":"Int"}],"args_string":"(numerator : Int, denominator : Int)","source_link":null,"def":{"name":"new","args":[{"name":"numerator","doc":null,"default_value":"","external_name":"numerator","restriction":"Int"},{"name":"denominator","doc":null,"default_value":"","external_name":"denominator","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(numerator, denominator)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:Int)-class-method","html_id":"new(num:Int)-class-method","name":"new","doc":"Creates a new `BigRational` with *num* as the numerator and 1 for denominator.","summary":"<p>Creates a new <code><a href=\"BigRational.html\">BigRational</a></code> with <em>num</em> as the numerator and 1 for denominator.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Int"}],"args_string":"(num : Int)","source_link":null,"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:Float)-class-method","html_id":"new(num:Float)-class-method","name":"new","doc":"Creates a exact representation of float as rational.","summary":"<p>Creates a exact representation of float as rational.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Float"}],"args_string":"(num : Float)","source_link":null,"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Float"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:BigRational)-class-method","html_id":"new(num:BigRational)-class-method","name":"new","doc":"Creates a `BigRational` from the given *num*.","summary":"<p>Creates a <code><a href=\"BigRational.html\">BigRational</a></code> from the given <em>num</em>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigRational"}],"args_string":"(num : BigRational)","source_link":null,"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"num"}},{"id":"new(num:BigDecimal)-class-method","html_id":"new(num:BigDecimal)-class-method","name":"new","doc":"Creates a `BigRational` from the given *num*.","summary":"<p>Creates a <code><a href=\"BigRational.html\">BigRational</a></code> from the given <em>num</em>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigDecimal"}],"args_string":"(num : BigDecimal)","source_link":null,"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"num.to_big_r"}}],"instance_methods":[{"id":"*(other:Int)-instance-method","html_id":"*(other:Int)-instance-method","name":"*","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int)","source_link":null,"def":{"name":"*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self * other.to_big_r"}},{"id":"*(other:BigRational)-instance-method","html_id":"*(other:BigRational)-instance-method","name":"*","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational)","source_link":null,"def":{"name":"*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigRational.new do |mpq|\n  LibGMP.mpq_mul(mpq, self, other)\nend"}},{"id":"**(other:Int):BigRational-instance-method","html_id":"**(other:Int):BigRational-instance-method","name":"**","doc":"Raises the rational to the *other*th power\n\nThis will raise `DivisionByZeroError` if rational is 0 and *other* is negative.\n\n```\nrequire \"big\"\n\nBigRational.new(2, 3) ** 2  # => 4/9\nBigRational.new(2, 3) ** -1 # => 3/2\n```","summary":"<p>Raises the rational to the <em>other</em>th power</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigRational","source_link":null,"def":{"name":"**","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"if other < 0\n  return (self ** (-other)).inv\nend\nBigRational.new(numerator ** other, denominator ** other)\n"}},{"id":"+(other:Int)-instance-method","html_id":"+(other:Int)-instance-method","name":"+","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int)","source_link":null,"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self + other.to_big_r"}},{"id":"+(other:BigRational)-instance-method","html_id":"+(other:BigRational)-instance-method","name":"+","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational)","source_link":null,"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigRational.new do |mpq|\n  LibGMP.mpq_add(mpq, self, other)\nend"}},{"id":"--instance-method","html_id":"--instance-method","name":"-","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"-","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigRational.new do |mpq|\n  LibGMP.mpq_neg(mpq, self)\nend"}},{"id":"-(other:Int)-instance-method","html_id":"-(other:Int)-instance-method","name":"-","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int)","source_link":null,"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self - other.to_big_r"}},{"id":"-(other:BigRational)-instance-method","html_id":"-(other:BigRational)-instance-method","name":"-","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational)","source_link":null,"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigRational.new do |mpq|\n  LibGMP.mpq_sub(mpq, self, other)\nend"}},{"id":"/(other:Int64):BigRational-instance-method","html_id":"/(other:Int64):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int64"}],"args_string":"(other : Int64) : BigRational","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:UInt64):BigRational-instance-method","html_id":"/(other:UInt64):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt64"}],"args_string":"(other : UInt64) : BigRational","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:Int128):BigRational-instance-method","html_id":"/(other:Int128):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int128"}],"args_string":"(other : Int128) : BigRational","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int128"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:UInt128):BigRational-instance-method","html_id":"/(other:UInt128):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt128"}],"args_string":"(other : UInt128) : BigRational","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt128"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:Float32):BigRational-instance-method","html_id":"/(other:Float32):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float32"}],"args_string":"(other : Float32) : BigRational","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:Float64):BigRational-instance-method","html_id":"/(other:Float64):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float64"}],"args_string":"(other : Float64) : BigRational","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:UInt32):BigRational-instance-method","html_id":"/(other:UInt32):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt32"}],"args_string":"(other : UInt32) : BigRational","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:Int32):BigRational-instance-method","html_id":"/(other:Int32):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int32"}],"args_string":"(other : Int32) : BigRational","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:UInt16):BigRational-instance-method","html_id":"/(other:UInt16):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt16"}],"args_string":"(other : UInt16) : BigRational","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt16"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:Int16):BigRational-instance-method","html_id":"/(other:Int16):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int16"}],"args_string":"(other : Int16) : BigRational","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int16"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:UInt8):BigRational-instance-method","html_id":"/(other:UInt8):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt8"}],"args_string":"(other : UInt8) : BigRational","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt8"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:Int8):BigRational-instance-method","html_id":"/(other:Int8):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int8"}],"args_string":"(other : Int8) : BigRational","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int8"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:BigDecimal):BigRational-instance-method","html_id":"/(other:BigDecimal):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : BigRational","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:BigFloat):BigRational-instance-method","html_id":"/(other:BigFloat):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigFloat"}],"args_string":"(other : BigFloat) : BigRational","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigFloat"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:BigInt):BigRational-instance-method","html_id":"/(other:BigInt):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigRational","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:BigRational)-instance-method","html_id":"/(other:BigRational)-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational)","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"check_division_by_zero(other)\nBigRational.new do |mpq|\n  LibGMP.mpq_div(mpq, self, other)\nend\n"}},{"id":"<<(other:Int)-instance-method","html_id":"&lt;&lt;(other:Int)-instance-method","name":"<<","doc":"Multiplies the rational by (2 ** *other*)\n\n```\nrequire \"big\"\n\nBigRational.new(2, 3) << 2 # => 8/3\n```","summary":"<p>Multiplies the rational by (2 ** <em>other</em>)</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int)","source_link":null,"def":{"name":"<<","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigRational.new do |mpq|\n  LibGMP.mpq_mul_2exp(mpq, self, other)\nend"}},{"id":"(other:BigDecimal)-instance-method","html_id":"(other:BigDecimal)-instance-method","name":"<=>","doc":"The comparison operator. Returns `0` if the two objects are equal,\na negative number if this object is considered less than *other*,\na positive number if this object is considered greter than *other*,\nor `nil` if the two objects are not comparable.\n\nSubclasses define this method to provide class-specific ordering.\n\nThe comparison operator is usually used to sort values:\n\n```\n# Sort in a descending way:\n[3, 1, 2].sort { |x, y| y <=> x } # => [3, 2, 1]\n\n# Sort in an ascending way:\n[3, 1, 2].sort { |x, y| x <=> y } # => [1, 2, 3]\n```","summary":"<p>The comparison operator.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal)","source_link":null,"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_d <=> other"}},{"id":"(other:Int)-instance-method","html_id":"(other:Int)-instance-method","name":"<=>","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int)","source_link":null,"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpq_cmp(mpq, other.to_big_r)"}},{"id":"(other:Float)-instance-method","html_id":"(other:Float)-instance-method","name":"<=>","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float"}],"args_string":"(other : Float)","source_link":null,"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_f <=> other.to_big_f"}},{"id":"(other:Float32|Float64)-instance-method","html_id":"(other:Float32|Float64)-instance-method","name":"<=>","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float32 | Float64"}],"args_string":"(other : Float32 | Float64)","source_link":null,"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float32 | Float64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self <=> (BigRational.new(other))"}},{"id":"(other:BigRational)-instance-method","html_id":"(other:BigRational)-instance-method","name":"<=>","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational)","source_link":null,"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpq_cmp(mpq, other)"}},{"id":">>(other:Int)-instance-method","html_id":"&gt;&gt;(other:Int)-instance-method","name":">>","doc":"Divides the rational by (2 ** *other*)\n\n```\nrequire \"big\"\n\nBigRational.new(2, 3) >> 2 # => 1/6\n```","summary":"<p>Divides the rational by (2 ** <em>other</em>)</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int)","source_link":null,"def":{"name":">>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigRational.new do |mpq|\n  LibGMP.mpq_div_2exp(mpq, self, other)\nend"}},{"id":"abs-instance-method","html_id":"abs-instance-method","name":"abs","doc":"Returns the absolute value of this number.\n\n```\n123.abs  # => 123\n-123.abs # => 123\n```","summary":"<p>Returns the absolute value of this number.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"abs","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigRational.new do |mpq|\n  LibGMP.mpq_abs(mpq, self)\nend"}},{"id":"ceil-instance-method","html_id":"ceil-instance-method","name":"ceil","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"ceil","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"diff = (denominator - (numerator % denominator)) % denominator\nBigRational.new(numerator + diff, denominator)\n"}},{"id":"clone-instance-method","html_id":"clone-instance-method","name":"clone","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"denominator-instance-method","html_id":"denominator-instance-method","name":"denominator","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"denominator","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.mpq_get_den(mpz, self)\nend"}},{"id":"floor-instance-method","html_id":"floor-instance-method","name":"floor","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"floor","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigRational.new(numerator - (numerator % denominator), denominator)"}},{"id":"hash(hasher)-instance-method","html_id":"hash(hasher)-instance-method","name":"hash","doc":"TODO: improve this","summary":"<p><span class=\"flag orange\">TODO</span>  improve this</p>","abstract":false,"args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"args_string":"(hasher)","source_link":null,"def":{"name":"hash","args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"hasher = to_f64.hash(hasher)\nhasher\n"}},{"id":"inspect:String-instance-method","html_id":"inspect:String-instance-method","name":"inspect","doc":"Returns a `String` representation of this object suitable\nto be embedded inside other expressions, sometimes providing\nmore information about this object.\n\n`#inspect` (and `#inspect(io)`) are the methods used when\nyou invoke `#to_s` or `#inspect` on an object that holds\nother objects and wants to show them. For example when you\ninvoke `Array#to_s`, `#inspect` will be invoked on each element:\n\n```\nary = [\"one\", \"two\", \"three, etc.\"]\nary.inspect # => [\"one\", \"two\", \"three, etc.\"]\n```\n\nNote that if Array invoked `#to_s` on each of the elements\nabove, the output would have been this:\n\n```\nary = [\"one\", \"two\", \"three, etc.\"]\n# If inspect invoked to_s on each element...\nary.inspect # => [one, two, three, etc.]\n```\n\nNote that it's not clear how many elements the array has,\nor which are they, because `#to_s` doesn't guarantee that\nthe string representation is clearly delimited (in the case\nof `String` the quotes are not shown).\n\nAlso note that sometimes the output of `#inspect` will look\nlike a Crystal expression that will compile, but this isn't\nalways the case, nor is it necessary. Notably, `Reference#inspect`\nand `Struct#inspect` return values that don't compile.\n\nClasses must usually **not** override this method. Instead,\nthey must override `inspect(io)`, which must append to the\ngiven `IO` object.","summary":"<p>Returns a <code><a href=\"String.html\">String</a></code> representation of this object suitable to be embedded inside other expressions, sometimes providing more information about this object.</p>","abstract":false,"args":[],"args_string":" : String","source_link":null,"def":{"name":"inspect","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"to_s"}},{"id":"inspect(io:IO):Nil-instance-method","html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Appends a string representation of this object\nto the given `IO` object.\n\nSimilar to `to_s(io)`, but usually appends more information\nabout this object.\nSee `#inspect`.","summary":"<p>Appends a string representation of this object to the given <code><a href=\"IO.html\">IO</a></code> object.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"inspect","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"to_s(io)"}},{"id":"inv-instance-method","html_id":"inv-instance-method","name":"inv","doc":"Returns a new `BigRational` as 1/r.\n\nThis will raise an exception if rational is 0.","summary":"<p>Returns a new <code><a href=\"BigRational.html\">BigRational</a></code> as 1/r.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"inv","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"check_division_by_zero(self)\nBigRational.new do |mpq|\n  LibGMP.mpq_inv(mpq, self)\nend\n"}},{"id":"numerator-instance-method","html_id":"numerator-instance-method","name":"numerator","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"numerator","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.mpq_get_num(mpz, self)\nend"}},{"id":"to_big_d-instance-method","html_id":"to_big_d-instance-method","name":"to_big_d","doc":"Converts `self` to `BigDecimal`.","summary":"<p>Converts <code>self</code> to <code><a href=\"BigDecimal.html\">BigDecimal</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_big_d","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigDecimal.new(self)"}},{"id":"to_big_f-instance-method","html_id":"to_big_f-instance-method","name":"to_big_f","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_big_f","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigFloat.new do |mpf|\n  LibGMP.mpf_set_q(mpf, mpq)\nend"}},{"id":"to_big_i-instance-method","html_id":"to_big_i-instance-method","name":"to_big_i","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_big_i","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.set_q(mpz, mpq)\nend"}},{"id":"to_f-instance-method","html_id":"to_f-instance-method","name":"to_f","doc":"Returns the `Float64` representing this rational.","summary":"<p>Returns the <code><a href=\"Float64.html\">Float64</a></code> representing this rational.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64"}},{"id":"to_f!-instance-method","html_id":"to_f!-instance-method","name":"to_f!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64!"}},{"id":"to_f32-instance-method","html_id":"to_f32-instance-method","name":"to_f32","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_f32"}},{"id":"to_f32!-instance-method","html_id":"to_f32!-instance-method","name":"to_f32!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f32!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_f32!"}},{"id":"to_f64-instance-method","html_id":"to_f64-instance-method","name":"to_f64","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpq_get_d(mpq)"}},{"id":"to_f64!-instance-method","html_id":"to_f64!-instance-method","name":"to_f64!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f64!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64"}},{"id":"to_i16(*args,**options)-instance-method","html_id":"to_i16(*args,**options)-instance-method","name":"to_i16","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","source_link":null,"def":{"name":"to_i16","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_i16(*args, **options)"}},{"id":"to_i16(*args,**options,&block)-instance-method","html_id":"to_i16(*args,**options,&amp;block)-instance-method","name":"to_i16","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &block)","source_link":null,"def":{"name":"to_i16","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_i16(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_i32(*args,**options)-instance-method","html_id":"to_i32(*args,**options)-instance-method","name":"to_i32","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","source_link":null,"def":{"name":"to_i32","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_i32(*args, **options)"}},{"id":"to_i32(*args,**options,&block)-instance-method","html_id":"to_i32(*args,**options,&amp;block)-instance-method","name":"to_i32","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &block)","source_link":null,"def":{"name":"to_i32","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_i32(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_i64(*args,**options)-instance-method","html_id":"to_i64(*args,**options)-instance-method","name":"to_i64","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","source_link":null,"def":{"name":"to_i64","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_i64(*args, **options)"}},{"id":"to_i64(*args,**options,&block)-instance-method","html_id":"to_i64(*args,**options,&amp;block)-instance-method","name":"to_i64","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &block)","source_link":null,"def":{"name":"to_i64","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_i64(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_i8(*args,**options,&block)-instance-method","html_id":"to_i8(*args,**options,&amp;block)-instance-method","name":"to_i8","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &block)","source_link":null,"def":{"name":"to_i8","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_i8(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_i8(*args,**options)-instance-method","html_id":"to_i8(*args,**options)-instance-method","name":"to_i8","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","source_link":null,"def":{"name":"to_i8","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_i8(*args, **options)"}},{"id":"to_s(io:IO,base:Int=10):Nil-instance-method","html_id":"to_s(io:IO,base:Int=10):Nil-instance-method","name":"to_s","doc":"Appends a `String` representation of this object\nto the given `IO` object.\n\nAn object must never append itself to the io argument,\nas this will in turn call `to_s(io)` on it.","summary":"<p>Appends a <code><a href=\"String.html\">String</a></code> representation of this object to the given <code><a href=\"IO.html\">IO</a></code> object.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(io : IO, base : Int = <span class=\"n\">10</span>) : Nil","source_link":null,"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"str = to_cstr(base)\nio.write_utf8(Slice.new(str, LibC.strlen(str)))\n"}},{"id":"to_s(base:Int=10):String-instance-method","html_id":"to_s(base:Int=10):String-instance-method","name":"to_s","doc":"Returns the string representing this rational.\n\nOptionally takes a radix base (2 through 36).\n\n```\nrequire \"big\"\n\nr = BigRational.new(8243243, 562828882)\nr.to_s     # => \"8243243/562828882\"\nr.to_s(16) # => \"7dc82b/218c1652\"\nr.to_s(36) # => \"4woiz/9b3djm\"\n```","summary":"<p>Returns the string representing this rational.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>) : String","source_link":null,"def":{"name":"to_s","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"String.new(to_cstr(base))"}},{"id":"to_u16(*args,**options)-instance-method","html_id":"to_u16(*args,**options)-instance-method","name":"to_u16","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","source_link":null,"def":{"name":"to_u16","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_u16(*args, **options)"}},{"id":"to_u16(*args,**options,&block)-instance-method","html_id":"to_u16(*args,**options,&amp;block)-instance-method","name":"to_u16","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &block)","source_link":null,"def":{"name":"to_u16","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_u16(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_u32(*args,**options)-instance-method","html_id":"to_u32(*args,**options)-instance-method","name":"to_u32","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","source_link":null,"def":{"name":"to_u32","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_u32(*args, **options)"}},{"id":"to_u32(*args,**options,&block)-instance-method","html_id":"to_u32(*args,**options,&amp;block)-instance-method","name":"to_u32","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &block)","source_link":null,"def":{"name":"to_u32","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_u32(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_u64(*args,**options,&block)-instance-method","html_id":"to_u64(*args,**options,&amp;block)-instance-method","name":"to_u64","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &block)","source_link":null,"def":{"name":"to_u64","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_u64(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_u64(*args,**options)-instance-method","html_id":"to_u64(*args,**options)-instance-method","name":"to_u64","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","source_link":null,"def":{"name":"to_u64","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_u64(*args, **options)"}},{"id":"to_u8(*args,**options,&block)-instance-method","html_id":"to_u8(*args,**options,&amp;block)-instance-method","name":"to_u8","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &block)","source_link":null,"def":{"name":"to_u8","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_u8(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_u8(*args,**options)-instance-method","html_id":"to_u8(*args,**options)-instance-method","name":"to_u8","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","source_link":null,"def":{"name":"to_u8","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_u8(*args, **options)"}},{"id":"to_unsafe-instance-method","html_id":"to_unsafe-instance-method","name":"to_unsafe","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_unsafe","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"mpq"}},{"id":"trunc-instance-method","html_id":"trunc-instance-method","name":"trunc","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"trunc","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self < 0 ? ceil : floor"}}],"macros":[],"types":[]},{"html_id":"/BitArray","path":"BitArray.html","kind":"struct","full_name":"BitArray","name":"BitArray","abstract":false,"superclass":{"html_id":"/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"/Indexable","kind":"module","full_name":"Indexable","name":"Indexable"},{"html_id":"/Enumerable","kind":"module","full_name":"Enumerable","name":"Enumerable"},{"html_id":"/Iterable","kind":"module","full_name":"Iterable","name":"Iterable"},{"html_id":"/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[{"html_id":"/Indexable","kind":"module","full_name":"Indexable","name":"Indexable"}],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"BitArray is an array data structure that compactly stores bits.\n\nBits externally represented as `Bool`s are stored internally as\n`UInt32`s. The total number of bits stored is set at creation and is\nimmutable.\n\n`BitArray` includes all the methods in `Enumerable`.\n\n### Example\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(12) # => \"BitArray[000000000000]\"\nba[2]                 # => false\n0.upto(5) { |i| ba[i * 2] = true }\nba    # => \"BitArray[101010101010]\"\nba[2] # => true\n```","summary":"<p>BitArray is an array data structure that compactly stores bits.</p>","class_methods":[],"constructors":[{"id":"new(size,initial:Bool=false)-class-method","html_id":"new(size,initial:Bool=false)-class-method","name":"new","doc":"Creates a new `BitArray` of *size* bits.\n\n*initial* optionally sets the starting value, `true` or `false`, for all bits\nin the array.","summary":"<p>Creates a new <code><a href=\"BitArray.html\">BitArray</a></code> of <em>size</em> bits.</p>","abstract":false,"args":[{"name":"size","doc":null,"default_value":"","external_name":"size","restriction":""},{"name":"initial","doc":null,"default_value":"false","external_name":"initial","restriction":"Bool"}],"args_string":"(size, initial : Bool = <span class=\"n\">false</span>)","source_link":null,"def":{"name":"new","args":[{"name":"size","doc":null,"default_value":"","external_name":"size","restriction":""},{"name":"initial","doc":null,"default_value":"false","external_name":"initial","restriction":"Bool"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(size, initial)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"==(other:BitArray)-instance-method","html_id":"==(other:BitArray)-instance-method","name":"==","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BitArray"}],"args_string":"(other : BitArray)","source_link":null,"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BitArray"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if size != other.size\n  return false\nend\nreturn (LibC.memcmp(@bits, other.@bits, malloc_size)) == 0\n"}},{"id":"==(other)-instance-method","html_id":"==(other)-instance-method","name":"==","doc":"Returns `true` if this struct is equal to *other*.\n\nBoth structs's instance vars are compared to each other. Thus, two\nstructs are considered equal if each of their instance variables are\nequal. Subclasses should override this method to provide specific\nequality semantics.\n\n```\nstruct Point\n  def initialize(@x : Int32, @y : Int32)\n  end\nend\n\np1 = Point.new 1, 2\np2 = Point.new 1, 2\np3 = Point.new 3, 4\n\np1 == p2 # => true\np1 == p3 # => false\n```","summary":"<p>Returns <code>true</code> if this struct is equal to <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"args_string":"(other)","source_link":null,"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"false"}},{"id":"[](start:Int,count:Int)-instance-method","html_id":"[](start:Int,count:Int)-instance-method","name":"[]","doc":"Returns count or less (if there aren't enough) elements starting at the\ngiven start index.\n\nNegative indices count backward from the end of the array (-1 is the last\nelement). Additionally, an empty array is returned when the starting index\nfor an element range is at the end of the array.\n\nRaises `IndexError` if the starting index is out of range.\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(5)\nba[0] = true; ba[2] = true; ba[4] = true\nba # => BitArray[10101]\n\nba[-3, 3] # => BitArray[101]\nba[6, 1]  # raise indexError\nba[1, 2]  # => BitArray[01]\nba[5, 1]  # => BitArray[]\n```","summary":"<p>Returns count or less (if there aren't enough) elements starting at the given start index.</p>","abstract":false,"args":[{"name":"start","doc":null,"default_value":"","external_name":"start","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"args_string":"(start : Int, count : Int)","source_link":null,"def":{"name":"[]","args":[{"name":"start","doc":null,"default_value":"","external_name":"start","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if count < 0\n  raise(ArgumentError.new(\"Negative count: #{count}\"))\nend\nif start == size\n  return BitArray.new(0)\nend\nif start < 0\n  start = start + size\nend\nif 0 <= start && start <= size\nelse\n  raise(IndexError.new)\nend\nif count == 0\n  return BitArray.new(0)\nend\ncount = Math.min(count, size - start)\nif size <= 32\n  bits = @bits[0]\n  bits = bits >> start\n  bits = bits & ((1 << count) - 1)\n  (BitArray.new(count)).tap do |ba|\n    (ba.@bits)[0] = bits\n  end\nelse\n  if size <= 64\n    bits = (@bits.as(::Pointer(UInt64)))[0]\n    bits = bits >> start\n    bits = bits & ((1 << count) - 1)\n    if count <= 32\n      (BitArray.new(count)).tap do |ba|\n        (ba.@bits)[0] = bits.to_u32\n      end\n    else\n      (BitArray.new(count)).tap do |ba|\n        ((ba.@bits).as(::Pointer(UInt64)))[0] = bits\n      end\n    end\n  else\n    ba = BitArray.new(count)\n    start_bit_index, start_sub_index = start.divmod(32)\n    end_bit_index = (start + count) // 32\n    i = 0\n    bits = @bits[start_bit_index]\n    while (start_bit_index + i) <= end_bit_index\n      low_bits = bits\n      low_bits = low_bits >> start_sub_index\n      bits = @bits[(start_bit_index + i) + 1]\n      high_bits = bits\n      high_bits = high_bits & ((1 << start_sub_index) - 1)\n      high_bits = high_bits << (32 - start_sub_index)\n      (ba.@bits)[i] = low_bits | high_bits\n      i = i + 1\n    end\n    ba\n  end\nend\n"}},{"id":"[](range:Range)-instance-method","html_id":"[](range:Range)-instance-method","name":"[]","doc":"Returns all elements that are within the given range.\n\nNegative indices count backward from the end of the array (-1 is the last\nelement). Additionally, an empty array is returned when the starting index\nfor an element range is at the end of the array.\n\nRaises `IndexError` if the starting index is out of range.\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(5)\nba[0] = true; ba[2] = true; ba[4] = true\nba # => BitArray[10101]\n\nba[1..3]    # => BitArray[010]\nba[4..7]    # => BitArray[1]\nba[6..10]   # raise IndexError\nba[5..10]   # => BitArray[]\nba[-2...-1] # => BitArray[0]\n```","summary":"<p>Returns all elements that are within the given range.</p>","abstract":false,"args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"}],"args_string":"(range : Range)","source_link":null,"def":{"name":"[]","args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self[*Indexable.range_to_index_and_count(range, size)]"}},{"id":"[]=(index,value:Bool)-instance-method","html_id":"[]=(index,value:Bool)-instance-method","name":"[]=","doc":"Sets the bit at the given *index*.\nNegative indices can be used to start counting from the end of the array.\nRaises `IndexError` if trying to access a bit outside the array's range.\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(5)\nba[3] = true\n```","summary":"<p>Sets the bit at the given <em>index</em>.</p>","abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":""},{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"Bool"}],"args_string":"(index, value : Bool)","source_link":null,"def":{"name":"[]=","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":""},{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"Bool"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"bit_index, sub_index = bit_index_and_sub_index(index)\nif value\n  __temp_87 = bit_index\n  @bits[__temp_87] = @bits[__temp_87] | (1 << sub_index)\nelse\n  __temp_89 = bit_index\n  @bits[__temp_89] = @bits[__temp_89] & (~(1 << sub_index))\nend\n"}},{"id":"hash(hasher)-instance-method","html_id":"hash(hasher)-instance-method","name":"hash","doc":"See `Object#hash(hasher)`","summary":"<p>See <code><a href=\"Object.html#hash(hasher)-instance-method\">Object#hash(hasher)</a></code></p>","abstract":false,"args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"args_string":"(hasher)","source_link":null,"def":{"name":"hash","args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"hasher = size.hash(hasher)\nhasher = to_slice.hash(hasher)\nhasher\n"}},{"id":"inspect(io:IO):Nil-instance-method","html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Creates a string representation of self.\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(5)\nba.to_s # => \"BitArray[00000]\"\n```","summary":"<p>Creates a string representation of self.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"inspect","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"to_s(io)"}},{"id":"invert-instance-method","html_id":"invert-instance-method","name":"invert","doc":"Inverts all bits in the array. Falses become `true` and vice versa.\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(5)\nba[2] = true; ba[3] = true\nba # => BitArray[00110]\nba.invert\nba # => BitArray[11001]\n```","summary":"<p>Inverts all bits in the array.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"invert","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"malloc_size.times do |i|\n  @bits[i] = ~@bits[i]\nend"}},{"id":"size:Int32-instance-method","html_id":"size:Int32-instance-method","name":"size","doc":"The number of bits the BitArray stores","summary":"<p>The number of bits the BitArray stores</p>","abstract":false,"args":[],"args_string":" : Int32","source_link":null,"def":{"name":"size","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":"@size"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Creates a string representation of self.\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(5)\nba.to_s # => \"BitArray[00000]\"\n```","summary":"<p>Creates a string representation of self.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << \"BitArray[\"\neach do |value|\n  io << (value ? '1' : '0')\nend\nio << ']'\n"}},{"id":"to_slice:Bytes-instance-method","html_id":"to_slice:Bytes-instance-method","name":"to_slice","doc":"Returns a `Bytes` able to read and write bytes from a buffer.\nThe slice will be long enough to hold all the bits groups in bytes despite the `UInt32` internal representation.\nIt's useful for reading and writing a bit array from a byte buffer directly.","summary":"<p>Returns a <code><a href=\"Bytes.html\">Bytes</a></code> able to read and write bytes from a buffer.</p>","abstract":false,"args":[],"args_string":" : Bytes","source_link":null,"def":{"name":"to_slice","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bytes","visibility":"Public","body":"Slice.new(@bits.as(Pointer(UInt8)), (@size / 8.0).ceil.to_i)"}},{"id":"toggle(index)-instance-method","html_id":"toggle(index)-instance-method","name":"toggle","doc":"Toggles the bit at the given *index*. A false bit becomes a `true` bit, and\nvice versa.\nNegative indices can be used to start counting from the end of the array.\nRaises `IndexError` if trying to access a bit outside the array's range.\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(5)\nba[3] # => false\nba.toggle(3)\nba[3] # => true\n```","summary":"<p>Toggles the bit at the given <em>index</em>.</p>","abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":""}],"args_string":"(index)","source_link":null,"def":{"name":"toggle","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"bit_index, sub_index = bit_index_and_sub_index(index)\n__temp_91 = bit_index\n@bits[__temp_91] = @bits[__temp_91] ^ (1 << sub_index)\n"}},{"id":"unsafe_fetch(index:Int)-instance-method","html_id":"unsafe_fetch(index:Int)-instance-method","name":"unsafe_fetch","doc":"Returns the element at the given *index*, without doing any bounds check.\n\n`Indexable` makes sure to invoke this method with *index* in `0...size`,\nso converting negative indices to positive ones is not needed here.\n\nClients never invoke this method directly. Instead, they access\nelements with `#[](index)` and `#[]?(index)`.\n\nThis method should only be directly invoked if you are absolutely\nsure the index is in bounds, to avoid a bounds check for a small boost\nof performance.","summary":"<p>Returns the element at the given <em>index</em>, without doing any bounds check.</p>","abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"}],"args_string":"(index : Int)","source_link":null,"def":{"name":"unsafe_fetch","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"bit_index, sub_index = index.divmod(32)\n(@bits[bit_index] & (1 << sub_index)) > 0\n"}}],"macros":[],"types":[]},{"html_id":"/Bool","path":"Bool.html","kind":"struct","full_name":"Bool","name":"Bool","abstract":false,"superclass":{"html_id":"/Value","kind":"struct","full_name":"Value","name":"Value"},"ancestors":[{"html_id":"/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"Bool has only two possible values: `true` and `false`. They are constructed using these literals:\n\n```\ntrue  # A Bool that is true\nfalse # A Bool that is false\n```","summary":"<p>Bool has only two possible values: <code>true</code> and <code>false</code>.</p>","class_methods":[],"constructors":[{"id":"new(ctx:YAML::ParseContext,node:YAML::Nodes::Node)-class-method","html_id":"new(ctx:YAML::ParseContext,node:YAML::Nodes::Node)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"ctx","doc":null,"default_value":"","external_name":"ctx","restriction":"YAML::ParseContext"},{"name":"node","doc":null,"default_value":"","external_name":"node","restriction":"YAML::Nodes::Node"}],"args_string":"(ctx : YAML::ParseContext, node : YAML::Nodes::Node)","source_link":null,"def":{"name":"new","args":[{"name":"ctx","doc":null,"default_value":"","external_name":"ctx","restriction":"YAML::ParseContext"},{"name":"node","doc":null,"default_value":"","external_name":"node","restriction":"YAML::Nodes::Node"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"parse_scalar(ctx, node, self)"}},{"id":"new(pull:JSON::PullParser)-class-method","html_id":"new(pull:JSON::PullParser)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"pull","doc":null,"default_value":"","external_name":"pull","restriction":"JSON::PullParser"}],"args_string":"(pull : JSON::PullParser)","source_link":null,"def":{"name":"new","args":[{"name":"pull","doc":null,"default_value":"","external_name":"pull","restriction":"JSON::PullParser"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"pull.read_bool"}}],"instance_methods":[{"id":"!=(other:Bool):Bool-instance-method","html_id":"!=(other:Bool):Bool-instance-method","name":"!=","doc":"Returns `true` if `self` is not equal to *other*.","summary":"<p>Returns <code>true</code> if <code>self</code> is not equal to <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Bool"}],"args_string":"(other : Bool) : Bool","source_link":null,"def":{"name":"!=","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Bool"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"# primitive: binary"}},{"id":"&(other:Bool):Bool-instance-method","html_id":"&amp;(other:Bool):Bool-instance-method","name":"&","doc":"Bitwise AND. Returns `true` if this bool and *other* are `true`, otherwise returns `false`.\n\n```\nfalse & false # => false\nfalse & true  # => false\ntrue & false  # => false\ntrue & true   # => true\n```","summary":"<p>Bitwise AND.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Bool"}],"args_string":"(other : Bool) : Bool","source_link":null,"def":{"name":"&","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Bool"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"self ? other : false"}},{"id":"==(other:Bool):Bool-instance-method","html_id":"==(other:Bool):Bool-instance-method","name":"==","doc":"Returns `true` if `self` is equal to *other*.","summary":"<p>Returns <code>true</code> if <code>self</code> is equal to <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Bool"}],"args_string":"(other : Bool) : Bool","source_link":null,"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Bool"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"# primitive: binary"}},{"id":"^(other:Bool):Bool-instance-method","html_id":"^(other:Bool):Bool-instance-method","name":"^","doc":"Exclusive OR. Returns `true` if this bool is different from *other*, otherwise returns `false`.\n\n```\nfalse ^ false # => false\nfalse ^ true  # => true\ntrue ^ false  # => true\ntrue ^ true   # => false\n```","summary":"<p>Exclusive OR.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Bool"}],"args_string":"(other : Bool) : Bool","source_link":null,"def":{"name":"^","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Bool"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"self != other"}},{"id":"clone:Bool-instance-method","html_id":"clone:Bool-instance-method","name":"clone","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Bool","source_link":null,"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"self"}},{"id":"hash(hasher)-instance-method","html_id":"hash(hasher)-instance-method","name":"hash","doc":"See `Object#hash(hasher)`","summary":"<p>See <code><a href=\"Object.html#hash(hasher)-instance-method\">Object#hash(hasher)</a></code></p>","abstract":false,"args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"args_string":"(hasher)","source_link":null,"def":{"name":"hash","args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"hasher.bool(self)"}},{"id":"to_json(json:JSON::Builder)-instance-method","html_id":"to_json(json:JSON::Builder)-instance-method","name":"to_json","doc":null,"summary":null,"abstract":false,"args":[{"name":"json","doc":null,"default_value":"","external_name":"json","restriction":"JSON::Builder"}],"args_string":"(json : JSON::Builder)","source_link":null,"def":{"name":"to_json","args":[{"name":"json","doc":null,"default_value":"","external_name":"json","restriction":"JSON::Builder"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"json.bool(self)"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Appends `\"true\"` for `true` and `\"false\"` for `false` to the given IO.","summary":"<p>Appends <code>\"true\"</code> for <code>true</code> and <code>\"false\"</code> for <code>false</code> to the given IO.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << to_s"}},{"id":"to_s:String-instance-method","html_id":"to_s:String-instance-method","name":"to_s","doc":"Returns `\"true\"` for `true` and `\"false\"` for `false`.","summary":"<p>Returns <code>\"true\"</code> for <code>true</code> and <code>\"false\"</code> for <code>false</code>.</p>","abstract":false,"args":[],"args_string":" : String","source_link":null,"def":{"name":"to_s","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"self ? \"true\" : \"false\""}},{"id":"to_unsafe:LibC::Int-instance-method","html_id":"to_unsafe:LibC::Int-instance-method","name":"to_unsafe","doc":"Returns an integer derived from the boolean value, for interoperability with C-style booleans.\n\nThe value is `1` for `true` and `0` for `false`.","summary":"<p>Returns an integer derived from the boolean value, for interoperability with C-style booleans.</p>","abstract":false,"args":[],"args_string":" : LibC::Int","source_link":null,"def":{"name":"to_unsafe","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"LibC::Int","visibility":"Public","body":"LibC::Int.new(self ? 1 : 0)"}},{"id":"to_yaml(yaml:YAML::Nodes::Builder)-instance-method","html_id":"to_yaml(yaml:YAML::Nodes::Builder)-instance-method","name":"to_yaml","doc":null,"summary":null,"abstract":false,"args":[{"name":"yaml","doc":null,"default_value":"","external_name":"yaml","restriction":"YAML::Nodes::Builder"}],"args_string":"(yaml : YAML::Nodes::Builder)","source_link":null,"def":{"name":"to_yaml","args":[{"name":"yaml","doc":null,"default_value":"","external_name":"yaml","restriction":"YAML::Nodes::Builder"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"yaml.scalar(self)"}},{"id":"|(other:Bool):Bool-instance-method","html_id":"|(other:Bool):Bool-instance-method","name":"|","doc":"Bitwise OR. Returns `true` if this bool or *other* is `true`, otherwise returns `false`.\n\n```\nfalse | false # => false\nfalse | true  # => true\ntrue | false  # => true\ntrue | true   # => true\n```","summary":"<p>Bitwise OR.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Bool"}],"args_string":"(other : Bool) : Bool","source_link":null,"def":{"name":"|","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Bool"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"self ? true : other"}}],"macros":[],"types":[]},{"html_id":"/Box","path":"Box.html","kind":"class","full_name":"Box(T)","name":"Box","abstract":false,"superclass":{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"A Box allows turning any object to a `Void*` and back.\n\nA Box's purpose is passing data to C as a `Void*` and then converting that\nback to the original data type.\n\nFor an example usage, see `Proc`'s explanation about sending Procs to C.","summary":"<p>A Box allows turning any object to a <code>Void*</code> and back.</p>","class_methods":[{"id":"box(r:Reference?):Pointer(Void)-class-method","html_id":"box(r:Reference?):Pointer(Void)-class-method","name":"box","doc":"Creates a Box for a reference type (or `nil`) and returns the same pointer (or `NULL`)","summary":"<p>Creates a Box for a reference type (or <code>nil</code>) and returns the same pointer (or <code>NULL</code>)</p>","abstract":false,"args":[{"name":"r","doc":null,"default_value":"","external_name":"r","restriction":"Reference | ::Nil"}],"args_string":"(r : Reference?) : Pointer(Void)","source_link":null,"def":{"name":"box","args":[{"name":"r","doc":null,"default_value":"","external_name":"r","restriction":"Reference | ::Nil"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"::Pointer(Void)","visibility":"Public","body":"r.as(::Pointer(Void))"}},{"id":"box(object):Pointer(Void)-class-method","html_id":"box(object):Pointer(Void)-class-method","name":"box","doc":"Creates a Box for an object and returns it as a `Void*`.","summary":"<p>Creates a Box for an object and returns it as a <code>Void*</code>.</p>","abstract":false,"args":[{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":""}],"args_string":"(object) : Pointer(Void)","source_link":null,"def":{"name":"box","args":[{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"::Pointer(Void)","visibility":"Public","body":"(new(object)).as(::Pointer(Void))"}},{"id":"unbox(pointer:Pointer(Void)):T-class-method","html_id":"unbox(pointer:Pointer(Void)):T-class-method","name":"unbox","doc":"Unboxes a `Void*` into an object of type `T`. Note that for this you must\nspecify T: `Box(T).unbox(data)`.","summary":"<p>Unboxes a <code>Void*</code> into an object of type <code>T</code>.</p>","abstract":false,"args":[{"name":"pointer","doc":null,"default_value":"","external_name":"pointer","restriction":"::Pointer(Void)"}],"args_string":"(pointer : Pointer(Void)) : T","source_link":null,"def":{"name":"unbox","args":[{"name":"pointer","doc":null,"default_value":"","external_name":"pointer","restriction":"::Pointer(Void)"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"T","visibility":"Public","body":"{% if T <= Reference %}\n      pointer.as(T)\n    {% else %}{% if T == Nil %}\n      # FIXME: This branch could be merged with the previous one once the issue #8015 is fixed\n      nil\n    {% else %}\n      pointer.as(self).object\n    {% end %}{% end %}"}}],"constructors":[{"id":"new(object:T)-class-method","html_id":"new(object:T)-class-method","name":"new","doc":"Creates a `Box` with the given object.\n\nThis method isn't usually used directly. Instead, `Box.box` is used.","summary":"<p>Creates a <code><a href=\"Box.html\">Box</a></code> with the given object.</p>","abstract":false,"args":[{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":"T"}],"args_string":"(object : T)","source_link":null,"def":{"name":"new","args":[{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = Box(T).allocate\n_.initialize(object)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"object:T-instance-method","html_id":"object:T-instance-method","name":"object","doc":"Returns the original object","summary":"<p>Returns the original object</p>","abstract":false,"args":[],"args_string":" : T","source_link":null,"def":{"name":"object","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"T","visibility":"Public","body":"@object"}}],"macros":[],"types":[]},{"html_id":"/Bytes","path":"Bytes.html","kind":"alias","full_name":"Bytes","name":"Bytes","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"","program":false,"enum":false,"alias":true,"aliased":"Slice(UInt8)","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"A convenient alias for the most common slice type,\na slice of bytes, used for example in `IO#read` and `IO#write`.","summary":"<p>A convenient alias for the most common slice type, a slice of bytes, used for example in <code><a href=\"IO.html#read(slice:Bytes)-instance-method\">IO#read</a></code> and <code><a href=\"IO.html#write(slice:Bytes):Nil-instance-method\">IO#write</a></code>.</p>","class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"/Channel","path":"Channel.html","kind":"class","full_name":"Channel(T)","name":"Channel","abstract":false,"superclass":{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"A `Channel` enables concurrent communication between fibers.\n\nThey allow communicating data between fibers without sharing memory and without having to worry about locks, semaphores or other special structures.\n\n```\nchannel = Channel(Int32).new\n\nspawn do\n  channel.send(0)\n  channel.send(1)\nend\n\nchannel.receive # => 0\nchannel.receive # => 1\n```","summary":"<p>A <code><a href=\"Channel.html\">Channel</a></code> enables concurrent communication between fibers.</p>","class_methods":[{"id":"receive_first(channels:Tuple|Array)-class-method","html_id":"receive_first(channels:Tuple|Array)-class-method","name":"receive_first","doc":null,"summary":null,"abstract":false,"args":[{"name":"channels","doc":null,"default_value":"","external_name":"channels","restriction":"Tuple | Array"}],"args_string":"(channels : Tuple | Array)","source_link":null,"def":{"name":"receive_first","args":[{"name":"channels","doc":null,"default_value":"","external_name":"channels","restriction":"Tuple | Array"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_, value = self.select(channels.map(&.receive_select_action))\nif value.is_a?(NotReady)\n  raise(\"BUG: Channel.select returned not ready status\")\nend\nvalue\n"}},{"id":"receive_first(*channels)-class-method","html_id":"receive_first(*channels)-class-method","name":"receive_first","doc":null,"summary":null,"abstract":false,"args":[{"name":"channels","doc":null,"default_value":"","external_name":"channels","restriction":""}],"args_string":"(*channels)","source_link":null,"def":{"name":"receive_first","args":[{"name":"channels","doc":null,"default_value":"","external_name":"channels","restriction":""}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"receive_first(channels)"}},{"id":"select(ops:Indexable(SelectAction),has_else=false)-class-method","html_id":"select(ops:Indexable(SelectAction),has_else=false)-class-method","name":"select","doc":null,"summary":null,"abstract":false,"args":[{"name":"ops","doc":null,"default_value":"","external_name":"ops","restriction":"Indexable(SelectAction)"},{"name":"has_else","doc":null,"default_value":"false","external_name":"has_else","restriction":""}],"args_string":"(ops : Indexable(SelectAction), has_else = <span class=\"n\">false</span>)","source_link":null,"def":{"name":"select","args":[{"name":"ops","doc":null,"default_value":"","external_name":"ops","restriction":"Indexable(SelectAction)"},{"name":"has_else","doc":null,"default_value":"false","external_name":"has_else","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ops_locks = ops.to_a.uniq(&.lock_object_id).sort_by(&.lock_object_id)\nops_locks.each(&.lock)\nops.each_with_index do |op, index|\n  ignore = false\n  result = op.execute\n  if result.is_a?(NotReady)\n  else\n    ops_locks.each(&.unlock)\n    return {index, result}\n  end\nend\nif has_else\n  ops_locks.each(&.unlock)\n  return {ops.size, NotReady}\nend\nstate = Atomic(SelectState).new(SelectState::Active)\ncontexts = ops.map(&.create_context_and_wait(pointerof(state)))\nops_locks.each(&.unlock)\nCrystal::Scheduler.reschedule\nops.each do |op|\n  op.lock\n  op.unwait\n  op.unlock\nend\ncontexts.each_with_index do |context, index|\n  if context.activated?\n    return {index, context.action.result}\n  end\nend\nraise(\"BUG: Fiber was awaken from select but no action was activated\")\n"}},{"id":"select(*ops:SelectAction)-class-method","html_id":"select(*ops:SelectAction)-class-method","name":"select","doc":null,"summary":null,"abstract":false,"args":[{"name":"ops","doc":null,"default_value":"","external_name":"ops","restriction":"SelectAction"}],"args_string":"(*ops : SelectAction)","source_link":null,"def":{"name":"select","args":[{"name":"ops","doc":null,"default_value":"","external_name":"ops","restriction":"SelectAction"}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self.select(ops)"}},{"id":"send_first(value,channels:Tuple|Array)-class-method","html_id":"send_first(value,channels:Tuple|Array)-class-method","name":"send_first","doc":null,"summary":null,"abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":""},{"name":"channels","doc":null,"default_value":"","external_name":"channels","restriction":"Tuple | Array"}],"args_string":"(value, channels : Tuple | Array)","source_link":null,"def":{"name":"send_first","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":""},{"name":"channels","doc":null,"default_value":"","external_name":"channels","restriction":"Tuple | Array"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self.select(channels.map(&.send_select_action(value)))\nnil\n"}},{"id":"send_first(value,*channels)-class-method","html_id":"send_first(value,*channels)-class-method","name":"send_first","doc":null,"summary":null,"abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":""},{"name":"channels","doc":null,"default_value":"","external_name":"channels","restriction":""}],"args_string":"(value, *channels)","source_link":null,"def":{"name":"send_first","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":""},{"name":"channels","doc":null,"default_value":"","external_name":"channels","restriction":""}],"double_splat":null,"splat_index":1,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"send_first(value, channels)"}}],"constructors":[{"id":"new(capacity=0)-class-method","html_id":"new(capacity=0)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"capacity","doc":null,"default_value":"0","external_name":"capacity","restriction":""}],"args_string":"(capacity = <span class=\"n\">0</span>)","source_link":null,"def":{"name":"new","args":[{"name":"capacity","doc":null,"default_value":"0","external_name":"capacity","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = Channel(T).allocate\n_.initialize(capacity)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"close-instance-method","html_id":"close-instance-method","name":"close","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"close","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@closed = true\n@senders.each do |__arg0|\n  __arg0.fiber.enqueue\nend\n@receivers.each do |receiver|\n  receiver.state_ptr.value = DeliveryState::Closed\n  receiver.fiber.enqueue\nend\n@senders.clear\n@receivers.clear\nnil\n"}},{"id":"closed?-instance-method","html_id":"closed?-instance-method","name":"closed?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"closed?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@closed"}},{"id":"inspect(io:IO):Nil-instance-method","html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Appends a String representation of this object\nwhich includes its class name, its object address\nand the values of all instance variables.\n\n```\nclass Person\n  def initialize(@name : String, @age : Int32)\n  end\nend\n\nPerson.new(\"John\", 32).inspect # => #<Person:0x10fd31f20 @name=\"John\", @age=32>\n```","summary":"<p>Appends a String representation of this object which includes its class name, its object address and the values of all instance variables.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"inspect","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"to_s(io)"}},{"id":"pretty_print(pp)-instance-method","html_id":"pretty_print(pp)-instance-method","name":"pretty_print","doc":null,"summary":null,"abstract":false,"args":[{"name":"pp","doc":null,"default_value":"","external_name":"pp","restriction":""}],"args_string":"(pp)","source_link":null,"def":{"name":"pretty_print","args":[{"name":"pp","doc":null,"default_value":"","external_name":"pp","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"pp.text(inspect)"}},{"id":"receive-instance-method","html_id":"receive-instance-method","name":"receive","doc":"Receives a value from the channel.\nIf there is a value waiting, it is returned immediately. Otherwise, this method blocks until a value is sent to the channel.\n\nRaises `ClosedError` if the channel is closed or closes while waiting for receive.\n\n```\nchannel = Channel(Int32).new\nchannel.send(1)\nchannel.receive # => 1\n```","summary":"<p>Receives a value from the channel.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"receive","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"receive_impl do\n  raise(ClosedError.new)\nend"}},{"id":"receive?-instance-method","html_id":"receive?-instance-method","name":"receive?","doc":"Receives a value from the channel.\nIf there is a value waiting, it is returned immediately. Otherwise, this method blocks until a value is sent to the channel.\n\nReturns `nil` if the channel is closed or closes while waiting for receive.","summary":"<p>Receives a value from the channel.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"receive?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"receive_impl do\n  return nil\nend"}},{"id":"receive_impl(&block)-instance-method","html_id":"receive_impl(&amp;block)-instance-method","name":"receive_impl","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"(&block)","source_link":null,"def":{"name":"receive_impl","args":[],"double_splat":null,"splat_index":null,"yields":0,"block_arg":null,"return_type":"","visibility":"Public","body":"@lock.sync do\n  receive_internal do\n    if @closed\n      yield\n    end\n    value = uninitialized T\n    state = DeliveryState::None\n    @receivers << (Receiver(T).new(Fiber.current, pointerof(value), pointerof(state), select_context: nil))\n    @lock.unsync do\n      Crystal::Scheduler.reschedule\n    end\n    case state\n    when DeliveryState::Delivered\n      value\n    when DeliveryState::Closed\n      yield\n    else\n      raise(\"BUG: Fiber was awaken without channel delivery state set\")\n    end\n  end\nend"}},{"id":"receive_internal(&block)-instance-method","html_id":"receive_internal(&amp;block)-instance-method","name":"receive_internal","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"(&block)","source_link":null,"def":{"name":"receive_internal","args":[],"double_splat":null,"splat_index":null,"yields":0,"block_arg":null,"return_type":"","visibility":"Public","body":"if (queue = @queue) && (!queue.empty?)\n  deque_value = queue.shift\n  if sender = dequeue_sender\n    sender.fiber.enqueue\n    queue << sender.value\n  end\n  deque_value\nelse\n  if sender = dequeue_sender\n    sender.fiber.enqueue\n    sender.value\n  else\n    yield\n  end\nend"}},{"id":"send(value:T)-instance-method","html_id":"send(value:T)-instance-method","name":"send","doc":null,"summary":null,"abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","source_link":null,"def":{"name":"send","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@lock.sync do\n  raise_if_closed\n  send_internal(value) do\n    @senders << (Sender(T).new(Fiber.current, value, select_context: nil))\n    @lock.unsync do\n      Crystal::Scheduler.reschedule\n    end\n    raise_if_closed\n  end\n  self\nend"}}],"macros":[],"types":[{"html_id":"/Channel/ClosedError","path":"Channel/ClosedError.html","kind":"class","full_name":"Channel::ClosedError","name":"ClosedError","abstract":false,"superclass":{"html_id":"/Exception","kind":"class","full_name":"Exception","name":"Exception"},"ancestors":[{"html_id":"/Exception","kind":"class","full_name":"Exception","name":"Exception"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Channel","kind":"class","full_name":"Channel(T)","name":"Channel"},"doc":null,"summary":null,"class_methods":[],"constructors":[{"id":"new(msg=&quot;Channelisclosed&quot;)-class-method","html_id":"new(msg=&amp;quot;Channelisclosed&amp;quot;)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"msg","doc":null,"default_value":"\"Channel is closed\"","external_name":"msg","restriction":""}],"args_string":"(msg = <span class=\"s\">&quot;Channel is closed&quot;</span>)","source_link":null,"def":{"name":"new","args":[{"name":"msg","doc":null,"default_value":"\"Channel is closed\"","external_name":"msg","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(msg)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[],"macros":[],"types":[]},{"html_id":"/Channel/DeliveryState","path":"Channel/DeliveryState.html","kind":"enum","full_name":"Channel::DeliveryState","name":"DeliveryState","abstract":false,"superclass":null,"ancestors":[{"html_id":"/Enum","kind":"struct","full_name":"Enum","name":"Enum"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":true,"alias":false,"aliased":"","const":false,"constants":[{"id":"None","name":"None","value":"0","doc":null,"summary":null},{"id":"Delivered","name":"Delivered","value":"1","doc":null,"summary":null},{"id":"Closed","name":"Closed","value":"2","doc":null,"summary":null}],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Channel","kind":"class","full_name":"Channel(T)","name":"Channel"},"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[{"id":"closed?-instance-method","html_id":"closed?-instance-method","name":"closed?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"closed?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == Closed"}},{"id":"delivered?-instance-method","html_id":"delivered?-instance-method","name":"delivered?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"delivered?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == Delivered"}},{"id":"none?-instance-method","html_id":"none?-instance-method","name":"none?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"none?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == None"}}],"macros":[],"types":[]},{"html_id":"/Channel/NotReady","path":"Channel/NotReady.html","kind":"module","full_name":"Channel::NotReady","name":"NotReady","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[{"html_id":"/Channel/NotReady","kind":"module","full_name":"Channel::NotReady","name":"NotReady"}],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Channel","kind":"class","full_name":"Channel(T)","name":"Channel"},"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"/Channel/Receiver","path":"Channel/Receiver.html","kind":"struct","full_name":"Channel::Receiver(T)","name":"Receiver","abstract":false,"superclass":{"html_id":"/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Channel","kind":"class","full_name":"Channel(T)","name":"Channel"},"doc":null,"summary":null,"class_methods":[],"constructors":[{"id":"new(fiber:Fiber,value_ptr:Pointer(T),state_ptr:Pointer(DeliveryState),select_context:SelectContext(T)?)-class-method","html_id":"new(fiber:Fiber,value_ptr:Pointer(T),state_ptr:Pointer(DeliveryState),select_context:SelectContext(T)?)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"fiber","doc":null,"default_value":"","external_name":"fiber","restriction":"Fiber"},{"name":"value_ptr","doc":null,"default_value":"","external_name":"value_ptr","restriction":"::Pointer(T)"},{"name":"state_ptr","doc":null,"default_value":"","external_name":"state_ptr","restriction":"::Pointer(DeliveryState)"},{"name":"select_context","doc":null,"default_value":"","external_name":"select_context","restriction":"SelectContext(T) | ::Nil"}],"args_string":"(fiber : Fiber, value_ptr : Pointer(T), state_ptr : Pointer(DeliveryState), select_context : SelectContext(T)?)","source_link":null,"def":{"name":"new","args":[{"name":"fiber","doc":null,"default_value":"","external_name":"fiber","restriction":"Fiber"},{"name":"value_ptr","doc":null,"default_value":"","external_name":"value_ptr","restriction":"::Pointer(T)"},{"name":"state_ptr","doc":null,"default_value":"","external_name":"state_ptr","restriction":"::Pointer(DeliveryState)"},{"name":"select_context","doc":null,"default_value":"","external_name":"select_context","restriction":"SelectContext(T) | ::Nil"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = Receiver(T).allocate\n_.initialize(fiber, value_ptr, state_ptr, select_context)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"clone-instance-method","html_id":"clone-instance-method","name":"clone","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self.class.new(@fiber.clone, @value_ptr.clone, @state_ptr.clone, @select_context.clone)"}},{"id":"copy_with(fiber_fiber=@fiber,value_ptr_value_ptr=@value_ptr,state_ptr_state_ptr=@state_ptr,select_context_select_context=@select_context)-instance-method","html_id":"copy_with(fiber_fiber=@fiber,value_ptr_value_ptr=@value_ptr,state_ptr_state_ptr=@state_ptr,select_context_select_context=@select_context)-instance-method","name":"copy_with","doc":null,"summary":null,"abstract":false,"args":[{"name":"_fiber","doc":null,"default_value":"@fiber","external_name":"fiber","restriction":""},{"name":"_value_ptr","doc":null,"default_value":"@value_ptr","external_name":"value_ptr","restriction":""},{"name":"_state_ptr","doc":null,"default_value":"@state_ptr","external_name":"state_ptr","restriction":""},{"name":"_select_context","doc":null,"default_value":"@select_context","external_name":"select_context","restriction":""}],"args_string":"(fiber _fiber = @fiber, value_ptr _value_ptr = @value_ptr, state_ptr _state_ptr = @state_ptr, select_context _select_context = @select_context)","source_link":null,"def":{"name":"copy_with","args":[{"name":"_fiber","doc":null,"default_value":"@fiber","external_name":"fiber","restriction":""},{"name":"_value_ptr","doc":null,"default_value":"@value_ptr","external_name":"value_ptr","restriction":""},{"name":"_state_ptr","doc":null,"default_value":"@state_ptr","external_name":"state_ptr","restriction":""},{"name":"_select_context","doc":null,"default_value":"@select_context","external_name":"select_context","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self.class.new(_fiber, _value_ptr, _state_ptr, _select_context)"}},{"id":"fiber:Fiber-instance-method","html_id":"fiber:Fiber-instance-method","name":"fiber","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Fiber","source_link":null,"def":{"name":"fiber","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Fiber","visibility":"Public","body":"@fiber"}},{"id":"select_context:SelectContext(T)?-instance-method","html_id":"select_context:SelectContext(T)?-instance-method","name":"select_context","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : SelectContext(T)?","source_link":null,"def":{"name":"select_context","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"SelectContext(T) | ::Nil","visibility":"Public","body":"@select_context"}},{"id":"state_ptr:Pointer(DeliveryState)-instance-method","html_id":"state_ptr:Pointer(DeliveryState)-instance-method","name":"state_ptr","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Pointer(DeliveryState)","source_link":null,"def":{"name":"state_ptr","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"::Pointer(DeliveryState)","visibility":"Public","body":"@state_ptr"}},{"id":"value_ptr:Pointer(T)-instance-method","html_id":"value_ptr:Pointer(T)-instance-method","name":"value_ptr","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Pointer(T)","source_link":null,"def":{"name":"value_ptr","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"::Pointer(T)","visibility":"Public","body":"@value_ptr"}}],"macros":[],"types":[]},{"html_id":"/Channel/SelectAction","path":"Channel/SelectAction.html","kind":"module","full_name":"Channel::SelectAction(S)","name":"SelectAction","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Channel","kind":"class","full_name":"Channel(T)","name":"Channel"},"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[{"id":"create_context_and_wait(state_ptr)-instance-method","html_id":"create_context_and_wait(state_ptr)-instance-method","name":"create_context_and_wait","doc":null,"summary":null,"abstract":false,"args":[{"name":"state_ptr","doc":null,"default_value":"","external_name":"state_ptr","restriction":""}],"args_string":"(state_ptr)","source_link":null,"def":{"name":"create_context_and_wait","args":[{"name":"state_ptr","doc":null,"default_value":"","external_name":"state_ptr","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"context = SelectContext.new(state_ptr, self)\nself.wait(context)\ncontext\n"}},{"id":"execute:S|NotReady-instance-method","html_id":"execute:S|NotReady-instance-method","name":"execute","doc":null,"summary":null,"abstract":true,"args":[],"args_string":" : S | NotReady","source_link":null,"def":{"name":"execute","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"S | NotReady","visibility":"Public","body":""}},{"id":"lock-instance-method","html_id":"lock-instance-method","name":"lock","doc":null,"summary":null,"abstract":true,"args":[],"args_string":"","source_link":null,"def":{"name":"lock","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":""}},{"id":"lock_object_id-instance-method","html_id":"lock_object_id-instance-method","name":"lock_object_id","doc":null,"summary":null,"abstract":true,"args":[],"args_string":"","source_link":null,"def":{"name":"lock_object_id","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":""}},{"id":"result:S-instance-method","html_id":"result:S-instance-method","name":"result","doc":null,"summary":null,"abstract":true,"args":[],"args_string":" : S","source_link":null,"def":{"name":"result","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"S","visibility":"Public","body":""}},{"id":"unlock-instance-method","html_id":"unlock-instance-method","name":"unlock","doc":null,"summary":null,"abstract":true,"args":[],"args_string":"","source_link":null,"def":{"name":"unlock","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":""}},{"id":"unwait-instance-method","html_id":"unwait-instance-method","name":"unwait","doc":null,"summary":null,"abstract":true,"args":[],"args_string":"","source_link":null,"def":{"name":"unwait","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":""}},{"id":"wait(context:SelectContext(S))-instance-method","html_id":"wait(context:SelectContext(S))-instance-method","name":"wait","doc":null,"summary":null,"abstract":true,"args":[{"name":"context","doc":null,"default_value":"","external_name":"context","restriction":"SelectContext(S)"}],"args_string":"(context : SelectContext(S))","source_link":null,"def":{"name":"wait","args":[{"name":"context","doc":null,"default_value":"","external_name":"context","restriction":"SelectContext(S)"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Channel/SelectState","path":"Channel/SelectState.html","kind":"enum","full_name":"Channel::SelectState","name":"SelectState","abstract":false,"superclass":null,"ancestors":[{"html_id":"/Enum","kind":"struct","full_name":"Enum","name":"Enum"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":true,"alias":false,"aliased":"","const":false,"constants":[{"id":"None","name":"None","value":"0","doc":null,"summary":null},{"id":"Active","name":"Active","value":"1","doc":null,"summary":null},{"id":"Done","name":"Done","value":"2","doc":null,"summary":null}],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Channel","kind":"class","full_name":"Channel(T)","name":"Channel"},"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[{"id":"active?-instance-method","html_id":"active?-instance-method","name":"active?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"active?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == Active"}},{"id":"done?-instance-method","html_id":"done?-instance-method","name":"done?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"done?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == Done"}},{"id":"none?-instance-method","html_id":"none?-instance-method","name":"none?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"none?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == None"}}],"macros":[],"types":[]},{"html_id":"/Channel/Sender","path":"Channel/Sender.html","kind":"struct","full_name":"Channel::Sender(T)","name":"Sender","abstract":false,"superclass":{"html_id":"/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Channel","kind":"class","full_name":"Channel(T)","name":"Channel"},"doc":null,"summary":null,"class_methods":[],"constructors":[{"id":"new(fiber:Fiber,value:T,select_context:SelectContext(Nil)?)-class-method","html_id":"new(fiber:Fiber,value:T,select_context:SelectContext(Nil)?)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"fiber","doc":null,"default_value":"","external_name":"fiber","restriction":"Fiber"},{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"},{"name":"select_context","doc":null,"default_value":"","external_name":"select_context","restriction":"SelectContext(Nil) | ::Nil"}],"args_string":"(fiber : Fiber, value : T, select_context : SelectContext(Nil)?)","source_link":null,"def":{"name":"new","args":[{"name":"fiber","doc":null,"default_value":"","external_name":"fiber","restriction":"Fiber"},{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"},{"name":"select_context","doc":null,"default_value":"","external_name":"select_context","restriction":"SelectContext(Nil) | ::Nil"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = Sender(T).allocate\n_.initialize(fiber, value, select_context)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"clone-instance-method","html_id":"clone-instance-method","name":"clone","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self.class.new(@fiber.clone, @value.clone, @select_context.clone)"}},{"id":"copy_with(fiber_fiber=@fiber,value_value=@value,select_context_select_context=@select_context)-instance-method","html_id":"copy_with(fiber_fiber=@fiber,value_value=@value,select_context_select_context=@select_context)-instance-method","name":"copy_with","doc":null,"summary":null,"abstract":false,"args":[{"name":"_fiber","doc":null,"default_value":"@fiber","external_name":"fiber","restriction":""},{"name":"_value","doc":null,"default_value":"@value","external_name":"value","restriction":""},{"name":"_select_context","doc":null,"default_value":"@select_context","external_name":"select_context","restriction":""}],"args_string":"(fiber _fiber = @fiber, value _value = @value, select_context _select_context = @select_context)","source_link":null,"def":{"name":"copy_with","args":[{"name":"_fiber","doc":null,"default_value":"@fiber","external_name":"fiber","restriction":""},{"name":"_value","doc":null,"default_value":"@value","external_name":"value","restriction":""},{"name":"_select_context","doc":null,"default_value":"@select_context","external_name":"select_context","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self.class.new(_fiber, _value, _select_context)"}},{"id":"fiber:Fiber-instance-method","html_id":"fiber:Fiber-instance-method","name":"fiber","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Fiber","source_link":null,"def":{"name":"fiber","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Fiber","visibility":"Public","body":"@fiber"}},{"id":"select_context:SelectContext(Nil)?-instance-method","html_id":"select_context:SelectContext(Nil)?-instance-method","name":"select_context","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : SelectContext(Nil)?","source_link":null,"def":{"name":"select_context","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"SelectContext(Nil) | ::Nil","visibility":"Public","body":"@select_context"}},{"id":"value:T-instance-method","html_id":"value:T-instance-method","name":"value","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : T","source_link":null,"def":{"name":"value","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"T","visibility":"Public","body":"@value"}}],"macros":[],"types":[]}]},{"html_id":"/Char","path":"Char.html","kind":"struct","full_name":"Char","name":"Char","abstract":false,"superclass":{"html_id":"/Value","kind":"struct","full_name":"Value","name":"Value"},"ancestors":[{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[{"id":"MAX","name":"MAX","value":"1114111.unsafe_chr","doc":"The maximum character.","summary":"<p>The maximum character.</p>"},{"id":"MAX_CODEPOINT","name":"MAX_CODEPOINT","value":"1114111","doc":"The maximum valid codepoint for a character.","summary":"<p>The maximum valid codepoint for a character.</p>"},{"id":"REPLACEMENT","name":"REPLACEMENT","value":"'�'","doc":"The replacement character, used on invalid UTF-8 byte sequences.","summary":"<p>The replacement character, used on invalid UTF-8 byte sequences.</p>"},{"id":"ZERO","name":"ZERO","value":"'\\u{0}'","doc":"The character representing the end of a C string.","summary":"<p>The character representing the end of a C string.</p>"}],"included_modules":[{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"}],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"A `Char` represents a [Unicode](http://en.wikipedia.org/wiki/Unicode) [code point](http://en.wikipedia.org/wiki/Code_point).\nIt occupies 32 bits.\n\nIt is created by enclosing an UTF-8 character in single quotes.\n\n```\n'a'\n'z'\n'0'\n'_'\n'あ'\n```\n\nYou can use a backslash to denote some characters:\n\n```\n'\\'' # single quote\n'\\\\' # backslash\n'\\e' # escape\n'\\f' # form feed\n'\\n' # newline\n'\\r' # carriage return\n'\\t' # tab\n'\\v' # vertical tab\n```\n\nYou can use a backslash followed by an *u* and four hexadecimal characters to denote a unicode codepoint written:\n\n```\n'\\u0041' # == 'A'\n```\n\nOr you can use curly braces and specify up to four hexadecimal numbers:\n\n```\n'\\u{41}' # == 'A'\n```","summary":"<p>A <code><a href=\"Char.html\">Char</a></code> represents a <a href=\"http://en.wikipedia.org/wiki/Unicode\" target=\"_blank\">Unicode</a> <a href=\"http://en.wikipedia.org/wiki/Code_point\" target=\"_blank\">code point</a>.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"!=(other:Char):Bool-instance-method","html_id":"!=(other:Char):Bool-instance-method","name":"!=","doc":"Returns `true` if `self`'s codepoint is not equal to *other*'s codepoint.","summary":"<p>Returns <code>true</code> if <code>self</code>'s codepoint is not equal to <em>other</em>'s codepoint.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"args_string":"(other : Char) : Bool","source_link":null,"def":{"name":"!=","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"# primitive: binary"}},{"id":"+(str:String)-instance-method","html_id":"+(str:String)-instance-method","name":"+","doc":"Concatenates this char and *string*.\n\n```\n'f' + \"oo\" # => \"foo\"\n```","summary":"<p>Concatenates this char and <em>string</em>.</p>","abstract":false,"args":[{"name":"str","doc":null,"default_value":"","external_name":"str","restriction":"String"}],"args_string":"(str : String)","source_link":null,"def":{"name":"+","args":[{"name":"str","doc":null,"default_value":"","external_name":"str","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"bytesize = str.bytesize + self.bytesize\nString.new(bytesize) do |buffer|\n  count = 0\n  each_byte do |byte|\n    buffer[count] = byte\n    count = count + 1\n  end\n  (buffer + count).copy_from(str.to_unsafe, str.bytesize)\n  {bytesize, str.size + 1}\nend\n"}},{"id":"+(other:Int):Char-instance-method","html_id":"+(other:Int):Char-instance-method","name":"+","doc":"Returns a char that has this char's codepoint plus *other*.\n\n```\n'a' + 1 # => 'b'\n'a' + 2 # => 'c'\n```","summary":"<p>Returns a char that has this char's codepoint plus <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : Char","source_link":null,"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Char","visibility":"Public","body":"(ord + other).chr"}},{"id":"-(other:Char)-instance-method","html_id":"-(other:Char)-instance-method","name":"-","doc":"Returns the difference of the codepoint values of this char and *other*.\n\n```\n'a' - 'a' # => 0\n'b' - 'a' # => 1\n'c' - 'a' # => 2\n```","summary":"<p>Returns the difference of the codepoint values of this char and <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"args_string":"(other : Char)","source_link":null,"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ord - other.ord"}},{"id":"-(other:Int):Char-instance-method","html_id":"-(other:Int):Char-instance-method","name":"-","doc":"Returns a char that has this char's codepoint minus *other*.\n\n```\n'c' - 1 # => 'b'\n'c' - 2 # => 'a'\n```","summary":"<p>Returns a char that has this char's codepoint minus <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : Char","source_link":null,"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Char","visibility":"Public","body":"(ord - other).chr"}},{"id":"<(other:Char):Bool-instance-method","html_id":"&lt;(other:Char):Bool-instance-method","name":"<","doc":"Returns `true` if `self`'s codepoint is less than *other*'s codepoint.","summary":"<p>Returns <code>true</code> if <code>self</code>'s codepoint is less than <em>other</em>'s codepoint.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"args_string":"(other : Char) : Bool","source_link":null,"def":{"name":"<","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"# primitive: binary"}},{"id":"<=(other:Char):Bool-instance-method","html_id":"&lt;=(other:Char):Bool-instance-method","name":"<=","doc":"Returns `true` if `self`'s codepoint is less than or equal to *other*'s codepoint.","summary":"<p>Returns <code>true</code> if <code>self</code>'s codepoint is less than or equal to <em>other</em>'s codepoint.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"args_string":"(other : Char) : Bool","source_link":null,"def":{"name":"<=","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"# primitive: binary"}},{"id":"(other:Char)-instance-method","html_id":"(other:Char)-instance-method","name":"<=>","doc":"The comparison operator.\n\nReturns the difference of the codepoint values of `self` and *other*.\nThe result is either negative, `0` or positive based on whether `other`'s codepoint is\nless, equal, or greater than `self`'s codepoint.\n\n```\n'a' <=> 'c' # => -2\n'z' <=> 'z' # => 0\n'c' <=> 'a' # => 2\n```","summary":"<p>The comparison operator.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"args_string":"(other : Char)","source_link":null,"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self - other"}},{"id":"==(other:Char):Bool-instance-method","html_id":"==(other:Char):Bool-instance-method","name":"==","doc":"Returns `true` if `self`'s codepoint is equal to *other*'s codepoint.","summary":"<p>Returns <code>true</code> if <code>self</code>'s codepoint is equal to <em>other</em>'s codepoint.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"args_string":"(other : Char) : Bool","source_link":null,"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"# primitive: binary"}},{"id":"===(byte:Int)-instance-method","html_id":"===(byte:Int)-instance-method","name":"===","doc":"Returns `true` if the codepoint is equal to *byte* ignoring the type.\n\n```\n'c'.ord       # => 99\n'c' === 99_u8 # => true\n'c' === 99    # => true\n'z' === 99    # => false\n```","summary":"<p>Returns <code>true</code> if the codepoint is equal to <em>byte</em> ignoring the type.</p>","abstract":false,"args":[{"name":"byte","doc":null,"default_value":"","external_name":"byte","restriction":"Int"}],"args_string":"(byte : Int)","source_link":null,"def":{"name":"===","args":[{"name":"byte","doc":null,"default_value":"","external_name":"byte","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ord === byte"}},{"id":">(other:Char):Bool-instance-method","html_id":"&gt;(other:Char):Bool-instance-method","name":">","doc":"Returns `true` if `self`'s codepoint is greater than *other*'s codepoint.","summary":"<p>Returns <code>true</code> if <code>self</code>'s codepoint is greater than <em>other</em>'s codepoint.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"args_string":"(other : Char) : Bool","source_link":null,"def":{"name":">","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"# primitive: binary"}},{"id":">=(other:Char):Bool-instance-method","html_id":"&gt;=(other:Char):Bool-instance-method","name":">=","doc":"Returns `true` if `self`'s codepoint is greater than or equal to *other*'s codepoint.","summary":"<p>Returns <code>true</code> if <code>self</code>'s codepoint is greater than or equal to <em>other</em>'s codepoint.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"args_string":"(other : Char) : Bool","source_link":null,"def":{"name":">=","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"# primitive: binary"}},{"id":"alphanumeric?-instance-method","html_id":"alphanumeric?-instance-method","name":"alphanumeric?","doc":"Returns `true` if this char is a letter or a number according to unicode.\n\n```\n'c'.alphanumeric? # => true\n'8'.alphanumeric? # => true\n'.'.alphanumeric? # => false\n```","summary":"<p>Returns <code>true</code> if this char is a letter or a number according to unicode.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"alphanumeric?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"letter? || number?"}},{"id":"ascii?-instance-method","html_id":"ascii?-instance-method","name":"ascii?","doc":"Returns `true` if this char is an ASCII character\n(codepoint is in (0..127))","summary":"<p>Returns <code>true</code> if this char is an ASCII character (codepoint is in (0..127))</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"ascii?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ord < 128"}},{"id":"ascii_alphanumeric?-instance-method","html_id":"ascii_alphanumeric?-instance-method","name":"ascii_alphanumeric?","doc":"Returns `true` if this char is an ASCII letter or number ('0' to '9', 'a' to 'z', 'A' to 'Z').\n\n```\n'c'.ascii_alphanumeric? # => true\n'8'.ascii_alphanumeric? # => true\n'.'.ascii_alphanumeric? # => false\n```","summary":"<p>Returns <code>true</code> if this char is an ASCII letter or number ('0' to '9', 'a' to 'z', 'A' to 'Z').</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"ascii_alphanumeric?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ascii_letter? || ascii_number?"}},{"id":"ascii_control?-instance-method","html_id":"ascii_control?-instance-method","name":"ascii_control?","doc":"Returns `true` if this char is an ASCII control character.\n\n```\n('\\u0000'..'\\u0019').each do |char|\n  char.control? # => true\nend\n\n('\\u007F'..'\\u009F').each do |char|\n  char.control? # => true\nend\n```","summary":"<p>Returns <code>true</code> if this char is an ASCII control character.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"ascii_control?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ord < 32 || (127 <= (__temp_18 = ord) && __temp_18 <= 159)"}},{"id":"ascii_letter?-instance-method","html_id":"ascii_letter?-instance-method","name":"ascii_letter?","doc":"Returns `true` if this char is an ASCII letter ('a' to 'z', 'A' to 'Z').\n\n```\n'c'.ascii_letter? # => true\n'á'.ascii_letter? # => false\n'8'.ascii_letter? # => false\n```","summary":"<p>Returns <code>true</code> if this char is an ASCII letter ('a' to 'z', 'A' to 'Z').</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"ascii_letter?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ascii_lowercase? || ascii_uppercase?"}},{"id":"ascii_lowercase?-instance-method","html_id":"ascii_lowercase?-instance-method","name":"ascii_lowercase?","doc":"Returns `true` if this char is a lowercase ASCII letter.\n\n```\n'c'.ascii_lowercase? # => true\n'ç'.lowercase?       # => true\n'G'.ascii_lowercase? # => false\n'.'.ascii_lowercase? # => false\n```","summary":"<p>Returns <code>true</code> if this char is a lowercase ASCII letter.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"ascii_lowercase?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"'a' <= self && self <= 'z'"}},{"id":"ascii_number?(base:Int=10)-instance-method","html_id":"ascii_number?(base:Int=10)-instance-method","name":"ascii_number?","doc":"Returns `true` if this char is an ASCII number in specified base.\n\nBase can be from 0 to 36 with digits from '0' to '9' and 'a' to 'z' or 'A' to 'Z'.\n\n```\n'4'.ascii_number?     # => true\n'z'.ascii_number?     # => false\n'z'.ascii_number?(36) # => true\n```","summary":"<p>Returns <code>true</code> if this char is an ASCII number in specified base.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","source_link":null,"def":{"name":"ascii_number?","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"!(!(to_i?(base)))"}},{"id":"ascii_uppercase?-instance-method","html_id":"ascii_uppercase?-instance-method","name":"ascii_uppercase?","doc":"Returns `true` if this char is an ASCII uppercase letter.\n\n```\n'H'.ascii_uppercase? # => true\n'Á'.ascii_uppercase? # => false\n'c'.ascii_uppercase? # => false\n'.'.ascii_uppercase? # => false\n```","summary":"<p>Returns <code>true</code> if this char is an ASCII uppercase letter.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"ascii_uppercase?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"'A' <= self && self <= 'Z'"}},{"id":"ascii_whitespace?-instance-method","html_id":"ascii_whitespace?-instance-method","name":"ascii_whitespace?","doc":"Returns `true` if this char is an ASCII whitespace.\n\n```\n' '.ascii_whitespace?  # => true\n'\\t'.ascii_whitespace? # => true\n'b'.ascii_whitespace?  # => false\n```","summary":"<p>Returns <code>true</code> if this char is an ASCII whitespace.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"ascii_whitespace?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(self == ' ') || (9 <= (__temp_17 = ord) && __temp_17 <= 13)"}},{"id":"bytes-instance-method","html_id":"bytes-instance-method","name":"bytes","doc":"Returns this char bytes as encoded by UTF-8, as an `Array(UInt8)`.\n\n```\n'a'.bytes # => [97]\n'あ'.bytes # => [227, 129, 130]\n```","summary":"<p>Returns this char bytes as encoded by UTF-8, as an <code><a href=\"Array.html\">Array</a>(<a href=\"UInt8.html\">UInt8</a>)</code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"bytes","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"bytes = [] of UInt8\neach_byte do |byte|\n  bytes << byte\nend\nbytes\n"}},{"id":"bytesize-instance-method","html_id":"bytesize-instance-method","name":"bytesize","doc":"Returns the number of UTF-8 bytes in this char.\n\n```\n'a'.bytesize # => 1\n'好'.bytesize # => 3\n```","summary":"<p>Returns the number of UTF-8 bytes in this char.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"bytesize","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"c = ord\nif c < 128\n  1\nelse\n  if c <= 2047\n    2\n  else\n    if c <= 65535\n      3\n    else\n      if c <= MAX_CODEPOINT\n        4\n      else\n        raise(InvalidByteSequenceError.new(\"Invalid char value #{dump}\"))\n      end\n    end\n  end\nend\n"}},{"id":"clone-instance-method","html_id":"clone-instance-method","name":"clone","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"control?-instance-method","html_id":"control?-instance-method","name":"control?","doc":"Returns `true` if this char is a control character according to unicode.","summary":"<p>Returns <code>true</code> if this char is a control character according to unicode.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"control?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ascii? ? ascii_control? : Unicode.control?(self)"}},{"id":"downcase(options=Unicode::CaseOptions::None)-instance-method","html_id":"downcase(options=Unicode::CaseOptions::None)-instance-method","name":"downcase","doc":"Returns the downcase equivalent of this char.\n\nNote that this only works for characters whose downcase\nequivalent yields a single codepoint. There are a few\ncharacters, like 'İ', than when downcased result in multiple\ncharacters (in this case: 'I' and the dot mark).\n\nFor a more correct method see the method that receives a block.\n\n```\n'Z'.downcase # => 'z'\n'x'.downcase # => 'x'\n'.'.downcase # => '.'\n```","summary":"<p>Returns the downcase equivalent of this char.</p>","abstract":false,"args":[{"name":"options","doc":null,"default_value":"Unicode::CaseOptions::None","external_name":"options","restriction":""}],"args_string":"(options = <span class=\"t\">Unicode</span><span class=\"t\">::</span><span class=\"t\">CaseOptions</span><span class=\"t\">::</span><span class=\"t\">None</span>)","source_link":null,"def":{"name":"downcase","args":[{"name":"options","doc":null,"default_value":"Unicode::CaseOptions::None","external_name":"options","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Unicode.downcase(self, options)"}},{"id":"downcase(options=Unicode::CaseOptions::None,&block)-instance-method","html_id":"downcase(options=Unicode::CaseOptions::None,&amp;block)-instance-method","name":"downcase","doc":"Yields each char for the downcase equivalent of this char.\n\nThis method takes into account the possibility that an downcase\nversion of a char might result in multiple chars, like for\n'İ', which results in 'i' and a dot mark.","summary":"<p>Yields each char for the downcase equivalent of this char.</p>","abstract":false,"args":[{"name":"options","doc":null,"default_value":"Unicode::CaseOptions::None","external_name":"options","restriction":""}],"args_string":"(options = <span class=\"t\">Unicode</span><span class=\"t\">::</span><span class=\"t\">CaseOptions</span><span class=\"t\">::</span><span class=\"t\">None</span>, &block)","source_link":null,"def":{"name":"downcase","args":[{"name":"options","doc":null,"default_value":"Unicode::CaseOptions::None","external_name":"options","restriction":""}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"Unicode.downcase(self, options) do |char|\n  yield char\nend"}},{"id":"dump-instance-method","html_id":"dump-instance-method","name":"dump","doc":"Returns this char as a string that contains a char literal as written in Crystal,\nwith characters with a codepoint greater than `0x79` written as `\\u{...}`.\n\n```\n'a'.dump      # => \"'a'\"\n'\\t'.dump     # => \"'\\\\t'\"\n'あ'.dump      # => \"'\\\\u{3042}'\"\n'\\u0012'.dump # => \"'\\\\u{12}'\"\n```","summary":"<p>Returns this char as a string that contains a char literal as written in Crystal, with characters with a codepoint greater than <code>0x79</code> written as <code>\\u{...}</code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"dump","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"dump_or_inspect do |io|\n  if ascii_control? || ord >= 128\n    io << \"\\\\u{\"\n    ord.to_s(16, io)\n    io << '}'\n  else\n    to_s(io)\n  end\nend"}},{"id":"dump(io)-instance-method","html_id":"dump(io)-instance-method","name":"dump","doc":"Appends this char as a string that contains a char literal to the given `IO`.\n\nSee also: `#dump`.","summary":"<p>Appends this char as a string that contains a char literal to the given <code><a href=\"IO.html\">IO</a></code>.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":""}],"args_string":"(io)","source_link":null,"def":{"name":"dump","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"io << '\\''\nio << dump\nio << '\\''\n"}},{"id":"each_byte(&block):Nil-instance-method","html_id":"each_byte(&amp;block):Nil-instance-method","name":"each_byte","doc":"Yields each of the bytes of this char as encoded by UTF-8.\n\n```\nputs \"'a'\"\n'a'.each_byte do |byte|\n  puts byte\nend\nputs\n\nputs \"'あ'\"\n'あ'.each_byte do |byte|\n  puts byte\nend\n```\n\nOutput:\n\n```text\n'a'\n97\n\n'あ'\n227\n129\n130\n```","summary":"<p>Yields each of the bytes of this char as encoded by UTF-8.</p>","abstract":false,"args":[],"args_string":"(&block) : Nil","source_link":null,"def":{"name":"each_byte","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"c = ord\nif c < 128\n  yield c.to_u8\nelse\n  if c <= 2047\n    yield (192 | (c >> 6)).to_u8\n    yield (128 | (c & 63)).to_u8\n  else\n    if c <= 65535\n      yield (224 | (c >> 12)).to_u8\n      yield (128 | ((c >> 6) & 63)).to_u8\n      yield (128 | (c & 63)).to_u8\n    else\n      if c <= MAX_CODEPOINT\n        yield (240 | (c >> 18)).to_u8\n        yield (128 | ((c >> 12) & 63)).to_u8\n        yield (128 | ((c >> 6) & 63)).to_u8\n        yield (128 | (c & 63)).to_u8\n      else\n        raise(InvalidByteSequenceError.new(\"Invalid char value #{dump}\"))\n      end\n    end\n  end\nend\n"}},{"id":"hash(hasher)-instance-method","html_id":"hash(hasher)-instance-method","name":"hash","doc":"See `Object#hash(hasher)`","summary":"<p>See <code><a href=\"Object.html#hash(hasher)-instance-method\">Object#hash(hasher)</a></code></p>","abstract":false,"args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"args_string":"(hasher)","source_link":null,"def":{"name":"hash","args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"hasher.char(self)"}},{"id":"hex?-instance-method","html_id":"hex?-instance-method","name":"hex?","doc":"Returns `true` if this char is an ASCII hex digit ('0' to '9', 'a' to 'f', 'A' to 'F').\n\n```\n'5'.hex? # => true\n'a'.hex? # => true\n'F'.hex? # => true\n'g'.hex? # => false\n```","summary":"<p>Returns <code>true</code> if this char is an ASCII hex digit ('0' to '9', 'a' to 'f', 'A' to 'F').</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"hex?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ascii_number?(16)"}},{"id":"in_set?(*sets:String)-instance-method","html_id":"in_set?(*sets:String)-instance-method","name":"in_set?","doc":"Returns `true` if this char is matched by the given *sets*.\n\nEach parameter defines a set, the character is matched against\nthe intersection of those, in other words it needs to\nmatch all sets.\n\nIf a set starts with a ^, it is negated. The sequence c1-c2\nmeans all characters between and including c1 and c2\nand is known as a range.\n\nThe backslash character \\ can be used to escape ^ or - and\nis otherwise ignored unless it appears at the end of a range\nor set.\n\n```\n'l'.in_set? \"lo\"          # => true\n'l'.in_set? \"lo\", \"o\"     # => false\n'l'.in_set? \"hello\", \"^l\" # => false\n'l'.in_set? \"j-m\"         # => true\n\n'^'.in_set? \"\\\\^aeiou\" # => true\n'-'.in_set? \"a\\\\-eo\"   # => true\n\n'\\\\'.in_set? \"\\\\\"    # => true\n'\\\\'.in_set? \"\\\\A\"   # => false\n'\\\\'.in_set? \"X-\\\\w\" # => true\n```","summary":"<p>Returns <code>true</code> if this char is matched by the given <em>sets</em>.</p>","abstract":false,"args":[{"name":"sets","doc":null,"default_value":"","external_name":"sets","restriction":"String"}],"args_string":"(*sets : String)","source_link":null,"def":{"name":"in_set?","args":[{"name":"sets","doc":null,"default_value":"","external_name":"sets","restriction":"String"}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if sets.size > 1\n  return sets.all? do |set|\n    in_set?(set)\n  end\nend\nset = sets.first\nnot_negated = true\nrange = false\nprevious = nil\nset.each_char do |char|\n  case char\n  when '^'\n    if previous\n    else\n      not_negated = false\n      previous = char\n      next\n    end\n  when '-'\n    if previous && (previous != '\\\\')\n      range = true\n      if previous == '^'\n        previous = '^'\n        not_negated = true\n      end\n      next\n    else\n      if self == char\n        return not_negated\n      end\n    end\n  end\n  if range && previous\n    if previous > char\n      raise(ArgumentError.new(\"Invalid range #{previous}-#{char}\"))\n    end\n    if previous <= self && self <= char\n      return not_negated\n    end\n    range = false\n  else\n    if char != '\\\\'\n      if self == char\n        return not_negated\n      end\n    end\n  end\n  previous = char\nend\nif range && (self == '-')\n  return not_negated\nend\nif (previous == '\\\\') && (self == previous)\n  return not_negated\nend\n!not_negated\n"}},{"id":"inspect:String-instance-method","html_id":"inspect:String-instance-method","name":"inspect","doc":"Returns this char as a string that contains a char literal.\n\n```\n'a'.inspect      # => \"'a'\"\n'\\t'.inspect     # => \"'\\\\t'\"\n'あ'.inspect      # => \"'あ'\"\n'\\u0012'.inspect # => \"'\\\\u{12}'\"\n```","summary":"<p>Returns this char as a string that contains a char literal.</p>","abstract":false,"args":[],"args_string":" : String","source_link":null,"def":{"name":"inspect","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"dump_or_inspect do |io|\n  if ascii_control?\n    io << \"\\\\u{\"\n    ord.to_s(16, io)\n    io << '}'\n  else\n    to_s(io)\n  end\nend"}},{"id":"inspect(io:IO):Nil-instance-method","html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Appends this char as a string that contains a char literal to the given `IO`.\n\nSee also: `#inspect`.","summary":"<p>Appends this char as a string that contains a char literal to the given <code><a href=\"IO.html\">IO</a></code>.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"inspect","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << inspect"}},{"id":"letter?-instance-method","html_id":"letter?-instance-method","name":"letter?","doc":"Returns `true` if this char is a letter.\n\n```\n'c'.letter? # => true\n'á'.letter? # => true\n'8'.letter? # => false\n```","summary":"<p>Returns <code>true</code> if this char is a letter.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"letter?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ascii? ? ascii_letter? : Unicode.letter?(self)"}},{"id":"lowercase?-instance-method","html_id":"lowercase?-instance-method","name":"lowercase?","doc":"Returns `true` if this char is a lowercase letter.\n\n```\n'c'.lowercase? # => true\n'ç'.lowercase? # => true\n'G'.lowercase? # => false\n'.'.lowercase? # => false\n```","summary":"<p>Returns <code>true</code> if this char is a lowercase letter.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"lowercase?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ascii? ? ascii_lowercase? : Unicode.lowercase?(self)"}},{"id":"mark?-instance-method","html_id":"mark?-instance-method","name":"mark?","doc":"Returns `true` if this is char is a mark character according to unicode.","summary":"<p>Returns <code>true</code> if this is char is a mark character according to unicode.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"mark?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Unicode.mark?(self)"}},{"id":"number?-instance-method","html_id":"number?-instance-method","name":"number?","doc":"Returns `true` if this char is a number according to unicode.\n\n```\n'1'.number? # => true\n'a'.number? # => false\n```","summary":"<p>Returns <code>true</code> if this char is a number according to unicode.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"number?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ascii? ? ascii_number? : Unicode.number?(self)"}},{"id":"ord:Int32-instance-method","html_id":"ord:Int32-instance-method","name":"ord","doc":"Returns the codepoint of this char.\n\nThe codepoint is the integer representation.\nThe Universal Coded Character Set (UCS) standard, commonly known as Unicode,\nassigns names and meanings to numbers, these numbers are called codepoints.\n\nFor values below and including 127 this matches the ASCII codes\nand thus its byte representation.\n\n```\n'a'.ord      # => 97\n'\\0'.ord     # => 0\n'\\u007f'.ord # => 127\n'☃'.ord      # => 9731\n```","summary":"<p>Returns the codepoint of this char.</p>","abstract":false,"args":[],"args_string":" : Int32","source_link":null,"def":{"name":"ord","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":"# primitive: cast"}},{"id":"pred-instance-method","html_id":"pred-instance-method","name":"pred","doc":"Returns a Char that is one codepoint smaller than this char's codepoint.\n\n```\n'b'.pred # => 'a'\n'ぃ'.pred # => 'あ'\n```","summary":"<p>Returns a Char that is one codepoint smaller than this char's codepoint.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"pred","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(ord - 1).chr"}},{"id":"succ-instance-method","html_id":"succ-instance-method","name":"succ","doc":"Returns a Char that is one codepoint bigger than this char's codepoint.\n\n```\n'a'.succ # => 'b'\n'あ'.succ # => 'ぃ'\n```\n\nThis method allows creating a `Range` of chars.","summary":"<p>Returns a Char that is one codepoint bigger than this char's codepoint.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"succ","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(ord + 1).chr"}},{"id":"to_f-instance-method","html_id":"to_f-instance-method","name":"to_f","doc":"Returns the integer value of this char as a float if it's an ASCII char denoting a digit,\nraises otherwise.\n\n```\n'1'.to_f # => 1.0\n'8'.to_f # => 8.0\n'c'.to_f # raises ArgumentError\n```","summary":"<p>Returns the integer value of this char as a float if it's an ASCII char denoting a digit, raises otherwise.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64"}},{"id":"to_f32-instance-method","html_id":"to_f32-instance-method","name":"to_f32","doc":"See also: `to_f`.","summary":"<p>See also: <code><a href=\"Char.html#to_f-instance-method\">#to_f</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i.to_f32"}},{"id":"to_f32?-instance-method","html_id":"to_f32?-instance-method","name":"to_f32?","doc":"See also: `to_f?`.","summary":"<p>See also: <code><a href=\"Char.html#to_f?-instance-method\">#to_f?</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f32?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i?.try(&.to_f32)"}},{"id":"to_f64-instance-method","html_id":"to_f64-instance-method","name":"to_f64","doc":"Same as `to_f`.","summary":"<p>Same as <code><a href=\"Char.html#to_f-instance-method\">#to_f</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i.to_f64"}},{"id":"to_f64?-instance-method","html_id":"to_f64?-instance-method","name":"to_f64?","doc":"Same as `to_f?`.","summary":"<p>Same as <code><a href=\"Char.html#to_f?-instance-method\">#to_f?</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f64?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i?.try(&.to_f64)"}},{"id":"to_f?-instance-method","html_id":"to_f?-instance-method","name":"to_f?","doc":"Returns the integer value of this char as a float if it's an ASCII char denoting a digit,\n`nil` otherwise.\n\n```\n'1'.to_f? # => 1.0\n'8'.to_f? # => 8.0\n'c'.to_f? # => nil\n```","summary":"<p>Returns the integer value of this char as a float if it's an ASCII char denoting a digit, <code>nil</code> otherwise.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64?"}},{"id":"to_i(base:Int=10):Int32-instance-method","html_id":"to_i(base:Int=10):Int32-instance-method","name":"to_i","doc":"Returns the integer value of this char if it's an ASCII char denoting a digit\nin *base*, raises otherwise.\n\n```\n'1'.to_i     # => 1\n'8'.to_i     # => 8\n'c'.to_i     # raises ArgumentError\n'1'.to_i(16) # => 1\n'a'.to_i(16) # => 10\n'f'.to_i(16) # => 15\n'z'.to_i(16) # raises ArgumentError\n```","summary":"<p>Returns the integer value of this char if it's an ASCII char denoting a digit in <em>base</em>, raises otherwise.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>) : Int32","source_link":null,"def":{"name":"to_i","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":"(to_i?(base)) || (raise(ArgumentError.new(\"Invalid integer: #{self}\")))"}},{"id":"to_i16(base:Int=10)-instance-method","html_id":"to_i16(base:Int=10)-instance-method","name":"to_i16","doc":"See also: `to_i`.","summary":"<p>See also: <code><a href=\"Char.html#to_i(base:Int=10):Int32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","source_link":null,"def":{"name":"to_i16","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i(base)).to_i16"}},{"id":"to_i16?(base:Int=10)-instance-method","html_id":"to_i16?(base:Int=10)-instance-method","name":"to_i16?","doc":"See also: `to_i?`.","summary":"<p>See also: <code><a href=\"Char.html#to_i?(base:Int=10):Int32?-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","source_link":null,"def":{"name":"to_i16?","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i?(base)).try(&.to_i16)"}},{"id":"to_i32(base:Int=10):Int32-instance-method","html_id":"to_i32(base:Int=10):Int32-instance-method","name":"to_i32","doc":"Same as `to_i`.","summary":"<p>Same as <code><a href=\"Char.html#to_i(base:Int=10):Int32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>) : Int32","source_link":null,"def":{"name":"to_i32","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":"to_i(base)"}},{"id":"to_i32?(base:Int=10):Int32?-instance-method","html_id":"to_i32?(base:Int=10):Int32?-instance-method","name":"to_i32?","doc":"Same as `to_i?`.","summary":"<p>Same as <code><a href=\"Char.html#to_i?(base:Int=10):Int32?-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>) : Int32?","source_link":null,"def":{"name":"to_i32?","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32 | ::Nil","visibility":"Public","body":"to_i?(base)"}},{"id":"to_i64(base:Int=10)-instance-method","html_id":"to_i64(base:Int=10)-instance-method","name":"to_i64","doc":"See also: `to_i`.","summary":"<p>See also: <code><a href=\"Char.html#to_i(base:Int=10):Int32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","source_link":null,"def":{"name":"to_i64","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i(base)).to_i64"}},{"id":"to_i64?(base:Int=10)-instance-method","html_id":"to_i64?(base:Int=10)-instance-method","name":"to_i64?","doc":"See also: `to_i?`.","summary":"<p>See also: <code><a href=\"Char.html#to_i?(base:Int=10):Int32?-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","source_link":null,"def":{"name":"to_i64?","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i?(base)).try(&.to_i64)"}},{"id":"to_i8(base:Int=10)-instance-method","html_id":"to_i8(base:Int=10)-instance-method","name":"to_i8","doc":"See also: `to_i`.","summary":"<p>See also: <code><a href=\"Char.html#to_i(base:Int=10):Int32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","source_link":null,"def":{"name":"to_i8","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i(base)).to_i8"}},{"id":"to_i8?(base:Int=10)-instance-method","html_id":"to_i8?(base:Int=10)-instance-method","name":"to_i8?","doc":"See also: `to_i?`.","summary":"<p>See also: <code><a href=\"Char.html#to_i?(base:Int=10):Int32?-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","source_link":null,"def":{"name":"to_i8?","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i?(base)).try(&.to_i8)"}},{"id":"to_i?(base:Int=10):Int32?-instance-method","html_id":"to_i?(base:Int=10):Int32?-instance-method","name":"to_i?","doc":"Returns the integer value of this char if it's an ASCII char denoting a digit\nin *base*, `nil` otherwise.\n\n```\n'1'.to_i?     # => 1\n'8'.to_i?     # => 8\n'c'.to_i?     # => nil\n'1'.to_i?(16) # => 1\n'a'.to_i?(16) # => 10\n'f'.to_i?(16) # => 15\n'z'.to_i?(16) # => nil\n```","summary":"<p>Returns the integer value of this char if it's an ASCII char denoting a digit in <em>base</em>, <code>nil</code> otherwise.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>) : Int32?","source_link":null,"def":{"name":"to_i?","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32 | ::Nil","visibility":"Public","body":"if 2 <= base && base <= 36\nelse\n  raise(ArgumentError.new(\"Invalid base #{base}, expected 2 to 36\"))\nend\nif base == 10\n  if '0' <= self && self <= '9'\n  else\n    return\n  end\n  self - '0'\nelse\n  ord = ord()\n  if 0 <= ord && ord < 256\n    digit = String::CHAR_TO_DIGIT.to_unsafe[ord]\n    if (digit == -1) || digit >= base\n      return\n    end\n    digit.to_i32\n  end\nend\n"}},{"id":"to_s:String-instance-method","html_id":"to_s:String-instance-method","name":"to_s","doc":"Returns this char as a string containing this char as a single character.\n\n```\n'a'.to_s # => \"a\"\n'あ'.to_s # => \"あ\"\n```","summary":"<p>Returns this char as a string containing this char as a single character.</p>","abstract":false,"args":[],"args_string":" : String","source_link":null,"def":{"name":"to_s","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"String.new(4) do |buffer|\n  appender = buffer.appender\n  each_byte do |byte|\n    appender << byte\n  end\n  {appender.size, 1}\nend"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Appends this char to the given `IO`.\n\nThis appends this char's bytes as encoded by UTF-8 to the given `IO`.","summary":"<p>Appends this char to the given <code><a href=\"IO.html\">IO</a></code>.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"if ascii?\n  byte = ord.to_u8\n  if io.has_non_utf8_encoding?\n    io.write_utf8(Slice.new(pointerof(byte), 1))\n  else\n    io.write_byte(byte)\n  end\nelse\n  chars = uninitialized ::StaticArray(UInt8, 4)\n  i = 0\n  each_byte do |byte|\n    chars[i] = byte\n    i = i + 1\n  end\n  io.write_utf8(chars.to_slice[0, i])\nend"}},{"id":"to_u16(base:Int=10)-instance-method","html_id":"to_u16(base:Int=10)-instance-method","name":"to_u16","doc":"See also: `to_i`.","summary":"<p>See also: <code><a href=\"Char.html#to_i(base:Int=10):Int32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","source_link":null,"def":{"name":"to_u16","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i(base)).to_u16"}},{"id":"to_u16?(base:Int=10)-instance-method","html_id":"to_u16?(base:Int=10)-instance-method","name":"to_u16?","doc":"See also: `to_i?`.","summary":"<p>See also: <code><a href=\"Char.html#to_i?(base:Int=10):Int32?-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","source_link":null,"def":{"name":"to_u16?","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i?(base)).try(&.to_u16)"}},{"id":"to_u32(base:Int=10)-instance-method","html_id":"to_u32(base:Int=10)-instance-method","name":"to_u32","doc":"See also: `to_i`.","summary":"<p>See also: <code><a href=\"Char.html#to_i(base:Int=10):Int32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","source_link":null,"def":{"name":"to_u32","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i(base)).to_u32"}},{"id":"to_u32?(base:Int=10)-instance-method","html_id":"to_u32?(base:Int=10)-instance-method","name":"to_u32?","doc":"See also: `to_i?`.","summary":"<p>See also: <code><a href=\"Char.html#to_i?(base:Int=10):Int32?-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","source_link":null,"def":{"name":"to_u32?","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i?(base)).try(&.to_u32)"}},{"id":"to_u64(base:Int=10)-instance-method","html_id":"to_u64(base:Int=10)-instance-method","name":"to_u64","doc":"See also: `to_i`.","summary":"<p>See also: <code><a href=\"Char.html#to_i(base:Int=10):Int32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","source_link":null,"def":{"name":"to_u64","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i(base)).to_u64"}},{"id":"to_u64?(base:Int=10)-instance-method","html_id":"to_u64?(base:Int=10)-instance-method","name":"to_u64?","doc":"See also: `to_i?`.","summary":"<p>See also: <code><a href=\"Char.html#to_i?(base:Int=10):Int32?-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","source_link":null,"def":{"name":"to_u64?","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i?(base)).try(&.to_u64)"}},{"id":"to_u8(base:Int=10)-instance-method","html_id":"to_u8(base:Int=10)-instance-method","name":"to_u8","doc":"See also: `to_i`.","summary":"<p>See also: <code><a href=\"Char.html#to_i(base:Int=10):Int32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","source_link":null,"def":{"name":"to_u8","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i(base)).to_u8"}},{"id":"to_u8?(base:Int=10)-instance-method","html_id":"to_u8?(base:Int=10)-instance-method","name":"to_u8?","doc":"See also: `to_i?`.","summary":"<p>See also: <code><a href=\"Char.html#to_i?(base:Int=10):Int32?-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","source_link":null,"def":{"name":"to_u8?","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i?(base)).try(&.to_u8)"}},{"id":"upcase(options=Unicode::CaseOptions::None,&block)-instance-method","html_id":"upcase(options=Unicode::CaseOptions::None,&amp;block)-instance-method","name":"upcase","doc":"Yields each char for the upcase equivalent of this char.\n\nThis method takes into account the possibility that an upcase\nversion of a char might result in multiple chars, like for\n'ﬄ', which results in 'F', 'F' and 'L'.\n\n```\n'z'.upcase { |v| puts v } # prints 'Z'\n'ﬄ'.upcase { |v| puts v } # prints 'F', 'F', 'L'\n```","summary":"<p>Yields each char for the upcase equivalent of this char.</p>","abstract":false,"args":[{"name":"options","doc":null,"default_value":"Unicode::CaseOptions::None","external_name":"options","restriction":""}],"args_string":"(options = <span class=\"t\">Unicode</span><span class=\"t\">::</span><span class=\"t\">CaseOptions</span><span class=\"t\">::</span><span class=\"t\">None</span>, &block)","source_link":null,"def":{"name":"upcase","args":[{"name":"options","doc":null,"default_value":"Unicode::CaseOptions::None","external_name":"options","restriction":""}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"Unicode.upcase(self, options) do |char|\n  yield char\nend"}},{"id":"upcase(options=Unicode::CaseOptions::None)-instance-method","html_id":"upcase(options=Unicode::CaseOptions::None)-instance-method","name":"upcase","doc":"Returns the upcase equivalent of this char.\n\nNote that this only works for characters whose upcase\nequivalent yields a single codepoint. There are a few\ncharacters, like 'ﬄ', than when upcased result in multiple\ncharacters (in this case: 'F', 'F', 'L').\n\nFor a more correct method see the method that receives a block.\n\n```\n'z'.upcase # => 'Z'\n'X'.upcase # => 'X'\n'.'.upcase # => '.'\n```","summary":"<p>Returns the upcase equivalent of this char.</p>","abstract":false,"args":[{"name":"options","doc":null,"default_value":"Unicode::CaseOptions::None","external_name":"options","restriction":""}],"args_string":"(options = <span class=\"t\">Unicode</span><span class=\"t\">::</span><span class=\"t\">CaseOptions</span><span class=\"t\">::</span><span class=\"t\">None</span>)","source_link":null,"def":{"name":"upcase","args":[{"name":"options","doc":null,"default_value":"Unicode::CaseOptions::None","external_name":"options","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Unicode.upcase(self, options)"}},{"id":"uppercase?-instance-method","html_id":"uppercase?-instance-method","name":"uppercase?","doc":"Returns `true` if this char is an uppercase letter.\n\n```\n'H'.uppercase? # => true\n'Á'.uppercase? # => true\n'c'.uppercase? # => false\n'.'.uppercase? # => false\n```","summary":"<p>Returns <code>true</code> if this char is an uppercase letter.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"uppercase?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ascii? ? ascii_uppercase? : Unicode.uppercase?(self)"}},{"id":"whitespace?-instance-method","html_id":"whitespace?-instance-method","name":"whitespace?","doc":"Returns `true` if this char is a whitespace according to unicode.\n\n```\n' '.whitespace?  # => true\n'\\t'.whitespace? # => true\n'b'.whitespace?  # => false\n```","summary":"<p>Returns <code>true</code> if this char is a whitespace according to unicode.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"whitespace?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ascii? ? ascii_whitespace? : Unicode.whitespace?(self)"}}],"macros":[],"types":[{"html_id":"/Char/Reader","path":"Char/Reader.html","kind":"struct","full_name":"Char::Reader","name":"Reader","abstract":false,"superclass":{"html_id":"/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"/Enumerable","kind":"module","full_name":"Enumerable","name":"Enumerable"},{"html_id":"/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[{"html_id":"/Enumerable","kind":"module","full_name":"Enumerable","name":"Enumerable"}],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Char","kind":"struct","full_name":"Char","name":"Char"},"doc":"A `Char::Reader` allows iterating a `String` by Chars.\n\nAs soon as you instantiate a `Char::Reader` it will decode the first\nchar in the `String`, which can be accessed by invoking `current_char`.\nAt this point `pos`, the current position in the string, will equal zero.\nSuccessive calls to `next_char` return the next chars in the string,\nadvancing `pos`.\n\nNote that the null character `'\\0'` will be returned in `current_char` when\nthe end is reached (as well as when the string is empty). Thus, `has_next?`\nwill return `false` only when `pos` is equal to the string's bytesize, in which\ncase `current_char` will always be `'\\0'`.","summary":"<p>A <code><a href=\"../Char/Reader.html\">Char::Reader</a></code> allows iterating a <code><a href=\"../String.html\">String</a></code> by Chars.</p>","class_methods":[],"constructors":[{"id":"new(string:String,pos=0)-class-method","html_id":"new(string:String,pos=0)-class-method","name":"new","doc":"Creates a reader with the specified *string* positioned at\nbyte index *pos*.","summary":"<p>Creates a reader with the specified <em>string</em> positioned at byte index <em>pos</em>.</p>","abstract":false,"args":[{"name":"string","doc":null,"default_value":"","external_name":"string","restriction":"String"},{"name":"pos","doc":null,"default_value":"0","external_name":"pos","restriction":""}],"args_string":"(string : String, pos = <span class=\"n\">0</span>)","source_link":null,"def":{"name":"new","args":[{"name":"string","doc":null,"default_value":"","external_name":"string","restriction":"String"},{"name":"pos","doc":null,"default_value":"0","external_name":"pos","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(string, pos)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(*,at_endstring:String)-class-method","html_id":"new(*,at_endstring:String)-class-method","name":"new","doc":"Creates a reader that will be positioned at the last char\nof the given string.","summary":"<p>Creates a reader that will be positioned at the last char of the given string.</p>","abstract":false,"args":[{"name":"","doc":null,"default_value":"","external_name":"","restriction":""},{"name":"string","doc":null,"default_value":"","external_name":"at_end","restriction":"String"}],"args_string":"(*, at_end string : String)","source_link":null,"def":{"name":"new","args":[{"name":"","doc":null,"default_value":"","external_name":"","restriction":""},{"name":"string","doc":null,"default_value":"","external_name":"at_end","restriction":"String"}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(at_end: string)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"current_char:Char-instance-method","html_id":"current_char:Char-instance-method","name":"current_char","doc":"Returns the current character.\n\n```\nreader = Char::Reader.new(\"ab\")\nreader.current_char # => 'a'\nreader.next_char\nreader.current_char # => 'b'\n```","summary":"<p>Returns the current character.</p>","abstract":false,"args":[],"args_string":" : Char","source_link":null,"def":{"name":"current_char","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Char","visibility":"Public","body":"@current_char"}},{"id":"current_char_width:Int32-instance-method","html_id":"current_char_width:Int32-instance-method","name":"current_char_width","doc":"Returns the size of the `#current_char` (in bytes) as if it were encoded in UTF-8.\n\n```\nreader = Char::Reader.new(\"aé\")\nreader.current_char_width # => 1\nreader.next_char\nreader.current_char_width # => 2\n```","summary":"<p>Returns the size of the <code><a href=\"../Char/Reader.html#current_char:Char-instance-method\">#current_char</a></code> (in bytes) as if it were encoded in UTF-8.</p>","abstract":false,"args":[],"args_string":" : Int32","source_link":null,"def":{"name":"current_char_width","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":"@current_char_width"}},{"id":"each(&block):Nil-instance-method","html_id":"each(&amp;block):Nil-instance-method","name":"each","doc":"Yields successive characters from `#string` starting from `#pos`.\n\n```\nreader = Char::Reader.new(\"abc\")\nreader.next_char\nreader.each do |c|\n  puts c.upcase\nend\n```\n\n``` text\nB\nC\n```","summary":"<p>Yields successive characters from <code><a href=\"../Char/Reader.html#string:String-instance-method\">#string</a></code> starting from <code><a href=\"../Char/Reader.html#pos:Int32-instance-method\">#pos</a></code>.</p>","abstract":false,"args":[],"args_string":"(&block) : Nil","source_link":null,"def":{"name":"each","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"while has_next?\n  yield current_char\n  @pos = @pos + @current_char_width\n  decode_current_char\nend"}},{"id":"error:UInt8?-instance-method","html_id":"error:UInt8?-instance-method","name":"error","doc":"If there was an error decoding the current char because\nof an invalid UTF-8 byte sequence, returns the byte\nthat produced the invalid encoding. Returns `0` if the char would've been\nout of bounds. Otherwise returns `nil`.","summary":"<p>If there was an error decoding the current char because of an invalid UTF-8 byte sequence, returns the byte that produced the invalid encoding.</p>","abstract":false,"args":[],"args_string":" : UInt8?","source_link":null,"def":{"name":"error","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"UInt8 | ::Nil","visibility":"Public","body":"@error"}},{"id":"has_next?-instance-method","html_id":"has_next?-instance-method","name":"has_next?","doc":"Returns `true` if there is a character left to read.\nThe terminating byte `'\\0'` is considered a valid character\nby this method.\n\n```\nreader = Char::Reader.new(\"a\")\nreader.has_next?      # => true\nreader.peek_next_char # => '\\0'\n```","summary":"<p>Returns <code>true</code> if there is a character left to read.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"has_next?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"!@end"}},{"id":"has_previous?-instance-method","html_id":"has_previous?-instance-method","name":"has_previous?","doc":"Returns `true` if there are characters before\nthe current one.","summary":"<p>Returns <code>true</code> if there are characters before the current one.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"has_previous?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@pos > 0"}},{"id":"next_char-instance-method","html_id":"next_char-instance-method","name":"next_char","doc":"Reads the next character in the string,\n`#pos` is incremented. Raises `IndexError` if the reader is\nat the end of the `#string`.\n\n```\nreader = Char::Reader.new(\"ab\")\nreader.next_char # => 'b'\n```","summary":"<p>Reads the next character in the string, <code><a href=\"../Char/Reader.html#pos:Int32-instance-method\">#pos</a></code> is incremented.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"next_char","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@pos = @pos + @current_char_width\nif @pos > @string.bytesize\n  raise(IndexError.new)\nend\ndecode_current_char\n"}},{"id":"peek_next_char-instance-method","html_id":"peek_next_char-instance-method","name":"peek_next_char","doc":"Returns the next character in the `#string`\nwithout incrementing `#pos`.\nRaises `IndexError` if the reader is at\nthe end of the `#string`.\n\n```\nreader = Char::Reader.new(\"ab\")\nreader.peek_next_char # => 'b'\nreader.current_char   # => 'a'\n```","summary":"<p>Returns the next character in the <code><a href=\"../Char/Reader.html#string:String-instance-method\">#string</a></code> without incrementing <code><a href=\"../Char/Reader.html#pos:Int32-instance-method\">#pos</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"peek_next_char","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"next_pos = @pos + @current_char_width\nif next_pos > @string.bytesize\n  raise(IndexError.new)\nend\ndecode_char_at(next_pos) do |code_point|\n  code_point.unsafe_chr\nend\n"}},{"id":"pos:Int32-instance-method","html_id":"pos:Int32-instance-method","name":"pos","doc":"Returns the position of the current character.\n\n```\nreader = Char::Reader.new(\"ab\")\nreader.pos # => 0\nreader.next_char\nreader.pos # => 1\n```","summary":"<p>Returns the position of the current character.</p>","abstract":false,"args":[],"args_string":" : Int32","source_link":null,"def":{"name":"pos","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":"@pos"}},{"id":"pos=(pos)-instance-method","html_id":"pos=(pos)-instance-method","name":"pos=","doc":"Sets `#pos` to *pos*.\n\n```\nreader = Char::Reader.new(\"abc\")\nreader.next_char\nreader.next_char\nreader.pos = 0\nreader.current_char # => 'a'\n```","summary":"<p>Sets <code><a href=\"../Char/Reader.html#pos:Int32-instance-method\">#pos</a></code> to <em>pos</em>.</p>","abstract":false,"args":[{"name":"pos","doc":null,"default_value":"","external_name":"pos","restriction":""}],"args_string":"(pos)","source_link":null,"def":{"name":"pos=","args":[{"name":"pos","doc":null,"default_value":"","external_name":"pos","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if pos > @string.bytesize\n  raise(IndexError.new)\nend\n@pos = pos\ndecode_current_char\npos\n"}},{"id":"previous_char:Char-instance-method","html_id":"previous_char:Char-instance-method","name":"previous_char","doc":"Returns the previous character, `#pos`\nis decremented.\nRaises `IndexError` if the reader is at the beginning of\nthe `#string`","summary":"<p>Returns the previous character, <code><a href=\"../Char/Reader.html#pos:Int32-instance-method\">#pos</a></code> is decremented.</p>","abstract":false,"args":[],"args_string":" : Char","source_link":null,"def":{"name":"previous_char","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Char","visibility":"Public","body":"if has_previous?\nelse\n  raise(IndexError.new)\nend\ndecode_previous_char.as(Char)\n"}},{"id":"string:String-instance-method","html_id":"string:String-instance-method","name":"string","doc":"Returns the reader's String.","summary":"<p>Returns the reader's String.</p>","abstract":false,"args":[],"args_string":" : String","source_link":null,"def":{"name":"string","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"@string"}}],"macros":[],"types":[]}]},{"html_id":"/Class","path":"Class.html","kind":"class","full_name":"Class","name":"Class","abstract":true,"superclass":{"html_id":"/Value","kind":"struct","full_name":"Value","name":"Value"},"ancestors":[{"html_id":"/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":null,"summary":null,"class_methods":[{"id":"T.class):BoolforallT-class-method","html_id":"T.class):BoolforallT-class-method","name":"<","doc":"Returns whether this class inherits or includes *other*.\n\n```\nInt32 < Number  # => true\nInt32 < Value   # => true\nInt32 < Int32   # => false\nInt32 <= String # => false\n```","summary":"<p>Returns whether this class inherits or includes <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"args_string":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) : Bool forall T","source_link":null,"def":{"name":"<","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"{% @type %}\nother._gt(self)\n"}},{"id":"T.class):BoolforallT-class-method","html_id":"T.class):BoolforallT-class-method","name":"<=","doc":"Returns whether this class inherits or includes *other*, or\nis equal to *other*.\n\n```\nInt32 < Number  # => true\nInt32 < Value   # => true\nInt32 <= Int32  # => true\nInt32 <= String # => false\n```","summary":"<p>Returns whether this class inherits or includes <em>other</em>, or is equal to <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"args_string":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) : Bool forall T","source_link":null,"def":{"name":"<=","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"{% @type %}\nother._gte(self)\n"}},{"id":"==(other:Class):Bool-class-method","html_id":"==(other:Class):Bool-class-method","name":"==","doc":"Returns whether this class is the same as *other*.\n\n```\nInt32 == Int32  # => true\nInt32 == String # => false\n```","summary":"<p>Returns whether this class is the same as <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Class"}],"args_string":"(other : Class) : Bool","source_link":null,"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"crystal_type_id == other.crystal_type_id"}},{"id":"===(other)-class-method","html_id":"===(other)-class-method","name":"===","doc":"Case equality.\n\nThe `===` method is used in a `case ... when ... end` expression.\n\nFor example, this code:\n\n```\ncase value\nwhen x\n  # something when x\nwhen y\n  # something when y\nend\n```\n\nIs equivalent to this code:\n\n```\nif x === value\n  # something when x\nelsif y === value\n  # something when y\nend\n```\n\nObject simply implements `===` by invoking `==`, but subclasses\n(notably `Regex`) can override it to provide meaningful case-equality semantics.","summary":"<p>Case equality.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"args_string":"(other)","source_link":null,"def":{"name":"===","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"other.is_a?(self)"}},{"id":">(other:T.class)forallT-class-method","html_id":"&gt;(other:T.class)forallT-class-method","name":">","doc":"Returns whether *other* inherits or includes `self`.\n\n```\nNumber > Int32  # => true\nNumber > Number # => false\nNumber > Object # => false\n```","summary":"<p>Returns whether <em>other</em> inherits or includes <code>self</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"args_string":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) forall T","source_link":null,"def":{"name":">","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% @type %}\nother._lt(self)\n"}},{"id":">=(other:T.class)forallT-class-method","html_id":"&gt;=(other:T.class)forallT-class-method","name":">=","doc":"Returns whether *other* inherits or includes `self`, or is equal\nto `self`.\n\n```\nNumber >= Int32  # => true\nNumber >= Number # => true\nNumber >= Object # => false\n```","summary":"<p>Returns whether <em>other</em> inherits or includes <code>self</code>, or is equal to <code>self</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"args_string":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) forall T","source_link":null,"def":{"name":">=","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% @type %}\nother._lte(self)\n"}},{"id":"clone-class-method","html_id":"clone-class-method","name":"clone","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"dup-class-method","html_id":"dup-class-method","name":"dup","doc":"Returns a shallow copy of this object.\n\nBecause `Value` is a value type, this method returns `self`,\nwhich already involves a shallow copy of this object because\nvalue types are passed by value.","summary":"<p>Returns a shallow copy of this object.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"dup","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"hash(hasher)-class-method","html_id":"hash(hasher)-class-method","name":"hash","doc":"See `Object#hash(hasher)`","summary":"<p>See <code><a href=\"Object.html#hash(hasher)-instance-method\">Object#hash(hasher)</a></code></p>","abstract":false,"args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"args_string":"(hasher)","source_link":null,"def":{"name":"hash","args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"hasher.class(self)"}},{"id":"inspect(io:IO):Nil-class-method","html_id":"inspect(io:IO):Nil-class-method","name":"inspect","doc":"Appends a string representation of this object\nto the given `IO` object.\n\nSimilar to `to_s(io)`, but usually appends more information\nabout this object.\nSee `#inspect`.","summary":"<p>Appends a string representation of this object to the given <code><a href=\"IO.html\">IO</a></code> object.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"inspect","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"to_s(io)"}},{"id":"name:String-class-method","html_id":"name:String-class-method","name":"name","doc":"Returns the name of this class.\n\n```\nString.name # => \"String\"\n```","summary":"<p>Returns the name of this class.</p>","abstract":false,"args":[],"args_string":" : String","source_link":null,"def":{"name":"name","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"{{ @type.name.stringify }}"}},{"id":"nilable?-class-method","html_id":"nilable?-class-method","name":"nilable?","doc":"Returns `true` if this class is `Nil`.\n\n```\nInt32.nilable? # => false\nNil.nilable?   # => true\n```","summary":"<p>Returns <code>true</code> if this class is <code><a href=\"Nil.html\">Nil</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"nilable?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == ::Nil"}},{"id":"to_s(io:IO):Nil-class-method","html_id":"to_s(io:IO):Nil-class-method","name":"to_s","doc":"Appends a `String` representation of this object\nto the given `IO` object.\n\nAn object must never append itself to the io argument,\nas this will in turn call `to_s(io)` on it.","summary":"<p>Appends a <code><a href=\"String.html\">String</a></code> representation of this object to the given <code><a href=\"IO.html\">IO</a></code> object.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << ({{ @type.name.stringify }})"}},{"id":"|(other:U.class)forallU-class-method","html_id":"|(other:U.class)forallU-class-method","name":"|","doc":"Returns the union type of `self` and *other*.\n\n```\nInt32 | Char # => (Int32 | Char)\n```","summary":"<p>Returns the union type of <code>self</code> and <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"U.class"}],"args_string":"(other : <span class=\"t\">U</span>.<span class=\"k\">class</span>) forall U","source_link":null,"def":{"name":"|","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"U.class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"t = uninitialized self\nu = uninitialized U\ntypeof(t, u)\n"}}],"constructors":[{"id":"cast(other):self-class-method","html_id":"cast(other):self-class-method","name":"cast","doc":"Casts *other* to this class.\n\nThis is the same as using `as`, but allows the class to be passed around as\nan argument. See the\n[documentation on as](//crystal-lang.org/docs/syntax_and_semantics/as.html)\nfor more information.\n\n```\nklass = Int32\nnumber = [99, \"str\"][0]\ntypeof(number)             # => (String | Int32)\ntypeof(klass.cast(number)) # => Int32\n```","summary":"<p>Casts <em>other</em> to this class.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"args_string":"(other) : <span class=\"k\">self</span>","source_link":null,"def":{"name":"cast","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"self","visibility":"Public","body":"other.as(self)"}}],"instance_methods":[{"id":"T.class):BoolforallT-instance-method","html_id":"T.class):BoolforallT-instance-method","name":"<","doc":"Returns whether this class inherits or includes *other*.\n\n```\nInt32 < Number  # => true\nInt32 < Value   # => true\nInt32 < Int32   # => false\nInt32 <= String # => false\n```","summary":"<p>Returns whether this class inherits or includes <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"args_string":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) : Bool forall T","source_link":null,"def":{"name":"<","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"{% @type %}\nother._gt(self)\n"}},{"id":"T.class):BoolforallT-instance-method","html_id":"T.class):BoolforallT-instance-method","name":"<=","doc":"Returns whether this class inherits or includes *other*, or\nis equal to *other*.\n\n```\nInt32 < Number  # => true\nInt32 < Value   # => true\nInt32 <= Int32  # => true\nInt32 <= String # => false\n```","summary":"<p>Returns whether this class inherits or includes <em>other</em>, or is equal to <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"args_string":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) : Bool forall T","source_link":null,"def":{"name":"<=","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"{% @type %}\nother._gte(self)\n"}},{"id":"==(other:Class):Bool-instance-method","html_id":"==(other:Class):Bool-instance-method","name":"==","doc":"Returns whether this class is the same as *other*.\n\n```\nInt32 == Int32  # => true\nInt32 == String # => false\n```","summary":"<p>Returns whether this class is the same as <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Class"}],"args_string":"(other : Class) : Bool","source_link":null,"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"crystal_type_id == other.crystal_type_id"}},{"id":"===(other)-instance-method","html_id":"===(other)-instance-method","name":"===","doc":"Case equality.\n\nThe `===` method is used in a `case ... when ... end` expression.\n\nFor example, this code:\n\n```\ncase value\nwhen x\n  # something when x\nwhen y\n  # something when y\nend\n```\n\nIs equivalent to this code:\n\n```\nif x === value\n  # something when x\nelsif y === value\n  # something when y\nend\n```\n\nObject simply implements `===` by invoking `==`, but subclasses\n(notably `Regex`) can override it to provide meaningful case-equality semantics.","summary":"<p>Case equality.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"args_string":"(other)","source_link":null,"def":{"name":"===","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"other.is_a?(self)"}},{"id":">(other:T.class)forallT-instance-method","html_id":"&gt;(other:T.class)forallT-instance-method","name":">","doc":"Returns whether *other* inherits or includes `self`.\n\n```\nNumber > Int32  # => true\nNumber > Number # => false\nNumber > Object # => false\n```","summary":"<p>Returns whether <em>other</em> inherits or includes <code>self</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"args_string":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) forall T","source_link":null,"def":{"name":">","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% @type %}\nother._lt(self)\n"}},{"id":">=(other:T.class)forallT-instance-method","html_id":"&gt;=(other:T.class)forallT-instance-method","name":">=","doc":"Returns whether *other* inherits or includes `self`, or is equal\nto `self`.\n\n```\nNumber >= Int32  # => true\nNumber >= Number # => true\nNumber >= Object # => false\n```","summary":"<p>Returns whether <em>other</em> inherits or includes <code>self</code>, or is equal to <code>self</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"args_string":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) forall T","source_link":null,"def":{"name":">=","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% @type %}\nother._lte(self)\n"}},{"id":"cast(other):self-instance-method","html_id":"cast(other):self-instance-method","name":"cast","doc":"Casts *other* to this class.\n\nThis is the same as using `as`, but allows the class to be passed around as\nan argument. See the\n[documentation on as](//crystal-lang.org/docs/syntax_and_semantics/as.html)\nfor more information.\n\n```\nklass = Int32\nnumber = [99, \"str\"][0]\ntypeof(number)             # => (String | Int32)\ntypeof(klass.cast(number)) # => Int32\n```","summary":"<p>Casts <em>other</em> to this class.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"args_string":"(other) : <span class=\"k\">self</span>","source_link":null,"def":{"name":"cast","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"self","visibility":"Public","body":"other.as(self)"}},{"id":"clone-instance-method","html_id":"clone-instance-method","name":"clone","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"dup-instance-method","html_id":"dup-instance-method","name":"dup","doc":"Returns a shallow copy of this object.\n\nBecause `Value` is a value type, this method returns `self`,\nwhich already involves a shallow copy of this object because\nvalue types are passed by value.","summary":"<p>Returns a shallow copy of this object.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"dup","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"hash(hasher)-instance-method","html_id":"hash(hasher)-instance-method","name":"hash","doc":"See `Object#hash(hasher)`","summary":"<p>See <code><a href=\"Object.html#hash(hasher)-instance-method\">Object#hash(hasher)</a></code></p>","abstract":false,"args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"args_string":"(hasher)","source_link":null,"def":{"name":"hash","args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"hasher.class(self)"}},{"id":"inspect(io:IO):Nil-instance-method","html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Appends a string representation of this object\nto the given `IO` object.\n\nSimilar to `to_s(io)`, but usually appends more information\nabout this object.\nSee `#inspect`.","summary":"<p>Appends a string representation of this object to the given <code><a href=\"IO.html\">IO</a></code> object.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"inspect","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"to_s(io)"}},{"id":"name:String-instance-method","html_id":"name:String-instance-method","name":"name","doc":"Returns the name of this class.\n\n```\nString.name # => \"String\"\n```","summary":"<p>Returns the name of this class.</p>","abstract":false,"args":[],"args_string":" : String","source_link":null,"def":{"name":"name","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"{{ @type.name.stringify }}"}},{"id":"nilable?-instance-method","html_id":"nilable?-instance-method","name":"nilable?","doc":"Returns `true` if this class is `Nil`.\n\n```\nInt32.nilable? # => false\nNil.nilable?   # => true\n```","summary":"<p>Returns <code>true</code> if this class is <code><a href=\"Nil.html\">Nil</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"nilable?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == ::Nil"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Appends a `String` representation of this object\nto the given `IO` object.\n\nAn object must never append itself to the io argument,\nas this will in turn call `to_s(io)` on it.","summary":"<p>Appends a <code><a href=\"String.html\">String</a></code> representation of this object to the given <code><a href=\"IO.html\">IO</a></code> object.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << ({{ @type.name.stringify }})"}},{"id":"|(other:U.class)forallU-instance-method","html_id":"|(other:U.class)forallU-instance-method","name":"|","doc":"Returns the union type of `self` and *other*.\n\n```\nInt32 | Char # => (Int32 | Char)\n```","summary":"<p>Returns the union type of <code>self</code> and <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"U.class"}],"args_string":"(other : <span class=\"t\">U</span>.<span class=\"k\">class</span>) forall U","source_link":null,"def":{"name":"|","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"U.class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"t = uninitialized self\nu = uninitialized U\ntypeof(t, u)\n"}}],"macros":[],"types":[]},{"html_id":"/Colorize","path":"Colorize.html","kind":"module","full_name":"Colorize","name":"Colorize","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"With Colorize you can change the fore- and background colors and text decorations when rendering text\non terminals supporting ANSI escape codes. It adds the `colorize` method to `Object` and thus all classes\nas its main interface, which calls `to_s` and surrounds it with the necessary escape codes\nwhen it comes to obtaining a string representation of the object.\n\nIts first argument changes the foreground color:\n```\nrequire \"colorize\"\n\n\"foo\".colorize(:green)\n100.colorize(:red)\n[1, 2, 3].colorize(:blue)\n```\n\nThere are alternative ways to change the foreground color:\n```\nrequire \"colorize\"\n\n\"foo\".colorize.fore(:green)\n\"foo\".colorize.green\n```\n\nTo change the background color, the following methods are available:\n```\nrequire \"colorize\"\n\n\"foo\".colorize.back(:green)\n\"foo\".colorize.on(:green)\n\"foo\".colorize.on_green\n```\n\nYou can also pass an RGB color to `colorize`:\n```\nrequire \"colorize\"\n\n\"foo\".colorize(Colorize::ColorRGB.new(0, 255, 255)) # => \"foo\" in aqua\n```\n\nOr an 8-bit color:\n```\nrequire \"colorize\"\n\n\"foo\".colorize(Colorize::Color256.new(208)) # => \"foo\" in orange\n```\n\nIt's also possible to change the text decoration:\n```\nrequire \"colorize\"\n\n\"foo\".colorize.mode(:underline)\n\"foo\".colorize.underline\n```\n\nThe `colorize` method returns a `Colorize::Object` instance,\nwhich allows chaining methods together:\n```\nrequire \"colorize\"\n\n\"foo\".colorize.fore(:yellow).back(:blue).mode(:underline)\n```\n\nWith the `toggle` method you can temporarily disable adding the escape codes.\nSettings of the instance are preserved however and can be turned back on later:\n```\nrequire \"colorize\"\n\n\"foo\".colorize(:red).toggle(false)              # => \"foo\" without color\n\"foo\".colorize(:red).toggle(false).toggle(true) # => \"foo\" in red\n```\n\nThe color `:default` will just leave the object as it is (but it's an `Colorize::Object(String)` then).\nThat's handy in for example conditions:\n```\nrequire \"colorize\"\n\n\"foo\".colorize(some_bool ? :green : :default)\n```\n\nAvailable colors are:\n```\n:default\n:black\n:red\n:green\n:yellow\n:blue\n:magenta\n:cyan\n:light_gray\n:dark_gray\n:light_red\n:light_green\n:light_yellow\n:light_blue\n:light_magenta\n:light_cyan\n:white\n```\n\nAvailable text decorations are:\n```\n:bold\n:bright\n:dim\n:underline\n:blink\n:reverse\n:hidden\n```","summary":"<p>With Colorize you can change the fore- and background colors and text decorations when rendering text on terminals supporting ANSI escape codes.</p>","class_methods":[{"id":"enabled=(enabled:Bool)-class-method","html_id":"enabled=(enabled:Bool)-class-method","name":"enabled=","doc":"If this value is `true`, `Colorize::Object` is enabled by default.\nBut if this value is `false`, `Colorize::Object` is disabled.\n\nThe default value is `true`.\n\n```\nrequire \"colorize\"\n\nColorize.enabled = true\n\"hello\".colorize.red.to_s # => \"\\e[31mhello\\e[0m\"\n\nColorize.enabled = false\n\"hello\".colorize.red.to_s # => \"hello\"\n```","summary":"<p>If this value is <code>true</code>, <code><a href=\"Colorize/Object.html\">Colorize::Object</a></code> is enabled by default.</p>","abstract":false,"args":[{"name":"enabled","doc":null,"default_value":"","external_name":"enabled","restriction":"Bool"}],"args_string":"(enabled : Bool)","source_link":null,"def":{"name":"enabled=","args":[{"name":"enabled","doc":null,"default_value":"","external_name":"enabled","restriction":"Bool"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@@enabled = enabled"}},{"id":"enabled?:Bool-class-method","html_id":"enabled?:Bool-class-method","name":"enabled?","doc":"If this value is `true`, `Colorize::Object` is enabled by default.\nBut if this value is `false`, `Colorize::Object` is disabled.\n\nThe default value is `true`.\n\n```\nrequire \"colorize\"\n\nColorize.enabled = true\n\"hello\".colorize.red.to_s # => \"\\e[31mhello\\e[0m\"\n\nColorize.enabled = false\n\"hello\".colorize.red.to_s # => \"hello\"\n```","summary":"<p>If this value is <code>true</code>, <code><a href=\"Colorize/Object.html\">Colorize::Object</a></code> is enabled by default.</p>","abstract":false,"args":[],"args_string":" : Bool","source_link":null,"def":{"name":"enabled?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"@@enabled"}},{"id":"on_tty_only!-class-method","html_id":"on_tty_only!-class-method","name":"on_tty_only!","doc":"Makes `Colorize.enabled` `true` if and only if both of `STDOUT.tty?` and `STDERR.tty?` are `true`.","summary":"<p>Makes <code>Colorize.enabled</code> <code>true</code> if and only if both of <code>STDOUT.tty?</code> and <code>STDERR.tty?</code> are <code>true</code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"on_tty_only!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self.enabled = STDOUT.tty? && STDERR.tty?"}},{"id":"reset(io=STDOUT)-class-method","html_id":"reset(io=STDOUT)-class-method","name":"reset","doc":null,"summary":null,"abstract":false,"args":[{"name":"io","doc":null,"default_value":"STDOUT","external_name":"io","restriction":""}],"args_string":"(io = <span class=\"t\">STDOUT</span>)","source_link":null,"def":{"name":"reset","args":[{"name":"io","doc":null,"default_value":"STDOUT","external_name":"io","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if enabled?\n  io << \"\\e[0m\"\nend"}}],"constructors":[],"instance_methods":[],"macros":[],"types":[{"html_id":"/Colorize/Color","path":"Colorize/Color.html","kind":"alias","full_name":"Colorize::Color","name":"Color","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"","program":false,"enum":false,"alias":true,"aliased":"(Colorize::Color256 | Colorize::ColorANSI | Colorize::ColorRGB)","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Colorize","kind":"module","full_name":"Colorize","name":"Colorize"},"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"/Colorize/Color256","path":"Colorize/Color256.html","kind":"struct","full_name":"Colorize::Color256","name":"Color256","abstract":false,"superclass":{"html_id":"/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Colorize","kind":"module","full_name":"Colorize","name":"Colorize"},"doc":null,"summary":null,"class_methods":[],"constructors":[{"id":"new(value:UInt8)-class-method","html_id":"new(value:UInt8)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"UInt8"}],"args_string":"(value : UInt8)","source_link":null,"def":{"name":"new","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"UInt8"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(value)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"back(io:IO):Nil-instance-method","html_id":"back(io:IO):Nil-instance-method","name":"back","doc":null,"summary":null,"abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"back","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << \"48;5;\"\nvalue.to_s(io)\n"}},{"id":"clone-instance-method","html_id":"clone-instance-method","name":"clone","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self.class.new(@value.clone)"}},{"id":"copy_with(value_value=@value)-instance-method","html_id":"copy_with(value_value=@value)-instance-method","name":"copy_with","doc":null,"summary":null,"abstract":false,"args":[{"name":"_value","doc":null,"default_value":"@value","external_name":"value","restriction":""}],"args_string":"(value _value = @value)","source_link":null,"def":{"name":"copy_with","args":[{"name":"_value","doc":null,"default_value":"@value","external_name":"value","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self.class.new(_value)"}},{"id":"fore(io:IO):Nil-instance-method","html_id":"fore(io:IO):Nil-instance-method","name":"fore","doc":null,"summary":null,"abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"fore","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << \"38;5;\"\nvalue.to_s(io)\n"}},{"id":"value:UInt8-instance-method","html_id":"value:UInt8-instance-method","name":"value","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : UInt8","source_link":null,"def":{"name":"value","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"UInt8","visibility":"Public","body":"@value"}}],"macros":[],"types":[]},{"html_id":"/Colorize/ColorANSI","path":"Colorize/ColorANSI.html","kind":"enum","full_name":"Colorize::ColorANSI","name":"ColorANSI","abstract":false,"superclass":null,"ancestors":[{"html_id":"/Enum","kind":"struct","full_name":"Enum","name":"Enum"},{"html_id":"/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":true,"alias":false,"aliased":"","const":false,"constants":[{"id":"Default","name":"Default","value":"39","doc":null,"summary":null},{"id":"Black","name":"Black","value":"30","doc":null,"summary":null},{"id":"Red","name":"Red","value":"31","doc":null,"summary":null},{"id":"Green","name":"Green","value":"32","doc":null,"summary":null},{"id":"Yellow","name":"Yellow","value":"33","doc":null,"summary":null},{"id":"Blue","name":"Blue","value":"34","doc":null,"summary":null},{"id":"Magenta","name":"Magenta","value":"35","doc":null,"summary":null},{"id":"Cyan","name":"Cyan","value":"36","doc":null,"summary":null},{"id":"LightGray","name":"LightGray","value":"37","doc":null,"summary":null},{"id":"DarkGray","name":"DarkGray","value":"90","doc":null,"summary":null},{"id":"LightRed","name":"LightRed","value":"91","doc":null,"summary":null},{"id":"LightGreen","name":"LightGreen","value":"92","doc":null,"summary":null},{"id":"LightYellow","name":"LightYellow","value":"93","doc":null,"summary":null},{"id":"LightBlue","name":"LightBlue","value":"94","doc":null,"summary":null},{"id":"LightMagenta","name":"LightMagenta","value":"95","doc":null,"summary":null},{"id":"LightCyan","name":"LightCyan","value":"96","doc":null,"summary":null},{"id":"White","name":"White","value":"97","doc":null,"summary":null}],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Colorize","kind":"module","full_name":"Colorize","name":"Colorize"},"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[{"id":"back(io:IO):Nil-instance-method","html_id":"back(io:IO):Nil-instance-method","name":"back","doc":null,"summary":null,"abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"back","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"(to_i + 10).to_s(io)"}},{"id":"black?-instance-method","html_id":"black?-instance-method","name":"black?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"black?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == Black"}},{"id":"blue?-instance-method","html_id":"blue?-instance-method","name":"blue?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"blue?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == Blue"}},{"id":"cyan?-instance-method","html_id":"cyan?-instance-method","name":"cyan?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"cyan?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == Cyan"}},{"id":"dark_gray?-instance-method","html_id":"dark_gray?-instance-method","name":"dark_gray?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"dark_gray?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == DarkGray"}},{"id":"default?-instance-method","html_id":"default?-instance-method","name":"default?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"default?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == Default"}},{"id":"fore(io:IO):Nil-instance-method","html_id":"fore(io:IO):Nil-instance-method","name":"fore","doc":null,"summary":null,"abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"fore","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"to_i.to_s(io)"}},{"id":"green?-instance-method","html_id":"green?-instance-method","name":"green?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"green?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == Green"}},{"id":"light_blue?-instance-method","html_id":"light_blue?-instance-method","name":"light_blue?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"light_blue?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == LightBlue"}},{"id":"light_cyan?-instance-method","html_id":"light_cyan?-instance-method","name":"light_cyan?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"light_cyan?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == LightCyan"}},{"id":"light_gray?-instance-method","html_id":"light_gray?-instance-method","name":"light_gray?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"light_gray?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == LightGray"}},{"id":"light_green?-instance-method","html_id":"light_green?-instance-method","name":"light_green?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"light_green?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == LightGreen"}},{"id":"light_magenta?-instance-method","html_id":"light_magenta?-instance-method","name":"light_magenta?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"light_magenta?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == LightMagenta"}},{"id":"light_red?-instance-method","html_id":"light_red?-instance-method","name":"light_red?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"light_red?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == LightRed"}},{"id":"light_yellow?-instance-method","html_id":"light_yellow?-instance-method","name":"light_yellow?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"light_yellow?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == LightYellow"}},{"id":"magenta?-instance-method","html_id":"magenta?-instance-method","name":"magenta?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"magenta?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == Magenta"}},{"id":"red?-instance-method","html_id":"red?-instance-method","name":"red?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"red?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == Red"}},{"id":"white?-instance-method","html_id":"white?-instance-method","name":"white?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"white?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == White"}},{"id":"yellow?-instance-method","html_id":"yellow?-instance-method","name":"yellow?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"yellow?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == Yellow"}}],"macros":[],"types":[]},{"html_id":"/Colorize/ColorRGB","path":"Colorize/ColorRGB.html","kind":"struct","full_name":"Colorize::ColorRGB","name":"ColorRGB","abstract":false,"superclass":{"html_id":"/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Colorize","kind":"module","full_name":"Colorize","name":"Colorize"},"doc":null,"summary":null,"class_methods":[],"constructors":[{"id":"new(red:UInt8,green:UInt8,blue:UInt8)-class-method","html_id":"new(red:UInt8,green:UInt8,blue:UInt8)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"red","doc":null,"default_value":"","external_name":"red","restriction":"UInt8"},{"name":"green","doc":null,"default_value":"","external_name":"green","restriction":"UInt8"},{"name":"blue","doc":null,"default_value":"","external_name":"blue","restriction":"UInt8"}],"args_string":"(red : UInt8, green : UInt8, blue : UInt8)","source_link":null,"def":{"name":"new","args":[{"name":"red","doc":null,"default_value":"","external_name":"red","restriction":"UInt8"},{"name":"green","doc":null,"default_value":"","external_name":"green","restriction":"UInt8"},{"name":"blue","doc":null,"default_value":"","external_name":"blue","restriction":"UInt8"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(red, green, blue)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"back(io:IO):Nil-instance-method","html_id":"back(io:IO):Nil-instance-method","name":"back","doc":null,"summary":null,"abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"back","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << \"48;2;\"\n{red, green, blue}.join(';', io, &.to_s(io))\n"}},{"id":"blue:UInt8-instance-method","html_id":"blue:UInt8-instance-method","name":"blue","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : UInt8","source_link":null,"def":{"name":"blue","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"UInt8","visibility":"Public","body":"@blue"}},{"id":"clone-instance-method","html_id":"clone-instance-method","name":"clone","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self.class.new(@red.clone, @green.clone, @blue.clone)"}},{"id":"copy_with(red_red=@red,green_green=@green,blue_blue=@blue)-instance-method","html_id":"copy_with(red_red=@red,green_green=@green,blue_blue=@blue)-instance-method","name":"copy_with","doc":null,"summary":null,"abstract":false,"args":[{"name":"_red","doc":null,"default_value":"@red","external_name":"red","restriction":""},{"name":"_green","doc":null,"default_value":"@green","external_name":"green","restriction":""},{"name":"_blue","doc":null,"default_value":"@blue","external_name":"blue","restriction":""}],"args_string":"(red _red = @red, green _green = @green, blue _blue = @blue)","source_link":null,"def":{"name":"copy_with","args":[{"name":"_red","doc":null,"default_value":"@red","external_name":"red","restriction":""},{"name":"_green","doc":null,"default_value":"@green","external_name":"green","restriction":""},{"name":"_blue","doc":null,"default_value":"@blue","external_name":"blue","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self.class.new(_red, _green, _blue)"}},{"id":"fore(io:IO):Nil-instance-method","html_id":"fore(io:IO):Nil-instance-method","name":"fore","doc":null,"summary":null,"abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"fore","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << \"38;2;\"\n{red, green, blue}.join(';', io, &.to_s(io))\n"}},{"id":"green:UInt8-instance-method","html_id":"green:UInt8-instance-method","name":"green","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : UInt8","source_link":null,"def":{"name":"green","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"UInt8","visibility":"Public","body":"@green"}},{"id":"red:UInt8-instance-method","html_id":"red:UInt8-instance-method","name":"red","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : UInt8","source_link":null,"def":{"name":"red","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"UInt8","visibility":"Public","body":"@red"}}],"macros":[],"types":[]},{"html_id":"/Colorize/Object","path":"Colorize/Object.html","kind":"struct","full_name":"Colorize::Object(T)","name":"Object","abstract":false,"superclass":{"html_id":"/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Colorize","kind":"module","full_name":"Colorize","name":"Colorize"},"doc":null,"summary":null,"class_methods":[],"constructors":[{"id":"new(object:T)-class-method","html_id":"new(object:T)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":"T"}],"args_string":"(object : T)","source_link":null,"def":{"name":"new","args":[{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = Object(T).allocate\n_.initialize(object)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"back(color:Symbol)-instance-method","html_id":"back(color:Symbol)-instance-method","name":"back","doc":null,"summary":null,"abstract":false,"args":[{"name":"color","doc":null,"default_value":"","external_name":"color","restriction":"Symbol"}],"args_string":"(color : Symbol)","source_link":null,"def":{"name":"back","args":[{"name":"color","doc":null,"default_value":"","external_name":"color","restriction":"Symbol"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% for name in COLORS %}\n      if color == :{{ name.id }}\n        @back = ColorANSI::{{ name.camelcase.id }}\n        return self\n      end\n    {% end %}\nraise(ArgumentError.new(\"Unknown color: #{color}\"))\n"}},{"id":"back(back:Color)-instance-method","html_id":"back(back:Color)-instance-method","name":"back","doc":null,"summary":null,"abstract":false,"args":[{"name":"back","doc":null,"default_value":"","external_name":"back","restriction":"Color"}],"args_string":"(back : Color)","source_link":null,"def":{"name":"back","args":[{"name":"back","doc":null,"default_value":"","external_name":"back","restriction":"Color"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = back\nself\n"}},{"id":"black-instance-method","html_id":"black-instance-method","name":"black","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"black","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::Black\nself\n"}},{"id":"blink-instance-method","html_id":"blink-instance-method","name":"blink","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"blink","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@mode = @mode | MODE_BLINK_FLAG\nself\n"}},{"id":"blue-instance-method","html_id":"blue-instance-method","name":"blue","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"blue","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::Blue\nself\n"}},{"id":"bold-instance-method","html_id":"bold-instance-method","name":"bold","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"bold","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@mode = @mode | MODE_BOLD_FLAG\nself\n"}},{"id":"bright-instance-method","html_id":"bright-instance-method","name":"bright","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"bright","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@mode = @mode | MODE_BRIGHT_FLAG\nself\n"}},{"id":"cyan-instance-method","html_id":"cyan-instance-method","name":"cyan","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"cyan","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::Cyan\nself\n"}},{"id":"dark_gray-instance-method","html_id":"dark_gray-instance-method","name":"dark_gray","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"dark_gray","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::DarkGray\nself\n"}},{"id":"default-instance-method","html_id":"default-instance-method","name":"default","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"default","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::Default\nself\n"}},{"id":"dim-instance-method","html_id":"dim-instance-method","name":"dim","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"dim","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@mode = @mode | MODE_DIM_FLAG\nself\n"}},{"id":"fore(color:Symbol)-instance-method","html_id":"fore(color:Symbol)-instance-method","name":"fore","doc":null,"summary":null,"abstract":false,"args":[{"name":"color","doc":null,"default_value":"","external_name":"color","restriction":"Symbol"}],"args_string":"(color : Symbol)","source_link":null,"def":{"name":"fore","args":[{"name":"color","doc":null,"default_value":"","external_name":"color","restriction":"Symbol"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% for name in COLORS %}\n      if color == :{{ name.id }}\n        @fore = ColorANSI::{{ name.camelcase.id }}\n        return self\n      end\n    {% end %}\nraise(ArgumentError.new(\"Unknown color: #{color}\"))\n"}},{"id":"fore(fore:Color)-instance-method","html_id":"fore(fore:Color)-instance-method","name":"fore","doc":null,"summary":null,"abstract":false,"args":[{"name":"fore","doc":null,"default_value":"","external_name":"fore","restriction":"Color"}],"args_string":"(fore : Color)","source_link":null,"def":{"name":"fore","args":[{"name":"fore","doc":null,"default_value":"","external_name":"fore","restriction":"Color"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = fore\nself\n"}},{"id":"green-instance-method","html_id":"green-instance-method","name":"green","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"green","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::Green\nself\n"}},{"id":"hidden-instance-method","html_id":"hidden-instance-method","name":"hidden","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"hidden","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@mode = @mode | MODE_HIDDEN_FLAG\nself\n"}},{"id":"inspect(io:IO):Nil-instance-method","html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Appends this struct's name and instance variables names and values\nto the given IO.\n\n```\nstruct Point\n  def initialize(@x : Int32, @y : Int32)\n  end\nend\n\np1 = Point.new 1, 2\np1.to_s    # \"Point(@x=1, @y=2)\"\np1.inspect # \"Point(@x=1, @y=2)\"\n```","summary":"<p>Appends this struct's name and instance variables names and values to the given IO.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"inspect","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"surround(io) do\n  @object.inspect(io)\nend"}},{"id":"light_blue-instance-method","html_id":"light_blue-instance-method","name":"light_blue","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"light_blue","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::LightBlue\nself\n"}},{"id":"light_cyan-instance-method","html_id":"light_cyan-instance-method","name":"light_cyan","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"light_cyan","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::LightCyan\nself\n"}},{"id":"light_gray-instance-method","html_id":"light_gray-instance-method","name":"light_gray","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"light_gray","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::LightGray\nself\n"}},{"id":"light_green-instance-method","html_id":"light_green-instance-method","name":"light_green","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"light_green","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::LightGreen\nself\n"}},{"id":"light_magenta-instance-method","html_id":"light_magenta-instance-method","name":"light_magenta","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"light_magenta","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::LightMagenta\nself\n"}},{"id":"light_red-instance-method","html_id":"light_red-instance-method","name":"light_red","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"light_red","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::LightRed\nself\n"}},{"id":"light_yellow-instance-method","html_id":"light_yellow-instance-method","name":"light_yellow","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"light_yellow","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::LightYellow\nself\n"}},{"id":"magenta-instance-method","html_id":"magenta-instance-method","name":"magenta","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"magenta","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::Magenta\nself\n"}},{"id":"mode(mode:Symbol)-instance-method","html_id":"mode(mode:Symbol)-instance-method","name":"mode","doc":null,"summary":null,"abstract":false,"args":[{"name":"mode","doc":null,"default_value":"","external_name":"mode","restriction":"Symbol"}],"args_string":"(mode : Symbol)","source_link":null,"def":{"name":"mode","args":[{"name":"mode","doc":null,"default_value":"","external_name":"mode","restriction":"Symbol"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% for name in MODES %}\n      if mode == :{{ name.id }}\n        @mode |= MODE_{{ name.upcase.id }}_FLAG\n        return self\n      end\n    {% end %}\nraise(ArgumentError.new(\"Unknown mode: #{mode}\"))\n"}},{"id":"on(color:Symbol)-instance-method","html_id":"on(color:Symbol)-instance-method","name":"on","doc":null,"summary":null,"abstract":false,"args":[{"name":"color","doc":null,"default_value":"","external_name":"color","restriction":"Symbol"}],"args_string":"(color : Symbol)","source_link":null,"def":{"name":"on","args":[{"name":"color","doc":null,"default_value":"","external_name":"color","restriction":"Symbol"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"back(color)"}},{"id":"on_black-instance-method","html_id":"on_black-instance-method","name":"on_black","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"on_black","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::Black\nself\n"}},{"id":"on_blue-instance-method","html_id":"on_blue-instance-method","name":"on_blue","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"on_blue","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::Blue\nself\n"}},{"id":"on_cyan-instance-method","html_id":"on_cyan-instance-method","name":"on_cyan","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"on_cyan","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::Cyan\nself\n"}},{"id":"on_dark_gray-instance-method","html_id":"on_dark_gray-instance-method","name":"on_dark_gray","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"on_dark_gray","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::DarkGray\nself\n"}},{"id":"on_default-instance-method","html_id":"on_default-instance-method","name":"on_default","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"on_default","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::Default\nself\n"}},{"id":"on_green-instance-method","html_id":"on_green-instance-method","name":"on_green","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"on_green","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::Green\nself\n"}},{"id":"on_light_blue-instance-method","html_id":"on_light_blue-instance-method","name":"on_light_blue","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"on_light_blue","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::LightBlue\nself\n"}},{"id":"on_light_cyan-instance-method","html_id":"on_light_cyan-instance-method","name":"on_light_cyan","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"on_light_cyan","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::LightCyan\nself\n"}},{"id":"on_light_gray-instance-method","html_id":"on_light_gray-instance-method","name":"on_light_gray","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"on_light_gray","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::LightGray\nself\n"}},{"id":"on_light_green-instance-method","html_id":"on_light_green-instance-method","name":"on_light_green","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"on_light_green","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::LightGreen\nself\n"}},{"id":"on_light_magenta-instance-method","html_id":"on_light_magenta-instance-method","name":"on_light_magenta","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"on_light_magenta","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::LightMagenta\nself\n"}},{"id":"on_light_red-instance-method","html_id":"on_light_red-instance-method","name":"on_light_red","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"on_light_red","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::LightRed\nself\n"}},{"id":"on_light_yellow-instance-method","html_id":"on_light_yellow-instance-method","name":"on_light_yellow","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"on_light_yellow","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::LightYellow\nself\n"}},{"id":"on_magenta-instance-method","html_id":"on_magenta-instance-method","name":"on_magenta","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"on_magenta","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::Magenta\nself\n"}},{"id":"on_red-instance-method","html_id":"on_red-instance-method","name":"on_red","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"on_red","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::Red\nself\n"}},{"id":"on_white-instance-method","html_id":"on_white-instance-method","name":"on_white","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"on_white","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::White\nself\n"}},{"id":"on_yellow-instance-method","html_id":"on_yellow-instance-method","name":"on_yellow","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"on_yellow","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::Yellow\nself\n"}},{"id":"red-instance-method","html_id":"red-instance-method","name":"red","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"red","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::Red\nself\n"}},{"id":"reverse-instance-method","html_id":"reverse-instance-method","name":"reverse","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"reverse","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@mode = @mode | MODE_REVERSE_FLAG\nself\n"}},{"id":"surround(io=STDOUT,&block)-instance-method","html_id":"surround(io=STDOUT,&amp;block)-instance-method","name":"surround","doc":null,"summary":null,"abstract":false,"args":[{"name":"io","doc":null,"default_value":"STDOUT","external_name":"io","restriction":""}],"args_string":"(io = <span class=\"t\">STDOUT</span>, &block)","source_link":null,"def":{"name":"surround","args":[{"name":"io","doc":null,"default_value":"STDOUT","external_name":"io","restriction":""}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"if @enabled\nelse\n  return yield io\nend\nObject.surround(io, to_named_tuple) do |io|\n  yield io\nend\n"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Same as `#inspect(io)`.","summary":"<p>Same as <code><a href=\"../Colorize/Object.html#inspect(io:IO):Nil-instance-method\">#inspect(io)</a></code>.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"surround(io) do\n  io << @object\nend"}},{"id":"toggle(flag)-instance-method","html_id":"toggle(flag)-instance-method","name":"toggle","doc":null,"summary":null,"abstract":false,"args":[{"name":"flag","doc":null,"default_value":"","external_name":"flag","restriction":""}],"args_string":"(flag)","source_link":null,"def":{"name":"toggle","args":[{"name":"flag","doc":null,"default_value":"","external_name":"flag","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@enabled = !(!flag)\nself\n"}},{"id":"underline-instance-method","html_id":"underline-instance-method","name":"underline","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"underline","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@mode = @mode | MODE_UNDERLINE_FLAG\nself\n"}},{"id":"white-instance-method","html_id":"white-instance-method","name":"white","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"white","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::White\nself\n"}},{"id":"yellow-instance-method","html_id":"yellow-instance-method","name":"yellow","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"yellow","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::Yellow\nself\n"}}],"macros":[],"types":[]},{"html_id":"/Colorize/ObjectExtensions","path":"Colorize/ObjectExtensions.html","kind":"module","full_name":"Colorize::ObjectExtensions","name":"ObjectExtensions","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"namespace":{"html_id":"/Colorize","kind":"module","full_name":"Colorize","name":"Colorize"},"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[{"id":"colorize(fore)-instance-method","html_id":"colorize(fore)-instance-method","name":"colorize","doc":null,"summary":null,"abstract":false,"args":[{"name":"fore","doc":null,"default_value":"","external_name":"fore","restriction":""}],"args_string":"(fore)","source_link":null,"def":{"name":"colorize","args":[{"name":"fore","doc":null,"default_value":"","external_name":"fore","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(Colorize::Object.new(self)).fore(fore)"}},{"id":"colorize-instance-method","html_id":"colorize-instance-method","name":"colorize","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"colorize","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Colorize::Object.new(self)"}}],"macros":[],"types":[]}]},{"html_id":"/Comparable","path":"Comparable.html","kind":"module","full_name":"Comparable(T)","name":"Comparable","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[{"html_id":"/Array","kind":"class","full_name":"Array(T)","name":"Array"},{"html_id":"/BigDecimal","kind":"struct","full_name":"BigDecimal","name":"BigDecimal"},{"html_id":"/BigFloat","kind":"struct","full_name":"BigFloat","name":"BigFloat"},{"html_id":"/BigInt","kind":"struct","full_name":"BigInt","name":"BigInt"},{"html_id":"/BigRational","kind":"struct","full_name":"BigRational","name":"BigRational"},{"html_id":"/Char","kind":"struct","full_name":"Char","name":"Char"},{"html_id":"/Enum","kind":"struct","full_name":"Enum","name":"Enum"},{"html_id":"/Float","kind":"struct","full_name":"Float","name":"Float"},{"html_id":"/Int","kind":"struct","full_name":"Int","name":"Int"},{"html_id":"/Number","kind":"struct","full_name":"Number","name":"Number"},{"html_id":"/Path","kind":"struct","full_name":"Path","name":"Path"},{"html_id":"/Pointer","kind":"struct","full_name":"Pointer(T)","name":"Pointer"},{"html_id":"/SemanticVersion","kind":"struct","full_name":"SemanticVersion","name":"SemanticVersion"},{"html_id":"/Slice","kind":"struct","full_name":"Slice(T)","name":"Slice"},{"html_id":"/String","kind":"class","full_name":"String","name":"String"},{"html_id":"/Symbol","kind":"struct","full_name":"Symbol","name":"Symbol"},{"html_id":"/Time","kind":"struct","full_name":"Time","name":"Time"},{"html_id":"/Time/Span","kind":"struct","full_name":"Time::Span","name":"Span"},{"html_id":"/Tuple","kind":"struct","full_name":"Tuple(*T)","name":"Tuple"}],"namespace":null,"doc":"The `Comparable` mixin is used by classes whose objects may be ordered.\n\nIncluding types must provide an `<=>` method, which compares the receiver against\nanother object, returning:\n- a negative number if `self` is less than the other object\n- a positive number if `self` is greater than the other object\n- `0` if `self` is equal to the other object\n- `nil` if `self` and the other object are not comparable\n\n`Comparable` uses `<=>` to implement the conventional comparison operators\n(`<`, `<=`, `==`, `>=`, and `>`). All of these return `false` when `<=>`\nreturns `nil`.\n\nNote that returning `nil` is only useful when defining a partial comparable\nrelationship. One such example is float values: they are generally comparable,\nexcept for `NaN`. If none of the values of a type are comparable between each\nother, `Comparable` shouldn't be included.\n\nNOTE: When `nil` is returned from `<=>`, `Array#sort` and related sorting\nmethods will perform slightly slower.","summary":"<p>The <code><a href=\"Comparable.html\">Comparable</a></code> mixin is used by classes whose objects may be ordered.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"<(other:T)-instance-method","html_id":"&lt;(other:T)-instance-method","name":"<","doc":"Compares this object to *other* based on the receiver’s `<=>` method,\nreturning `true` if it returns a negative number.","summary":"<p>Compares this object to <em>other</em> based on the receiver’s <code><a href=\"Comparable.html#(other:T)-instance-method\">#<=></a></code> method, returning <code>true</code> if it returns a negative number.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T"}],"args_string":"(other : T)","source_link":null,"def":{"name":"<","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"cmp = self <=> other\ncmp ? cmp < 0 : false\n"}},{"id":"<=(other:T)-instance-method","html_id":"&lt;=(other:T)-instance-method","name":"<=","doc":"Compares this object to *other* based on the receiver’s `<=>` method,\nreturning `true` if it returns a value equal or less then `0`.","summary":"<p>Compares this object to <em>other</em> based on the receiver’s <code><a href=\"Comparable.html#(other:T)-instance-method\">#<=></a></code> method, returning <code>true</code> if it returns a value equal or less then <code>0</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T"}],"args_string":"(other : T)","source_link":null,"def":{"name":"<=","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"cmp = self <=> other\ncmp ? cmp <= 0 : false\n"}},{"id":"(other:T)-instance-method","html_id":"(other:T)-instance-method","name":"<=>","doc":"The comparison operator. Returns `0` if the two objects are equal,\na negative number if this object is considered less than *other*,\na positive number if this object is considered greter than *other*,\nor `nil` if the two objects are not comparable.\n\nSubclasses define this method to provide class-specific ordering.\n\nThe comparison operator is usually used to sort values:\n\n```\n# Sort in a descending way:\n[3, 1, 2].sort { |x, y| y <=> x } # => [3, 2, 1]\n\n# Sort in an ascending way:\n[3, 1, 2].sort { |x, y| x <=> y } # => [1, 2, 3]\n```","summary":"<p>The comparison operator.</p>","abstract":true,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T"}],"args_string":"(other : T)","source_link":null,"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":""}},{"id":"==(other:T)-instance-method","html_id":"==(other:T)-instance-method","name":"==","doc":"Compares this object to *other* based on the receiver’s `<=>` method,\nreturning `true` if it returns `0`.\n\nAlso returns `true` if this and *other* are the same object.","summary":"<p>Compares this object to <em>other</em> based on the receiver’s <code><a href=\"Comparable.html#(other:T)-instance-method\">#<=></a></code> method, returning <code>true</code> if it returns <code>0</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T"}],"args_string":"(other : T)","source_link":null,"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if self.is_a?(Reference)\n  if other.is_a?(Reference) && (self.same?(other))\n    return true\n  end\n  if other.is_a?(Nil) && (self.same?(other))\n    return true\n  end\nend\ncmp = self <=> other\ncmp ? cmp == 0 : false\n"}},{"id":">(other:T)-instance-method","html_id":"&gt;(other:T)-instance-method","name":">","doc":"Compares this object to *other* based on the receiver’s `<=>` method,\nreturning `true` if it returns a value greater then `0`.","summary":"<p>Compares this object to <em>other</em> based on the receiver’s <code><a href=\"Comparable.html#(other:T)-instance-method\">#<=></a></code> method, returning <code>true</code> if it returns a value greater then <code>0</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T"}],"args_string":"(other : T)","source_link":null,"def":{"name":">","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"cmp = self <=> other\ncmp ? cmp > 0 : false\n"}},{"id":">=(other:T)-instance-method","html_id":"&gt;=(other:T)-instance-method","name":">=","doc":"Compares this object to *other* based on the receiver’s `<=>` method,\nreturning `true` if it returns a value equal or greater than `0`.","summary":"<p>Compares this object to <em>other</em> based on the receiver’s <code><a href=\"Comparable.html#(other:T)-instance-method\">#<=></a></code> method, returning <code>true</code> if it returns a value equal or greater than <code>0</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T"}],"args_string":"(other : T)","source_link":null,"def":{"name":">=","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"cmp = self <=> other\ncmp ? cmp >= 0 : false\n"}}],"macros":[],"types":[]},{"html_id":"/Complex","path":"Complex.html","kind":"struct","full_name":"Complex","name":"Complex","abstract":false,"superclass":{"html_id":"/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"A complex number is a number represented in the form a + bi. In this form,\na and b are real numbers, and i is an imaginary number such as i² = -1.\nThe a is the real part of the number, and the b is the imaginary part of\nthe number.\n\n```\nrequire \"complex\"\n\nComplex.new(1, 0)   # => 1.0 + 0.0i\nComplex.new(5, -12) # => 5.0 - 12.0i\n\n1.to_c # => 1.0 + 0.0i\n1.i    # => 0.0 + 1.0i\n```","summary":"<p>A complex number is a number represented in the form a + bi.</p>","class_methods":[],"constructors":[{"id":"new(real:Number,imag:Number=0)-class-method","html_id":"new(real:Number,imag:Number=0)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"real","doc":null,"default_value":"","external_name":"real","restriction":"Number"},{"name":"imag","doc":null,"default_value":"0","external_name":"imag","restriction":"Number"}],"args_string":"(real : Number, imag : Number = <span class=\"n\">0</span>)","source_link":null,"def":{"name":"new","args":[{"name":"real","doc":null,"default_value":"","external_name":"real","restriction":"Number"},{"name":"imag","doc":null,"default_value":"0","external_name":"imag","restriction":"Number"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(real, imag)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(c:Complex)-class-method","html_id":"new(c:Complex)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"c","doc":null,"default_value":"","external_name":"c","restriction":"Complex"}],"args_string":"(c : Complex)","source_link":null,"def":{"name":"new","args":[{"name":"c","doc":null,"default_value":"","external_name":"c","restriction":"Complex"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"c"}},{"id":"zero:Complex-class-method","html_id":"zero:Complex-class-method","name":"zero","doc":"Returns the number `0` in complex form.","summary":"<p>Returns the number <code>0</code> in complex form.</p>","abstract":false,"args":[],"args_string":" : Complex","source_link":null,"def":{"name":"zero","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Complex","visibility":"Public","body":"new(0, 0)"}}],"instance_methods":[{"id":"*(other:Number)-instance-method","html_id":"*(other:Number)-instance-method","name":"*","doc":"Multiplies `self` by *other*.","summary":"<p>Multiplies <code>self</code> by <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"args_string":"(other : Number)","source_link":null,"def":{"name":"*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Complex.new(@real * other, @imag * other)"}},{"id":"*(other:Complex)-instance-method","html_id":"*(other:Complex)-instance-method","name":"*","doc":"Multiplies `self` by *other*.","summary":"<p>Multiplies <code>self</code> by <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Complex"}],"args_string":"(other : Complex)","source_link":null,"def":{"name":"*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Complex"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Complex.new((@real * other.real) - (@imag * other.imag), (@real * other.imag) + (@imag * other.real))"}},{"id":"+(other:Complex)-instance-method","html_id":"+(other:Complex)-instance-method","name":"+","doc":"Adds the value of `self` to *other*.","summary":"<p>Adds the value of <code>self</code> to <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Complex"}],"args_string":"(other : Complex)","source_link":null,"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Complex"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Complex.new(@real + other.real, @imag + other.imag)"}},{"id":"+(other:Number)-instance-method","html_id":"+(other:Number)-instance-method","name":"+","doc":"Adds the value of `self` to *other*.","summary":"<p>Adds the value of <code>self</code> to <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"args_string":"(other : Number)","source_link":null,"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Complex.new(@real + other, @imag)"}},{"id":"+-instance-method","html_id":"+-instance-method","name":"+","doc":"Returns absolute value of `self`.","summary":"<p>Returns absolute value of <code>self</code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"+","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Complex.new(@real.abs, @imag.abs)"}},{"id":"-(other:Complex)-instance-method","html_id":"-(other:Complex)-instance-method","name":"-","doc":"Removes the value of *other* from `self`.","summary":"<p>Removes the value of <em>other</em> from <code>self</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Complex"}],"args_string":"(other : Complex)","source_link":null,"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Complex"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Complex.new(@real - other.real, @imag - other.imag)"}},{"id":"--instance-method","html_id":"--instance-method","name":"-","doc":"Returns the opposite of `self`.","summary":"<p>Returns the opposite of <code>self</code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"-","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Complex.new(-@real, -@imag)"}},{"id":"-(other:Number)-instance-method","html_id":"-(other:Number)-instance-method","name":"-","doc":"Removes the value of *other* from `self`.","summary":"<p>Removes the value of <em>other</em> from <code>self</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"args_string":"(other : Number)","source_link":null,"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Complex.new(@real - other, @imag)"}},{"id":"/(other:Number)-instance-method","html_id":"/(other:Number)-instance-method","name":"/","doc":"Divides `self` by *other*.","summary":"<p>Divides <code>self</code> by <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"args_string":"(other : Number)","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Complex.new(@real / other, @imag / other)"}},{"id":"/(other:Complex)-instance-method","html_id":"/(other:Complex)-instance-method","name":"/","doc":"Divides `self` by *other*.","summary":"<p>Divides <code>self</code> by <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Complex"}],"args_string":"(other : Complex)","source_link":null,"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Complex"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if other.real <= other.imag\n  r = other.real / other.imag\n  d = other.imag + (r * other.real)\n  Complex.new(((@real * r) + @imag) / d, ((@imag * r) - @real) / d)\nelse\n  r = other.imag / other.real\n  d = other.real + (r * other.imag)\n  Complex.new((@real + (@imag * r)) / d, (@imag - (@real * r)) / d)\nend"}},{"id":"==(other:Complex)-instance-method","html_id":"==(other:Complex)-instance-method","name":"==","doc":"Determines whether `self` equals *other* or not.","summary":"<p>Determines whether <code>self</code> equals <em>other</em> or not.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Complex"}],"args_string":"(other : Complex)","source_link":null,"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Complex"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(@real == other.real) && (@imag == other.imag)"}},{"id":"==(other:Number)-instance-method","html_id":"==(other:Number)-instance-method","name":"==","doc":"Determines whether `self` equals *other* or not.","summary":"<p>Determines whether <code>self</code> equals <em>other</em> or not.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"args_string":"(other : Number)","source_link":null,"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == other.to_c"}},{"id":"==(other)-instance-method","html_id":"==(other)-instance-method","name":"==","doc":"Determines whether `self` equals *other* or not.","summary":"<p>Determines whether <code>self</code> equals <em>other</em> or not.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"args_string":"(other)","source_link":null,"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"false"}},{"id":"abs-instance-method","html_id":"abs-instance-method","name":"abs","doc":"Returns the absolute value of this complex number in a\nnumber form, using the Pythagorean theorem.\n\n```\nrequire \"complex\"\n\nComplex.new(42, 2).abs  # => 42.04759208325728\nComplex.new(-42, 2).abs # => 42.04759208325728\n```","summary":"<p>Returns the absolute value of this complex number in a number form, using the Pythagorean theorem.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"abs","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Math.hypot(@real, @imag)"}},{"id":"abs2-instance-method","html_id":"abs2-instance-method","name":"abs2","doc":"Returns the square of absolute value in a number form.\n\n```\nrequire \"complex\"\n\nComplex.new(42, 2).abs2 # => 1768\n```","summary":"<p>Returns the square of absolute value in a number form.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"abs2","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(@real * @real) + (@imag * @imag)"}},{"id":"clone-instance-method","html_id":"clone-instance-method","name":"clone","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"conj-instance-method","html_id":"conj-instance-method","name":"conj","doc":"Returns the conjugate of `self`.\n\n```\nrequire \"complex\"\n\nComplex.new(42, 2).conj  # => 42.0 - 2.0i\nComplex.new(42, -2).conj # => 42.0 + 2.0i\n```","summary":"<p>Returns the conjugate of <code>self</code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"conj","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Complex.new(@real, -@imag)"}},{"id":"exp-instance-method","html_id":"exp-instance-method","name":"exp","doc":"Calculates the exp of `self`.\n\n```\nrequire \"complex\"\n\nComplex.new(4, 2).exp # => -22.720847417619233 + 49.645957334580565i\n```","summary":"<p>Calculates the exp of <code>self</code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"exp","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"r = Math.exp(@real)\nComplex.new(r * (Math.cos(@imag)), r * (Math.sin(@imag)))\n"}},{"id":"hash(hasher)-instance-method","html_id":"hash(hasher)-instance-method","name":"hash","doc":"See `Object#hash(hasher)`","summary":"<p>See <code><a href=\"Object.html#hash(hasher)-instance-method\">Object#hash(hasher)</a></code></p>","abstract":false,"args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"args_string":"(hasher)","source_link":null,"def":{"name":"hash","args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"hasher = real.hash(hasher)\nif imag.zero?\nelse\n  hasher = imag.hash(hasher)\nend\nhasher\n"}},{"id":"imag:Float64-instance-method","html_id":"imag:Float64-instance-method","name":"imag","doc":"Returns the imaginary part.","summary":"<p>Returns the imaginary part.</p>","abstract":false,"args":[],"args_string":" : Float64","source_link":null,"def":{"name":"imag","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Float64","visibility":"Public","body":"@imag"}},{"id":"inspect(io:IO):Nil-instance-method","html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Writes this complex object to an *io*, surrounded by parentheses.\n\n```\nrequire \"complex\"\n\nComplex.new(42, 2).inspect # => \"(42.0 + 2.0i)\"\n```","summary":"<p>Writes this complex object to an <em>io</em>, surrounded by parentheses.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"inspect","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << '('\nto_s(io)\nio << ')'\n"}},{"id":"inv-instance-method","html_id":"inv-instance-method","name":"inv","doc":"Returns the inverse of `self`.","summary":"<p>Returns the inverse of <code>self</code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"inv","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"conj / abs2"}},{"id":"log-instance-method","html_id":"log-instance-method","name":"log","doc":"Calculates the log of `self`.","summary":"<p>Calculates the log of <code>self</code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"log","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Complex.new(Math.log(abs), phase)"}},{"id":"log10-instance-method","html_id":"log10-instance-method","name":"log10","doc":"Calculates the log10 of `self`.","summary":"<p>Calculates the log10 of <code>self</code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"log10","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"log / Math::LOG10"}},{"id":"log2-instance-method","html_id":"log2-instance-method","name":"log2","doc":"Calculates the log2 of `self`.","summary":"<p>Calculates the log2 of <code>self</code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"log2","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"log / Math::LOG2"}},{"id":"phase-instance-method","html_id":"phase-instance-method","name":"phase","doc":"Returns the phase of `self`.","summary":"<p>Returns the phase of <code>self</code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"phase","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Math.atan2(@imag, @real)"}},{"id":"polar-instance-method","html_id":"polar-instance-method","name":"polar","doc":"Returns a `Tuple` with the `abs` value and the `phase`.\n\n```\nrequire \"complex\"\n\nComplex.new(42, 2).polar # => {42.047592083257278, 0.047583103276983396}\n```","summary":"<p>Returns a <code><a href=\"Tuple.html\">Tuple</a></code> with the <code><a href=\"Complex.html#abs-instance-method\">#abs</a></code> value and the <code><a href=\"Complex.html#phase-instance-method\">#phase</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"polar","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{abs, phase}"}},{"id":"real:Float64-instance-method","html_id":"real:Float64-instance-method","name":"real","doc":"Returns the real part.","summary":"<p>Returns the real part.</p>","abstract":false,"args":[],"args_string":" : Float64","source_link":null,"def":{"name":"real","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Float64","visibility":"Public","body":"@real"}},{"id":"sign-instance-method","html_id":"sign-instance-method","name":"sign","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"sign","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self / abs"}},{"id":"sqrt-instance-method","html_id":"sqrt-instance-method","name":"sqrt","doc":"`Complex#sqrt` was inspired by the [following blog post](https://pavpanchekha.com/casio/)\nof Pavel Panchekha on floating point precision.\n","summary":"<p><code><a href=\"Complex.html#sqrt-instance-method\">Complex#sqrt</a></code> was inspired by the <a href=\"https://pavpanchekha.com/casio/\" target=\"_blank\">following blog post</a> of Pavel Panchekha on floating point precision.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"sqrt","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"r = abs\nre = if @real >= 0\n  0.5 * (Math.sqrt(2.0 * (r + @real)))\nelse\n  @imag.abs / (Math.sqrt(2 * (r - @real)))\nend\nim = if @real <= 0\n  0.5 * (Math.sqrt(2.0 * (r - @real)))\nelse\n  @imag.abs / (Math.sqrt(2 * (r + @real)))\nend\nComplex.new(re, @imag >= 0 ? im : -im)\n"}},{"id":"to_c-instance-method","html_id":"to_c-instance-method","name":"to_c","doc":"Returns `self`.","summary":"<p>Returns <code>self</code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_c","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"to_f-instance-method","html_id":"to_f-instance-method","name":"to_f","doc":"See `#to_f64`.","summary":"<p>See <code><a href=\"Complex.html#to_f64-instance-method\">#to_f64</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64"}},{"id":"to_f32-instance-method","html_id":"to_f32-instance-method","name":"to_f32","doc":"Returns the value as a `Float32` if possible (the imaginary part should be exactly zero),\nraises otherwise.","summary":"<p>Returns the value as a <code><a href=\"Float32.html\">Float32</a></code> if possible (the imaginary part should be exactly zero), raises otherwise.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_f32"}},{"id":"to_f64-instance-method","html_id":"to_f64-instance-method","name":"to_f64","doc":"Returns the value as a `Float64` if possible (the imaginary part should be exactly zero),\nraises otherwise.","summary":"<p>Returns the value as a <code><a href=\"Float64.html\">Float64</a></code> if possible (the imaginary part should be exactly zero), raises otherwise.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_f64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if @imag.zero?\nelse\n  raise(Exception.new(\"Complex number with non-zero imaginary part can't be converted to real number\"))\nend\n@real\n"}},{"id":"to_i-instance-method","html_id":"to_i-instance-method","name":"to_i","doc":"See `#to_i32`.","summary":"<p>See <code><a href=\"Complex.html#to_i32(*args,**options)-instance-method\">#to_i32</a></code>.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i32"}},{"id":"to_i16(*args,**options)-instance-method","html_id":"to_i16(*args,**options)-instance-method","name":"to_i16","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","source_link":null,"def":{"name":"to_i16","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i64.to_i16(*args, **options)"}},{"id":"to_i16(*args,**options,&block)-instance-method","html_id":"to_i16(*args,**options,&amp;block)-instance-method","name":"to_i16","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &block)","source_link":null,"def":{"name":"to_i16","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i64.to_i16(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_i32(*args,**options)-instance-method","html_id":"to_i32(*args,**options)-instance-method","name":"to_i32","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","source_link":null,"def":{"name":"to_i32","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i64.to_i32(*args, **options)"}},{"id":"to_i32(*args,**options,&block)-instance-method","html_id":"to_i32(*args,**options,&amp;block)-instance-method","name":"to_i32","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &block)","source_link":null,"def":{"name":"to_i32","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i64.to_i32(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_i64-instance-method","html_id":"to_i64-instance-method","name":"to_i64","doc":"Returns the value as an `Int64` if possible (the imaginary part should be exactly zero),\nraises otherwise.","summary":"<p>Returns the value as an <code><a href=\"Int64.html\">Int64</a></code> if possible (the imaginary part should be exactly zero), raises otherwise.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_i64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_i64"}},{"id":"to_i8(*args,**options)-instance-method","html_id":"to_i8(*args,**options)-instance-method","name":"to_i8","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","source_link":null,"def":{"name":"to_i8","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i64.to_i8(*args, **options)"}},{"id":"to_i8(*args,**options,&block)-instance-method","html_id":"to_i8(*args,**options,&amp;block)-instance-method","name":"to_i8","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &block)","source_link":null,"def":{"name":"to_i8","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i64.to_i8(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Writes this complex object to an *io*.\n\n```\nrequire \"complex\"\n\nComplex.new(42, 2).to_s # => \"42.0 + 2.0i\"\n```","summary":"<p>Writes this complex object to an <em>io</em>.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << @real\nio << (@imag >= 0 ? \" + \" : \" - \")\nio << @imag.abs\nio << 'i'\n"}},{"id":"to_u16(*args,**options)-instance-method","html_id":"to_u16(*args,**options)-instance-method","name":"to_u16","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","source_link":null,"def":{"name":"to_u16","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u64.to_u16(*args, **options)"}},{"id":"to_u16(*args,**options,&block)-instance-method","html_id":"to_u16(*args,**options,&amp;block)-instance-method","name":"to_u16","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &block)","source_link":null,"def":{"name":"to_u16","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u64.to_u16(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_u32(*args,**options)-instance-method","html_id":"to_u32(*args,**options)-instance-method","name":"to_u32","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","source_link":null,"def":{"name":"to_u32","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u64.to_u32(*args, **options)"}},{"id":"to_u32(*args,**options,&block)-instance-method","html_id":"to_u32(*args,**options,&amp;block)-instance-method","name":"to_u32","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &block)","source_link":null,"def":{"name":"to_u32","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u64.to_u32(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_u64-instance-method","html_id":"to_u64-instance-method","name":"to_u64","doc":"Returns the value as an `UInt64` if possible (the imaginary part should be exactly zero),\nraises otherwise.","summary":"<p>Returns the value as an <code><a href=\"UInt64.html\">UInt64</a></code> if possible (the imaginary part should be exactly zero), raises otherwise.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_u64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_u64"}},{"id":"to_u8(*args,**options)-instance-method","html_id":"to_u8(*args,**options)-instance-method","name":"to_u8","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","source_link":null,"def":{"name":"to_u8","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u64.to_u8(*args, **options)"}},{"id":"to_u8(*args,**options,&block)-instance-method","html_id":"to_u8(*args,**options,&amp;block)-instance-method","name":"to_u8","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &block)","source_link":null,"def":{"name":"to_u8","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u64.to_u8(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"zero?:Bool-instance-method","html_id":"zero?:Bool-instance-method","name":"zero?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Bool","source_link":null,"def":{"name":"zero?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"(@real == 0) && (@imag == 0)"}}],"macros":[],"types":[]},{"html_id":"/Concurrent","path":"Concurrent.html","kind":"module","full_name":"Concurrent","name":"Concurrent","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[{"html_id":"/Concurrent/CanceledError","path":"Concurrent/CanceledError.html","kind":"class","full_name":"Concurrent::CanceledError","name":"CanceledError","abstract":false,"superclass":{"html_id":"/Exception","kind":"class","full_name":"Exception","name":"Exception"},"ancestors":[{"html_id":"/Exception","kind":"class","full_name":"Exception","name":"Exception"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Concurrent","kind":"module","full_name":"Concurrent","name":"Concurrent"},"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]}]},{"html_id":"/ConcurrentExecutionException","path":"ConcurrentExecutionException.html","kind":"class","full_name":"ConcurrentExecutionException","name":"ConcurrentExecutionException","abstract":false,"superclass":{"html_id":"/Exception","kind":"class","full_name":"Exception","name":"Exception"},"ancestors":[{"html_id":"/Exception","kind":"class","full_name":"Exception","name":"Exception"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"Wraps around exceptions re-raised from concurrent calls.\nThe original exception can be accessed via `#cause`.","summary":"<p>Wraps around exceptions re-raised from concurrent calls.</p>","class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"/CRC32","path":"CRC32.html","kind":"module","full_name":"CRC32","name":"CRC32","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":null,"summary":null,"class_methods":[{"id":"checksum(data):UInt32-class-method","html_id":"checksum(data):UInt32-class-method","name":"checksum","doc":null,"summary":null,"abstract":false,"args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""}],"args_string":"(data) : UInt32","source_link":null,"def":{"name":"checksum","args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"UInt32","visibility":"Public","body":"update(data, initial)"}},{"id":"combine(crc1:UInt32,crc2:UInt32,len):UInt32-class-method","html_id":"combine(crc1:UInt32,crc2:UInt32,len):UInt32-class-method","name":"combine","doc":null,"summary":null,"abstract":false,"args":[{"name":"crc1","doc":null,"default_value":"","external_name":"crc1","restriction":"UInt32"},{"name":"crc2","doc":null,"default_value":"","external_name":"crc2","restriction":"UInt32"},{"name":"len","doc":null,"default_value":"","external_name":"len","restriction":""}],"args_string":"(crc1 : UInt32, crc2 : UInt32, len) : UInt32","source_link":null,"def":{"name":"combine","args":[{"name":"crc1","doc":null,"default_value":"","external_name":"crc1","restriction":"UInt32"},{"name":"crc2","doc":null,"default_value":"","external_name":"crc2","restriction":"UInt32"},{"name":"len","doc":null,"default_value":"","external_name":"len","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"UInt32","visibility":"Public","body":"(LibZ.crc32_combine(crc1, crc2, len)).to_u32"}},{"id":"initial:UInt32-class-method","html_id":"initial:UInt32-class-method","name":"initial","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : UInt32","source_link":null,"def":{"name":"initial","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"UInt32","visibility":"Public","body":"(LibZ.crc32(0, nil, 0)).to_u32"}},{"id":"update(data,crc32:UInt32):UInt32-class-method","html_id":"update(data,crc32:UInt32):UInt32-class-method","name":"update","doc":null,"summary":null,"abstract":false,"args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""},{"name":"crc32","doc":null,"default_value":"","external_name":"crc32","restriction":"UInt32"}],"args_string":"(data, crc32 : UInt32) : UInt32","source_link":null,"def":{"name":"update","args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""},{"name":"crc32","doc":null,"default_value":"","external_name":"crc32","restriction":"UInt32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"UInt32","visibility":"Public","body":"slice = data.to_slice\n(LibZ.crc32(crc32, slice, slice.size)).to_u32\n"}}],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"/Crypto","path":"Crypto.html","kind":"module","full_name":"Crypto","name":"Crypto","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[{"html_id":"/Crypto/Bcrypt","path":"Crypto/Bcrypt.html","kind":"class","full_name":"Crypto::Bcrypt","name":"Bcrypt","abstract":false,"superclass":{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[{"id":"COST_RANGE","name":"COST_RANGE","value":"4..31","doc":null,"summary":null},{"id":"DEFAULT_COST","name":"DEFAULT_COST","value":"11","doc":null,"summary":null},{"id":"PASSWORD_RANGE","name":"PASSWORD_RANGE","value":"1..72","doc":null,"summary":null},{"id":"SALT_SIZE","name":"SALT_SIZE","value":"16","doc":null,"summary":null}],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crypto","kind":"module","full_name":"Crypto","name":"Crypto"},"doc":"Pure Crystal implementation of the Bcrypt algorithm by Niels Provos and David\nMazières, as [presented at USENIX in\n1999](https://www.usenix.org/legacy/events/usenix99/provos/provos_html/index.html).\n\nThe algorithm has a maximum password length limit of 71 characters (see\n[this comment](https://security.stackexchange.com/questions/39849/does-bcrypt-have-a-maximum-password-length#answer-39851)\non stackoverflow).\n\nRefer to `Crypto::Bcrypt::Password` for a higher level interface.\n\nAbout the Cost\n\nBcrypt, like the PBKDF2 or scrypt ciphers, are designed to be slow, so\ngenerating rainbow tables or cracking passwords is nearly impossible. Yet,\ncomputers are always getting faster and faster, so the actual cost must be\nincremented every once in a while.\nAlways use the maximum cost that is tolerable, performance wise, for your\napplication. Be sure to test and select this based on your server, not your\nhome computer.\n\nThis implementation of Bcrypt is currently 50% slower than pure C solutions,\nso keep this in mind when selecting your cost. It may be wise to test with\nRuby's [bcrypt gem](https://github.com/codahale/bcrypt-ruby)\nwhich is a binding to OpenBSD's implementation.\n\nLast but not least: beware of denial of services! Always protect your\napplication using an external strategy (eg: rate limiting), otherwise\nendpoints that verifies bcrypt hashes will be an easy target.","summary":"<p>Pure Crystal implementation of the Bcrypt algorithm by Niels Provos and David Mazières, as <a href=\"https://www.usenix.org/legacy/events/usenix99/provos/provos_html/index.html\" target=\"_blank\">presented at USENIX in 1999</a>.</p>","class_methods":[{"id":"hash_secret(password,cost=DEFAULT_COST):String-class-method","html_id":"hash_secret(password,cost=DEFAULT_COST):String-class-method","name":"hash_secret","doc":null,"summary":null,"abstract":false,"args":[{"name":"password","doc":null,"default_value":"","external_name":"password","restriction":""},{"name":"cost","doc":null,"default_value":"DEFAULT_COST","external_name":"cost","restriction":""}],"args_string":"(password, cost = <span class=\"t\">DEFAULT_COST</span>) : String","source_link":null,"def":{"name":"hash_secret","args":[{"name":"password","doc":null,"default_value":"","external_name":"password","restriction":""},{"name":"cost","doc":null,"default_value":"DEFAULT_COST","external_name":"cost","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"passwordb = (password.to_unsafe.to_slice(password.bytesize + 1)).clone\nsaltb = Random::Secure.random_bytes(SALT_SIZE)\n(new(passwordb, saltb, cost)).to_s\n"}}],"constructors":[{"id":"new(password:String,salt:String,cost=DEFAULT_COST)-class-method","html_id":"new(password:String,salt:String,cost=DEFAULT_COST)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"password","doc":null,"default_value":"","external_name":"password","restriction":"String"},{"name":"salt","doc":null,"default_value":"","external_name":"salt","restriction":"String"},{"name":"cost","doc":null,"default_value":"DEFAULT_COST","external_name":"cost","restriction":""}],"args_string":"(password : String, salt : String, cost = <span class=\"t\">DEFAULT_COST</span>)","source_link":null,"def":{"name":"new","args":[{"name":"password","doc":null,"default_value":"","external_name":"password","restriction":"String"},{"name":"salt","doc":null,"default_value":"","external_name":"salt","restriction":"String"},{"name":"cost","doc":null,"default_value":"DEFAULT_COST","external_name":"cost","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"passwordb = (password.to_unsafe.to_slice(password.bytesize + 1)).clone\nsaltb = Base64.decode(salt, SALT_SIZE)\nnew(passwordb, saltb, cost)\n"}},{"id":"new(password:Bytes,salt:Bytes,cost=DEFAULT_COST)-class-method","html_id":"new(password:Bytes,salt:Bytes,cost=DEFAULT_COST)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"password","doc":null,"default_value":"","external_name":"password","restriction":"Bytes"},{"name":"salt","doc":null,"default_value":"","external_name":"salt","restriction":"Bytes"},{"name":"cost","doc":null,"default_value":"DEFAULT_COST","external_name":"cost","restriction":""}],"args_string":"(password : Bytes, salt : Bytes, cost = <span class=\"t\">DEFAULT_COST</span>)","source_link":null,"def":{"name":"new","args":[{"name":"password","doc":null,"default_value":"","external_name":"password","restriction":"Bytes"},{"name":"salt","doc":null,"default_value":"","external_name":"salt","restriction":"Bytes"},{"name":"cost","doc":null,"default_value":"DEFAULT_COST","external_name":"cost","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(password, salt, cost)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"cost:Int32-instance-method","html_id":"cost:Int32-instance-method","name":"cost","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Int32","source_link":null,"def":{"name":"cost","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":"@cost"}},{"id":"digest-instance-method","html_id":"digest-instance-method","name":"digest","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"digest","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@digest || (@digest = hash_password)"}},{"id":"inspect(io:IO):Nil-instance-method","html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Appends a String representation of this object\nwhich includes its class name, its object address\nand the values of all instance variables.\n\n```\nclass Person\n  def initialize(@name : String, @age : Int32)\n  end\nend\n\nPerson.new(\"John\", 32).inspect # => #<Person:0x10fd31f20 @name=\"John\", @age=32>\n```","summary":"<p>Appends a String representation of this object which includes its class name, its object address and the values of all instance variables.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"inspect","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"to_s(io)"}},{"id":"password:Bytes-instance-method","html_id":"password:Bytes-instance-method","name":"password","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Bytes","source_link":null,"def":{"name":"password","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bytes","visibility":"Public","body":"@password"}},{"id":"salt:Bytes-instance-method","html_id":"salt:Bytes-instance-method","name":"salt","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Bytes","source_link":null,"def":{"name":"salt","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bytes","visibility":"Public","body":"@salt"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Appends a short String representation of this object\nwhich includes its class name and its object address.\n\n```\nclass Person\n  def initialize(@name : String, @age : Int32)\n  end\nend\n\nPerson.new(\"John\", 32).to_s # => #<Person:0x10a199f20>\n```","summary":"<p>Appends a short String representation of this object which includes its class name and its object address.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << to_s"}},{"id":"to_s-instance-method","html_id":"to_s-instance-method","name":"to_s","doc":"Returns a string representation of this object.\n\nDescendants must usually **not** override this method. Instead,\nthey must override `to_s(io)`, which must append to the given\nIO object.","summary":"<p>Returns a string representation of this object.</p>","abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"to_s","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@hash || (@hash = (begin\n  salt64 = Base64.encode(salt, salt.size)\n  digest64 = Base64.encode(digest, digest.size - 1)\n  \"$2a$%02d$%s%s\" % {cost, salt64, digest64}\nend))"}},{"id":"to_slice(*args,**options)-instance-method","html_id":"to_slice(*args,**options)-instance-method","name":"to_slice","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","source_link":null,"def":{"name":"to_slice","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_s.to_slice(*args, **options)"}},{"id":"to_slice(*args,**options,&block)-instance-method","html_id":"to_slice(*args,**options,&amp;block)-instance-method","name":"to_slice","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &block)","source_link":null,"def":{"name":"to_slice","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_s.to_slice(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}}],"macros":[],"types":[{"html_id":"/Crypto/Bcrypt/Error","path":"Crypto/Bcrypt/Error.html","kind":"class","full_name":"Crypto::Bcrypt::Error","name":"Error","abstract":false,"superclass":{"html_id":"/Exception","kind":"class","full_name":"Exception","name":"Exception"},"ancestors":[{"html_id":"/Exception","kind":"class","full_name":"Exception","name":"Exception"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crypto/Bcrypt","kind":"class","full_name":"Crypto::Bcrypt","name":"Bcrypt"},"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"/Crypto/Bcrypt/Password","path":"Crypto/Bcrypt/Password.html","kind":"class","full_name":"Crypto::Bcrypt::Password","name":"Password","abstract":false,"superclass":{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crypto/Bcrypt","kind":"class","full_name":"Crypto::Bcrypt","name":"Bcrypt"},"doc":"Generate, read and verify `Crypto::Bcrypt` hashes.\n\n```\nrequire \"crypto/bcrypt/password\"\n\npassword = Crypto::Bcrypt::Password.create(\"super secret\", cost: 10)\n# => $2a$10$rI4xRiuAN2fyiKwynO6PPuorfuoM4L2PVv6hlnVJEmNLjqcibAfHq\n\npassword.verify(\"wrong secret\") # => false\npassword.verify(\"super secret\") # => true\n```\n\nSee `Crypto::Bcrypt` for hints to select the cost when generating hashes.","summary":"<p>Generate, read and verify <code><a href=\"../../Crypto/Bcrypt.html\">Crypto::Bcrypt</a></code> hashes.</p>","class_methods":[],"constructors":[{"id":"create(password,cost=DEFAULT_COST):self-class-method","html_id":"create(password,cost=DEFAULT_COST):self-class-method","name":"create","doc":"Hashes a password.\n\n```\nrequire \"crypto/bcrypt/password\"\n\npassword = Crypto::Bcrypt::Password.create(\"super secret\", cost: 10)\n# => $2a$10$rI4xRiuAN2fyiKwynO6PPuorfuoM4L2PVv6hlnVJEmNLjqcibAfHq\n```","summary":"<p>Hashes a password.</p>","abstract":false,"args":[{"name":"password","doc":null,"default_value":"","external_name":"password","restriction":""},{"name":"cost","doc":null,"default_value":"DEFAULT_COST","external_name":"cost","restriction":""}],"args_string":"(password, cost = <span class=\"t\">DEFAULT_COST</span>) : <span class=\"k\">self</span>","source_link":null,"def":{"name":"create","args":[{"name":"password","doc":null,"default_value":"","external_name":"password","restriction":""},{"name":"cost","doc":null,"default_value":"DEFAULT_COST","external_name":"cost","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"self","visibility":"Public","body":"new((Bcrypt.hash_secret(password, cost)).to_s)"}},{"id":"new(raw_hash:String)-class-method","html_id":"new(raw_hash:String)-class-method","name":"new","doc":"Loads a bcrypt hash.\n\n```\nrequire \"crypto/bcrypt/password\"\n\npassword = Crypto::Bcrypt::Password.new(\"$2a$10$X6rw/jDiLBuzHV./JjBNXe8/Po4wTL0fhdDNdAdjcKN/Fup8tGCya\")\npassword.version # => \"2a\"\npassword.salt    # => \"X6rw/jDiLBuzHV./JjBNXe\"\npassword.digest  # => \"8/Po4wTL0fhdDNdAdjcKN/Fup8tGCya\"\n```","summary":"<p>Loads a bcrypt hash.</p>","abstract":false,"args":[{"name":"raw_hash","doc":null,"default_value":"","external_name":"raw_hash","restriction":"String"}],"args_string":"(raw_hash : String)","source_link":null,"def":{"name":"new","args":[{"name":"raw_hash","doc":null,"default_value":"","external_name":"raw_hash","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(raw_hash)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"==(password:String):Bool-instance-method","html_id":"==(password:String):Bool-instance-method","name":"==","doc":null,"summary":"<p><span class=\"flag red\">DEPRECATED</span>  Use <code><a href=\"../../Crypto/Bcrypt/Password.html#verify(password:String):Bool-instance-method\">Crypto::Bcrypt::Password#verify</a></code></p>\n\n","abstract":false,"args":[{"name":"password","doc":null,"default_value":"","external_name":"password","restriction":"String"}],"args_string":"(password : String) : Bool","source_link":null,"def":{"name":"==","args":[{"name":"password","doc":null,"default_value":"","external_name":"password","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"verify(password)"}},{"id":"cost:Int32-instance-method","html_id":"cost:Int32-instance-method","name":"cost","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Int32","source_link":null,"def":{"name":"cost","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":"@cost"}},{"id":"digest:String-instance-method","html_id":"digest:String-instance-method","name":"digest","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : String","source_link":null,"def":{"name":"digest","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"@digest"}},{"id":"inspect(io:IO):Nil-instance-method","html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Appends a String representation of this object\nwhich includes its class name, its object address\nand the values of all instance variables.\n\n```\nclass Person\n  def initialize(@name : String, @age : Int32)\n  end\nend\n\nPerson.new(\"John\", 32).inspect # => #<Person:0x10fd31f20 @name=\"John\", @age=32>\n```","summary":"<p>Appends a String representation of this object which includes its class name, its object address and the values of all instance variables.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"inspect","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"to_s(io)"}},{"id":"salt:String-instance-method","html_id":"salt:String-instance-method","name":"salt","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : String","source_link":null,"def":{"name":"salt","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"@salt"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Appends a short String representation of this object\nwhich includes its class name and its object address.\n\n```\nclass Person\n  def initialize(@name : String, @age : Int32)\n  end\nend\n\nPerson.new(\"John\", 32).to_s # => #<Person:0x10a199f20>\n```","summary":"<p>Appends a short String representation of this object which includes its class name and its object address.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","source_link":null,"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << @raw_hash"}},{"id":"verify(password:String):Bool-instance-method","html_id":"verify(password:String):Bool-instance-method","name":"verify","doc":"Verifies a password against the hash.\n\n```\nrequire \"crypto/bcrypt/password\"\n\npassword = Crypto::Bcrypt::Password.create(\"super secret\")\npassword.verify(\"wrong secret\") # => false\npassword.verify(\"super secret\") # => true\n```","summary":"<p>Verifies a password against the hash.</p>","abstract":false,"args":[{"name":"password","doc":null,"default_value":"","external_name":"password","restriction":"String"}],"args_string":"(password : String) : Bool","source_link":null,"def":{"name":"verify","args":[{"name":"password","doc":null,"default_value":"","external_name":"password","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"hashed_password = Bcrypt.new(password, salt, cost)\nCrypto::Subtle.constant_time_compare(@raw_hash, hashed_password)\n"}},{"id":"version:String-instance-method","html_id":"version:String-instance-method","name":"version","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : String","source_link":null,"def":{"name":"version","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"@version"}}],"macros":[],"types":[]}]},{"html_id":"/Crypto/Blowfish","path":"Crypto/Blowfish.html","kind":"class","full_name":"Crypto::Blowfish","name":"Blowfish","abstract":false,"superclass":{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[{"id":"DEFAULT_ROUNDS","name":"DEFAULT_ROUNDS","value":"16","doc":null,"summary":null}],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crypto","kind":"module","full_name":"Crypto","name":"Crypto"},"doc":null,"summary":null,"class_methods":[],"constructors":[{"id":"new(rounds=DEFAULT_ROUNDS)-class-method","html_id":"new(rounds=DEFAULT_ROUNDS)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"rounds","doc":null,"default_value":"DEFAULT_ROUNDS","external_name":"rounds","restriction":""}],"args_string":"(rounds = <span class=\"t\">DEFAULT_ROUNDS</span>)","source_link":null,"def":{"name":"new","args":[{"name":"rounds","doc":null,"default_value":"DEFAULT_ROUNDS","external_name":"rounds","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(rounds)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"decrypt_pair(l:UInt32,r:UInt32)-instance-method","html_id":"decrypt_pair(l:UInt32,r:UInt32)-instance-method","name":"decrypt_pair","doc":null,"summary":null,"abstract":false,"args":[{"name":"l","doc":null,"default_value":"","external_name":"l","restriction":"UInt32"},{"name":"r","doc":null,"default_value":"","external_name":"r","restriction":"UInt32"}],"args_string":"(l : UInt32, r : UInt32)","source_link":null,"def":{"name":"decrypt_pair","args":[{"name":"l","doc":null,"default_value":"","external_name":"l","restriction":"UInt32"},{"name":"r","doc":null,"default_value":"","external_name":"r","restriction":"UInt32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(@rounds + 1).downto(2) do |i|\n  l = l ^ @p.to_unsafe[i]\n  r = r ^ (f(l))\n  l, r = r, l\nend\nl, r = r, l\nr = r ^ @p.to_unsafe[1]\nl = l ^ @p.to_unsafe[0]\n{l, r}\n"}},{"id":"encrypt_pair(l:UInt32,r:UInt32)-instance-method","html_id":"encrypt_pair(l:UInt32,r:UInt32)-instance-method","name":"encrypt_pair","doc":null,"summary":null,"abstract":false,"args":[{"name":"l","doc":null,"default_value":"","external_name":"l","restriction":"UInt32"},{"name":"r","doc":null,"default_value":"","external_name":"r","restriction":"UInt32"}],"args_string":"(l : UInt32, r : UInt32)","source_link":null,"def":{"name":"encrypt_pair","args":[{"name":"l","doc":null,"default_value":"","external_name":"l","restriction":"UInt32"},{"name":"r","doc":null,"default_value":"","external_name":"r","restriction":"UInt32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"0.upto(@rounds - 1) do |i|\n  l = l ^ @p.to_unsafe[i]\n  r = r ^ (f(l))\n  l, r = r, l\nend\nl, r = r, l\nr = r ^ @p.to_unsafe[@rounds]\nl = l ^ @p.to_unsafe[@rounds + 1]\n{l, r}\n"}},{"id":"expand_key(key)-instance-method","html_id":"expand_key(key)-instance-method","name":"expand_key","doc":null,"summary":null,"abstract":false,"args":[{"name":"key","doc":null,"default_value":"","external_name":"key","restriction":""}],"args_string":"(key)","source_link":null,"def":{"name":"expand_key","args":[{"name":"key","doc":null,"default_value":"","external_name":"key","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"pos = 0\n0.upto(17) do |i|\n  __temp_26 = i\n  __temp_27 = @p.to_unsafe\n  __temp_27[__temp_26] = __temp_27[__temp_26] ^ (next_word(key, pointerof(pos)))\nend\nl, r = 0_u32, 0_u32\n(0..17).step(2) do |i|\n  l, r = encrypt_pair(l, r)\n  @p.to_unsafe[i] = l\n  @p.to_unsafe[i + 1] = r\nend\n(0..1023).step(2) do |i|\n  l, r = encrypt_pair(l, r)\n  @s.to_unsafe[i] = l\n  @s.to_unsafe[i + 1] = r\nend\n"}}],"macros":[],"types":[]},{"html_id":"/Crypto/Subtle","path":"Crypto/Subtle.html","kind":"module","full_name":"Crypto::Subtle","name":"Subtle","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crypto","kind":"module","full_name":"Crypto","name":"Crypto"},"doc":null,"summary":null,"class_methods":[{"id":"constant_time_byte_eq(x,y)-class-method","html_id":"constant_time_byte_eq(x,y)-class-method","name":"constant_time_byte_eq","doc":null,"summary":null,"abstract":false,"args":[{"name":"x","doc":null,"default_value":"","external_name":"x","restriction":""},{"name":"y","doc":null,"default_value":"","external_name":"y","restriction":""}],"args_string":"(x, y)","source_link":null,"def":{"name":"constant_time_byte_eq","args":[{"name":"x","doc":null,"default_value":"","external_name":"x","restriction":""},{"name":"y","doc":null,"default_value":"","external_name":"y","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"z = ~(x ^ y)\nz = z & (z >> 4)\nz = z & (z >> 2)\nz = z & (z >> 1)\nz\n"}},{"id":"constant_time_compare(x,y):Bool-class-method","html_id":"constant_time_compare(x,y):Bool-class-method","name":"constant_time_compare","doc":"Compares *x* and *y* in constant time and returns `true` if they are the same, and `false` if they are not.\n\n```\nrequire \"crypto/subtle\"\n\nCrypto::Subtle.constant_time_compare(\"foo\", \"bar\") # => false\nCrypto::Subtle.constant_time_compare(\"foo\", \"foo\") # => true\n```\n\nNOTE: *x* and *y* must be able to respond to `to_slice`.","summary":"<p>Compares <em>x</em> and <em>y</em> in constant time and returns <code>true</code> if they are the same, and <code>false</code> if they are not.</p>","abstract":false,"args":[{"name":"x","doc":null,"default_value":"","external_name":"x","restriction":""},{"name":"y","doc":null,"default_value":"","external_name":"y","restriction":""}],"args_string":"(x, y) : Bool","source_link":null,"def":{"name":"constant_time_compare","args":[{"name":"x","doc":null,"default_value":"","external_name":"x","restriction":""},{"name":"y","doc":null,"default_value":"","external_name":"y","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"x = x.to_slice\ny = y.to_slice\nif x.size != y.size\n  return false\nend\nv = 0_u8\nx.size.times do |i|\n  v = v | (x[i] ^ y[i])\nend\n(constant_time_byte_eq(v, 0)) == 1\n"}}],"constructors":[],"instance_methods":[],"macros":[],"types":[]}]},{"html_id":"/Crystal","path":"Crystal.html","kind":"module","full_name":"Crystal","name":"Crystal","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":null,"summary":null,"class_methods":[{"id":"main(&block)-class-method","html_id":"main(&amp;block)-class-method","name":"main","doc":"Defines the main routine run by normal Crystal programs:\n\n- Initializes the GC\n- Invokes the given *block*\n- Handles unhandled exceptions\n- Invokes `at_exit` handlers\n- Flushes `STDOUT` and `STDERR`\n\nThis method can be invoked if you need to define a custom\nmain (as in C main) function, doing all the above steps.\n\nFor example:\n\n```\nfun main(argc : Int32, argv : UInt8**) : Int32\n  Crystal.main do\n    elapsed = Time.measure do\n      Crystal.main_user_code(argc, argv)\n    end\n    puts \"Time to execute program: #{elapsed}\"\n  end\nend\n```\n\nNote that the above is really just an example, almost the\nsame can be accomplished with `at_exit`. But in some cases\nredefinition of C's main is needed.","summary":"<p>Defines the main routine run by normal Crystal programs:</p>","abstract":false,"args":[],"args_string":"(&block)","source_link":null,"def":{"name":"main","args":[],"double_splat":null,"splat_index":null,"yields":0,"block_arg":null,"return_type":"","visibility":"Public","body":"GC.init\nstatus = begin\n  yield\n  0\nrescue ex\n  1\nend\nif ex\n  AtExitHandlers.exception = ex\nend\nstatus = AtExitHandlers.run(status)\nSTDOUT.flush\nSTDERR.flush\nstatus\n"}},{"id":"main(argc:Int32,argv:Pointer(Pointer(UInt8)))-class-method","html_id":"main(argc:Int32,argv:Pointer(Pointer(UInt8)))-class-method","name":"main","doc":"Main method run by all Crystal programs at startup.\n\nThis setups up the GC, invokes your program, rescuing\nany handled exception, and then runs `at_exit` handlers.\n\nThis method is automatically invoked for you, so you\ndon't need to invoke it.\n\nHowever, if you need to define a special main C function,\nyou can redefine main and invoke `Crystal.main` from it:\n\n```\nfun main(argc : Int32, argv : UInt8**) : Int32\n  # some setup before Crystal main\n  Crystal.main(argc, argv)\n  # some cleanup logic after Crystal main\nend\n```\n\nThe `Crystal.main` can also be passed as a callback:\n\n```\nfun main(argc : Int32, argv : UInt8**) : Int32\n  LibFoo.init_foo_and_invoke_main(argc, argv, ->Crystal.main)\nend\n```\n\nNote that before `Crystal.main` is invoked the GC\nis not setup yet, so nothing that allocates memory\nin Crystal (like `new` for classes) can be used.","summary":"<p>Main method run by all Crystal programs at startup.</p>","abstract":false,"args":[{"name":"argc","doc":null,"default_value":"","external_name":"argc","restriction":"Int32"},{"name":"argv","doc":null,"default_value":"","external_name":"argv","restriction":"::Pointer(::Pointer(UInt8))"}],"args_string":"(argc : Int32, argv : Pointer(Pointer(UInt8)))","source_link":null,"def":{"name":"main","args":[{"name":"argc","doc":null,"default_value":"","external_name":"argc","restriction":"Int32"},{"name":"argv","doc":null,"default_value":"","external_name":"argv","restriction":"::Pointer(::Pointer(UInt8))"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"main do\n  main_user_code(argc, argv)\nend"}},{"id":"main_user_code(argc:Int32,argv:Pointer(Pointer(UInt8)))-class-method","html_id":"main_user_code(argc:Int32,argv:Pointer(Pointer(UInt8)))-class-method","name":"main_user_code","doc":"Executes the main user code. This normally is executed\nafter initializing the GC and before executing `at_exit` handlers.\n\nYou should never invoke this method unless you need to\nredefine C's main function. See `Crystal.main` for\nmore details.","summary":"<p>Executes the main user code.</p>","abstract":false,"args":[{"name":"argc","doc":null,"default_value":"","external_name":"argc","restriction":"Int32"},{"name":"argv","doc":null,"default_value":"","external_name":"argv","restriction":"::Pointer(::Pointer(UInt8))"}],"args_string":"(argc : Int32, argv : Pointer(Pointer(UInt8)))","source_link":null,"def":{"name":"main_user_code","args":[{"name":"argc","doc":null,"default_value":"","external_name":"argc","restriction":"Int32"},{"name":"argv","doc":null,"default_value":"","external_name":"argv","restriction":"::Pointer(::Pointer(UInt8))"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibCrystalMain.__crystal_main(argc, argv)"}}],"constructors":[],"instance_methods":[],"macros":[],"types":[{"html_id":"/Crystal/EventLoop","path":"Crystal/EventLoop.html","kind":"module","full_name":"Crystal::EventLoop","name":"EventLoop","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal","kind":"module","full_name":"Crystal","name":"Crystal"},"doc":null,"summary":null,"class_methods":[{"id":"after_fork-class-method","html_id":"after_fork-class-method","name":"after_fork","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"after_fork","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Thread.current.event_base.reinit"}},{"id":"create_fd_read_event(io:IO::Evented,edge_triggered:Bool=false)-class-method","html_id":"create_fd_read_event(io:IO::Evented,edge_triggered:Bool=false)-class-method","name":"create_fd_read_event","doc":null,"summary":null,"abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO::Evented"},{"name":"edge_triggered","doc":null,"default_value":"false","external_name":"edge_triggered","restriction":"Bool"}],"args_string":"(io : IO::Evented, edge_triggered : Bool = <span class=\"n\">false</span>)","source_link":null,"def":{"name":"create_fd_read_event","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO::Evented"},{"name":"edge_triggered","doc":null,"default_value":"false","external_name":"edge_triggered","restriction":"Bool"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"flags = LibEvent2::EventFlags::Read\nif edge_triggered\n  flags = flags | (LibEvent2::EventFlags::Persist | LibEvent2::EventFlags::ET)\nend\nevent_base.new_event(io.fd, flags, io) do |s, flags, data|\n  io_ref = data.as(typeof(io))\n  if flags.includes?(LibEvent2::EventFlags::Read)\n    io_ref.resume_read\n  else\n    if flags.includes?(LibEvent2::EventFlags::Timeout)\n      io_ref.resume_read(timed_out: true)\n    end\n  end\nend\n"}},{"id":"create_fd_write_event(io:IO::Evented,edge_triggered:Bool=false)-class-method","html_id":"create_fd_write_event(io:IO::Evented,edge_triggered:Bool=false)-class-method","name":"create_fd_write_event","doc":null,"summary":null,"abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO::Evented"},{"name":"edge_triggered","doc":null,"default_value":"false","external_name":"edge_triggered","restriction":"Bool"}],"args_string":"(io : IO::Evented, edge_triggered : Bool = <span class=\"n\">false</span>)","source_link":null,"def":{"name":"create_fd_write_event","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO::Evented"},{"name":"edge_triggered","doc":null,"default_value":"false","external_name":"edge_triggered","restriction":"Bool"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"flags = LibEvent2::EventFlags::Write\nif edge_triggered\n  flags = flags | (LibEvent2::EventFlags::Persist | LibEvent2::EventFlags::ET)\nend\nevent_base.new_event(io.fd, flags, io) do |s, flags, data|\n  io_ref = data.as(typeof(io))\n  if flags.includes?(LibEvent2::EventFlags::Write)\n    io_ref.resume_write\n  else\n    if flags.includes?(LibEvent2::EventFlags::Timeout)\n      io_ref.resume_write(timed_out: true)\n    end\n  end\nend\n"}},{"id":"create_resume_event(fiber)-class-method","html_id":"create_resume_event(fiber)-class-method","name":"create_resume_event","doc":null,"summary":null,"abstract":false,"args":[{"name":"fiber","doc":null,"default_value":"","external_name":"fiber","restriction":""}],"args_string":"(fiber)","source_link":null,"def":{"name":"create_resume_event","args":[{"name":"fiber","doc":null,"default_value":"","external_name":"fiber","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"event_base.new_event(-1, LibEvent2::EventFlags::None, fiber) do |s, flags, data|\n  Crystal::Scheduler.enqueue(data.as(Fiber))\nend"}},{"id":"run_once-class-method","html_id":"run_once-class-method","name":"run_once","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","source_link":null,"def":{"name":"run_once","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Thread.current.event_base.run_once"}}],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"/Crystal/Macros","path":"Crystal/Macros.html","kind":"module","full_name":"Crystal::Macros","name":"Macros","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal","kind":"module","full_name":"Crystal","name":"Crystal"},"doc":"The `Macros` module is a fictitious module used to document macros\nand macro methods.\n\nYou can invoke a **fixed subset** of methods on AST nodes at compile-time. These methods\nare documented on the classes in this module. Additionally, methods of the\n`Macros` module are top-level methods that you can invoke, like `puts` and `run`.","summary":"<p>The <code><a href=\"../Crystal/Macros.html\">Macros</a></code> module is a fictitious module used to document macros and macro methods.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"`(command):MacroId-instance-method","html_id":"`(command):MacroId-instance-method","name":"`","doc":"Executes a system command and returns the output as a `MacroId`.\nGives a compile-time error if the command failed to execute.","summary":"<p>Executes a system command and returns the output as a <code><a href=\"../Crystal/Macros/MacroId.html\">MacroId</a></code>.</p>","abstract":false,"args":[{"name":"command","doc":null,"default_value":"","external_name":"command","restriction":""}],"args_string":"(command) : MacroId","source_link":null,"def":{"name":"`","args":[{"name":"command","doc":null,"default_value":"","external_name":"command","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"compare_versions(v1:StringLiteral,v2:StringLiteral):NumberLiteral-instance-method","html_id":"compare_versions(v1:StringLiteral,v2:StringLiteral):NumberLiteral-instance-method","name":"compare_versions","doc":"Compares two [semantic versions](http://semver.org/).\n\nReturns `-1`, `0` or `1` depending on whether *v1* is lower than *v2*,\nequal to *v2* or greater than *v2*.\n\n```\n{{ compare_versions(\"1.10.0\", \"1.2.0\") }} # => 1\n```","summary":"<p>Compares two <a href=\"http://semver.org/\" target=\"_blank\">semantic versions</a>.</p>","abstract":false,"args":[{"name":"v1","doc":null,"default_value":"","external_name":"v1","restriction":"StringLiteral"},{"name":"v2","doc":null,"default_value":"","external_name":"v2","restriction":"StringLiteral"}],"args_string":"(v1 : StringLiteral, v2 : StringLiteral) : NumberLiteral","source_link":null,"def":{"name":"compare_versions","args":[{"name":"v1","doc":null,"default_value":"","external_name":"v1","restriction":"StringLiteral"},{"name":"v2","doc":null,"default_value":"","external_name":"v2","restriction":"StringLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral","visibility":"Public","body":""}},{"id":"debug(format=true):Nop-instance-method","html_id":"debug(format=true):Nop-instance-method","name":"debug","doc":"Outputs the current macro's buffer to the standard output. Useful for debugging\na macro to see what's being generated.\n\nBy default, the output is tried to be formatted using Crystal's\nformatter, but you can disable this by passing `false` to this method.","summary":"<p>Outputs the current macro's buffer to the standard output.</p>","abstract":false,"args":[{"name":"format","doc":null,"default_value":"true","external_name":"format","restriction":""}],"args_string":"(format = <span class=\"n\">true</span>) : Nop","source_link":null,"def":{"name":"debug","args":[{"name":"format","doc":null,"default_value":"true","external_name":"format","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nop","visibility":"Public","body":""}},{"id":"env(name):StringLiteral|NilLiteral-instance-method","html_id":"env(name):StringLiteral|NilLiteral-instance-method","name":"env","doc":"Gets the value of an environment variable at compile-time, or `nil` if it doesn't exist.","summary":"<p>Gets the value of an environment variable at compile-time, or <code>nil</code> if it doesn't exist.</p>","abstract":false,"args":[{"name":"name","doc":null,"default_value":"","external_name":"name","restriction":""}],"args_string":"(name) : StringLiteral | NilLiteral","source_link":null,"def":{"name":"env","args":[{"name":"name","doc":null,"default_value":"","external_name":"name","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral | NilLiteral","visibility":"Public","body":""}},{"id":"flag?(name):BoolLiteral-instance-method","html_id":"flag?(name):BoolLiteral-instance-method","name":"flag?","doc":"Returns whether a [compile-time flag](https://crystal-lang.org/docs/syntax_and_semantics/compile_time_flags.html) is set.\n\n```\n{{ flag?(:x86_64) }} # true or false\n```","summary":"<p>Returns whether a <a href=\"https://crystal-lang.org/docs/syntax_and_semantics/compile_time_flags.html\" target=\"_blank\">compile-time flag</a> is set.</p>","abstract":false,"args":[{"name":"name","doc":null,"default_value":"","external_name":"name","restriction":""}],"args_string":"(name) : BoolLiteral","source_link":null,"def":{"name":"flag?","args":[{"name":"name","doc":null,"default_value":"","external_name":"name","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"p(*expressions):Nop-instance-method","html_id":"p(*expressions):Nop-instance-method","name":"p","doc":"Same as `puts`.","summary":"<p>Same as <code><a href=\"../Crystal/Macros.html#puts(*expressions):Nop-instance-method\">#puts</a></code>.</p>","abstract":false,"args":[{"name":"expressions","doc":null,"default_value":"","external_name":"expressions","restriction":""}],"args_string":"(*expressions) : Nop","source_link":null,"def":{"name":"p","args":[{"name":"expressions","doc":null,"default_value":"","external_name":"expressions","restriction":""}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"Nop","visibility":"Public","body":""}},{"id":"p!(*expressions):Nop-instance-method","html_id":"p!(*expressions):Nop-instance-method","name":"p!","doc":"Prints macro expressions together with their values at compile-time. Useful for debugging macros.","summary":"<p>Prints macro expressions together with their values at compile-time.</p>","abstract":false,"args":[{"name":"expressions","doc":null,"default_value":"","external_name":"expressions","restriction":""}],"args_string":"(*expressions) : Nop","source_link":null,"def":{"name":"p!","args":[{"name":"expressions","doc":null,"default_value":"","external_name":"expressions","restriction":""}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"Nop","visibility":"Public","body":""}},{"id":"pp(*expressions):Nop-instance-method","html_id":"pp(*expressions):Nop-instance-method","name":"pp","doc":"Same as `puts`.","summary":"<p>Same as <code><a href=\"../Crystal/Macros.html#puts(*expressions):Nop-instance-method\">#puts</a></code>.</p>","abstract":false,"args":[{"name":"expressions","doc":null,"default_value":"","external_name":"expressions","restriction":""}],"args_string":"(*expressions) : Nop","source_link":null,"def":{"name":"pp","args":[{"name":"expressions","doc":null,"default_value":"","external_name":"expressions","restriction":""}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"Nop","visibility":"Public","body":""}},{"id":"pp!(*expressions):Nop-instance-method","html_id":"pp!(*expressions):Nop-instance-method","name":"pp!","doc":"Same as `p!`","summary":"<p>Same as <code><a href=\"../Crystal/Macros.html#p!(*expressions):Nop-instance-method\">#p!</a></code></p>","abstract":false,"args":[{"name":"expressions","doc":null,"default_value":"","external_name":"expressions","restriction":""}],"args_string":"(*expressions) : Nop","source_link":null,"def":{"name":"pp!","args":[{"name":"expressions","doc":null,"default_value":"","external_name":"expressions","restriction":""}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"Nop","visibility":"Public","body":""}},{"id":"puts(*expressions):Nop-instance-method","html_id":"puts(*expressions):Nop-instance-method","name":"puts","doc":"Prints AST nodes at compile-time. Useful for debugging macros.","summary":"<p>Prints AST nodes at compile-time.</p>","abstract":false,"args":[{"name":"expressions","doc":null,"default_value":"","external_name":"expressions","restriction":""}],"args_string":"(*expressions) : Nop","source_link":null,"def":{"name":"puts","args":[{"name":"expressions","doc":null,"default_value":"","external_name":"expressions","restriction":""}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"Nop","visibility":"Public","body":""}},{"id":"raise(message):NoReturn-instance-method","html_id":"raise(message):NoReturn-instance-method","name":"raise","doc":"Gives a compile-time error with the given *message*.","summary":"<p>Gives a compile-time error with the given <em>message</em>.</p>","abstract":false,"args":[{"name":"message","doc":null,"default_value":"","external_name":"message","restriction":""}],"args_string":"(message) : NoReturn","source_link":null,"def":{"name":"raise","args":[{"name":"message","doc":null,"default_value":"","external_name":"message","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NoReturn","visibility":"Public","body":""}},{"id":"read_file(filename):StringLiteral-instance-method","html_id":"read_file(filename):StringLiteral-instance-method","name":"read_file","doc":"Reads a file and returns a `StringLiteral` with its contents.\n\nGives a compile-time error if the file doesn't exist or if\nreading the file fails.\n\nTo read a file relative to where the macro is defined, use:\n\n```\nread_file(\"#{__DIR__}/some_file.txt\")\n```\n\nNOTE: Relative paths are resolved to the current working directory.","summary":"<p>Reads a file and returns a <code><a href=\"../Crystal/Macros/StringLiteral.html\">StringLiteral</a></code> with its contents.</p>","abstract":false,"args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":""}],"args_string":"(filename) : StringLiteral","source_link":null,"def":{"name":"read_file","args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral","visibility":"Public","body":""}},{"id":"read_file?(filename):StringLiteral|NilLiteral-instance-method","html_id":"read_file?(filename):StringLiteral|NilLiteral-instance-method","name":"read_file?","doc":"Same as `read_file`, except that `nil` is returned on any I/O failure\ninstead of issuing a compile-time failure.","summary":"<p>Same as <code><a href=\"../Crystal/Macros.html#read_file(filename):StringLiteral-instance-method\">#read_file</a></code>, except that <code>nil</code> is returned on any I/O failure instead of issuing a compile-time failure.</p>","abstract":false,"args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":""}],"args_string":"(filename) : StringLiteral | NilLiteral","source_link":null,"def":{"name":"read_file?","args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral | NilLiteral","visibility":"Public","body":""}},{"id":"run(filename,*args):MacroId-instance-method","html_id":"run(filename,*args):MacroId-instance-method","name":"run","doc":"Compiles and execute a Crystal program and returns its output\nas a `MacroId`.\n\nThe file denoted by *filename* must be a valid Crystal program.\nThis macro invocation passes *args* to the program as regular\nprogram arguments. The program must output a valid Crystal expression.\nThis output is the result of this macro invocation, as a `MacroId`.\n\nThe `run` macro is useful when the subset of available macro methods\nare not enough for your purposes and you need something more powerful.\nWith `run` you can read files at compile time, connect to the internet\nor to a database.\n\nA simple example:\n\n```\n# read.cr\nputs File.read(ARGV[0])\n```\n\n```\n# main.cr\nmacro read_file_at_compile_time(filename)\n  {{ run(\"./read\", filename).stringify }}\nend\n\nputs read_file_at_compile_time(\"some_file.txt\")\n```\n\nThe above generates a program that will have the contents of `some_file.txt`.\nThe file, however, is read at compile time and will not be needed at runtime.\n\nNOTE: the compiler is allowed to cache the executable generated for\n*filename* and only recompile it if any of the files it depends on changes\n(their modified time). This is why it's **strongly discouraged** to use a program\nfor `run` that changes in subsequent compilations (for example, if it executes\nshell commands at compile time, or other macro run programs). It's also strongly\ndiscouraged to have a macro run program take a lot of time, because this will\nslow down compilation times. Reading files is OK, opening an HTTP connection\nat compile-time will most likely result in very slow compilations.","summary":"<p>Compiles and execute a Crystal program and returns its output as a <code><a href=\"../Crystal/Macros/MacroId.html\">MacroId</a></code>.</p>","abstract":false,"args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":""},{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(filename, *args) : MacroId","source_link":null,"def":{"name":"run","args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":""},{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":null,"splat_index":1,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"skip_file:Nop-instance-method","html_id":"skip_file:Nop-instance-method","name":"skip_file","doc":"Skips the rest of the file from which it is executed.\nTypical usage is to skip files that have platform specific code,\nwithout having to surround the most relevant code in `{% if flag?(...) %} ... {% end %}` macro blocks.\n\nExample:\n\n```\n# sth_for_osx.cr\n{% skip_file unless flag?(:darwin) %}\n\n# Class FooForMac will only be defined if we're compiling on OS X\nclass FooForMac\nend\n```","summary":"<p>Skips the rest of the file from which it is executed.</p>","abstract":false,"args":[],"args_string":" : Nop","source_link":null,"def":{"name":"skip_file","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nop","visibility":"Public","body":""}},{"id":"system(command):MacroId-instance-method","html_id":"system(command):MacroId-instance-method","name":"system","doc":"Executes a system command and returns the output as a `MacroId`.\nGives a compile-time error if the command failed to execute.","summary":"<p>Executes a system command and returns the output as a <code><a href=\"../Crystal/Macros/MacroId.html\">MacroId</a></code>.</p>","abstract":false,"args":[{"name":"command","doc":null,"default_value":"","external_name":"command","restriction":""}],"args_string":"(command) : MacroId","source_link":null,"def":{"name":"system","args":[{"name":"command","doc":null,"default_value":"","external_name":"command","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}}],"macros":[],"types":[{"html_id":"/Crystal/Macros/And","path":"Crystal/Macros/And.html","kind":"class","full_name":"Crystal::Macros::And","name":"And","abstract":false,"superclass":{"html_id":"/Crystal/Macros/BinaryOp","kind":"class","full_name":"Crystal::Macros::BinaryOp","name":"BinaryOp"},"ancestors":[{"html_id":"/Crystal/Macros/BinaryOp","kind":"class","full_name":"Crystal::Macros::BinaryOp","name":"BinaryOp"},{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"An `&&` (and) expression","summary":"<p>An <code>&&</code> (and) expression</p>","class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/Annotation","path":"Crystal/Macros/Annotation.html","kind":"class","full_name":"Crystal::Macros::Annotation","name":"Annotation","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"An annotation on top of a type or variable.","summary":"<p>An annotation on top of a type or variable.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"[](index:NumberLiteral):ASTNode-instance-method","html_id":"[](index:NumberLiteral):ASTNode-instance-method","name":"[]","doc":"Returns the value of a positional argument,\nor NilLiteral if out of bounds.","summary":"<p>Returns the value of a positional argument, or NilLiteral if out of bounds.</p>","abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"NumberLiteral"}],"args_string":"(index : NumberLiteral) : ASTNode","source_link":null,"def":{"name":"[]","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"NumberLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"[](name:SymbolLiteral|StringLiteral|MacroId):ASTNode-instance-method","html_id":"[](name:SymbolLiteral|StringLiteral|MacroId):ASTNode-instance-method","name":"[]","doc":"Returns the value of a named argument,\nor NilLiteral if the named argument isn't\nused on `self`.","summary":"<p>Returns the value of a named argument, or NilLiteral if the named argument isn't used on <code>self</code>.</p>","abstract":false,"args":[{"name":"name","doc":null,"default_value":"","external_name":"name","restriction":"SymbolLiteral | StringLiteral | MacroId"}],"args_string":"(name : SymbolLiteral | StringLiteral | MacroId) : ASTNode","source_link":null,"def":{"name":"[]","args":[{"name":"name","doc":null,"default_value":"","external_name":"name","restriction":"SymbolLiteral | StringLiteral | MacroId"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"args:TupleLiteral-instance-method","html_id":"args:TupleLiteral-instance-method","name":"args","doc":"Returns a `TupleLiteral` representing the positional arguments on `self`.","summary":"<p>Returns a <code><a href=\"../../Crystal/Macros/TupleLiteral.html\">TupleLiteral</a></code> representing the positional arguments on <code>self</code>.</p>","abstract":false,"args":[],"args_string":" : TupleLiteral","source_link":null,"def":{"name":"args","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"TupleLiteral","visibility":"Public","body":""}},{"id":"named_args:NamedTupleLiteral-instance-method","html_id":"named_args:NamedTupleLiteral-instance-method","name":"named_args","doc":"Returns a `NamedTupleLiteral` representing the named arguments on `self`.","summary":"<p>Returns a <code><a href=\"../../Crystal/Macros/NamedTupleLiteral.html\">NamedTupleLiteral</a></code> representing the named arguments on <code>self</code>.</p>","abstract":false,"args":[],"args_string":" : NamedTupleLiteral","source_link":null,"def":{"name":"named_args","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NamedTupleLiteral","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/Arg","path":"Crystal/Macros/Arg.html","kind":"class","full_name":"Crystal::Macros::Arg","name":"Arg","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A def argument.","summary":"<p>A def argument.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"default_value:ASTNode|Nop-instance-method","html_id":"default_value:ASTNode|Nop-instance-method","name":"default_value","doc":"Returns the default value of this argument, if any.","summary":"<p>Returns the default value of this argument, if any.</p>","abstract":false,"args":[],"args_string":" : ASTNode | Nop","source_link":null,"def":{"name":"default_value","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode | Nop","visibility":"Public","body":""}},{"id":"internal_name:MacroId-instance-method","html_id":"internal_name:MacroId-instance-method","name":"internal_name","doc":"Returns the internal name of this argument.\n\nFor example, for `def write(to file)` returns `file`.","summary":"<p>Returns the internal name of this argument.</p>","abstract":false,"args":[],"args_string":" : MacroId","source_link":null,"def":{"name":"internal_name","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"name:MacroId-instance-method","html_id":"name:MacroId-instance-method","name":"name","doc":"Returns the external name of this argument.\n\nFor example, for `def write(to file)` returns `to`.","summary":"<p>Returns the external name of this argument.</p>","abstract":false,"args":[],"args_string":" : MacroId","source_link":null,"def":{"name":"name","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"restriction:ASTNode|Nop-instance-method","html_id":"restriction:ASTNode|Nop-instance-method","name":"restriction","doc":"Returns the type restriction of this argument, if any.","summary":"<p>Returns the type restriction of this argument, if any.</p>","abstract":false,"args":[],"args_string":" : ASTNode | Nop","source_link":null,"def":{"name":"restriction","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode | Nop","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/ArrayLiteral","path":"Crystal/Macros/ArrayLiteral.html","kind":"class","full_name":"Crystal::Macros::ArrayLiteral","name":"ArrayLiteral","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"An array literal.","summary":"<p>An array literal.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"+(other:ArrayLiteral):ArrayLiteral-instance-method","html_id":"+(other:ArrayLiteral):ArrayLiteral-instance-method","name":"+","doc":"Similar to `Array#+`.","summary":"<p>Similar to <code><a href=\"../../Array.html#+(other:Array(U))forallU-instance-method\">Array#+</a></code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"ArrayLiteral"}],"args_string":"(other : ArrayLiteral) : ArrayLiteral","source_link":null,"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"ArrayLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral","visibility":"Public","body":""}},{"id":"<<(value:ASTNode):ArrayLiteral-instance-method","html_id":"&lt;&lt;(value:ASTNode):ArrayLiteral-instance-method","name":"<<","doc":"Similar to `Array#<<`.","summary":"<p>Similar to <code><a href=\"../../Array.html#%3C%3C(value:T)-instance-method\">Array#<<</a></code>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"ASTNode"}],"args_string":"(value : ASTNode) : ArrayLiteral","source_link":null,"def":{"name":"<<","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"ASTNode"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral","visibility":"Public","body":""}},{"id":"[](index:NumberLiteral):ASTNode-instance-method","html_id":"[](index:NumberLiteral):ASTNode-instance-method","name":"[]","doc":"Similar to `Array#[]`, but returns `NilLiteral` on out of bounds.","summary":"<p>Similar to <code><a href=\"../../Array.html#[](start:Int,count:Int)-instance-method\">Array#[]</a></code>, but returns <code><a href=\"../../Crystal/Macros/NilLiteral.html\">NilLiteral</a></code> on out of bounds.</p>","abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"NumberLiteral"}],"args_string":"(index : NumberLiteral) : ASTNode","source_link":null,"def":{"name":"[]","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"NumberLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"[]=(index:NumberLiteral,value:ASTNode)-instance-method","html_id":"[]=(index:NumberLiteral,value:ASTNode)-instance-method","name":"[]=","doc":"Similar to `Array#[]=`.","summary":"<p>Similar to <code><a href=\"../../Array.html#[]=(range:Range,value:T)-instance-method\">Array#[]=</a></code>.</p>","abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"NumberLiteral"},{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"ASTNode"}],"args_string":"(index : NumberLiteral, value : ASTNode)","source_link":null,"def":{"name":"[]=","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"NumberLiteral"},{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"ASTNode"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":""}},{"id":"all?(&block):BoolLiteral-instance-method","html_id":"all?(&amp;block):BoolLiteral-instance-method","name":"all?","doc":"Similar to `Enumerable#all?`","summary":"<p>Similar to <code><a href=\"../../Enumerable.html#all?(&block)-instance-method\">Enumerable#all?</a></code></p>","abstract":false,"args":[],"args_string":"(&block) : BoolLiteral","source_link":null,"def":{"name":"all?","args":[],"double_splat":null,"splat_index":null,"yields":0,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"any?(&block):BoolLiteral-instance-method","html_id":"any?(&amp;block):BoolLiteral-instance-method","name":"any?","doc":"Similar to `Enumerable#any?`","summary":"<p>Similar to <code><a href=\"../../Enumerable.html#any?(&block)-instance-method\">Enumerable#any?</a></code></p>","abstract":false,"args":[],"args_string":"(&block) : BoolLiteral","source_link":null,"def":{"name":"any?","args":[],"double_splat":null,"splat_index":null,"yields":0,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"clear:ArrayLiteral-instance-method","html_id":"clear:ArrayLiteral-instance-method","name":"clear","doc":"Similar to `Array#clear`","summary":"<p>Similar to <code><a href=\"../../Array.html#clear-instance-method\">Array#clear</a></code></p>","abstract":false,"args":[],"args_string":" : ArrayLiteral","source_link":null,"def":{"name":"clear","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral","visibility":"Public","body":""}},{"id":"empty?:BoolLiteral-instance-method","html_id":"empty?:BoolLiteral-instance-method","name":"empty?","doc":"Similar to `Array#empty?`","summary":"<p>Similar to <code>Array#empty?</code></p>","abstract":false,"args":[],"args_string":" : BoolLiteral","source_link":null,"def":{"name":"empty?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"find(&block):ASTNode|NilLiteral-instance-method","html_id":"find(&amp;block):ASTNode|NilLiteral-instance-method","name":"find","doc":"Similar to `Enumerable#find`","summary":"<p>Similar to <code><a href=\"../../Enumerable.html#find(if_none=nil,&block)-instance-method\">Enumerable#find</a></code></p>","abstract":false,"args":[],"args_string":"(&block) : ASTNode | NilLiteral","source_link":null,"def":{"name":"find","args":[],"double_splat":null,"splat_index":null,"yields":0,"block_arg":null,"return_type":"ASTNode | NilLiteral","visibility":"Public","body":""}},{"id":"first:ASTNode|NilLiteral-instance-method","html_id":"first:ASTNode|NilLiteral-instance-method","name":"first","doc":"Similar to `Array#first`, but returns a `NilLiteral` if the array is empty.","summary":"<p>Similar to <code><a href=\"../../Array.html#first(n:Int)-instance-method\">Array#first</a></code>, but returns a <code><a href=\"../../Crystal/Macros/NilLiteral.html\">NilLiteral</a></code> if the array is empty.</p>","abstract":false,"args":[],"args_string":" : ASTNode | NilLiteral","source_link":null,"def":{"name":"first","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode | NilLiteral","visibility":"Public","body":""}},{"id":"includes?(node:ASTNode):BoolLiteral-instance-method","html_id":"includes?(node:ASTNode):BoolLiteral-instance-method","name":"includes?","doc":"Similar to `Enumerable#includes?(obj)`.","summary":"<p>Similar to <code><a href=\"../../Enumerable.html#includes?(obj)-instance-method\">Enumerable#includes?(obj)</a></code>.</p>","abstract":false,"args":[{"name":"node","doc":null,"default_value":"","external_name":"node","restriction":"ASTNode"}],"args_string":"(node : ASTNode) : BoolLiteral","source_link":null,"def":{"name":"includes?","args":[{"name":"node","doc":null,"default_value":"","external_name":"node","restriction":"ASTNode"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"join(separator):StringLiteral-instance-method","html_id":"join(separator):StringLiteral-instance-method","name":"join","doc":"Similar to `Enumerable#join`","summary":"<p>Similar to <code><a href=\"../../Enumerable.html#join(separator=&quot;&quot;,&block)-instance-method\">Enumerable#join</a></code></p>","abstract":false,"args":[{"name":"separator","doc":null,"default_value":"","external_name":"separator","restriction":""}],"args_string":"(separator) : StringLiteral","source_link":null,"def":{"name":"join","args":[{"name":"separator","doc":null,"default_value":"","external_name":"separator","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral","visibility":"Public","body":""}},{"id":"last:ASTNode|NilLiteral-instance-method","html_id":"last:ASTNode|NilLiteral-instance-method","name":"last","doc":"Similar to `Array#last`, but returns a `NilLiteral` if the array is empty.","summary":"<p>Similar to <code><a href=\"../../Array.html#last(n:Int)-instance-method\">Array#last</a></code>, but returns a <code><a href=\"../../Crystal/Macros/NilLiteral.html\">NilLiteral</a></code> if the array is empty.</p>","abstract":false,"args":[],"args_string":" : ASTNode | NilLiteral","source_link":null,"def":{"name":"last","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode | NilLiteral","visibility":"Public","body":""}},{"id":"map(&block):ArrayLiteral-instance-method","html_id":"map(&amp;block):ArrayLiteral-instance-method","name":"map","doc":"Similar to `Enumerable#map`","summary":"<p>Similar to <code><a href=\"../../Enumerable.html#map(&block:T-%3EU)forallU-instance-method\">Enumerable#map</a></code></p>","abstract":false,"args":[],"args_string":"(&block) : ArrayLiteral","source_link":null,"def":{"name":"map","args":[],"double_splat":null,"splat_index":null,"yields":0,"block_arg":null,"return_type":"ArrayLiteral","visibility":"Public","body":""}},{"id":"of:ASTNode|Nop-instance-method","html_id":"of:ASTNode|Nop-instance-method","name":"of","doc":"Returns the type specified at the end of the array literal, if any.\n\nThis refers to the part after brackets in `[] of String`.","summary":"<p>Returns the type specified at the end of the array literal, if any.</p>","abstract":false,"args":[],"args_string":" : ASTNode | Nop","source_link":null,"def":{"name":"of","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode | Nop","visibility":"Public","body":""}},{"id":"push(value:ASTNode):ArrayLiteral-instance-method","html_id":"push(value:ASTNode):ArrayLiteral-instance-method","name":"push","doc":"Similar to `Array#push`.","summary":"<p>Similar to <code><a href=\"../../Array.html#push(value:T)-instance-method\">Array#push</a></code>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"ASTNode"}],"args_string":"(value : ASTNode) : ArrayLiteral","source_link":null,"def":{"name":"push","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"ASTNode"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral","visibility":"Public","body":""}},{"id":"reduce(&block):ASTNode-instance-method","html_id":"reduce(&amp;block):ASTNode-instance-method","name":"reduce","doc":"Similar to `Enumerable#reduce`","summary":"<p>Similar to <code><a href=\"../../Enumerable.html#reduce(&block)-instance-method\">Enumerable#reduce</a></code></p>","abstract":false,"args":[],"args_string":"(&block) : ASTNode","source_link":null,"def":{"name":"reduce","args":[],"double_splat":null,"splat_index":null,"yields":0,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"reject(&block):ArrayLiteral-instance-method","html_id":"reject(&amp;block):ArrayLiteral-instance-method","name":"reject","doc":"Similar to `Enumerable#reject`","summary":"<p>Similar to <code><a href=\"../../Enumerable.html#reject(&block:T-%3E)-instance-method\">Enumerable#reject</a></code></p>","abstract":false,"args":[],"args_string":"(&block) : ArrayLiteral","source_link":null,"def":{"name":"reject","args":[],"double_splat":null,"splat_index":null,"yields":0,"block_arg":null,"return_type":"ArrayLiteral","visibility":"Public","body":""}},{"id":"select(&block):ArrayLiteral-instance-method","html_id":"select(&amp;block):ArrayLiteral-instance-method","name":"select","doc":"Similar to `Enumerable#select`","summary":"<p>Similar to <code><a href=\"../../Enumerable.html#select(&block:T-%3E)-instance-method\">Enumerable#select</a></code></p>","abstract":false,"args":[],"args_string":"(&block) : ArrayLiteral","source_link":null,"def":{"name":"select","args":[],"double_splat":null,"splat_index":null,"yields":0,"block_arg":null,"return_type":"ArrayLiteral","visibility":"Public","body":""}},{"id":"shuffle:ArrayLiteral-instance-method","html_id":"shuffle:ArrayLiteral-instance-method","name":"shuffle","doc":"Similar to `Array#shuffle`","summary":"<p>Similar to <code><a href=\"../../Array.html#shuffle(random=Random::DEFAULT)-instance-method\">Array#shuffle</a></code></p>","abstract":false,"args":[],"args_string":" : ArrayLiteral","source_link":null,"def":{"name":"shuffle","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral","visibility":"Public","body":""}},{"id":"size:NumberLiteral-instance-method","html_id":"size:NumberLiteral-instance-method","name":"size","doc":"Similar to `Array#size`","summary":"<p>Similar to <code><a href=\"../../Array.html#size:Int32-instance-method\">Array#size</a></code></p>","abstract":false,"args":[],"args_string":" : NumberLiteral","source_link":null,"def":{"name":"size","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral","visibility":"Public","body":""}},{"id":"sort:ArrayLiteral-instance-method","html_id":"sort:ArrayLiteral-instance-method","name":"sort","doc":"Similar to `Array#sort`","summary":"<p>Similar to <code><a href=\"../../Array.html#sort:Array(T)-instance-method\">Array#sort</a></code></p>","abstract":false,"args":[],"args_string":" : ArrayLiteral","source_link":null,"def":{"name":"sort","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral","visibility":"Public","body":""}},{"id":"sort_by(&block):ArrayLiteral-instance-method","html_id":"sort_by(&amp;block):ArrayLiteral-instance-method","name":"sort_by","doc":"Similar to `Array#sort_by`","summary":"<p>Similar to <code><a href=\"../../Array.html#sort_by(&block:T-%3EUNDERSCORE):Array(T)-instance-method\">Array#sort_by</a></code></p>","abstract":false,"args":[],"args_string":"(&block) : ArrayLiteral","source_link":null,"def":{"name":"sort_by","args":[],"double_splat":null,"splat_index":null,"yields":0,"block_arg":null,"return_type":"ArrayLiteral","visibility":"Public","body":""}},{"id":"splat(trailing_string:StringLiteral=nil):MacroId-instance-method","html_id":"splat(trailing_string:StringLiteral=nil):MacroId-instance-method","name":"splat","doc":"Returns a `MacroId` with all of this array's elements joined\nby commas.\n\nIf *trailing_string* is given, it will be appended to\nthe result unless this array is empty. This lets you\nsplat an array and optionally write a trailing comma\nif needed.","summary":"<p>Returns a <code><a href=\"../../Crystal/Macros/MacroId.html\">MacroId</a></code> with all of this array's elements joined by commas.</p>","abstract":false,"args":[{"name":"trailing_string","doc":null,"default_value":"nil","external_name":"trailing_string","restriction":"StringLiteral"}],"args_string":"(trailing_string : StringLiteral = <span class=\"n\">nil</span>) : MacroId","source_link":null,"def":{"name":"splat","args":[{"name":"trailing_string","doc":null,"default_value":"nil","external_name":"trailing_string","restriction":"StringLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"type:Path|Nop-instance-method","html_id":"type:Path|Nop-instance-method","name":"type","doc":"Returns the type that receives the items of the array.\n\nThis refers to the part before brackets in `MyArray{1, 2, 3}`","summary":"<p>Returns the type that receives the items of the array.</p>","abstract":false,"args":[],"args_string":" : Path | Nop","source_link":null,"def":{"name":"type","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Path | Nop","visibility":"Public","body":""}},{"id":"uniq:ArrayLiteral-instance-method","html_id":"uniq:ArrayLiteral-instance-method","name":"uniq","doc":"Similar to `Array#uniq`","summary":"<p>Similar to <code><a href=\"../../Array.html#uniq-instance-method\">Array#uniq</a></code></p>","abstract":false,"args":[],"args_string":" : ArrayLiteral","source_link":null,"def":{"name":"uniq","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral","visibility":"Public","body":""}},{"id":"unshift(value:ASTNode):ArrayLiteral-instance-method","html_id":"unshift(value:ASTNode):ArrayLiteral-instance-method","name":"unshift","doc":"Similar to `Array#unshift`.","summary":"<p>Similar to <code><a href=\"../../Array.html#unshift(obj:T)-instance-method\">Array#unshift</a></code>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"ASTNode"}],"args_string":"(value : ASTNode) : ArrayLiteral","source_link":null,"def":{"name":"unshift","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"ASTNode"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/Assign","path":"Crystal/Macros/Assign.html","kind":"class","full_name":"Crystal::Macros::Assign","name":"Assign","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"Assign expression.","summary":"<p>Assign expression.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"target:ASTNode-instance-method","html_id":"target:ASTNode-instance-method","name":"target","doc":"Returns the target assigned to.","summary":"<p>Returns the target assigned to.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"target","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"value:ASTNode-instance-method","html_id":"value:ASTNode-instance-method","name":"value","doc":"Returns the value that is being assigned.","summary":"<p>Returns the value that is being assigned.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"value","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/ASTNode","path":"Crystal/Macros/ASTNode.html","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode","abstract":true,"superclass":{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[{"html_id":"/Crystal/Macros/Annotation","kind":"class","full_name":"Crystal::Macros::Annotation","name":"Annotation"},{"html_id":"/Crystal/Macros/Arg","kind":"class","full_name":"Crystal::Macros::Arg","name":"Arg"},{"html_id":"/Crystal/Macros/ArrayLiteral","kind":"class","full_name":"Crystal::Macros::ArrayLiteral","name":"ArrayLiteral"},{"html_id":"/Crystal/Macros/Assign","kind":"class","full_name":"Crystal::Macros::Assign","name":"Assign"},{"html_id":"/Crystal/Macros/BinaryOp","kind":"class","full_name":"Crystal::Macros::BinaryOp","name":"BinaryOp"},{"html_id":"/Crystal/Macros/Block","kind":"class","full_name":"Crystal::Macros::Block","name":"Block"},{"html_id":"/Crystal/Macros/BoolLiteral","kind":"class","full_name":"Crystal::Macros::BoolLiteral","name":"BoolLiteral"},{"html_id":"/Crystal/Macros/Call","kind":"class","full_name":"Crystal::Macros::Call","name":"Call"},{"html_id":"/Crystal/Macros/Case","kind":"class","full_name":"Crystal::Macros::Case","name":"Case"},{"html_id":"/Crystal/Macros/Cast","kind":"class","full_name":"Crystal::Macros::Cast","name":"Cast"},{"html_id":"/Crystal/Macros/CharLiteral","kind":"class","full_name":"Crystal::Macros::CharLiteral","name":"CharLiteral"},{"html_id":"/Crystal/Macros/ClassDef","kind":"class","full_name":"Crystal::Macros::ClassDef","name":"ClassDef"},{"html_id":"/Crystal/Macros/ClassVar","kind":"class","full_name":"Crystal::Macros::ClassVar","name":"ClassVar"},{"html_id":"/Crystal/Macros/Def","kind":"class","full_name":"Crystal::Macros::Def","name":"Def"},{"html_id":"/Crystal/Macros/Expressions","kind":"class","full_name":"Crystal::Macros::Expressions","name":"Expressions"},{"html_id":"/Crystal/Macros/Generic","kind":"class","full_name":"Crystal::Macros::Generic","name":"Generic"},{"html_id":"/Crystal/Macros/Global","kind":"class","full_name":"Crystal::Macros::Global","name":"Global"},{"html_id":"/Crystal/Macros/HashLiteral","kind":"class","full_name":"Crystal::Macros::HashLiteral","name":"HashLiteral"},{"html_id":"/Crystal/Macros/If","kind":"class","full_name":"Crystal::Macros::If","name":"If"},{"html_id":"/Crystal/Macros/ImplicitObj","kind":"class","full_name":"Crystal::Macros::ImplicitObj","name":"ImplicitObj"},{"html_id":"/Crystal/Macros/InstanceVar","kind":"class","full_name":"Crystal::Macros::InstanceVar","name":"InstanceVar"},{"html_id":"/Crystal/Macros/IsA","kind":"class","full_name":"Crystal::Macros::IsA","name":"IsA"},{"html_id":"/Crystal/Macros/Macro","kind":"class","full_name":"Crystal::Macros::Macro","name":"Macro"},{"html_id":"/Crystal/Macros/MacroId","kind":"class","full_name":"Crystal::Macros::MacroId","name":"MacroId"},{"html_id":"/Crystal/Macros/MetaVar","kind":"class","full_name":"Crystal::Macros::MetaVar","name":"MetaVar"},{"html_id":"/Crystal/Macros/MultiAssign","kind":"class","full_name":"Crystal::Macros::MultiAssign","name":"MultiAssign"},{"html_id":"/Crystal/Macros/NamedArgument","kind":"class","full_name":"Crystal::Macros::NamedArgument","name":"NamedArgument"},{"html_id":"/Crystal/Macros/NamedTupleLiteral","kind":"class","full_name":"Crystal::Macros::NamedTupleLiteral","name":"NamedTupleLiteral"},{"html_id":"/Crystal/Macros/NilableCast","kind":"class","full_name":"Crystal::Macros::NilableCast","name":"NilableCast"},{"html_id":"/Crystal/Macros/NilLiteral","kind":"class","full_name":"Crystal::Macros::NilLiteral","name":"NilLiteral"},{"html_id":"/Crystal/Macros/Nop","kind":"class","full_name":"Crystal::Macros::Nop","name":"Nop"},{"html_id":"/Crystal/Macros/NumberLiteral","kind":"class","full_name":"Crystal::Macros::NumberLiteral","name":"NumberLiteral"},{"html_id":"/Crystal/Macros/OffsetOf","kind":"class","full_name":"Crystal::Macros::OffsetOf","name":"OffsetOf"},{"html_id":"/Crystal/Macros/Path","kind":"class","full_name":"Crystal::Macros::Path","name":"Path"},{"html_id":"/Crystal/Macros/ProcLiteral","kind":"class","full_name":"Crystal::Macros::ProcLiteral","name":"ProcLiteral"},{"html_id":"/Crystal/Macros/ProcNotation","kind":"class","full_name":"Crystal::Macros::ProcNotation","name":"ProcNotation"},{"html_id":"/Crystal/Macros/ProcPointer","kind":"class","full_name":"Crystal::Macros::ProcPointer","name":"ProcPointer"},{"html_id":"/Crystal/Macros/RangeLiteral","kind":"class","full_name":"Crystal::Macros::RangeLiteral","name":"RangeLiteral"},{"html_id":"/Crystal/Macros/ReadInstanceVar","kind":"class","full_name":"Crystal::Macros::ReadInstanceVar","name":"ReadInstanceVar"},{"html_id":"/Crystal/Macros/RegexLiteral","kind":"class","full_name":"Crystal::Macros::RegexLiteral","name":"RegexLiteral"},{"html_id":"/Crystal/Macros/Require","kind":"class","full_name":"Crystal::Macros::Require","name":"Require"},{"html_id":"/Crystal/Macros/RespondsTo","kind":"class","full_name":"Crystal::Macros::RespondsTo","name":"RespondsTo"},{"html_id":"/Crystal/Macros/Splat","kind":"class","full_name":"Crystal::Macros::Splat","name":"Splat"},{"html_id":"/Crystal/Macros/StringInterpolation","kind":"class","full_name":"Crystal::Macros::StringInterpolation","name":"StringInterpolation"},{"html_id":"/Crystal/Macros/StringLiteral","kind":"class","full_name":"Crystal::Macros::StringLiteral","name":"StringLiteral"},{"html_id":"/Crystal/Macros/SymbolLiteral","kind":"class","full_name":"Crystal::Macros::SymbolLiteral","name":"SymbolLiteral"},{"html_id":"/Crystal/Macros/TupleLiteral","kind":"class","full_name":"Crystal::Macros::TupleLiteral","name":"TupleLiteral"},{"html_id":"/Crystal/Macros/TypeDeclaration","kind":"class","full_name":"Crystal::Macros::TypeDeclaration","name":"TypeDeclaration"},{"html_id":"/Crystal/Macros/TypeNode","kind":"class","full_name":"Crystal::Macros::TypeNode","name":"TypeNode"},{"html_id":"/Crystal/Macros/UnaryExpression","kind":"class","full_name":"Crystal::Macros::UnaryExpression","name":"UnaryExpression"},{"html_id":"/Crystal/Macros/UninitializedVar","kind":"class","full_name":"Crystal::Macros::UninitializedVar","name":"UninitializedVar"},{"html_id":"/Crystal/Macros/Union","kind":"class","full_name":"Crystal::Macros::Union","name":"Union"},{"html_id":"/Crystal/Macros/Var","kind":"class","full_name":"Crystal::Macros::Var","name":"Var"},{"html_id":"/Crystal/Macros/VisibilityModifier","kind":"class","full_name":"Crystal::Macros::VisibilityModifier","name":"VisibilityModifier"},{"html_id":"/Crystal/Macros/When","kind":"class","full_name":"Crystal::Macros::When","name":"When"},{"html_id":"/Crystal/Macros/While","kind":"class","full_name":"Crystal::Macros::While","name":"While"}],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"This is the base class of all AST nodes. This methods are\navailable to all AST nodes.","summary":"<p>This is the base class of all AST nodes.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"!=(other:ASTNode):BoolLiteral-instance-method","html_id":"!=(other:ASTNode):BoolLiteral-instance-method","name":"!=","doc":"Returns `true` if this node's textual representation is not the same as\nthe *other* node.","summary":"<p>Returns <code>true</code> if this node's textual representation is not the same as the <em>other</em> node.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"ASTNode"}],"args_string":"(other : ASTNode) : BoolLiteral","source_link":null,"def":{"name":"!=","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"ASTNode"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"==(other:ASTNode):BoolLiteral-instance-method","html_id":"==(other:ASTNode):BoolLiteral-instance-method","name":"==","doc":"Returns `true` if this node's textual representation is the same as\nthe *other* node.","summary":"<p>Returns <code>true</code> if this node's textual representation is the same as the <em>other</em> node.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"ASTNode"}],"args_string":"(other : ASTNode) : BoolLiteral","source_link":null,"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"ASTNode"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"class_name:StringLiteral-instance-method","html_id":"class_name:StringLiteral-instance-method","name":"class_name","doc":"Returns a `StringLiteral` that contains this node's name.\n\n```\nmacro test\n  {{ \"foo\".class_name }}\nend\n\nputs test # => prints StringLiteral\n```","summary":"<p>Returns a <code><a href=\"../../Crystal/Macros/StringLiteral.html\">StringLiteral</a></code> that contains this node's name.</p>","abstract":false,"args":[],"args_string":" : StringLiteral","source_link":null,"def":{"name":"class_name","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral","visibility":"Public","body":""}},{"id":"column_number:StringLiteral|NilLiteral-instance-method","html_id":"column_number:StringLiteral|NilLiteral-instance-method","name":"column_number","doc":"Returns the column number where this node begins.\nMight return `nil` if the location is not known.\n\nThe first column number in a line is `1`.","summary":"<p>Returns the column number where this node begins.</p>","abstract":false,"args":[],"args_string":" : StringLiteral | NilLiteral","source_link":null,"def":{"name":"column_number","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral | NilLiteral","visibility":"Public","body":""}},{"id":"end_column_number:StringLiteral|NilLiteral-instance-method","html_id":"end_column_number:StringLiteral|NilLiteral-instance-method","name":"end_column_number","doc":"Returns the column number where this node ends.\nMight return `nil` if the location is not known.\n\nThe first column number in a line is `1`.","summary":"<p>Returns the column number where this node ends.</p>","abstract":false,"args":[],"args_string":" : StringLiteral | NilLiteral","source_link":null,"def":{"name":"end_column_number","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral | NilLiteral","visibility":"Public","body":""}},{"id":"end_line_number:StringLiteral|NilLiteral-instance-method","html_id":"end_line_number:StringLiteral|NilLiteral-instance-method","name":"end_line_number","doc":"Returns the line number where this node ends.\nMight return `nil` if the location is not known.\n\nThe first line number in a file is `1`.","summary":"<p>Returns the line number where this node ends.</p>","abstract":false,"args":[],"args_string":" : StringLiteral | NilLiteral","source_link":null,"def":{"name":"end_line_number","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral | NilLiteral","visibility":"Public","body":""}},{"id":"filename:StringLiteral|NilLiteral-instance-method","html_id":"filename:StringLiteral|NilLiteral-instance-method","name":"filename","doc":"Returns the filename where this node is located.\nMight return `nil` if the location is not known.","summary":"<p>Returns the filename where this node is located.</p>","abstract":false,"args":[],"args_string":" : StringLiteral | NilLiteral","source_link":null,"def":{"name":"filename","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral | NilLiteral","visibility":"Public","body":""}},{"id":"id:MacroId-instance-method","html_id":"id:MacroId-instance-method","name":"id","doc":"Returns this node as a `MacroId`. Useful when you need an identifier\nout of a `StringLiteral`, `SymbolLiteral`, `Var` or `Call`.\n\n```\nmacro define_method(name, content)\n  def {{name.id}}\n    {{content}}\n  end\nend\n\ndefine_method :foo, 1\ndefine_method \"bar\", 2\ndefine_method baz, 3\n\nputs foo # => prints 1\nputs bar # => prints 2\nputs baz # => prints 3\n```","summary":"<p>Returns this node as a <code><a href=\"../../Crystal/Macros/MacroId.html\">MacroId</a></code>.</p>","abstract":false,"args":[],"args_string":" : MacroId","source_link":null,"def":{"name":"id","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"line_number:StringLiteral|NilLiteral-instance-method","html_id":"line_number:StringLiteral|NilLiteral-instance-method","name":"line_number","doc":"Returns the line number where this node begins.\nMight return `nil` if the location is not known.\n\nThe first line number in a file is 1.","summary":"<p>Returns the line number where this node begins.</p>","abstract":false,"args":[],"args_string":" : StringLiteral | NilLiteral","source_link":null,"def":{"name":"line_number","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral | NilLiteral","visibility":"Public","body":""}},{"id":"raise(message):NoReturn-instance-method","html_id":"raise(message):NoReturn-instance-method","name":"raise","doc":"Gives a compile-time error with the given *message*. This will\nhighlight this node in the error message.","summary":"<p>Gives a compile-time error with the given <em>message</em>.</p>","abstract":false,"args":[{"name":"message","doc":null,"default_value":"","external_name":"message","restriction":""}],"args_string":"(message) : NoReturn","source_link":null,"def":{"name":"raise","args":[{"name":"message","doc":null,"default_value":"","external_name":"message","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NoReturn","visibility":"Public","body":""}},{"id":"stringify:StringLiteral-instance-method","html_id":"stringify:StringLiteral-instance-method","name":"stringify","doc":"Returns a `StringLiteral` that contains this node's textual representation.\nNote that invoking stringify on a string literal will return a `StringLiteral`\nthat contains a string literal.\n\n```\nmacro test\n  {{ \"foo\".stringify }}\nend\n\nputs test # prints \"foo\" (including the double quotes)\n```","summary":"<p>Returns a <code><a href=\"../../Crystal/Macros/StringLiteral.html\">StringLiteral</a></code> that contains this node's textual representation.</p>","abstract":false,"args":[],"args_string":" : StringLiteral","source_link":null,"def":{"name":"stringify","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral","visibility":"Public","body":""}},{"id":"symbolize:SymbolLiteral-instance-method","html_id":"symbolize:SymbolLiteral-instance-method","name":"symbolize","doc":"Returns a `SymbolLiteral` that contains this node's textual representation.\n\n```\n{{ \"foo\".id.symbolize }} # => :foo\n```","summary":"<p>Returns a <code><a href=\"../../Crystal/Macros/SymbolLiteral.html\">SymbolLiteral</a></code> that contains this node's textual representation.</p>","abstract":false,"args":[],"args_string":" : SymbolLiteral","source_link":null,"def":{"name":"symbolize","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"SymbolLiteral","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/BinaryOp","path":"Crystal/Macros/BinaryOp.html","kind":"class","full_name":"Crystal::Macros::BinaryOp","name":"BinaryOp","abstract":true,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[{"html_id":"/Crystal/Macros/And","kind":"class","full_name":"Crystal::Macros::And","name":"And"},{"html_id":"/Crystal/Macros/Or","kind":"class","full_name":"Crystal::Macros::Or","name":"Or"}],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A binary expression like `And` and `Or`.","summary":"<p>A binary expression like <code><a href=\"../../Crystal/Macros/And.html\">And</a></code> and <code><a href=\"../../Crystal/Macros/Or.html\">Or</a></code>.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"left:ASTNode-instance-method","html_id":"left:ASTNode-instance-method","name":"left","doc":"Returns the left hand side of this node.","summary":"<p>Returns the left hand side of this node.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"left","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"right:ASTNode-instance-method","html_id":"right:ASTNode-instance-method","name":"right","doc":"Returns the left hand side of this node.","summary":"<p>Returns the left hand side of this node.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"right","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/Block","path":"Crystal/Macros/Block.html","kind":"class","full_name":"Crystal::Macros::Block","name":"Block","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A code block.","summary":"<p>A code block.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"args:Crystal::Macros::ArrayLiteral(MacroId)-instance-method","html_id":"args:Crystal::Macros::ArrayLiteral(MacroId)-instance-method","name":"args","doc":"Returns the blocks arguments.","summary":"<p>Returns the blocks arguments.</p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(MacroId)","source_link":null,"def":{"name":"args","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(MacroId)","visibility":"Public","body":""}},{"id":"body:ASTNode-instance-method","html_id":"body:ASTNode-instance-method","name":"body","doc":"Returns the block's body, if any.","summary":"<p>Returns the block's body, if any.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"body","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"splat_index:NumberLiteral|NilLiteral-instance-method","html_id":"splat_index:NumberLiteral|NilLiteral-instance-method","name":"splat_index","doc":"Returns the index of the argument with a *splat, if any.","summary":"<p>Returns the index of the argument with a *splat, if any.</p>","abstract":false,"args":[],"args_string":" : NumberLiteral | NilLiteral","source_link":null,"def":{"name":"splat_index","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral | NilLiteral","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/BoolLiteral","path":"Crystal/Macros/BoolLiteral.html","kind":"class","full_name":"Crystal::Macros::BoolLiteral","name":"BoolLiteral","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A bool literal.","summary":"<p>A bool literal.</p>","class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/Call","path":"Crystal/Macros/Call.html","kind":"class","full_name":"Crystal::Macros::Call","name":"Call","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A method call.","summary":"<p>A method call.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"args:ArrayLiteral-instance-method","html_id":"args:ArrayLiteral-instance-method","name":"args","doc":"Returns this call's arguments.","summary":"<p>Returns this call's arguments.</p>","abstract":false,"args":[],"args_string":" : ArrayLiteral","source_link":null,"def":{"name":"args","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral","visibility":"Public","body":""}},{"id":"block:Block|Nop-instance-method","html_id":"block:Block|Nop-instance-method","name":"block","doc":"Returns this call's block, if any.","summary":"<p>Returns this call's block, if any.</p>","abstract":false,"args":[],"args_string":" : Block | Nop","source_link":null,"def":{"name":"block","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Block | Nop","visibility":"Public","body":""}},{"id":"block_arg:ASTNode|Nop-instance-method","html_id":"block_arg:ASTNode|Nop-instance-method","name":"block_arg","doc":"Returns this call's block argument, if any","summary":"<p>Returns this call's block argument, if any</p>","abstract":false,"args":[],"args_string":" : ASTNode | Nop","source_link":null,"def":{"name":"block_arg","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode | Nop","visibility":"Public","body":""}},{"id":"id:MacroId-instance-method","html_id":"id:MacroId-instance-method","name":"id","doc":"Returns this call's name as a `MacroId`.","summary":"<p>Returns this call's name as a <code><a href=\"../../Crystal/Macros/MacroId.html\">MacroId</a></code>.</p>","abstract":false,"args":[],"args_string":" : MacroId","source_link":null,"def":{"name":"id","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"name:MacroId-instance-method","html_id":"name:MacroId-instance-method","name":"name","doc":"Returns the method name of this call.","summary":"<p>Returns the method name of this call.</p>","abstract":false,"args":[],"args_string":" : MacroId","source_link":null,"def":{"name":"name","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"named_args:Crystal::Macros::ArrayLiteral(NamedArgument)-instance-method","html_id":"named_args:Crystal::Macros::ArrayLiteral(NamedArgument)-instance-method","name":"named_args","doc":"Returns this call's named arguments.","summary":"<p>Returns this call's named arguments.</p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(NamedArgument)","source_link":null,"def":{"name":"named_args","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(NamedArgument)","visibility":"Public","body":""}},{"id":"receiver:ASTNode|Nop-instance-method","html_id":"receiver:ASTNode|Nop-instance-method","name":"receiver","doc":"Returns this call's receiver, if any.","summary":"<p>Returns this call's receiver, if any.</p>","abstract":false,"args":[],"args_string":" : ASTNode | Nop","source_link":null,"def":{"name":"receiver","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode | Nop","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/Case","path":"Crystal/Macros/Case.html","kind":"class","full_name":"Crystal::Macros::Case","name":"Case","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A `case` expression.","summary":"<p>A <code>case</code> expression.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"cond:ASTNode-instance-method","html_id":"cond:ASTNode-instance-method","name":"cond","doc":"Returns the condition (target) of this `case`.","summary":"<p>Returns the condition (target) of this <code>case</code>.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"cond","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"else:Crystal::Macros::ArrayLiteral(When)-instance-method","html_id":"else:Crystal::Macros::ArrayLiteral(When)-instance-method","name":"else","doc":"Returns the `else` of this `case`.","summary":"<p>Returns the <code><a href=\"../../Crystal/Macros/Case.html#else:Crystal::Macros::ArrayLiteral(When)-instance-method\">#else</a></code> of this <code>case</code>.</p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(When)","source_link":null,"def":{"name":"else","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(When)","visibility":"Public","body":""}},{"id":"whens:Crystal::Macros::ArrayLiteral(When)-instance-method","html_id":"whens:Crystal::Macros::ArrayLiteral(When)-instance-method","name":"whens","doc":"Returns the `when`s of this `case`.","summary":"<p>Returns the <code>when</code>s of this <code>case</code>.</p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(When)","source_link":null,"def":{"name":"whens","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(When)","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/Cast","path":"Crystal/Macros/Cast.html","kind":"class","full_name":"Crystal::Macros::Cast","name":"Cast","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A cast call: `obj.as(to)`","summary":"<p>A cast call: <code>obj.as(to)</code></p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"obj:ASTNode-instance-method","html_id":"obj:ASTNode-instance-method","name":"obj","doc":"Returns the object part of the cast.","summary":"<p>Returns the object part of the cast.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"obj","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"to:ASTNode-instance-method","html_id":"to:ASTNode-instance-method","name":"to","doc":"Returns the target type of the cast.","summary":"<p>Returns the target type of the cast.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"to","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/CharLiteral","path":"Crystal/Macros/CharLiteral.html","kind":"class","full_name":"Crystal::Macros::CharLiteral","name":"CharLiteral","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A character literal.","summary":"<p>A character literal.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"id:MacroId-instance-method","html_id":"id:MacroId-instance-method","name":"id","doc":"Returns a `MacroId` for this character's contents.","summary":"<p>Returns a <code><a href=\"../../Crystal/Macros/MacroId.html\">MacroId</a></code> for this character's contents.</p>","abstract":false,"args":[],"args_string":" : MacroId","source_link":null,"def":{"name":"id","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/ClassDef","path":"Crystal/Macros/ClassDef.html","kind":"class","full_name":"Crystal::Macros::ClassDef","name":"ClassDef","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A class definition.","summary":"<p>A class definition.</p>","class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/ClassVar","path":"Crystal/Macros/ClassVar.html","kind":"class","full_name":"Crystal::Macros::ClassVar","name":"ClassVar","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A class variable.","summary":"<p>A class variable.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"name:MacroId-instance-method","html_id":"name:MacroId-instance-method","name":"name","doc":"Returns the name of this variable.","summary":"<p>Returns the name of this variable.</p>","abstract":false,"args":[],"args_string":" : MacroId","source_link":null,"def":{"name":"name","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/Def","path":"Crystal/Macros/Def.html","kind":"class","full_name":"Crystal::Macros::Def","name":"Def","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A method definition.","summary":"<p>A method definition.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"accepts_block?:BoolLiteral-instance-method","html_id":"accepts_block?:BoolLiteral-instance-method","name":"accepts_block?","doc":"Returns `true` if this method can be called with a block, `false` otherwise.","summary":"<p>Returns <code>true</code> if this method can be called with a block, <code>false</code> otherwise.</p>","abstract":false,"args":[],"args_string":" : BoolLiteral","source_link":null,"def":{"name":"accepts_block?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"annotation(type:TypeNode):Annotation|NilLiteral-instance-method","html_id":"annotation(type:TypeNode):Annotation|NilLiteral-instance-method","name":"annotation","doc":"Returns the last `Annotation` with the given `type`\nattached to this variable or `NilLiteral` if there are none.","summary":"<p>Returns the last <code><a href=\"../../Crystal/Macros/Annotation.html\">Annotation</a></code> with the given <code>type</code> attached to this variable or <code><a href=\"../../Crystal/Macros/NilLiteral.html\">NilLiteral</a></code> if there are none.</p>","abstract":false,"args":[{"name":"type","doc":null,"default_value":"","external_name":"type","restriction":"TypeNode"}],"args_string":"(type : TypeNode) : Annotation | NilLiteral","source_link":null,"def":{"name":"annotation","args":[{"name":"type","doc":null,"default_value":"","external_name":"type","restriction":"TypeNode"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Annotation | NilLiteral","visibility":"Public","body":""}},{"id":"annotations(type:TypeNode):Crystal::Macros::ArrayLiteral(Annotation)-instance-method","html_id":"annotations(type:TypeNode):Crystal::Macros::ArrayLiteral(Annotation)-instance-method","name":"annotations","doc":"Returns an array of annotations with the given `type`\nattached to this variable, or an empty `ArrayLiteral` if there are none.","summary":"<p>Returns an array of annotations with the given <code>type</code> attached to this variable, or an empty <code><a href=\"../../Crystal/Macros/ArrayLiteral.html\">ArrayLiteral</a></code> if there are none.</p>","abstract":false,"args":[{"name":"type","doc":null,"default_value":"","external_name":"type","restriction":"TypeNode"}],"args_string":"(type : TypeNode) : Crystal::Macros::ArrayLiteral(Annotation)","source_link":null,"def":{"name":"annotations","args":[{"name":"type","doc":null,"default_value":"","external_name":"type","restriction":"TypeNode"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(Annotation)","visibility":"Public","body":""}},{"id":"args:Crystal::Macros::ArrayLiteral(Arg)-instance-method","html_id":"args:Crystal::Macros::ArrayLiteral(Arg)-instance-method","name":"args","doc":"Returns the arguments of this method.","summary":"<p>Returns the arguments of this method.</p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(Arg)","source_link":null,"def":{"name":"args","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(Arg)","visibility":"Public","body":""}},{"id":"block_arg:Arg|Nop-instance-method","html_id":"block_arg:Arg|Nop-instance-method","name":"block_arg","doc":"Returns the block argument, if any.","summary":"<p>Returns the block argument, if any.</p>","abstract":false,"args":[],"args_string":" : Arg | Nop","source_link":null,"def":{"name":"block_arg","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Arg | Nop","visibility":"Public","body":""}},{"id":"body:ASTNode-instance-method","html_id":"body:ASTNode-instance-method","name":"body","doc":"Returns the body of this method.","summary":"<p>Returns the body of this method.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"body","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"double_splat:Arg|Nop-instance-method","html_id":"double_splat:Arg|Nop-instance-method","name":"double_splat","doc":"Returns the double splat argument, if any.","summary":"<p>Returns the double splat argument, if any.</p>","abstract":false,"args":[],"args_string":" : Arg | Nop","source_link":null,"def":{"name":"double_splat","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Arg | Nop","visibility":"Public","body":""}},{"id":"name:MacroId-instance-method","html_id":"name:MacroId-instance-method","name":"name","doc":"Returns the name of this method.","summary":"<p>Returns the name of this method.</p>","abstract":false,"args":[],"args_string":" : MacroId","source_link":null,"def":{"name":"name","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"receiver:ASTNode|Nop-instance-method","html_id":"receiver:ASTNode|Nop-instance-method","name":"receiver","doc":"Returns the receiver (for example `self`) of this method definition,\nor `Nop` if not specified.","summary":"<p>Returns the receiver (for example <code>self</code>) of this method definition, or <code><a href=\"../../Crystal/Macros/Nop.html\">Nop</a></code> if not specified.</p>","abstract":false,"args":[],"args_string":" : ASTNode | Nop","source_link":null,"def":{"name":"receiver","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode | Nop","visibility":"Public","body":""}},{"id":"return_type:ASTNode|Nop-instance-method","html_id":"return_type:ASTNode|Nop-instance-method","name":"return_type","doc":"Returns the return type of the method, if specified.","summary":"<p>Returns the return type of the method, if specified.</p>","abstract":false,"args":[],"args_string":" : ASTNode | Nop","source_link":null,"def":{"name":"return_type","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode | Nop","visibility":"Public","body":""}},{"id":"splat_index:NumberLiteral|NilLiteral-instance-method","html_id":"splat_index:NumberLiteral|NilLiteral-instance-method","name":"splat_index","doc":"Returns the index of the argument with a *splat, if any.","summary":"<p>Returns the index of the argument with a *splat, if any.</p>","abstract":false,"args":[],"args_string":" : NumberLiteral | NilLiteral","source_link":null,"def":{"name":"splat_index","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral | NilLiteral","visibility":"Public","body":""}},{"id":"visibility:SymbolLiteral-instance-method","html_id":"visibility:SymbolLiteral-instance-method","name":"visibility","doc":"Returns the visibility of this def: `:public`, `:protected` or `:private`.","summary":"<p>Returns the visibility of this def: <code>:public</code>, <code>:protected</code> or <code>:private</code>.</p>","abstract":false,"args":[],"args_string":" : SymbolLiteral","source_link":null,"def":{"name":"visibility","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"SymbolLiteral","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/Expressions","path":"Crystal/Macros/Expressions.html","kind":"class","full_name":"Crystal::Macros::Expressions","name":"Expressions","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A group of expressions.","summary":"<p>A group of expressions.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"expressions:Crystal::Macros::ArrayLiteral(ASTNode)-instance-method","html_id":"expressions:Crystal::Macros::ArrayLiteral(ASTNode)-instance-method","name":"expressions","doc":"Returns the list of expressions in this node","summary":"<p>Returns the list of expressions in this node</p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(ASTNode)","source_link":null,"def":{"name":"expressions","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(ASTNode)","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/Generic","path":"Crystal/Macros/Generic.html","kind":"class","full_name":"Crystal::Macros::Generic","name":"Generic","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A generic instantiation, like `Foo(T)` or `Foo::Bar::Baz(T)`","summary":"<p>A generic instantiation, like <code>Foo(T)</code> or <code>Foo::Bar::Baz(T)</code></p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"name:Path-instance-method","html_id":"name:Path-instance-method","name":"name","doc":"Returns the path to the generic.","summary":"<p>Returns the path to the generic.</p>","abstract":false,"args":[],"args_string":" : Path","source_link":null,"def":{"name":"name","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Path","visibility":"Public","body":""}},{"id":"named_args:NamedTupleLiteral|NilLiteral-instance-method","html_id":"named_args:NamedTupleLiteral|NilLiteral-instance-method","name":"named_args","doc":"Returns the named arguments of this instantiation, if any.","summary":"<p>Returns the named arguments of this instantiation, if any.</p>","abstract":false,"args":[],"args_string":" : NamedTupleLiteral | NilLiteral","source_link":null,"def":{"name":"named_args","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NamedTupleLiteral | NilLiteral","visibility":"Public","body":""}},{"id":"resolve:ASTNode-instance-method","html_id":"resolve:ASTNode-instance-method","name":"resolve","doc":"Resolves this generic to a `TypeNode` if it denotes a type,\nor otherwise gives a compile-time error.","summary":"<p>Resolves this generic to a <code><a href=\"../../Crystal/Macros/TypeNode.html\">TypeNode</a></code> if it denotes a type, or otherwise gives a compile-time error.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"resolve","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"resolve?:ASTNode|NilLiteral-instance-method","html_id":"resolve?:ASTNode|NilLiteral-instance-method","name":"resolve?","doc":"Resolves this path to a `TypeNode` if it denotes a type,\nor otherwise returns a `NilLiteral`.","summary":"<p>Resolves this path to a <code><a href=\"../../Crystal/Macros/TypeNode.html\">TypeNode</a></code> if it denotes a type, or otherwise returns a <code><a href=\"../../Crystal/Macros/NilLiteral.html\">NilLiteral</a></code>.</p>","abstract":false,"args":[],"args_string":" : ASTNode | NilLiteral","source_link":null,"def":{"name":"resolve?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode | NilLiteral","visibility":"Public","body":""}},{"id":"type_vars:Crystal::Macros::ArrayLiteral(ASTNode)-instance-method","html_id":"type_vars:Crystal::Macros::ArrayLiteral(ASTNode)-instance-method","name":"type_vars","doc":"Returns the arguments (the type variables) of this instantiation.","summary":"<p>Returns the arguments (the type variables) of this instantiation.</p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(ASTNode)","source_link":null,"def":{"name":"type_vars","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(ASTNode)","visibility":"Public","body":""}},{"id":"types:Crystal::Macros::ArrayLiteral(ASTNode)-instance-method","html_id":"types:Crystal::Macros::ArrayLiteral(ASTNode)-instance-method","name":"types","doc":"Returns this generic inside an array literal.\nThis method exists so you can call `types` on the type of a type\ndeclaration and get all types, whether it's a Generic, Path or Union.","summary":"<p>Returns this generic inside an array literal.</p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(ASTNode)","source_link":null,"def":{"name":"types","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(ASTNode)","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/Global","path":"Crystal/Macros/Global.html","kind":"class","full_name":"Crystal::Macros::Global","name":"Global","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A global variable.","summary":"<p>A global variable.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"name:MacroId-instance-method","html_id":"name:MacroId-instance-method","name":"name","doc":"Returns the name of this variable.","summary":"<p>Returns the name of this variable.</p>","abstract":false,"args":[],"args_string":" : MacroId","source_link":null,"def":{"name":"name","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/HashLiteral","path":"Crystal/Macros/HashLiteral.html","kind":"class","full_name":"Crystal::Macros::HashLiteral","name":"HashLiteral","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A hash literal.","summary":"<p>A hash literal.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"[](key:ASTNode):ASTNode-instance-method","html_id":"[](key:ASTNode):ASTNode-instance-method","name":"[]","doc":"Similar to `Hash#[]`","summary":"<p>Similar to <code><a href=\"../../Hash.html#[](key)-instance-method\">Hash#[]</a></code></p>","abstract":false,"args":[{"name":"key","doc":null,"default_value":"","external_name":"key","restriction":"ASTNode"}],"args_string":"(key : ASTNode) : ASTNode","source_link":null,"def":{"name":"[]","args":[{"name":"key","doc":null,"default_value":"","external_name":"key","restriction":"ASTNode"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"[]=(key:ASTNode):ASTNode-instance-method","html_id":"[]=(key:ASTNode):ASTNode-instance-method","name":"[]=","doc":"Similar to `Hash#[]=`","summary":"<p>Similar to <code><a href=\"../../Hash.html#[]=(key:K,value:V)-instance-method\">Hash#[]=</a></code></p>","abstract":false,"args":[{"name":"key","doc":null,"default_value":"","external_name":"key","restriction":"ASTNode"}],"args_string":"(key : ASTNode) : ASTNode","source_link":null,"def":{"name":"[]=","args":[{"name":"key","doc":null,"default_value":"","external_name":"key","restriction":"ASTNode"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"clear:HashLiteral-instance-method","html_id":"clear:HashLiteral-instance-method","name":"clear","doc":"Similar to `Hash#clear`","summary":"<p>Similar to <code><a href=\"../../Hash.html#clear-instance-method\">Hash#clear</a></code></p>","abstract":false,"args":[],"args_string":" : HashLiteral","source_link":null,"def":{"name":"clear","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"HashLiteral","visibility":"Public","body":""}},{"id":"double_splat(trailing_string:StringLiteral=nil):MacroId-instance-method","html_id":"double_splat(trailing_string:StringLiteral=nil):MacroId-instance-method","name":"double_splat","doc":"Returns a `MacroId` with all of this hash elements joined\nby commas.\n\nIf *trailing_string* is given, it will be appended to\nthe result unless this hash is empty. This lets you\nsplat a hash and optionally write a trailing comma\nif needed.","summary":"<p>Returns a <code><a href=\"../../Crystal/Macros/MacroId.html\">MacroId</a></code> with all of this hash elements joined by commas.</p>","abstract":false,"args":[{"name":"trailing_string","doc":null,"default_value":"nil","external_name":"trailing_string","restriction":"StringLiteral"}],"args_string":"(trailing_string : StringLiteral = <span class=\"n\">nil</span>) : MacroId","source_link":null,"def":{"name":"double_splat","args":[{"name":"trailing_string","doc":null,"default_value":"nil","external_name":"trailing_string","restriction":"StringLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"empty?:BoolLiteral-instance-method","html_id":"empty?:BoolLiteral-instance-method","name":"empty?","doc":"Similar to `Hash#empty?`","summary":"<p>Similar to <code><a href=\"../../Hash.html#empty?-instance-method\">Hash#empty?</a></code></p>","abstract":false,"args":[],"args_string":" : BoolLiteral","source_link":null,"def":{"name":"empty?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"keys:ArrayLiteral-instance-method","html_id":"keys:ArrayLiteral-instance-method","name":"keys","doc":"Similar to `Hash#keys`","summary":"<p>Similar to <code><a href=\"../../Hash.html#keys:Array(K)-instance-method\">Hash#keys</a></code></p>","abstract":false,"args":[],"args_string":" : ArrayLiteral","source_link":null,"def":{"name":"keys","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral","visibility":"Public","body":""}},{"id":"map:ArrayLiteral-instance-method","html_id":"map:ArrayLiteral-instance-method","name":"map","doc":"Similar to `Hash#map`","summary":"<p>Similar to <code>Hash#map</code></p>","abstract":false,"args":[],"args_string":" : ArrayLiteral","source_link":null,"def":{"name":"map","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral","visibility":"Public","body":""}},{"id":"of_key:ASTNode|Nop-instance-method","html_id":"of_key:ASTNode|Nop-instance-method","name":"of_key","doc":"Returns the type specified at the end of the Hash literal, if any.\n\nThis refers to the key type after brackets in `{} of String => Int32`.","summary":"<p>Returns the type specified at the end of the Hash literal, if any.</p>","abstract":false,"args":[],"args_string":" : ASTNode | Nop","source_link":null,"def":{"name":"of_key","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode | Nop","visibility":"Public","body":""}},{"id":"of_value:ASTNode|Nop-instance-method","html_id":"of_value:ASTNode|Nop-instance-method","name":"of_value","doc":"Returns the type specified at the end of the Hash literal, if any.\n\nThis refers to the value type after brackets in `{} of String => Int32`.","summary":"<p>Returns the type specified at the end of the Hash literal, if any.</p>","abstract":false,"args":[],"args_string":" : ASTNode | Nop","source_link":null,"def":{"name":"of_value","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode | Nop","visibility":"Public","body":""}},{"id":"size:NumberLiteral-instance-method","html_id":"size:NumberLiteral-instance-method","name":"size","doc":"Similar to `Hash#size`","summary":"<p>Similar to <code><a href=\"../../Hash.html#size:Int32-instance-method\">Hash#size</a></code></p>","abstract":false,"args":[],"args_string":" : NumberLiteral","source_link":null,"def":{"name":"size","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral","visibility":"Public","body":""}},{"id":"to_a:Crystal::Macros::ArrayLiteral(TupleLiteral)-instance-method","html_id":"to_a:Crystal::Macros::ArrayLiteral(TupleLiteral)-instance-method","name":"to_a","doc":"Similar to `Hash#to_a`","summary":"<p>Similar to <code><a href=\"../../Hash.html#to_a:Array(Tuple(K,V))-instance-method\">Hash#to_a</a></code></p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(TupleLiteral)","source_link":null,"def":{"name":"to_a","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(TupleLiteral)","visibility":"Public","body":""}},{"id":"type:Path|Nop-instance-method","html_id":"type:Path|Nop-instance-method","name":"type","doc":"Returns the type that receives the items of the array.\n\nThis refers to the part before brackets in `MyHash{'a' => 1, 'b' => 2}`","summary":"<p>Returns the type that receives the items of the array.</p>","abstract":false,"args":[],"args_string":" : Path | Nop","source_link":null,"def":{"name":"type","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Path | Nop","visibility":"Public","body":""}},{"id":"values:ArrayLiteral-instance-method","html_id":"values:ArrayLiteral-instance-method","name":"values","doc":"Similar to `Hash#values`","summary":"<p>Similar to <code><a href=\"../../Hash.html#values:Array(V)-instance-method\">Hash#values</a></code></p>","abstract":false,"args":[],"args_string":" : ArrayLiteral","source_link":null,"def":{"name":"values","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/If","path":"Crystal/Macros/If.html","kind":"class","full_name":"Crystal::Macros::If","name":"If","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"An if expression.","summary":"<p>An if expression.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"cond:ASTNode-instance-method","html_id":"cond:ASTNode-instance-method","name":"cond","doc":"Returns this if's condition.","summary":"<p>Returns this if's condition.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"cond","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"else:ASTNode-instance-method","html_id":"else:ASTNode-instance-method","name":"else","doc":"Returns this if's `else` clause's body.","summary":"<p>Returns this if's <code><a href=\"../../Crystal/Macros/If.html#else:ASTNode-instance-method\">#else</a></code> clause's body.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"else","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"then:ASTNode-instance-method","html_id":"then:ASTNode-instance-method","name":"then","doc":"Returns this if's `then` clause's body.","summary":"<p>Returns this if's <code><a href=\"../../Crystal/Macros/If.html#then:ASTNode-instance-method\">#then</a></code> clause's body.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"then","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/ImplicitObj","path":"Crystal/Macros/ImplicitObj.html","kind":"class","full_name":"Crystal::Macros::ImplicitObj","name":"ImplicitObj","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"Node that represents an implicit object in:\n\n    case foo\n    when .bar? # this is a call with an implicit object\n    end","summary":"<p>Node that represents an implicit object in:</p>","class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/InstanceSizeOf","path":"Crystal/Macros/InstanceSizeOf.html","kind":"class","full_name":"Crystal::Macros::InstanceSizeOf","name":"InstanceSizeOf","abstract":false,"superclass":{"html_id":"/Crystal/Macros/UnaryExpression","kind":"class","full_name":"Crystal::Macros::UnaryExpression","name":"UnaryExpression"},"ancestors":[{"html_id":"/Crystal/Macros/UnaryExpression","kind":"class","full_name":"Crystal::Macros::UnaryExpression","name":"UnaryExpression"},{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"An `instance_sizeof` expression.","summary":"<p>An <code>instance_sizeof</code> expression.</p>","class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/InstanceVar","path":"Crystal/Macros/InstanceVar.html","kind":"class","full_name":"Crystal::Macros::InstanceVar","name":"InstanceVar","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"An instance variable.","summary":"<p>An instance variable.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"name:MacroId-instance-method","html_id":"name:MacroId-instance-method","name":"name","doc":"Returns the name of this variable.","summary":"<p>Returns the name of this variable.</p>","abstract":false,"args":[],"args_string":" : MacroId","source_link":null,"def":{"name":"name","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/IsA","path":"Crystal/Macros/IsA.html","kind":"class","full_name":"Crystal::Macros::IsA","name":"IsA","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"An `.is_a?` or `.nil?` call.","summary":"<p>An <code>.is_a?</code> or <code>.nil?</code> call.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"arg:ASTNode-instance-method","html_id":"arg:ASTNode-instance-method","name":"arg","doc":"Returns this call's argument.","summary":"<p>Returns this call's argument.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"arg","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"receiver:ASTNode-instance-method","html_id":"receiver:ASTNode-instance-method","name":"receiver","doc":"Returns this call's receiver.","summary":"<p>Returns this call's receiver.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"receiver","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/Macro","path":"Crystal/Macros/Macro.html","kind":"class","full_name":"Crystal::Macros::Macro","name":"Macro","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A macro definition.","summary":"<p>A macro definition.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"args:Crystal::Macros::ArrayLiteral(Arg)-instance-method","html_id":"args:Crystal::Macros::ArrayLiteral(Arg)-instance-method","name":"args","doc":"Returns the arguments of this macro.","summary":"<p>Returns the arguments of this macro.</p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(Arg)","source_link":null,"def":{"name":"args","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(Arg)","visibility":"Public","body":""}},{"id":"block_arg:Arg|Nop-instance-method","html_id":"block_arg:Arg|Nop-instance-method","name":"block_arg","doc":"Returns the block argument, if any.","summary":"<p>Returns the block argument, if any.</p>","abstract":false,"args":[],"args_string":" : Arg | Nop","source_link":null,"def":{"name":"block_arg","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Arg | Nop","visibility":"Public","body":""}},{"id":"body:ASTNode-instance-method","html_id":"body:ASTNode-instance-method","name":"body","doc":"Returns the body of this macro.","summary":"<p>Returns the body of this macro.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"body","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"double_splat:Arg|Nop-instance-method","html_id":"double_splat:Arg|Nop-instance-method","name":"double_splat","doc":"Returns the double splat argument, if any.","summary":"<p>Returns the double splat argument, if any.</p>","abstract":false,"args":[],"args_string":" : Arg | Nop","source_link":null,"def":{"name":"double_splat","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Arg | Nop","visibility":"Public","body":""}},{"id":"name:MacroId-instance-method","html_id":"name:MacroId-instance-method","name":"name","doc":"Returns the name of this macro.","summary":"<p>Returns the name of this macro.</p>","abstract":false,"args":[],"args_string":" : MacroId","source_link":null,"def":{"name":"name","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"splat_index:NumberLiteral|NilLiteral-instance-method","html_id":"splat_index:NumberLiteral|NilLiteral-instance-method","name":"splat_index","doc":"Returns the index of the argument with a *splat, if any.","summary":"<p>Returns the index of the argument with a *splat, if any.</p>","abstract":false,"args":[],"args_string":" : NumberLiteral | NilLiteral","source_link":null,"def":{"name":"splat_index","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral | NilLiteral","visibility":"Public","body":""}},{"id":"visibility:SymbolLiteral-instance-method","html_id":"visibility:SymbolLiteral-instance-method","name":"visibility","doc":"Returns the visibility of this macro: `:public`, `:protected` or `:private`.","summary":"<p>Returns the visibility of this macro: <code>:public</code>, <code>:protected</code> or <code>:private</code>.</p>","abstract":false,"args":[],"args_string":" : SymbolLiteral","source_link":null,"def":{"name":"visibility","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"SymbolLiteral","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/MacroId","path":"Crystal/Macros/MacroId.html","kind":"class","full_name":"Crystal::Macros::MacroId","name":"MacroId","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A fictitious node representing an idenfitifer like, `foo`, `Bar` or `something_else`.\n\nThe parser doesn't create this nodes. Instead, you create them by invoking `id`\non some nodes. For example, invoking `id` on a `StringLiteral` returns a `MacroId`\nfor the string's content. Similarly, invoking ID on a `SymbolLiteral`, `Call`, `Var` and `Path`\nreturn MacroIds for the node's content.\n\nThis allows you to treat strings, symbols, variables and calls uniformly. For example:\n\n```text\nmacro getter(name)\n  def {{name.id}}\n    @{{name.id}}\n  end\nend\n\ngetter unicorns\ngetter :unicorns\ngetter \"unicorns\"\n```\n\nAll of the above macro calls work because we invoked `id`, and the generated code\nlooks like this:\n\n```\ndef unicorns\n  @unicorns\nend\n```\n\nIf we hand't use `id`, the generated code would have been this:\n\n```text\ndef unicorns\n  @unicorns\nend\n\ndef :unicorns\n  @:unicorns\nend\n\ndef \"unicorns\"\n  @\"unicorns\"\nend\n```\n\nThe last two definitions are invalid and so will give a compile-time error.","summary":"<p>A fictitious node representing an idenfitifer like, <code>foo</code>, <code>Bar</code> or <code>something_else</code>.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"+(other:StringLiteral|CharLiteral):MacroId-instance-method","html_id":"+(other:StringLiteral|CharLiteral):MacroId-instance-method","name":"+","doc":"Similar to `String#+`.","summary":"<p>Similar to <code><a href=\"../../String.html#+(other:self)-instance-method\">String#+</a></code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"StringLiteral | CharLiteral"}],"args_string":"(other : StringLiteral | CharLiteral) : MacroId","source_link":null,"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"StringLiteral | CharLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"=~(range:RegexLiteral):BoolLiteral-instance-method","html_id":"=~(range:RegexLiteral):BoolLiteral-instance-method","name":"=~","doc":"Similar to `String#=~`.","summary":"<p>Similar to <code><a href=\"../../String.html#=~(other)-instance-method\">String#=~</a></code>.</p>","abstract":false,"args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"RegexLiteral"}],"args_string":"(range : RegexLiteral) : BoolLiteral","source_link":null,"def":{"name":"=~","args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"RegexLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"[](range:RangeLiteral):MacroId-instance-method","html_id":"[](range:RangeLiteral):MacroId-instance-method","name":"[]","doc":"Similar to `String#[]`.","summary":"<p>Similar to <code><a href=\"../../String.html#[](regex:Regex)-instance-method\">String#[]</a></code>.</p>","abstract":false,"args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"RangeLiteral"}],"args_string":"(range : RangeLiteral) : MacroId","source_link":null,"def":{"name":"[]","args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"RangeLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"capitalize:MacroId-instance-method","html_id":"capitalize:MacroId-instance-method","name":"capitalize","doc":"Similar to `String#capitalize`.","summary":"<p>Similar to <code><a href=\"../../String.html#capitalize(options=Unicode::CaseOptions::None)-instance-method\">String#capitalize</a></code>.</p>","abstract":false,"args":[],"args_string":" : MacroId","source_link":null,"def":{"name":"capitalize","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"chars:Crystal::Macros::ArrayLiteral(CharLiteral)-instance-method","html_id":"chars:Crystal::Macros::ArrayLiteral(CharLiteral)-instance-method","name":"chars","doc":"Similar to `String#chars`.","summary":"<p>Similar to <code><a href=\"../../String.html#chars-instance-method\">String#chars</a></code>.</p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(CharLiteral)","source_link":null,"def":{"name":"chars","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(CharLiteral)","visibility":"Public","body":""}},{"id":"chomp:MacroId-instance-method","html_id":"chomp:MacroId-instance-method","name":"chomp","doc":"Similar to `String#chomp`.","summary":"<p>Similar to <code><a href=\"../../String.html#chomp-instance-method\">String#chomp</a></code>.</p>","abstract":false,"args":[],"args_string":" : MacroId","source_link":null,"def":{"name":"chomp","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"downcase:MacroId-instance-method","html_id":"downcase:MacroId-instance-method","name":"downcase","doc":"Similar to `String#downcase`.","summary":"<p>Similar to <code><a href=\"../../String.html#downcase(options=Unicode::CaseOptions::None)-instance-method\">String#downcase</a></code>.</p>","abstract":false,"args":[],"args_string":" : MacroId","source_link":null,"def":{"name":"downcase","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"empty?:BoolLiteral-instance-method","html_id":"empty?:BoolLiteral-instance-method","name":"empty?","doc":"Similar to `String#empty?`.","summary":"<p>Similar to <code><a href=\"../../String.html#empty?-instance-method\">String#empty?</a></code>.</p>","abstract":false,"args":[],"args_string":" : BoolLiteral","source_link":null,"def":{"name":"empty?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"ends_with?(other:StringLiteral|CharLiteral):BoolLiteral-instance-method","html_id":"ends_with?(other:StringLiteral|CharLiteral):BoolLiteral-instance-method","name":"ends_with?","doc":"Similar to `String#ends_with?`.","summary":"<p>Similar to <code><a href=\"../../String.html#ends_with?(re:Regex)-instance-method\">String#ends_with?</a></code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"StringLiteral | CharLiteral"}],"args_string":"(other : StringLiteral | CharLiteral) : BoolLiteral","source_link":null,"def":{"name":"ends_with?","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"StringLiteral | CharLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"gsub(regex:RegexLiteral,replacement:StringLiteral):MacroId-instance-method","html_id":"gsub(regex:RegexLiteral,replacement:StringLiteral):MacroId-instance-method","name":"gsub","doc":"Similar to `String#gsub`.","summary":"<p>Similar to <code><a href=\"../../String.html#gsub(&block:Char-%3EUNDERSCORE)-instance-method\">String#gsub</a></code>.</p>","abstract":false,"args":[{"name":"regex","doc":null,"default_value":"","external_name":"regex","restriction":"RegexLiteral"},{"name":"replacement","doc":null,"default_value":"","external_name":"replacement","restriction":"StringLiteral"}],"args_string":"(regex : RegexLiteral, replacement : StringLiteral) : MacroId","source_link":null,"def":{"name":"gsub","args":[{"name":"regex","doc":null,"default_value":"","external_name":"regex","restriction":"RegexLiteral"},{"name":"replacement","doc":null,"default_value":"","external_name":"replacement","restriction":"StringLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"id:MacroId-instance-method","html_id":"id:MacroId-instance-method","name":"id","doc":"Returns self.","summary":"<p>Returns self.</p>","abstract":false,"args":[],"args_string":" : MacroId","source_link":null,"def":{"name":"id","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"includes?(search:StringLiteral|CharLiteral):BoolLiteral-instance-method","html_id":"includes?(search:StringLiteral|CharLiteral):BoolLiteral-instance-method","name":"includes?","doc":"Similar to `String#includes?`.","summary":"<p>Similar to <code><a href=\"../../String.html#includes?(search:Char%7CString)-instance-method\">String#includes?</a></code>.</p>","abstract":false,"args":[{"name":"search","doc":null,"default_value":"","external_name":"search","restriction":"StringLiteral | CharLiteral"}],"args_string":"(search : StringLiteral | CharLiteral) : BoolLiteral","source_link":null,"def":{"name":"includes?","args":[{"name":"search","doc":null,"default_value":"","external_name":"search","restriction":"StringLiteral | CharLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"lines:Crystal::Macros::ArrayLiteral(StringLiteral)-instance-method","html_id":"lines:Crystal::Macros::ArrayLiteral(StringLiteral)-instance-method","name":"lines","doc":"Similar to `String#lines`.","summary":"<p>Similar to <code><a href=\"../../String.html#lines(chomp=true)-instance-method\">String#lines</a></code>.</p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(StringLiteral)","source_link":null,"def":{"name":"lines","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(StringLiteral)","visibility":"Public","body":""}},{"id":"size:NumberLiteral-instance-method","html_id":"size:NumberLiteral-instance-method","name":"size","doc":"Similar to `String#size`.","summary":"<p>Similar to <code><a href=\"../../String.html#size-instance-method\">String#size</a></code>.</p>","abstract":false,"args":[],"args_string":" : NumberLiteral","source_link":null,"def":{"name":"size","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral","visibility":"Public","body":""}},{"id":"split(node:ASTNode):Crystal::Macros::ArrayLiteral(StringLiteral)-instance-method","html_id":"split(node:ASTNode):Crystal::Macros::ArrayLiteral(StringLiteral)-instance-method","name":"split","doc":"Similar to `String#split`.","summary":"<p>Similar to <code><a href=\"../../String.html#split(separator:Char,limit=nil,*,remove_empty=false)-instance-method\">String#split</a></code>.</p>","abstract":false,"args":[{"name":"node","doc":null,"default_value":"","external_name":"node","restriction":"ASTNode"}],"args_string":"(node : ASTNode) : Crystal::Macros::ArrayLiteral(StringLiteral)","source_link":null,"def":{"name":"split","args":[{"name":"node","doc":null,"default_value":"","external_name":"node","restriction":"ASTNode"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(StringLiteral)","visibility":"Public","body":""}},{"id":"split:Crystal::Macros::ArrayLiteral(StringLiteral)-instance-method","html_id":"split:Crystal::Macros::ArrayLiteral(StringLiteral)-instance-method","name":"split","doc":"Similar to `String#split`.","summary":"<p>Similar to <code><a href=\"../../String.html#split(separator:Char,limit=nil,*,remove_empty=false)-instance-method\">String#split</a></code>.</p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(StringLiteral)","source_link":null,"def":{"name":"split","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(StringLiteral)","visibility":"Public","body":""}},{"id":"starts_with?(other:StringLiteral|CharLiteral):BoolLiteral-instance-method","html_id":"starts_with?(other:StringLiteral|CharLiteral):BoolLiteral-instance-method","name":"starts_with?","doc":"Similar to `String#starts_with?`.","summary":"<p>Similar to <code><a href=\"../../String.html#starts_with?(re:Regex)-instance-method\">String#starts_with?</a></code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"StringLiteral | CharLiteral"}],"args_string":"(other : StringLiteral | CharLiteral) : BoolLiteral","source_link":null,"def":{"name":"starts_with?","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"StringLiteral | CharLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"strip:MacroId-instance-method","html_id":"strip:MacroId-instance-method","name":"strip","doc":"Similar to `String#strip`.","summary":"<p>Similar to <code><a href=\"../../String.html#strip-instance-method\">String#strip</a></code>.</p>","abstract":false,"args":[],"args_string":" : MacroId","source_link":null,"def":{"name":"strip","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"tr(from:StringLiteral,to:StringLiteral):MacroId-instance-method","html_id":"tr(from:StringLiteral,to:StringLiteral):MacroId-instance-method","name":"tr","doc":"Similar to `String#tr`.","summary":"<p>Similar to <code><a href=\"../../String.html#tr(from:String,to:String)-instance-method\">String#tr</a></code>.</p>","abstract":false,"args":[{"name":"from","doc":null,"default_value":"","external_name":"from","restriction":"StringLiteral"},{"name":"to","doc":null,"default_value":"","external_name":"to","restriction":"StringLiteral"}],"args_string":"(from : StringLiteral, to : StringLiteral) : MacroId","source_link":null,"def":{"name":"tr","args":[{"name":"from","doc":null,"default_value":"","external_name":"from","restriction":"StringLiteral"},{"name":"to","doc":null,"default_value":"","external_name":"to","restriction":"StringLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"upcase:MacroId-instance-method","html_id":"upcase:MacroId-instance-method","name":"upcase","doc":"Similar to `String#upcase`.","summary":"<p>Similar to <code><a href=\"../../String.html#upcase(options=Unicode::CaseOptions::None)-instance-method\">String#upcase</a></code>.</p>","abstract":false,"args":[],"args_string":" : MacroId","source_link":null,"def":{"name":"upcase","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/MetaVar","path":"Crystal/Macros/MetaVar.html","kind":"class","full_name":"Crystal::Macros::MetaVar","name":"MetaVar","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A fictitious node representing a variable or instance\nvariable, together with type information.","summary":"<p>A fictitious node representing a variable or instance variable, together with type information.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"annotation(type:TypeNode):Annotation|NilLiteral-instance-method","html_id":"annotation(type:TypeNode):Annotation|NilLiteral-instance-method","name":"annotation","doc":"Returns the last `Annotation` with the given `type`\nattached to this variable or `NilLiteral` if there are none.","summary":"<p>Returns the last <code><a href=\"../../Crystal/Macros/Annotation.html\">Annotation</a></code> with the given <code><a href=\"../../Crystal/Macros/MetaVar.html#type:TypeNode%7CNilLiteral-instance-method\">#type</a></code> attached to this variable or <code><a href=\"../../Crystal/Macros/NilLiteral.html\">NilLiteral</a></code> if there are none.</p>","abstract":false,"args":[{"name":"type","doc":null,"default_value":"","external_name":"type","restriction":"TypeNode"}],"args_string":"(type : TypeNode) : Annotation | NilLiteral","source_link":null,"def":{"name":"annotation","args":[{"name":"type","doc":null,"default_value":"","external_name":"type","restriction":"TypeNode"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Annotation | NilLiteral","visibility":"Public","body":""}},{"id":"annotations(type:TypeNode):Crystal::Macros::ArrayLiteral(Annotation)-instance-method","html_id":"annotations(type:TypeNode):Crystal::Macros::ArrayLiteral(Annotation)-instance-method","name":"annotations","doc":"Returns an array of annotations with the given `type`\nattached to this variable, or an empty `ArrayLiteral` if there are none.","summary":"<p>Returns an array of annotations with the given <code><a href=\"../../Crystal/Macros/MetaVar.html#type:TypeNode%7CNilLiteral-instance-method\">#type</a></code> attached to this variable, or an empty <code><a href=\"../../Crystal/Macros/ArrayLiteral.html\">ArrayLiteral</a></code> if there are none.</p>","abstract":false,"args":[{"name":"type","doc":null,"default_value":"","external_name":"type","restriction":"TypeNode"}],"args_string":"(type : TypeNode) : Crystal::Macros::ArrayLiteral(Annotation)","source_link":null,"def":{"name":"annotations","args":[{"name":"type","doc":null,"default_value":"","external_name":"type","restriction":"TypeNode"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(Annotation)","visibility":"Public","body":""}},{"id":"default_value:ASTNode-instance-method","html_id":"default_value:ASTNode-instance-method","name":"default_value","doc":"Returns the default value of this variable.\nNote that if the variable doesn't have a default value,\nor the default value is `nil`, a `NilLiteral` will be\nreturned. To distinguish between these cases, use\n`has_default_value?`.","summary":"<p>Returns the default value of this variable.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"default_value","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"has_default_value?:BoolLiteral-instance-method","html_id":"has_default_value?:BoolLiteral-instance-method","name":"has_default_value?","doc":"Returns whether this variable has a default value\n(which can in turn be `nil`).","summary":"<p>Returns whether this variable has a default value (which can in turn be <code>nil</code>).</p>","abstract":false,"args":[],"args_string":" : BoolLiteral","source_link":null,"def":{"name":"has_default_value?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"name:MacroId-instance-method","html_id":"name:MacroId-instance-method","name":"name","doc":"Returns the name of this variable.","summary":"<p>Returns the name of this variable.</p>","abstract":false,"args":[],"args_string":" : MacroId","source_link":null,"def":{"name":"name","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"type:TypeNode|NilLiteral-instance-method","html_id":"type:TypeNode|NilLiteral-instance-method","name":"type","doc":"Returns the type of this variable, if known, or `nil`.","summary":"<p>Returns the type of this variable, if known, or <code>nil</code>.</p>","abstract":false,"args":[],"args_string":" : TypeNode | NilLiteral","source_link":null,"def":{"name":"type","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"TypeNode | NilLiteral","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/MultiAssign","path":"Crystal/Macros/MultiAssign.html","kind":"class","full_name":"Crystal::Macros::MultiAssign","name":"MultiAssign","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"Multiple assign expression.","summary":"<p>Multiple assign expression.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"targets:Crystal::Macros::ArrayLiteral(ASTNode)-instance-method","html_id":"targets:Crystal::Macros::ArrayLiteral(ASTNode)-instance-method","name":"targets","doc":"Returns the targets assigned to.","summary":"<p>Returns the targets assigned to.</p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(ASTNode)","source_link":null,"def":{"name":"targets","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(ASTNode)","visibility":"Public","body":""}},{"id":"values:Crystal::Macros::ArrayLiteral(ASTNode)-instance-method","html_id":"values:Crystal::Macros::ArrayLiteral(ASTNode)-instance-method","name":"values","doc":"Returns the values that are being assigned.","summary":"<p>Returns the values that are being assigned.</p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(ASTNode)","source_link":null,"def":{"name":"values","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(ASTNode)","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/NamedArgument","path":"Crystal/Macros/NamedArgument.html","kind":"class","full_name":"Crystal::Macros::NamedArgument","name":"NamedArgument","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A call's named argument.","summary":"<p>A call's named argument.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"name:MacroId-instance-method","html_id":"name:MacroId-instance-method","name":"name","doc":"Returns this named argument name.","summary":"<p>Returns this named argument name.</p>","abstract":false,"args":[],"args_string":" : MacroId","source_link":null,"def":{"name":"name","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"value:ASTNode-instance-method","html_id":"value:ASTNode-instance-method","name":"value","doc":"Returns this named argument value.","summary":"<p>Returns this named argument value.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"value","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/NamedTupleLiteral","path":"Crystal/Macros/NamedTupleLiteral.html","kind":"class","full_name":"Crystal::Macros::NamedTupleLiteral","name":"NamedTupleLiteral","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A named tuple literal.","summary":"<p>A named tuple literal.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"[](key:SymbolLiteral|StringLiteral|MacroId):ASTNode-instance-method","html_id":"[](key:SymbolLiteral|StringLiteral|MacroId):ASTNode-instance-method","name":"[]","doc":"Similar to `NamedTuple#[]` but returns `NilLiteral` if *key* is undefined.","summary":"<p>Similar to <code><a href=\"../../NamedTuple.html#[](key:Symbol%7CString)-instance-method\">NamedTuple#[]</a></code> but returns <code><a href=\"../../Crystal/Macros/NilLiteral.html\">NilLiteral</a></code> if <em>key</em> is undefined.</p>","abstract":false,"args":[{"name":"key","doc":null,"default_value":"","external_name":"key","restriction":"SymbolLiteral | StringLiteral | MacroId"}],"args_string":"(key : SymbolLiteral | StringLiteral | MacroId) : ASTNode","source_link":null,"def":{"name":"[]","args":[{"name":"key","doc":null,"default_value":"","external_name":"key","restriction":"SymbolLiteral | StringLiteral | MacroId"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"[]=(key:SymbolLiteral|StringLiteral|MacroId):ASTNode-instance-method","html_id":"[]=(key:SymbolLiteral|StringLiteral|MacroId):ASTNode-instance-method","name":"[]=","doc":"Adds or replaces a key.","summary":"<p>Adds or replaces a key.</p>","abstract":false,"args":[{"name":"key","doc":null,"default_value":"","external_name":"key","restriction":"SymbolLiteral | StringLiteral | MacroId"}],"args_string":"(key : SymbolLiteral | StringLiteral | MacroId) : ASTNode","source_link":null,"def":{"name":"[]=","args":[{"name":"key","doc":null,"default_value":"","external_name":"key","restriction":"SymbolLiteral | StringLiteral | MacroId"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"double_splat(trailing_string:StringLiteral=nil):MacroId-instance-method","html_id":"double_splat(trailing_string:StringLiteral=nil):MacroId-instance-method","name":"double_splat","doc":"Similar to `HashLiteral#double_splat`","summary":"<p>Similar to <code><a href=\"../../Crystal/Macros/HashLiteral.html#double_splat(trailing_string:StringLiteral=nil):MacroId-instance-method\">HashLiteral#double_splat</a></code></p>","abstract":false,"args":[{"name":"trailing_string","doc":null,"default_value":"nil","external_name":"trailing_string","restriction":"StringLiteral"}],"args_string":"(trailing_string : StringLiteral = <span class=\"n\">nil</span>) : MacroId","source_link":null,"def":{"name":"double_splat","args":[{"name":"trailing_string","doc":null,"default_value":"nil","external_name":"trailing_string","restriction":"StringLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"empty?:BoolLiteral-instance-method","html_id":"empty?:BoolLiteral-instance-method","name":"empty?","doc":"Similar to `NamedTuple#empty?`","summary":"<p>Similar to <code><a href=\"../../NamedTuple.html#empty?-instance-method\">NamedTuple#empty?</a></code></p>","abstract":false,"args":[],"args_string":" : BoolLiteral","source_link":null,"def":{"name":"empty?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"keys:ArrayLiteral-instance-method","html_id":"keys:ArrayLiteral-instance-method","name":"keys","doc":"Similar to `NamedTuple#keys`","summary":"<p>Similar to <code><a href=\"../../NamedTuple.html#keys-instance-method\">NamedTuple#keys</a></code></p>","abstract":false,"args":[],"args_string":" : ArrayLiteral","source_link":null,"def":{"name":"keys","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral","visibility":"Public","body":""}},{"id":"map:ArrayLiteral-instance-method","html_id":"map:ArrayLiteral-instance-method","name":"map","doc":"Similar to `NamedTuple#map`","summary":"<p>Similar to <code><a href=\"../../NamedTuple.html#map(&block)-instance-method\">NamedTuple#map</a></code></p>","abstract":false,"args":[],"args_string":" : ArrayLiteral","source_link":null,"def":{"name":"map","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral","visibility":"Public","body":""}},{"id":"size:NumberLiteral-instance-method","html_id":"size:NumberLiteral-instance-method","name":"size","doc":"Similar to `NamedTuple#size`","summary":"<p>Similar to <code><a href=\"../../NamedTuple.html#size-instance-method\">NamedTuple#size</a></code></p>","abstract":false,"args":[],"args_string":" : NumberLiteral","source_link":null,"def":{"name":"size","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral","visibility":"Public","body":""}},{"id":"to_a:Crystal::Macros::ArrayLiteral(TupleLiteral)-instance-method","html_id":"to_a:Crystal::Macros::ArrayLiteral(TupleLiteral)-instance-method","name":"to_a","doc":"Similar to `NamedTuple#to_a`","summary":"<p>Similar to <code><a href=\"../../NamedTuple.html#to_a-instance-method\">NamedTuple#to_a</a></code></p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(TupleLiteral)","source_link":null,"def":{"name":"to_a","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(TupleLiteral)","visibility":"Public","body":""}},{"id":"values:ArrayLiteral-instance-method","html_id":"values:ArrayLiteral-instance-method","name":"values","doc":"Similar to `NamedTuple#values`","summary":"<p>Similar to <code><a href=\"../../NamedTuple.html#values-instance-method\">NamedTuple#values</a></code></p>","abstract":false,"args":[],"args_string":" : ArrayLiteral","source_link":null,"def":{"name":"values","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/NilableCast","path":"Crystal/Macros/NilableCast.html","kind":"class","full_name":"Crystal::Macros::NilableCast","name":"NilableCast","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A cast call: `obj.as?(to)`","summary":"<p>A cast call: <code>obj.as?(to)</code></p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"obj:ASTNode-instance-method","html_id":"obj:ASTNode-instance-method","name":"obj","doc":"Returns the object part of the cast.","summary":"<p>Returns the object part of the cast.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"obj","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"to:ASTNode-instance-method","html_id":"to:ASTNode-instance-method","name":"to","doc":"Returns the target type of the cast.","summary":"<p>Returns the target type of the cast.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"to","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/NilLiteral","path":"Crystal/Macros/NilLiteral.html","kind":"class","full_name":"Crystal::Macros::NilLiteral","name":"NilLiteral","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"The nil literal.","summary":"<p>The nil literal.</p>","class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/Nop","path":"Crystal/Macros/Nop.html","kind":"class","full_name":"Crystal::Macros::Nop","name":"Nop","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"The empty node. Similar to a `NilLiteral` but its textual representation\nis the empty string. This corresponds, for example, to the missing `else` branch of\nan `if` without an `else`.","summary":"<p>The empty node.</p>","class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/Not","path":"Crystal/Macros/Not.html","kind":"class","full_name":"Crystal::Macros::Not","name":"Not","abstract":false,"superclass":{"html_id":"/Crystal/Macros/UnaryExpression","kind":"class","full_name":"Crystal::Macros::UnaryExpression","name":"UnaryExpression"},"ancestors":[{"html_id":"/Crystal/Macros/UnaryExpression","kind":"class","full_name":"Crystal::Macros::UnaryExpression","name":"UnaryExpression"},{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"An unary `not` (`!`).","summary":"<p>An unary <code>not</code> (<code>!</code>).</p>","class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/NumberLiteral","path":"Crystal/Macros/NumberLiteral.html","kind":"class","full_name":"Crystal::Macros::NumberLiteral","name":"NumberLiteral","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"Any number literal.","summary":"<p>Any number literal.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"%(other:NumberLiteral):NumberLiteral-instance-method","html_id":"%(other:NumberLiteral):NumberLiteral-instance-method","name":"%","doc":"Same as `Number#%`","summary":"<p>Same as <code><a href=\"../../Number.html\">Number</a>#%</code></p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"args_string":"(other : NumberLiteral) : NumberLiteral","source_link":null,"def":{"name":"%","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral","visibility":"Public","body":""}},{"id":"&(other:NumberLiteral):NumberLiteral-instance-method","html_id":"&amp;(other:NumberLiteral):NumberLiteral-instance-method","name":"&","doc":"Same as `Number#&`","summary":"<p>Same as <code>Number#&</code></p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"args_string":"(other : NumberLiteral) : NumberLiteral","source_link":null,"def":{"name":"&","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral","visibility":"Public","body":""}},{"id":"*(other:NumberLiteral):NumberLiteral-instance-method","html_id":"*(other:NumberLiteral):NumberLiteral-instance-method","name":"*","doc":"Same as `Number#*`","summary":"<p>Same as <code><a href=\"../../Number.html#*(other:Complex)-instance-method\">Number#*</a></code></p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"args_string":"(other : NumberLiteral) : NumberLiteral","source_link":null,"def":{"name":"*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral","visibility":"Public","body":""}},{"id":"**(other:NumberLiteral):NumberLiteral-instance-method","html_id":"**(other:NumberLiteral):NumberLiteral-instance-method","name":"**","doc":"Same as `Number#**`","summary":"<p>Same as <code>Number#**</code></p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"args_string":"(other : NumberLiteral) : NumberLiteral","source_link":null,"def":{"name":"**","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral","visibility":"Public","body":""}},{"id":"+(other:NumberLiteral):NumberLiteral-instance-method","html_id":"+(other:NumberLiteral):NumberLiteral-instance-method","name":"+","doc":"Same as `Number#+`","summary":"<p>Same as <code><a href=\"../../Number.html#+-instance-method\">Number#+</a></code></p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"args_string":"(other : NumberLiteral) : NumberLiteral","source_link":null,"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral","visibility":"Public","body":""}},{"id":"+:NumberLiteral-instance-method","html_id":"+:NumberLiteral-instance-method","name":"+","doc":"Same as `Number#+`","summary":"<p>Same as <code><a href=\"../../Number.html#+-instance-method\">Number#+</a></code></p>","abstract":false,"args":[],"args_string":" : NumberLiteral","source_link":null,"def":{"name":"+","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral","visibility":"Public","body":""}},{"id":"-(other:NumberLiteral):NumberLiteral-instance-method","html_id":"-(other:NumberLiteral):NumberLiteral-instance-method","name":"-","doc":"Same as `Number#-`","summary":"<p>Same as <code><a href=\"../../Number.html#-(other:Complex)-instance-method\">Number#-</a></code></p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"args_string":"(other : NumberLiteral) : NumberLiteral","source_link":null,"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral","visibility":"Public","body":""}},{"id":"-:NumberLiteral-instance-method","html_id":"-:NumberLiteral-instance-method","name":"-","doc":"Same as `Number#-`","summary":"<p>Same as <code><a href=\"../../Number.html#-(other:Complex)-instance-method\">Number#-</a></code></p>","abstract":false,"args":[],"args_string":" : NumberLiteral","source_link":null,"def":{"name":"-","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral","visibility":"Public","body":""}},{"id":"//(other:NumberLiteral):NumberLiteral-instance-method","html_id":"//(other:NumberLiteral):NumberLiteral-instance-method","name":"//","doc":"Same as `Number#//`","summary":"<p>Same as <code><a href=\"../../Number.html#//(other)-instance-method\">Number#//</a></code></p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"args_string":"(other : NumberLiteral) : NumberLiteral","source_link":null,"def":{"name":"//","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral","visibility":"Public","body":""}},{"id":"<(other:NumberLiteral):BoolLiteral-instance-method","html_id":"&lt;(other:NumberLiteral):BoolLiteral-instance-method","name":"<","doc":"Compares this node's value to another node's value.","summary":"<p>Compares this node's value to another node's value.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"args_string":"(other : NumberLiteral) : BoolLiteral","source_link":null,"def":{"name":"<","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"<<(other:NumberLiteral):NumberLiteral-instance-method","html_id":"&lt;&lt;(other:NumberLiteral):NumberLiteral-instance-method","name":"<<","doc":"Same as `Number#<<`","summary":"<p>Same as <code>Number#<<</code></p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"args_string":"(other : NumberLiteral) : NumberLiteral","source_link":null,"def":{"name":"<<","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral","visibility":"Public","body":""}},{"id":"<=(other:NumberLiteral):BoolLiteral-instance-method","html_id":"&lt;=(other:NumberLiteral):BoolLiteral-instance-method","name":"<=","doc":"Compares this node's value to another node's value.","summary":"<p>Compares this node's value to another node's value.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"args_string":"(other : NumberLiteral) : BoolLiteral","source_link":null,"def":{"name":"<=","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"(other:NumberLiteral):NumberLiteral-instance-method","html_id":"(other:NumberLiteral):NumberLiteral-instance-method","name":"<=>","doc":"Compares this node's value to another node's value.","summary":"<p>Compares this node's value to another node's value.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"args_string":"(other : NumberLiteral) : NumberLiteral","source_link":null,"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral","visibility":"Public","body":""}},{"id":">(other:NumberLiteral):BoolLiteral-instance-method","html_id":"&gt;(other:NumberLiteral):BoolLiteral-instance-method","name":">","doc":"Compares this node's value to another node's value.","summary":"<p>Compares this node's value to another node's value.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"args_string":"(other : NumberLiteral) : BoolLiteral","source_link":null,"def":{"name":">","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":">=(other:NumberLiteral):BoolLiteral-instance-method","html_id":"&gt;=(other:NumberLiteral):BoolLiteral-instance-method","name":">=","doc":"Compares this node's value to another node's value.","summary":"<p>Compares this node's value to another node's value.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"args_string":"(other : NumberLiteral) : BoolLiteral","source_link":null,"def":{"name":">=","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":">>(other:NumberLiteral):NumberLiteral-instance-method","html_id":"&gt;&gt;(other:NumberLiteral):NumberLiteral-instance-method","name":">>","doc":"Same as `Number#>>`","summary":"<p>Same as <code>Number#>></code></p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"args_string":"(other : NumberLiteral) : NumberLiteral","source_link":null,"def":{"name":">>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral","visibility":"Public","body":""}},{"id":"^(other:NumberLiteral):NumberLiteral-instance-method","html_id":"^(other:NumberLiteral):NumberLiteral-instance-method","name":"^","doc":"Same as `Number#^`","summary":"<p>Same as <code>Number#^</code></p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"args_string":"(other : NumberLiteral) : NumberLiteral","source_link":null,"def":{"name":"^","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral","visibility":"Public","body":""}},{"id":"kind:SymbolLiteral-instance-method","html_id":"kind:SymbolLiteral-instance-method","name":"kind","doc":"The type of the literal: `:i32`, `:u16`, `:f32`, `:f64`, etc.","summary":"<p>The type of the literal: <code>:i32</code>, <code>:u16</code>, <code>:f32</code>, <code>:f64</code>, etc.</p>","abstract":false,"args":[],"args_string":" : SymbolLiteral","source_link":null,"def":{"name":"kind","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"SymbolLiteral","visibility":"Public","body":""}},{"id":"|(other:NumberLiteral):NumberLiteral-instance-method","html_id":"|(other:NumberLiteral):NumberLiteral-instance-method","name":"|","doc":"Same as `Number#|`","summary":"<p>Same as <code>Number#|</code></p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"args_string":"(other : NumberLiteral) : NumberLiteral","source_link":null,"def":{"name":"|","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"NumberLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral","visibility":"Public","body":""}},{"id":"~:NumberLiteral-instance-method","html_id":"~:NumberLiteral-instance-method","name":"~","doc":"Same as `Number#~`","summary":"<p>Same as <code>Number#~</code></p>","abstract":false,"args":[],"args_string":" : NumberLiteral","source_link":null,"def":{"name":"~","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/OffsetOf","path":"Crystal/Macros/OffsetOf.html","kind":"class","full_name":"Crystal::Macros::OffsetOf","name":"OffsetOf","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"An `offsetof` expression.","summary":"<p>An <code>offsetof</code> expression.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"instance_var:ASTNode-instance-method","html_id":"instance_var:ASTNode-instance-method","name":"instance_var","doc":"Returns the instance variable used in this `offsetof` expression.","summary":"<p>Returns the instance variable used in this <code>offsetof</code> expression.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"instance_var","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"type:ASTNode-instance-method","html_id":"type:ASTNode-instance-method","name":"type","doc":"Returns the type that has been used in this `offsetof` expression.","summary":"<p>Returns the type that has been used in this <code>offsetof</code> expression.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"type","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/Or","path":"Crystal/Macros/Or.html","kind":"class","full_name":"Crystal::Macros::Or","name":"Or","abstract":false,"superclass":{"html_id":"/Crystal/Macros/BinaryOp","kind":"class","full_name":"Crystal::Macros::BinaryOp","name":"BinaryOp"},"ancestors":[{"html_id":"/Crystal/Macros/BinaryOp","kind":"class","full_name":"Crystal::Macros::BinaryOp","name":"BinaryOp"},{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"An `||` (or) expression","summary":"<p>An <code>||</code> (or) expression</p>","class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/Out","path":"Crystal/Macros/Out.html","kind":"class","full_name":"Crystal::Macros::Out","name":"Out","abstract":false,"superclass":{"html_id":"/Crystal/Macros/UnaryExpression","kind":"class","full_name":"Crystal::Macros::UnaryExpression","name":"UnaryExpression"},"ancestors":[{"html_id":"/Crystal/Macros/UnaryExpression","kind":"class","full_name":"Crystal::Macros::UnaryExpression","name":"UnaryExpression"},{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"An `out` expression.","summary":"<p>An <code>out</code> expression.</p>","class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/Path","path":"Crystal/Macros/Path.html","kind":"class","full_name":"Crystal::Macros::Path","name":"Path","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A Path to a constant or type, like `Foo` or `Foo::Bar::Baz`.","summary":"<p>A Path to a constant or type, like <code>Foo</code> or <code>Foo::Bar::Baz</code>.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"global?:BoolLiteral-instance-method","html_id":"global?:BoolLiteral-instance-method","name":"global?","doc":"Returns `true` if this is a global path (starts with `::`)","summary":"<p>Returns <code>true</code> if this is a global path (starts with <code>::</code>)</p>","abstract":false,"args":[],"args_string":" : BoolLiteral","source_link":null,"def":{"name":"global?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"names:Crystal::Macros::ArrayLiteral(MacroId)-instance-method","html_id":"names:Crystal::Macros::ArrayLiteral(MacroId)-instance-method","name":"names","doc":"Returns an array with each separate part of this path.","summary":"<p>Returns an array with each separate part of this path.</p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(MacroId)","source_link":null,"def":{"name":"names","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(MacroId)","visibility":"Public","body":""}},{"id":"resolve:ASTNode-instance-method","html_id":"resolve:ASTNode-instance-method","name":"resolve","doc":"Resolves this path to a `TypeNode` if it denotes a type, to\nthe value of a constant if it denotes a constant, or otherwise\ngives a compile-time error.","summary":"<p>Resolves this path to a <code><a href=\"../../Crystal/Macros/TypeNode.html\">TypeNode</a></code> if it denotes a type, to the value of a constant if it denotes a constant, or otherwise gives a compile-time error.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"resolve","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"resolve?:ASTNode|NilLiteral-instance-method","html_id":"resolve?:ASTNode|NilLiteral-instance-method","name":"resolve?","doc":"Resolves this path to a `TypeNode` if it denotes a type, to\nthe value of a constant if it denotes a constant, or otherwise\nreturns a `NilLiteral`.","summary":"<p>Resolves this path to a <code><a href=\"../../Crystal/Macros/TypeNode.html\">TypeNode</a></code> if it denotes a type, to the value of a constant if it denotes a constant, or otherwise returns a <code><a href=\"../../Crystal/Macros/NilLiteral.html\">NilLiteral</a></code>.</p>","abstract":false,"args":[],"args_string":" : ASTNode | NilLiteral","source_link":null,"def":{"name":"resolve?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode | NilLiteral","visibility":"Public","body":""}},{"id":"types:Crystal::Macros::ArrayLiteral(ASTNode)-instance-method","html_id":"types:Crystal::Macros::ArrayLiteral(ASTNode)-instance-method","name":"types","doc":"Returns this path inside an array literal.\nThis method exists so you can call `types` on the type of a type\ndeclaration and get all types, whether it's a Generic, Path or Union.","summary":"<p>Returns this path inside an array literal.</p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(ASTNode)","source_link":null,"def":{"name":"types","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(ASTNode)","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/PointerOf","path":"Crystal/Macros/PointerOf.html","kind":"class","full_name":"Crystal::Macros::PointerOf","name":"PointerOf","abstract":false,"superclass":{"html_id":"/Crystal/Macros/UnaryExpression","kind":"class","full_name":"Crystal::Macros::UnaryExpression","name":"UnaryExpression"},"ancestors":[{"html_id":"/Crystal/Macros/UnaryExpression","kind":"class","full_name":"Crystal::Macros::UnaryExpression","name":"UnaryExpression"},{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A `pointerof` expression.","summary":"<p>A <code>pointerof</code> expression.</p>","class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/ProcLiteral","path":"Crystal/Macros/ProcLiteral.html","kind":"class","full_name":"Crystal::Macros::ProcLiteral","name":"ProcLiteral","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A proc method, written like:\n```\n->(arg : String) {\n  puts arg\n}\n```","summary":"<p>A proc method, written like: <code></code>` ->(arg : String) {   puts arg } <code></code>`</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"args:Crystal::Macros::ArrayLiteral(Arg)-instance-method","html_id":"args:Crystal::Macros::ArrayLiteral(Arg)-instance-method","name":"args","doc":"Returns the arguments of this proc.","summary":"<p>Returns the arguments of this proc.</p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(Arg)","source_link":null,"def":{"name":"args","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(Arg)","visibility":"Public","body":""}},{"id":"body:ASTNode-instance-method","html_id":"body:ASTNode-instance-method","name":"body","doc":"Returns the body of this proc.","summary":"<p>Returns the body of this proc.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"body","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/ProcNotation","path":"Crystal/Macros/ProcNotation.html","kind":"class","full_name":"Crystal::Macros::ProcNotation","name":"ProcNotation","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"The type of a proc or block argument, like `String -> Int32`.","summary":"<p>The type of a proc or block argument, like <code><a href=\"../../String.html\">String</a> -> <a href=\"../../Int32.html\">Int32</a></code>.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"inputs:Crystal::Macros::ArrayLiteral(ASTNode)-instance-method","html_id":"inputs:Crystal::Macros::ArrayLiteral(ASTNode)-instance-method","name":"inputs","doc":"Returns the argument types, or an empty list if no arguments.","summary":"<p>Returns the argument types, or an empty list if no arguments.</p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(ASTNode)","source_link":null,"def":{"name":"inputs","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(ASTNode)","visibility":"Public","body":""}},{"id":"output:ASTNode|NilLiteral-instance-method","html_id":"output:ASTNode|NilLiteral-instance-method","name":"output","doc":"Returns the output type, or nil if there is no return type.","summary":"<p>Returns the output type, or nil if there is no return type.</p>","abstract":false,"args":[],"args_string":" : ASTNode | NilLiteral","source_link":null,"def":{"name":"output","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode | NilLiteral","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/ProcPointer","path":"Crystal/Macros/ProcPointer.html","kind":"class","full_name":"Crystal::Macros::ProcPointer","name":"ProcPointer","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A proc pointer, like `->my_var.some_method(String)`","summary":"<p>A proc pointer, like <code>->my_var.some_method(String)</code></p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"args:Crystal::Macros::ArrayLiteral(ASTNode)-instance-method","html_id":"args:Crystal::Macros::ArrayLiteral(ASTNode)-instance-method","name":"args","doc":"Returns the types of the arguments of the proc.","summary":"<p>Returns the types of the arguments of the proc.</p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(ASTNode)","source_link":null,"def":{"name":"args","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(ASTNode)","visibility":"Public","body":""}},{"id":"name:MacroId-instance-method","html_id":"name:MacroId-instance-method","name":"name","doc":"Returns the name of the method this proc points to.","summary":"<p>Returns the name of the method this proc points to.</p>","abstract":false,"args":[],"args_string":" : MacroId","source_link":null,"def":{"name":"name","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"obj:ASTNode|NilLiteral-instance-method","html_id":"obj:ASTNode|NilLiteral-instance-method","name":"obj","doc":"Returns the receiver of the proc, or nil if the proc is not attached to an object.","summary":"<p>Returns the receiver of the proc, or nil if the proc is not attached to an object.</p>","abstract":false,"args":[],"args_string":" : ASTNode | NilLiteral","source_link":null,"def":{"name":"obj","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode | NilLiteral","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/RangeLiteral","path":"Crystal/Macros/RangeLiteral.html","kind":"class","full_name":"Crystal::Macros::RangeLiteral","name":"RangeLiteral","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A range literal.","summary":"<p>A range literal.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"begin:ASTNode-instance-method","html_id":"begin:ASTNode-instance-method","name":"begin","doc":"Similar to `Range#begin`","summary":"<p>Similar to <code><a href=\"../../Range.html#begin:B-instance-method\">Range#begin</a></code></p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"begin","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"end:ASTNode-instance-method","html_id":"end:ASTNode-instance-method","name":"end","doc":"Similar to `Range#end`","summary":"<p>Similar to <code><a href=\"../../Range.html#end:E-instance-method\">Range#end</a></code></p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"end","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"excludes_end?:ASTNode-instance-method","html_id":"excludes_end?:ASTNode-instance-method","name":"excludes_end?","doc":"Similar to `Range#excludes_end?`","summary":"<p>Similar to <code><a href=\"../../Range.html#excludes_end?-instance-method\">Range#excludes_end?</a></code></p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"excludes_end?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}},{"id":"map:ArrayLiteral-instance-method","html_id":"map:ArrayLiteral-instance-method","name":"map","doc":"Similar to `Enumerable#map` for a `Range`.\nOnly works on ranges of `NumberLiteral`s considered as integers.","summary":"<p>Similar to <code><a href=\"../../Enumerable.html#map(&block:T-%3EU)forallU-instance-method\">Enumerable#map</a></code> for a <code><a href=\"../../Range.html\">Range</a></code>.</p>","abstract":false,"args":[],"args_string":" : ArrayLiteral","source_link":null,"def":{"name":"map","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral","visibility":"Public","body":""}},{"id":"to_a:ArrayLiteral-instance-method","html_id":"to_a:ArrayLiteral-instance-method","name":"to_a","doc":"Similar to `Enumerable#to_a` for a `Range`.\nOnly works on ranges of `NumberLiteral`s considered as integers.","summary":"<p>Similar to <code><a href=\"../../Enumerable.html#to_a-instance-method\">Enumerable#to_a</a></code> for a <code><a href=\"../../Range.html\">Range</a></code>.</p>","abstract":false,"args":[],"args_string":" : ArrayLiteral","source_link":null,"def":{"name":"to_a","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/ReadInstanceVar","path":"Crystal/Macros/ReadInstanceVar.html","kind":"class","full_name":"Crystal::Macros::ReadInstanceVar","name":"ReadInstanceVar","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"Access to an instance variable, e.g. `obj.@var`.","summary":"<p>Access to an instance variable, e.g.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"name:MacroId-instance-method","html_id":"name:MacroId-instance-method","name":"name","doc":"Returns the name of the instance variable being accessed.","summary":"<p>Returns the name of the instance variable being accessed.</p>","abstract":false,"args":[],"args_string":" : MacroId","source_link":null,"def":{"name":"name","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"obj:ASTNode-instance-method","html_id":"obj:ASTNode-instance-method","name":"obj","doc":"Returns the object whose variable is being accessed.","summary":"<p>Returns the object whose variable is being accessed.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"obj","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/RegexLiteral","path":"Crystal/Macros/RegexLiteral.html","kind":"class","full_name":"Crystal::Macros::RegexLiteral","name":"RegexLiteral","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A regular expression literal.","summary":"<p>A regular expression literal.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"options:Crystal::Macros::ArrayLiteral(SymbolLiteral)-instance-method","html_id":"options:Crystal::Macros::ArrayLiteral(SymbolLiteral)-instance-method","name":"options","doc":"Similar to `Regex#options`,\nbut returns an array of symbols such as `[:i, :m, :x]`","summary":"<p>Similar to <code><a href=\"../../Regex.html#options:Options-instance-method\">Regex#options</a></code>, but returns an array of symbols such as <code>[:i, :m, :x]</code></p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(SymbolLiteral)","source_link":null,"def":{"name":"options","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(SymbolLiteral)","visibility":"Public","body":""}},{"id":"source:StringLiteral|StringInterpolation-instance-method","html_id":"source:StringLiteral|StringInterpolation-instance-method","name":"source","doc":"Similar to `Regex#source`.","summary":"<p>Similar to <code><a href=\"../../Regex.html#source:String-instance-method\">Regex#source</a></code>.</p>","abstract":false,"args":[],"args_string":" : StringLiteral | StringInterpolation","source_link":null,"def":{"name":"source","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral | StringInterpolation","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/Require","path":"Crystal/Macros/Require.html","kind":"class","full_name":"Crystal::Macros::Require","name":"Require","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A `require` statement.","summary":"<p>A <code>require</code> statement.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"path:StringLiteral-instance-method","html_id":"path:StringLiteral-instance-method","name":"path","doc":"Returns the argument of the `require`.","summary":"<p>Returns the argument of the <code>require</code>.</p>","abstract":false,"args":[],"args_string":" : StringLiteral","source_link":null,"def":{"name":"path","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/RespondsTo","path":"Crystal/Macros/RespondsTo.html","kind":"class","full_name":"Crystal::Macros::RespondsTo","name":"RespondsTo","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A `.responds_to?` call.","summary":"<p>A <code>.responds_to?</code> call.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"name:StringLiteral-instance-method","html_id":"name:StringLiteral-instance-method","name":"name","doc":"Returns the method name that is being checked for.","summary":"<p>Returns the method name that is being checked for.</p>","abstract":false,"args":[],"args_string":" : StringLiteral","source_link":null,"def":{"name":"name","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral","visibility":"Public","body":""}},{"id":"receiver:ASTNode-instance-method","html_id":"receiver:ASTNode-instance-method","name":"receiver","doc":"Returns this call's receiver.","summary":"<p>Returns this call's receiver.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"receiver","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/SizeOf","path":"Crystal/Macros/SizeOf.html","kind":"class","full_name":"Crystal::Macros::SizeOf","name":"SizeOf","abstract":false,"superclass":{"html_id":"/Crystal/Macros/UnaryExpression","kind":"class","full_name":"Crystal::Macros::UnaryExpression","name":"UnaryExpression"},"ancestors":[{"html_id":"/Crystal/Macros/UnaryExpression","kind":"class","full_name":"Crystal::Macros::UnaryExpression","name":"UnaryExpression"},{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A `sizeof` expression.","summary":"<p>A <code>sizeof</code> expression.</p>","class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/Splat","path":"Crystal/Macros/Splat.html","kind":"class","full_name":"Crystal::Macros::Splat","name":"Splat","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A splat expression: `*exp`.","summary":"<p>A splat expression: <code>*exp</code>.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"exp:ASTNode-instance-method","html_id":"exp:ASTNode-instance-method","name":"exp","doc":"Returns the splatted expression.","summary":"<p>Returns the splatted expression.</p>","abstract":false,"args":[],"args_string":" : ASTNode","source_link":null,"def":{"name":"exp","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ASTNode","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/StringInterpolation","path":"Crystal/Macros/StringInterpolation.html","kind":"class","full_name":"Crystal::Macros::StringInterpolation","name":"StringInterpolation","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"An interpolated string like `\"Hello, #{name}!\"`.","summary":"<p>An interpolated string like <code>\"Hello, #{name}!\"</code>.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"expressions:Crystal::Macros::ArrayLiteral(ASTNode)-instance-method","html_id":"expressions:Crystal::Macros::ArrayLiteral(ASTNode)-instance-method","name":"expressions","doc":"Returns a list of expressions that comprise the interpolated string.\n\nThese alternate between `StringLiteral` for the plaintext parts and\n`ASTNode`s of any type for the interpolated expressions.","summary":"<p>Returns a list of expressions that comprise the interpolated string.</p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(ASTNode)","source_link":null,"def":{"name":"expressions","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(ASTNode)","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/StringLiteral","path":"Crystal/Macros/StringLiteral.html","kind":"class","full_name":"Crystal::Macros::StringLiteral","name":"StringLiteral","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A string literal.","summary":"<p>A string literal.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"+(other:StringLiteral|CharLiteral):StringLiteral-instance-method","html_id":"+(other:StringLiteral|CharLiteral):StringLiteral-instance-method","name":"+","doc":"Similar to `String#+`.","summary":"<p>Similar to <code><a href=\"../../String.html#+(other:self)-instance-method\">String#+</a></code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"StringLiteral | CharLiteral"}],"args_string":"(other : StringLiteral | CharLiteral) : StringLiteral","source_link":null,"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"StringLiteral | CharLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral","visibility":"Public","body":""}},{"id":"<(other:StringLiteral|MacroId):BoolLiteral-instance-method","html_id":"&lt;(other:StringLiteral|MacroId):BoolLiteral-instance-method","name":"<","doc":"Similar to `String#<`","summary":"<p>Similar to <code>String#<</code></p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"StringLiteral | MacroId"}],"args_string":"(other : StringLiteral | MacroId) : BoolLiteral","source_link":null,"def":{"name":"<","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"StringLiteral | MacroId"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"=~(range:RegexLiteral):BoolLiteral-instance-method","html_id":"=~(range:RegexLiteral):BoolLiteral-instance-method","name":"=~","doc":"Similar to `String#=~`.","summary":"<p>Similar to <code><a href=\"../../String.html#=~(other)-instance-method\">String#=~</a></code>.</p>","abstract":false,"args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"RegexLiteral"}],"args_string":"(range : RegexLiteral) : BoolLiteral","source_link":null,"def":{"name":"=~","args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"RegexLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":">(other:StringLiteral|MacroId):BoolLiteral-instance-method","html_id":"&gt;(other:StringLiteral|MacroId):BoolLiteral-instance-method","name":">","doc":"Similar to `String#>`","summary":"<p>Similar to <code>String#></code></p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"StringLiteral | MacroId"}],"args_string":"(other : StringLiteral | MacroId) : BoolLiteral","source_link":null,"def":{"name":">","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"StringLiteral | MacroId"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"[](range:RangeLiteral):StringLiteral-instance-method","html_id":"[](range:RangeLiteral):StringLiteral-instance-method","name":"[]","doc":"Similar to `String#[]`.","summary":"<p>Similar to <code><a href=\"../../String.html#[](regex:Regex)-instance-method\">String#[]</a></code>.</p>","abstract":false,"args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"RangeLiteral"}],"args_string":"(range : RangeLiteral) : StringLiteral","source_link":null,"def":{"name":"[]","args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"RangeLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral","visibility":"Public","body":""}},{"id":"camelcase:StringLiteral-instance-method","html_id":"camelcase:StringLiteral-instance-method","name":"camelcase","doc":"Similar to `String#camelcase`.","summary":"<p>Similar to <code><a href=\"../../String.html#camelcase(options:Unicode::CaseOptions=Unicode::CaseOptions::None,*,lower:Bool=false)-instance-method\">String#camelcase</a></code>.</p>","abstract":false,"args":[],"args_string":" : StringLiteral","source_link":null,"def":{"name":"camelcase","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral","visibility":"Public","body":""}},{"id":"capitalize:StringLiteral-instance-method","html_id":"capitalize:StringLiteral-instance-method","name":"capitalize","doc":"Similar to `String#capitalize`.","summary":"<p>Similar to <code><a href=\"../../String.html#capitalize(options=Unicode::CaseOptions::None)-instance-method\">String#capitalize</a></code>.</p>","abstract":false,"args":[],"args_string":" : StringLiteral","source_link":null,"def":{"name":"capitalize","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral","visibility":"Public","body":""}},{"id":"chars:Crystal::Macros::ArrayLiteral(CharLiteral)-instance-method","html_id":"chars:Crystal::Macros::ArrayLiteral(CharLiteral)-instance-method","name":"chars","doc":"Similar to `String#chars`.","summary":"<p>Similar to <code><a href=\"../../String.html#chars-instance-method\">String#chars</a></code>.</p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(CharLiteral)","source_link":null,"def":{"name":"chars","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(CharLiteral)","visibility":"Public","body":""}},{"id":"chomp:StringLiteral-instance-method","html_id":"chomp:StringLiteral-instance-method","name":"chomp","doc":"Similar to `String#chomp`.","summary":"<p>Similar to <code><a href=\"../../String.html#chomp-instance-method\">String#chomp</a></code>.</p>","abstract":false,"args":[],"args_string":" : StringLiteral","source_link":null,"def":{"name":"chomp","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral","visibility":"Public","body":""}},{"id":"count(other:CharLiteral):NumberLiteral-instance-method","html_id":"count(other:CharLiteral):NumberLiteral-instance-method","name":"count","doc":"Similar to `String#count`.","summary":"<p>Similar to <code><a href=\"../../String.html#count(&block)-instance-method\">String#count</a></code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"CharLiteral"}],"args_string":"(other : CharLiteral) : NumberLiteral","source_link":null,"def":{"name":"count","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"CharLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral","visibility":"Public","body":""}},{"id":"downcase:StringLiteral-instance-method","html_id":"downcase:StringLiteral-instance-method","name":"downcase","doc":"Similar to `String#downcase`.","summary":"<p>Similar to <code><a href=\"../../String.html#downcase(options=Unicode::CaseOptions::None)-instance-method\">String#downcase</a></code>.</p>","abstract":false,"args":[],"args_string":" : StringLiteral","source_link":null,"def":{"name":"downcase","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral","visibility":"Public","body":""}},{"id":"empty?:BoolLiteral-instance-method","html_id":"empty?:BoolLiteral-instance-method","name":"empty?","doc":"Similar to `String#empty?`.","summary":"<p>Similar to <code><a href=\"../../String.html#empty?-instance-method\">String#empty?</a></code>.</p>","abstract":false,"args":[],"args_string":" : BoolLiteral","source_link":null,"def":{"name":"empty?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"ends_with?(other:StringLiteral|CharLiteral):BoolLiteral-instance-method","html_id":"ends_with?(other:StringLiteral|CharLiteral):BoolLiteral-instance-method","name":"ends_with?","doc":"Similar to `String#ends_with?`.","summary":"<p>Similar to <code><a href=\"../../String.html#ends_with?(re:Regex)-instance-method\">String#ends_with?</a></code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"StringLiteral | CharLiteral"}],"args_string":"(other : StringLiteral | CharLiteral) : BoolLiteral","source_link":null,"def":{"name":"ends_with?","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"StringLiteral | CharLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"gsub(regex:RegexLiteral,replacement:StringLiteral):StringLiteral-instance-method","html_id":"gsub(regex:RegexLiteral,replacement:StringLiteral):StringLiteral-instance-method","name":"gsub","doc":"Similar to `String#gsub`.","summary":"<p>Similar to <code><a href=\"../../String.html#gsub(&block:Char-%3EUNDERSCORE)-instance-method\">String#gsub</a></code>.</p>","abstract":false,"args":[{"name":"regex","doc":null,"default_value":"","external_name":"regex","restriction":"RegexLiteral"},{"name":"replacement","doc":null,"default_value":"","external_name":"replacement","restriction":"StringLiteral"}],"args_string":"(regex : RegexLiteral, replacement : StringLiteral) : StringLiteral","source_link":null,"def":{"name":"gsub","args":[{"name":"regex","doc":null,"default_value":"","external_name":"regex","restriction":"RegexLiteral"},{"name":"replacement","doc":null,"default_value":"","external_name":"replacement","restriction":"StringLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral","visibility":"Public","body":""}},{"id":"id:MacroId-instance-method","html_id":"id:MacroId-instance-method","name":"id","doc":"Returns a `MacroId` for this string's contents.","summary":"<p>Returns a <code><a href=\"../../Crystal/Macros/MacroId.html\">MacroId</a></code> for this string's contents.</p>","abstract":false,"args":[],"args_string":" : MacroId","source_link":null,"def":{"name":"id","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"MacroId","visibility":"Public","body":""}},{"id":"includes?(search:StringLiteral|CharLiteral):BoolLiteral-instance-method","html_id":"includes?(search:StringLiteral|CharLiteral):BoolLiteral-instance-method","name":"includes?","doc":"Similar to `String#includes?`.","summary":"<p>Similar to <code><a href=\"../../String.html#includes?(search:Char%7CString)-instance-method\">String#includes?</a></code>.</p>","abstract":false,"args":[{"name":"search","doc":null,"default_value":"","external_name":"search","restriction":"StringLiteral | CharLiteral"}],"args_string":"(search : StringLiteral | CharLiteral) : BoolLiteral","source_link":null,"def":{"name":"includes?","args":[{"name":"search","doc":null,"default_value":"","external_name":"search","restriction":"StringLiteral | CharLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"lines:Crystal::Macros::ArrayLiteral(StringLiteral)-instance-method","html_id":"lines:Crystal::Macros::ArrayLiteral(StringLiteral)-instance-method","name":"lines","doc":"Similar to `String#lines`.","summary":"<p>Similar to <code><a href=\"../../String.html#lines(chomp=true)-instance-method\">String#lines</a></code>.</p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(StringLiteral)","source_link":null,"def":{"name":"lines","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(StringLiteral)","visibility":"Public","body":""}},{"id":"size:NumberLiteral-instance-method","html_id":"size:NumberLiteral-instance-method","name":"size","doc":"Similar to `String#size`.","summary":"<p>Similar to <code><a href=\"../../String.html#size-instance-method\">String#size</a></code>.</p>","abstract":false,"args":[],"args_string":" : NumberLiteral","source_link":null,"def":{"name":"size","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NumberLiteral","visibility":"Public","body":""}},{"id":"split(node:ASTNode):Crystal::Macros::ArrayLiteral(StringLiteral)-instance-method","html_id":"split(node:ASTNode):Crystal::Macros::ArrayLiteral(StringLiteral)-instance-method","name":"split","doc":"Similar to `String#split`.","summary":"<p>Similar to <code><a href=\"../../String.html#split(separator:Char,limit=nil,*,remove_empty=false)-instance-method\">String#split</a></code>.</p>","abstract":false,"args":[{"name":"node","doc":null,"default_value":"","external_name":"node","restriction":"ASTNode"}],"args_string":"(node : ASTNode) : Crystal::Macros::ArrayLiteral(StringLiteral)","source_link":null,"def":{"name":"split","args":[{"name":"node","doc":null,"default_value":"","external_name":"node","restriction":"ASTNode"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(StringLiteral)","visibility":"Public","body":""}},{"id":"split:Crystal::Macros::ArrayLiteral(StringLiteral)-instance-method","html_id":"split:Crystal::Macros::ArrayLiteral(StringLiteral)-instance-method","name":"split","doc":"Similar to `String#split`.","summary":"<p>Similar to <code><a href=\"../../String.html#split(separator:Char,limit=nil,*,remove_empty=false)-instance-method\">String#split</a></code>.</p>","abstract":false,"args":[],"args_string":" : Crystal::Macros::ArrayLiteral(StringLiteral)","source_link":null,"def":{"name":"split","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"ArrayLiteral(StringLiteral)","visibility":"Public","body":""}},{"id":"starts_with?(other:StringLiteral|CharLiteral):BoolLiteral-instance-method","html_id":"starts_with?(other:StringLiteral|CharLiteral):BoolLiteral-instance-method","name":"starts_with?","doc":"Similar to `String#starts_with?`.","summary":"<p>Similar to <code><a href=\"../../String.html#starts_with?(re:Regex)-instance-method\">String#starts_with?</a></code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"StringLiteral | CharLiteral"}],"args_string":"(other : StringLiteral | CharLiteral) : BoolLiteral","source_link":null,"def":{"name":"starts_with?","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"StringLiteral | CharLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BoolLiteral","visibility":"Public","body":""}},{"id":"strip:StringLiteral-instance-method","html_id":"strip:StringLiteral-instance-method","name":"strip","doc":"Similar to `String#strip`.","summary":"<p>Similar to <code><a href=\"../../String.html#strip-instance-method\">String#strip</a></code>.</p>","abstract":false,"args":[],"args_string":" : StringLiteral","source_link":null,"def":{"name":"strip","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral","visibility":"Public","body":""}},{"id":"to_i(base=10)-instance-method","html_id":"to_i(base=10)-instance-method","name":"to_i","doc":"Similar to `String#to_i`.","summary":"<p>Similar to <code><a href=\"../../String.html#to_i(base:Int=10,whitespace:Bool=true,underscore:Bool=false,prefix:Bool=false,strict:Bool=true,leading_zero_is_octal:Bool=false)-instance-method\">String#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":""}],"args_string":"(base = <span class=\"n\">10</span>)","source_link":null,"def":{"name":"to_i","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":""}},{"id":"tr(from:StringLiteral,to:StringLiteral):StringLiteral-instance-method","html_id":"tr(from:StringLiteral,to:StringLiteral):StringLiteral-instance-method","name":"tr","doc":"Similar to `String#tr`.","summary":"<p>Similar to <code><a href=\"../../String.html#tr(from:String,to:String)-instance-method\">String#tr</a></code>.</p>","abstract":false,"args":[{"name":"from","doc":null,"default_value":"","external_name":"from","restriction":"StringLiteral"},{"name":"to","doc":null,"default_value":"","external_name":"to","restriction":"StringLiteral"}],"args_string":"(from : StringLiteral, to : StringLiteral) : StringLiteral","source_link":null,"def":{"name":"tr","args":[{"name":"from","doc":null,"default_value":"","external_name":"from","restriction":"StringLiteral"},{"name":"to","doc":null,"default_value":"","external_name":"to","restriction":"StringLiteral"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral","visibility":"Public","body":""}},{"id":"underscore:StringLiteral-instance-method","html_id":"underscore:StringLiteral-instance-method","name":"underscore","doc":"Similar to `String#underscore`.","summary":"<p>Similar to <code><a href=\"../../String.html#underscore(options:Unicode::CaseOptions=Unicode::CaseOptions::None)-instance-method\">String#underscore</a></code>.</p>","abstract":false,"args":[],"args_string":" : StringLiteral","source_link":null,"def":{"name":"underscore","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral","visibility":"Public","body":""}},{"id":"upcase:StringLiteral-instance-method","html_id":"upcase:StringLiteral-instance-method","name":"upcase","doc":"Similar to `String#upcase`.","summary":"<p>Similar to <code><a href=\"../../String.html#upcase(options=Unicode::CaseOptions::None)-instance-method\">String#upcase</a></code>.</p>","abstract":false,"args":[],"args_string":" : StringLiteral","source_link":null,"def":{"name":"upcase","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"StringLiteral","visibility":"Public","body":""}}],"macros":[],"types":[]},{"html_id":"/Crystal/Macros/SymbolLiteral","path":"Crystal/Macros/SymbolLiteral.html","kind":"class","full_name":"Crystal::Macros::SymbolLiteral","name":"SymbolLiteral","abstract":false,"superclass":{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},"ancestors":[{"html_id":"/Crystal/Macros/ASTNode","kind":"class","full_name":"Crystal::Macros::ASTNode","name":"ASTNode"},{"html_id":"/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"","program":false,"enum":false,"alias":false,"aliased":"","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"/Crystal/Macros","kind":"module","full_name":"Crystal::Macros","name":"Macros"},"doc":"A symbol literal.","summary":"<p>A symbol literal.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"+(other:StringLiteral|CharLiteral):SymbolLiteral-instance-method","html_id":"+(other:StringLiteral|CharLiteral):SymbolLiteral-instance-method","name":"+","doc":"Similar to `String#+`.","summary":"<p>Similar to <code><a href=\"../../String.html#+(other:self)-instance-method\">String#+</a></code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default