/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.testframework;

import com.android.repository.Revision;
import com.android.repository.api.Channel;
import com.android.repository.api.Dependency;
import com.android.repository.api.License;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.RepositorySource;
import com.android.repository.impl.meta.Archive;
import com.android.repository.impl.meta.CommonFactory;
import com.android.repository.impl.meta.GenericFactory;
import com.android.repository.impl.meta.TypeDetails;
import com.google.common.base.Objects;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;

public class FakePackage
implements LocalPackage,
RemotePackage {
    private final String mPath;
    private final Revision mVersion;
    private final Collection<Dependency> mDependencies;
    private TypeDetails mDetails;
    private Channel mChannel;
    private Archive mArchive;

    public FakePackage(String path, Revision version, Collection<Dependency> dependencies) {
        this.mPath = path;
        this.mVersion = version;
        this.mDependencies = dependencies == null ? ImmutableList.of() : dependencies;
    }

    @Override
    public RepositorySource getSource() {
        return null;
    }

    @Override
    public void setSource(RepositorySource source) {
    }

    @Override
    public Archive getArchive() {
        return this.mArchive;
    }

    public void setCompleteUrl(String url) {
        this.mArchive = new FakeArchive(url);
    }

    public void setChannel(Channel channel) {
        this.mChannel = channel;
    }

    @Override
    public Channel getChannel() {
        return this.mChannel == null ? Channel.DEFAULT : this.mChannel;
    }

    public void setTypeDetails(TypeDetails details) {
        this.mDetails = details;
    }

    @Override
    public TypeDetails getTypeDetails() {
        return this.mDetails == null ? (TypeDetails)((Object)((GenericFactory)RepoManager.getGenericModule().createLatestFactory()).createGenericDetailsType()) : this.mDetails;
    }

    @Override
    public Revision getVersion() {
        return this.mVersion;
    }

    @Override
    public String getDisplayName() {
        return "fake package";
    }

    @Override
    public License getLicense() {
        return null;
    }

    @Override
    public Collection<Dependency> getAllDependencies() {
        return this.mDependencies;
    }

    @Override
    public String getPath() {
        return this.mPath;
    }

    @Override
    public boolean obsolete() {
        return false;
    }

    @Override
    public CommonFactory createFactory() {
        return null;
    }

    @Override
    public int compareTo(RepoPackage o) {
        return ComparisonChain.start().compare((Comparable)((Object)this.getPath()), (Comparable)((Object)o.getPath())).compare((Comparable)this.getVersion(), (Comparable)o.getVersion()).result();
    }

    public boolean equals(Object obj) {
        return obj instanceof RepoPackage && ((RepoPackage)obj).getPath().equals(this.getPath()) && ((RepoPackage)obj).getVersion().equals(this.getVersion());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getPath(), this.getVersion()});
    }

    @Override
    public File getLocation() {
        return null;
    }

    @Override
    public void setInstalledPath(File root) {
    }

    public String toString() {
        return this.mPath;
    }

    private static class FakeArchive
    extends Archive {
        private String mCompleteUrl;

        public FakeArchive(String url) {
            this.mCompleteUrl = url;
        }

        @Override
        public Archive.CompleteType getComplete() {
            return new Archive.CompleteType(){

                @Override
                public String getChecksum() {
                    return null;
                }

                @Override
                public String getUrl() {
                    return FakeArchive.this.mCompleteUrl;
                }

                @Override
                public long getSize() {
                    return 0L;
                }
            };
        }

        @Override
        public CommonFactory createFactory() {
            return null;
        }
    }
}

