(function() {
  var DefaultDirectoryProvider, Directory, fs, path, url;

  Directory = require('pathwatcher').Directory;

  fs = require('fs-plus');

  path = require('path');

  url = require('url');

  module.exports = DefaultDirectoryProvider = (function() {
    function DefaultDirectoryProvider() {}

    DefaultDirectoryProvider.prototype.directoryForURISync = function(uri) {
      var directory, directoryPath, host, normalizedPath;
      normalizedPath = this.normalizePath(uri);
      host = url.parse(uri).host;
      directoryPath = host ? uri : !fs.isDirectorySync(normalizedPath) && fs.isDirectorySync(path.dirname(normalizedPath)) ? path.dirname(normalizedPath) : normalizedPath;
      directory = new Directory(directoryPath);
      if (host) {
        directory.path = directoryPath;
        if (fs.isCaseInsensitive()) {
          directory.lowerCasePath = directoryPath.toLowerCase();
        }
      }
      return directory;
    };

    DefaultDirectoryProvider.prototype.directoryForURI = function(uri) {
      return Promise.resolve(this.directoryForURISync(uri));
    };

    DefaultDirectoryProvider.prototype.normalizePath = function(uri) {
      var matchData, pathWithNormalizedDiskDriveLetter;
      pathWithNormalizedDiskDriveLetter = process.platform === 'win32' && (matchData = uri.match(/^([a-z]):/)) ? "" + (matchData[1].toUpperCase()) + (uri.slice(1)) : uri;
      return path.normalize(pathWithNormalizedDiskDriveLetter);
    };

    return DefaultDirectoryProvider;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
