Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var SystemPanel = (function () {
  function SystemPanel() {
    var _this = this;

    _classCallCheck(this, SystemPanel);

    _etch2['default'].initialize(this);
    this.subscriptions = new _atom.CompositeDisposable();
    this.subscriptions.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    _atom.WinShell.fileHandler.isRegistered(function (i) {
      _this.refs.fileHandlerCheckbox.checked = i;
    });
    _atom.WinShell.fileContextMenu.isRegistered(function (i) {
      _this.refs.fileContextMenuCheckbox.checked = i;
    });
    _atom.WinShell.folderContextMenu.isRegistered(function (i) {
      _this.refs.folderContextMenuCheckbox.checked = i;
    });
  }

  _createClass(SystemPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.subscriptions.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      return _etch2['default'].dom(
        'div',
        { className: 'panels-item', tabIndex: '0' },
        _etch2['default'].dom(
          'form',
          { className: 'general-panel section' },
          _etch2['default'].dom(
            'div',
            { className: 'settings-panel' },
            _etch2['default'].dom(
              'div',
              { className: 'section-container' },
              _etch2['default'].dom(
                'div',
                { className: 'block section-heading icon icon-device-desktop' },
                'System Settings'
              ),
              _etch2['default'].dom(
                'div',
                { className: 'text icon icon-question' },
                'These settings determine how Atom integrates with your operating system.'
              ),
              _etch2['default'].dom(
                'div',
                { className: 'section-body' },
                _etch2['default'].dom(
                  'div',
                  { className: 'control-group' },
                  _etch2['default'].dom(
                    'div',
                    { className: 'controls' },
                    _etch2['default'].dom(
                      'div',
                      { className: 'checkbox' },
                      _etch2['default'].dom(
                        'label',
                        { 'for': 'system.windows.file-handler' },
                        _etch2['default'].dom('input', {
                          ref: 'fileHandlerCheckbox',
                          id: 'system.windows.file-handler',
                          className: 'input-checkbox',
                          type: 'checkbox',
                          onclick: function (e) {
                            _this2.setRegistration(_atom.WinShell.fileHandler, e.target.checked);
                          } }),
                        _etch2['default'].dom(
                          'div',
                          { className: 'setting-title' },
                          'Register as file handler'
                        ),
                        _etch2['default'].dom(
                          'div',
                          { className: 'setting-description' },
                          'Show ',
                          _atom.WinShell.appName,
                          ' in the "Open with" application list for easy association with file types.'
                        )
                      )
                    )
                  )
                ),
                _etch2['default'].dom(
                  'div',
                  { className: 'control-group' },
                  _etch2['default'].dom(
                    'div',
                    { className: 'controls' },
                    _etch2['default'].dom(
                      'div',
                      { className: 'checkbox' },
                      _etch2['default'].dom(
                        'label',
                        { 'for': 'system.windows.shell-menu-files' },
                        _etch2['default'].dom('input', {
                          ref: 'fileContextMenuCheckbox',
                          id: 'system.windows.shell-menu-files',
                          className: 'input-checkbox',
                          type: 'checkbox',
                          onclick: function (e) {
                            _this2.setRegistration(_atom.WinShell.fileContextMenu, e.target.checked);
                          } }),
                        _etch2['default'].dom(
                          'div',
                          { className: 'setting-title' },
                          'Show in file context menus'
                        ),
                        _etch2['default'].dom(
                          'div',
                          { className: 'setting-description' },
                          'Add "Open with ',
                          _atom.WinShell.appName,
                          '" to the File Explorer context menu for files.'
                        )
                      )
                    )
                  )
                ),
                _etch2['default'].dom(
                  'div',
                  { className: 'control-group' },
                  _etch2['default'].dom(
                    'div',
                    { className: 'controls' },
                    _etch2['default'].dom(
                      'div',
                      { className: 'checkbox' },
                      _etch2['default'].dom(
                        'label',
                        { 'for': 'system.windows.shell-menu-folders' },
                        _etch2['default'].dom('input', {
                          ref: 'folderContextMenuCheckbox',
                          id: 'system.windows.shell-menu-folders',
                          className: 'input-checkbox',
                          type: 'checkbox',
                          onclick: function (e) {
                            _this2.setRegistration(_atom.WinShell.folderContextMenu, e.target.checked);
                            _this2.setRegistration(_atom.WinShell.folderBackgroundContextMenu, e.target.checked);
                          } }),
                        _etch2['default'].dom(
                          'div',
                          { className: 'setting-title' },
                          'Show in folder context menus'
                        ),
                        _etch2['default'].dom(
                          'div',
                          { className: 'setting-description' },
                          'Add "Open with ',
                          _atom.WinShell.appName,
                          '" to the File Explorer context menu for folders.'
                        )
                      )
                    )
                  )
                )
              )
            )
          )
        )
      );
    }
  }, {
    key: 'setRegistration',
    value: function setRegistration(option, shouldBeRegistered) {
      if (shouldBeRegistered) {
        return option.register(function () {});
      } else {
        return option.deregister(function () {});
      }
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return SystemPanel;
})();

exports['default'] = SystemPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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