"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.collectionRenderer = collectionRenderer;
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

var _helpers = require("../helpers");

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _commitsView = _interopRequireDefault(require("./timeline-items/commits-view.js"));

var _issueCommentView = _interopRequireDefault(require("./timeline-items/issue-comment-view.js"));

var _mergedEventView = _interopRequireDefault(require("./timeline-items/merged-event-view.js"));

var _headRefForcePushedEventView = _interopRequireDefault(require("./timeline-items/head-ref-force-pushed-event-view.js"));

var _crossReferencedEventsView = _interopRequireDefault(require("./timeline-items/cross-referenced-events-view.js"));

var _commitCommentThreadView = _interopRequireDefault(require("./timeline-items/commit-comment-thread-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function collectionRenderer(Component, styleAsTimelineItem = true) {
  var _class, _temp;

  return _temp = _class = class GroupedComponent extends _react["default"].Component {
    static getFragment(fragName, ...args) {
      const frag = fragName === 'nodes' ? 'item' : fragName;
      return Component.getFragment(frag, ...args);
    }

    constructor(props) {
      super(props);
      (0, _helpers.autobind)(this, 'renderNode');
    }

    render() {
      return _react["default"].createElement("div", {
        className: styleAsTimelineItem ? 'timeline-item' : ''
      }, this.props.nodes.map(this.renderNode));
    }

    renderNode(node, i) {
      return _react["default"].createElement(Component, {
        key: i,
        item: node,
        issueish: this.props.issueish,
        switchToIssueish: this.props.switchToIssueish
      });
    }

  }, _defineProperty(_class, "displayName", `Grouped(${Component.render ? Component.render.displayName : Component.displayName})`), _defineProperty(_class, "propTypes", {
    nodes: _propTypes["default"].array.isRequired,
    issueish: _propTypes["default"].object.isRequired,
    switchToIssueish: _propTypes["default"].func.isRequired
  }), _temp;
}

const timelineItems = {
  PullRequestCommit: _commitsView["default"],
  PullRequestCommitCommentThread: collectionRenderer(_commitCommentThreadView["default"], false),
  IssueComment: collectionRenderer(_issueCommentView["default"], false),
  MergedEvent: collectionRenderer(_mergedEventView["default"]),
  HeadRefForcePushedEvent: collectionRenderer(_headRefForcePushedEventView["default"]),
  CrossReferencedEvent: _crossReferencedEventsView["default"]
};
const TimelineConnectionPropType = (0, _propTypes2.RelayConnectionPropType)(_propTypes["default"].shape({
  __typename: _propTypes["default"].string.isRequired
})).isRequired;

class IssueishTimelineView extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'loadMore');
  }

  loadMore() {
    this.props.relay.loadMore(10, () => {
      this.forceUpdate();
    });
    this.forceUpdate();
  }

  render() {
    const issueish = this.props.issue || this.props.pullRequest;
    const groupedEdges = this.groupEdges(issueish.timelineItems.edges);
    return _react["default"].createElement("div", {
      className: "github-PrTimeline"
    }, groupedEdges.map(({
      type,
      edges
    }) => {
      const Component = timelineItems[type];
      const propsForCommits = {
        onBranch: this.props.onBranch,
        openCommit: this.props.openCommit
      };

      if (Component) {
        return _react["default"].createElement(Component, _extends({
          key: `${type}-${edges[0].cursor}`,
          nodes: edges.map(e => e.node),
          issueish: issueish,
          switchToIssueish: this.props.switchToIssueish
        }, Component === _commitsView["default"] && propsForCommits));
      } else {
        // eslint-disable-next-line no-console
        console.warn(`unrecognized timeline event type: ${type}`);
        return null;
      }
    }), this.renderLoadMore());
  }

  renderLoadMore() {
    if (!this.props.relay.hasMore()) {
      return null;
    }

    return _react["default"].createElement("div", {
      className: "github-PrTimeline-loadMore"
    }, _react["default"].createElement("button", {
      className: "github-PrTimeline-loadMoreButton btn",
      onClick: this.loadMore
    }, this.props.relay.isLoading() ? _react["default"].createElement(_octicon["default"], {
      icon: "ellipsis"
    }) : 'Load More'));
  }

  groupEdges(edges) {
    let currentGroup;
    const groupedEdges = [];
    let lastEdgeType;
    edges.forEach(({
      node,
      cursor
    }) => {
      const currentEdgeType = node.__typename;

      if (currentEdgeType === lastEdgeType) {
        currentGroup.edges.push({
          node,
          cursor
        });
      } else {
        currentGroup = {
          type: currentEdgeType,
          edges: [{
            node,
            cursor
          }]
        };
        groupedEdges.push(currentGroup);
      }

      lastEdgeType = currentEdgeType;
    });
    return groupedEdges;
  }

}

exports["default"] = IssueishTimelineView;

_defineProperty(IssueishTimelineView, "propTypes", {
  switchToIssueish: _propTypes["default"].func.isRequired,
  relay: _propTypes["default"].shape({
    hasMore: _propTypes["default"].func.isRequired,
    loadMore: _propTypes["default"].func.isRequired,
    isLoading: _propTypes["default"].func.isRequired
  }).isRequired,
  issue: _propTypes["default"].shape({
    timelineItems: TimelineConnectionPropType
  }),
  pullRequest: _propTypes["default"].shape({
    timelineItems: TimelineConnectionPropType
  }),
  onBranch: _propTypes["default"].bool,
  openCommit: _propTypes["default"].func
});

_defineProperty(IssueishTimelineView, "defaultProps", {
  onBranch: false,
  openCommit: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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