"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

var _accordion = _interopRequireDefault(require("./accordion"));

var _timeago = _interopRequireDefault(require("./timeago"));

var _statusDonutChart = _interopRequireDefault(require("./status-donut-chart"));

var _checkSuitesAccumulator = _interopRequireDefault(require("../containers/accumulators/check-suites-accumulator"));

var _queryErrorTile = _interopRequireDefault(require("./query-error-tile"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class IssueishListView extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "renderReviewsButton", () => {
      if (!this.props.needReviewsButton || this.props.issueishes.length < 1) {
        return null;
      }

      return _react["default"].createElement("button", {
        className: "btn btn-primary btn-sm github-IssueishList-openReviewsButton",
        onClick: this.openReviews
      }, "See reviews");
    });

    _defineProperty(this, "openReviews", e => {
      e.stopPropagation();
      this.props.openReviews(this.props.issueishes[0]);
    });

    _defineProperty(this, "renderIssueish", issueish => {
      return _react["default"].createElement(_checkSuitesAccumulator["default"], {
        commit: issueish.getLatestCommit()
      }, ({
        runsBySuite
      }) => {
        issueish.setCheckRuns(runsBySuite);
        return _react["default"].createElement(_react.Fragment, null, _react["default"].createElement("img", {
          className: "github-IssueishList-item github-IssueishList-item--avatar",
          src: issueish.getAuthorAvatarURL(32),
          title: issueish.getAuthorLogin(),
          alt: issueish.getAuthorLogin()
        }), _react["default"].createElement("span", {
          className: "github-IssueishList-item github-IssueishList-item--title"
        }, issueish.getTitle()), _react["default"].createElement("span", {
          className: "github-IssueishList-item github-IssueishList-item--number"
        }, "#", issueish.getNumber()), this.renderStatusSummary(issueish.getStatusCounts()), _react["default"].createElement(_timeago["default"], {
          time: issueish.getCreatedAt(),
          displayStyle: "short",
          className: "github-IssueishList-item github-IssueishList-item--age"
        }), _react["default"].createElement(_octicon["default"], {
          icon: "ellipses",
          className: "github-IssueishList-item github-IssueishList-item--menu",
          onClick: event => this.showActionsMenu(event, issueish)
        }));
      });
    });

    _defineProperty(this, "renderLoadingTile", () => {
      return _react["default"].createElement("div", {
        className: "github-IssueishList-loading"
      }, "Loading");
    });

    _defineProperty(this, "renderEmptyTile", () => {
      if (this.props.error) {
        return _react["default"].createElement(_queryErrorTile["default"], {
          error: this.props.error
        });
      }

      if (this.props.emptyComponent) {
        const EmptyComponent = this.props.emptyComponent;
        return _react["default"].createElement(EmptyComponent, null);
      }

      return null;
    });

    _defineProperty(this, "renderMoreTile", () => {
      /* eslint-disable jsx-a11y/anchor-is-valid */
      if (this.props.onMoreClick) {
        return _react["default"].createElement("div", {
          className: "github-IssueishList-more"
        }, _react["default"].createElement("a", {
          onClick: this.props.onMoreClick
        }, "More..."));
      }

      return null;
    });
  }

  render() {
    return _react["default"].createElement(_accordion["default"], {
      leftTitle: this.props.title,
      isLoading: this.props.isLoading,
      results: this.props.issueishes,
      total: this.props.total,
      loadingComponent: this.renderLoadingTile,
      emptyComponent: this.renderEmptyTile,
      moreComponent: this.renderMoreTile,
      reviewsButton: this.renderReviewsButton,
      onClickItem: this.props.onIssueishClick
    }, this.renderIssueish);
  }

  showActionsMenu(event, issueish) {
    event.preventDefault();
    event.stopPropagation();
    this.props.showActionsMenu(issueish);
  }

  renderStatusSummary(statusCounts) {
    if (['success', 'failure', 'pending'].every(kind => statusCounts[kind] === 0)) {
      return _react["default"].createElement(_octicon["default"], {
        className: "github-IssueishList-item github-IssueishList-item--status",
        icon: "dash"
      });
    }

    if (statusCounts.success > 0 && statusCounts.failure === 0 && statusCounts.pending === 0) {
      return _react["default"].createElement(_octicon["default"], {
        className: "github-IssueishList-item github-IssueishList-item--status",
        icon: "check"
      });
    }

    if (statusCounts.success === 0 && statusCounts.failure > 0 && statusCounts.pending === 0) {
      return _react["default"].createElement(_octicon["default"], {
        className: "github-IssueishList-item github-IssueishList-item--status",
        icon: "x"
      });
    }

    return _react["default"].createElement(_statusDonutChart["default"], _extends({}, statusCounts, {
      className: "github-IssueishList-item github-IssueishList-item--status"
    }));
  }

}

exports["default"] = IssueishListView;

_defineProperty(IssueishListView, "propTypes", {
  title: _propTypes["default"].string.isRequired,
  isLoading: _propTypes["default"].bool.isRequired,
  total: _propTypes["default"].number.isRequired,
  issueishes: _propTypes["default"].arrayOf(_propTypes2.IssueishPropType).isRequired,
  repository: _propTypes["default"].shape({
    defaultBranchRef: _propTypes["default"].shape({
      prefix: _propTypes["default"].string.isRequired,
      name: _propTypes["default"].string.isRequired
    })
  }),
  needReviewsButton: _propTypes["default"].bool,
  onIssueishClick: _propTypes["default"].func.isRequired,
  onMoreClick: _propTypes["default"].func,
  openReviews: _propTypes["default"].func.isRequired,
  openOnGitHub: _propTypes["default"].func.isRequired,
  showActionsMenu: _propTypes["default"].func.isRequired,
  emptyComponent: _propTypes["default"].func,
  error: _propTypes["default"].object
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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