"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareIssueDetailView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _issueTimelineController = _interopRequireDefault(require("../controllers/issue-timeline-controller"));

var _emojiReactionsController = _interopRequireDefault(require("../controllers/emoji-reactions-controller"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _issueishBadge = _interopRequireDefault(require("../views/issueish-badge"));

var _githubDotcomMarkdown = _interopRequireDefault(require("../views/github-dotcom-markdown"));

var _periodicRefresher = _interopRequireDefault(require("../periodic-refresher"));

var _reporterProxy = require("../reporter-proxy");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareIssueDetailView extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {
      refreshing: false
    });

    _defineProperty(this, "handleRefreshClick", e => {
      e.preventDefault();
      this.refresher.refreshNow(true);
    });

    _defineProperty(this, "recordOpenInBrowserEvent", () => {
      (0, _reporterProxy.addEvent)('open-issue-in-browser', {
        "package": 'github',
        component: this.constructor.name
      });
    });

    _defineProperty(this, "refresh", () => {
      if (this.state.refreshing) {
        return;
      }

      this.setState({
        refreshing: true
      });
      this.props.relay.refetch({
        repoId: this.props.repository.id,
        issueishId: this.props.issue.id,
        timelineCount: 100,
        timelineCursor: null
      }, null, err => {
        if (err) {
          this.props.reportRelayError('Unable to refresh issue details', err);
        }

        this.setState({
          refreshing: false
        });
      }, {
        force: true
      });
    });
  }

  componentDidMount() {
    this.refresher = new _periodicRefresher["default"](BareIssueDetailView, {
      interval: () => 5 * 60 * 1000,
      getCurrentId: () => this.props.issue.id,
      refresh: this.refresh,
      minimumIntervalPerId: 2 * 60 * 1000
    }); // auto-refresh disabled for now until pagination is handled
    // this.refresher.start();
  }

  componentWillUnmount() {
    this.refresher.destroy();
  }

  renderIssueBody(issue) {
    return _react["default"].createElement("div", {
      className: "github-IssueishDetailView-issueBody"
    }, _react["default"].createElement(_githubDotcomMarkdown["default"], {
      html: issue.bodyHTML || '<em>No description provided.</em>',
      switchToIssueish: this.props.switchToIssueish
    }), _react["default"].createElement(_emojiReactionsController["default"], {
      reactable: issue,
      tooltips: this.props.tooltips,
      reportRelayError: this.props.reportRelayError
    }), _react["default"].createElement(_issueTimelineController["default"], {
      issue: issue,
      switchToIssueish: this.props.switchToIssueish
    }));
  }

  render() {
    const repo = this.props.repository;
    const issue = this.props.issue;
    const author = issue.author || _helpers.GHOST_USER;
    return _react["default"].createElement("div", {
      className: "github-IssueishDetailView native-key-bindings"
    }, _react["default"].createElement("div", {
      className: "github-IssueishDetailView-container"
    }, _react["default"].createElement("header", {
      className: "github-IssueishDetailView-header"
    }, _react["default"].createElement("div", {
      className: "github-IssueishDetailView-headerColumn"
    }, _react["default"].createElement("a", {
      className: "github-IssueishDetailView-avatar",
      href: author.url
    }, _react["default"].createElement("img", {
      className: "github-IssueishDetailView-avatarImage",
      src: author.avatarUrl,
      title: author.login,
      alt: author.login
    }))), _react["default"].createElement("div", {
      className: "github-IssueishDetailView-headerColumn is-flexible"
    }, _react["default"].createElement("div", {
      className: "github-IssueishDetailView-headerRow is-fullwidth"
    }, _react["default"].createElement("a", {
      className: "github-IssueishDetailView-title",
      href: issue.url
    }, issue.title)), _react["default"].createElement("div", {
      className: "github-IssueishDetailView-headerRow"
    }, _react["default"].createElement(_issueishBadge["default"], {
      className: "github-IssueishDetailView-headerBadge",
      type: issue.__typename,
      state: issue.state
    }), _react["default"].createElement(_octicon["default"], {
      icon: "repo-sync",
      className: (0, _classnames["default"])('github-IssueishDetailView-headerRefreshButton', {
        refreshing: this.state.refreshing
      }),
      onClick: this.handleRefreshClick
    }), _react["default"].createElement("a", {
      className: "github-IssueishDetailView-headerLink",
      title: "open on GitHub.com",
      href: issue.url,
      onClick: this.recordOpenInBrowserEvent
    }, repo.owner.login, "/", repo.name, "#", issue.number)))), this.renderIssueBody(issue), _react["default"].createElement("footer", {
      className: "github-IssueishDetailView-footer"
    }, _react["default"].createElement("a", {
      className: "github-IssueishDetailView-footerLink icon icon-mark-github",
      href: issue.url
    }, repo.owner.login, "/", repo.name, "#", issue.number))));
  }

}

exports.BareIssueDetailView = BareIssueDetailView;

_defineProperty(BareIssueDetailView, "propTypes", {
  // Relay response
  relay: _propTypes["default"].shape({
    refetch: _propTypes["default"].func.isRequired
  }),
  switchToIssueish: _propTypes["default"].func.isRequired,
  repository: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired,
    name: _propTypes["default"].string.isRequired,
    owner: _propTypes["default"].shape({
      login: _propTypes["default"].string
    })
  }),
  issue: _propTypes["default"].shape({
    __typename: _propTypes["default"].string.isRequired,
    id: _propTypes["default"].string.isRequired,
    title: _propTypes["default"].string,
    url: _propTypes["default"].string.isRequired,
    bodyHTML: _propTypes["default"].string,
    number: _propTypes["default"].number,
    state: _propTypes["default"].oneOf(['OPEN', 'CLOSED']).isRequired,
    author: _propTypes["default"].shape({
      login: _propTypes["default"].string.isRequired,
      avatarUrl: _propTypes["default"].string.isRequired,
      url: _propTypes["default"].string.isRequired
    }).isRequired,
    reactionGroups: _propTypes["default"].arrayOf(_propTypes["default"].shape({
      content: _propTypes["default"].string.isRequired,
      users: _propTypes["default"].shape({
        totalCount: _propTypes["default"].number.isRequired
      }).isRequired
    })).isRequired
  }).isRequired,
  // Atom environment
  tooltips: _propTypes["default"].object.isRequired,
  // Action methods
  reportRelayError: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createRefetchContainer)(BareIssueDetailView, {
  repository: function () {
    const node = require("./__generated__/issueDetailView_repository.graphql");

    if (node.hash && node.hash !== "295a60f53b25b6fdb07a1539cda447f2") {
      console.error("The definition of 'issueDetailView_repository' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/issueDetailView_repository.graphql");
  },
  issue: function () {
    const node = require("./__generated__/issueDetailView_issue.graphql");

    if (node.hash && node.hash !== "f7adc2e75c1d55df78481fd359bf7180") {
      console.error("The definition of 'issueDetailView_issue' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/issueDetailView_issue.graphql");
  }
}, function () {
  const node = require("./__generated__/issueDetailViewRefetchQuery.graphql");

  if (node.hash && node.hash !== "82666b2748036545eb131b3e34f48e72") {
    console.error("The definition of 'issueDetailViewRefetchQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/issueDetailViewRefetchQuery.graphql");
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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