"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _commitDetailItem = _interopRequireDefault(require("../items/commit-detail-item"));

var _issueishDetailItem = _interopRequireDefault(require("../items/issueish-detail-item"));

var _propTypes2 = require("../prop-types");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class FilePatchMetaView extends _react["default"].Component {
  renderMetaControls() {
    if (this.props.itemType === _commitDetailItem["default"] || this.props.itemType === _issueishDetailItem["default"]) {
      return null;
    }

    return _react["default"].createElement("div", {
      className: "github-FilePatchView-metaControls"
    }, _react["default"].createElement("button", {
      className: (0, _classnames["default"])('github-FilePatchView-metaButton', 'icon', this.props.actionIcon),
      onClick: this.props.action
    }, this.props.actionText));
  }

  render() {
    return _react["default"].createElement("div", {
      className: "github-FilePatchView-meta"
    }, _react["default"].createElement("div", {
      className: "github-FilePatchView-metaContainer"
    }, _react["default"].createElement("header", {
      className: "github-FilePatchView-metaHeader"
    }, _react["default"].createElement("h3", {
      className: "github-FilePatchView-metaTitle"
    }, this.props.title), this.renderMetaControls()), _react["default"].createElement("div", {
      className: "github-FilePatchView-metaDetails"
    }, this.props.children)));
  }

}

exports["default"] = FilePatchMetaView;

_defineProperty(FilePatchMetaView, "propTypes", {
  title: _propTypes["default"].string.isRequired,
  actionIcon: _propTypes["default"].string.isRequired,
  actionText: _propTypes["default"].string.isRequired,
  action: _propTypes["default"].func.isRequired,
  children: _propTypes["default"].element.isRequired,
  itemType: _propTypes2.ItemTypePropType.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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