"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _classnames = _interopRequireDefault(require("classnames"));

var _reactSelect = _interopRequireDefault(require("react-select"));

var _tooltip = _interopRequireDefault(require("../atom/tooltip"));

var _atomTextEditor = _interopRequireDefault(require("../atom/atom-text-editor"));

var _coAuthorForm = _interopRequireDefault(require("./co-author-form"));

var _recentCommitsView = _interopRequireDefault(require("./recent-commits-view"));

var _stagingView = _interopRequireDefault(require("./staging-view"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _author = _interopRequireDefault(require("../models/author"));

var _observeModel = _interopRequireDefault(require("./observe-model"));

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _reporterProxy = require("../reporter-proxy");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const TOOLTIP_DELAY = 200; // CustomEvent is a DOM primitive, which v8 can't access
// so we're essentially lazy loading to keep snapshotting from breaking.

let FakeKeyDownEvent;

class CommitView extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'submitNewCoAuthor', 'cancelNewCoAuthor', 'didMoveCursor', 'toggleHardWrap', 'toggleCoAuthorInput', 'abortMerge', 'commit', 'amendLastCommit', 'toggleExpandedCommitMessageEditor', 'renderCoAuthorListItem', 'onSelectedCoAuthorsChanged', 'excludeCoAuthor');
    this.state = {
      showWorking: false,
      showCoAuthorInput: false,
      showCoAuthorForm: false,
      coAuthorInput: ''
    };
    this.timeoutHandle = null;
    this.subscriptions = new _eventKit.CompositeDisposable();
    this.refRoot = new _refHolder["default"]();
    this.refCommitPreviewButton = new _refHolder["default"]();
    this.refExpandButton = new _refHolder["default"]();
    this.refCommitButton = new _refHolder["default"]();
    this.refHardWrapButton = new _refHolder["default"]();
    this.refAbortMergeButton = new _refHolder["default"]();
    this.refCoAuthorToggle = new _refHolder["default"]();
    this.refCoAuthorSelect = new _refHolder["default"]();
    this.refCoAuthorForm = new _refHolder["default"]();
    this.refEditorComponent = new _refHolder["default"]();
    this.refEditorModel = new _refHolder["default"]();
    this.subs = new _eventKit.CompositeDisposable();
  }

  proxyKeyCode(keyCode) {
    return e => {
      if (this.refCoAuthorSelect.isEmpty()) {
        return;
      }

      if (!FakeKeyDownEvent) {
        FakeKeyDownEvent = class extends CustomEvent {
          constructor(kCode) {
            super('keydown');
            this.keyCode = kCode;
          }

        };
      }

      const fakeEvent = new FakeKeyDownEvent(keyCode);
      this.refCoAuthorSelect.get().handleKeyDown(fakeEvent);

      if (!fakeEvent.defaultPrevented) {
        e.abortKeyBinding();
      }
    };
  } // eslint-disable-next-line camelcase


  UNSAFE_componentWillMount() {
    this.scheduleShowWorking(this.props);
    this.subs.add(this.props.config.onDidChange('github.automaticCommitMessageWrapping', () => this.forceUpdate()), this.props.messageBuffer.onDidChange(() => this.forceUpdate()));
  }

  render() {
    let remainingCharsClassName = '';
    const remainingCharacters = parseInt(this.getRemainingCharacters(), 10);

    if (remainingCharacters < 0) {
      remainingCharsClassName = 'is-error';
    } else if (remainingCharacters < this.props.maximumCharacterLimit / 4) {
      remainingCharsClassName = 'is-warning';
    }

    const showAbortMergeButton = this.props.isMerging || null;
    /* istanbul ignore next */

    const modKey = process.platform === 'darwin' ? 'Cmd' : 'Ctrl';
    return _react["default"].createElement("div", {
      className: "github-CommitView",
      ref: this.refRoot.setter
    }, _react["default"].createElement(_commands["default"], {
      registry: this.props.commandRegistry,
      target: "atom-workspace"
    }, _react["default"].createElement(_commands.Command, {
      command: "github:commit",
      callback: this.commit
    }), _react["default"].createElement(_commands.Command, {
      command: "github:amend-last-commit",
      callback: this.amendLastCommit
    }), _react["default"].createElement(_commands.Command, {
      command: "github:toggle-expanded-commit-message-editor",
      callback: this.toggleExpandedCommitMessageEditor
    })), _react["default"].createElement(_commands["default"], {
      registry: this.props.commandRegistry,
      target: ".github-CommitView-coAuthorEditor"
    }, _react["default"].createElement(_commands.Command, {
      command: "github:co-author:down",
      callback: this.proxyKeyCode(40)
    }), _react["default"].createElement(_commands.Command, {
      command: "github:co-author:up",
      callback: this.proxyKeyCode(38)
    }), _react["default"].createElement(_commands.Command, {
      command: "github:co-author:enter",
      callback: this.proxyKeyCode(13)
    }), _react["default"].createElement(_commands.Command, {
      command: "github:co-author:tab",
      callback: this.proxyKeyCode(9)
    }), _react["default"].createElement(_commands.Command, {
      command: "github:co-author:backspace",
      callback: this.proxyKeyCode(8)
    }), _react["default"].createElement(_commands.Command, {
      command: "github:co-author:pageup",
      callback: this.proxyKeyCode(33)
    }), _react["default"].createElement(_commands.Command, {
      command: "github:co-author:pagedown",
      callback: this.proxyKeyCode(34)
    }), _react["default"].createElement(_commands.Command, {
      command: "github:co-author:end",
      callback: this.proxyKeyCode(35)
    }), _react["default"].createElement(_commands.Command, {
      command: "github:co-author:home",
      callback: this.proxyKeyCode(36)
    }), _react["default"].createElement(_commands.Command, {
      command: "github:co-author:delete",
      callback: this.proxyKeyCode(46)
    }), _react["default"].createElement(_commands.Command, {
      command: "github:co-author:escape",
      callback: this.proxyKeyCode(27)
    }), _react["default"].createElement(_commands.Command, {
      command: "github:co-author-exclude",
      callback: this.excludeCoAuthor
    })), _react["default"].createElement(_commands["default"], {
      registry: this.props.commandRegistry,
      target: ".github-CommitView-commitPreview"
    }, _react["default"].createElement(_commands.Command, {
      command: "github:dive",
      callback: this.props.activateCommitPreview
    })), _react["default"].createElement("div", {
      className: "github-CommitView-buttonWrapper"
    }, _react["default"].createElement("button", {
      ref: this.refCommitPreviewButton.setter,
      className: "github-CommitView-commitPreview github-CommitView-button btn",
      disabled: !this.props.stagedChangesExist,
      onClick: this.props.toggleCommitPreview
    }, this.props.commitPreviewActive ? 'Hide All Staged Changes' : 'See All Staged Changes')), _react["default"].createElement("div", {
      className: (0, _classnames["default"])('github-CommitView-editor', {
        'is-expanded': this.props.deactivateCommitBox
      })
    }, _react["default"].createElement(_atomTextEditor["default"], {
      ref: this.refEditorComponent.setter,
      refModel: this.refEditorModel,
      softWrapped: true,
      placeholderText: "Commit message",
      lineNumberGutterVisible: false,
      showInvisibles: false,
      autoHeight: false,
      scrollPastEnd: false,
      buffer: this.props.messageBuffer,
      workspace: this.props.workspace,
      didChangeCursorPosition: this.didMoveCursor
    }), _react["default"].createElement("button", {
      ref: this.refCoAuthorToggle.setter,
      className: (0, _classnames["default"])('github-CommitView-coAuthorToggle', {
        focused: this.state.showCoAuthorInput
      }),
      onClick: this.toggleCoAuthorInput
    }, this.renderCoAuthorToggleIcon()), _react["default"].createElement(_tooltip["default"], {
      manager: this.props.tooltips,
      target: this.refCoAuthorToggle,
      title: `${this.state.showCoAuthorInput ? 'Remove' : 'Add'} co-authors`,
      showDelay: TOOLTIP_DELAY
    }), _react["default"].createElement("button", {
      ref: this.refHardWrapButton.setter,
      onClick: this.toggleHardWrap,
      className: "github-CommitView-hardwrap hard-wrap-icons"
    }, this.renderHardWrapIcon()), _react["default"].createElement(_tooltip["default"], {
      manager: this.props.tooltips,
      target: this.refHardWrapButton,
      className: "github-CommitView-hardwrap-tooltip",
      title: "Toggle hard wrap on commit",
      showDelay: TOOLTIP_DELAY
    }), _react["default"].createElement("button", {
      ref: this.refExpandButton.setter,
      className: "github-CommitView-expandButton icon icon-screen-full",
      onClick: this.toggleExpandedCommitMessageEditor
    }), _react["default"].createElement(_tooltip["default"], {
      manager: this.props.tooltips,
      target: this.refExpandButton,
      className: "github-CommitView-expandButton-tooltip",
      title: "Expand commit message editor",
      showDelay: TOOLTIP_DELAY
    })), this.renderCoAuthorForm(), this.renderCoAuthorInput(), _react["default"].createElement("footer", {
      className: "github-CommitView-bar"
    }, showAbortMergeButton && _react["default"].createElement("button", {
      ref: this.refAbortMergeButton.setter,
      className: "btn github-CommitView-button github-CommitView-abortMerge is-secondary",
      onClick: this.abortMerge
    }, "Abort Merge"), _react["default"].createElement("button", {
      ref: this.refCommitButton.setter,
      className: "github-CommitView-button github-CommitView-commit btn btn-primary native-key-bindings",
      onClick: this.commit,
      disabled: !this.commitIsEnabled(false)
    }, this.commitButtonText()), this.commitIsEnabled(false) && _react["default"].createElement(_tooltip["default"], {
      manager: this.props.tooltips,
      target: this.refCommitButton,
      className: "github-CommitView-button-tooltip",
      title: `${modKey}-enter to commit`,
      showDelay: TOOLTIP_DELAY
    }), _react["default"].createElement("div", {
      className: `github-CommitView-remaining-characters ${remainingCharsClassName}`
    }, this.getRemainingCharacters())));
  }

  renderCoAuthorToggleIcon() {
    /* eslint-disable max-len */
    const svgPath = 'M9.875 2.125H12v1.75H9.875V6h-1.75V3.875H6v-1.75h2.125V0h1.75v2.125zM6 6.5a.5.5 0 0 1-.5.5h-5a.5.5 0 0 1-.5-.5V6c0-1.316 2-2 2-2s.114-.204 0-.5c-.42-.31-.472-.795-.5-2C1.587.293 2.434 0 3 0s1.413.293 1.5 1.5c-.028 1.205-.08 1.69-.5 2-.114.295 0 .5 0 .5s2 .684 2 2v.5z';
    return _react["default"].createElement("svg", {
      className: (0, _classnames["default"])('github-CommitView-coAuthorToggleIcon', {
        focused: this.state.showCoAuthorInput
      }),
      viewBox: "0 0 12 7",
      xmlns: "http://www.w3.org/2000/svg"
    }, _react["default"].createElement("title", null, "Add or remove co-authors"), _react["default"].createElement("path", {
      d: svgPath
    }));
  }

  renderCoAuthorInput() {
    if (!this.state.showCoAuthorInput) {
      return null;
    }

    return _react["default"].createElement(_observeModel["default"], {
      model: this.props.userStore,
      fetchData: store => store.getUsers()
    }, mentionableUsers => _react["default"].createElement(_reactSelect["default"], {
      ref: this.refCoAuthorSelect.setter,
      className: "github-CommitView-coAuthorEditor input-textarea native-key-bindings",
      placeholder: "Co-Authors",
      arrowRenderer: null,
      options: mentionableUsers,
      labelKey: "fullName",
      valueKey: "email",
      filterOptions: this.matchAuthors,
      optionRenderer: this.renderCoAuthorListItem,
      valueRenderer: this.renderCoAuthorValue,
      onChange: this.onSelectedCoAuthorsChanged,
      value: this.props.selectedCoAuthors,
      multi: true,
      openOnClick: false,
      openOnFocus: false,
      tabIndex: "5"
    }));
  }

  renderHardWrapIcon() {
    const singleLineMessage = this.props.messageBuffer.getText().split(_helpers.LINE_ENDING_REGEX).length === 1;
    const hardWrap = this.props.config.get('github.automaticCommitMessageWrapping');
    const notApplicable = this.props.deactivateCommitBox || singleLineMessage;
    /* eslint-disable max-len */

    const svgPaths = {
      hardWrapEnabled: {
        path1: 'M7.058 10.2h-.975v2.4L2 9l4.083-3.6v2.4h.97l1.202 1.203L7.058 10.2zm2.525-4.865V4.2h2.334v1.14l-1.164 1.165-1.17-1.17z',
        // eslint-disable-line max-len
        path2: 'M7.842 6.94l2.063 2.063-2.122 2.12.908.91 2.123-2.123 1.98 1.98.85-.848L11.58 8.98l2.12-2.123-.824-.825-2.122 2.12-2.062-2.06z' // eslint-disable-line max-len

      },
      hardWrapDisabled: {
        path1: 'M11.917 8.4c0 .99-.788 1.8-1.75 1.8H6.083v2.4L2 9l4.083-3.6v2.4h3.5V4.2h2.334v4.2z'
      }
    };
    /* eslint-enable max-line */

    if (notApplicable) {
      return null;
    }

    if (hardWrap) {
      return _react["default"].createElement("div", {
        className: (0, _classnames["default"])('icon', 'hardwrap', 'icon-hardwrap-enabled', {
          hidden: notApplicable || !hardWrap
        })
      }, _react["default"].createElement("svg", {
        width: "16",
        height: "16",
        viewBox: "0 0 16 16",
        xmlns: "http://www.w3.org/2000/svg"
      }, _react["default"].createElement("path", {
        d: svgPaths.hardWrapDisabled.path1,
        fillRule: "evenodd"
      })));
    } else {
      return _react["default"].createElement("div", {
        className: (0, _classnames["default"])('icon', 'no-hardwrap', 'icon-hardwrap-disabled', {
          hidden: notApplicable || hardWrap
        })
      }, _react["default"].createElement("svg", {
        width: "16",
        height: "16",
        viewBox: "0 0 16 16",
        xmlns: "http://www.w3.org/2000/svg"
      }, _react["default"].createElement("g", {
        fillRule: "evenodd"
      }, _react["default"].createElement("path", {
        d: svgPaths.hardWrapEnabled.path1
      }), _react["default"].createElement("path", {
        fillRule: "nonzero",
        d: svgPaths.hardWrapEnabled.path2
      }))));
    }
  }

  renderCoAuthorForm() {
    if (!this.state.showCoAuthorForm) {
      return null;
    }

    return _react["default"].createElement(_coAuthorForm["default"], {
      ref: this.refCoAuthorForm.setter,
      commandRegistry: this.props.commandRegistry,
      onSubmit: this.submitNewCoAuthor,
      onCancel: this.cancelNewCoAuthor,
      name: this.state.coAuthorInput
    });
  }

  submitNewCoAuthor(newAuthor) {
    this.props.updateSelectedCoAuthors(this.props.selectedCoAuthors, newAuthor);
    this.hideNewAuthorForm();
  }

  cancelNewCoAuthor() {
    this.hideNewAuthorForm();
  }

  hideNewAuthorForm() {
    this.setState({
      showCoAuthorForm: false
    }, () => {
      this.refCoAuthorSelect.map(c => c.focus());
    });
  } // eslint-disable-next-line camelcase


  UNSAFE_componentWillReceiveProps(nextProps) {
    this.scheduleShowWorking(nextProps);
  }

  componentWillUnmount() {
    this.subs.dispose();
  }

  didMoveCursor() {
    this.forceUpdate();
  }

  toggleHardWrap() {
    const currentSetting = this.props.config.get('github.automaticCommitMessageWrapping');
    this.props.config.set('github.automaticCommitMessageWrapping', !currentSetting);
  }

  toggleCoAuthorInput() {
    this.setState({
      showCoAuthorInput: !this.state.showCoAuthorInput
    }, () => {
      if (this.state.showCoAuthorInput) {
        (0, _reporterProxy.incrementCounter)('show-co-author-input');
        this.refCoAuthorSelect.map(c => c.focus());
      } else {
        // if input is closed, remove all co-authors
        this.props.updateSelectedCoAuthors([]);
        (0, _reporterProxy.incrementCounter)('hide-co-author-input');
      }
    });
  }

  excludeCoAuthor() {
    const author = this.refCoAuthorSelect.map(c => c.getFocusedOption()).getOr(null);

    if (!author || author.isNew()) {
      return;
    }

    let excluded = this.props.config.get('github.excludedUsers');

    if (excluded && excluded !== '') {
      excluded += ', ';
    }

    excluded += author.getEmail();
    this.props.config.set('github.excludedUsers', excluded);
  }

  abortMerge() {
    this.props.abortMerge();
  }

  async commit(event, amend) {
    if ((await this.props.prepareToCommit()) && this.commitIsEnabled(amend)) {
      try {
        await this.props.commit(this.props.messageBuffer.getText(), this.props.selectedCoAuthors, amend);
      } catch (e) {
        // do nothing - error was taken care of in pipeline manager
        if (!atom.isReleasedVersion()) {
          throw e;
        }
      }
    } else {
      this.setFocus(CommitView.focus.EDITOR);
    }
  }

  amendLastCommit() {
    (0, _reporterProxy.incrementCounter)('amend');
    this.commit(null, true);
  }

  getRemainingCharacters() {
    return this.refEditorModel.map(editor => {
      if (editor.getCursorBufferPosition().row === 0) {
        return (this.props.maximumCharacterLimit - editor.lineTextForBufferRow(0).length).toString();
      } else {
        return '∞';
      }
    }).getOr(this.props.maximumCharacterLimit || '');
  } // We don't want the user to see the UI flicker in the case
  // the commit takes a very small time to complete. Instead we
  // will only show the working message if we are working for longer
  // than 1 second as per https://www.nngroup.com/articles/response-times-3-important-limits/
  //
  // The closure is created to restrict variable access


  scheduleShowWorking(props) {
    if (props.isCommitting) {
      if (!this.state.showWorking && this.timeoutHandle === null) {
        this.timeoutHandle = setTimeout(() => {
          this.timeoutHandle = null;
          this.setState({
            showWorking: true
          });
        }, 1000);
      }
    } else {
      clearTimeout(this.timeoutHandle);
      this.timeoutHandle = null;
      this.setState({
        showWorking: false
      });
    }
  }

  isValidMessage() {
    // ensure that there are at least some non-comment lines in the commit message.
    // Commented lines are stripped out of commit messages by git, by default configuration.
    return this.props.messageBuffer.getText().replace(/^#.*$/gm, '').trim().length !== 0;
  }

  commitIsEnabled(amend) {
    return !this.props.isCommitting && (amend || this.props.stagedChangesExist) && !this.props.mergeConflictsExist && this.props.lastCommit.isPresent() && (this.props.deactivateCommitBox || amend || this.isValidMessage());
  }

  commitButtonText() {
    if (this.state.showWorking) {
      return 'Working...';
    } else if (this.props.currentBranch.isDetached()) {
      return 'Create detached commit';
    } else if (this.props.currentBranch.isPresent()) {
      return `Commit to ${this.props.currentBranch.getName()}`;
    } else {
      return 'Commit';
    }
  }

  toggleExpandedCommitMessageEditor() {
    return this.props.toggleExpandedCommitMessageEditor(this.props.messageBuffer.getText());
  }

  matchAuthors(authors, filterText, selectedAuthors) {
    const matchedAuthors = authors.filter((author, index) => {
      const isAlreadySelected = selectedAuthors && selectedAuthors.find(selected => selected.matches(author));
      const matchesFilter = [author.getLogin(), author.getFullName(), author.getEmail()].some(field => field && field.toLowerCase().indexOf(filterText.toLowerCase()) !== -1);
      return !isAlreadySelected && matchesFilter;
    });
    matchedAuthors.push(_author["default"].createNew('Add new author', filterText));
    return matchedAuthors;
  }

  renderCoAuthorListItemField(fieldName, value) {
    if (!value || value.length === 0) {
      return null;
    }

    return _react["default"].createElement("span", {
      className: `github-CommitView-coAuthorEditor-${fieldName}`
    }, value);
  }

  renderCoAuthorListItem(author) {
    return _react["default"].createElement("div", {
      className: (0, _classnames["default"])('github-CommitView-coAuthorEditor-selectListItem', {
        'new-author': author.isNew()
      })
    }, this.renderCoAuthorListItemField('name', author.getFullName()), author.hasLogin() && this.renderCoAuthorListItemField('login', '@' + author.getLogin()), this.renderCoAuthorListItemField('email', author.getEmail()));
  }

  renderCoAuthorValue(author) {
    const fullName = author.getFullName();

    if (fullName && fullName.length > 0) {
      return _react["default"].createElement("span", null, author.getFullName());
    }

    if (author.hasLogin()) {
      return _react["default"].createElement("span", null, "@", author.getLogin());
    }

    return _react["default"].createElement("span", null, author.getEmail());
  }

  onSelectedCoAuthorsChanged(selectedCoAuthors) {
    (0, _reporterProxy.incrementCounter)('selected-co-authors-changed');
    const newAuthor = selectedCoAuthors.find(author => author.isNew());

    if (newAuthor) {
      this.setState({
        coAuthorInput: newAuthor.getFullName(),
        showCoAuthorForm: true
      });
    } else {
      this.props.updateSelectedCoAuthors(selectedCoAuthors);
    }
  }

  hasFocus() {
    return this.refRoot.map(element => element.contains(document.activeElement)).getOr(false);
  }

  getFocus(element) {
    if (this.refCommitPreviewButton.map(button => button.contains(element)).getOr(false)) {
      return CommitView.focus.COMMIT_PREVIEW_BUTTON;
    }

    if (this.refEditorComponent.map(editor => editor.contains(element)).getOr(false)) {
      return CommitView.focus.EDITOR;
    }

    if (this.refAbortMergeButton.map(e => e.contains(element)).getOr(false)) {
      return CommitView.focus.ABORT_MERGE_BUTTON;
    }

    if (this.refCommitButton.map(e => e.contains(element)).getOr(false)) {
      return CommitView.focus.COMMIT_BUTTON;
    }

    if (this.refCoAuthorSelect.map(c => c.wrapper && c.wrapper.contains(element)).getOr(false)) {
      return CommitView.focus.COAUTHOR_INPUT;
    }

    return null;
  }

  setFocus(focus) {
    let fallback = false;

    const focusElement = element => {
      element.focus();
      return true;
    };

    if (focus === CommitView.focus.COMMIT_PREVIEW_BUTTON) {
      if (this.refCommitPreviewButton.map(focusElement).getOr(false)) {
        return true;
      }
    }

    if (focus === CommitView.focus.EDITOR) {
      if (this.refEditorComponent.map(focusElement).getOr(false)) {
        if (this.props.messageBuffer.getText().length > 0 && !this.isValidMessage()) {
          // there is likely a commit message template present
          // we want the cursor to be at the beginning, not at the and of the template
          this.refEditorComponent.get().getModel().setCursorBufferPosition([0, 0]);
        }

        return true;
      }
    }

    if (focus === CommitView.focus.ABORT_MERGE_BUTTON) {
      if (this.refAbortMergeButton.map(focusElement).getOr(false)) {
        return true;
      }

      fallback = true;
    }

    if (focus === CommitView.focus.COMMIT_BUTTON) {
      if (this.refCommitButton.map(focusElement).getOr(false)) {
        return true;
      }

      fallback = true;
    }

    if (focus === CommitView.focus.COAUTHOR_INPUT) {
      if (this.refCoAuthorSelect.map(focusElement).getOr(false)) {
        return true;
      }

      fallback = true;
    }

    if (focus === CommitView.lastFocus) {
      if (this.commitIsEnabled(false)) {
        return this.setFocus(CommitView.focus.COMMIT_BUTTON);
      } else if (this.props.isMerging) {
        return this.setFocus(CommitView.focus.ABORT_MERGE_BUTTON);
      } else if (this.state.showCoAuthorInput) {
        return this.setFocus(CommitView.focus.COAUTHOR_INPUT);
      } else {
        return this.setFocus(CommitView.focus.EDITOR);
      }
    }

    if (fallback && this.refEditorComponent.map(focusElement).getOr(false)) {
      return true;
    }

    return false;
  }

  advanceFocusFrom(focus) {
    const f = this.constructor.focus;
    let next = null;

    switch (focus) {
      case f.COMMIT_PREVIEW_BUTTON:
        next = f.EDITOR;
        break;

      case f.EDITOR:
        if (this.state.showCoAuthorInput) {
          next = f.COAUTHOR_INPUT;
        } else if (this.props.isMerging) {
          next = f.ABORT_MERGE_BUTTON;
        } else if (this.commitIsEnabled(false)) {
          next = f.COMMIT_BUTTON;
        } else {
          next = _recentCommitsView["default"].firstFocus;
        }

        break;

      case f.COAUTHOR_INPUT:
        if (this.props.isMerging) {
          next = f.ABORT_MERGE_BUTTON;
        } else if (this.commitIsEnabled(false)) {
          next = f.COMMIT_BUTTON;
        } else {
          next = _recentCommitsView["default"].firstFocus;
        }

        break;

      case f.ABORT_MERGE_BUTTON:
        next = this.commitIsEnabled(false) ? f.COMMIT_BUTTON : _recentCommitsView["default"].firstFocus;
        break;

      case f.COMMIT_BUTTON:
        next = _recentCommitsView["default"].firstFocus;
        break;
    }

    return Promise.resolve(next);
  }

  retreatFocusFrom(focus) {
    const f = this.constructor.focus;
    let previous = null;

    switch (focus) {
      case f.COMMIT_BUTTON:
        if (this.props.isMerging) {
          previous = f.ABORT_MERGE_BUTTON;
        } else if (this.state.showCoAuthorInput) {
          previous = f.COAUTHOR_INPUT;
        } else {
          previous = f.EDITOR;
        }

        break;

      case f.ABORT_MERGE_BUTTON:
        previous = this.state.showCoAuthorInput ? f.COAUTHOR_INPUT : f.EDITOR;
        break;

      case f.COAUTHOR_INPUT:
        previous = f.EDITOR;
        break;

      case f.EDITOR:
        previous = f.COMMIT_PREVIEW_BUTTON;
        break;

      case f.COMMIT_PREVIEW_BUTTON:
        previous = _stagingView["default"].lastFocus;
        break;
    }

    return Promise.resolve(previous);
  }

}

exports["default"] = CommitView;

_defineProperty(CommitView, "focus", {
  COMMIT_PREVIEW_BUTTON: Symbol('commit-preview-button'),
  EDITOR: Symbol('commit-editor'),
  COAUTHOR_INPUT: Symbol('coauthor-input'),
  ABORT_MERGE_BUTTON: Symbol('commit-abort-merge-button'),
  COMMIT_BUTTON: Symbol('commit-button')
});

_defineProperty(CommitView, "firstFocus", CommitView.focus.COMMIT_PREVIEW_BUTTON);

_defineProperty(CommitView, "lastFocus", Symbol('last-focus'));

_defineProperty(CommitView, "propTypes", {
  workspace: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  commandRegistry: _propTypes["default"].object.isRequired,
  lastCommit: _propTypes["default"].object.isRequired,
  currentBranch: _propTypes["default"].object.isRequired,
  isMerging: _propTypes["default"].bool.isRequired,
  mergeConflictsExist: _propTypes["default"].bool.isRequired,
  stagedChangesExist: _propTypes["default"].bool.isRequired,
  isCommitting: _propTypes["default"].bool.isRequired,
  commitPreviewActive: _propTypes["default"].bool.isRequired,
  deactivateCommitBox: _propTypes["default"].bool.isRequired,
  maximumCharacterLimit: _propTypes["default"].number.isRequired,
  messageBuffer: _propTypes["default"].object.isRequired,
  // FIXME more specific proptype
  userStore: _propTypes2.UserStorePropType.isRequired,
  selectedCoAuthors: _propTypes["default"].arrayOf(_propTypes2.AuthorPropType),
  updateSelectedCoAuthors: _propTypes["default"].func,
  commit: _propTypes["default"].func.isRequired,
  abortMerge: _propTypes["default"].func.isRequired,
  prepareToCommit: _propTypes["default"].func.isRequired,
  toggleExpandedCommitMessageEditor: _propTypes["default"].func.isRequired,
  toggleCommitPreview: _propTypes["default"].func.isRequired,
  activateCommitPreview: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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