"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _reporterProxy = require("../reporter-proxy");

var _repository = _interopRequireDefault(require("../models/repository"));

var _endpoint = require("../models/endpoint");

var _issueishDetailContainer = _interopRequireDefault(require("../containers/issueish-detail-container"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class IssueishDetailItem extends _react.Component {
  static buildURI({
    host,
    owner,
    repo,
    number,
    workdir
  }) {
    const encodeOptionalParam = param => param ? encodeURIComponent(param) : '';

    return 'atom-github://issueish/' + encodeURIComponent(host) + '/' + encodeURIComponent(owner) + '/' + encodeURIComponent(repo) + '/' + encodeURIComponent(number) + '?workdir=' + encodeOptionalParam(workdir);
  }

  constructor(props) {
    super(props);

    _defineProperty(this, "destroy", () => {
      /* istanbul ignore else */
      if (!this.isDestroyed) {
        this.emitter.emit('did-destroy');
        this.isDestroyed = true;
      }
    });

    _defineProperty(this, "onTabSelected", index => new Promise(resolve => {
      this.setState({
        selectedTab: index,
        initChangedFilePath: '',
        initChangedFilePosition: 0
      }, resolve);
    }));

    _defineProperty(this, "onOpenFilesTab", callback => this.emitter.on('on-open-files-tab', callback));

    (0, _helpers.autobind)(this, 'switchToIssueish', 'handleTitleChanged');
    this.emitter = new _eventKit.Emitter();
    this.title = `${this.props.owner}/${this.props.repo}#${this.props.issueishNumber}`;
    this.hasTerminatedPendingState = false;
    const repository = this.props.workingDirectory === '' ? _repository["default"].absent() : this.props.workdirContextPool.add(this.props.workingDirectory).getRepository();
    this.state = {
      host: this.props.host,
      owner: this.props.owner,
      repo: this.props.repo,
      issueishNumber: this.props.issueishNumber,
      repository,
      initChangedFilePath: '',
      initChangedFilePosition: 0,
      selectedTab: this.props.initSelectedTab
    };

    if (repository.isAbsent()) {
      this.switchToIssueish(this.props.owner, this.props.repo, this.props.issueishNumber);
    }

    this.refEditor = new _refHolder["default"]();
    this.refEditor.observe(editor => {
      if (editor.isAlive()) {
        this.emitter.emit('did-change-embedded-text-editor', editor);
      }
    });
  }

  render() {
    return _react["default"].createElement(_issueishDetailContainer["default"], {
      endpoint: (0, _endpoint.getEndpoint)(this.state.host),
      owner: this.state.owner,
      repo: this.state.repo,
      issueishNumber: this.state.issueishNumber,
      initChangedFilePath: this.state.initChangedFilePath,
      initChangedFilePosition: this.state.initChangedFilePosition,
      selectedTab: this.state.selectedTab,
      onTabSelected: this.onTabSelected,
      onOpenFilesTab: this.onOpenFilesTab,
      repository: this.state.repository,
      workspace: this.props.workspace,
      loginModel: this.props.loginModel,
      onTitleChange: this.handleTitleChanged,
      switchToIssueish: this.switchToIssueish,
      commands: this.props.commands,
      keymaps: this.props.keymaps,
      tooltips: this.props.tooltips,
      config: this.props.config,
      destroy: this.destroy,
      itemType: this.constructor,
      refEditor: this.refEditor,
      reportRelayError: this.props.reportRelayError
    });
  }

  async switchToIssueish(owner, repo, issueishNumber) {
    const pool = this.props.workdirContextPool;
    const prev = {
      owner: this.state.owner,
      repo: this.state.repo,
      issueishNumber: this.state.issueishNumber
    };
    const nextRepository = (await this.state.repository.hasGitHubRemote(this.state.host, owner, repo)) ? this.state.repository : (await pool.getMatchingContext(this.state.host, owner, repo)).getRepository();
    await new Promise(resolve => {
      this.setState((prevState, props) => {
        if (pool === props.workdirContextPool && prevState.owner === prev.owner && prevState.repo === prev.repo && prevState.issueishNumber === prev.issueishNumber) {
          (0, _reporterProxy.addEvent)('open-issueish-in-pane', {
            "package": 'github',
            from: 'issueish-link',
            target: 'current-tab'
          });
          return {
            owner,
            repo,
            issueishNumber,
            repository: nextRepository
          };
        }

        return {};
      }, resolve);
    });
  }

  handleTitleChanged(title) {
    if (this.title !== title) {
      this.title = title;
      this.emitter.emit('did-change-title', title);
    }
  }

  onDidChangeTitle(cb) {
    return this.emitter.on('did-change-title', cb);
  }

  terminatePendingState() {
    if (!this.hasTerminatedPendingState) {
      this.emitter.emit('did-terminate-pending-state');
      this.hasTerminatedPendingState = true;
    }
  }

  onDidTerminatePendingState(callback) {
    return this.emitter.on('did-terminate-pending-state', callback);
  }

  onDidDestroy(callback) {
    return this.emitter.on('did-destroy', callback);
  }

  serialize() {
    return {
      uri: IssueishDetailItem.buildURI({
        host: this.props.host,
        owner: this.props.owner,
        repo: this.props.repo,
        number: this.props.issueishNumber,
        workdir: this.props.workingDirectory
      }),
      selectedTab: this.state.selectedTab,
      deserializer: 'IssueishDetailItem'
    };
  }

  getTitle() {
    return this.title;
  }

  observeEmbeddedTextEditor(cb) {
    this.refEditor.map(editor => editor.isAlive() && cb(editor));
    return this.emitter.on('did-change-embedded-text-editor', cb);
  }

  openFilesTab({
    changedFilePath,
    changedFilePosition
  }) {
    this.setState({
      selectedTab: IssueishDetailItem.tabs.FILES,
      initChangedFilePath: changedFilePath,
      initChangedFilePosition: changedFilePosition
    }, () => {
      this.emitter.emit('on-open-files-tab', {
        changedFilePath,
        changedFilePosition
      });
    });
  }

}

exports["default"] = IssueishDetailItem;

_defineProperty(IssueishDetailItem, "tabs", {
  OVERVIEW: 0,
  BUILD_STATUS: 1,
  COMMITS: 2,
  FILES: 3
});

_defineProperty(IssueishDetailItem, "propTypes", {
  // Issueish selection criteria
  // Parsed from item URI
  host: _propTypes["default"].string.isRequired,
  owner: _propTypes["default"].string.isRequired,
  repo: _propTypes["default"].string.isRequired,
  issueishNumber: _propTypes["default"].number.isRequired,
  workingDirectory: _propTypes["default"].string.isRequired,
  // Package models
  workdirContextPool: _propTypes2.WorkdirContextPoolPropType.isRequired,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  initSelectedTab: _propTypes["default"].oneOf(Object.keys(IssueishDetailItem.tabs).map(k => IssueishDetailItem.tabs[k])),
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  keymaps: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  // Action methods
  reportRelayError: _propTypes["default"].func.isRequired
});

_defineProperty(IssueishDetailItem, "defaultProps", {
  initSelectedTab: IssueishDetailItem.tabs.OVERVIEW
});

_defineProperty(IssueishDetailItem, "uriPattern", 'atom-github://issueish/{host}/{owner}/{repo}/{issueishNumber}?workdir={workingDirectory}');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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