"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.MarkerLayerContext = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _atomTextEditor = require("./atom-text-editor");

var _marker = require("./marker");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const markerLayerProps = {
  maintainHistory: _propTypes["default"].bool,
  persistent: _propTypes["default"].bool
};

const MarkerLayerContext = _react["default"].createContext();

exports.MarkerLayerContext = MarkerLayerContext;

class BareMarkerLayer extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'createLayer');
    this.subs = new _eventKit.CompositeDisposable();
    this.layerSub = new _eventKit.Disposable();
    this.layerHolder = new _refHolder["default"]();
    this.state = {
      editorHolder: _refHolder["default"].on(this.props.editor)
    };
    this.decorable = {
      holder: this.layerHolder,
      decorateMethod: 'decorateMarkerLayer'
    };
  }

  static getDerivedStateFromProps(props, state) {
    if (state.editorHolder.map(e => e === props.editor).getOr(props.editor === undefined)) {
      return null;
    }

    return {
      editorHolder: _refHolder["default"].on(props.editor)
    };
  }

  componentDidMount() {
    this.observeEditor();
  }

  render() {
    return _react["default"].createElement(MarkerLayerContext.Provider, {
      value: this.layerHolder
    }, _react["default"].createElement(_marker.DecorableContext.Provider, {
      value: this.decorable
    }, this.props.children));
  }

  componentDidUpdate(prevProps, prevState) {
    if (this.state.editorHolder !== prevState.editorHolder) {
      this.observeEditor();
    }
  }

  componentWillUnmount() {
    this.subs.dispose();
  }

  observeEditor() {
    this.subs.dispose();
    this.subs = new _eventKit.CompositeDisposable();
    this.subs.add(this.state.editorHolder.observe(this.createLayer));
  }

  createLayer() {
    this.subs.remove(this.layerSub);
    this.layerSub.dispose();
    this.state.editorHolder.map(editor => {
      const options = (0, _helpers.extractProps)(this.props, markerLayerProps);
      let layer;

      if (this.props.external !== undefined) {
        layer = editor.getMarkerLayer(this.props.external.id);

        if (!layer) {
          return null;
        }

        if (layer !== this.props.external && layer.bufferMarkerLayer !== this.props.external) {
          // Oops, same layer ID on a different TextEditor
          return null;
        }

        this.layerSub = new _eventKit.Disposable();
      } else {
        layer = editor.addMarkerLayer(options);
        this.layerSub = new _eventKit.Disposable(() => {
          layer.destroy();
          this.props.handleLayer(undefined);
          this.props.handleID(undefined);
        });
      }

      this.layerHolder.setter(layer);
      this.props.handleLayer(layer);
      this.props.handleID(layer.id);
      this.subs.add(this.layerSub);
      return null;
    });
  }

}

_defineProperty(BareMarkerLayer, "propTypes", _objectSpread({}, markerLayerProps, {
  editor: _propTypes["default"].object,
  external: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired
  }),
  children: _propTypes["default"].node,
  handleID: _propTypes["default"].func,
  handleLayer: _propTypes["default"].func
}));

_defineProperty(BareMarkerLayer, "defaultProps", {
  handleID: () => {},
  handleLayer: () => {}
});

class MarkerLayer extends _react["default"].Component {
  render() {
    return _react["default"].createElement(_atomTextEditor.TextEditorContext.Consumer, null, editor => _react["default"].createElement(BareMarkerLayer, _extends({
      editor: editor
    }, this.props)));
  }

}

exports["default"] = MarkerLayer;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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