function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

/** @babel */

var fs = require('fs');
var path = require('path');

module.exports = {
  enumerate: _asyncToGenerator(function* () {
    if (atom.inDevMode()) {
      return [];
    }

    var duplicatePackages = [];
    var names = atom.packages.getAvailablePackageNames();
    for (var _name of names) {
      if (atom.packages.isBundledPackage(_name)) {
        var isDuplicatedPackage = yield this.isInstalledAsCommunityPackage(_name);
        if (isDuplicatedPackage) {
          duplicatePackages.push(_name);
        }
      }
    }

    return duplicatePackages;
  }),

  isInstalledAsCommunityPackage: _asyncToGenerator(function* (name) {
    var availablePackagePaths = atom.packages.getPackageDirPaths();

    for (var packagePath of availablePackagePaths) {
      var candidate = path.join(packagePath, name);

      if (fs.existsSync(candidate)) {
        var realPath = yield this.realpath(candidate);
        if (realPath === candidate) {
          return true;
        }
      }
    }

    return false;
  }),

  realpath: function realpath(path) {
    return new Promise(function (resolve, reject) {
      fs.realpath(path, function (error, realpath) {
        if (error) {
          reject(error);
        } else {
          resolve(realpath);
        }
      });
    });
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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