"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var _this = this;
Object.defineProperty(exports, "__esModule", { value: true });
var electron_1 = require("electron");
var fileUrl = require("file-url");
var path = require("path");
var eventType_1 = require("../lib/eventType");
var locale = require("../locale/locale");
var config_1 = require("../settings/config");
var webappVersion;
var APP_PATH = path.join(electron_1.app.getAppPath(), config_1.config.electronDirectory);
var ABOUT_HTML = fileUrl(path.join(APP_PATH, 'html/about.html'));
var ABOUT_WINDOW_WHITELIST = [
    ABOUT_HTML,
    fileUrl(path.join(APP_PATH, 'img/logo.256.png')),
    fileUrl(path.join(APP_PATH, 'css/about.css')),
];
var PRELOAD_JS = path.join(APP_PATH, 'dist/renderer/menu/preload-about.js');
var WINDOW_SIZE = {
    HEIGHT: 256,
    WIDTH: 304,
};
electron_1.ipcMain.once(eventType_1.EVENT_TYPE.UI.WEBAPP_VERSION, function (event, version) { return (webappVersion = version); });
var showWindow = function () {
    var aboutWindow;
    if (!aboutWindow) {
        aboutWindow = new electron_1.BrowserWindow({
            alwaysOnTop: true,
            backgroundColor: '#ececec',
            fullscreen: false,
            height: WINDOW_SIZE.HEIGHT,
            maximizable: false,
            minimizable: false,
            resizable: false,
            show: false,
            title: config_1.config.name,
            webPreferences: {
                javascript: false,
                nodeIntegration: false,
                nodeIntegrationInWorker: false,
                preload: PRELOAD_JS,
                session: electron_1.session.fromPartition('about-window'),
                webviewTag: false,
            },
            width: WINDOW_SIZE.WIDTH,
        });
        aboutWindow.setMenuBarVisibility(false);
        aboutWindow.webContents.session.webRequest.onBeforeRequest({ urls: ['*'] }, function (_a, callback) {
            var url = _a.url;
            return __awaiter(_this, void 0, void 0, function () {
                return __generator(this, function (_b) {
                    if (ABOUT_WINDOW_WHITELIST.includes(url)) {
                        return [2, callback({ cancel: false })];
                    }
                    if (url.startsWith('https://')) {
                        electron_1.shell.openExternal(url);
                    }
                    else {
                        console.log('Attempt to open URL in window prevented, url:', url);
                    }
                    callback({ redirectURL: ABOUT_HTML });
                    return [2];
                });
            });
        });
        electron_1.ipcMain.on(eventType_1.EVENT_TYPE.ABOUT.LOCALE_VALUES, function (event, labels) {
            if (aboutWindow) {
                var isExpected = event.sender.id === aboutWindow.webContents.id;
                if (isExpected) {
                    var resultLabels_1 = {};
                    labels.forEach(function (label) { return (resultLabels_1[label] = locale.getText(label)); });
                    event.sender.send(eventType_1.EVENT_TYPE.ABOUT.LOCALE_RENDER, resultLabels_1);
                }
            }
        });
        aboutWindow.webContents.on('before-input-event', function (event, input) {
            if (input.type === 'keyDown' && input.key === 'Escape') {
                if (aboutWindow) {
                    aboutWindow.close();
                }
            }
        });
        aboutWindow.on('closed', function () { return (aboutWindow = undefined); });
        aboutWindow.loadURL(ABOUT_HTML);
        aboutWindow.webContents.on('dom-ready', function () {
            if (aboutWindow) {
                aboutWindow.webContents.send(eventType_1.EVENT_TYPE.ABOUT.LOADED, {
                    copyright: config_1.config.copyright,
                    electronVersion: config_1.config.version,
                    productName: config_1.config.name,
                    webappVersion: webappVersion,
                });
            }
        });
    }
    aboutWindow.show();
};
exports.AboutWindow = { showWindow: showWindow };
//# sourceMappingURL=AboutWindow.js.map