/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Paint;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.Arrays;
import java.util.Map;
import org.freehep.graphics2d.font.FontEncoder;
import org.freehep.graphics2d.font.FontUtilities;
import org.freehep.graphicsio.MultiPageDocument;
import org.freehep.graphicsio.VectorGraphicsIO;
import org.freehep.util.images.ImageUtilities;

public abstract class AbstractVectorGraphicsIO
extends VectorGraphicsIO {
    private static final String rootKey = AbstractVectorGraphicsIO.class.getName();
    public static final String EMIT_WARNINGS = rootKey + ".EMIT_WARNINGS";
    public static final String TEXT_AS_SHAPES = rootKey + "." + "TEXT_AS_SHAPES";
    public static final String EMIT_ERRORS = rootKey + ".EMIT_ERRORS";
    public static final String CLIP = rootKey + ".CLIP";
    private Dimension size;
    private Component component;
    private boolean doRestoreOnDispose;
    private Rectangle deviceClip;
    private Area userClip;
    private AffineTransform currentTransform;
    private AffineTransform oldTransform = new AffineTransform();
    private Composite currentComposite;
    private Stroke currentStroke;
    private RenderingHints hints;

    protected AbstractVectorGraphicsIO(Dimension size, boolean doRestoreOnDispose) {
        this.size = size;
        this.component = null;
        this.doRestoreOnDispose = doRestoreOnDispose;
        this.deviceClip = size != null ? new Rectangle(0, 0, size.width, size.height) : null;
        this.userClip = null;
        this.currentTransform = new AffineTransform();
        this.currentComposite = AlphaComposite.getInstance(3);
        this.currentStroke = new BasicStroke(1.0f, 2, 0, 10.0f, null, 0.0f);
        super.setColor(Color.BLACK);
        super.setBackground(Color.BLACK);
        super.setFont(new Font("Dialog", 0, 12));
        this.hints = new RenderingHints(null);
    }

    protected AbstractVectorGraphicsIO(Component component, boolean doRestoreOnDispose) {
        this.size = component.getSize();
        this.component = component;
        this.doRestoreOnDispose = doRestoreOnDispose;
        this.deviceClip = this.size != null ? new Rectangle(0, 0, this.size.width, this.size.height) : null;
        this.userClip = null;
        GraphicsConfiguration gc = component.getGraphicsConfiguration();
        this.currentTransform = gc != null ? gc.getDefaultTransform() : new AffineTransform();
        this.currentComposite = AlphaComposite.getInstance(3);
        this.currentStroke = new BasicStroke(1.0f, 2, 0, 10.0f, null, 0.0f);
        super.setFont(component.getFont());
        super.setBackground(component.getBackground());
        super.setColor(component.getForeground());
        this.hints = new RenderingHints(null);
    }

    protected AbstractVectorGraphicsIO(AbstractVectorGraphicsIO graphics, boolean doRestoreOnDispose) {
        super(graphics);
        this.doRestoreOnDispose = doRestoreOnDispose;
        this.size = new Dimension(graphics.size);
        this.component = graphics.component;
        this.deviceClip = new Rectangle(graphics.deviceClip);
        this.userClip = graphics.userClip != null ? new Area(graphics.userClip) : null;
        this.currentTransform = new AffineTransform(graphics.currentTransform);
        this.currentComposite = graphics.currentComposite;
        this.currentStroke = graphics.currentStroke;
        this.hints = graphics.hints;
    }

    public Dimension getSize() {
        return this.size;
    }

    public Component getComponent() {
        return this.component;
    }

    public void startExport() {
        try {
            this.writeHeader();
            if (!(this instanceof MultiPageDocument)) {
                this.writeGraphicsState();
                this.writeBackground();
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void endExport() {
        try {
            this.dispose();
            this.writeTrailer();
            this.closeStream();
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public abstract void writeHeader() throws IOException;

    public void writeGraphicsState() throws IOException {
        this.writePaint(this.getPrintColor(this.getColor()));
        this.writeSetTransform(this.getTransform());
        this.setClip(this.getClip());
    }

    public abstract void writeBackground() throws IOException;

    public abstract void writeTrailer() throws IOException;

    public abstract void closeStream() throws IOException;

    public void printComment(String comment) {
        try {
            this.writeComment(comment);
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public abstract void writeComment(String var1) throws IOException;

    protected void resetClip(Rectangle clip) {
        this.deviceClip = clip;
        this.userClip = null;
    }

    public void dispose() {
        try {
            if (this.doRestoreOnDispose) {
                this.writeGraphicsRestore();
                this.doRestoreOnDispose = false;
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    protected abstract void writeGraphicsSave() throws IOException;

    protected abstract void writeGraphicsRestore() throws IOException;

    public boolean drawImage(Image image, int x, int y, ImageObserver observer) {
        int imageWidth = image.getWidth(observer);
        int imageHeight = image.getHeight(observer);
        return this.drawImage(image, x, y, x + imageWidth, y + imageHeight, 0, 0, imageWidth, imageHeight, null, observer);
    }

    public boolean drawImage(Image image, int x, int y, int width, int height, ImageObserver observer) {
        int imageWidth = image.getWidth(observer);
        int imageHeight = image.getHeight(observer);
        return this.drawImage(image, x, y, x + width, y + height, 0, 0, imageWidth, imageHeight, null, observer);
    }

    public boolean drawImage(Image image, int x, int y, int width, int height, Color bgColor, ImageObserver observer) {
        int imageWidth = image.getWidth(observer);
        int imageHeight = image.getHeight(observer);
        return this.drawImage(image, x, y, x + width, y + height, 0, 0, imageWidth, imageHeight, bgColor, observer);
    }

    public boolean drawImage(Image image, int x, int y, Color bgColor, ImageObserver observer) {
        int imageWidth = image.getWidth(observer);
        int imageHeight = image.getHeight(observer);
        return this.drawImage(image, x, y, x + imageWidth, y + imageHeight, 0, 0, imageWidth, imageHeight, bgColor, observer);
    }

    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, observer);
    }

    public boolean drawImage(Image image, AffineTransform xform, ImageObserver observer) {
        this.drawRenderedImage(ImageUtilities.createRenderedImage(image, observer, null), xform);
        return true;
    }

    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.drawImage((Image)op.filter(img, null), x, y, null);
    }

    public void drawRenderableImage(RenderableImage image, AffineTransform xform) {
        this.drawRenderedImage(image.createRendering(new RenderContext(new AffineTransform(), this.getRenderingHints())), xform);
    }

    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgColor, ImageObserver observer) {
        try {
            int srcX = Math.min(sx1, sx2);
            int srcY = Math.min(sy1, sy2);
            int srcWidth = Math.abs(sx2 - sx1);
            int srcHeight = Math.abs(sy2 - sy1);
            int width = Math.abs(dx2 - dx1);
            int height = Math.abs(dy2 - dy1);
            if (srcX != 0 || srcY != 0 || srcWidth != image.getWidth(observer) || srcHeight != image.getHeight(observer)) {
                CropImageFilter crop = new CropImageFilter(srcX, srcY, srcWidth, srcHeight);
                image = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), crop));
                MediaTracker mediaTracker = new MediaTracker(new Panel());
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForAll();
                }
                catch (InterruptedException e) {
                    this.handleException(e);
                }
            }
            boolean flipHorizontal = dx2 < dx1 ^ sx2 < sx1;
            boolean flipVertical = dy2 < dy1 ^ sy2 < sy1;
            double tx = flipHorizontal ? (double)dx2 : (double)dx1;
            double ty = flipVertical ? (double)dy2 : (double)dy1;
            double sx = (double)width / (double)srcWidth;
            sx = flipHorizontal ? -1.0 * sx : sx;
            double sy = (double)height / (double)srcHeight;
            sy = flipVertical ? -1.0 * sy : sy;
            this.writeImage(ImageUtilities.createRenderedImage(image, observer, bgColor), new AffineTransform(sx, 0.0, 0.0, sy, tx, ty), bgColor);
            return true;
        }
        catch (IOException e) {
            this.handleException(e);
            return false;
        }
    }

    public void drawRenderedImage(RenderedImage image, AffineTransform xform) {
        try {
            this.writeImage(image, xform, null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected abstract void writeImage(RenderedImage var1, AffineTransform var2, Color var3) throws IOException;

    public void clearRect(double x, double y, double width, double height) {
        Paint temp = this.getPaint();
        this.setPaint(this.getBackground());
        this.fillRect(x, y, width, height);
        this.setPaint(temp);
    }

    public void drawString(String string, double x, double y) {
        if (string == null || string.equals("")) {
            return;
        }
        if (this.isProperty(TEXT_AS_SHAPES)) {
            Font font = this.getFont();
            String fontName = font.getName();
            if (fontName.equals("Symbol") || fontName.equals("ZapfDingbats")) {
                string = FontEncoder.getEncodedString(string, fontName);
                font = new Font("Serif", font.getStyle(), font.getSize());
            }
            GlyphVector gv = font.createGlyphVector(this.getFontRenderContext(), string);
            this.drawGlyphVector(gv, (float)x, (float)y);
        } else {
            try {
                this.writeString(string, x, y);
            }
            catch (IOException e) {
                this.handleException(e);
            }
        }
    }

    protected abstract void writeString(String var1, double var2, double var4) throws IOException;

    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.fill(g.getOutline(x, y));
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        if (this.isProperty(TEXT_AS_SHAPES)) {
            TextLayout tl = new TextLayout(iterator, this.getFontRenderContext());
            tl.draw(this, x, y);
        } else {
            Font font = this.getFont();
            Map<Object, Object> attributes = FontUtilities.getAttributes(font);
            StringBuffer sb = new StringBuffer();
            char c = iterator.first();
            while (c != '\uffff') {
                if (((Object)attributes).equals(iterator.getAttributes())) {
                    sb.append(c);
                } else {
                    if (sb.length() > 0) {
                        this.drawString(sb.toString(), x, y);
                        TextLayout tl = new TextLayout(sb.toString(), attributes, this.getFontRenderContext());
                        x += Math.max(tl.getAdvance(), (float)tl.getBounds().getWidth());
                    }
                    sb = new StringBuffer();
                    sb.append(c);
                    attributes = iterator.getAttributes();
                    this.setFont(new Font(attributes));
                }
                c = iterator.next();
            }
            if (sb.length() > 0) {
                this.drawString(sb.toString(), x, y);
            }
            this.setFont(font);
        }
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.currentTransform);
    }

    public void setTransform(AffineTransform transform) {
        this.oldTransform.setTransform(this.currentTransform);
        this.currentTransform.setTransform(transform);
        try {
            this.writeSetTransform(transform);
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void transform(AffineTransform transform) {
        this.currentTransform.concatenate(transform);
        try {
            this.writeTransform(transform);
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void translate(double x, double y) {
        this.currentTransform.translate(x, y);
        try {
            this.writeTransform(new AffineTransform(1.0, 0.0, 0.0, 1.0, x, y));
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void rotate(double theta) {
        this.currentTransform.rotate(theta);
        try {
            this.writeTransform(new AffineTransform(Math.cos(theta), Math.sin(theta), -Math.sin(theta), Math.cos(theta), 0.0, 0.0));
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void scale(double sx, double sy) {
        this.currentTransform.scale(sx, sy);
        try {
            this.writeTransform(new AffineTransform(sx, 0.0, 0.0, sy, 0.0, 0.0));
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void shear(double shx, double shy) {
        this.currentTransform.shear(shx, shy);
        try {
            this.writeTransform(new AffineTransform(1.0, shy, shx, 1.0, 0.0, 0.0));
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    protected abstract void writeTransform(AffineTransform var1) throws IOException;

    protected void writeSetTransform(AffineTransform transform) throws IOException {
        try {
            AffineTransform deltaTransform = new AffineTransform(transform);
            deltaTransform.concatenate(this.oldTransform.createInverse());
            this.writeTransform(deltaTransform);
        }
        catch (NoninvertibleTransformException e) {
            System.err.println("Warning: (ignored) Could not invert matrix: " + this.oldTransform);
        }
    }

    public Shape getClip() {
        return this.userClip != null ? new Area(this.untransformShape(this.userClip)) : null;
    }

    public Rectangle getClipBounds() {
        Shape clip = this.getClip();
        return clip != null ? this.getClip().getBounds() : null;
    }

    public Rectangle getClipBounds(Rectangle r) {
        Rectangle bounds = this.getClipBounds();
        if (bounds != null) {
            r.setBounds(bounds);
        }
        return r;
    }

    public void clipRect(int x, int y, int width, int height) {
        this.clip(new Rectangle(x, y, width, height));
    }

    public void clipRect(double x, double y, double width, double height) {
        this.clip(new Rectangle2D.Double(x, y, width, height));
    }

    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height));
    }

    public void setClip(double x, double y, double width, double height) {
        this.setClip(new Rectangle2D.Double(x, y, width, height));
    }

    public void setClip(Shape s) {
        Shape ts = this.transformShape(s);
        this.userClip = ts != null ? new Area(ts) : null;
        try {
            this.writeSetClip(s);
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void clip(Shape s) {
        Shape ts = this.transformShape(s);
        if (this.userClip != null) {
            if (ts != null) {
                this.userClip.intersect(new Area(ts));
            } else {
                this.userClip = null;
            }
        } else {
            this.userClip = ts != null ? new Area(ts) : null;
        }
        try {
            this.writeClip(s);
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    protected abstract void writeClip(Shape var1) throws IOException;

    protected abstract void writeSetClip(Shape var1) throws IOException;

    public Stroke getStroke() {
        return this.currentStroke;
    }

    public void setStroke(Stroke stroke) {
        if (stroke.equals(this.currentStroke)) {
            return;
        }
        try {
            this.writeStroke(stroke);
        }
        catch (IOException e) {
            this.handleException(e);
        }
        this.currentStroke = stroke;
    }

    protected void writeStroke(Stroke stroke) throws IOException {
        if (stroke instanceof BasicStroke) {
            float limit;
            int join;
            int cap;
            float width;
            BasicStroke ns = (BasicStroke)stroke;
            int currentCap = -1;
            int currentJoin = -1;
            float currentWidth = -1.0f;
            float currentLimit = -1.0f;
            float currentDashPhase = -1.0f;
            float[] currentDashArray = null;
            if (this.currentStroke != null && this.currentStroke instanceof BasicStroke) {
                BasicStroke cs = (BasicStroke)this.currentStroke;
                currentCap = cs.getEndCap();
                currentJoin = cs.getLineJoin();
                currentWidth = cs.getLineWidth();
                currentLimit = cs.getMiterLimit();
                currentDashArray = cs.getDashArray();
                currentDashPhase = cs.getDashPhase();
            }
            if (currentWidth != (width = ns.getLineWidth())) {
                this.writeWidth(width);
            }
            if (currentCap != (cap = ns.getEndCap())) {
                this.writeCap(cap);
            }
            if (currentJoin != (join = ns.getLineJoin())) {
                this.writeJoin(join);
            }
            if (currentLimit != (limit = ns.getMiterLimit()) && limit >= 1.0f) {
                this.writeMiterLimit(limit);
            }
            if (!Arrays.equals(currentDashArray, ns.getDashArray()) || currentDashPhase != ns.getDashPhase()) {
                if (ns.getDashArray() != null) {
                    this.writeDash(ns.getDashArray(), ns.getDashPhase());
                } else {
                    this.writeDash(new float[0], ns.getDashPhase());
                }
            }
        }
    }

    protected void writeWidth(float width) throws IOException {
        this.writeWarning(this.getClass() + ": writeWidth() not implemented.");
    }

    protected void writeCap(int cap) throws IOException {
        this.writeWarning(this.getClass() + ": writeCap() not implemented.");
    }

    protected void writeJoin(int join) throws IOException {
        this.writeWarning(this.getClass() + ": writeJoin() not implemented.");
    }

    protected void writeMiterLimit(float limit) throws IOException {
        this.writeWarning(this.getClass() + ": writeMiterLimit() not implemented.");
    }

    protected void writeDash(float[] dash, float phase) throws IOException {
        double[] dd = new double[dash.length];
        for (int i = 0; i < dash.length; ++i) {
            dd[i] = dash[i];
        }
        this.writeDash(dd, (double)phase);
    }

    protected void writeDash(double[] dash, double phase) throws IOException {
        this.writeWarning(this.getClass() + ": writeDash() not implemented.");
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        if (color.equals(this.getColor())) {
            return;
        }
        try {
            super.setColor(color);
            this.writePaint(this.getPrintColor(color));
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void setPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        if (paint.equals(this.getPaint())) {
            return;
        }
        try {
            if (paint instanceof Color) {
                this.setColor((Color)paint);
            } else if (paint instanceof GradientPaint) {
                super.setPaint(paint);
                this.writePaint((GradientPaint)paint);
            } else if (paint instanceof TexturePaint) {
                super.setPaint(paint);
                this.writePaint((TexturePaint)paint);
            } else {
                super.setPaint(paint);
                this.writePaint(paint);
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    protected abstract void writePaint(Color var1) throws IOException;

    protected abstract void writePaint(GradientPaint var1) throws IOException;

    protected abstract void writePaint(TexturePaint var1) throws IOException;

    protected abstract void writePaint(Paint var1) throws IOException;

    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f), true, true);
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public RenderingHints getRenderingHints() {
        return (RenderingHints)this.hints.clone();
    }

    public void addRenderingHints(Map hints) {
        hints.putAll(hints);
    }

    public void setRenderingHints(Map hints) {
        hints.clear();
        hints.putAll(hints);
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.hints.get(key);
    }

    public void setRenderingHint(RenderingHints.Key key, Object hint) {
        if (key == null || hint == null) {
            return;
        }
        this.hints.put(key, hint);
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        super.setFont(font);
        try {
            this.writeFont(font);
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    protected abstract void writeFont(Font var1) throws IOException;

    public Composite getComposite() {
        return this.currentComposite;
    }

    public void setComposite(Composite composite) {
        this.currentComposite = composite;
    }

    protected void handleException(Exception exception) {
        if (exception instanceof UnsupportedOperationException) {
            this.writeWarning(exception);
        } else {
            this.writeError(exception);
        }
    }

    protected void writeWarning(Exception exception) {
        this.writeWarning(exception.getMessage());
    }

    protected void writeWarning(String warning) {
        if (this.isProperty(EMIT_WARNINGS)) {
            System.err.println(warning);
        }
    }

    protected void writeError(Exception exception) {
        throw new RuntimeException(exception);
    }

    protected Shape createShape(double[] xPoints, double[] yPoints, int nPoints, boolean close) {
        GeneralPath path = new GeneralPath(0);
        if (nPoints > 0) {
            path.moveTo((float)xPoints[0], (float)yPoints[0]);
            for (int i = 1; i < nPoints; ++i) {
                path.lineTo((float)xPoints[i], (float)yPoints[i]);
            }
            if (close) {
                path.closePath();
            }
        }
        return path;
    }

    private Shape transformShape(AffineTransform at, Shape s) {
        if (s == null) {
            return null;
        }
        return at.createTransformedShape(s);
    }

    private Shape transformShape(Shape s) {
        return this.transformShape(this.getTransform(), s);
    }

    private Shape untransformShape(Shape s) {
        if (s == null) {
            return null;
        }
        try {
            return this.transformShape(this.getTransform().createInverse(), s);
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
    }

    protected void overLine(String text, Font font, float x, float y) {
        TextLayout layout = new TextLayout(text, font, this.getFontRenderContext());
        float width = Math.max(layout.getAdvance(), (float)layout.getBounds().getWidth());
        GeneralPath path = new GeneralPath();
        path.moveTo(x, y + (float)layout.getBounds().getY() - layout.getAscent());
        path.lineTo(x + width, y + (float)layout.getBounds().getY() - layout.getAscent() - layout.getAscent());
        this.draw(path);
    }
}

