/*
 * Decompiled with CFR 0.152.
 */
package org.sagemath.sage3d;

import java.awt.BorderLayout;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.swing.JApplet;
import javax.swing.JFrame;
import org.sagemath.sage3d.ObjectViewer;

public class ObjectViewerApplet
extends JApplet {
    protected HashMap windows = new HashMap();
    protected ObjectViewer curView;

    public void start() {
        String popup;
        this.setLayout(new BorderLayout());
        String inline = this.getParameter("inline");
        if (inline != null) {
            this.showView(inline, null);
        }
        if ((popup = this.getParameter("popup")) != null) {
            this.showView(popup, "popup");
        }
    }

    public void showView(String url, String id) {
        this.showView(url, id, url);
    }

    public void showView(URL url, String id) {
        this.showView(url, id, url.toString());
    }

    public void showView(String url, String id, String name) {
        try {
            this.showView(new URL(this.getBase(), url), id, name);
        }
        catch (MalformedURLException ex) {
            System.out.println(ex);
            this.showView((URL)null, null, null);
        }
    }

    public void showView(URL url, String id, String name) {
        ObjectViewer view = new ObjectViewer(url);
        if (id == null) {
            this.getContentPane().add(view);
            this.validate();
            this.curView = view;
        } else {
            JFrame frame = this.getWindow(id, name);
            frame.getContentPane().add(view);
            frame.setVisible(true);
        }
    }

    public URL getBase() {
        return this.getDocumentBase();
    }

    public JFrame getWindow(String id, String name) {
        JFrame frame = (JFrame)this.windows.get(id);
        if (frame == null) {
            frame = new JFrame(name);
            frame.getContentPane().setLayout(new BorderLayout());
            frame.setSize(300, 300);
        } else {
            frame.getContentPane().removeAll();
        }
        return frame;
    }
}

